"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppInstanceStreamingConfigurations = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const messagingCustomResources_1 = require("./messagingCustomResources");
class AppInstanceStreamingConfigurations extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { streamingConfigs, appInstanceArn } = props;
        const uid = cdk.Names.uniqueId(this);
        new messagingCustomResources_1.MessagingResources(this, 'AppInstanceStreamingConfiguration', {
            resourceType: 'StreamingConfig',
            uid: uid,
            properties: {
                appInstanceArn: appInstanceArn,
                streamingConfigs: streamingConfigs,
            },
        });
        this.streamingConfigs = streamingConfigs;
    }
}
exports.AppInstanceStreamingConfigurations = AppInstanceStreamingConfigurations;
_a = JSII_RTTI_SYMBOL_1;
AppInstanceStreamingConfigurations[_a] = { fqn: "cdk-amazon-chime-resources.AppInstanceStreamingConfigurations", version: "2.0.14" };
//# sourceMappingURL=data:application/json;base64,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