"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/* eslint-disable @typescript-eslint/indent */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const messaging_function_1 = require("../resources/messaging/messaging-function");
class MessagingResources extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.lambda = this.ensureLambda();
        const MessagingResourceProvider = new custom_resources_1.Provider(this, 'MessagingResourceProvider', {
            onEventHandler: this.lambda,
        });
        this.messagingCustomResource = new aws_cdk_lib_1.CustomResource(this, 'messagingCustomResource', {
            serviceToken: MessagingResourceProvider.serviceToken,
            properties: { ...props },
        });
    }
    ensureLambda() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        const constructName = 'MessagingResources';
        const existing = stack.node.tryFindChild(constructName);
        if (existing) {
            return existing;
        }
        const messagingCustomResourceRole = new aws_iam_1.Role(this, 'messagingCustomResourceRole', {
            description: 'Amazon Chime SDK Messaging Resources',
            assumedBy: new aws_iam_1.ServicePrincipal('lambda.amazonaws.com'),
            inlinePolicies: {
                ['chimePolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: ['*'],
                            actions: [
                                'chime:CreateAppInstance',
                                'chime:CreateChannelFlow',
                                'chime:DeleteChannelFlow',
                                'chime:DescribeAppInstance',
                                'chime:ListAppInstances',
                                'chime:UpdateAppInstance',
                                'chime:DeleteAppInstance',
                                'chime:CreateAppInstanceUser',
                                'chime:DeleteAppInstanceUser',
                                'chime:ListAppInstanceUsers',
                                'chime:UpdateAppInstanceUser',
                                'chime:DescribeAppInstanceUser',
                                'chime:CreateAppInstanceAdmin',
                                'chime:DescribeAppInstanceAdmin',
                                'chime:ListAppInstanceAdmins',
                                'chime:DeleteAppInstanceAdmin',
                                'chime:PutAppInstanceRetentionSettings',
                                'chime:GetAppInstanceRetentionSettings',
                                'chime:PutAppInstanceStreamingConfigurations',
                                'chime:GetAppInstanceStreamingConfigurations',
                                'chime:DeleteAppInstanceStreamingConfigurations',
                                'chime:TagResource',
                                'chime:UntagResource',
                                'chime:ListTagsForResource',
                                'lambda:GetPolicy',
                                'lambda:AddPermission',
                                'iam:PutRolePolicy',
                                'iam:CreateServiceLinkedRole',
                            ],
                        }),
                    ],
                }),
                ['kinesisPolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                `arn:aws:kinesis:${stack.region}:${stack.account}:stream/chime-messaging-*`,
                            ],
                            actions: ['kinesis:DescribeStream'],
                        }),
                    ],
                }),
                ['ssmPolicy']: new aws_iam_1.PolicyDocument({
                    statements: [
                        new aws_iam_1.PolicyStatement({
                            resources: [
                                `arn:aws:ssm:${stack.region}:${stack.account}:parameter/chime/*`,
                            ],
                            actions: [
                                'ssm:PutParameter',
                                'ssm:GetParameter',
                                'ssm:DeleteParameter',
                            ],
                        }),
                    ],
                }),
            },
            managedPolicies: [
                aws_iam_1.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole'),
            ],
        });
        const fn = new messaging_function_1.MessagingFunction(this, 'messagingResourcesFunction', {
            role: messagingCustomResourceRole,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
        });
        // const fn = new NodejsFunction(this, 'messagingResourcesFunction', {
        //   entry: 'src/resources/messaging/index.ts',
        //   handler: 'handler',
        //   runtime: Runtime.NODEJS_18_X,
        //   architecture: Architecture.ARM_64,
        //   role: messagingCustomResourceRole,
        //   timeout: Duration.seconds(60),
        // });
        return fn;
    }
}
exports.MessagingResources = MessagingResources;
_a = JSII_RTTI_SYMBOL_1;
MessagingResources[_a] = { fqn: "cdk-amazon-chime-resources.MessagingResources", version: "2.0.14" };
//# sourceMappingURL=data:application/json;base64,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