import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKMessagingClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKMessagingClient";
import { ListChannelsAssociatedWithChannelFlowRequest, ListChannelsAssociatedWithChannelFlowResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link ListChannelsAssociatedWithChannelFlowCommand}.
 */
export interface ListChannelsAssociatedWithChannelFlowCommandInput extends ListChannelsAssociatedWithChannelFlowRequest {
}
/**
 * @public
 *
 * The output of {@link ListChannelsAssociatedWithChannelFlowCommand}.
 */
export interface ListChannelsAssociatedWithChannelFlowCommandOutput extends ListChannelsAssociatedWithChannelFlowResponse, __MetadataBearer {
}
/**
 * @public
 * <p>Lists all channels associated with a specified channel flow. You can associate a channel flow with multiple channels, but you can only associate a channel with one channel flow. This is a developer API.</p>
 * @example
 * Use a bare-bones client and the command you need to make an API call.
 * ```javascript
 * import { ChimeSDKMessagingClient, ListChannelsAssociatedWithChannelFlowCommand } from "@aws-sdk/client-chime-sdk-messaging"; // ES Modules import
 * // const { ChimeSDKMessagingClient, ListChannelsAssociatedWithChannelFlowCommand } = require("@aws-sdk/client-chime-sdk-messaging"); // CommonJS import
 * const client = new ChimeSDKMessagingClient(config);
 * const command = new ListChannelsAssociatedWithChannelFlowCommand(input);
 * const response = await client.send(command);
 * ```
 *
 * @param ListChannelsAssociatedWithChannelFlowCommandInput - {@link ListChannelsAssociatedWithChannelFlowCommandInput}
 * @returns {@link ListChannelsAssociatedWithChannelFlowCommandOutput}
 * @see {@link ListChannelsAssociatedWithChannelFlowCommandInput} for command's `input` shape.
 * @see {@link ListChannelsAssociatedWithChannelFlowCommandOutput} for command's `response` shape.
 * @see {@link ChimeSDKMessagingClientResolvedConfig | config} for ChimeSDKMessagingClient's `config` shape.
 *
 * @throws {@link BadRequestException} (client fault)
 *  <p>The input parameters don't match the service's restrictions.</p>
 *
 * @throws {@link ForbiddenException} (client fault)
 *  <p>The client is permanently forbidden from making the request.</p>
 *
 * @throws {@link ServiceFailureException} (server fault)
 *  <p>The service encountered an unexpected error.</p>
 *
 * @throws {@link ServiceUnavailableException} (server fault)
 *  <p>The service is currently unavailable.</p>
 *
 * @throws {@link ThrottledClientException} (client fault)
 *  <p>The client exceeded its request rate limit.</p>
 *
 * @throws {@link UnauthorizedClientException} (client fault)
 *  <p>The client is not currently authorized to make the request.</p>
 *
 *
 */
export declare class ListChannelsAssociatedWithChannelFlowCommand extends $Command<ListChannelsAssociatedWithChannelFlowCommandInput, ListChannelsAssociatedWithChannelFlowCommandOutput, ChimeSDKMessagingClientResolvedConfig> {
    readonly input: ListChannelsAssociatedWithChannelFlowCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: ListChannelsAssociatedWithChannelFlowCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKMessagingClientResolvedConfig, options?: __HttpHandlerOptions): Handler<ListChannelsAssociatedWithChannelFlowCommandInput, ListChannelsAssociatedWithChannelFlowCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
