import { getEndpointPlugin } from "@aws-sdk/middleware-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog, DisassociatePhoneNumbersFromVoiceConnectorGroupResponseFilterSensitiveLog, } from "../models/models_0";
import { deserializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorGroupCommand, serializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorGroupCommand, } from "../protocols/Aws_restJson1";
export class DisassociatePhoneNumbersFromVoiceConnectorGroupCommand extends $Command {
    static getEndpointParameterInstructions() {
        return {
            UseFIPS: { type: "builtInParams", name: "useFipsEndpoint" },
            Endpoint: { type: "builtInParams", name: "endpoint" },
            Region: { type: "builtInParams", name: "region" },
            UseDualStack: { type: "builtInParams", name: "useDualstackEndpoint" },
        };
    }
    constructor(input) {
        super();
        this.input = input;
    }
    resolveMiddleware(clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getEndpointPlugin(configuration, DisassociatePhoneNumbersFromVoiceConnectorGroupCommand.getEndpointParameterInstructions()));
        const stack = clientStack.concat(this.middlewareStack);
        const { logger } = configuration;
        const clientName = "ChimeSDKVoiceClient";
        const commandName = "DisassociatePhoneNumbersFromVoiceConnectorGroupCommand";
        const handlerExecutionContext = {
            logger,
            clientName,
            commandName,
            inputFilterSensitiveLog: DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog,
            outputFilterSensitiveLog: DisassociatePhoneNumbersFromVoiceConnectorGroupResponseFilterSensitiveLog,
        };
        const { requestHandler } = configuration;
        return stack.resolve((request) => requestHandler.handle(request.request, options || {}), handlerExecutionContext);
    }
    serialize(input, context) {
        return serializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorGroupCommand(input, context);
    }
    deserialize(output, context) {
        return deserializeAws_restJson1DisassociatePhoneNumbersFromVoiceConnectorGroupCommand(output, context);
    }
}
