import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { GetVoiceProfileDomainRequest, GetVoiceProfileDomainResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link GetVoiceProfileDomainCommand}.
 */
export interface GetVoiceProfileDomainCommandInput extends GetVoiceProfileDomainRequest {
}
/**
 * @public
 *
 * The output of {@link GetVoiceProfileDomainCommand}.
 */
export interface GetVoiceProfileDomainCommandOutput extends GetVoiceProfileDomainResponse, __MetadataBearer {
}
export declare class GetVoiceProfileDomainCommand extends $Command<GetVoiceProfileDomainCommandInput, GetVoiceProfileDomainCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: GetVoiceProfileDomainCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: GetVoiceProfileDomainCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<GetVoiceProfileDomainCommandInput, GetVoiceProfileDomainCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
