import { EndpointParameterInstructions } from "@aws-sdk/middleware-endpoint";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { Handler, HttpHandlerOptions as __HttpHandlerOptions, MetadataBearer as __MetadataBearer, MiddlewareStack } from "@aws-sdk/types";
import { ChimeSDKVoiceClientResolvedConfig, ServiceInputTypes, ServiceOutputTypes } from "../ChimeSDKVoiceClient";
import { UpdateVoiceProfileDomainRequest, UpdateVoiceProfileDomainResponse } from "../models/models_0";
/**
 * @public
 *
 * The input for {@link UpdateVoiceProfileDomainCommand}.
 */
export interface UpdateVoiceProfileDomainCommandInput extends UpdateVoiceProfileDomainRequest {
}
/**
 * @public
 *
 * The output of {@link UpdateVoiceProfileDomainCommand}.
 */
export interface UpdateVoiceProfileDomainCommandOutput extends UpdateVoiceProfileDomainResponse, __MetadataBearer {
}
export declare class UpdateVoiceProfileDomainCommand extends $Command<UpdateVoiceProfileDomainCommandInput, UpdateVoiceProfileDomainCommandOutput, ChimeSDKVoiceClientResolvedConfig> {
    readonly input: UpdateVoiceProfileDomainCommandInput;
    static getEndpointParameterInstructions(): EndpointParameterInstructions;
    /**
     * @public
     */
    constructor(input: UpdateVoiceProfileDomainCommandInput);
    /**
     * @internal
     */
    resolveMiddleware(clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>, configuration: ChimeSDKVoiceClientResolvedConfig, options?: __HttpHandlerOptions): Handler<UpdateVoiceProfileDomainCommandInput, UpdateVoiceProfileDomainCommandOutput>;
    /**
     * @internal
     */
    private serialize;
    /**
     * @internal
     */
    private deserialize;
}
