import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { ChimeSDKVoiceServiceException as __BaseException } from "./ChimeSDKVoiceServiceException";
/**
 * @public
 */
export declare enum ErrorCode {
    AccessDenied = "AccessDenied",
    BadRequest = "BadRequest",
    Conflict = "Conflict",
    Forbidden = "Forbidden",
    Gone = "Gone",
    NotFound = "NotFound",
    PhoneNumberAssociationsExist = "PhoneNumberAssociationsExist",
    PreconditionFailed = "PreconditionFailed",
    ResourceLimitExceeded = "ResourceLimitExceeded",
    ServiceFailure = "ServiceFailure",
    ServiceUnavailable = "ServiceUnavailable",
    Throttled = "Throttled",
    Throttling = "Throttling",
    Unauthorized = "Unauthorized",
    Unprocessable = "Unprocessable",
    VoiceConnectorGroupAssociationsExist = "VoiceConnectorGroupAssociationsExist"
}
/**
 * @public
 */
export declare class AccessDeniedException extends __BaseException {
    readonly name: "AccessDeniedException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<AccessDeniedException, __BaseException>);
}
/**
 * @public
 */
export interface Address {
    streetName?: string;
    streetSuffix?: string;
    postDirectional?: string;
    preDirectional?: string;
    streetNumber?: string;
    city?: string;
    state?: string;
    postalCode?: string;
    postalCodePlus4?: string;
    country?: string;
}
/**
 * @public
 */
export declare enum AlexaSkillStatus {
    ACTIVE = "ACTIVE",
    INACTIVE = "INACTIVE"
}
/**
 * @public
 */
export interface AssociatePhoneNumbersWithVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
    E164PhoneNumbers: string[] | undefined;
    ForceAssociate?: boolean;
}
/**
 * @public
 */
export interface PhoneNumberError {
    PhoneNumberId?: string;
    ErrorCode?: ErrorCode | string;
    ErrorMessage?: string;
}
/**
 * @public
 */
export interface AssociatePhoneNumbersWithVoiceConnectorResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
/**
 * @public
 */
export declare class BadRequestException extends __BaseException {
    readonly name: "BadRequestException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<BadRequestException, __BaseException>);
}
/**
 * @public
 */
export declare class ForbiddenException extends __BaseException {
    readonly name: "ForbiddenException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ForbiddenException, __BaseException>);
}
/**
 * @public
 */
export declare class NotFoundException extends __BaseException {
    readonly name: "NotFoundException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
/**
 * @public
 */
export declare class ServiceFailureException extends __BaseException {
    readonly name: "ServiceFailureException";
    readonly $fault: "server";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ServiceFailureException, __BaseException>);
}
/**
 * @public
 */
export declare class ServiceUnavailableException extends __BaseException {
    readonly name: "ServiceUnavailableException";
    readonly $fault: "server";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ServiceUnavailableException, __BaseException>);
}
/**
 * @public
 */
export declare class ThrottledClientException extends __BaseException {
    readonly name: "ThrottledClientException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ThrottledClientException, __BaseException>);
}
/**
 * @public
 */
export declare class UnauthorizedClientException extends __BaseException {
    readonly name: "UnauthorizedClientException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<UnauthorizedClientException, __BaseException>);
}
/**
 * @public
 */
export interface AssociatePhoneNumbersWithVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
    E164PhoneNumbers: string[] | undefined;
    ForceAssociate?: boolean;
}
/**
 * @public
 */
export interface AssociatePhoneNumbersWithVoiceConnectorGroupResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
/**
 * @public
 */
export interface BatchDeletePhoneNumberRequest {
    PhoneNumberIds: string[] | undefined;
}
/**
 * @public
 */
export interface BatchDeletePhoneNumberResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
/**
 * @public
 */
export declare enum PhoneNumberProductType {
    SipMediaApplicationDialIn = "SipMediaApplicationDialIn",
    VoiceConnector = "VoiceConnector"
}
/**
 * @public
 */
export interface UpdatePhoneNumberRequestItem {
    PhoneNumberId: string | undefined;
    ProductType?: PhoneNumberProductType | string;
    CallingName?: string;
}
/**
 * @public
 */
export interface BatchUpdatePhoneNumberRequest {
    UpdatePhoneNumberRequestItems: UpdatePhoneNumberRequestItem[] | undefined;
}
/**
 * @public
 */
export interface BatchUpdatePhoneNumberResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
/**
 * @public
 */
export interface CallDetails {
    VoiceConnectorId?: string;
    TransactionId?: string;
    IsCaller?: boolean;
}
/**
 * @public
 */
export declare enum CallingNameStatus {
    Unassigned = "Unassigned",
    UpdateFailed = "UpdateFailed",
    UpdateInProgress = "UpdateInProgress",
    UpdateSucceeded = "UpdateSucceeded"
}
/**
 * @public
 */
export interface CandidateAddress {
    streetInfo?: string;
    streetNumber?: string;
    city?: string;
    state?: string;
    postalCode?: string;
    postalCodePlus4?: string;
    country?: string;
}
/**
 * @public
 */
export declare enum Capability {
    SMS = "SMS",
    Voice = "Voice"
}
/**
 * @public
 */
export interface CreatePhoneNumberOrderRequest {
    ProductType: PhoneNumberProductType | string | undefined;
    E164PhoneNumbers: string[] | undefined;
}
/**
 * @public
 */
export declare enum OrderedPhoneNumberStatus {
    Acquired = "Acquired",
    Failed = "Failed",
    Processing = "Processing"
}
/**
 * @public
 */
export interface OrderedPhoneNumber {
    E164PhoneNumber?: string;
    Status?: OrderedPhoneNumberStatus | string;
}
/**
 * @public
 */
export declare enum PhoneNumberOrderType {
    New = "New",
    Porting = "Porting"
}
/**
 * @public
 */
export declare enum PhoneNumberOrderStatus {
    CancelRequested = "CancelRequested",
    Cancelled = "Cancelled",
    ChangeRequested = "ChangeRequested",
    Exception = "Exception",
    FOC = "FOC",
    Failed = "Failed",
    Partial = "Partial",
    PendingDocuments = "PendingDocuments",
    Processing = "Processing",
    Submitted = "Submitted",
    Successful = "Successful"
}
/**
 * @public
 */
export interface PhoneNumberOrder {
    PhoneNumberOrderId?: string;
    ProductType?: PhoneNumberProductType | string;
    Status?: PhoneNumberOrderStatus | string;
    OrderType?: PhoneNumberOrderType | string;
    OrderedPhoneNumbers?: OrderedPhoneNumber[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface CreatePhoneNumberOrderResponse {
    PhoneNumberOrder?: PhoneNumberOrder;
}
/**
 * @public
 */
export declare class ResourceLimitExceededException extends __BaseException {
    readonly name: "ResourceLimitExceededException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceLimitExceededException, __BaseException>);
}
/**
 * @public
 */
export declare enum GeoMatchLevel {
    AreaCode = "AreaCode",
    Country = "Country"
}
/**
 * @public
 */
export interface GeoMatchParams {
    Country: string | undefined;
    AreaCode: string | undefined;
}
/**
 * @public
 */
export declare enum NumberSelectionBehavior {
    AvoidSticky = "AvoidSticky",
    PreferSticky = "PreferSticky"
}
/**
 * @public
 */
export interface CreateProxySessionRequest {
    VoiceConnectorId: string | undefined;
    ParticipantPhoneNumbers: string[] | undefined;
    Name?: string;
    ExpiryMinutes?: number;
    Capabilities: (Capability | string)[] | undefined;
    NumberSelectionBehavior?: NumberSelectionBehavior | string;
    GeoMatchLevel?: GeoMatchLevel | string;
    GeoMatchParams?: GeoMatchParams;
}
/**
 * @public
 */
export interface Participant {
    PhoneNumber?: string;
    ProxyPhoneNumber?: string;
}
/**
 * @public
 */
export declare enum ProxySessionStatus {
    Closed = "Closed",
    InProgress = "InProgress",
    Open = "Open"
}
/**
 * @public
 */
export interface ProxySession {
    VoiceConnectorId?: string;
    ProxySessionId?: string;
    Name?: string;
    Status?: ProxySessionStatus | string;
    ExpiryMinutes?: number;
    Capabilities?: (Capability | string)[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    EndedTimestamp?: Date;
    Participants?: Participant[];
    NumberSelectionBehavior?: NumberSelectionBehavior | string;
    GeoMatchLevel?: GeoMatchLevel | string;
    GeoMatchParams?: GeoMatchParams;
}
/**
 * @public
 */
export interface CreateProxySessionResponse {
    ProxySession?: ProxySession;
}
/**
 * @public
 */
export declare class ConflictException extends __BaseException {
    readonly name: "ConflictException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ConflictException, __BaseException>);
}
/**
 * @public
 */
export interface SipMediaApplicationEndpoint {
    LambdaArn?: string;
}
/**
 * @public
 */
export interface CreateSipMediaApplicationRequest {
    AwsRegion: string | undefined;
    Name: string | undefined;
    Endpoints: SipMediaApplicationEndpoint[] | undefined;
}
/**
 * @public
 */
export interface SipMediaApplication {
    SipMediaApplicationId?: string;
    AwsRegion?: string;
    Name?: string;
    Endpoints?: SipMediaApplicationEndpoint[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface CreateSipMediaApplicationResponse {
    SipMediaApplication?: SipMediaApplication;
}
/**
 * @public
 */
export interface CreateSipMediaApplicationCallRequest {
    FromPhoneNumber: string | undefined;
    ToPhoneNumber: string | undefined;
    SipMediaApplicationId: string | undefined;
    SipHeaders?: Record<string, string>;
    ArgumentsMap?: Record<string, string>;
}
/**
 * @public
 */
export interface SipMediaApplicationCall {
    TransactionId?: string;
}
/**
 * @public
 */
export interface CreateSipMediaApplicationCallResponse {
    SipMediaApplicationCall?: SipMediaApplicationCall;
}
/**
 * @public
 */
export interface SipRuleTargetApplication {
    SipMediaApplicationId?: string;
    Priority?: number;
    AwsRegion?: string;
}
/**
 * @public
 */
export declare enum SipRuleTriggerType {
    RequestUriHostname = "RequestUriHostname",
    ToPhoneNumber = "ToPhoneNumber"
}
/**
 * @public
 */
export interface CreateSipRuleRequest {
    Name: string | undefined;
    TriggerType: SipRuleTriggerType | string | undefined;
    TriggerValue: string | undefined;
    Disabled?: boolean;
    TargetApplications?: SipRuleTargetApplication[];
}
/**
 * @public
 */
export interface SipRule {
    SipRuleId?: string;
    Name?: string;
    Disabled?: boolean;
    TriggerType?: SipRuleTriggerType | string;
    TriggerValue?: string;
    TargetApplications?: SipRuleTargetApplication[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface CreateSipRuleResponse {
    SipRule?: SipRule;
}
/**
 * @public
 */
export declare enum VoiceConnectorAwsRegion {
    AP_NORTHEAST_1 = "ap-northeast-1",
    AP_NORTHEAST_2 = "ap-northeast-2",
    AP_SOUTHEAST_1 = "ap-southeast-1",
    AP_SOUTHEAST_2 = "ap-southeast-2",
    CA_CENTRAL_1 = "ca-central-1",
    EU_CENTRAL_1 = "eu-central-1",
    EU_WEST_1 = "eu-west-1",
    EU_WEST_2 = "eu-west-2",
    US_EAST_1 = "us-east-1",
    US_WEST_2 = "us-west-2"
}
/**
 * @public
 */
export interface CreateVoiceConnectorRequest {
    Name: string | undefined;
    AwsRegion?: VoiceConnectorAwsRegion | string;
    RequireEncryption: boolean | undefined;
}
/**
 * @public
 */
export interface VoiceConnector {
    VoiceConnectorId?: string;
    AwsRegion?: VoiceConnectorAwsRegion | string;
    Name?: string;
    OutboundHostName?: string;
    RequireEncryption?: boolean;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    VoiceConnectorArn?: string;
}
/**
 * @public
 */
export interface CreateVoiceConnectorResponse {
    VoiceConnector?: VoiceConnector;
}
/**
 * @public
 */
export interface VoiceConnectorItem {
    VoiceConnectorId: string | undefined;
    Priority: number | undefined;
}
/**
 * @public
 */
export interface CreateVoiceConnectorGroupRequest {
    Name: string | undefined;
    VoiceConnectorItems?: VoiceConnectorItem[];
}
/**
 * @public
 */
export interface VoiceConnectorGroup {
    VoiceConnectorGroupId?: string;
    Name?: string;
    VoiceConnectorItems?: VoiceConnectorItem[];
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    VoiceConnectorGroupArn?: string;
}
/**
 * @public
 */
export interface CreateVoiceConnectorGroupResponse {
    VoiceConnectorGroup?: VoiceConnectorGroup;
}
/**
 * @public
 */
export interface CreateVoiceProfileRequest {
    SpeakerSearchTaskId: string | undefined;
}
/**
 * @public
 */
export interface VoiceProfile {
    VoiceProfileId?: string;
    VoiceProfileArn?: string;
    VoiceProfileDomainId?: string;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    ExpirationTimestamp?: Date;
}
/**
 * @public
 */
export interface CreateVoiceProfileResponse {
    VoiceProfile?: VoiceProfile;
}
/**
 * @public
 */
export declare class GoneException extends __BaseException {
    readonly name: "GoneException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<GoneException, __BaseException>);
}
/**
 * @public
 */
export interface ServerSideEncryptionConfiguration {
    KmsKeyArn: string | undefined;
}
/**
 * @public
 */
export interface Tag {
    Key: string | undefined;
    Value: string | undefined;
}
/**
 * @public
 */
export interface CreateVoiceProfileDomainRequest {
    Name: string | undefined;
    Description?: string;
    ServerSideEncryptionConfiguration: ServerSideEncryptionConfiguration | undefined;
    ClientRequestToken?: string;
    Tags?: Tag[];
}
/**
 * @public
 */
export interface VoiceProfileDomain {
    VoiceProfileDomainId?: string;
    VoiceProfileDomainArn?: string;
    Name?: string;
    Description?: string;
    ServerSideEncryptionConfiguration?: ServerSideEncryptionConfiguration;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface CreateVoiceProfileDomainResponse {
    VoiceProfileDomain?: VoiceProfileDomain;
}
/**
 * @public
 */
export interface DeletePhoneNumberRequest {
    PhoneNumberId: string | undefined;
}
/**
 * @public
 */
export interface DeleteProxySessionRequest {
    VoiceConnectorId: string | undefined;
    ProxySessionId: string | undefined;
}
/**
 * @public
 */
export interface DeleteSipMediaApplicationRequest {
    SipMediaApplicationId: string | undefined;
}
/**
 * @public
 */
export interface DeleteSipRuleRequest {
    SipRuleId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceConnectorEmergencyCallingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceConnectorOriginationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceConnectorProxyRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceConnectorStreamingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceConnectorTerminationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceConnectorTerminationCredentialsRequest {
    VoiceConnectorId: string | undefined;
    Usernames: string[] | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceProfileRequest {
    VoiceProfileId: string | undefined;
}
/**
 * @public
 */
export interface DeleteVoiceProfileDomainRequest {
    VoiceProfileDomainId: string | undefined;
}
/**
 * @public
 */
export interface DisassociatePhoneNumbersFromVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
    E164PhoneNumbers: string[] | undefined;
}
/**
 * @public
 */
export interface DisassociatePhoneNumbersFromVoiceConnectorResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
/**
 * @public
 */
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
    E164PhoneNumbers: string[] | undefined;
}
/**
 * @public
 */
export interface DisassociatePhoneNumbersFromVoiceConnectorGroupResponse {
    PhoneNumberErrors?: PhoneNumberError[];
}
/**
 * @public
 */
export interface VoiceConnectorSettings {
    CdrBucket?: string;
}
/**
 * @public
 */
export interface GetGlobalSettingsResponse {
    VoiceConnector?: VoiceConnectorSettings;
}
/**
 * @public
 */
export interface GetPhoneNumberRequest {
    PhoneNumberId: string | undefined;
}
/**
 * @public
 */
export declare enum PhoneNumberAssociationName {
    SipRuleId = "SipRuleId",
    VoiceConnectorGroupId = "VoiceConnectorGroupId",
    VoiceConnectorId = "VoiceConnectorId"
}
/**
 * @public
 */
export interface PhoneNumberAssociation {
    Value?: string;
    Name?: PhoneNumberAssociationName | string;
    AssociatedTimestamp?: Date;
}
/**
 * @public
 */
export interface PhoneNumberCapabilities {
    InboundCall?: boolean;
    OutboundCall?: boolean;
    InboundSMS?: boolean;
    OutboundSMS?: boolean;
    InboundMMS?: boolean;
    OutboundMMS?: boolean;
}
/**
 * @public
 */
export declare enum PhoneNumberStatus {
    AcquireFailed = "AcquireFailed",
    AcquireInProgress = "AcquireInProgress",
    Assigned = "Assigned",
    Cancelled = "Cancelled",
    DeleteFailed = "DeleteFailed",
    DeleteInProgress = "DeleteInProgress",
    PortinCancelRequested = "PortinCancelRequested",
    PortinInProgress = "PortinInProgress",
    ReleaseFailed = "ReleaseFailed",
    ReleaseInProgress = "ReleaseInProgress",
    Unassigned = "Unassigned"
}
/**
 * @public
 */
export declare enum PhoneNumberType {
    Local = "Local",
    TollFree = "TollFree"
}
/**
 * @public
 */
export interface PhoneNumber {
    PhoneNumberId?: string;
    E164PhoneNumber?: string;
    Country?: string;
    Type?: PhoneNumberType | string;
    ProductType?: PhoneNumberProductType | string;
    Status?: PhoneNumberStatus | string;
    Capabilities?: PhoneNumberCapabilities;
    Associations?: PhoneNumberAssociation[];
    CallingName?: string;
    CallingNameStatus?: CallingNameStatus | string;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    DeletionTimestamp?: Date;
    OrderId?: string;
}
/**
 * @public
 */
export interface GetPhoneNumberResponse {
    PhoneNumber?: PhoneNumber;
}
/**
 * @public
 */
export interface GetPhoneNumberOrderRequest {
    PhoneNumberOrderId: string | undefined;
}
/**
 * @public
 */
export interface GetPhoneNumberOrderResponse {
    PhoneNumberOrder?: PhoneNumberOrder;
}
/**
 * @public
 */
export interface GetPhoneNumberSettingsResponse {
    CallingName?: string;
    CallingNameUpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface GetProxySessionRequest {
    VoiceConnectorId: string | undefined;
    ProxySessionId: string | undefined;
}
/**
 * @public
 */
export interface GetProxySessionResponse {
    ProxySession?: ProxySession;
}
/**
 * @public
 */
export interface GetSipMediaApplicationRequest {
    SipMediaApplicationId: string | undefined;
}
/**
 * @public
 */
export interface GetSipMediaApplicationResponse {
    SipMediaApplication?: SipMediaApplication;
}
/**
 * @public
 */
export interface GetSipMediaApplicationAlexaSkillConfigurationRequest {
    SipMediaApplicationId: string | undefined;
}
/**
 * @public
 */
export interface SipMediaApplicationAlexaSkillConfiguration {
    AlexaSkillStatus: AlexaSkillStatus | string | undefined;
    AlexaSkillIds: string[] | undefined;
}
/**
 * @public
 */
export interface GetSipMediaApplicationAlexaSkillConfigurationResponse {
    SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
/**
 * @public
 */
export interface GetSipMediaApplicationLoggingConfigurationRequest {
    SipMediaApplicationId: string | undefined;
}
/**
 * @public
 */
export interface SipMediaApplicationLoggingConfiguration {
    EnableSipMediaApplicationMessageLogs?: boolean;
}
/**
 * @public
 */
export interface GetSipMediaApplicationLoggingConfigurationResponse {
    SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
/**
 * @public
 */
export interface GetSipRuleRequest {
    SipRuleId: string | undefined;
}
/**
 * @public
 */
export interface GetSipRuleResponse {
    SipRule?: SipRule;
}
/**
 * @public
 */
export interface GetSpeakerSearchTaskRequest {
    VoiceConnectorId: string | undefined;
    SpeakerSearchTaskId: string | undefined;
}
/**
 * @public
 */
export interface SpeakerSearchResult {
    ConfidenceScore?: number;
    VoiceProfileId?: string;
}
/**
 * @public
 */
export interface SpeakerSearchDetails {
    Results?: SpeakerSearchResult[];
    VoiceprintGenerationStatus?: string;
}
/**
 * @public
 */
export interface SpeakerSearchTask {
    SpeakerSearchTaskId?: string;
    SpeakerSearchTaskStatus?: string;
    CallDetails?: CallDetails;
    SpeakerSearchDetails?: SpeakerSearchDetails;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    StartedTimestamp?: Date;
    StatusMessage?: string;
}
/**
 * @public
 */
export interface GetSpeakerSearchTaskResponse {
    SpeakerSearchTask?: SpeakerSearchTask;
}
/**
 * @public
 */
export interface GetVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface GetVoiceConnectorResponse {
    VoiceConnector?: VoiceConnector;
}
/**
 * @public
 */
export interface GetVoiceConnectorEmergencyCallingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface DNISEmergencyCallingConfiguration {
    EmergencyPhoneNumber: string | undefined;
    TestPhoneNumber?: string;
    CallingCountry: string | undefined;
}
/**
 * @public
 */
export interface EmergencyCallingConfiguration {
    DNIS?: DNISEmergencyCallingConfiguration[];
}
/**
 * @public
 */
export interface GetVoiceConnectorEmergencyCallingConfigurationResponse {
    EmergencyCallingConfiguration?: EmergencyCallingConfiguration;
}
/**
 * @public
 */
export interface GetVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
}
/**
 * @public
 */
export interface GetVoiceConnectorGroupResponse {
    VoiceConnectorGroup?: VoiceConnectorGroup;
}
/**
 * @public
 */
export interface GetVoiceConnectorLoggingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface LoggingConfiguration {
    EnableSIPLogs?: boolean;
    EnableMediaMetricLogs?: boolean;
}
/**
 * @public
 */
export interface GetVoiceConnectorLoggingConfigurationResponse {
    LoggingConfiguration?: LoggingConfiguration;
}
/**
 * @public
 */
export interface GetVoiceConnectorOriginationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export declare enum OriginationRouteProtocol {
    TCP = "TCP",
    UDP = "UDP"
}
/**
 * @public
 */
export interface OriginationRoute {
    Host?: string;
    Port?: number;
    Protocol?: OriginationRouteProtocol | string;
    Priority?: number;
    Weight?: number;
}
/**
 * @public
 */
export interface Origination {
    Routes?: OriginationRoute[];
    Disabled?: boolean;
}
/**
 * @public
 */
export interface GetVoiceConnectorOriginationResponse {
    Origination?: Origination;
}
/**
 * @public
 */
export interface GetVoiceConnectorProxyRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface Proxy {
    DefaultSessionExpiryMinutes?: number;
    Disabled?: boolean;
    FallBackPhoneNumber?: string;
    PhoneNumberCountries?: string[];
}
/**
 * @public
 */
export interface GetVoiceConnectorProxyResponse {
    Proxy?: Proxy;
}
/**
 * @public
 */
export interface GetVoiceConnectorStreamingConfigurationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface MediaInsightsConfiguration {
    Disabled?: boolean;
    ConfigurationArn?: string;
}
/**
 * @public
 */
export declare enum NotificationTarget {
    EventBridge = "EventBridge",
    SNS = "SNS",
    SQS = "SQS"
}
/**
 * @public
 */
export interface StreamingNotificationTarget {
    NotificationTarget?: NotificationTarget | string;
}
/**
 * @public
 */
export interface StreamingConfiguration {
    DataRetentionInHours: number | undefined;
    Disabled: boolean | undefined;
    StreamingNotificationTargets?: StreamingNotificationTarget[];
    MediaInsightsConfiguration?: MediaInsightsConfiguration;
}
/**
 * @public
 */
export interface GetVoiceConnectorStreamingConfigurationResponse {
    StreamingConfiguration?: StreamingConfiguration;
}
/**
 * @public
 */
export interface GetVoiceConnectorTerminationRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface Termination {
    CpsLimit?: number;
    DefaultPhoneNumber?: string;
    CallingRegions?: string[];
    CidrAllowedList?: string[];
    Disabled?: boolean;
}
/**
 * @public
 */
export interface GetVoiceConnectorTerminationResponse {
    Termination?: Termination;
}
/**
 * @public
 */
export interface GetVoiceConnectorTerminationHealthRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface TerminationHealth {
    Timestamp?: Date;
    Source?: string;
}
/**
 * @public
 */
export interface GetVoiceConnectorTerminationHealthResponse {
    TerminationHealth?: TerminationHealth;
}
/**
 * @public
 */
export interface GetVoiceProfileRequest {
    VoiceProfileId: string | undefined;
}
/**
 * @public
 */
export interface GetVoiceProfileResponse {
    VoiceProfile?: VoiceProfile;
}
/**
 * @public
 */
export interface GetVoiceProfileDomainRequest {
    VoiceProfileDomainId: string | undefined;
}
/**
 * @public
 */
export interface GetVoiceProfileDomainResponse {
    VoiceProfileDomain?: VoiceProfileDomain;
}
/**
 * @public
 */
export interface GetVoiceToneAnalysisTaskRequest {
    VoiceConnectorId: string | undefined;
    VoiceToneAnalysisTaskId: string | undefined;
    IsCaller: boolean | undefined;
}
/**
 * @public
 */
export interface VoiceToneAnalysisTask {
    VoiceToneAnalysisTaskId?: string;
    VoiceToneAnalysisTaskStatus?: string;
    CallDetails?: CallDetails;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    StartedTimestamp?: Date;
    StatusMessage?: string;
}
/**
 * @public
 */
export interface GetVoiceToneAnalysisTaskResponse {
    VoiceToneAnalysisTask?: VoiceToneAnalysisTask;
}
/**
 * @public
 */
export interface ListAvailableVoiceConnectorRegionsResponse {
    VoiceConnectorRegions?: (VoiceConnectorAwsRegion | string)[];
}
/**
 * @public
 */
export interface ListPhoneNumberOrdersRequest {
    NextToken?: string;
    MaxResults?: number;
}
/**
 * @public
 */
export interface ListPhoneNumberOrdersResponse {
    PhoneNumberOrders?: PhoneNumberOrder[];
    NextToken?: string;
}
/**
 * @public
 */
export interface ListPhoneNumbersRequest {
    Status?: string;
    ProductType?: PhoneNumberProductType | string;
    FilterName?: PhoneNumberAssociationName | string;
    FilterValue?: string;
    MaxResults?: number;
    NextToken?: string;
}
/**
 * @public
 */
export interface ListPhoneNumbersResponse {
    PhoneNumbers?: PhoneNumber[];
    NextToken?: string;
}
/**
 * @public
 */
export interface ListProxySessionsRequest {
    VoiceConnectorId: string | undefined;
    Status?: ProxySessionStatus | string;
    NextToken?: string;
    MaxResults?: number;
}
/**
 * @public
 */
export interface ListProxySessionsResponse {
    ProxySessions?: ProxySession[];
    NextToken?: string;
}
/**
 * @public
 */
export interface ListSipMediaApplicationsRequest {
    MaxResults?: number;
    NextToken?: string;
}
/**
 * @public
 */
export interface ListSipMediaApplicationsResponse {
    SipMediaApplications?: SipMediaApplication[];
    NextToken?: string;
}
/**
 * @public
 */
export interface ListSipRulesRequest {
    SipMediaApplicationId?: string;
    MaxResults?: number;
    NextToken?: string;
}
/**
 * @public
 */
export interface ListSipRulesResponse {
    SipRules?: SipRule[];
    NextToken?: string;
}
/**
 * @public
 */
export interface ListSupportedPhoneNumberCountriesRequest {
    ProductType: PhoneNumberProductType | string | undefined;
}
/**
 * @public
 */
export interface PhoneNumberCountry {
    CountryCode?: string;
    SupportedPhoneNumberTypes?: (PhoneNumberType | string)[];
}
/**
 * @public
 */
export interface ListSupportedPhoneNumberCountriesResponse {
    PhoneNumberCountries?: PhoneNumberCountry[];
}
/**
 * @public
 */
export interface ListTagsForResourceRequest {
    ResourceARN: string | undefined;
}
/**
 * @public
 */
export interface ListTagsForResourceResponse {
    Tags?: Tag[];
}
/**
 * @public
 */
export interface ListVoiceConnectorGroupsRequest {
    NextToken?: string;
    MaxResults?: number;
}
/**
 * @public
 */
export interface ListVoiceConnectorGroupsResponse {
    VoiceConnectorGroups?: VoiceConnectorGroup[];
    NextToken?: string;
}
/**
 * @public
 */
export interface ListVoiceConnectorsRequest {
    NextToken?: string;
    MaxResults?: number;
}
/**
 * @public
 */
export interface ListVoiceConnectorsResponse {
    VoiceConnectors?: VoiceConnector[];
    NextToken?: string;
}
/**
 * @public
 */
export interface ListVoiceConnectorTerminationCredentialsRequest {
    VoiceConnectorId: string | undefined;
}
/**
 * @public
 */
export interface ListVoiceConnectorTerminationCredentialsResponse {
    Usernames?: string[];
}
/**
 * @public
 */
export interface ListVoiceProfileDomainsRequest {
    NextToken?: string;
    MaxResults?: number;
}
/**
 * @public
 */
export interface VoiceProfileDomainSummary {
    VoiceProfileDomainId?: string;
    VoiceProfileDomainArn?: string;
    Name?: string;
    Description?: string;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
}
/**
 * @public
 */
export interface ListVoiceProfileDomainsResponse {
    VoiceProfileDomains?: VoiceProfileDomainSummary[];
    NextToken?: string;
}
/**
 * @public
 */
export interface ListVoiceProfilesRequest {
    VoiceProfileDomainId: string | undefined;
    NextToken?: string;
    MaxResults?: number;
}
/**
 * @public
 */
export interface VoiceProfileSummary {
    VoiceProfileId?: string;
    VoiceProfileArn?: string;
    VoiceProfileDomainId?: string;
    CreatedTimestamp?: Date;
    UpdatedTimestamp?: Date;
    ExpirationTimestamp?: Date;
}
/**
 * @public
 */
export interface ListVoiceProfilesResponse {
    VoiceProfiles?: VoiceProfileSummary[];
    NextToken?: string;
}
/**
 * @public
 */
export interface PutSipMediaApplicationAlexaSkillConfigurationRequest {
    SipMediaApplicationId: string | undefined;
    SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
/**
 * @public
 */
export interface PutSipMediaApplicationAlexaSkillConfigurationResponse {
    SipMediaApplicationAlexaSkillConfiguration?: SipMediaApplicationAlexaSkillConfiguration;
}
/**
 * @public
 */
export interface PutSipMediaApplicationLoggingConfigurationRequest {
    SipMediaApplicationId: string | undefined;
    SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
/**
 * @public
 */
export interface PutSipMediaApplicationLoggingConfigurationResponse {
    SipMediaApplicationLoggingConfiguration?: SipMediaApplicationLoggingConfiguration;
}
/**
 * @public
 */
export interface PutVoiceConnectorEmergencyCallingConfigurationRequest {
    VoiceConnectorId: string | undefined;
    EmergencyCallingConfiguration: EmergencyCallingConfiguration | undefined;
}
/**
 * @public
 */
export interface PutVoiceConnectorEmergencyCallingConfigurationResponse {
    EmergencyCallingConfiguration?: EmergencyCallingConfiguration;
}
/**
 * @public
 */
export interface PutVoiceConnectorLoggingConfigurationRequest {
    VoiceConnectorId: string | undefined;
    LoggingConfiguration: LoggingConfiguration | undefined;
}
/**
 * @public
 */
export interface PutVoiceConnectorLoggingConfigurationResponse {
    LoggingConfiguration?: LoggingConfiguration;
}
/**
 * @public
 */
export interface PutVoiceConnectorOriginationRequest {
    VoiceConnectorId: string | undefined;
    Origination: Origination | undefined;
}
/**
 * @public
 */
export interface PutVoiceConnectorOriginationResponse {
    Origination?: Origination;
}
/**
 * @public
 */
export interface PutVoiceConnectorProxyRequest {
    VoiceConnectorId: string | undefined;
    DefaultSessionExpiryMinutes: number | undefined;
    PhoneNumberPoolCountries: string[] | undefined;
    FallBackPhoneNumber?: string;
    Disabled?: boolean;
}
/**
 * @public
 */
export interface PutVoiceConnectorProxyResponse {
    Proxy?: Proxy;
}
/**
 * @public
 */
export interface PutVoiceConnectorStreamingConfigurationRequest {
    VoiceConnectorId: string | undefined;
    StreamingConfiguration: StreamingConfiguration | undefined;
}
/**
 * @public
 */
export interface PutVoiceConnectorStreamingConfigurationResponse {
    StreamingConfiguration?: StreamingConfiguration;
}
/**
 * @public
 */
export interface PutVoiceConnectorTerminationRequest {
    VoiceConnectorId: string | undefined;
    Termination: Termination | undefined;
}
/**
 * @public
 */
export interface PutVoiceConnectorTerminationResponse {
    Termination?: Termination;
}
/**
 * @public
 */
export interface Credential {
    Username?: string;
    Password?: string;
}
/**
 * @public
 */
export interface PutVoiceConnectorTerminationCredentialsRequest {
    VoiceConnectorId: string | undefined;
    Credentials?: Credential[];
}
/**
 * @public
 */
export interface RestorePhoneNumberRequest {
    PhoneNumberId: string | undefined;
}
/**
 * @public
 */
export interface RestorePhoneNumberResponse {
    PhoneNumber?: PhoneNumber;
}
/**
 * @public
 */
export interface SearchAvailablePhoneNumbersRequest {
    AreaCode?: string;
    City?: string;
    Country?: string;
    State?: string;
    TollFreePrefix?: string;
    PhoneNumberType?: PhoneNumberType | string;
    MaxResults?: number;
    NextToken?: string;
}
/**
 * @public
 */
export interface SearchAvailablePhoneNumbersResponse {
    E164PhoneNumbers?: string[];
    NextToken?: string;
}
/**
 * @public
 */
export interface StartSpeakerSearchTaskRequest {
    VoiceConnectorId: string | undefined;
    TransactionId: string | undefined;
    VoiceProfileDomainId: string | undefined;
    ClientRequestToken?: string;
}
/**
 * @public
 */
export interface StartSpeakerSearchTaskResponse {
    SpeakerSearchTask?: SpeakerSearchTask;
}
/**
 * @public
 */
export declare class UnprocessableEntityException extends __BaseException {
    readonly name: "UnprocessableEntityException";
    readonly $fault: "client";
    Code?: ErrorCode | string;
    Message?: string;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<UnprocessableEntityException, __BaseException>);
}
/**
 * @public
 */
export declare enum LanguageCode {
    EN_US = "en-US"
}
/**
 * @public
 */
export interface StartVoiceToneAnalysisTaskRequest {
    VoiceConnectorId: string | undefined;
    TransactionId: string | undefined;
    LanguageCode: LanguageCode | string | undefined;
    ClientRequestToken?: string;
}
/**
 * @public
 */
export interface StartVoiceToneAnalysisTaskResponse {
    VoiceToneAnalysisTask?: VoiceToneAnalysisTask;
}
/**
 * @public
 */
export interface StopSpeakerSearchTaskRequest {
    VoiceConnectorId: string | undefined;
    SpeakerSearchTaskId: string | undefined;
}
/**
 * @public
 */
export interface StopVoiceToneAnalysisTaskRequest {
    VoiceConnectorId: string | undefined;
    VoiceToneAnalysisTaskId: string | undefined;
}
/**
 * @public
 */
export interface TagResourceRequest {
    ResourceARN: string | undefined;
    Tags: Tag[] | undefined;
}
/**
 * @public
 */
export interface UntagResourceRequest {
    ResourceARN: string | undefined;
    TagKeys: string[] | undefined;
}
/**
 * @public
 */
export interface UpdateGlobalSettingsRequest {
    VoiceConnector?: VoiceConnectorSettings;
}
/**
 * @public
 */
export interface UpdatePhoneNumberRequest {
    PhoneNumberId: string | undefined;
    ProductType?: PhoneNumberProductType | string;
    CallingName?: string;
}
/**
 * @public
 */
export interface UpdatePhoneNumberResponse {
    PhoneNumber?: PhoneNumber;
}
/**
 * @public
 */
export interface UpdatePhoneNumberSettingsRequest {
    CallingName: string | undefined;
}
/**
 * @public
 */
export interface UpdateProxySessionRequest {
    VoiceConnectorId: string | undefined;
    ProxySessionId: string | undefined;
    Capabilities: (Capability | string)[] | undefined;
    ExpiryMinutes?: number;
}
/**
 * @public
 */
export interface UpdateProxySessionResponse {
    ProxySession?: ProxySession;
}
/**
 * @public
 */
export interface UpdateSipMediaApplicationRequest {
    SipMediaApplicationId: string | undefined;
    Name?: string;
    Endpoints?: SipMediaApplicationEndpoint[];
}
/**
 * @public
 */
export interface UpdateSipMediaApplicationResponse {
    SipMediaApplication?: SipMediaApplication;
}
/**
 * @public
 */
export interface UpdateSipMediaApplicationCallRequest {
    SipMediaApplicationId: string | undefined;
    TransactionId: string | undefined;
    Arguments: Record<string, string> | undefined;
}
/**
 * @public
 */
export interface UpdateSipMediaApplicationCallResponse {
    SipMediaApplicationCall?: SipMediaApplicationCall;
}
/**
 * @public
 */
export interface UpdateSipRuleRequest {
    SipRuleId: string | undefined;
    Name: string | undefined;
    Disabled?: boolean;
    TargetApplications?: SipRuleTargetApplication[];
}
/**
 * @public
 */
export interface UpdateSipRuleResponse {
    SipRule?: SipRule;
}
/**
 * @public
 */
export interface UpdateVoiceConnectorRequest {
    VoiceConnectorId: string | undefined;
    Name: string | undefined;
    RequireEncryption: boolean | undefined;
}
/**
 * @public
 */
export interface UpdateVoiceConnectorResponse {
    VoiceConnector?: VoiceConnector;
}
/**
 * @public
 */
export interface UpdateVoiceConnectorGroupRequest {
    VoiceConnectorGroupId: string | undefined;
    Name: string | undefined;
    VoiceConnectorItems: VoiceConnectorItem[] | undefined;
}
/**
 * @public
 */
export interface UpdateVoiceConnectorGroupResponse {
    VoiceConnectorGroup?: VoiceConnectorGroup;
}
/**
 * @public
 */
export interface UpdateVoiceProfileRequest {
    VoiceProfileId: string | undefined;
    SpeakerSearchTaskId: string | undefined;
}
/**
 * @public
 */
export interface UpdateVoiceProfileResponse {
    VoiceProfile?: VoiceProfile;
}
/**
 * @public
 */
export interface UpdateVoiceProfileDomainRequest {
    VoiceProfileDomainId: string | undefined;
    Name?: string;
    Description?: string;
}
/**
 * @public
 */
export interface UpdateVoiceProfileDomainResponse {
    VoiceProfileDomain?: VoiceProfileDomain;
}
/**
 * @public
 */
export interface ValidateE911AddressRequest {
    AwsAccountId: string | undefined;
    StreetNumber: string | undefined;
    StreetInfo: string | undefined;
    City: string | undefined;
    State: string | undefined;
    Country: string | undefined;
    PostalCode: string | undefined;
}
/**
 * @public
 */
export interface ValidateE911AddressResponse {
    ValidationResult?: number;
    AddressExternalId?: string;
    Address?: Address;
    CandidateAddressList?: CandidateAddress[];
}
/**
 * @internal
 */
export declare const AddressFilterSensitiveLog: (obj: Address) => any;
/**
 * @internal
 */
export declare const AssociatePhoneNumbersWithVoiceConnectorRequestFilterSensitiveLog: (obj: AssociatePhoneNumbersWithVoiceConnectorRequest) => any;
/**
 * @internal
 */
export declare const PhoneNumberErrorFilterSensitiveLog: (obj: PhoneNumberError) => any;
/**
 * @internal
 */
export declare const AssociatePhoneNumbersWithVoiceConnectorResponseFilterSensitiveLog: (obj: AssociatePhoneNumbersWithVoiceConnectorResponse) => any;
/**
 * @internal
 */
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupRequestFilterSensitiveLog: (obj: AssociatePhoneNumbersWithVoiceConnectorGroupRequest) => any;
/**
 * @internal
 */
export declare const AssociatePhoneNumbersWithVoiceConnectorGroupResponseFilterSensitiveLog: (obj: AssociatePhoneNumbersWithVoiceConnectorGroupResponse) => any;
/**
 * @internal
 */
export declare const BatchDeletePhoneNumberResponseFilterSensitiveLog: (obj: BatchDeletePhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const UpdatePhoneNumberRequestItemFilterSensitiveLog: (obj: UpdatePhoneNumberRequestItem) => any;
/**
 * @internal
 */
export declare const BatchUpdatePhoneNumberRequestFilterSensitiveLog: (obj: BatchUpdatePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const BatchUpdatePhoneNumberResponseFilterSensitiveLog: (obj: BatchUpdatePhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const CandidateAddressFilterSensitiveLog: (obj: CandidateAddress) => any;
/**
 * @internal
 */
export declare const CreatePhoneNumberOrderRequestFilterSensitiveLog: (obj: CreatePhoneNumberOrderRequest) => any;
/**
 * @internal
 */
export declare const OrderedPhoneNumberFilterSensitiveLog: (obj: OrderedPhoneNumber) => any;
/**
 * @internal
 */
export declare const PhoneNumberOrderFilterSensitiveLog: (obj: PhoneNumberOrder) => any;
/**
 * @internal
 */
export declare const CreatePhoneNumberOrderResponseFilterSensitiveLog: (obj: CreatePhoneNumberOrderResponse) => any;
/**
 * @internal
 */
export declare const CreateProxySessionRequestFilterSensitiveLog: (obj: CreateProxySessionRequest) => any;
/**
 * @internal
 */
export declare const ParticipantFilterSensitiveLog: (obj: Participant) => any;
/**
 * @internal
 */
export declare const ProxySessionFilterSensitiveLog: (obj: ProxySession) => any;
/**
 * @internal
 */
export declare const CreateProxySessionResponseFilterSensitiveLog: (obj: CreateProxySessionResponse) => any;
/**
 * @internal
 */
export declare const SipMediaApplicationEndpointFilterSensitiveLog: (obj: SipMediaApplicationEndpoint) => any;
/**
 * @internal
 */
export declare const CreateSipMediaApplicationRequestFilterSensitiveLog: (obj: CreateSipMediaApplicationRequest) => any;
/**
 * @internal
 */
export declare const SipMediaApplicationFilterSensitiveLog: (obj: SipMediaApplication) => any;
/**
 * @internal
 */
export declare const CreateSipMediaApplicationResponseFilterSensitiveLog: (obj: CreateSipMediaApplicationResponse) => any;
/**
 * @internal
 */
export declare const CreateSipMediaApplicationCallRequestFilterSensitiveLog: (obj: CreateSipMediaApplicationCallRequest) => any;
/**
 * @internal
 */
export declare const VoiceProfileFilterSensitiveLog: (obj: VoiceProfile) => any;
/**
 * @internal
 */
export declare const CreateVoiceProfileResponseFilterSensitiveLog: (obj: CreateVoiceProfileResponse) => any;
/**
 * @internal
 */
export declare const ServerSideEncryptionConfigurationFilterSensitiveLog: (obj: ServerSideEncryptionConfiguration) => any;
/**
 * @internal
 */
export declare const TagFilterSensitiveLog: (obj: Tag) => any;
/**
 * @internal
 */
export declare const CreateVoiceProfileDomainRequestFilterSensitiveLog: (obj: CreateVoiceProfileDomainRequest) => any;
/**
 * @internal
 */
export declare const VoiceProfileDomainFilterSensitiveLog: (obj: VoiceProfileDomain) => any;
/**
 * @internal
 */
export declare const CreateVoiceProfileDomainResponseFilterSensitiveLog: (obj: CreateVoiceProfileDomainResponse) => any;
/**
 * @internal
 */
export declare const DeletePhoneNumberRequestFilterSensitiveLog: (obj: DeletePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const DeleteVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (obj: DeleteVoiceConnectorTerminationCredentialsRequest) => any;
/**
 * @internal
 */
export declare const DisassociatePhoneNumbersFromVoiceConnectorRequestFilterSensitiveLog: (obj: DisassociatePhoneNumbersFromVoiceConnectorRequest) => any;
/**
 * @internal
 */
export declare const DisassociatePhoneNumbersFromVoiceConnectorResponseFilterSensitiveLog: (obj: DisassociatePhoneNumbersFromVoiceConnectorResponse) => any;
/**
 * @internal
 */
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupRequestFilterSensitiveLog: (obj: DisassociatePhoneNumbersFromVoiceConnectorGroupRequest) => any;
/**
 * @internal
 */
export declare const DisassociatePhoneNumbersFromVoiceConnectorGroupResponseFilterSensitiveLog: (obj: DisassociatePhoneNumbersFromVoiceConnectorGroupResponse) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberRequestFilterSensitiveLog: (obj: GetPhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const PhoneNumberFilterSensitiveLog: (obj: PhoneNumber) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberResponseFilterSensitiveLog: (obj: GetPhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberOrderResponseFilterSensitiveLog: (obj: GetPhoneNumberOrderResponse) => any;
/**
 * @internal
 */
export declare const GetPhoneNumberSettingsResponseFilterSensitiveLog: (obj: GetPhoneNumberSettingsResponse) => any;
/**
 * @internal
 */
export declare const GetProxySessionResponseFilterSensitiveLog: (obj: GetProxySessionResponse) => any;
/**
 * @internal
 */
export declare const GetSipMediaApplicationResponseFilterSensitiveLog: (obj: GetSipMediaApplicationResponse) => any;
/**
 * @internal
 */
export declare const SipMediaApplicationAlexaSkillConfigurationFilterSensitiveLog: (obj: SipMediaApplicationAlexaSkillConfiguration) => any;
/**
 * @internal
 */
export declare const GetSipMediaApplicationAlexaSkillConfigurationResponseFilterSensitiveLog: (obj: GetSipMediaApplicationAlexaSkillConfigurationResponse) => any;
/**
 * @internal
 */
export declare const DNISEmergencyCallingConfigurationFilterSensitiveLog: (obj: DNISEmergencyCallingConfiguration) => any;
/**
 * @internal
 */
export declare const EmergencyCallingConfigurationFilterSensitiveLog: (obj: EmergencyCallingConfiguration) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog: (obj: GetVoiceConnectorEmergencyCallingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const ProxyFilterSensitiveLog: (obj: Proxy) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorProxyResponseFilterSensitiveLog: (obj: GetVoiceConnectorProxyResponse) => any;
/**
 * @internal
 */
export declare const MediaInsightsConfigurationFilterSensitiveLog: (obj: MediaInsightsConfiguration) => any;
/**
 * @internal
 */
export declare const StreamingConfigurationFilterSensitiveLog: (obj: StreamingConfiguration) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorStreamingConfigurationResponseFilterSensitiveLog: (obj: GetVoiceConnectorStreamingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const TerminationFilterSensitiveLog: (obj: Termination) => any;
/**
 * @internal
 */
export declare const GetVoiceConnectorTerminationResponseFilterSensitiveLog: (obj: GetVoiceConnectorTerminationResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceProfileResponseFilterSensitiveLog: (obj: GetVoiceProfileResponse) => any;
/**
 * @internal
 */
export declare const GetVoiceProfileDomainResponseFilterSensitiveLog: (obj: GetVoiceProfileDomainResponse) => any;
/**
 * @internal
 */
export declare const ListPhoneNumberOrdersResponseFilterSensitiveLog: (obj: ListPhoneNumberOrdersResponse) => any;
/**
 * @internal
 */
export declare const ListPhoneNumbersResponseFilterSensitiveLog: (obj: ListPhoneNumbersResponse) => any;
/**
 * @internal
 */
export declare const ListProxySessionsResponseFilterSensitiveLog: (obj: ListProxySessionsResponse) => any;
/**
 * @internal
 */
export declare const ListSipMediaApplicationsResponseFilterSensitiveLog: (obj: ListSipMediaApplicationsResponse) => any;
/**
 * @internal
 */
export declare const ListTagsForResourceRequestFilterSensitiveLog: (obj: ListTagsForResourceRequest) => any;
/**
 * @internal
 */
export declare const ListTagsForResourceResponseFilterSensitiveLog: (obj: ListTagsForResourceResponse) => any;
/**
 * @internal
 */
export declare const ListVoiceConnectorTerminationCredentialsResponseFilterSensitiveLog: (obj: ListVoiceConnectorTerminationCredentialsResponse) => any;
/**
 * @internal
 */
export declare const VoiceProfileDomainSummaryFilterSensitiveLog: (obj: VoiceProfileDomainSummary) => any;
/**
 * @internal
 */
export declare const ListVoiceProfileDomainsResponseFilterSensitiveLog: (obj: ListVoiceProfileDomainsResponse) => any;
/**
 * @internal
 */
export declare const VoiceProfileSummaryFilterSensitiveLog: (obj: VoiceProfileSummary) => any;
/**
 * @internal
 */
export declare const ListVoiceProfilesResponseFilterSensitiveLog: (obj: ListVoiceProfilesResponse) => any;
/**
 * @internal
 */
export declare const PutSipMediaApplicationAlexaSkillConfigurationRequestFilterSensitiveLog: (obj: PutSipMediaApplicationAlexaSkillConfigurationRequest) => any;
/**
 * @internal
 */
export declare const PutSipMediaApplicationAlexaSkillConfigurationResponseFilterSensitiveLog: (obj: PutSipMediaApplicationAlexaSkillConfigurationResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorEmergencyCallingConfigurationRequestFilterSensitiveLog: (obj: PutVoiceConnectorEmergencyCallingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorEmergencyCallingConfigurationResponseFilterSensitiveLog: (obj: PutVoiceConnectorEmergencyCallingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorProxyRequestFilterSensitiveLog: (obj: PutVoiceConnectorProxyRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorProxyResponseFilterSensitiveLog: (obj: PutVoiceConnectorProxyResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorStreamingConfigurationRequestFilterSensitiveLog: (obj: PutVoiceConnectorStreamingConfigurationRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorStreamingConfigurationResponseFilterSensitiveLog: (obj: PutVoiceConnectorStreamingConfigurationResponse) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorTerminationRequestFilterSensitiveLog: (obj: PutVoiceConnectorTerminationRequest) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorTerminationResponseFilterSensitiveLog: (obj: PutVoiceConnectorTerminationResponse) => any;
/**
 * @internal
 */
export declare const CredentialFilterSensitiveLog: (obj: Credential) => any;
/**
 * @internal
 */
export declare const PutVoiceConnectorTerminationCredentialsRequestFilterSensitiveLog: (obj: PutVoiceConnectorTerminationCredentialsRequest) => any;
/**
 * @internal
 */
export declare const RestorePhoneNumberRequestFilterSensitiveLog: (obj: RestorePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const RestorePhoneNumberResponseFilterSensitiveLog: (obj: RestorePhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const SearchAvailablePhoneNumbersResponseFilterSensitiveLog: (obj: SearchAvailablePhoneNumbersResponse) => any;
/**
 * @internal
 */
export declare const TagResourceRequestFilterSensitiveLog: (obj: TagResourceRequest) => any;
/**
 * @internal
 */
export declare const UntagResourceRequestFilterSensitiveLog: (obj: UntagResourceRequest) => any;
/**
 * @internal
 */
export declare const UpdatePhoneNumberRequestFilterSensitiveLog: (obj: UpdatePhoneNumberRequest) => any;
/**
 * @internal
 */
export declare const UpdatePhoneNumberResponseFilterSensitiveLog: (obj: UpdatePhoneNumberResponse) => any;
/**
 * @internal
 */
export declare const UpdatePhoneNumberSettingsRequestFilterSensitiveLog: (obj: UpdatePhoneNumberSettingsRequest) => any;
/**
 * @internal
 */
export declare const UpdateProxySessionResponseFilterSensitiveLog: (obj: UpdateProxySessionResponse) => any;
/**
 * @internal
 */
export declare const UpdateSipMediaApplicationRequestFilterSensitiveLog: (obj: UpdateSipMediaApplicationRequest) => any;
/**
 * @internal
 */
export declare const UpdateSipMediaApplicationResponseFilterSensitiveLog: (obj: UpdateSipMediaApplicationResponse) => any;
/**
 * @internal
 */
export declare const UpdateSipMediaApplicationCallRequestFilterSensitiveLog: (obj: UpdateSipMediaApplicationCallRequest) => any;
/**
 * @internal
 */
export declare const UpdateVoiceProfileResponseFilterSensitiveLog: (obj: UpdateVoiceProfileResponse) => any;
/**
 * @internal
 */
export declare const UpdateVoiceProfileDomainResponseFilterSensitiveLog: (obj: UpdateVoiceProfileDomainResponse) => any;
/**
 * @internal
 */
export declare const ValidateE911AddressRequestFilterSensitiveLog: (obj: ValidateE911AddressRequest) => any;
/**
 * @internal
 */
export declare const ValidateE911AddressResponseFilterSensitiveLog: (obj: ValidateE911AddressResponse) => any;
