import { ChimeClient } from "../ChimeClient";
import { ListMeetingsCommand, } from "../commands/ListMeetingsCommand";
const makePagedClientRequest = async (client, input, ...args) => {
    return await client.send(new ListMeetingsCommand(input), ...args);
};
export async function* paginateListMeetings(config, input, ...additionalArguments) {
    let token = config.startingToken || undefined;
    let hasNext = true;
    let page;
    while (hasNext) {
        input.NextToken = token;
        input["MaxResults"] = config.pageSize;
        if (config.client instanceof ChimeClient) {
            page = await makePagedClientRequest(config.client, input, ...additionalArguments);
        }
        else {
            throw new Error("Invalid client, expected Chime | ChimeClient");
        }
        yield page;
        const prevToken = token;
        token = page.NextToken;
        hasNext = !!(token && (!config.stopOnSameToken || token !== prevToken));
    }
    return undefined;
}
