"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveEndpointConfig = void 0;
const util_middleware_1 = require("@aws-sdk/util-middleware");
const toEndpointV1_1 = require("./adaptors/toEndpointV1");
const resolveEndpointConfig = (input) => {
    var _a, _b, _c;
    const tls = (_a = input.tls) !== null && _a !== void 0 ? _a : true;
    const { endpoint } = input;
    const customEndpointProvider = endpoint != null ? async () => (0, toEndpointV1_1.toEndpointV1)(await (0, util_middleware_1.normalizeProvider)(endpoint)()) : undefined;
    const isCustomEndpoint = !!endpoint;
    return {
        ...input,
        endpoint: customEndpointProvider,
        tls,
        isCustomEndpoint,
        useDualstackEndpoint: (0, util_middleware_1.normalizeProvider)((_b = input.useDualstackEndpoint) !== null && _b !== void 0 ? _b : false),
        useFipsEndpoint: (0, util_middleware_1.normalizeProvider)((_c = input.useFipsEndpoint) !== null && _c !== void 0 ? _c : false),
    };
};
exports.resolveEndpointConfig = resolveEndpointConfig;
