import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface CompliantDynamoDbProps {
    /**
     * @stability stable
     */
    readonly partitionKey?: dynamodb.Attribute;
    /**
     * @stability stable
     */
    readonly billingMode?: dynamodb.BillingMode;
    /**
     * @stability stable
     */
    readonly tableName?: string;
    /**
     * @stability stable
     */
    readonly backupVaultName?: string;
}
/**
 * @stability stable
 * @description creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery
 * enabled by default.
 */
export declare class CompliantDynamoDb extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly dynamodbTable: dynamodb.Table;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: CompliantDynamoDbProps);
}
