"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliantDynamoDb = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const backup = require("@aws-cdk/aws-backup");
const dynamodb = require("@aws-cdk/aws-dynamodb");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 * @description creates a DynamoDB table that is secured by an AWS backup plan und with point in time recovery
 * enabled by default.
 */
class CompliantDynamoDb extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b, _c;
        super(scope, id);
        this.dynamodbTable = new dynamodb.Table(this, 'DynamoDBTable', {
            tableName: props.tableName,
            billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
            partitionKey: (_b = props.partitionKey) !== null && _b !== void 0 ? _b : {
                name: 'id',
                type: dynamodb.AttributeType.STRING,
            },
            pointInTimeRecovery: true,
            encryption: dynamodb.TableEncryption.AWS_MANAGED,
        });
        const backupPlan = backup.BackupPlan.daily35DayRetention(this, 'BackupPlan', new backup.BackupVault(this, 'BackupVault', {
            backupVaultName: (_c = props.backupVaultName) !== null && _c !== void 0 ? _c : `${props.tableName}-backup-vault`,
            blockRecoveryPointDeletion: true,
        }));
        backupPlan.addSelection('DynamoDB', {
            resources: [backup.BackupResource.fromDynamoDbTable(this.dynamodbTable)],
        });
    }
}
exports.CompliantDynamoDb = CompliantDynamoDb;
_a = JSII_RTTI_SYMBOL_1;
CompliantDynamoDb[_a] = { fqn: "compliantdynamodb.CompliantDynamoDb", version: "0.0.10" };
//# sourceMappingURL=data:application/json;base64,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