"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pipeline = exports.PipelineProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const mps_generated_1 = require("./mps.generated");
Object.defineProperty(exports, "PipelineProperty", { enumerable: true, get: function () { return mps_generated_1.RosPipeline; } });
/**
 * A ROS resource type:  `ALIYUN::MPS::Pipeline`
 */
class Pipeline extends ros.Resource {
    /**
     * Create a new `ALIYUN::MPS::Pipeline`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPipeline = new mps_generated_1.RosPipeline(this, id, {
            role: props.role,
            speed: props.speed,
            speedLevel: props.speedLevel,
            state: props.state,
            notifyConfig: props.notifyConfig,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPipeline;
        this.attrPipelineId = rosPipeline.attrPipelineId;
    }
}
exports.Pipeline = Pipeline;
//# sourceMappingURL=data:application/json;base64,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