from setuptools import setup

with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name="naas-drivers",
    version="0.0.6",
    author="Martin Donadieu",
    author_email="martindonadieu@gmail.com",
    description="drivers made to easy connect to any services",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/jupyter-naas/drivers",
    packages=["naas_drivers"],
    tests_require=[
        "pytest==5.2",
        "pytest-sanic==1.6.1",
        "requests-mock==1.8.0",
        "twine==3.2.0",
        "flake8==3.1.1",
        "black==20.8b1",
    ],
    install_requires=[
        "vaderSentiment==3.2.1",
        "chardet==3.0.4",
        "Cython==0.29.15",
        "idna==2.9",
        "inflection==0.3.1",
        "joblib==0.14.1",
        "more-itertools==8.2.0",
        "numpy==1.18.1",
        "pandas==1.0.1",
        "patsy==0.5.1",
        "pmdarima==1.5.3",
        "python-dateutil==2.8.1",
        "python-dotenv==0.12.0",
        "pytz==2020.1",
        "plotly==4.10.0" "Quandl==3.5.0",
        "requests==2.23.0",
        "scikit-learn==0.22.2",
        "scipy==1.4.1",
        "six==1.14.0",
        "statsmodels==0.11.1",
        "urllib3==1.25.8",
        "xlrd==1.2.0",
        "pymongo==3.10.1",
        "pysftp==0.2.9",
        "md2pdf==0.4",
        "sendgrid==6.2.0",
        "escapism==1.0.0",
        "openpyxl==3.0.3",
        "google-api-python-client==1.8.0",
        "google-auth-httplib2==0.0.3",
        "google-auth-oauthlib==0.4.1",
        "gspread==3.6.0",
        "oauth2client==4.1.3",
        "geopy==1.21.0",
        "GitPython==3.1.1",
        "cson==0.8",
        "opencv-python==4.2.0.34",
        "pytesseract==0.3.4",
    ],
    classifiers=[
        "Programming Language :: Python :: 3.6",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
)
