# ory-keto-client
Ory Keto is a cloud native access control server providing best-practice patterns (RBAC, ABAC, ACL, AWS IAM Policies, Kubernetes Roles, ...) via REST APIs.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v0.7.0-alpha.1
- Package version: v0.7.0-alpha.1
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://www.ory.sh](https://www.ory.sh)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/ory/sdk.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/ory/sdk.git`)

Then import the package:
```python
import ory_keto_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import ory_keto_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import ory_keto_client
from pprint import pprint
from ory_keto_client.api import health_api
from ory_keto_client.model.health_not_ready_status import HealthNotReadyStatus
from ory_keto_client.model.health_status import HealthStatus
from ory_keto_client.model.inline_response400 import InlineResponse400
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = ory_keto_client.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with ory_keto_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = health_api.HealthApi(api_client)
    
    try:
        # Check alive status
        api_response = api_instance.is_instance_alive()
        pprint(api_response)
    except ory_keto_client.ApiException as e:
        print("Exception when calling HealthApi->is_instance_alive: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*HealthApi* | [**is_instance_alive**](docs/HealthApi.md#is_instance_alive) | **GET** /health/alive | Check alive status
*HealthApi* | [**is_instance_ready**](docs/HealthApi.md#is_instance_ready) | **GET** /health/ready | Check readiness status
*ReadApi* | [**get_check**](docs/ReadApi.md#get_check) | **GET** /check | Check a relation tuple
*ReadApi* | [**get_expand**](docs/ReadApi.md#get_expand) | **GET** /expand | Expand a Relation Tuple
*ReadApi* | [**get_relation_tuples**](docs/ReadApi.md#get_relation_tuples) | **GET** /relation-tuples | Query relation tuples
*ReadApi* | [**post_check**](docs/ReadApi.md#post_check) | **POST** /check | Check a relation tuple
*VersionApi* | [**get_version**](docs/VersionApi.md#get_version) | **GET** /version | Get service version
*WriteApi* | [**create_relation_tuple**](docs/WriteApi.md#create_relation_tuple) | **PUT** /relation-tuples | Create a Relation Tuple
*WriteApi* | [**delete_relation_tuple**](docs/WriteApi.md#delete_relation_tuple) | **DELETE** /relation-tuples | Delete a Relation Tuple
*WriteApi* | [**patch_relation_tuples**](docs/WriteApi.md#patch_relation_tuples) | **PATCH** /relation-tuples | Patch Multiple Relation Tuples


## Documentation For Models

 - [ExpandTree](docs/ExpandTree.md)
 - [GetCheckResponse](docs/GetCheckResponse.md)
 - [GetRelationTuplesResponse](docs/GetRelationTuplesResponse.md)
 - [HealthNotReadyStatus](docs/HealthNotReadyStatus.md)
 - [HealthStatus](docs/HealthStatus.md)
 - [InlineResponse400](docs/InlineResponse400.md)
 - [InternalRelationTuple](docs/InternalRelationTuple.md)
 - [PatchDelta](docs/PatchDelta.md)
 - [RelationQuery](docs/RelationQuery.md)
 - [SubjectSet](docs/SubjectSet.md)
 - [Version](docs/Version.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author

hi@ory.sh


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in ory_keto_client.apis and ory_keto_client.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from ory_keto_client.api.default_api import DefaultApi`
- `from ory_keto_client.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import ory_keto_client
from ory_keto_client.apis import *
from ory_keto_client.models import *
```

