# Talk2Scholars

**Talk2Scholars** is an AI-powered hierarchical agent system designed to revolutionize academic paper search and analysis. Through intelligent conversation, users can discover, analyze, and receive recommendations for academic papers using state-of-the-art natural language processing.

## ![Talk2Scholars](../assets/t2scholars_diagram.png)

### Why Talk2Scholars?

Academic literature search can be overwhelming, with millions of papers published yearly across diverse fields. **Talk2Scholars** transforms this experience by offering an intelligent, conversation-driven approach to academic research. Our system acts as a knowledgeable research assistant that understands context and provides targeted recommendations.

At its core, Talk2Scholars uses a sophisticated hierarchical agent architecture. The main supervisor agent intelligently routes queries to specialized sub-agents, ensuring that each request is handled by the most appropriate tool. Currently, our Semantic Scholar integration provides access to academic literature, which we plan to expand in the future.

### Key Capabilities

The system excels at understanding natural language queries and translating them into precise academic searches. When you find interesting papers, Talk2Scholars can analyze them to discover related research, either based on a single paper or by finding connections between multiple papers. This helps researchers uncover hidden connections in literature and stay current with relevant publications.

We are in the process integrating [Zotero](https://www.zotero.org/) to enable researchers to better organize their literature searchers, get automated recommendations based on categories of papers, and cite saved papers when asking questions about one or more saved papers or generating text based on a starting prompt.

### How to Access Talk2Scholars

Our system is available through two main interfaces:

**Streamlit Application**: Launch our user-friendly web interface to interact with the system directly. Perfect for researchers who prefer a graphical interface and interactive experience.

**Python Package**: For programmers and those requiring programmatic access, our Python package provides full access to all features. Integration is straightforward, and our comprehensive documentation includes examples and best practices.

### Future Developments

Talk2Scholars is actively evolving. Our roadmap includes integration with additional academic databases, enhanced PDF analysis capabilities, and improved cross-reference features. We're committed to making academic literature more accessible and easier to navigate for researchers at all levels.

## Coming Soon..
