# mypy: ignore-errors

# generated by datamodel-codegen:
#   filename:  https://schemas.getdbt.com/dbt/manifest/v7.json
#   timestamp: 2022-11-10T12:44:29+00:00

from __future__ import annotations

from datetime import datetime
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, Extra, Field, constr
from typing_extensions import Literal


class ManifestMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    dbt_schema_version: Optional[
        str
    ] = 'https://schemas.getdbt.com/dbt/manifest/v7.json'
    dbt_version: Optional[str] = '1.3.0b2'
    generated_at: Optional[datetime] = '2022-10-05T17:41:25.798224Z'
    invocation_id: Optional[Optional[str]] = '020388aa-c5cf-4e92-9391-497c583ddc54'
    env: Optional[Dict[str, str]] = {}
    project_id: Optional[Optional[str]] = Field(
        None, description='A unique identifier for the project'
    )
    user_id: Optional[
        Optional[
            constr(
                regex=r'[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}'
            )
        ]
    ] = Field(None, description='A unique identifier for the user')
    send_anonymous_usage_stats: Optional[Optional[bool]] = Field(
        None, description='Whether dbt is configured to send anonymous usage statistics'
    )
    adapter_type: Optional[Optional[str]] = Field(
        None, description='The type name of the adapter'
    )


class FileHash(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    checksum: str


class Hook(BaseModel):
    class Config:
        extra = Extra.forbid

    sql: str
    transaction: Optional[bool] = True
    index: Optional[Optional[int]] = None


class Docs(BaseModel):
    class Config:
        extra = Extra.forbid

    show: Optional[bool] = True
    node_color: Optional[Optional[str]] = None


class DependsOn(BaseModel):
    class Config:
        extra = Extra.forbid

    macros: Optional[List[str]] = []
    nodes: Optional[List[str]] = []


class ColumnInfo(BaseModel):
    class Config:
        extra = Extra.allow

    name: str
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    data_type: Optional[Optional[str]] = None
    quote: Optional[Optional[bool]] = None
    tags: Optional[List[str]] = []


class InjectedCTE(BaseModel):
    class Config:
        extra = Extra.forbid

    id: str
    sql: str


class TestConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True
    alias: Optional[Optional[str]] = None
    schema_: Optional[Optional[str]] = Field('dbt_test__audit', alias='schema')
    database: Optional[Optional[str]] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'test'
    severity: Optional[
        constr(regex=r'^([Ww][Aa][Rr][Nn]|[Ee][Rr][Rr][Oo][Rr])$')
    ] = 'ERROR'
    store_failures: Optional[Optional[bool]] = None
    where: Optional[Optional[str]] = None
    limit: Optional[Optional[int]] = None
    fail_calc: Optional[str] = 'count(*)'
    warn_if: Optional[str] = '!= 0'
    error_if: Optional[str] = '!= 0'


class TestMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    kwargs: Optional[Dict[str, Any]] = {}
    namespace: Optional[Optional[str]] = None


class SeedConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True
    alias: Optional[Optional[str]] = None
    schema_: Optional[Optional[str]] = Field(None, alias='schema')
    database: Optional[Optional[str]] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'seed'
    incremental_strategy: Optional[Optional[str]] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[Optional[bool]] = None
    unique_key: Optional[Optional[Union[str, List[str]]]] = None
    on_schema_change: Optional[Optional[str]] = 'ignore'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    quote_columns: Optional[Optional[bool]] = None


class ParsedSingularTestNode(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['test']
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = {
        'enabled': True,
        'alias': None,
        'schema': 'dbt_test__audit',
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'test',
        'severity': 'ERROR',
        'store_failures': None,
        'where': None,
        'limit': None,
        'fail_calc': 'count(*)',
        'warn_if': '!= 0',
        'error_if': '!= 0',
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.81637
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedGenericTestNode(BaseModel):
    class Config:
        extra = Extra.forbid

    test_metadata: TestMetadata
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['test']
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = {
        'enabled': True,
        'alias': None,
        'schema': 'dbt_test__audit',
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'test',
        'severity': 'ERROR',
        'store_failures': None,
        'where': None,
        'limit': None,
        'fail_calc': 'count(*)',
        'warn_if': '!= 0',
        'error_if': '!= 0',
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.821276
    config_call_dict: Optional[Dict[str, Any]] = {}
    column_name: Optional[Optional[str]] = None
    file_key_name: Optional[Optional[str]] = None


class ParsedSeedNode(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['seed']
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'seed',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'quote_columns': None,
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.822274
    config_call_dict: Optional[Dict[str, Any]] = {}


class SnapshotConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True
    alias: Optional[Optional[str]] = None
    schema_: Optional[Optional[str]] = Field(None, alias='schema')
    database: Optional[Optional[str]] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'snapshot'
    incremental_strategy: Optional[Optional[str]] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[Optional[bool]] = None
    unique_key: Optional[Optional[str]] = None
    on_schema_change: Optional[Optional[str]] = 'ignore'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    strategy: Optional[Optional[str]] = None
    target_schema: Optional[Optional[str]] = None
    target_database: Optional[Optional[str]] = None
    updated_at: Optional[Optional[str]] = None
    check_cols: Optional[Optional[Union[str, List[str]]]] = None


class Quoting(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[bool]] = None
    schema_: Optional[Optional[bool]] = Field(None, alias='schema')
    identifier: Optional[Optional[bool]] = None
    column: Optional[Optional[bool]] = None


class FreshnessMetadata(BaseModel):
    class Config:
        extra = Extra.forbid

    dbt_schema_version: Optional[str] = 'https://schemas.getdbt.com/dbt/sources/v3.json'
    dbt_version: Optional[str] = '1.3.0b2'
    generated_at: Optional[datetime] = '2022-10-05T17:41:25.794018Z'
    invocation_id: Optional[Optional[str]] = '020388aa-c5cf-4e92-9391-497c583ddc54'
    env: Optional[Dict[str, str]] = {}


class SourceFreshnessRuntimeError(BaseModel):
    class Config:
        extra = Extra.forbid

    unique_id: str
    error: Optional[Optional[Union[str, int]]] = None
    status: Literal['runtime error']


class Time(BaseModel):
    class Config:
        extra = Extra.forbid

    count: Optional[Optional[int]] = None
    period: Optional[Optional[Literal['minute', 'hour', 'day']]] = None


class TimingInfo(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    started_at: Optional[Optional[datetime]] = None
    completed_at: Optional[Optional[datetime]] = None


class ExternalPartition(BaseModel):
    class Config:
        extra = Extra.allow

    name: Optional[str] = ''
    description: Optional[str] = ''
    data_type: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}


class SourceConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True


class MacroDependsOn(BaseModel):
    class Config:
        extra = Extra.forbid

    macros: Optional[List[str]] = []


class MacroArgument(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    type: Optional[Optional[str]] = None
    description: Optional[str] = ''


class ParsedDocumentation(BaseModel):
    class Config:
        extra = Extra.forbid

    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    block_contents: str


class ExposureOwner(BaseModel):
    class Config:
        extra = Extra.forbid

    email: str
    name: Optional[Optional[str]] = None


class ExposureConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True


class MetricFilter(BaseModel):
    class Config:
        extra = Extra.forbid

    field: str
    operator: str
    value: str


class MetricTime(BaseModel):
    class Config:
        extra = Extra.forbid

    count: Optional[Optional[int]] = None
    period: Optional[Optional[Literal['day', 'week', 'month', 'year']]] = None


class MetricConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True


class NodeConfig(BaseModel):
    class Config:
        extra = Extra.allow

    enabled: Optional[bool] = True
    alias: Optional[Optional[str]] = None
    schema_: Optional[Optional[str]] = Field(None, alias='schema')
    database: Optional[Optional[str]] = None
    tags: Optional[Union[List[str], str]] = []
    meta: Optional[Dict[str, Any]] = {}
    materialized: Optional[str] = 'view'
    incremental_strategy: Optional[Optional[str]] = None
    persist_docs: Optional[Dict[str, Any]] = {}
    post_hook: Optional[List[Hook]] = Field([], alias='post-hook')
    pre_hook: Optional[List[Hook]] = Field([], alias='pre-hook')
    quoting: Optional[Dict[str, Any]] = {}
    column_types: Optional[Dict[str, Any]] = {}
    full_refresh: Optional[Optional[bool]] = None
    unique_key: Optional[Optional[Union[str, List[str]]]] = None
    on_schema_change: Optional[Optional[str]] = 'ignore'
    grants: Optional[Dict[str, Any]] = {}
    packages: Optional[List[str]] = []
    docs: Optional[Docs] = {'show': True, 'node_color': None}


class CompiledSingularTestNode(BaseModel):
    class Config:
        extra = Extra.forbid

    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['test']
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = {
        'enabled': True,
        'alias': None,
        'schema': 'dbt_test__audit',
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'test',
        'severity': 'ERROR',
        'store_failures': None,
        'where': None,
        'limit': None,
        'fail_calc': 'count(*)',
        'warn_if': '!= 0',
        'error_if': '!= 0',
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.803982
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledModelNode(BaseModel):
    class Config:
        extra = Extra.forbid

    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['model']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.806056
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledHookNode(BaseModel):
    class Config:
        extra = Extra.forbid

    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['operation']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.807287
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None
    index: Optional[Optional[int]] = None


class CompiledRPCNode(BaseModel):
    class Config:
        extra = Extra.forbid

    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['rpc']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.808457
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledSqlNode(BaseModel):
    class Config:
        extra = Extra.forbid

    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['sql operation']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.8095949
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledGenericTestNode(BaseModel):
    class Config:
        extra = Extra.forbid

    test_metadata: TestMetadata
    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['test']
    alias: str
    checksum: FileHash
    config: Optional[TestConfig] = {
        'enabled': True,
        'alias': None,
        'schema': 'dbt_test__audit',
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'test',
        'severity': 'ERROR',
        'store_failures': None,
        'where': None,
        'limit': None,
        'fail_calc': 'count(*)',
        'warn_if': '!= 0',
        'error_if': '!= 0',
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.81105
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None
    column_name: Optional[Optional[str]] = None
    file_key_name: Optional[Optional[str]] = None


class CompiledSeedNode(BaseModel):
    class Config:
        extra = Extra.forbid

    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['seed']
    alias: str
    checksum: FileHash
    config: Optional[SeedConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'seed',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'quote_columns': None,
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.813088
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class CompiledSnapshotNode(BaseModel):
    class Config:
        extra = Extra.forbid

    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['snapshot']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.814346
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class ParsedAnalysisNode(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['analysis']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.8153868
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedHookNode(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['operation']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.817323
    config_call_dict: Optional[Dict[str, Any]] = {}
    index: Optional[Optional[int]] = None


class ParsedModelNode(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['model']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.8182888
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedRPCNode(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['rpc']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.819205
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedSqlNode(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['sql operation']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.8202639
    config_call_dict: Optional[Dict[str, Any]] = {}


class ParsedSnapshotNode(BaseModel):
    class Config:
        extra = Extra.forbid

    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['snapshot']
    alias: str
    checksum: FileHash
    config: SnapshotConfig
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.8241339
    config_call_dict: Optional[Dict[str, Any]] = {}


class FreshnessThreshold(BaseModel):
    class Config:
        extra = Extra.forbid

    warn_after: Optional[Optional[Time]] = {'count': None, 'period': None}
    error_after: Optional[Optional[Time]] = {'count': None, 'period': None}
    filter: Optional[Optional[str]] = None


class SourceFreshnessOutput(BaseModel):
    class Config:
        extra = Extra.forbid

    unique_id: str
    max_loaded_at: datetime
    snapshotted_at: datetime
    max_loaded_at_time_ago_in_s: float
    status: Literal['pass', 'warn', 'error', 'runtime error']
    criteria: FreshnessThreshold
    adapter_response: Dict[str, Any]
    timing: List[TimingInfo]
    thread_id: str
    execution_time: float


class ExternalTable(BaseModel):
    class Config:
        extra = Extra.allow

    location: Optional[Optional[str]] = None
    file_format: Optional[Optional[str]] = None
    row_format: Optional[Optional[str]] = None
    tbl_properties: Optional[Optional[str]] = None
    partitions: Optional[Optional[List[ExternalPartition]]] = None


class ParsedMacro(BaseModel):
    class Config:
        extra = Extra.forbid

    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    macro_sql: str
    resource_type: Literal['macro']
    tags: Optional[List[str]] = []
    depends_on: Optional[MacroDependsOn] = {'macros': []}
    description: Optional[str] = ''
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    arguments: Optional[List[MacroArgument]] = []
    created_at: Optional[float] = 1664991685.8266501
    supported_languages: Optional[Optional[List[Literal['python', 'sql']]]] = None


class ParsedExposure(BaseModel):
    class Config:
        extra = Extra.forbid

    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    type: Literal['dashboard', 'notebook', 'analysis', 'ml', 'application']
    owner: ExposureOwner
    resource_type: Optional[
        Literal[
            'model',
            'analysis',
            'test',
            'snapshot',
            'operation',
            'seed',
            'rpc',
            'sql operation',
            'docs block',
            'source',
            'macro',
            'exposure',
            'metric',
        ]
    ] = 'exposure'
    description: Optional[str] = ''
    label: Optional[Optional[str]] = None
    maturity: Optional[Optional[Literal['low', 'medium', 'high']]] = None
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[ExposureConfig] = {'enabled': True}
    unrendered_config: Optional[Dict[str, Any]] = {}
    url: Optional[Optional[str]] = None
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    created_at: Optional[float] = 1664991685.828064


class ParsedMetric(BaseModel):
    class Config:
        extra = Extra.forbid

    fqn: List[str]
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    description: str
    label: str
    calculation_method: str
    expression: str
    timestamp: str
    filters: List[MetricFilter]
    time_grains: List[str]
    dimensions: List[str]
    window: Optional[Optional[MetricTime]] = None
    model: Optional[Optional[str]] = None
    model_unique_id: Optional[Optional[str]] = None
    resource_type: Optional[
        Literal[
            'model',
            'analysis',
            'test',
            'snapshot',
            'operation',
            'seed',
            'rpc',
            'sql operation',
            'docs block',
            'source',
            'macro',
            'exposure',
            'metric',
        ]
    ] = 'metric'
    meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[MetricConfig] = {'enabled': True}
    unrendered_config: Optional[Dict[str, Any]] = {}
    sources: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    refs: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    created_at: Optional[float] = 1664991685.8293078


class CompiledAnalysisNode(BaseModel):
    class Config:
        extra = Extra.forbid

    compiled: bool
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    fqn: List[str]
    unique_id: str
    raw_code: str
    language: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    resource_type: Literal['analysis']
    alias: str
    checksum: FileHash
    config: Optional[NodeConfig] = {
        'enabled': True,
        'alias': None,
        'schema': None,
        'database': None,
        'tags': [],
        'meta': {},
        'materialized': 'view',
        'incremental_strategy': None,
        'persist_docs': {},
        'quoting': {},
        'column_types': {},
        'full_refresh': None,
        'unique_key': None,
        'on_schema_change': 'ignore',
        'grants': {},
        'packages': [],
        'docs': {'show': True, 'node_color': None},
        'post-hook': [],
        'pre-hook': [],
    }
    tags: Optional[List[str]] = []
    refs: Optional[List[List[str]]] = []
    sources: Optional[List[List[str]]] = []
    metrics: Optional[List[List[str]]] = []
    depends_on: Optional[DependsOn] = {'macros': [], 'nodes': []}
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    docs: Optional[Docs] = {'show': True, 'node_color': None}
    patch_path: Optional[Optional[str]] = None
    compiled_path: Optional[Optional[str]] = None
    build_path: Optional[Optional[str]] = None
    deferred: Optional[bool] = False
    unrendered_config: Optional[Dict[str, Any]] = {}
    created_at: Optional[float] = 1664991685.801986
    config_call_dict: Optional[Dict[str, Any]] = {}
    compiled_code: Optional[Optional[str]] = None
    extra_ctes_injected: Optional[bool] = False
    extra_ctes: Optional[List[InjectedCTE]] = []
    relation_name: Optional[Optional[str]] = None


class ParsedSourceDefinition(BaseModel):
    class Config:
        extra = Extra.forbid

    fqn: List[str]
    database: Optional[Optional[str]] = None
    schema_: str = Field(..., alias='schema')
    unique_id: str
    package_name: str
    root_path: str
    path: str
    original_file_path: str
    name: str
    source_name: str
    source_description: str
    loader: str
    identifier: str
    resource_type: Literal['source']
    quoting: Optional[Quoting] = {
        'database': None,
        'schema': None,
        'identifier': None,
        'column': None,
    }
    loaded_at_field: Optional[Optional[str]] = None
    freshness: Optional[Optional[FreshnessThreshold]] = None
    external: Optional[Optional[ExternalTable]] = None
    description: Optional[str] = ''
    columns: Optional[Dict[str, ColumnInfo]] = {}
    meta: Optional[Dict[str, Any]] = {}
    source_meta: Optional[Dict[str, Any]] = {}
    tags: Optional[List[str]] = []
    config: Optional[SourceConfig] = {'enabled': True}
    patch_path: Optional[Optional[str]] = None
    unrendered_config: Optional[Dict[str, Any]] = {}
    relation_name: Optional[Optional[str]] = None
    created_at: Optional[float] = 1664991685.825852


class DbtManifest(BaseModel):
    class Config:
        extra = Extra.forbid

    metadata: ManifestMetadata = Field(..., description='Metadata about the manifest')
    nodes: Dict[
        str,
        Union[
            CompiledAnalysisNode,
            CompiledSingularTestNode,
            CompiledModelNode,
            CompiledHookNode,
            CompiledRPCNode,
            CompiledSqlNode,
            CompiledGenericTestNode,
            CompiledSeedNode,
            CompiledSnapshotNode,
            ParsedAnalysisNode,
            ParsedSingularTestNode,
            ParsedHookNode,
            ParsedModelNode,
            ParsedRPCNode,
            ParsedSqlNode,
            ParsedGenericTestNode,
            ParsedSeedNode,
            ParsedSnapshotNode,
        ],
    ] = Field(
        ..., description='The nodes defined in the dbt project and its dependencies'
    )
    sources: Dict[str, ParsedSourceDefinition] = Field(
        ..., description='The sources defined in the dbt project and its dependencies'
    )
    macros: Dict[str, ParsedMacro] = Field(
        ..., description='The macros defined in the dbt project and its dependencies'
    )
    docs: Dict[str, ParsedDocumentation] = Field(
        ..., description='The docs defined in the dbt project and its dependencies'
    )
    exposures: Dict[str, ParsedExposure] = Field(
        ..., description='The exposures defined in the dbt project and its dependencies'
    )
    metrics: Dict[str, ParsedMetric] = Field(
        ..., description='The metrics defined in the dbt project and its dependencies'
    )
    selectors: Dict[str, Any] = Field(
        ..., description='The selectors defined in selectors.yml'
    )
    disabled: Optional[
        Optional[
            Dict[
                str,
                List[
                    Union[
                        CompiledAnalysisNode,
                        CompiledSingularTestNode,
                        CompiledModelNode,
                        CompiledHookNode,
                        CompiledRPCNode,
                        CompiledSqlNode,
                        CompiledGenericTestNode,
                        CompiledSeedNode,
                        CompiledSnapshotNode,
                        ParsedAnalysisNode,
                        ParsedSingularTestNode,
                        ParsedHookNode,
                        ParsedModelNode,
                        ParsedRPCNode,
                        ParsedSqlNode,
                        ParsedGenericTestNode,
                        ParsedSeedNode,
                        ParsedSnapshotNode,
                        ParsedSourceDefinition,
                    ]
                ],
            ]
        ]
    ] = Field(None, description='A mapping of the disabled nodes in the target')
    parent_map: Optional[Optional[Dict[str, List[str]]]] = Field(
        None, description='A mapping from\xa0child nodes to their dependencies'
    )
    child_map: Optional[Optional[Dict[str, List[str]]]] = Field(
        None, description='A mapping from parent nodes to their dependents'
    )
