helpmsg: str = "\n PT2BS - Python to binary build system based on nuitka\n\n  -g --generate | generate new build.py file with options by args\n  -h --help     | print this message\n  -v --version  | print program version\n"
modes: str = "\nModes:\n 1) default (single binary without libs)\n 2) default + pgo (may cause errors)\n 3) standalone dir (binary + libs for distribute)"
main_file: str = "\n Main file of program."
o_file: str = "\n Output file."
cmassage: str = "\n [build.py generated]\n"
build_py_1: str = '#!/usr/bin/env python3\n\nfrom os import chdir, mkdir\nfrom os import system as sh\nfrom os.path import isdir\nfrom sys import argv\n\n# main file in program\nMAIN: str = "%s"\n\n# output file\nOFILE: str = "%s"\n\n# flags for python interpreter\nPYFLAGS: str = """ \\\n    -OO \\\n"""\n\n# compile flags\nCFLAGS: str = """ \\\n    --warn-implicit-exceptions \\\n    --warn-unusual-code \\\n    --follow-imports \\\n    --python-flag=-OO \\\n    --disable-ccache \\\n    --lto=yes \\\n"""\n\n# dir for binary file\nBINDIR: str = "/usr/local/bin"\n\n# build command\nBUILD: str = f"python {PYFLAGS} -m nuitka {CFLAGS} -o {OFILE} ../{MAIN}"\n\n# if no flags\nif len(argv) == 1:\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n# build option\nelif argv[1] == "build":\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n# install option\nelif argv[1] == "install":\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n    # move file in BINDIR\n    sh(f"sudo mv {OFILE} {BINDIR}")\n\nelse:\n    print("incorrect flags")\n'
build_py_2: str = '#!/usr/bin/env python3\n\nfrom os import chdir, mkdir\nfrom os import system as sh\nfrom os.path import isdir\nfrom sys import argv\n\n# main file in program\nMAIN: str = "%s"\n\n# output file\nOFILE: str = "%s"\n\n# flags for python interpreter\nPYFLAGS: str = """ \\\n    -OO \\\n"""\n\n# compile flags\nCFLAGS: str = """ \\\n    --warn-implicit-exceptions \\\n    --warn-unusual-code \\\n    --follow-imports \\\n    --python-flag=-OO \\\n    --disable-ccache \\\n    --lto=yes \\\n    --pgo \\\n"""\n\n# dir for binary file\nBINDIR: str = "/usr/local/bin"\n\n# build command\nBUILD: str = f"python {PYFLAGS} -m nuitka {CFLAGS} -o {OFILE} ../{MAIN}"\n\n# if no flags\nif len(argv) == 1:\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n# build option\nelif argv[1] == "build":\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n# install option\nelif argv[1] == "install":\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n    # move file in BINDIR\n    sh(f"sudo mv {OFILE} {BINDIR}")\n\nelse:\n    print("incorrect flags")\n'
build_py_3: str = '#!/usr/bin/env python3\n\nfrom os import chdir, mkdir\nfrom os import system as sh\nfrom os.path import isdir\nfrom sys import argv\n\n# main file in program\nMAIN: str = "%s"\n\n# output file\nOFILE: str = "%s"\n\n# flags for python interpreter\nPYFLAGS: str = """ \\\n    -OO \\\n"""\n\n# compile flags\nCFLAGS: str = """ \\\n    --warn-implicit-exceptions \\\n    --warn-unusual-code \\\n    --follow-imports \\\n    --follow-stdlib \\\n    --standalone \\\n    --python-flag=-OO \\\n    --disable-ccache \\\n    --lto=yes \\\n"""\n\n# dir for binary file\nBINDIR: str = "/usr/local/bin"\n\n# build command\nBUILD: str = f"python {PYFLAGS} -m nuitka {CFLAGS} -o {OFILE} ../{MAIN}"\n\n# if no flags\nif len(argv) == 1:\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n# build option\nelif argv[1] == "build":\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n# install option\nelif argv[1] == "install":\n    if isdir("build/"):\n        chdir("build/")\n\n    else:\n        mkdir("build/")\n        chdir("build/")\n\n    sh(BUILD)\n\n    # move file in BINDIR\n    sh(f"sudo mv {OFILE} {BINDIR}")\n\nelse:\n    print("incorrect flags")\n'
args_error: str = "\n [flags is incorrect]\n"
empty_field_error: str = "\n [input field is empty]\n"
mode_error: str = "\n [this mode does not exist]\n"
io_error: str = "\n [file inaccessible]\n"
version: str = "pt2bs - 0.2.0"
