## DWAO Adobe IO Library

Library for basic Adobe IO Integrations.

## Examples

```
import requests
from dwaoAdobeIO import AdobeAuth


JWT_PAYLOAD = {"exp":1619849370,"iss":"D7A63A725B02CDC70A495C49@AdobeOrg","sub":"C52B3AA8607583300A495FE3@techacct.adobe.com","https://ims-na1.adobelogin.com/s/ent_audiencemanagerplatform_sdk":True,"aud":"https://ims-na1.adobelogin.com/c/50f750a65e75406392b4c1c2da9492ee"}
PRIVATE_KEY_PATH = "../Credentials/private.key"
CLIENT_SECRET = "fafda214-f54d-44fe-94e2-30da167e126a"

AAMdcs = AdobeAuth.AAM(JWT_PAYLOAD=JWT_PAYLOAD,PRIVATE_KEY_PATH=PRIVATE_KEY_PATH,CLIENT_SECRET=CLIENT_SECRET)
jwt_token =AAMdcs.generate_jwt()
access_token = AAMdcs.generate_access_token()

print(AAMdcs.get_segments().text)
```

```
Methods Available for AAM REST APIs
get_datasource(param)
get_traits(param)
create_trait(data)
get_segments(param)
create_segment(data)
update_segment(data,segmentId)
get_segment_folders(param)
get_trait_folders(param)
get_destinations(param)
get_destination_mappings(param,destinationId)
set_destination_mappings(data,destinationId)
```