import os
from os import path
from codecs import open as s_open
from setuptools import setup, find_namespace_packages

# get current directory
here = path.abspath(path.dirname(__file__))

# get the long description from the README file
with open(path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

# Read the API version from disk. This file should be located in the package
# folder, since it's also used to set the pkg.__version__ variable.
version_path = os.path.join(here, 'vantage6', 'client', '_version.py')
version_ns = {
    '__file__': version_path
}
with s_open(version_path) as f:
    exec(f.read(), {}, version_ns)


# setup the package
setup(
    name='vantage6-client',
    version=version_ns['__version__'],
    description='Vantage6 client',
    long_description=long_description,
    long_description_content_type='text/markdown',
    url='https://github.com/IKNL/vantage6-client',
    packages=find_namespace_packages(),
    python_requires='>=3.6',
    install_requires=[
       'cryptography==2.8',
       'requests==2.23.0',
       'PyJWT',
       'vantage6-common >= 1.1.0rc1',
    ],
    package_data={
        'vantage6.client': [
            '__build__',
        ],
    }
)