# -*- coding: utf-8 -*-
#
# Copyright (C) 2020 CERN.
#
# invenio-app-ils is free software; you can redistribute it and/or modify it
# under the terms of the MIT License; see LICENSE file for more details.

"""ILS Items serializers."""

from invenio_records_rest.serializers.response import record_responsify, \
    search_responsify

from invenio_app_ils.records.schemas.json import ILSRecordSchemaJSONV1

from .item import ItemCSVSerializer, ItemJSONSerializer

csv_v1 = ItemCSVSerializer(ILSRecordSchemaJSONV1, csv_excluded_fields=[])
csv_v1_response = record_responsify(csv_v1, "text/csv")
csv_v1_search = search_responsify(csv_v1, "text/csv")

json_v1 = ItemJSONSerializer(ILSRecordSchemaJSONV1, replace_refs=True)
json_v1_response = record_responsify(json_v1, "application/json")
json_v1_search = search_responsify(json_v1, "application/json")
