from django.conf import settings

SCHEDULER_CRON = "CRON"
SCHEDULER_CELERY = "CELERY"
VALID_SCHEDULERS = (
    SCHEDULER_CRON,
    SCHEDULER_CELERY,
)


def get_drip_scheduler_settings():
    DRIP_SCHEDULE_SETTINGS = getattr(settings, "DRIP_SCHEDULE_SETTINGS", {})
    DRIP_SCHEDULE = DRIP_SCHEDULE_SETTINGS.get("DRIP_SCHEDULE", False)
    DRIP_SCHEDULE_DAY_OF_WEEK = DRIP_SCHEDULE_SETTINGS.get("DRIP_SCHEDULE_DAY_OF_WEEK", 0)
    DRIP_SCHEDULE_HOUR = DRIP_SCHEDULE_SETTINGS.get("DRIP_SCHEDULE_HOUR", 0)
    DRIP_SCHEDULE_MINUTE = DRIP_SCHEDULE_SETTINGS.get("DRIP_SCHEDULE_MINUTE", 0)
    SCHEDULER = DRIP_SCHEDULE_SETTINGS.get("SCHEDULER", SCHEDULER_CRON)
    return DRIP_SCHEDULE, DRIP_SCHEDULE_DAY_OF_WEEK, DRIP_SCHEDULE_HOUR, DRIP_SCHEDULE_MINUTE, SCHEDULER
