## Guvicorn_logger

This lib colored, normalizes and joins logs between Uvicorn and Gunicorn.
There is a common problem when using Uvicorn for Dev and Gunicorn for Prod, 
normally the logs generated by Uvicorn wokers are not captured by Gunicorn.

This lib facilitates this configuration...

#### Easy config
```python
from guvicorn_logger import Logger

logger = Logger().configure()
```

#### Example

```python
logger.info("Information")
logger.error("Error")
logger.warning("Warning")
logger.critical("Critical")
```
#### Output

- Python File
![alt text](/docs/img/normal.JPG)

- Framework (Uvicorn, Gunicorn, Fastapi)
![alt text](/docs/img/framework-web.JPG)