# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['guvicorn_logger']

package_data = \
{'': ['*']}

install_requires = \
['gunicorn>=20.1.0,<21.0.0', 'uvicorn>=0.17.5,<0.18.0']

setup_kwargs = {
    'name': 'guvicorn-logger',
    'version': '0.1.4',
    'description': 'Colored, normalizes and joins logs between Uvicorn and Gunicorn.',
    'long_description': '## Guvicorn_logger\n\nThis lib colored, normalizes and joins logs between Uvicorn and Gunicorn.\nThere is a common problem when using Uvicorn for Dev and Gunicorn for Prod, \nnormally the logs generated by Uvicorn wokers are not captured by Gunicorn.\n\nThis lib facilitates this configuration...\n\n#### Easy config\n```python\nfrom guvicorn_logger import Logger\n\nlogger = Logger().configure()\n```\n\n#### Example\n\n```python\nlogger.info("Information")\nlogger.error("Error")\nlogger.warning("Warning")\nlogger.critical("Critical")\n```\n#### Output\n\n- Python File\n![alt text](/docs/img/normal.JPG)\n\n- Framework (Uvicorn, Gunicorn, Fastapi)\n![alt text](/docs/img/framework-web.JPG)',
    'author': 'carlos.rian',
    'author_email': 'crian.rian@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/carlos-rian/guvicorn_logger',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
