# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2

from temporalio.api.testservice.v1 import (
    request_response_pb2 as temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2,
)


class TestServiceStub(object):
    """TestService API defines an interface supported only by the Temporal Test Server.
    It provides functionality needed or supported for testing purposes only.

    This is an EXPERIMENTAL API.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.LockTimeSkipping = channel.unary_unary(
            "/temporal.api.testservice.v1.TestService/LockTimeSkipping",
            request_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.LockTimeSkippingRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.LockTimeSkippingResponse.FromString,
        )
        self.UnlockTimeSkipping = channel.unary_unary(
            "/temporal.api.testservice.v1.TestService/UnlockTimeSkipping",
            request_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.UnlockTimeSkippingRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.UnlockTimeSkippingResponse.FromString,
        )
        self.Sleep = channel.unary_unary(
            "/temporal.api.testservice.v1.TestService/Sleep",
            request_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.FromString,
        )
        self.SleepUntil = channel.unary_unary(
            "/temporal.api.testservice.v1.TestService/SleepUntil",
            request_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepUntilRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.FromString,
        )
        self.UnlockTimeSkippingWithSleep = channel.unary_unary(
            "/temporal.api.testservice.v1.TestService/UnlockTimeSkippingWithSleep",
            request_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepRequest.SerializeToString,
            response_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.FromString,
        )
        self.GetCurrentTime = channel.unary_unary(
            "/temporal.api.testservice.v1.TestService/GetCurrentTime",
            request_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            response_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.GetCurrentTimeResponse.FromString,
        )


class TestServiceServicer(object):
    """TestService API defines an interface supported only by the Temporal Test Server.
    It provides functionality needed or supported for testing purposes only.

    This is an EXPERIMENTAL API.
    """

    def LockTimeSkipping(self, request, context):
        """LockTimeSkipping increments Time Locking Counter by one.

        If Time Locking Counter is positive, time skipping is locked (disabled).
        When time skipping is disabled, the time in test server is moving normally, with a real time pace.
        Test Server is typically started with locked time skipping and Time Locking Counter = 1.

        LockTimeSkipping and UnlockTimeSkipping calls are counted.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def UnlockTimeSkipping(self, request, context):
        """UnlockTimeSkipping decrements Time Locking Counter by one.

        If the counter reaches 0, it unlocks time skipping and fast forwards time.
        LockTimeSkipping and UnlockTimeSkipping calls are counted. Calling UnlockTimeSkipping does not
        guarantee that time is going to be fast forwarded as another lock can be holding it.

        Time Locking Counter can't be negative, unbalanced calls to UnlockTimeSkipping will lead to rpc call failure
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def Sleep(self, request, context):
        """This call returns only when the Test Server Time advances by the specified duration.
        This is an EXPERIMENTAL API.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def SleepUntil(self, request, context):
        """This call returns only when the Test Server Time advances to the specified timestamp.
        If the current Test Server Time is beyond the specified timestamp, returns immediately.
        This is an EXPERIMENTAL API.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def UnlockTimeSkippingWithSleep(self, request, context):
        """UnlockTimeSkippingWhileSleep decreases time locking counter by one and increases it back
        once the Test Server Time advances by the duration specified in the request.

        This call returns only when the Test Server Time advances by the specified duration.

        If it is called when Time Locking Counter is
        - more than 1 and no other unlocks are coming in, rpc call will block for the specified duration, time will not be fast forwarded.
        - 1, it will lead to fast forwarding of the time by the duration specified in the request and quick return of this rpc call.
        - 0 will lead to rpc call failure same way as an unbalanced UnlockTimeSkipping.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetCurrentTime(self, request, context):
        """GetCurrentTime returns the current Temporal Test Server time

        This time might not be equal to {@link System#currentTimeMillis()} due to time skipping.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_TestServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
        "LockTimeSkipping": grpc.unary_unary_rpc_method_handler(
            servicer.LockTimeSkipping,
            request_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.LockTimeSkippingRequest.FromString,
            response_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.LockTimeSkippingResponse.SerializeToString,
        ),
        "UnlockTimeSkipping": grpc.unary_unary_rpc_method_handler(
            servicer.UnlockTimeSkipping,
            request_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.UnlockTimeSkippingRequest.FromString,
            response_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.UnlockTimeSkippingResponse.SerializeToString,
        ),
        "Sleep": grpc.unary_unary_rpc_method_handler(
            servicer.Sleep,
            request_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepRequest.FromString,
            response_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.SerializeToString,
        ),
        "SleepUntil": grpc.unary_unary_rpc_method_handler(
            servicer.SleepUntil,
            request_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepUntilRequest.FromString,
            response_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.SerializeToString,
        ),
        "UnlockTimeSkippingWithSleep": grpc.unary_unary_rpc_method_handler(
            servicer.UnlockTimeSkippingWithSleep,
            request_deserializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepRequest.FromString,
            response_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.SerializeToString,
        ),
        "GetCurrentTime": grpc.unary_unary_rpc_method_handler(
            servicer.GetCurrentTime,
            request_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
            response_serializer=temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.GetCurrentTimeResponse.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "temporal.api.testservice.v1.TestService", rpc_method_handlers
    )
    server.add_generic_rpc_handlers((generic_handler,))


# This class is part of an EXPERIMENTAL API.
class TestService(object):
    """TestService API defines an interface supported only by the Temporal Test Server.
    It provides functionality needed or supported for testing purposes only.

    This is an EXPERIMENTAL API.
    """

    @staticmethod
    def LockTimeSkipping(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.testservice.v1.TestService/LockTimeSkipping",
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.LockTimeSkippingRequest.SerializeToString,
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.LockTimeSkippingResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def UnlockTimeSkipping(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.testservice.v1.TestService/UnlockTimeSkipping",
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.UnlockTimeSkippingRequest.SerializeToString,
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.UnlockTimeSkippingResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def Sleep(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.testservice.v1.TestService/Sleep",
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepRequest.SerializeToString,
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def SleepUntil(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.testservice.v1.TestService/SleepUntil",
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepUntilRequest.SerializeToString,
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def UnlockTimeSkippingWithSleep(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.testservice.v1.TestService/UnlockTimeSkippingWithSleep",
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepRequest.SerializeToString,
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.SleepResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )

    @staticmethod
    def GetCurrentTime(
        request,
        target,
        options=(),
        channel_credentials=None,
        call_credentials=None,
        insecure=False,
        compression=None,
        wait_for_ready=None,
        timeout=None,
        metadata=None,
    ):
        return grpc.experimental.unary_unary(
            request,
            target,
            "/temporal.api.testservice.v1.TestService/GetCurrentTime",
            google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
            temporal_dot_api_dot_testservice_dot_v1_dot_request__response__pb2.GetCurrentTimeResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
        )
