"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
The MIT License

Copyright (c) 2020 Temporal Technologies Inc.  All rights reserved.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import temporalio.api.enums.v1.common_pb2

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class ReleaseInfo(google.protobuf.message.Message):
    """ReleaseInfo contains information about specific version of temporal."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    RELEASE_TIME_FIELD_NUMBER: builtins.int
    NOTES_FIELD_NUMBER: builtins.int
    version: builtins.str
    @property
    def release_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    notes: builtins.str
    def __init__(
        self,
        *,
        version: builtins.str = ...,
        release_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        notes: builtins.str = ...,
    ) -> None: ...
    def HasField(
        self, field_name: typing_extensions.Literal["release_time", b"release_time"]
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "notes", b"notes", "release_time", b"release_time", "version", b"version"
        ],
    ) -> None: ...

global___ReleaseInfo = ReleaseInfo

class Alert(google.protobuf.message.Message):
    """Alert contains notification and severity."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGE_FIELD_NUMBER: builtins.int
    SEVERITY_FIELD_NUMBER: builtins.int
    message: builtins.str
    severity: temporalio.api.enums.v1.common_pb2.Severity.ValueType
    def __init__(
        self,
        *,
        message: builtins.str = ...,
        severity: temporalio.api.enums.v1.common_pb2.Severity.ValueType = ...,
    ) -> None: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "message", b"message", "severity", b"severity"
        ],
    ) -> None: ...

global___Alert = Alert

class VersionInfo(google.protobuf.message.Message):
    """VersionInfo contains details about current and recommended release versions as well as alerts and upgrade instructions."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CURRENT_FIELD_NUMBER: builtins.int
    RECOMMENDED_FIELD_NUMBER: builtins.int
    INSTRUCTIONS_FIELD_NUMBER: builtins.int
    ALERTS_FIELD_NUMBER: builtins.int
    LAST_UPDATE_TIME_FIELD_NUMBER: builtins.int
    @property
    def current(self) -> global___ReleaseInfo: ...
    @property
    def recommended(self) -> global___ReleaseInfo: ...
    instructions: builtins.str
    @property
    def alerts(
        self,
    ) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[
        global___Alert
    ]: ...
    @property
    def last_update_time(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    def __init__(
        self,
        *,
        current: global___ReleaseInfo | None = ...,
        recommended: global___ReleaseInfo | None = ...,
        instructions: builtins.str = ...,
        alerts: collections.abc.Iterable[global___Alert] | None = ...,
        last_update_time: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(
        self,
        field_name: typing_extensions.Literal[
            "current",
            b"current",
            "last_update_time",
            b"last_update_time",
            "recommended",
            b"recommended",
        ],
    ) -> builtins.bool: ...
    def ClearField(
        self,
        field_name: typing_extensions.Literal[
            "alerts",
            b"alerts",
            "current",
            b"current",
            "instructions",
            b"instructions",
            "last_update_time",
            b"last_update_time",
            "recommended",
            b"recommended",
        ],
    ) -> None: ...

global___VersionInfo = VersionInfo
