// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core');
goog.require('goog.string');
goog.require('goog.object');
goog.require('goog.array');
goog.require('goog.string.StringBuffer');
cljs.core._STAR_clojurescript_version_STAR_ = "1.7.228";
cljs.core._STAR_unchecked_if_STAR_ = false;

/** @define {string} */
goog.define("cljs.core._STAR_target_STAR_","default");
/**
 * Var bound to the current namespace. Only used for bootstrapping.
 * @type {*}
 */
cljs.core._STAR_ns_STAR_ = null;
/**
 * @type {*}
 */
cljs.core._STAR_out_STAR_ = null;
cljs.core._STAR_assert_STAR_ = true;
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
if(typeof cljs.core._STAR_print_err_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print error output.
 *   Whatever function *print-fn* is bound to will be passed any
 *   Strings which should be printed.
 */
cljs.core._STAR_print_err_fn_STAR_ = (function cljs$core$_STAR_print_err_fn_STAR_(_){
throw (new Error("No *print-err-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * Set *print-err-fn* to f.
 */
cljs.core.set_print_err_fn_BANG_ = (function cljs$core$set_print_err_fn_BANG_(f){
return cljs.core._STAR_print_err_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 *   Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 *   This is to work around the implicit newlines emitted by standard JavaScript
 *   console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 *   non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 *   Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 *   be printed in a form that can be read back by the reader.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 *   their type when read in later.
 * 
 *   Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * *print-length* controls how many items of each collection the
 *   printer will print. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   number of items of each collection to print. If a collection contains
 *   more items, the printer will print items up to the limit followed by
 *   '...' to represent the remaining items. The root binding is nil
 *   indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 *   print nested objects. If it is bound to logical false, there is no
 *   limit. Otherwise, it must be bound to an integer indicating the maximum
 *   level to print. Each argument to print is at level 0; if an argument is a
 *   collection, its items are at level 1; and so on. If an object is a
 *   collection and is at a level greater than or equal to the value bound to
 *   *print-level*, the printer prints '#' to represent it. The root binding
 *   is nil indicating no limit.
 * @type {null|number}
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
/**
 * @type {*}
 */
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$flush_DASH_on_DASH_newline,cljs.core._STAR_flush_on_newline_STAR_,cljs.core.cst$kw$readably,cljs.core._STAR_print_readably_STAR_,cljs.core.cst$kw$meta,cljs.core._STAR_print_meta_STAR_,cljs.core.cst$kw$dup,cljs.core._STAR_print_dup_STAR_,cljs.core.cst$kw$print_DASH_length,cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__33228__delegate = function (args){
return console.log.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__33228 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33229__i = 0, G__33229__a = new Array(arguments.length -  0);
while (G__33229__i < G__33229__a.length) {G__33229__a[G__33229__i] = arguments[G__33229__i + 0]; ++G__33229__i;}
  args = new cljs.core.IndexedSeq(G__33229__a,0);
} 
return G__33228__delegate.call(this,args);};
G__33228.cljs$lang$maxFixedArity = 0;
G__33228.cljs$lang$applyTo = (function (arglist__33230){
var args = cljs.core.seq(arglist__33230);
return G__33228__delegate(args);
});
G__33228.cljs$core$IFn$_invoke$arity$variadic = G__33228__delegate;
return G__33228;
})()
;

cljs.core._STAR_print_err_fn_STAR_ = (function() { 
var G__33231__delegate = function (args){
return console.error.apply(console,(cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args) : cljs.core.into_array.call(null,args)));
};
var G__33231 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__33232__i = 0, G__33232__a = new Array(arguments.length -  0);
while (G__33232__i < G__33232__a.length) {G__33232__a[G__33232__i] = arguments[G__33232__i + 0]; ++G__33232__i;}
  args = new cljs.core.IndexedSeq(G__33232__a,0);
} 
return G__33231__delegate.call(this,args);};
G__33231.cljs$lang$maxFixedArity = 0;
G__33231.cljs$lang$applyTo = (function (arglist__33233){
var args = cljs.core.seq(arglist__33233);
return G__33231__delegate(args);
});
G__33231.cljs$core$IFn$_invoke$arity$variadic = G__33231__delegate;
return G__33231;
})()
;

return null;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(x){
return typeof x === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if((x == null)){
return true;
} else {
if(x === false){
return true;
} else {
return false;

}
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
return goog.isString(x);
});
/**
 * Returns true if x is a JavaScript char.
 */
cljs.core.char_QMARK_ = (function cljs$core$char_QMARK_(x){
return goog.string.isUnicodeChar(x);
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[goog.typeOf(x__$1)])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever function
 *   *main-cli-fn* is set to will be called with the command-line
 *   argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__6141__auto__ = ty;
if(cljs.core.truth_(and__6141__auto__)){
return ty.cljs$lang$type;
} else {
return and__6141__auto__;
}
})())?ty.cljs$lang$ctorStr:goog.typeOf(obj));
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4655__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4655__auto__)){
var s = temp__4655__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && ((goog.typeOf(Symbol) === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * @enum {string}
 */
cljs.core.CHAR_MAP = {"]": "_RBRACK_", "'": "_SINGLEQUOTE_", "=": "_EQ_", "\"": "_DOUBLEQUOTE_", "!": "_BANG_", "*": "_STAR_", "%": "_PERCENT_", "|": "_BAR_", "~": "_TILDE_", "/": "_SLASH_", "\\": "_BSLASH_", "-": "_", "?": "_QMARK_", "&": "_AMPERSAND_", ":": "_COLON_", "<": "_LT_", "{": "_LBRACE_", "}": "_RBRACE_", "[": "_LBRACK_", "#": "_SHARP_", "^": "_CARET_", "+": "_PLUS_", "@": "_CIRCA_", ">": "_GT_"};
/**
 * @enum {string}
 */
cljs.core.DEMUNGE_MAP = {"_RBRACE_": "}", "_COLON_": ":", "_BANG_": "!", "_QMARK_": "?", "_BSLASH_": "\\\\", "_SLASH_": "/", "_PERCENT_": "%", "_PLUS_": "+", "_SHARP_": "#", "_LBRACE_": "{", "_BAR_": "|", "_LBRACK_": "[", "_EQ_": "=", "_": "-", "_TILDE_": "~", "_RBRACK_": "]", "_GT_": ">", "_SINGLEQUOTE_": "'", "_CIRCA_": "@", "_AMPERSAND_": "&", "_DOUBLEQUOTE_": "\\\"", "_CARET_": "^", "_LT_": "<", "_STAR_": "*"};
cljs.core.DEMUNGE_PATTERN = null;
/**
 * Returns highest resolution time offered by host in milliseconds.
 */
cljs.core.system_time = (function cljs$core$system_time(){
if((typeof performance !== 'undefined') && (!((performance.now == null)))){
return performance.now();
} else {
if((typeof process !== 'undefined') && (!((process.hrtime == null)))){
var t = process.hrtime();
return ((((t[(0)]) * 1.0E9) + (t[(1)])) / 1000000.0);
} else {
return (new Date()).getTime();

}
}
});
/**
 * Construct a JavaScript array of specified size. Accepts ignored type
 *   argument for compatibility with Clojure.
 */
cljs.core.make_array = (function cljs$core$make_array(var_args){
var args33234 = [];
var len__7211__auto___33237 = arguments.length;
var i__7212__auto___33238 = (0);
while(true){
if((i__7212__auto___33238 < len__7211__auto___33237)){
args33234.push((arguments[i__7212__auto___33238]));

var G__33239 = (i__7212__auto___33238 + (1));
i__7212__auto___33238 = G__33239;
continue;
} else {
}
break;
}

var G__33236 = args33234.length;
switch (G__33236) {
case 1:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.make_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33234.length)].join('')));

}
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$1 = (function (size){
return (new Array(size));
});

cljs.core.make_array.cljs$core$IFn$_invoke$arity$2 = (function (type,size){
return (new Array(size));
});

cljs.core.make_array.cljs$lang$maxFixedArity = 2;
/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__7056__auto___33241 = len;
var i_33242 = (0);
while(true){
if((i_33242 < n__7056__auto___33241)){
(new_arr[i_33242] = (arr[i_33242]));

var G__33243 = (i_33242 + (1));
i_33242 = G__33243;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__33244 = (i + (1));
i = G__33244;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 */
cljs.core.aget = (function cljs$core$aget(var_args){
var args33245 = [];
var len__7211__auto___33254 = arguments.length;
var i__7212__auto___33255 = (0);
while(true){
if((i__7212__auto___33255 < len__7211__auto___33254)){
args33245.push((arguments[i__7212__auto___33255]));

var G__33256 = (i__7212__auto___33255 + (1));
i__7212__auto___33255 = G__33256;
continue;
} else {
}
break;
}

var G__33250 = args33245.length;
switch (G__33250) {
case 2:
return cljs.core.aget.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33245.slice((2)),(0)));
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return (array[i]);
});

cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic = (function (array,i,idxs){
var G__33251 = cljs.core.aget;
var G__33252 = (array[i]);
var G__33253 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__33251,G__33252,G__33253) : cljs.core.apply.call(null,G__33251,G__33252,G__33253));
});

cljs.core.aget.cljs$lang$applyTo = (function (seq33246){
var G__33247 = cljs.core.first(seq33246);
var seq33246__$1 = cljs.core.next(seq33246);
var G__33248 = cljs.core.first(seq33246__$1);
var seq33246__$2 = cljs.core.next(seq33246__$1);
return cljs.core.aget.cljs$core$IFn$_invoke$arity$variadic(G__33247,G__33248,seq33246__$2);
});

cljs.core.aget.cljs$lang$maxFixedArity = (2);
/**
 * Sets the value at the index.
 */
cljs.core.aset = (function cljs$core$aset(var_args){
var args33258 = [];
var len__7211__auto___33269 = arguments.length;
var i__7212__auto___33270 = (0);
while(true){
if((i__7212__auto___33270 < len__7211__auto___33269)){
args33258.push((arguments[i__7212__auto___33270]));

var G__33271 = (i__7212__auto___33270 + (1));
i__7212__auto___33270 = G__33271;
continue;
} else {
}
break;
}

var G__33264 = args33258.length;
switch (G__33264) {
case 3:
return cljs.core.aset.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33258.slice((3)),(0)));
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$3 = (function (array,i,val){
return (array[i] = val);
});

cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic = (function (array,idx,idx2,idxv){
var G__33265 = cljs.core.aset;
var G__33266 = (array[idx]);
var G__33267 = idx2;
var G__33268 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__33265,G__33266,G__33267,G__33268) : cljs.core.apply.call(null,G__33265,G__33266,G__33267,G__33268));
});

cljs.core.aset.cljs$lang$applyTo = (function (seq33259){
var G__33260 = cljs.core.first(seq33259);
var seq33259__$1 = cljs.core.next(seq33259);
var G__33261 = cljs.core.first(seq33259__$1);
var seq33259__$2 = cljs.core.next(seq33259__$1);
var G__33262 = cljs.core.first(seq33259__$2);
var seq33259__$3 = cljs.core.next(seq33259__$2);
return cljs.core.aset.cljs$core$IFn$_invoke$arity$variadic(G__33260,G__33261,G__33262,seq33259__$3);
});

cljs.core.aset.cljs$lang$maxFixedArity = (3);
/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 *   argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function cljs$core$into_array(var_args){
var args33273 = [];
var len__7211__auto___33279 = arguments.length;
var i__7212__auto___33280 = (0);
while(true){
if((i__7212__auto___33280 < len__7211__auto___33279)){
args33273.push((arguments[i__7212__auto___33280]));

var G__33281 = (i__7212__auto___33280 + (1));
i__7212__auto___33280 = G__33281;
continue;
} else {
}
break;
}

var G__33275 = args33273.length;
switch (G__33275) {
case 1:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33273.length)].join('')));

}
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 = (function (aseq){
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});

cljs.core.into_array.cljs$core$IFn$_invoke$arity$2 = (function (type,aseq){
var G__33276 = (function (a,x){
a.push(x);

return a;
});
var G__33277 = [];
var G__33278 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__33276,G__33277,G__33278) : cljs.core.reduce.call(null,G__33276,G__33277,G__33278));
});

cljs.core.into_array.cljs$lang$maxFixedArity = 2;
/**
 * Invoke JavaScript object method via string. Needed when the
 *   string is not a valid unquoted property name.
 */
cljs.core.js_invoke = (function cljs$core$js_invoke(var_args){
var args__7218__auto__ = [];
var len__7211__auto___33286 = arguments.length;
var i__7212__auto___33287 = (0);
while(true){
if((i__7212__auto___33287 < len__7211__auto___33286)){
args__7218__auto__.push((arguments[i__7212__auto___33287]));

var G__33288 = (i__7212__auto___33287 + (1));
i__7212__auto___33287 = G__33288;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((2) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((2)),(0))):null);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7219__auto__);
});

cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic = (function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
});

cljs.core.js_invoke.cljs$lang$maxFixedArity = (2);

cljs.core.js_invoke.cljs$lang$applyTo = (function (seq33283){
var G__33284 = cljs.core.first(seq33283);
var seq33283__$1 = cljs.core.next(seq33283);
var G__33285 = cljs.core.first(seq33283__$1);
var seq33283__$2 = cljs.core.next(seq33283__$1);
return cljs.core.js_invoke.cljs$core$IFn$_invoke$arity$variadic(G__33284,G__33285,seq33283__$2);
});

/**
 * Marker protocol
 * @interface
 */
cljs.core.Fn = function(){};


/**
 * Protocol for adding the ability to invoke an object as a function.
 *   For example, a vector can also be used to look up a value:
 *   ([1 2 3 4] 1) => 2
 * @interface
 */
cljs.core.IFn = function(){};

cljs.core._invoke = (function cljs$core$_invoke(var_args){
var args33289 = [];
var len__7211__auto___33292 = arguments.length;
var i__7212__auto___33293 = (0);
while(true){
if((i__7212__auto___33293 < len__7211__auto___33292)){
args33289.push((arguments[i__7212__auto___33293]));

var G__33294 = (i__7212__auto___33293 + (1));
i__7212__auto___33293 = G__33294;
continue;
} else {
}
break;
}

var G__33291 = args33289.length;
switch (G__33291) {
case 1:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
case 9:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
case 11:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$11((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]));

break;
case 12:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$12((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]));

break;
case 13:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$13((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]));

break;
case 14:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$14((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]));

break;
case 15:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$15((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]));

break;
case 16:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$16((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]));

break;
case 17:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$17((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]));

break;
case 18:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$18((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]));

break;
case 19:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$19((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]));

break;
case 20:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$20((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]));

break;
case 21:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$21((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]));

break;
case 22:
return cljs.core._invoke.cljs$core$IFn$_invoke$arity$22((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]),(arguments[(10)]),(arguments[(11)]),(arguments[(12)]),(arguments[(13)]),(arguments[(14)]),(arguments[(15)]),(arguments[(16)]),(arguments[(17)]),(arguments[(18)]),(arguments[(19)]),(arguments[(20)]),(arguments[(21)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33289.length)].join('')));

}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$1 = (function (this$){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$1 == null)))){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__6809__auto__.call(null,this$));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__6809__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$2 = (function (this$,a){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$2 == null)))){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(this$,a) : m__6809__auto__.call(null,this$,a));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,a) : m__6809__auto____$1.call(null,this$,a));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$3 = (function (this$,a,b){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$3 == null)))){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__6809__auto__.call(null,this$,a,b));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,a,b) : m__6809__auto____$1.call(null,this$,a,b));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$4 = (function (this$,a,b,c){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$4 == null)))){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__6809__auto__.call(null,this$,a,b,c));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$4(this$,a,b,c) : m__6809__auto____$1.call(null,this$,a,b,c));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$5 = (function (this$,a,b,c,d){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$5 == null)))){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$5 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__6809__auto__.call(null,this$,a,b,c,d));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d) : m__6809__auto____$1.call(null,this$,a,b,c,d));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$6 = (function (this$,a,b,c,d,e){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$6 == null)))){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$6 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__6809__auto__.call(null,this$,a,b,c,d,e));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$6 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e) : m__6809__auto____$1.call(null,this$,a,b,c,d,e));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$7 = (function (this$,a,b,c,d,e,f){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$7 == null)))){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$7 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__6809__auto__.call(null,this$,a,b,c,d,e,f));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$7 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$8 = (function (this$,a,b,c,d,e,f,g){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$8 == null)))){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$8 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$8 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$9 = (function (this$,a,b,c,d,e,f,g,h){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$9 == null)))){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$9 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$9 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$10 == null)))){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$10 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$10 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$11 == null)))){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$11 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$11 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$12 == null)))){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$12 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$12 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$13 == null)))){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$13 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$13 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$14 == null)))){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$14 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$14 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$15 == null)))){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$15 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$15 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$16 == null)))){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$16 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$16 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$17 == null)))){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$17 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$17 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$18 == null)))){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$18 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$18 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$19 == null)))){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$19 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$19 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$20 == null)))){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$20 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$20 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$21 == null)))){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$21 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$21 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$core$IFn$_invoke$arity$22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((!((this$ == null))) && (!((this$.cljs$core$IFn$_invoke$arity$22 == null)))){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._invoke[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$22 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__6809__auto__.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
var m__6809__auto____$1 = (cljs.core._invoke["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$22 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : m__6809__auto____$1.call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
}
});

cljs.core._invoke.cljs$lang$maxFixedArity = 22;


/**
 * Protocol for cloning a value.
 * @interface
 */
cljs.core.ICloneable = function(){};

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((!((value == null))) && (!((value.cljs$core$ICloneable$_clone$arity$1 == null)))){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__6808__auto__ = (((value == null))?null:value);
var m__6809__auto__ = (cljs.core._clone[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(value) : m__6809__auto__.call(null,value));
} else {
var m__6809__auto____$1 = (cljs.core._clone["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(value) : m__6809__auto____$1.call(null,value));
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 * @interface
 */
cljs.core.ICounted = function(){};

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((!((coll == null))) && (!((coll.cljs$core$ICounted$_count$arity$1 == null)))){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._count[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._count["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
}
});


/**
 * Protocol for creating an empty collection.
 * @interface
 */
cljs.core.IEmptyableCollection = function(){};

/**
 * Returns an empty collection of the same category as coll. Used
 *   by cljs.core/empty.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEmptyableCollection$_empty$arity$1 == null)))){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._empty[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._empty["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
}
});


/**
 * Protocol for adding to a collection.
 * @interface
 */
cljs.core.ICollection = function(){};

/**
 * Returns a new collection of coll with o added to it. The new item
 *   should be added to the most efficient place, e.g.
 *   (conj [1 2 3 4] 5) => [1 2 3 4 5]
 *   (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((!((coll == null))) && (!((coll.cljs$core$ICollection$_conj$arity$2 == null)))){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._conj[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(coll,o) : m__6809__auto__.call(null,coll,o));
} else {
var m__6809__auto____$1 = (cljs.core._conj["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,o) : m__6809__auto____$1.call(null,coll,o));
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
}
});


/**
 * Protocol for collections to provide indexed-based access to their items.
 * @interface
 */
cljs.core.IIndexed = function(){};

/**
 * Returns the value at the index n in the collection coll.
 *   Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function cljs$core$_nth(var_args){
var args33296 = [];
var len__7211__auto___33299 = arguments.length;
var i__7212__auto___33300 = (0);
while(true){
if((i__7212__auto___33300 < len__7211__auto___33299)){
args33296.push((arguments[i__7212__auto___33300]));

var G__33301 = (i__7212__auto___33300 + (1));
i__7212__auto___33300 = G__33301;
continue;
} else {
}
break;
}

var G__33298 = args33296.length;
switch (G__33298) {
case 2:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33296.length)].join('')));

}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$2 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._nth[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(coll,n) : m__6809__auto__.call(null,coll,n));
} else {
var m__6809__auto____$1 = (cljs.core._nth["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,n) : m__6809__auto____$1.call(null,coll,n));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if((!((coll == null))) && (!((coll.cljs$core$IIndexed$_nth$arity$3 == null)))){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._nth[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__6809__auto__.call(null,coll,n,not_found));
} else {
var m__6809__auto____$1 = (cljs.core._nth["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,not_found) : m__6809__auto____$1.call(null,coll,n,not_found));
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
}
});

cljs.core._nth.cljs$lang$maxFixedArity = 3;


/**
 * Marker protocol indicating an array sequence.
 * @interface
 */
cljs.core.ASeq = function(){};


/**
 * Protocol for collections to provide access to their items as sequences.
 * @interface
 */
cljs.core.ISeq = function(){};

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_first$arity$1 == null)))){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._first[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._first["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
}
});

/**
 * Returns a new collection of coll without the first item. It should
 *   always return a seq, e.g.
 *   (rest []) => ()
 *   (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISeq$_rest$arity$1 == null)))){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._rest[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._rest["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the next items of a collection.
 * @interface
 */
cljs.core.INext = function(){};

/**
 * Returns a new collection of coll without the first item. In contrast to
 *   rest, it should return nil if there are no more items, e.g.
 *   (next []) => nil
 *   (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$INext$_next$arity$1 == null)))){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._next[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._next["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
}
});


/**
 * Protocol for looking up a value in a data structure.
 * @interface
 */
cljs.core.ILookup = function(){};

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 *   a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function cljs$core$_lookup(var_args){
var args33303 = [];
var len__7211__auto___33306 = arguments.length;
var i__7212__auto___33307 = (0);
while(true){
if((i__7212__auto___33307 < len__7211__auto___33306)){
args33303.push((arguments[i__7212__auto___33307]));

var G__33308 = (i__7212__auto___33307 + (1));
i__7212__auto___33307 = G__33308;
continue;
} else {
}
break;
}

var G__33305 = args33303.length;
switch (G__33305) {
case 2:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33303.length)].join('')));

}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$2 == null)))){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._lookup[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(o,k) : m__6809__auto__.call(null,o,k));
} else {
var m__6809__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(o,k) : m__6809__auto____$1.call(null,o,k));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if((!((o == null))) && (!((o.cljs$core$ILookup$_lookup$arity$3 == null)))){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._lookup[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__6809__auto__.call(null,o,k,not_found));
} else {
var m__6809__auto____$1 = (cljs.core._lookup["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(o,k,not_found) : m__6809__auto____$1.call(null,o,k,not_found));
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
}
});

cljs.core._lookup.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for adding associativity to collections.
 * @interface
 */
cljs.core.IAssociative = function(){};

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 == null)))){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._contains_key_QMARK_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__6809__auto__.call(null,coll,k));
} else {
var m__6809__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__6809__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 *   value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((!((coll == null))) && (!((coll.cljs$core$IAssociative$_assoc$arity$3 == null)))){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._assoc[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__6809__auto__.call(null,coll,k,v));
} else {
var m__6809__auto____$1 = (cljs.core._assoc["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,v) : m__6809__auto____$1.call(null,coll,k,v));
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to collections.
 * @interface
 */
cljs.core.IMap = function(){};

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((!((coll == null))) && (!((coll.cljs$core$IMap$_dissoc$arity$2 == null)))){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._dissoc[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(coll,k) : m__6809__auto__.call(null,coll,k));
} else {
var m__6809__auto____$1 = (cljs.core._dissoc["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,k) : m__6809__auto____$1.call(null,coll,k));
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
}
});


/**
 * Protocol for examining a map entry.
 * @interface
 */
cljs.core.IMapEntry = function(){};

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_key$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._key[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._key["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((!((coll == null))) && (!((coll.cljs$core$IMapEntry$_val$arity$1 == null)))){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._val[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._val["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
}
});


/**
 * Protocol for adding set functionality to a collection.
 * @interface
 */
cljs.core.ISet = function(){};

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((!((coll == null))) && (!((coll.cljs$core$ISet$_disjoin$arity$2 == null)))){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._disjoin[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(coll,v) : m__6809__auto__.call(null,coll,v));
} else {
var m__6809__auto____$1 = (cljs.core._disjoin["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,v) : m__6809__auto____$1.call(null,coll,v));
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 *   of the stack should be accessed in the most efficient way for the different
 *   data structures.
 * @interface
 */
cljs.core.IStack = function(){};

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_peek$arity$1 == null)))){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._peek[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._peek["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 *   by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((!((coll == null))) && (!((coll.cljs$core$IStack$_pop$arity$1 == null)))){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._pop[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._pop["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
}
});


/**
 * Protocol for adding vector functionality to collections.
 * @interface
 */
cljs.core.IVector = function(){};

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((!((coll == null))) && (!((coll.cljs$core$IVector$_assoc_n$arity$3 == null)))){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._assoc_n[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__6809__auto__.call(null,coll,n,val));
} else {
var m__6809__auto____$1 = (cljs.core._assoc_n["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,n,val) : m__6809__auto____$1.call(null,coll,n,val));
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 * @interface
 */
cljs.core.IDeref = function(){};

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((!((o == null))) && (!((o.cljs$core$IDeref$_deref$arity$1 == null)))){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._deref[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__6809__auto__.call(null,o));
} else {
var m__6809__auto____$1 = (cljs.core._deref["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__6809__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
}
});


/**
 * @interface
 */
cljs.core.IDerefWithTimeout = function(){};

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((!((o == null))) && (!((o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3 == null)))){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._deref_with_timeout[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__6809__auto__.call(null,o,msec,timeout_val));
} else {
var m__6809__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(o,msec,timeout_val) : m__6809__auto____$1.call(null,o,msec,timeout_val));
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
}
});


/**
 * Protocol for accessing the metadata of an object.
 * @interface
 */
cljs.core.IMeta = function(){};

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((!((o == null))) && (!((o.cljs$core$IMeta$_meta$arity$1 == null)))){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._meta[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__6809__auto__.call(null,o));
} else {
var m__6809__auto____$1 = (cljs.core._meta["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__6809__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
}
});


/**
 * Protocol for adding metadata to an object.
 * @interface
 */
cljs.core.IWithMeta = function(){};

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((!((o == null))) && (!((o.cljs$core$IWithMeta$_with_meta$arity$2 == null)))){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._with_meta[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(o,meta) : m__6809__auto__.call(null,o,meta));
} else {
var m__6809__auto____$1 = (cljs.core._with_meta["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(o,meta) : m__6809__auto____$1.call(null,o,meta));
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
}
});


/**
 * Protocol for seq types that can reduce themselves.
 *   Called by cljs.core/reduce.
 * @interface
 */
cljs.core.IReduce = function(){};

/**
 * f should be a function of 2 arguments. If start is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function cljs$core$_reduce(var_args){
var args33310 = [];
var len__7211__auto___33313 = arguments.length;
var i__7212__auto___33314 = (0);
while(true){
if((i__7212__auto___33314 < len__7211__auto___33313)){
args33310.push((arguments[i__7212__auto___33314]));

var G__33315 = (i__7212__auto___33314 + (1));
i__7212__auto___33314 = G__33315;
continue;
} else {
}
break;
}

var G__33312 = args33310.length;
switch (G__33312) {
case 2:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33310.length)].join('')));

}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$2 = (function (coll,f){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$2 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._reduce[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(coll,f) : m__6809__auto__.call(null,coll,f));
} else {
var m__6809__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,f) : m__6809__auto____$1.call(null,coll,f));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$core$IFn$_invoke$arity$3 = (function (coll,f,start){
if((!((coll == null))) && (!((coll.cljs$core$IReduce$_reduce$arity$3 == null)))){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._reduce[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__6809__auto__.call(null,coll,f,start));
} else {
var m__6809__auto____$1 = (cljs.core._reduce["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,start) : m__6809__auto____$1.call(null,coll,f,start));
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
}
});

cljs.core._reduce.cljs$lang$maxFixedArity = 3;


/**
 * Protocol for associative types that can reduce themselves
 *   via a function of key and val. Called by cljs.core/reduce-kv.
 * @interface
 */
cljs.core.IKVReduce = function(){};

/**
 * Reduces an associative collection and returns the result. f should be
 *   a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((!((coll == null))) && (!((coll.cljs$core$IKVReduce$_kv_reduce$arity$3 == null)))){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._kv_reduce[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__6809__auto__.call(null,coll,f,init));
} else {
var m__6809__auto____$1 = (cljs.core._kv_reduce["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,f,init) : m__6809__auto____$1.call(null,coll,f,init));
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 * @interface
 */
cljs.core.IEquiv = function(){};

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((!((o == null))) && (!((o.cljs$core$IEquiv$_equiv$arity$2 == null)))){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._equiv[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(o,other) : m__6809__auto__.call(null,o,other));
} else {
var m__6809__auto____$1 = (cljs.core._equiv["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(o,other) : m__6809__auto____$1.call(null,o,other));
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
}
});


/**
 * Protocol for adding hashing functionality to a type.
 * @interface
 */
cljs.core.IHash = function(){};

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((!((o == null))) && (!((o.cljs$core$IHash$_hash$arity$1 == null)))){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._hash[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__6809__auto__.call(null,o));
} else {
var m__6809__auto____$1 = (cljs.core._hash["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__6809__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 * @interface
 */
cljs.core.ISeqable = function(){};

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((!((o == null))) && (!((o.cljs$core$ISeqable$_seq$arity$1 == null)))){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._seq[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(o) : m__6809__auto__.call(null,o));
} else {
var m__6809__auto____$1 = (cljs.core._seq["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(o) : m__6809__auto____$1.call(null,o));
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 * @interface
 */
cljs.core.ISequential = function(){};


/**
 * Marker interface indicating a persistent list
 * @interface
 */
cljs.core.IList = function(){};


/**
 * Marker interface indicating a record object
 * @interface
 */
cljs.core.IRecord = function(){};


/**
 * Protocol for reversing a seq.
 * @interface
 */
cljs.core.IReversible = function(){};

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((!((coll == null))) && (!((coll.cljs$core$IReversible$_rseq$arity$1 == null)))){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._rseq[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._rseq["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
}
});


/**
 * Protocol for a collection which can represent their items
 *   in a sorted manner. 
 * @interface
 */
cljs.core.ISorted = function(){};

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq$arity$2 == null)))){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._sorted_seq[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__6809__auto__.call(null,coll,ascending_QMARK_));
} else {
var m__6809__auto____$1 = (cljs.core._sorted_seq["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,ascending_QMARK_) : m__6809__auto____$1.call(null,coll,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 *   If ascending is true, the result should contain all items which are > or >=
 *   than k. If ascending is false, the result should contain all items which
 *   are < or <= than k, e.g.
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 *   (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_sorted_seq_from$arity$3 == null)))){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._sorted_seq_from[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__6809__auto__.call(null,coll,k,ascending_QMARK_));
} else {
var m__6809__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(coll,k,ascending_QMARK_) : m__6809__auto____$1.call(null,coll,k,ascending_QMARK_));
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_entry_key$arity$2 == null)))){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._entry_key[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__6809__auto__.call(null,coll,entry));
} else {
var m__6809__auto____$1 = (cljs.core._entry_key["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(coll,entry) : m__6809__auto____$1.call(null,coll,entry));
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((!((coll == null))) && (!((coll.cljs$core$ISorted$_comparator$arity$1 == null)))){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._comparator[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._comparator["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 * @interface
 */
cljs.core.IWriter = function(){};

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_write$arity$2 == null)))){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__6808__auto__ = (((writer == null))?null:writer);
var m__6809__auto__ = (cljs.core._write[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(writer,s) : m__6809__auto__.call(null,writer,s));
} else {
var m__6809__auto____$1 = (cljs.core._write["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(writer,s) : m__6809__auto____$1.call(null,writer,s));
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((!((writer == null))) && (!((writer.cljs$core$IWriter$_flush$arity$1 == null)))){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__6808__auto__ = (((writer == null))?null:writer);
var m__6809__auto__ = (cljs.core._flush[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(writer) : m__6809__auto__.call(null,writer));
} else {
var m__6809__auto____$1 = (cljs.core._flush["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(writer) : m__6809__auto____$1.call(null,writer));
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 * @interface
 */
cljs.core.IPrintWithWriter = function(){};

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((!((o == null))) && (!((o.cljs$core$IPrintWithWriter$_pr_writer$arity$3 == null)))){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._pr_writer[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__6809__auto__.call(null,o,writer,opts));
} else {
var m__6809__auto____$1 = (cljs.core._pr_writer["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(o,writer,opts) : m__6809__auto____$1.call(null,o,writer,opts));
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 *   implemented by Delay and LazySeq.
 * @interface
 */
cljs.core.IPending = function(){};

/**
 * Returns true if a value for x has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(x){
if((!((x == null))) && (!((x.cljs$core$IPending$_realized_QMARK_$arity$1 == null)))){
return x.cljs$core$IPending$_realized_QMARK_$arity$1(x);
} else {
var x__6808__auto__ = (((x == null))?null:x);
var m__6809__auto__ = (cljs.core._realized_QMARK_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto__.call(null,x));
} else {
var m__6809__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IPending.-realized?",x);
}
}
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 * @interface
 */
cljs.core.IWatchable = function(){};

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_notify_watches$arity$3 == null)))){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._notify_watches[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__6809__auto__.call(null,this$,oldval,newval));
} else {
var m__6809__auto____$1 = (cljs.core._notify_watches["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,oldval,newval) : m__6809__auto____$1.call(null,this$,oldval,newval));
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 *   and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_add_watch$arity$3 == null)))){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._add_watch[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__6809__auto__.call(null,this$,key,f));
} else {
var m__6809__auto____$1 = (cljs.core._add_watch["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(this$,key,f) : m__6809__auto____$1.call(null,this$,key,f));
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((!((this$ == null))) && (!((this$.cljs$core$IWatchable$_remove_watch$arity$2 == null)))){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (cljs.core._remove_watch[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(this$,key) : m__6809__auto__.call(null,this$,key));
} else {
var m__6809__auto____$1 = (cljs.core._remove_watch["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,key) : m__6809__auto____$1.call(null,this$,key));
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
}
});


/**
 * Protocol for collections which can transformed to transients.
 * @interface
 */
cljs.core.IEditableCollection = function(){};

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((!((coll == null))) && (!((coll.cljs$core$IEditableCollection$_as_transient$arity$1 == null)))){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._as_transient[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._as_transient["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 * @interface
 */
cljs.core.ITransientCollection = function(){};

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__6808__auto__ = (((tcoll == null))?null:tcoll);
var m__6809__auto__ = (cljs.core._conj_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__6809__auto__.call(null,tcoll,val));
} else {
var m__6809__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,val) : m__6809__auto____$1.call(null,tcoll,val));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__6808__auto__ = (((tcoll == null))?null:tcoll);
var m__6809__auto__ = (cljs.core._persistent_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__6809__auto__.call(null,tcoll));
} else {
var m__6809__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__6809__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
}
});


/**
 * Protocol for adding associativity to transient collections.
 * @interface
 */
cljs.core.ITransientAssociative = function(){};

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 *   val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__6808__auto__ = (((tcoll == null))?null:tcoll);
var m__6809__auto__ = (cljs.core._assoc_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__6809__auto__.call(null,tcoll,key,val));
} else {
var m__6809__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,key,val) : m__6809__auto____$1.call(null,tcoll,key,val));
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 * @interface
 */
cljs.core.ITransientMap = function(){};

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__6808__auto__ = (((tcoll == null))?null:tcoll);
var m__6809__auto__ = (cljs.core._dissoc_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__6809__auto__.call(null,tcoll,key));
} else {
var m__6809__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,key) : m__6809__auto____$1.call(null,tcoll,key));
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 * @interface
 */
cljs.core.ITransientVector = function(){};

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 == null)))){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__6808__auto__ = (((tcoll == null))?null:tcoll);
var m__6809__auto__ = (cljs.core._assoc_n_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__6809__auto__.call(null,tcoll,n,val));
} else {
var m__6809__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(tcoll,n,val) : m__6809__auto____$1.call(null,tcoll,n,val));
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1 == null)))){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__6808__auto__ = (((tcoll == null))?null:tcoll);
var m__6809__auto__ = (cljs.core._pop_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(tcoll) : m__6809__auto__.call(null,tcoll));
} else {
var m__6809__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(tcoll) : m__6809__auto____$1.call(null,tcoll));
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 * @interface
 */
cljs.core.ITransientSet = function(){};

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((!((tcoll == null))) && (!((tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 == null)))){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__6808__auto__ = (((tcoll == null))?null:tcoll);
var m__6809__auto__ = (cljs.core._disjoin_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__6809__auto__.call(null,tcoll,v));
} else {
var m__6809__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(tcoll,v) : m__6809__auto____$1.call(null,tcoll,v));
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
}
});


/**
 * Protocol for values that can be compared.
 * @interface
 */
cljs.core.IComparable = function(){};

/**
 * Returns a negative number, zero, or a positive number when x is logically
 *   'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((!((x == null))) && (!((x.cljs$core$IComparable$_compare$arity$2 == null)))){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__6808__auto__ = (((x == null))?null:x);
var m__6809__auto__ = (cljs.core._compare[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(x,y) : m__6809__auto__.call(null,x,y));
} else {
var m__6809__auto____$1 = (cljs.core._compare["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(x,y) : m__6809__auto____$1.call(null,x,y));
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
}
});


/**
 * Protocol for accessing the items of a chunk.
 * @interface
 */
cljs.core.IChunk = function(){};

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunk$_drop_first$arity$1 == null)))){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._drop_first[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._drop_first["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 * @interface
 */
cljs.core.IChunkedSeq = function(){};

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_first$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._chunked_first[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._chunked_first["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1 == null)))){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._chunked_rest[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._chunked_rest["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
}
});


/**
 * Protocol for accessing the chunks of a collection.
 * @interface
 */
cljs.core.IChunkedNext = function(){};

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((!((coll == null))) && (!((coll.cljs$core$IChunkedNext$_chunked_next$arity$1 == null)))){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._chunked_next[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._chunked_next["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
}
});


/**
 * Protocol for adding a name.
 * @interface
 */
cljs.core.INamed = function(){};

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_name$arity$1 == null)))){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__6808__auto__ = (((x == null))?null:x);
var m__6809__auto__ = (cljs.core._name[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto__.call(null,x));
} else {
var m__6809__auto____$1 = (cljs.core._name["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((!((x == null))) && (!((x.cljs$core$INamed$_namespace$arity$1 == null)))){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__6808__auto__ = (((x == null))?null:x);
var m__6809__auto__ = (cljs.core._namespace[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto__.call(null,x));
} else {
var m__6809__auto____$1 = (cljs.core._namespace["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
}
});


/**
 * Marker protocol indicating an atom.
 * @interface
 */
cljs.core.IAtom = function(){};


/**
 * Protocol for adding resetting functionality.
 * @interface
 */
cljs.core.IReset = function(){};

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IReset$_reset_BANG_$arity$2 == null)))){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._reset_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__6809__auto__.call(null,o,new_value));
} else {
var m__6809__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__6809__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
}
});


/**
 * Protocol for adding swapping functionality.
 * @interface
 */
cljs.core.ISwap = function(){};

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function cljs$core$_swap_BANG_(var_args){
var args33317 = [];
var len__7211__auto___33320 = arguments.length;
var i__7212__auto___33321 = (0);
while(true){
if((i__7212__auto___33321 < len__7211__auto___33320)){
args33317.push((arguments[i__7212__auto___33321]));

var G__33322 = (i__7212__auto___33321 + (1));
i__7212__auto___33321 = G__33322;
continue;
} else {
}
break;
}

var G__33319 = args33317.length;
switch (G__33319) {
case 2:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33317.length)].join('')));

}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (o,f){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$2 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(o,f) : m__6809__auto__.call(null,o,f));
} else {
var m__6809__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(o,f) : m__6809__auto____$1.call(null,o,f));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (o,f,a){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$3 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__6809__auto__.call(null,o,f,a));
} else {
var m__6809__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(o,f,a) : m__6809__auto____$1.call(null,o,f,a));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (o,f,a,b){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$4 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__6809__auto__.call(null,o,f,a,b));
} else {
var m__6809__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$4(o,f,a,b) : m__6809__auto____$1.call(null,o,f,a,b));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (o,f,a,b,xs){
if((!((o == null))) && (!((o.cljs$core$ISwap$_swap_BANG_$arity$5 == null)))){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._swap_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$5 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__6809__auto__.call(null,o,f,a,b,xs));
} else {
var m__6809__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$5 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$5(o,f,a,b,xs) : m__6809__auto____$1.call(null,o,f,a,b,xs));
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
}
});

cljs.core._swap_BANG_.cljs$lang$maxFixedArity = 5;


/**
 * Protocol for adding volatile functionality.
 * @interface
 */
cljs.core.IVolatile = function(){};

/**
 * Sets the value of volatile o to new-value without regard for the
 *   current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((!((o == null))) && (!((o.cljs$core$IVolatile$_vreset_BANG_$arity$2 == null)))){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__6808__auto__ = (((o == null))?null:o);
var m__6809__auto__ = (cljs.core._vreset_BANG_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__6809__auto__.call(null,o,new_value));
} else {
var m__6809__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(o,new_value) : m__6809__auto____$1.call(null,o,new_value));
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
}
});


/**
 * Protocol for iterating over a collection.
 * @interface
 */
cljs.core.IIterable = function(){};

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((!((coll == null))) && (!((coll.cljs$core$IIterable$_iterator$arity$1 == null)))){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__6808__auto__ = (((coll == null))?null:coll);
var m__6809__auto__ = (cljs.core._iterator[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto__.call(null,coll));
} else {
var m__6809__auto____$1 = (cljs.core._iterator["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(coll) : m__6809__auto____$1.call(null,coll));
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.IWriter}
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$sb], null);
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!((Math.imul((4294967295),(5)) === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
return Math.imul(a,b);
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
return (h1__$6 ^ (h1__$6 >>> (16)));
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__33324 = (i + (2));
var G__33325 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__33324;
h1 = G__33325;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__33328 = (i + (1));
var G__33329 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__33328;
hash = G__33329;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = {};

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (4194304))) || (o.cljs$core$IHash$))?true:false):false)){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return (Math.floor(o) % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 *   c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(c,x){
return (x instanceof c);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__6141__auto__ = cljs.core.not(a.ns);
if(and__6141__auto__){
return b.ns;
} else {
return and__6141__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__33342 = a.ns;
var G__33343 = b.ns;
return goog.array.defaultCompare(G__33342,G__33343);
})();
if(((0) === nsc)){
var G__33344 = a.name;
var G__33345 = b.name;
return goog.array.defaultCompare(G__33344,G__33345);
} else {
return nsc;
}
}
} else {
var G__33346 = a.name;
var G__33347 = b.name;
return goog.array.defaultCompare(G__33346,G__33347);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.call = (function() {
var G__33349 = null;
var G__33349__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});
var G__33349__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});
G__33349 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__33349__2.call(this,self__,coll);
case 3:
return G__33349__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33349.cljs$core$IFn$_invoke$arity$2 = G__33349__2;
G__33349.cljs$core$IFn$_invoke$arity$3 = G__33349__3;
return G__33349;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args33348){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33348)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$2 ? cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,sym) : cljs.core.get.call(null,coll,sym));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return (cljs.core.get.cljs$core$IFn$_invoke$arity$3 ? cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found) : cljs.core.get.call(null,coll,sym,not_found));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__6588__auto__ = self__._hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$str,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function cljs$core$symbol(var_args){
var args33350 = [];
var len__7211__auto___33353 = arguments.length;
var i__7212__auto___33354 = (0);
while(true){
if((i__7212__auto___33354 < len__7211__auto___33353)){
args33350.push((arguments[i__7212__auto___33354]));

var G__33355 = (i__7212__auto___33354 + (1));
i__7212__auto___33354 = G__33355;
continue;
} else {
}
break;
}

var G__33352 = args33350.length;
switch (G__33352) {
case 1:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33350.length)].join('')));

}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
var idx = name.indexOf("/");
if((idx === (-1))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(null,name);
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$2(name.substring((0),idx),name.substring((idx + (1)),name.length));
}
}
});

cljs.core.symbol.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});

cljs.core.symbol.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IDeref}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2523137;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Var.prototype.isMacro = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).cljs$lang$macro;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Var(self__.val,self__.sym,new_meta));
});

cljs.core.Var.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
if((other instanceof cljs.core.Var)){
var G__33358 = this$__$1.sym;
var G__33359 = other.sym;
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 ? cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(G__33358,G__33359) : cljs.core._EQ_.call(null,G__33358,G__33359));
} else {
return false;
}
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.call = (function() {
var G__33404 = null;
var G__33404__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});
var G__33404__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});
var G__33404__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});
var G__33404__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});
var G__33404__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});
var G__33404__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});
var G__33404__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});
var G__33404__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});
var G__33404__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});
var G__33404__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});
var G__33404__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__33404__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__33404__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__33404__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__33404__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__33404__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__33404__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__33404__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__33404__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__33404__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__33404__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__33404__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__33360 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__33361 = a;
var G__33362 = b;
var G__33363 = c;
var G__33364 = d;
var G__33365 = e;
var G__33366 = f;
var G__33367 = g;
var G__33368 = h;
var G__33369 = i;
var G__33370 = j;
var G__33371 = k;
var G__33372 = l;
var G__33373 = m;
var G__33374 = n;
var G__33375 = o;
var G__33376 = p;
var G__33377 = q;
var G__33378 = r;
var G__33379 = s;
var G__33380 = t;
var G__33381 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__33360,G__33361,G__33362,G__33363,G__33364,G__33365,G__33366,G__33367,G__33368,G__33369,G__33370,G__33371,G__33372,G__33373,G__33374,G__33375,G__33376,G__33377,G__33378,G__33379,G__33380,G__33381) : cljs.core.apply.call(null,G__33360,G__33361,G__33362,G__33363,G__33364,G__33365,G__33366,G__33367,G__33368,G__33369,G__33370,G__33371,G__33372,G__33373,G__33374,G__33375,G__33376,G__33377,G__33378,G__33379,G__33380,G__33381));
});
G__33404 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__33404__1.call(this,self__);
case 2:
return G__33404__2.call(this,self__,a);
case 3:
return G__33404__3.call(this,self__,a,b);
case 4:
return G__33404__4.call(this,self__,a,b,c);
case 5:
return G__33404__5.call(this,self__,a,b,c,d);
case 6:
return G__33404__6.call(this,self__,a,b,c,d,e);
case 7:
return G__33404__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__33404__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__33404__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__33404__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__33404__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__33404__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__33404__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__33404__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__33404__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__33404__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__33404__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__33404__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__33404__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__33404__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__33404__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__33404__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33404.cljs$core$IFn$_invoke$arity$1 = G__33404__1;
G__33404.cljs$core$IFn$_invoke$arity$2 = G__33404__2;
G__33404.cljs$core$IFn$_invoke$arity$3 = G__33404__3;
G__33404.cljs$core$IFn$_invoke$arity$4 = G__33404__4;
G__33404.cljs$core$IFn$_invoke$arity$5 = G__33404__5;
G__33404.cljs$core$IFn$_invoke$arity$6 = G__33404__6;
G__33404.cljs$core$IFn$_invoke$arity$7 = G__33404__7;
G__33404.cljs$core$IFn$_invoke$arity$8 = G__33404__8;
G__33404.cljs$core$IFn$_invoke$arity$9 = G__33404__9;
G__33404.cljs$core$IFn$_invoke$arity$10 = G__33404__10;
G__33404.cljs$core$IFn$_invoke$arity$11 = G__33404__11;
G__33404.cljs$core$IFn$_invoke$arity$12 = G__33404__12;
G__33404.cljs$core$IFn$_invoke$arity$13 = G__33404__13;
G__33404.cljs$core$IFn$_invoke$arity$14 = G__33404__14;
G__33404.cljs$core$IFn$_invoke$arity$15 = G__33404__15;
G__33404.cljs$core$IFn$_invoke$arity$16 = G__33404__16;
G__33404.cljs$core$IFn$_invoke$arity$17 = G__33404__17;
G__33404.cljs$core$IFn$_invoke$arity$18 = G__33404__18;
G__33404.cljs$core$IFn$_invoke$arity$19 = G__33404__19;
G__33404.cljs$core$IFn$_invoke$arity$20 = G__33404__20;
G__33404.cljs$core$IFn$_invoke$arity$21 = G__33404__21;
G__33404.cljs$core$IFn$_invoke$arity$22 = G__33404__22;
return G__33404;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args33357){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33357)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null)).call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__33382 = (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
var G__33383 = a;
var G__33384 = b;
var G__33385 = c;
var G__33386 = d;
var G__33387 = e;
var G__33388 = f;
var G__33389 = g;
var G__33390 = h;
var G__33391 = i;
var G__33392 = j;
var G__33393 = k;
var G__33394 = l;
var G__33395 = m;
var G__33396 = n;
var G__33397 = o;
var G__33398 = p;
var G__33399 = q;
var G__33400 = r;
var G__33401 = s;
var G__33402 = t;
var G__33403 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__33382,G__33383,G__33384,G__33385,G__33386,G__33387,G__33388,G__33389,G__33390,G__33391,G__33392,G__33393,G__33394,G__33395,G__33396,G__33397,G__33398,G__33399,G__33400,G__33401,G__33402,G__33403) : cljs.core.apply.call(null,G__33382,G__33383,G__33384,G__33385,G__33386,G__33387,G__33388,G__33389,G__33390,G__33391,G__33392,G__33393,G__33394,G__33395,G__33396,G__33397,G__33398,G__33399,G__33400,G__33401,G__33402,G__33403));
});

cljs.core.Var.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$sym,cljs.core.cst$sym$_meta], null);
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});

/**
 * Returns true if v is of type cljs.core.Var
 */
cljs.core.var_QMARK_ = (function cljs$core$var_QMARK_(v){
return (v instanceof cljs.core.Var);
});


/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
if(!((x == null))){
if((false) || (x.cljs$core$IIterable$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,x);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
if(!((value == null))){
if(((value.cljs$lang$protocol_mask$partition1$ & (8192))) || (value.cljs$core$ICloneable$)){
return true;
} else {
if((!value.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,value);
}
});
/**
 * Returns a seq on the collection. If the collection is
 *   empty, returns nil.  (seq nil) returns nil. seq also works on
 *   Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || (coll.cljs$core$ISeqable$))?true:false):false)){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 *   argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$))?true:false):false)){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 *   argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$))?true:false):false)){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 *   argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (128))) || (coll.cljs$core$INext$))?true:false):false)){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 *   numbers and collections in a type-independent manner.  Clojure's immutable data
 *   structures define -equiv (and thus =) as a value, not an identity,
 *   comparison.
 */
cljs.core._EQ_ = (function cljs$core$_EQ_(var_args){
var args33417 = [];
var len__7211__auto___33423 = arguments.length;
var i__7212__auto___33424 = (0);
while(true){
if((i__7212__auto___33424 < len__7211__auto___33423)){
args33417.push((arguments[i__7212__auto___33424]));

var G__33425 = (i__7212__auto___33424 + (1));
i__7212__auto___33424 = G__33425;
continue;
} else {
}
break;
}

var G__33422 = args33417.length;
switch (G__33422) {
case 1:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33417.slice((2)),(0)));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});

cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__33427 = y;
var G__33428 = cljs.core.first(more);
var G__33429 = cljs.core.next(more);
x = G__33427;
y = G__33428;
more = G__33429;
continue;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ_.cljs$lang$applyTo = (function (seq33418){
var G__33419 = cljs.core.first(seq33418);
var seq33418__$1 = cljs.core.next(seq33418);
var G__33420 = cljs.core.first(seq33418__$1);
var seq33418__$2 = cljs.core.next(seq33418__$1);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic(G__33419,G__33420,seq33418__$2);
});

cljs.core._EQ_.cljs$lang$maxFixedArity = (2);

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"value": x, "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6Iterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(self__.iter) : cljs.core.es6_iterator_seq.call(null,self__.iter));
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$value,cljs.core.cst$sym$iter,cljs.core.with_meta(cljs.core.cst$sym$_rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__33430 = (n + (1));
var G__33431 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__33432 = cljs.core.next(coll__$1);
n = G__33430;
hash_code = G__33431;
coll__$1 = G__33432;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 *   (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__33433 = (n + (1));
var G__33434 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__33435 = cljs.core.next(coll__$1);
n = G__33433;
hash_code = G__33434;
coll__$1 = G__33435;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});

Date.prototype.cljs$core$IComparable$ = true;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
if((other instanceof Date)){
var G__33436 = this$__$1.valueOf();
var G__33437 = other.valueOf();
return goog.array.defaultCompare(G__33436,G__33437);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(this$__$1),cljs.core.str(" to "),cljs.core.str(other)].join('')));
}
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.Fn["function"] = true);

(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
return goog.getUid(o);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
 * @implements {cljs.core.IDeref}
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val], null);
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function cljs$core$ci_reduce(var_args){
var args33438 = [];
var len__7211__auto___33447 = arguments.length;
var i__7212__auto___33448 = (0);
while(true){
if((i__7212__auto___33448 < len__7211__auto___33447)){
args33438.push((arguments[i__7212__auto___33448]));

var G__33449 = (i__7212__auto___33448 + (1));
i__7212__auto___33448 = G__33449;
continue;
} else {
}
break;
}

var G__33440 = args33438.length;
switch (G__33440) {
case 2:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33438.length)].join('')));

}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__33441 = val;
var G__33442 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33441,G__33442) : f.call(null,G__33441,G__33442));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__33451 = nval;
var G__33452 = (n + (1));
val = G__33451;
n = G__33452;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__33443 = val__$1;
var G__33444 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33443,G__33444) : f.call(null,G__33443,G__33444));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__33453 = nval;
var G__33454 = (n + (1));
val__$1 = G__33453;
n = G__33454;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__33445 = val__$1;
var G__33446 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33445,G__33446) : f.call(null,G__33445,G__33446));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__33455 = nval;
var G__33456 = (n + (1));
val__$1 = G__33455;
n = G__33456;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.ci_reduce.cljs$lang$maxFixedArity = 4;
cljs.core.array_reduce = (function cljs$core$array_reduce(var_args){
var args33457 = [];
var len__7211__auto___33466 = arguments.length;
var i__7212__auto___33467 = (0);
while(true){
if((i__7212__auto___33467 < len__7211__auto___33466)){
args33457.push((arguments[i__7212__auto___33467]));

var G__33468 = (i__7212__auto___33467 + (1));
i__7212__auto___33467 = G__33468;
continue;
} else {
}
break;
}

var G__33459 = args33457.length;
switch (G__33459) {
case 2:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33457.length)].join('')));

}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__33460 = val;
var G__33461 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33460,G__33461) : f.call(null,G__33460,G__33461));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__33470 = nval;
var G__33471 = (n + (1));
val = G__33470;
n = G__33471;
continue;
}
} else {
return val;
}
break;
}
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__33462 = val__$1;
var G__33463 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33462,G__33463) : f.call(null,G__33462,G__33463));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__33472 = nval;
var G__33473 = (n + (1));
val__$1 = G__33472;
n = G__33473;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__33464 = val__$1;
var G__33465 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33464,G__33465) : f.call(null,G__33464,G__33465));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__33474 = nval;
var G__33475 = (n + (1));
val__$1 = G__33474;
n = G__33475;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.array_reduce.cljs$lang$maxFixedArity = 4;



/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (2))) || (x.cljs$core$ICounted$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,x);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16))) || (x.cljs$core$IIndexed$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,x);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IReduce}
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var x__6484__auto__ = (0);
var y__6485__auto__ = (self__.arr.length - self__.i);
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.i < self__.arr.length)){
return this$__$1;
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.IndexedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i], null);
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function cljs$core$prim_seq(var_args){
var args33480 = [];
var len__7211__auto___33483 = arguments.length;
var i__7212__auto___33484 = (0);
while(true){
if((i__7212__auto___33484 < len__7211__auto___33483)){
args33480.push((arguments[i__7212__auto___33484]));

var G__33485 = (i__7212__auto___33484 + (1));
i__7212__auto___33484 = G__33485;
continue;
} else {
}
break;
}

var G__33482 = args33480.length;
switch (G__33482) {
case 1:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33480.length)].join('')));

}
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1 = (function (prim){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});

cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});

cljs.core.prim_seq.cljs$lang$maxFixedArity = 2;
/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function cljs$core$array_seq(var_args){
var args33487 = [];
var len__7211__auto___33490 = arguments.length;
var i__7212__auto___33491 = (0);
while(true){
if((i__7212__auto___33491 < len__7211__auto___33490)){
args33487.push((arguments[i__7212__auto___33491]));

var G__33492 = (i__7212__auto___33491 + (1));
i__7212__auto___33491 = G__33492;
continue;
} else {
}
break;
}

var G__33489 = args33487.length;
switch (G__33489) {
case 1:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33487.length)].join('')));

}
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});

cljs.core.array_seq.cljs$core$IFn$_invoke$arity$2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});

cljs.core.array_seq.cljs$lang$maxFixedArity = 2;


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(coll__$1,other) : cljs.core.equiv_sequential.call(null,coll__$1,other));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__33494 = cljs.core.List.EMPTY;
var G__33495 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__33494,G__33495) : cljs.core.with_meta.call(null,G__33494,G__33495));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,col__$1) : cljs.core.seq_reduce.call(null,f,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,col__$1) : cljs.core.seq_reduce.call(null,f,start,col__$1));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(o,coll__$1) : cljs.core.cons.call(null,o,coll__$1));
});

cljs.core.RSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ci,cljs.core.cst$sym$i,cljs.core.cst$sym$meta], null);
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__33496 = sn;
s = G__33496;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 *   'added'. (conj nil item) returns (item).  The 'addition' may
 *   happen at different 'places' depending on the concrete type.
 */
cljs.core.conj = (function cljs$core$conj(var_args){
var args33497 = [];
var len__7211__auto___33503 = arguments.length;
var i__7212__auto___33504 = (0);
while(true){
if((i__7212__auto___33504 < len__7211__auto___33503)){
args33497.push((arguments[i__7212__auto___33504]));

var G__33505 = (i__7212__auto___33504 + (1));
i__7212__auto___33504 = G__33505;
continue;
} else {
}
break;
}

var G__33502 = args33497.length;
switch (G__33502) {
case 0:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33497.slice((2)),(0)));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});

cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__33507 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__33508 = cljs.core.first(xs);
var G__33509 = cljs.core.next(xs);
coll = G__33507;
x = G__33508;
xs = G__33509;
continue;
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
});

cljs.core.conj.cljs$lang$applyTo = (function (seq33498){
var G__33499 = cljs.core.first(seq33498);
var seq33498__$1 = cljs.core.next(seq33498);
var G__33500 = cljs.core.first(seq33498__$1);
var seq33498__$2 = cljs.core.next(seq33498__$1);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(G__33499,G__33500,seq33498__$2);
});

cljs.core.conj.cljs$lang$maxFixedArity = (2);
/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__33510 = cljs.core.next(s);
var G__33511 = (acc + (1));
s = G__33510;
acc = G__33511;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 *   0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (2))) || (coll.cljs$core$ICounted$))?true:false):false)){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (8388608))) || (coll.cljs$core$ISeqable$))?true:false):false)){
return cljs.core.accumulating_seq_count(coll);
} else {
return cljs.core._count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function cljs$core$linear_traversal_nth(var_args){
var args33516 = [];
var len__7211__auto___33519 = arguments.length;
var i__7212__auto___33520 = (0);
while(true){
if((i__7212__auto___33520 < len__7211__auto___33519)){
args33516.push((arguments[i__7212__auto___33520]));

var G__33521 = (i__7212__auto___33520 + (1));
i__7212__auto___33520 = G__33521;
continue;
} else {
}
break;
}

var G__33518 = args33516.length;
switch (G__33518) {
case 2:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33516.length)].join('')));

}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__33523 = cljs.core.next(coll);
var G__33524 = (n - (1));
coll = G__33523;
n = G__33524;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__33525 = cljs.core.next(coll);
var G__33526 = (n - (1));
var G__33527 = not_found;
coll = G__33525;
n = G__33526;
not_found = G__33527;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});

cljs.core.linear_traversal_nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the value at the index. get returns nil if index out of
 *   bounds, nth throws an exception unless not-found is supplied.  nth
 *   also works for strings, arrays, regex Matchers and Lists, and,
 *   in O(n) time, for sequences.
 */
cljs.core.nth = (function cljs$core$nth(var_args){
var args33528 = [];
var len__7211__auto___33535 = arguments.length;
var i__7212__auto___33536 = (0);
while(true){
if((i__7212__auto___33536 < len__7211__auto___33535)){
args33528.push((arguments[i__7212__auto___33536]));

var G__33537 = (i__7212__auto___33536 + (1));
i__7212__auto___33536 = G__33537;
continue;
} else {
}
break;
}

var G__33530 = args33528.length;
switch (G__33530) {
case 2:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33528.length)].join('')));

}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || (coll.cljs$core$IIndexed$))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return coll.charAt(n);
} else {
return null;
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$core$IFn$_invoke$arity$3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (16))) || (coll.cljs$core$IIndexed$))?true:false):false)){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return coll.charAt(n);
} else {
return not_found;
}
} else {
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$))?true:false):false)){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});

cljs.core.nth.cljs$lang$maxFixedArity = 3;
/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__33539 = (n__$1 - (1));
var G__33540 = cljs.core.rest(xs);
n__$1 = G__33539;
xs = G__33540;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function cljs$core$get(var_args){
var args33541 = [];
var len__7211__auto___33546 = arguments.length;
var i__7212__auto___33547 = (0);
while(true){
if((i__7212__auto___33547 < len__7211__auto___33546)){
args33541.push((arguments[i__7212__auto___33547]));

var G__33548 = (i__7212__auto___33547 + (1));
i__7212__auto___33547 = G__33548;
continue;
} else {
}
break;
}

var G__33543 = args33541.length;
switch (G__33543) {
case 2:
return cljs.core.get.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33541.length)].join('')));

}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$2 = (function (o,k){
if((o == null)){
return null;
} else {
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || (o.cljs$core$ILookup$))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[(k | (0))]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});

cljs.core.get.cljs$core$IFn$_invoke$arity$3 = (function (o,k,not_found){
if(!((o == null))){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (256))) || (o.cljs$core$ILookup$))?true:false):false)){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});

cljs.core.get.cljs$lang$maxFixedArity = 3;
/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 */
cljs.core.assoc = (function cljs$core$assoc(var_args){
var args33550 = [];
var len__7211__auto___33557 = arguments.length;
var i__7212__auto___33558 = (0);
while(true){
if((i__7212__auto___33558 < len__7211__auto___33557)){
args33550.push((arguments[i__7212__auto___33558]));

var G__33559 = (i__7212__auto___33558 + (1));
i__7212__auto___33558 = G__33559;
continue;
} else {
}
break;
}

var G__33556 = args33550.length;
switch (G__33556) {
case 3:
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33550.slice((3)),(0)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});

cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,v,kvs){
while(true){
var ret = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__33561 = ret;
var G__33562 = cljs.core.first(kvs);
var G__33563 = cljs.core.second(kvs);
var G__33564 = cljs.core.nnext(kvs);
coll = G__33561;
k = G__33562;
v = G__33563;
kvs = G__33564;
continue;
} else {
return ret;
}
break;
}
});

cljs.core.assoc.cljs$lang$applyTo = (function (seq33551){
var G__33552 = cljs.core.first(seq33551);
var seq33551__$1 = cljs.core.next(seq33551);
var G__33553 = cljs.core.first(seq33551__$1);
var seq33551__$2 = cljs.core.next(seq33551__$1);
var G__33554 = cljs.core.first(seq33551__$2);
var seq33551__$3 = cljs.core.next(seq33551__$2);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__33552,G__33553,G__33554,seq33551__$3);
});

cljs.core.assoc.cljs$lang$maxFixedArity = (3);
/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 *   that does not contain a mapping for key(s).
 */
cljs.core.dissoc = (function cljs$core$dissoc(var_args){
var args33565 = [];
var len__7211__auto___33571 = arguments.length;
var i__7212__auto___33572 = (0);
while(true){
if((i__7212__auto___33572 < len__7211__auto___33571)){
args33565.push((arguments[i__7212__auto___33572]));

var G__33573 = (i__7212__auto___33572 + (1));
i__7212__auto___33572 = G__33573;
continue;
} else {
}
break;
}

var G__33570 = args33565.length;
switch (G__33570) {
case 1:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33565.slice((2)),(0)));
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});

cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__33575 = ret;
var G__33576 = cljs.core.first(ks);
var G__33577 = cljs.core.next(ks);
coll = G__33575;
k = G__33576;
ks = G__33577;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.dissoc.cljs$lang$applyTo = (function (seq33566){
var G__33567 = cljs.core.first(seq33566);
var seq33566__$1 = cljs.core.next(seq33566);
var G__33568 = cljs.core.first(seq33566__$1);
var seq33566__$2 = cljs.core.next(seq33566__$1);
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__33567,G__33568,seq33566__$2);
});

cljs.core.dissoc.cljs$lang$maxFixedArity = (2);
/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__6153__auto__ = goog.isFunction(f);
if(or__6153__auto__){
return or__6153__auto__;
} else {
if(!((f == null))){
if((false) || (f.cljs$core$Fn$)){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,f);
}
}
});

/**
* @constructor
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.Fn}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 393217;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.call = (function() {
var G__33583 = null;
var G__33583__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__33583__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});
var G__33583__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});
var G__33583__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});
var G__33583__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});
var G__33583__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});
var G__33583__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});
var G__33583__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});
var G__33583__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});
var G__33583__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});
var G__33583__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});
var G__33583__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});
var G__33583__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});
var G__33583__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});
var G__33583__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});
var G__33583__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});
var G__33583__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});
var G__33583__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});
var G__33583__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});
var G__33583__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});
var G__33583__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});
var G__33583__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});
G__33583 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__33583__1.call(this,self__);
case 2:
return G__33583__2.call(this,self__,a);
case 3:
return G__33583__3.call(this,self__,a,b);
case 4:
return G__33583__4.call(this,self__,a,b,c);
case 5:
return G__33583__5.call(this,self__,a,b,c,d);
case 6:
return G__33583__6.call(this,self__,a,b,c,d,e);
case 7:
return G__33583__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__33583__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__33583__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__33583__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__33583__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__33583__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__33583__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__33583__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__33583__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__33583__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__33583__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__33583__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__33583__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__33583__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__33583__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__33583__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33583.cljs$core$IFn$_invoke$arity$1 = G__33583__1;
G__33583.cljs$core$IFn$_invoke$arity$2 = G__33583__2;
G__33583.cljs$core$IFn$_invoke$arity$3 = G__33583__3;
G__33583.cljs$core$IFn$_invoke$arity$4 = G__33583__4;
G__33583.cljs$core$IFn$_invoke$arity$5 = G__33583__5;
G__33583.cljs$core$IFn$_invoke$arity$6 = G__33583__6;
G__33583.cljs$core$IFn$_invoke$arity$7 = G__33583__7;
G__33583.cljs$core$IFn$_invoke$arity$8 = G__33583__8;
G__33583.cljs$core$IFn$_invoke$arity$9 = G__33583__9;
G__33583.cljs$core$IFn$_invoke$arity$10 = G__33583__10;
G__33583.cljs$core$IFn$_invoke$arity$11 = G__33583__11;
G__33583.cljs$core$IFn$_invoke$arity$12 = G__33583__12;
G__33583.cljs$core$IFn$_invoke$arity$13 = G__33583__13;
G__33583.cljs$core$IFn$_invoke$arity$14 = G__33583__14;
G__33583.cljs$core$IFn$_invoke$arity$15 = G__33583__15;
G__33583.cljs$core$IFn$_invoke$arity$16 = G__33583__16;
G__33583.cljs$core$IFn$_invoke$arity$17 = G__33583__17;
G__33583.cljs$core$IFn$_invoke$arity$18 = G__33583__18;
G__33583.cljs$core$IFn$_invoke$arity$19 = G__33583__19;
G__33583.cljs$core$IFn$_invoke$arity$20 = G__33583__20;
G__33583.cljs$core$IFn$_invoke$arity$21 = G__33583__21;
G__33583.cljs$core$IFn$_invoke$arity$22 = G__33583__22;
return G__33583;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args33582){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args33582)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(a) : self__.afn.call(null,a));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(a,b) : self__.afn.call(null,a,b));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(a,b,c) : self__.afn.call(null,a,b,c));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(a,b,c,d) : self__.afn.call(null,a,b,c,d));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(a,b,c,d,e) : self__.afn.call(null,a,b,c,d,e));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(a,b,c,d,e,f) : self__.afn.call(null,a,b,c,d,e,f));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(a,b,c,d,e,f,g) : self__.afn.call(null,a,b,c,d,e,f,g));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(a,b,c,d,e,f,g,h) : self__.afn.call(null,a,b,c,d,e,f,g,h));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(a,b,c,d,e,f,g,h,i) : self__.afn.call(null,a,b,c,d,e,f,g,h,i));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(a,b,c,d,e,f,g,h,i,j) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(a,b,c,d,e,f,g,h,i,j,k) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(a,b,c,d,e,f,g,h,i,j,k,l) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(a,b,c,d,e,f,g,h,i,j,k,l,m) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(a,b,c,d,e,f,g,h,i,j,k,l,m,n) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t) : self__.afn.call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest) : cljs.core.apply.call(null,self__.afn,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest));
});

cljs.core.MetaFn.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta], null);
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 *   map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if(goog.isFunction(o)){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__6141__auto__ = !((o == null));
if(and__6141__auto__){
if(!((o == null))){
if(((o.cljs$lang$protocol_mask$partition0$ & (131072))) || (o.cljs$core$IMeta$)){
return true;
} else {
if((!o.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,o);
}
} else {
return and__6141__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 *   more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 *   item, for a vector, returns a new vector without the last item.
 *   Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj = (function cljs$core$disj(var_args){
var args33588 = [];
var len__7211__auto___33594 = arguments.length;
var i__7212__auto___33595 = (0);
while(true){
if((i__7212__auto___33595 < len__7211__auto___33594)){
args33588.push((arguments[i__7212__auto___33595]));

var G__33596 = (i__7212__auto___33595 + (1));
i__7212__auto___33595 = G__33596;
continue;
} else {
}
break;
}

var G__33593 = args33588.length;
switch (G__33593) {
case 1:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33588.slice((2)),(0)));
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});

cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic = (function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__33598 = ret;
var G__33599 = cljs.core.first(ks);
var G__33600 = cljs.core.next(ks);
coll = G__33598;
k = G__33599;
ks = G__33600;
continue;
} else {
return ret;
}
}
break;
}
});

cljs.core.disj.cljs$lang$applyTo = (function (seq33589){
var G__33590 = cljs.core.first(seq33589);
var seq33589__$1 = cljs.core.next(seq33589);
var G__33591 = cljs.core.first(seq33589__$1);
var seq33589__$2 = cljs.core.next(seq33589__$1);
return cljs.core.disj.cljs$core$IFn$_invoke$arity$variadic(G__33590,G__33591,seq33589__$2);
});

cljs.core.disj.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if coll has no items - same as (not (seq coll)).
 *   Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (8))) || (x.cljs$core$ICollection$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,x);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (4096))) || (x.cljs$core$ISet$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,x);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (512))) || (x.cljs$core$IAssociative$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,x);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16777216))) || (x.cljs$core$ISequential$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,x);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (268435456))) || (x.cljs$core$ISorted$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,x);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (524288))) || (x.cljs$core$IReduce$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,x);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (1024))) || (x.cljs$core$IMap$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,x);
}
}
});
/**
 * Return true if x satisfies IRecord
 */
cljs.core.record_QMARK_ = (function cljs$core$record_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (67108864))) || (x.cljs$core$IRecord$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IRecord,x);
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (16384))) || (x.cljs$core$IVector$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,x);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition1$ & (512))) || (x.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 *   interleaved keys and values.
 */
cljs.core.js_obj = (function cljs$core$js_obj(var_args){
var args33621 = [];
var len__7211__auto___33627 = arguments.length;
var i__7212__auto___33628 = (0);
while(true){
if((i__7212__auto___33628 < len__7211__auto___33627)){
args33621.push((arguments[i__7212__auto___33628]));

var G__33629 = (i__7212__auto___33628 + (1));
i__7212__auto___33628 = G__33629;
continue;
} else {
}
break;
}

var G__33624 = args33621.length;
switch (G__33624) {
case 0:
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33621.slice((0)),(0)));
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(argseq__7230__auto__);

}
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$0 = (function (){
return {};
});

cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(goog.object.create,keyvals) : cljs.core.apply.call(null,goog.object.create,keyvals));
});

cljs.core.js_obj.cljs$lang$applyTo = (function (seq33622){
return cljs.core.js_obj.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33622));
});

cljs.core.js_obj.cljs$lang$maxFixedArity = (0);
/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__33633_33635 = obj;
var G__33634_33636 = ((function (G__33633_33635,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__33633_33635,keys))
;
goog.object.forEach(G__33633_33635,G__33634_33636);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__33637 = (i__$1 + (1));
var G__33638 = (j__$1 + (1));
var G__33639 = (len__$1 - (1));
i__$1 = G__33637;
j__$1 = G__33638;
len__$1 = G__33639;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__33640 = (i__$1 - (1));
var G__33641 = (j__$1 - (1));
var G__33642 = (len__$1 - (1));
i__$1 = G__33640;
j__$1 = G__33641;
len__$1 = G__33642;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = {};
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (64))) || (s.cljs$core$ISeq$)){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,s);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
if(!((s == null))){
if(((s.cljs$lang$protocol_mask$partition0$ & (8388608))) || (s.cljs$core$ISeqable$)){
return true;
} else {
if((!s.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,s);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if((x == null)){
return false;
} else {
if(x === false){
return false;
} else {
return true;

}
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__6153__auto__ = cljs.core.fn_QMARK_(f);
if(or__6153__auto__){
return or__6153__auto__;
} else {
if(!((f == null))){
if(((f.cljs$lang$protocol_mask$partition0$ & (1))) || (f.cljs$core$IFn$)){
return true;
} else {
if((!f.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,f);
}
}
});
/**
 * Returns true if n is an integer.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (!(isNaN(n))) && (!((n === Infinity))) && ((parseFloat(n) === parseInt(n,(10))));
});
/**
 * Returns true if key is present in the given collection, otherwise
 *   returns false.  Note that for numerically indexed collections like
 *   vectors and arrays, this tests if the numeric key is within the
 *   range of indexes. 'contains?' operates constant or logarithmic time;
 *   it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 */
cljs.core.distinct_QMARK_ = (function cljs$core$distinct_QMARK_(var_args){
var args33653 = [];
var len__7211__auto___33659 = arguments.length;
var i__7212__auto___33660 = (0);
while(true){
if((i__7212__auto___33660 < len__7211__auto___33659)){
args33653.push((arguments[i__7212__auto___33660]));

var G__33661 = (i__7212__auto___33660 + (1));
i__7212__auto___33660 = G__33661;
continue;
} else {
}
break;
}

var G__33658 = args33653.length;
switch (G__33658) {
case 1:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33653.slice((2)),(0)));
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__33663 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__33664 = etc;
s = G__33663;
xs = G__33664;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
});

cljs.core.distinct_QMARK_.cljs$lang$applyTo = (function (seq33654){
var G__33655 = cljs.core.first(seq33654);
var seq33654__$1 = cljs.core.next(seq33654);
var G__33656 = cljs.core.first(seq33654__$1);
var seq33654__$2 = cljs.core.next(seq33654__$1);
return cljs.core.distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic(G__33655,G__33656,seq33654__$2);
});

cljs.core.distinct_QMARK_.cljs$lang$maxFixedArity = (2);
/**
 * Comparator. Returns a negative number, zero, or a positive number
 *   when x is logically 'less than', 'equal to', or 'greater than'
 *   y. Uses IComparable if available and google.array.defaultCompare for objects
 *  of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if(typeof x === 'number'){
if(typeof y === 'number'){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
} else {
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (2048))) || (x.cljs$core$IComparable$))?true:(((!x.cljs$lang$protocol_mask$partition1$))?cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IComparable,x))){
return cljs.core._compare(x,y);
} else {
if(((typeof x === 'string') || (cljs.core.array_QMARK_(x)) || (x === true) || (x === false)) && ((cljs.core.type(x) === cljs.core.type(y)))){
return goog.array.defaultCompare(x,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}

}
}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function cljs$core$compare_indexed(var_args){
var args33667 = [];
var len__7211__auto___33670 = arguments.length;
var i__7212__auto___33671 = (0);
while(true){
if((i__7212__auto___33671 < len__7211__auto___33670)){
args33667.push((arguments[i__7212__auto___33671]));

var G__33672 = (i__7212__auto___33671 + (1));
i__7212__auto___33671 = G__33672;
continue;
} else {
}
break;
}

var G__33669 = args33667.length;
switch (G__33669) {
case 2:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33667.length)].join('')));

}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
if((xl === (0))){
return (0);
} else {
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
}
});

cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__33674 = xs;
var G__33675 = ys;
var G__33676 = len;
var G__33677 = (n + (1));
xs = G__33674;
ys = G__33675;
len = G__33676;
n = G__33677;
continue;
} else {
return d;
}
break;
}
});

cljs.core.compare_indexed.cljs$lang$maxFixedArity = 4;
/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(y,x) : f.call(null,y,x)))){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function cljs$core$sort(var_args){
var args33678 = [];
var len__7211__auto___33683 = arguments.length;
var i__7212__auto___33684 = (0);
while(true){
if((i__7212__auto___33684 < len__7211__auto___33683)){
args33678.push((arguments[i__7212__auto___33684]));

var G__33685 = (i__7212__auto___33684 + (1));
i__7212__auto___33684 = G__33685;
continue;
} else {
}
break;
}

var G__33680 = args33678.length;
switch (G__33680) {
case 1:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33678.length)].join('')));

}
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});

cljs.core.sort.cljs$core$IFn$_invoke$arity$2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
var G__33681_33687 = a;
var G__33682_33688 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__33681_33687,G__33682_33688);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.sort.cljs$lang$maxFixedArity = 2;
/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function cljs$core$sort_by(var_args){
var args33689 = [];
var len__7211__auto___33692 = arguments.length;
var i__7212__auto___33693 = (0);
while(true){
if((i__7212__auto___33693 < len__7211__auto___33692)){
args33689.push((arguments[i__7212__auto___33693]));

var G__33694 = (i__7212__auto___33693 + (1));
i__7212__auto___33693 = G__33694;
continue;
} else {
}
break;
}

var G__33691 = args33689.length;
switch (G__33691) {
case 2:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33689.length)].join('')));

}
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,coll){
return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});

cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(x) : keyfn.call(null,x)),(keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(y) : keyfn.call(null,y)));
}),coll);
});

cljs.core.sort_by.cljs$lang$maxFixedArity = 3;
cljs.core.seq_reduce = (function cljs$core$seq_reduce(var_args){
var args33696 = [];
var len__7211__auto___33704 = arguments.length;
var i__7212__auto___33705 = (0);
while(true){
if((i__7212__auto___33705 < len__7211__auto___33704)){
args33696.push((arguments[i__7212__auto___33705]));

var G__33706 = (i__7212__auto___33705 + (1));
i__7212__auto___33705 = G__33706;
continue;
} else {
}
break;
}

var G__33698 = args33696.length;
switch (G__33698) {
case 2:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33696.length)].join('')));

}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var s = temp__4655__auto__;
var G__33699 = f;
var G__33700 = cljs.core.first(s);
var G__33701 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__33699,G__33700,G__33701) : cljs.core.reduce.call(null,G__33699,G__33700,G__33701));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});

cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__33702 = val__$1;
var G__33703 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33702,G__33703) : f.call(null,G__33702,G__33703));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__33708 = nval;
var G__33709 = cljs.core.next(coll__$1);
val__$1 = G__33708;
coll__$1 = G__33709;
continue;
}
} else {
return val__$1;
}
break;
}
});

cljs.core.seq_reduce.cljs$lang$maxFixedArity = 3;
/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.to_array.call(null,coll));
goog.array.shuffle(a);

return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(a) : cljs.core.vec.call(null,a));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 *   returns the result of applying f to the first 2 items in coll, then
 *   applying f to that result and the 3rd item, etc. If coll contains no
 *   items, f must accept no arguments as well, and reduce returns the
 *   result of calling f with no arguments.  If coll has only 1 item, it
 *   is returned and f is not called.  If val is supplied, returns the
 *   result of applying f to val and the first item in coll, then
 *   applying f to that result and the 2nd item, etc. If coll contains no
 *   items, returns val and f is not called.
 */
cljs.core.reduce = (function cljs$core$reduce(var_args){
var args33710 = [];
var len__7211__auto___33715 = arguments.length;
var i__7212__auto___33716 = (0);
while(true){
if((i__7212__auto___33716 < len__7211__auto___33715)){
args33710.push((arguments[i__7212__auto___33716]));

var G__33717 = (i__7212__auto___33716 + (1));
i__7212__auto___33716 = G__33717;
continue;
} else {
}
break;
}

var G__33712 = args33710.length;
switch (G__33712) {
case 2:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33710.length)].join('')));

}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || (coll.cljs$core$IReduce$))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 = (function (f,val,coll){
if(((!((coll == null)))?((((coll.cljs$lang$protocol_mask$partition0$ & (524288))) || (coll.cljs$core$IReduce$))?true:false):false)){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});

cljs.core.reduce.cljs$lang$maxFixedArity = 3;
/**
 * Reduces an associative collection. f should be a function of 3
 *   arguments. Returns the result of applying f to init, the first key
 *   and the first value in coll, then applying f to that result and the
 *   2nd key and value, etc. If coll contains no entries, returns init
 *   and f is not called. Note that reduce-kv is supported on vectors,
 *   where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 *   transduce by adding an arity-1 signature that calls cf (default -
 *   identity) on the result argument.
 */
cljs.core.completing = (function cljs$core$completing(var_args){
var args33719 = [];
var len__7211__auto___33722 = arguments.length;
var i__7212__auto___33723 = (0);
while(true){
if((i__7212__auto___33723 < len__7211__auto___33722)){
args33719.push((arguments[i__7212__auto___33723]));

var G__33724 = (i__7212__auto___33723 + (1));
i__7212__auto___33723 = G__33724;
continue;
} else {
}
break;
}

var G__33721 = args33719.length;
switch (G__33721) {
case 1:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33719.length)].join('')));

}
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});

cljs.core.completing.cljs$core$IFn$_invoke$arity$2 = (function (f,cf){
return (function() {
var G__33726 = null;
var G__33726__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__33726__1 = (function (x){
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(x) : cf.call(null,x));
});
var G__33726__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y));
});
G__33726 = function(x,y){
switch(arguments.length){
case 0:
return G__33726__0.call(this);
case 1:
return G__33726__1.call(this,x);
case 2:
return G__33726__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33726.cljs$core$IFn$_invoke$arity$0 = G__33726__0;
G__33726.cljs$core$IFn$_invoke$arity$1 = G__33726__1;
G__33726.cljs$core$IFn$_invoke$arity$2 = G__33726__2;
return G__33726;
})()
});

cljs.core.completing.cljs$lang$maxFixedArity = 2;
/**
 * reduce with a transformation of f (xf). If init is not
 *   supplied, (f) will be called to produce it. f should be a reducing
 *   step function that accepts both 1 and 2 arguments, if it accepts
 *   only 2 you can add the arity-1 with 'completing'. Returns the result
 *   of applying (the transformed) xf to init and the first item in coll,
 *   then applying xf to that result and the 2nd item, etc. If coll
 *   contains no items, returns init and f is not called. Note that
 *   certain transforms may inject or skip items.
 */
cljs.core.transduce = (function cljs$core$transduce(var_args){
var args33727 = [];
var len__7211__auto___33730 = arguments.length;
var i__7212__auto___33731 = (0);
while(true){
if((i__7212__auto___33731 < len__7211__auto___33730)){
args33727.push((arguments[i__7212__auto___33731]));

var G__33732 = (i__7212__auto___33731 + (1));
i__7212__auto___33731 = G__33732;
continue;
} else {
}
break;
}

var G__33729 = args33727.length;
switch (G__33729) {
case 3:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33727.length)].join('')));

}
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$3 = (function (xform,f,coll){
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),coll);
});

cljs.core.transduce.cljs$core$IFn$_invoke$arity$4 = (function (xform,f,init,coll){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(ret) : f__$1.call(null,ret));
});

cljs.core.transduce.cljs$lang$maxFixedArity = 4;
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core._PLUS_ = (function cljs$core$_PLUS_(var_args){
var args33734 = [];
var len__7211__auto___33740 = arguments.length;
var i__7212__auto___33741 = (0);
while(true){
if((i__7212__auto___33741 < len__7211__auto___33740)){
args33734.push((arguments[i__7212__auto___33741]));

var G__33742 = (i__7212__auto___33741 + (1));
i__7212__auto___33741 = G__33742;
continue;
} else {
}
break;
}

var G__33739 = args33734.length;
switch (G__33739) {
case 0:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33734.slice((2)),(0)));
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(x + y),more);
});

cljs.core._PLUS_.cljs$lang$applyTo = (function (seq33735){
var G__33736 = cljs.core.first(seq33735);
var seq33735__$1 = cljs.core.next(seq33735);
var G__33737 = cljs.core.first(seq33735__$1);
var seq33735__$2 = cljs.core.next(seq33735__$1);
return cljs.core._PLUS_.cljs$core$IFn$_invoke$arity$variadic(G__33736,G__33737,seq33735__$2);
});

cljs.core._PLUS_.cljs$lang$maxFixedArity = (2);
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core._ = (function cljs$core$_(var_args){
var args33744 = [];
var len__7211__auto___33750 = arguments.length;
var i__7212__auto___33751 = (0);
while(true){
if((i__7212__auto___33751 < len__7211__auto___33750)){
args33744.push((arguments[i__7212__auto___33751]));

var G__33752 = (i__7212__auto___33751 + (1));
i__7212__auto___33751 = G__33752;
continue;
} else {
}
break;
}

var G__33749 = args33744.length;
switch (G__33749) {
case 1:
return cljs.core._.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33744.slice((2)),(0)));
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core._.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core._.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._,(x - y),more);
});

cljs.core._.cljs$lang$applyTo = (function (seq33745){
var G__33746 = cljs.core.first(seq33745);
var seq33745__$1 = cljs.core.next(seq33745);
var G__33747 = cljs.core.first(seq33745__$1);
var seq33745__$2 = cljs.core.next(seq33745__$1);
return cljs.core._.cljs$core$IFn$_invoke$arity$variadic(G__33746,G__33747,seq33745__$2);
});

cljs.core._.cljs$lang$maxFixedArity = (2);
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core._STAR_ = (function cljs$core$_STAR_(var_args){
var args33754 = [];
var len__7211__auto___33760 = arguments.length;
var i__7212__auto___33761 = (0);
while(true){
if((i__7212__auto___33761 < len__7211__auto___33760)){
args33754.push((arguments[i__7212__auto___33761]));

var G__33762 = (i__7212__auto___33761 + (1));
i__7212__auto___33761 = G__33762;
continue;
} else {
}
break;
}

var G__33759 = args33754.length;
switch (G__33759) {
case 0:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33754.slice((2)),(0)));
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,(x * y),more);
});

cljs.core._STAR_.cljs$lang$applyTo = (function (seq33755){
var G__33756 = cljs.core.first(seq33755);
var seq33755__$1 = cljs.core.next(seq33755);
var G__33757 = cljs.core.first(seq33755__$1);
var seq33755__$2 = cljs.core.next(seq33755__$1);
return cljs.core._STAR_.cljs$core$IFn$_invoke$arity$variadic(G__33756,G__33757,seq33755__$2);
});

cljs.core._STAR_.cljs$lang$maxFixedArity = (2);
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core._SLASH_ = (function cljs$core$_SLASH_(var_args){
var args33764 = [];
var len__7211__auto___33770 = arguments.length;
var i__7212__auto___33771 = (0);
while(true){
if((i__7212__auto___33771 < len__7211__auto___33770)){
args33764.push((arguments[i__7212__auto___33771]));

var G__33772 = (i__7212__auto___33771 + (1));
i__7212__auto___33771 = G__33772;
continue;
} else {
}
break;
}

var G__33769 = args33764.length;
switch (G__33769) {
case 1:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33764.slice((2)),(0)));
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._SLASH_,(x / y),more);
});

cljs.core._SLASH_.cljs$lang$applyTo = (function (seq33765){
var G__33766 = cljs.core.first(seq33765);
var seq33765__$1 = cljs.core.next(seq33765);
var G__33767 = cljs.core.first(seq33765__$1);
var seq33765__$2 = cljs.core.next(seq33765__$1);
return cljs.core._SLASH_.cljs$core$IFn$_invoke$arity$variadic(G__33766,G__33767,seq33765__$2);
});

cljs.core._SLASH_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically increasing order,
 *   otherwise false.
 */
cljs.core._LT_ = (function cljs$core$_LT_(var_args){
var args33774 = [];
var len__7211__auto___33780 = arguments.length;
var i__7212__auto___33781 = (0);
while(true){
if((i__7212__auto___33781 < len__7211__auto___33780)){
args33774.push((arguments[i__7212__auto___33781]));

var G__33782 = (i__7212__auto___33781 + (1));
i__7212__auto___33781 = G__33782;
continue;
} else {
}
break;
}

var G__33779 = args33774.length;
switch (G__33779) {
case 1:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33774.slice((2)),(0)));
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x < y);
});

cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__33784 = y;
var G__33785 = cljs.core.first(more);
var G__33786 = cljs.core.next(more);
x = G__33784;
y = G__33785;
more = G__33786;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT_.cljs$lang$applyTo = (function (seq33775){
var G__33776 = cljs.core.first(seq33775);
var seq33775__$1 = cljs.core.next(seq33775);
var G__33777 = cljs.core.first(seq33775__$1);
var seq33775__$2 = cljs.core.next(seq33775__$1);
return cljs.core._LT_.cljs$core$IFn$_invoke$arity$variadic(G__33776,G__33777,seq33775__$2);
});

cljs.core._LT_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 *   otherwise false.
 */
cljs.core._LT__EQ_ = (function cljs$core$_LT__EQ_(var_args){
var args33787 = [];
var len__7211__auto___33793 = arguments.length;
var i__7212__auto___33794 = (0);
while(true){
if((i__7212__auto___33794 < len__7211__auto___33793)){
args33787.push((arguments[i__7212__auto___33794]));

var G__33795 = (i__7212__auto___33794 + (1));
i__7212__auto___33794 = G__33795;
continue;
} else {
}
break;
}

var G__33792 = args33787.length;
switch (G__33792) {
case 1:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33787.slice((2)),(0)));
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x <= y);
});

cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__33797 = y;
var G__33798 = cljs.core.first(more);
var G__33799 = cljs.core.next(more);
x = G__33797;
y = G__33798;
more = G__33799;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._LT__EQ_.cljs$lang$applyTo = (function (seq33788){
var G__33789 = cljs.core.first(seq33788);
var seq33788__$1 = cljs.core.next(seq33788);
var G__33790 = cljs.core.first(seq33788__$1);
var seq33788__$2 = cljs.core.next(seq33788__$1);
return cljs.core._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__33789,G__33790,seq33788__$2);
});

cljs.core._LT__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically decreasing order,
 *   otherwise false.
 */
cljs.core._GT_ = (function cljs$core$_GT_(var_args){
var args33800 = [];
var len__7211__auto___33806 = arguments.length;
var i__7212__auto___33807 = (0);
while(true){
if((i__7212__auto___33807 < len__7211__auto___33806)){
args33800.push((arguments[i__7212__auto___33807]));

var G__33808 = (i__7212__auto___33807 + (1));
i__7212__auto___33807 = G__33808;
continue;
} else {
}
break;
}

var G__33805 = args33800.length;
switch (G__33805) {
case 1:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33800.slice((2)),(0)));
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x > y);
});

cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__33810 = y;
var G__33811 = cljs.core.first(more);
var G__33812 = cljs.core.next(more);
x = G__33810;
y = G__33811;
more = G__33812;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT_.cljs$lang$applyTo = (function (seq33801){
var G__33802 = cljs.core.first(seq33801);
var seq33801__$1 = cljs.core.next(seq33801);
var G__33803 = cljs.core.first(seq33801__$1);
var seq33801__$2 = cljs.core.next(seq33801__$1);
return cljs.core._GT_.cljs$core$IFn$_invoke$arity$variadic(G__33802,G__33803,seq33801__$2);
});

cljs.core._GT_.cljs$lang$maxFixedArity = (2);
/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 *   otherwise false.
 */
cljs.core._GT__EQ_ = (function cljs$core$_GT__EQ_(var_args){
var args33813 = [];
var len__7211__auto___33819 = arguments.length;
var i__7212__auto___33820 = (0);
while(true){
if((i__7212__auto___33820 < len__7211__auto___33819)){
args33813.push((arguments[i__7212__auto___33820]));

var G__33821 = (i__7212__auto___33820 + (1));
i__7212__auto___33820 = G__33821;
continue;
} else {
}
break;
}

var G__33818 = args33813.length;
switch (G__33818) {
case 1:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33813.slice((2)),(0)));
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x >= y);
});

cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__33823 = y;
var G__33824 = cljs.core.first(more);
var G__33825 = cljs.core.next(more);
x = G__33823;
y = G__33824;
more = G__33825;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._GT__EQ_.cljs$lang$applyTo = (function (seq33814){
var G__33815 = cljs.core.first(seq33814);
var seq33814__$1 = cljs.core.next(seq33814);
var G__33816 = cljs.core.first(seq33814__$1);
var seq33814__$2 = cljs.core.next(seq33814__$1);
return cljs.core._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__33815,G__33816,seq33814__$2);
});

cljs.core._GT__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 */
cljs.core.max = (function cljs$core$max(var_args){
var args33826 = [];
var len__7211__auto___33832 = arguments.length;
var i__7212__auto___33833 = (0);
while(true){
if((i__7212__auto___33833 < len__7211__auto___33832)){
args33826.push((arguments[i__7212__auto___33833]));

var G__33834 = (i__7212__auto___33833 + (1));
i__7212__auto___33833 = G__33834;
continue;
} else {
}
break;
}

var G__33831 = args33826.length;
switch (G__33831) {
case 1:
return cljs.core.max.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.max.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33826.slice((2)),(0)));
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.max.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.max.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__6484__auto__ = x;
var y__6485__auto__ = y;
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
});

cljs.core.max.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(function (){var x__6484__auto__ = x;
var y__6485__auto__ = y;
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})(),more);
});

cljs.core.max.cljs$lang$applyTo = (function (seq33827){
var G__33828 = cljs.core.first(seq33827);
var seq33827__$1 = cljs.core.next(seq33827);
var G__33829 = cljs.core.first(seq33827__$1);
var seq33827__$2 = cljs.core.next(seq33827__$1);
return cljs.core.max.cljs$core$IFn$_invoke$arity$variadic(G__33828,G__33829,seq33827__$2);
});

cljs.core.max.cljs$lang$maxFixedArity = (2);
/**
 * Returns the least of the nums.
 */
cljs.core.min = (function cljs$core$min(var_args){
var args33836 = [];
var len__7211__auto___33842 = arguments.length;
var i__7212__auto___33843 = (0);
while(true){
if((i__7212__auto___33843 < len__7211__auto___33842)){
args33836.push((arguments[i__7212__auto___33843]));

var G__33844 = (i__7212__auto___33843 + (1));
i__7212__auto___33843 = G__33844;
continue;
} else {
}
break;
}

var G__33841 = args33836.length;
switch (G__33841) {
case 1:
return cljs.core.min.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.min.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33836.slice((2)),(0)));
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.min.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.min.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
var x__6491__auto__ = x;
var y__6492__auto__ = y;
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
});

cljs.core.min.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.min,(function (){var x__6491__auto__ = x;
var y__6492__auto__ = y;
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
})(),more);
});

cljs.core.min.cljs$lang$applyTo = (function (seq33837){
var G__33838 = cljs.core.first(seq33837);
var seq33837__$1 = cljs.core.next(seq33837);
var G__33839 = cljs.core.first(seq33837__$1);
var seq33837__$2 = cljs.core.next(seq33837__$1);
return cljs.core.min.cljs$core$IFn$_invoke$arity$variadic(G__33838,G__33839,seq33837__$2);
});

cljs.core.min.cljs$lang$maxFixedArity = (2);
cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add = (function cljs$core$unchecked_add(var_args){
var args33846 = [];
var len__7211__auto___33852 = arguments.length;
var i__7212__auto___33853 = (0);
while(true){
if((i__7212__auto___33853 < len__7211__auto___33852)){
args33846.push((arguments[i__7212__auto___33853]));

var G__33854 = (i__7212__auto___33853 + (1));
i__7212__auto___33853 = G__33854;
continue;
} else {
}
break;
}

var G__33851 = args33846.length;
switch (G__33851) {
case 0:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33846.slice((2)),(0)));
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add,(x + y),more);
});

cljs.core.unchecked_add.cljs$lang$applyTo = (function (seq33847){
var G__33848 = cljs.core.first(seq33847);
var seq33847__$1 = cljs.core.next(seq33847);
var G__33849 = cljs.core.first(seq33847__$1);
var seq33847__$2 = cljs.core.next(seq33847__$1);
return cljs.core.unchecked_add.cljs$core$IFn$_invoke$arity$variadic(G__33848,G__33849,seq33847__$2);
});

cljs.core.unchecked_add.cljs$lang$maxFixedArity = (2);
/**
 * Returns the sum of nums. (+) returns 0.
 */
cljs.core.unchecked_add_int = (function cljs$core$unchecked_add_int(var_args){
var args33856 = [];
var len__7211__auto___33862 = arguments.length;
var i__7212__auto___33863 = (0);
while(true){
if((i__7212__auto___33863 < len__7211__auto___33862)){
args33856.push((arguments[i__7212__auto___33863]));

var G__33864 = (i__7212__auto___33863 + (1));
i__7212__auto___33863 = G__33864;
continue;
} else {
}
break;
}

var G__33861 = args33856.length;
switch (G__33861) {
case 0:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33856.slice((2)),(0)));
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (0);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x + y);
});

cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_add_int,(x + y),more);
});

cljs.core.unchecked_add_int.cljs$lang$applyTo = (function (seq33857){
var G__33858 = cljs.core.first(seq33857);
var seq33857__$1 = cljs.core.next(seq33857);
var G__33859 = cljs.core.first(seq33857__$1);
var seq33857__$2 = cljs.core.next(seq33857__$1);
return cljs.core.unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic(G__33858,G__33859,seq33857__$2);
});

cljs.core.unchecked_add_int.cljs$lang$maxFixedArity = (2);
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 *   else returns numerator divided by all of the denominators.
 */
cljs.core.unchecked_divide_int = (function cljs$core$unchecked_divide_int(var_args){
var args33866 = [];
var len__7211__auto___33872 = arguments.length;
var i__7212__auto___33873 = (0);
while(true){
if((i__7212__auto___33873 < len__7211__auto___33872)){
args33866.push((arguments[i__7212__auto___33873]));

var G__33874 = (i__7212__auto___33873 + (1));
i__7212__auto___33873 = G__33874;
continue;
} else {
}
break;
}

var G__33871 = args33866.length;
switch (G__33871) {
case 1:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33866.slice((2)),(0)));
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return ((1) / x);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x / y);
});

cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_divide_int,(x / y),more);
});

cljs.core.unchecked_divide_int.cljs$lang$applyTo = (function (seq33867){
var G__33868 = cljs.core.first(seq33867);
var seq33867__$1 = cljs.core.next(seq33867);
var G__33869 = cljs.core.first(seq33867__$1);
var seq33867__$2 = cljs.core.next(seq33867__$1);
return cljs.core.unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic(G__33868,G__33869,seq33867__$2);
});

cljs.core.unchecked_divide_int.cljs$lang$maxFixedArity = (2);
cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply = (function cljs$core$unchecked_multiply(var_args){
var args33876 = [];
var len__7211__auto___33882 = arguments.length;
var i__7212__auto___33883 = (0);
while(true){
if((i__7212__auto___33883 < len__7211__auto___33882)){
args33876.push((arguments[i__7212__auto___33883]));

var G__33884 = (i__7212__auto___33883 + (1));
i__7212__auto___33883 = G__33884;
continue;
} else {
}
break;
}

var G__33881 = args33876.length;
switch (G__33881) {
case 0:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33876.slice((2)),(0)));
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply,(x * y),more);
});

cljs.core.unchecked_multiply.cljs$lang$applyTo = (function (seq33877){
var G__33878 = cljs.core.first(seq33877);
var seq33877__$1 = cljs.core.next(seq33877);
var G__33879 = cljs.core.first(seq33877__$1);
var seq33877__$2 = cljs.core.next(seq33877__$1);
return cljs.core.unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic(G__33878,G__33879,seq33877__$2);
});

cljs.core.unchecked_multiply.cljs$lang$maxFixedArity = (2);
/**
 * Returns the product of nums. (*) returns 1.
 */
cljs.core.unchecked_multiply_int = (function cljs$core$unchecked_multiply_int(var_args){
var args33886 = [];
var len__7211__auto___33892 = arguments.length;
var i__7212__auto___33893 = (0);
while(true){
if((i__7212__auto___33893 < len__7211__auto___33892)){
args33886.push((arguments[i__7212__auto___33893]));

var G__33894 = (i__7212__auto___33893 + (1));
i__7212__auto___33893 = G__33894;
continue;
} else {
}
break;
}

var G__33891 = args33886.length;
switch (G__33891) {
case 0:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33886.slice((2)),(0)));
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = (function (){
return (1);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return x;
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x * y);
});

cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_multiply_int,(x * y),more);
});

cljs.core.unchecked_multiply_int.cljs$lang$applyTo = (function (seq33887){
var G__33888 = cljs.core.first(seq33887);
var seq33887__$1 = cljs.core.next(seq33887);
var G__33889 = cljs.core.first(seq33887__$1);
var seq33887__$2 = cljs.core.next(seq33887__$1);
return cljs.core.unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic(G__33888,G__33889,seq33887__$2);
});

cljs.core.unchecked_multiply_int.cljs$lang$maxFixedArity = (2);
cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(x,n) : cljs.core.mod.call(null,x,n));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract = (function cljs$core$unchecked_subtract(var_args){
var args33896 = [];
var len__7211__auto___33902 = arguments.length;
var i__7212__auto___33903 = (0);
while(true){
if((i__7212__auto___33903 < len__7211__auto___33902)){
args33896.push((arguments[i__7212__auto___33903]));

var G__33904 = (i__7212__auto___33903 + (1));
i__7212__auto___33903 = G__33904;
continue;
} else {
}
break;
}

var G__33901 = args33896.length;
switch (G__33901) {
case 1:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33896.slice((2)),(0)));
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract,(x - y),more);
});

cljs.core.unchecked_subtract.cljs$lang$applyTo = (function (seq33897){
var G__33898 = cljs.core.first(seq33897);
var seq33897__$1 = cljs.core.next(seq33897);
var G__33899 = cljs.core.first(seq33897__$1);
var seq33897__$2 = cljs.core.next(seq33897__$1);
return cljs.core.unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic(G__33898,G__33899,seq33897__$2);
});

cljs.core.unchecked_subtract.cljs$lang$maxFixedArity = (2);
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 *   the ys from x and returns the result.
 */
cljs.core.unchecked_subtract_int = (function cljs$core$unchecked_subtract_int(var_args){
var args33906 = [];
var len__7211__auto___33912 = arguments.length;
var i__7212__auto___33913 = (0);
while(true){
if((i__7212__auto___33913 < len__7211__auto___33912)){
args33906.push((arguments[i__7212__auto___33913]));

var G__33914 = (i__7212__auto___33913 + (1));
i__7212__auto___33913 = G__33914;
continue;
} else {
}
break;
}

var G__33911 = args33906.length;
switch (G__33911) {
case 1:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33906.slice((2)),(0)));
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (- x);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x - y);
});

cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.unchecked_subtract_int,(x - y),more);
});

cljs.core.unchecked_subtract_int.cljs$lang$applyTo = (function (seq33907){
var G__33908 = cljs.core.first(seq33907);
var seq33907__$1 = cljs.core.next(seq33907);
var G__33909 = cljs.core.first(seq33907__$1);
var seq33907__$2 = cljs.core.next(seq33907__$1);
return cljs.core.unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic(G__33908,G__33909,seq33907__$2);
});

cljs.core.unchecked_subtract_int.cljs$lang$maxFixedArity = (2);
cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
return Math.floor(q);
} else {
return Math.ceil(q);
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 */
cljs.core.bit_xor = (function cljs$core$bit_xor(var_args){
var args33916 = [];
var len__7211__auto___33922 = arguments.length;
var i__7212__auto___33923 = (0);
while(true){
if((i__7212__auto___33923 < len__7211__auto___33922)){
args33916.push((arguments[i__7212__auto___33923]));

var G__33924 = (i__7212__auto___33923 + (1));
i__7212__auto___33923 = G__33924;
continue;
} else {
}
break;
}

var G__33921 = args33916.length;
switch (G__33921) {
case 2:
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33916.slice((2)),(0)));
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x ^ y);
});

cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_xor,(x ^ y),more);
});

cljs.core.bit_xor.cljs$lang$applyTo = (function (seq33917){
var G__33918 = cljs.core.first(seq33917);
var seq33917__$1 = cljs.core.next(seq33917);
var G__33919 = cljs.core.first(seq33917__$1);
var seq33917__$2 = cljs.core.next(seq33917__$1);
return cljs.core.bit_xor.cljs$core$IFn$_invoke$arity$variadic(G__33918,G__33919,seq33917__$2);
});

cljs.core.bit_xor.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise and
 */
cljs.core.bit_and = (function cljs$core$bit_and(var_args){
var args33926 = [];
var len__7211__auto___33932 = arguments.length;
var i__7212__auto___33933 = (0);
while(true){
if((i__7212__auto___33933 < len__7211__auto___33932)){
args33926.push((arguments[i__7212__auto___33933]));

var G__33934 = (i__7212__auto___33933 + (1));
i__7212__auto___33933 = G__33934;
continue;
} else {
}
break;
}

var G__33931 = args33926.length;
switch (G__33931) {
case 2:
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33926.slice((2)),(0)));
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & y);
});

cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and,(x & y),more);
});

cljs.core.bit_and.cljs$lang$applyTo = (function (seq33927){
var G__33928 = cljs.core.first(seq33927);
var seq33927__$1 = cljs.core.next(seq33927);
var G__33929 = cljs.core.first(seq33927__$1);
var seq33927__$2 = cljs.core.next(seq33927__$1);
return cljs.core.bit_and.cljs$core$IFn$_invoke$arity$variadic(G__33928,G__33929,seq33927__$2);
});

cljs.core.bit_and.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise or
 */
cljs.core.bit_or = (function cljs$core$bit_or(var_args){
var args33936 = [];
var len__7211__auto___33942 = arguments.length;
var i__7212__auto___33943 = (0);
while(true){
if((i__7212__auto___33943 < len__7211__auto___33942)){
args33936.push((arguments[i__7212__auto___33943]));

var G__33944 = (i__7212__auto___33943 + (1));
i__7212__auto___33943 = G__33944;
continue;
} else {
}
break;
}

var G__33941 = args33936.length;
switch (G__33941) {
case 2:
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33936.slice((2)),(0)));
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x | y);
});

cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_or,(x | y),more);
});

cljs.core.bit_or.cljs$lang$applyTo = (function (seq33937){
var G__33938 = cljs.core.first(seq33937);
var seq33937__$1 = cljs.core.next(seq33937);
var G__33939 = cljs.core.first(seq33937__$1);
var seq33937__$2 = cljs.core.next(seq33937__$1);
return cljs.core.bit_or.cljs$core$IFn$_invoke$arity$variadic(G__33938,G__33939,seq33937__$2);
});

cljs.core.bit_or.cljs$lang$maxFixedArity = (2);
/**
 * Bitwise and
 */
cljs.core.bit_and_not = (function cljs$core$bit_and_not(var_args){
var args33946 = [];
var len__7211__auto___33952 = arguments.length;
var i__7212__auto___33953 = (0);
while(true){
if((i__7212__auto___33953 < len__7211__auto___33952)){
args33946.push((arguments[i__7212__auto___33953]));

var G__33954 = (i__7212__auto___33953 + (1));
i__7212__auto___33953 = G__33954;
continue;
} else {
}
break;
}

var G__33951 = args33946.length;
switch (G__33951) {
case 2:
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33946.slice((2)),(0)));
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (x & ~y);
});

cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.bit_and_not,(x & ~y),more);
});

cljs.core.bit_and_not.cljs$lang$applyTo = (function (seq33947){
var G__33948 = cljs.core.first(seq33947);
var seq33947__$1 = cljs.core.next(seq33947);
var G__33949 = cljs.core.first(seq33947__$1);
var seq33947__$2 = cljs.core.next(seq33947__$1);
return cljs.core.bit_and_not.cljs$core$IFn$_invoke$arity$variadic(G__33948,G__33949,seq33947__$2);
});

cljs.core.bit_and_not.cljs$lang$maxFixedArity = (2);
/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 *   value, otherwise false. Behavior on non nums is
 *   undefined.
 */
cljs.core._EQ__EQ_ = (function cljs$core$_EQ__EQ_(var_args){
var args33956 = [];
var len__7211__auto___33962 = arguments.length;
var i__7212__auto___33963 = (0);
while(true){
if((i__7212__auto___33963 < len__7211__auto___33962)){
args33956.push((arguments[i__7212__auto___33963]));

var G__33964 = (i__7212__auto___33963 + (1));
i__7212__auto___33963 = G__33964;
continue;
} else {
}
break;
}

var G__33961 = args33956.length;
switch (G__33961) {
case 1:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33956.slice((2)),(0)));
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return true;
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return cljs.core._equiv(x,y);
});

cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
while(true){
if((x === y)){
if(cljs.core.next(more)){
var G__33966 = y;
var G__33967 = cljs.core.first(more);
var G__33968 = cljs.core.next(more);
x = G__33966;
y = G__33967;
more = G__33968;
continue;
} else {
return (y === cljs.core.first(more));
}
} else {
return false;
}
break;
}
});

cljs.core._EQ__EQ_.cljs$lang$applyTo = (function (seq33957){
var G__33958 = cljs.core.first(seq33957);
var seq33957__$1 = cljs.core.next(seq33957);
var G__33959 = cljs.core.first(seq33957__$1);
var seq33957__$2 = cljs.core.next(seq33957__$1);
return cljs.core._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(G__33958,G__33959,seq33957__$2);
});

cljs.core._EQ__EQ_.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(n){
return (n > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(n){
return (n === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__33969 = (n__$1 - (1));
var G__33970 = cljs.core.next(xs);
n__$1 = G__33969;
xs = G__33970;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 *   x.toString().  (str nil) returns the empty string. With more than
 *   one arg, returns the concatenation of the str values of the args.
 */
cljs.core.str = (function cljs$core$str(var_args){
var args33971 = [];
var len__7211__auto___33976 = arguments.length;
var i__7212__auto___33977 = (0);
while(true){
if((i__7212__auto___33977 < len__7211__auto___33976)){
args33971.push((arguments[i__7212__auto___33977]));

var G__33978 = (i__7212__auto___33977 + (1));
i__7212__auto___33977 = G__33978;
continue;
} else {
}
break;
}

var G__33975 = args33971.length;
switch (G__33975) {
case 0:
return cljs.core.str.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.str.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args33971.slice((1)),(0)));
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7230__auto__);

}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$0 = (function (){
return "";
});

cljs.core.str.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x == null)){
return "";
} else {
return [x].join("");
}
});

cljs.core.str.cljs$core$IFn$_invoke$arity$variadic = (function (x,ys){
var sb = (new goog.string.StringBuffer([cljs.core.str(x)].join('')));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__33980 = sb.append([cljs.core.str(cljs.core.first(more))].join(''));
var G__33981 = cljs.core.next(more);
sb = G__33980;
more = G__33981;
continue;
} else {
return sb.toString();
}
break;
}
});

cljs.core.str.cljs$lang$applyTo = (function (seq33972){
var G__33973 = cljs.core.first(seq33972);
var seq33972__$1 = cljs.core.next(seq33972);
return cljs.core.str.cljs$core$IFn$_invoke$arity$variadic(G__33973,seq33972__$1);
});

cljs.core.str.cljs$lang$maxFixedArity = (1);
/**
 * Returns the substring of s beginning at start inclusive, and ending
 *   at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function cljs$core$subs(var_args){
var args33982 = [];
var len__7211__auto___33985 = arguments.length;
var i__7212__auto___33986 = (0);
while(true){
if((i__7212__auto___33986 < len__7211__auto___33985)){
args33982.push((arguments[i__7212__auto___33986]));

var G__33987 = (i__7212__auto___33986 + (1));
i__7212__auto___33986 = G__33987;
continue;
} else {
}
break;
}

var G__33984 = args33982.length;
switch (G__33984) {
case 2:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args33982.length)].join('')));

}
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$2 = (function (s,start){
return s.substring(start);
});

cljs.core.subs.cljs$core$IFn$_invoke$arity$3 = (function (s,start,end){
return s.substring(start,end);
});

cljs.core.subs.cljs$lang$maxFixedArity = 3;

/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 *   returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__33989 = cljs.core.next(xs);
var G__33990 = cljs.core.next(ys);
xs = G__33989;
ys = G__33990;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__33991 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__33992 = cljs.core.next(s);
res = G__33991;
s = G__33992;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__33993 = ((h + (cljs.core.hash((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e))) ^ cljs.core.hash((cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e))))) % (4503599627370496));
var G__33994 = cljs.core.next(s);
h = G__33993;
s = G__33994;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__33995 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__33996 = cljs.core.next(s__$1);
h = G__33995;
s__$1 = G__33996;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 *   attaches said functions as methods on the object.  Any references to
 *   JavaScript's implicit this (via the this-as macro) will resolve to the
 *   object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__34003_34009 = cljs.core.seq(fn_map);
var chunk__34004_34010 = null;
var count__34005_34011 = (0);
var i__34006_34012 = (0);
while(true){
if((i__34006_34012 < count__34005_34011)){
var vec__34007_34013 = chunk__34004_34010.cljs$core$IIndexed$_nth$arity$2(null,i__34006_34012);
var key_name_34014 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34007_34013,(0),null);
var f_34015 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34007_34013,(1),null);
var str_name_34016 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_34014) : cljs.core.name.call(null,key_name_34014));
(obj[str_name_34016] = f_34015);

var G__34017 = seq__34003_34009;
var G__34018 = chunk__34004_34010;
var G__34019 = count__34005_34011;
var G__34020 = (i__34006_34012 + (1));
seq__34003_34009 = G__34017;
chunk__34004_34010 = G__34018;
count__34005_34011 = G__34019;
i__34006_34012 = G__34020;
continue;
} else {
var temp__4657__auto___34021 = cljs.core.seq(seq__34003_34009);
if(temp__4657__auto___34021){
var seq__34003_34022__$1 = temp__4657__auto___34021;
if(cljs.core.chunked_seq_QMARK_(seq__34003_34022__$1)){
var c__6956__auto___34023 = (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(seq__34003_34022__$1) : cljs.core.chunk_first.call(null,seq__34003_34022__$1));
var G__34024 = (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(seq__34003_34022__$1) : cljs.core.chunk_rest.call(null,seq__34003_34022__$1));
var G__34025 = c__6956__auto___34023;
var G__34026 = cljs.core.count(c__6956__auto___34023);
var G__34027 = (0);
seq__34003_34009 = G__34024;
chunk__34004_34010 = G__34025;
count__34005_34011 = G__34026;
i__34006_34012 = G__34027;
continue;
} else {
var vec__34008_34028 = cljs.core.first(seq__34003_34022__$1);
var key_name_34029 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34008_34028,(0),null);
var f_34030 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34008_34028,(1),null);
var str_name_34031 = (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(key_name_34029) : cljs.core.name.call(null,key_name_34029));
(obj[str_name_34031] = f_34030);

var G__34032 = cljs.core.next(seq__34003_34022__$1);
var G__34033 = null;
var G__34034 = (0);
var G__34035 = (0);
seq__34003_34009 = G__34032;
chunk__34004_34010 = G__34033;
count__34005_34011 = G__34034;
i__34006_34012 = G__34035;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.cst$sym$count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
if(!((x == null))){
if(((x.cljs$lang$protocol_mask$partition0$ & (33554432))) || (x.cljs$core$IList$)){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,x);
}
});
(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((cljs.core.list_QMARK_(other)) || (cljs.core.sequential_QMARK_(other))){
return (cljs.core.seq(other) == null);
} else {
return false;
}
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta], null);
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (134217728))) || (coll.cljs$core$IReversible$)){
return true;
} else {
if((!coll.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,coll);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 *   can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(rev){
return cljs.core._rseq(rev);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 */
cljs.core.list = (function cljs$core$list(var_args){
var args__7218__auto__ = [];
var len__7211__auto___34041 = arguments.length;
var i__7212__auto___34042 = (0);
while(true){
if((i__7212__auto___34042 < len__7211__auto___34041)){
args__7218__auto__.push((arguments[i__7212__auto___34042]));

var G__34043 = (i__7212__auto___34042 + (1));
i__7212__auto___34042 = G__34043;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.list.cljs$core$IFn$_invoke$arity$variadic = (function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__34044 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__34044;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__34045 = (i - (1));
var G__34046 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__34045;
r = G__34046;
continue;
} else {
return r;
}
break;
}
});

cljs.core.list.cljs$lang$maxFixedArity = (0);

cljs.core.list.cljs$lang$applyTo = (function (seq34040){
return cljs.core.list.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34040));
});

/**
* @constructor
 * @implements {cljs.core.IList}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,null));
});

cljs.core.Cons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$first,cljs.core.cst$sym$rest,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Returns a new seq where x is the first element and seq is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__6153__auto__ = (coll == null);
if(or__6153__auto__){
return or__6153__auto__;
} else {
if(!((coll == null))){
if(((coll.cljs$lang$protocol_mask$partition0$ & (64))) || (coll.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__6141__auto__ = cljs.core.not(a.ns);
if(and__6141__auto__){
return b.ns;
} else {
return and__6141__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__34057 = a.ns;
var G__34058 = b.ns;
return goog.array.defaultCompare(G__34057,G__34058);
})();
if(((0) === nsc)){
var G__34059 = a.name;
var G__34060 = b.name;
return goog.array.defaultCompare(G__34059,G__34060);
} else {
return nsc;
}
}
} else {
var G__34061 = a.name;
var G__34062 = b.name;
return goog.array.defaultCompare(G__34061,G__34062);

}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.INamed}
 * @implements {cljs.core.IPrintWithWriter}
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__34064 = null;
var G__34064__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__34064__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__34064 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__34064__2.call(this,self__,coll);
case 3:
return G__34064__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34064.cljs$core$IFn$_invoke$arity$2 = G__34064__2;
G__34064.cljs$core$IFn$_invoke$arity$3 = G__34064__3;
return G__34064;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args34063){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args34063)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__6588__auto__ = self__._hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ns,cljs.core.cst$sym$name,cljs.core.cst$sym$fqn,cljs.core.with_meta(cljs.core.cst$sym$_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Efficient test to determine that two symbol are identical.
 */
cljs.core.symbol_identical_QMARK_ = (function cljs$core$symbol_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Symbol)) && ((y instanceof cljs.core.Symbol))){
return (x.str === y.str);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || (x.cljs$core$INamed$))?true:false):false)){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 *   in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function cljs$core$keyword(var_args){
var args34067 = [];
var len__7211__auto___34070 = arguments.length;
var i__7212__auto___34071 = (0);
while(true){
if((i__7212__auto___34071 < len__7211__auto___34070)){
args34067.push((arguments[i__7212__auto___34071]));

var G__34072 = (i__7212__auto___34071 + (1));
i__7212__auto___34071 = G__34072;
continue;
} else {
}
break;
}

var G__34069 = args34067.length;
switch (G__34069) {
case 1:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34067.length)].join('')));

}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(name) : cljs.core.name.call(null,name)),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});

cljs.core.keyword.cljs$core$IFn$_invoke$arity$2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});

cljs.core.keyword.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 1;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (x){
var self__ = this;
var x__$1 = this;
return cljs.core.not(self__.fn);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__34074 = ls.sval();
ls = G__34074;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$fn,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ICounted}
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 2;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$buf,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$end,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.IChunk}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition0$ = 524306;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$off,cljs.core.cst$sym$end], null);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function cljs$core$array_chunk(var_args){
var args34075 = [];
var len__7211__auto___34078 = arguments.length;
var i__7212__auto___34079 = (0);
while(true){
if((i__7212__auto___34079 < len__7211__auto___34078)){
args34075.push((arguments[i__7212__auto___34079]));

var G__34080 = (i__7212__auto___34079 + (1));
i__7212__auto___34079 = G__34080;
continue;
} else {
}
break;
}

var G__34077 = args34075.length;
switch (G__34077) {
case 1:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34075.length)].join('')));

}
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});

cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk.cljs$lang$maxFixedArity = 3;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$chunk,cljs.core.cst$sym$more,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if(((!((s == null)))?((((s.cljs$lang$protocol_mask$partition1$ & (1024))) || (s.cljs$core$IChunkedNext$))?true:false):false)){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__34084 = cljs.core.next(s__$1);
s__$1 = G__34084;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 *   containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_34085 = (0);
var xs_34086 = cljs.core.seq(coll);
while(true){
if(xs_34086){
(ret[i_34085] = cljs.core.to_array(cljs.core.first(xs_34086)));

var G__34087 = (i_34085 + (1));
var G__34088 = cljs.core.next(xs_34086);
i_34085 = G__34087;
xs_34086 = G__34088;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.int_array = (function cljs$core$int_array(var_args){
var args34089 = [];
var len__7211__auto___34092 = arguments.length;
var i__7212__auto___34093 = (0);
while(true){
if((i__7212__auto___34093 < len__7211__auto___34092)){
args34089.push((arguments[i__7212__auto___34093]));

var G__34094 = (i__7212__auto___34093 + (1));
i__7212__auto___34093 = G__34094;
continue;
} else {
}
break;
}

var G__34091 = args34089.length;
switch (G__34091) {
case 1:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34089.length)].join('')));

}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.int_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__34096 = (i + (1));
var G__34097 = cljs.core.next(s__$1);
i = G__34096;
s__$1 = G__34097;
continue;
} else {
return a;
}
break;
}
} else {
var n__7056__auto___34098 = size;
var i_34099 = (0);
while(true){
if((i_34099 < n__7056__auto___34098)){
(a[i_34099] = init_val_or_seq);

var G__34100 = (i_34099 + (1));
i_34099 = G__34100;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.int_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.long_array = (function cljs$core$long_array(var_args){
var args34101 = [];
var len__7211__auto___34104 = arguments.length;
var i__7212__auto___34105 = (0);
while(true){
if((i__7212__auto___34105 < len__7211__auto___34104)){
args34101.push((arguments[i__7212__auto___34105]));

var G__34106 = (i__7212__auto___34105 + (1));
i__7212__auto___34105 = G__34106;
continue;
} else {
}
break;
}

var G__34103 = args34101.length;
switch (G__34103) {
case 1:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34101.length)].join('')));

}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.long_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__34108 = (i + (1));
var G__34109 = cljs.core.next(s__$1);
i = G__34108;
s__$1 = G__34109;
continue;
} else {
return a;
}
break;
}
} else {
var n__7056__auto___34110 = size;
var i_34111 = (0);
while(true){
if((i_34111 < n__7056__auto___34110)){
(a[i_34111] = init_val_or_seq);

var G__34112 = (i_34111 + (1));
i_34111 = G__34112;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.long_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.double_array = (function cljs$core$double_array(var_args){
var args34113 = [];
var len__7211__auto___34116 = arguments.length;
var i__7212__auto___34117 = (0);
while(true){
if((i__7212__auto___34117 < len__7211__auto___34116)){
args34113.push((arguments[i__7212__auto___34117]));

var G__34118 = (i__7212__auto___34117 + (1));
i__7212__auto___34117 = G__34118;
continue;
} else {
}
break;
}

var G__34115 = args34113.length;
switch (G__34115) {
case 1:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34113.length)].join('')));

}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.double_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__34120 = (i + (1));
var G__34121 = cljs.core.next(s__$1);
i = G__34120;
s__$1 = G__34121;
continue;
} else {
return a;
}
break;
}
} else {
var n__7056__auto___34122 = size;
var i_34123 = (0);
while(true){
if((i_34123 < n__7056__auto___34122)){
(a[i_34123] = init_val_or_seq);

var G__34124 = (i_34123 + (1));
i_34123 = G__34124;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.double_array.cljs$lang$maxFixedArity = 2;
/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 *   with Clojure.
 */
cljs.core.object_array = (function cljs$core$object_array(var_args){
var args34125 = [];
var len__7211__auto___34128 = arguments.length;
var i__7212__auto___34129 = (0);
while(true){
if((i__7212__auto___34129 < len__7211__auto___34128)){
args34125.push((arguments[i__7212__auto___34129]));

var G__34130 = (i__7212__auto___34129 + (1));
i__7212__auto___34129 = G__34130;
continue;
} else {
}
break;
}

var G__34127 = args34125.length;
switch (G__34127) {
case 1:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34125.length)].join('')));

}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs.core.object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});

cljs.core.object_array.cljs$core$IFn$_invoke$arity$2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__34132 = (i + (1));
var G__34133 = cljs.core.next(s__$1);
i = G__34132;
s__$1 = G__34133;
continue;
} else {
return a;
}
break;
}
} else {
var n__7056__auto___34134 = size;
var i_34135 = (0);
while(true){
if((i_34135 < n__7056__auto___34134)){
(a[i_34135] = init_val_or_seq);

var G__34136 = (i_34135 + (1));
i_34135 = G__34136;
continue;
} else {
}
break;
}

return a;
}
});

cljs.core.object_array.cljs$lang$maxFixedArity = 2;
cljs.core.bounded_count = (function cljs$core$bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__34137 = cljs.core.next(s__$1);
var G__34138 = (i - (1));
var G__34139 = (sum + (1));
s__$1 = G__34137;
i = G__34138;
sum = G__34139;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),cljs$core$spread(cljs.core.next(arglist)));

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 */
cljs.core.concat = (function cljs$core$concat(var_args){
var args34141 = [];
var len__7211__auto___34153 = arguments.length;
var i__7212__auto___34154 = (0);
while(true){
if((i__7212__auto___34154 < len__7211__auto___34153)){
args34141.push((arguments[i__7212__auto___34154]));

var G__34155 = (i__7212__auto___34154 + (1));
i__7212__auto___34154 = G__34155;
continue;
} else {
}
break;
}

var G__34146 = args34141.length;
switch (G__34146) {
case 0:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34141.slice((2)),(0)));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});

cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,zs){
var cat = (function cljs$core$cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
});

cljs.core.concat.cljs$lang$applyTo = (function (seq34142){
var G__34143 = cljs.core.first(seq34142);
var seq34142__$1 = cljs.core.next(seq34142);
var G__34144 = cljs.core.first(seq34142__$1);
var seq34142__$2 = cljs.core.next(seq34142__$1);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(G__34143,G__34144,seq34142__$2);
});

cljs.core.concat.cljs$lang$maxFixedArity = (2);
/**
 * Creates a new list containing the items prepended to the rest, the
 *   last of which will be treated as a sequence.
 */
cljs.core.list_STAR_ = (function cljs$core$list_STAR_(var_args){
var args34157 = [];
var len__7211__auto___34165 = arguments.length;
var i__7212__auto___34166 = (0);
while(true){
if((i__7212__auto___34166 < len__7211__auto___34165)){
args34157.push((arguments[i__7212__auto___34166]));

var G__34167 = (i__7212__auto___34166 + (1));
i__7212__auto___34166 = G__34167;
continue;
} else {
}
break;
}

var G__34164 = args34157.length;
switch (G__34164) {
case 1:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34157.slice((4)),(0)));
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7230__auto__);

}
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (args){
return cljs.core.seq(args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (a,args){
return cljs.core.cons(a,args);
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});

cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
});

cljs.core.list_STAR_.cljs$lang$applyTo = (function (seq34158){
var G__34159 = cljs.core.first(seq34158);
var seq34158__$1 = cljs.core.next(seq34158);
var G__34160 = cljs.core.first(seq34158__$1);
var seq34158__$2 = cljs.core.next(seq34158__$1);
var G__34161 = cljs.core.first(seq34158__$2);
var seq34158__$3 = cljs.core.next(seq34158__$2);
var G__34162 = cljs.core.first(seq34158__$3);
var seq34158__$4 = cljs.core.next(seq34158__$3);
return cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__34159,G__34160,G__34161,G__34162,seq34158__$4);
});

cljs.core.list_STAR_.cljs$lang$maxFixedArity = (4);
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 *   constant time. The transient collection cannot be used after this
 *   call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds x to the transient collection, and return coll. The 'addition'
 *   may happen at different 'places' depending on the concrete type.
 */
cljs.core.conj_BANG_ = (function cljs$core$conj_BANG_(var_args){
var args34169 = [];
var len__7211__auto___34175 = arguments.length;
var i__7212__auto___34176 = (0);
while(true){
if((i__7212__auto___34176 < len__7211__auto___34175)){
args34169.push((arguments[i__7212__auto___34176]));

var G__34177 = (i__7212__auto___34176 + (1));
i__7212__auto___34176 = G__34177;
continue;
} else {
}
break;
}

var G__34174 = args34169.length;
switch (G__34174) {
case 0:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34169.slice((2)),(0)));
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return coll;
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});

cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__34179 = ntcoll;
var G__34180 = cljs.core.first(vals);
var G__34181 = cljs.core.next(vals);
tcoll = G__34179;
val = G__34180;
vals = G__34181;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.conj_BANG_.cljs$lang$applyTo = (function (seq34170){
var G__34171 = cljs.core.first(seq34170);
var seq34170__$1 = cljs.core.next(seq34170);
var G__34172 = cljs.core.first(seq34170__$1);
var seq34170__$2 = cljs.core.next(seq34170__$1);
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34171,G__34172,seq34170__$2);
});

cljs.core.conj_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * When applied to a transient map, adds mapping of key(s) to
 *   val(s). When applied to a transient vector, sets the val at index.
 *   Note - index must be <= (count vector). Returns coll.
 */
cljs.core.assoc_BANG_ = (function cljs$core$assoc_BANG_(var_args){
var args34182 = [];
var len__7211__auto___34189 = arguments.length;
var i__7212__auto___34190 = (0);
while(true){
if((i__7212__auto___34190 < len__7211__auto___34189)){
args34182.push((arguments[i__7212__auto___34190]));

var G__34191 = (i__7212__auto___34190 + (1));
i__7212__auto___34190 = G__34191;
continue;
} else {
}
break;
}

var G__34188 = args34182.length;
switch (G__34188) {
case 3:
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34182.slice((3)),(0)));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});

cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__34193 = ntcoll;
var G__34194 = cljs.core.first(kvs);
var G__34195 = cljs.core.second(kvs);
var G__34196 = cljs.core.nnext(kvs);
tcoll = G__34193;
key = G__34194;
val = G__34195;
kvs = G__34196;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.assoc_BANG_.cljs$lang$applyTo = (function (seq34183){
var G__34184 = cljs.core.first(seq34183);
var seq34183__$1 = cljs.core.next(seq34183);
var G__34185 = cljs.core.first(seq34183__$1);
var seq34183__$2 = cljs.core.next(seq34183__$1);
var G__34186 = cljs.core.first(seq34183__$2);
var seq34183__$3 = cljs.core.next(seq34183__$2);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34184,G__34185,G__34186,seq34183__$3);
});

cljs.core.assoc_BANG_.cljs$lang$maxFixedArity = (3);
/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 */
cljs.core.dissoc_BANG_ = (function cljs$core$dissoc_BANG_(var_args){
var args34197 = [];
var len__7211__auto___34203 = arguments.length;
var i__7212__auto___34204 = (0);
while(true){
if((i__7212__auto___34204 < len__7211__auto___34203)){
args34197.push((arguments[i__7212__auto___34204]));

var G__34205 = (i__7212__auto___34204 + (1));
i__7212__auto___34204 = G__34205;
continue;
} else {
}
break;
}

var G__34202 = args34197.length;
switch (G__34202) {
case 2:
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34197.slice((2)),(0)));
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});

cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__34207 = ntcoll;
var G__34208 = cljs.core.first(ks);
var G__34209 = cljs.core.next(ks);
tcoll = G__34207;
key = G__34208;
ks = G__34209;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.dissoc_BANG_.cljs$lang$applyTo = (function (seq34198){
var G__34199 = cljs.core.first(seq34198);
var seq34198__$1 = cljs.core.next(seq34198);
var G__34200 = cljs.core.first(seq34198__$1);
var seq34198__$2 = cljs.core.next(seq34198__$1);
return cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34199,G__34200,seq34198__$2);
});

cljs.core.dissoc_BANG_.cljs$lang$maxFixedArity = (2);
/**
 * Removes the last item from a transient vector. If
 *   the collection is empty, throws an exception. Returns coll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 *   does not contain key(s).
 */
cljs.core.disj_BANG_ = (function cljs$core$disj_BANG_(var_args){
var args34210 = [];
var len__7211__auto___34216 = arguments.length;
var i__7212__auto___34217 = (0);
while(true){
if((i__7212__auto___34217 < len__7211__auto___34216)){
args34210.push((arguments[i__7212__auto___34217]));

var G__34218 = (i__7212__auto___34217 + (1));
i__7212__auto___34217 = G__34218;
continue;
} else {
}
break;
}

var G__34215 = args34210.length;
switch (G__34215) {
case 2:
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34210.slice((2)),(0)));
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});

cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__34220 = ntcoll;
var G__34221 = cljs.core.first(vals);
var G__34222 = cljs.core.next(vals);
tcoll = G__34220;
val = G__34221;
vals = G__34222;
continue;
} else {
return ntcoll;
}
break;
}
});

cljs.core.disj_BANG_.cljs$lang$applyTo = (function (seq34211){
var G__34212 = cljs.core.first(seq34211);
var seq34211__$1 = cljs.core.next(seq34211);
var G__34213 = cljs.core.first(seq34211__$1);
var seq34211__$2 = cljs.core.next(seq34211__$1);
return cljs.core.disj_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34212,G__34213,seq34211__$2);
});

cljs.core.disj_BANG_.cljs$lang$maxFixedArity = (2);

cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a7100 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a7100);
} else {
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(a7100) : f.call(null,a7100));
}
} else {
var b7101 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a7100,b7101);
} else {
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(a7100,b7101) : f.call(null,a7100,b7101));
}
} else {
var c7102 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a7100,b7101,c7102);
} else {
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(a7100,b7101,c7102) : f.call(null,a7100,b7101,c7102));
}
} else {
var d7103 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a7100,b7101,c7102,d7103);
} else {
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(a7100,b7101,c7102,d7103) : f.call(null,a7100,b7101,c7102,d7103));
}
} else {
var e7104 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a7100,b7101,c7102,d7103,e7104);
} else {
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(a7100,b7101,c7102,d7103,e7104) : f.call(null,a7100,b7101,c7102,d7103,e7104));
}
} else {
var f7105 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a7100,b7101,c7102,d7103,e7104,f7105);
} else {
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(a7100,b7101,c7102,d7103,e7104,f7105) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105));
}
} else {
var g7106 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a7100,b7101,c7102,d7103,e7104,f7105,g7106);
} else {
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(a7100,b7101,c7102,d7103,e7104,f7105,g7106) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106));
}
} else {
var h7107 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107);
} else {
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107));
}
} else {
var i7108 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108);
} else {
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108));
}
} else {
var j7109 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109);
} else {
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109));
}
} else {
var k7110 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110);
} else {
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110));
}
} else {
var l7111 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111);
} else {
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111));
}
} else {
var m7112 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112);
} else {
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112));
}
} else {
var n7113 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113);
} else {
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113));
}
} else {
var o7114 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114);
} else {
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114));
}
} else {
var p7115 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115);
} else {
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115));
}
} else {
var q7116 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116);
} else {
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116));
}
} else {
var r7117 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117);
} else {
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117));
}
} else {
var s7118 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117,s7118);
} else {
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117,s7118) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117,s7118));
}
} else {
var t7119 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117,s7118,t7119);
} else {
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117,s7118,t7119) : f.call(null,a7100,b7101,c7102,d7103,e7104,f7105,g7106,h7107,i7108,j7109,k7110,l7111,m7112,n7113,o7114,p7115,q7116,r7117,s7118,t7119));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 */
cljs.core.apply = (function cljs$core$apply(var_args){
var args34223 = [];
var len__7211__auto___34232 = arguments.length;
var i__7212__auto___34233 = (0);
while(true){
if((i__7212__auto___34233 < len__7211__auto___34232)){
args34223.push((arguments[i__7212__auto___34233]));

var G__34234 = (i__7212__auto___34233 + (1));
i__7212__auto___34233 = G__34234;
continue;
} else {
}
break;
}

var G__34231 = args34223.length;
switch (G__34231) {
case 2:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34223.slice((5)),(0)));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__7230__auto__);

}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic = (function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});

cljs.core.apply.cljs$lang$applyTo = (function (seq34224){
var G__34225 = cljs.core.first(seq34224);
var seq34224__$1 = cljs.core.next(seq34224);
var G__34226 = cljs.core.first(seq34224__$1);
var seq34224__$2 = cljs.core.next(seq34224__$1);
var G__34227 = cljs.core.first(seq34224__$2);
var seq34224__$3 = cljs.core.next(seq34224__$2);
var G__34228 = cljs.core.first(seq34224__$3);
var seq34224__$4 = cljs.core.next(seq34224__$3);
var G__34229 = cljs.core.first(seq34224__$4);
var seq34224__$5 = cljs.core.next(seq34224__$4);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(G__34225,G__34226,G__34227,G__34228,G__34229,seq34224__$5);
});

cljs.core.apply.cljs$lang$maxFixedArity = (5);
/**
 * Returns an object of the same type and value as obj, with
 *   (apply f (meta obj) args) as its metadata.
 */
cljs.core.vary_meta = (function cljs$core$vary_meta(var_args){
var args34236 = [];
var len__7211__auto___34261 = arguments.length;
var i__7212__auto___34262 = (0);
while(true){
if((i__7212__auto___34262 < len__7211__auto___34261)){
args34236.push((arguments[i__7212__auto___34262]));

var G__34263 = (i__7212__auto___34262 + (1));
i__7212__auto___34262 = G__34263;
continue;
} else {
}
break;
}

var G__34245 = args34236.length;
switch (G__34245) {
case 2:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34236.slice((6)),(0)));
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7230__auto__);

}
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__34246 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34246) : f.call(null,G__34246));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__34247 = cljs.core.meta(obj);
var G__34248 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34247,G__34248) : f.call(null,G__34247,G__34248));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__34249 = cljs.core.meta(obj);
var G__34250 = a;
var G__34251 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34249,G__34250,G__34251) : f.call(null,G__34249,G__34250,G__34251));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__34252 = cljs.core.meta(obj);
var G__34253 = a;
var G__34254 = b;
var G__34255 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__34252,G__34253,G__34254,G__34255) : f.call(null,G__34252,G__34253,G__34254,G__34255));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__34256 = cljs.core.meta(obj);
var G__34257 = a;
var G__34258 = b;
var G__34259 = c;
var G__34260 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__34256,G__34257,G__34258,G__34259,G__34260) : f.call(null,G__34256,G__34257,G__34258,G__34259,G__34260));
})());
});

cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic = (function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
});

cljs.core.vary_meta.cljs$lang$applyTo = (function (seq34237){
var G__34238 = cljs.core.first(seq34237);
var seq34237__$1 = cljs.core.next(seq34237);
var G__34239 = cljs.core.first(seq34237__$1);
var seq34237__$2 = cljs.core.next(seq34237__$1);
var G__34240 = cljs.core.first(seq34237__$2);
var seq34237__$3 = cljs.core.next(seq34237__$2);
var G__34241 = cljs.core.first(seq34237__$3);
var seq34237__$4 = cljs.core.next(seq34237__$3);
var G__34242 = cljs.core.first(seq34237__$4);
var seq34237__$5 = cljs.core.next(seq34237__$4);
var G__34243 = cljs.core.first(seq34237__$5);
var seq34237__$6 = cljs.core.next(seq34237__$5);
return cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$variadic(G__34238,G__34239,G__34240,G__34241,G__34242,G__34243,seq34237__$6);
});

cljs.core.vary_meta.cljs$lang$maxFixedArity = (6);
/**
 * Same as (not (= obj1 obj2))
 */
cljs.core.not_EQ_ = (function cljs$core$not_EQ_(var_args){
var args34265 = [];
var len__7211__auto___34271 = arguments.length;
var i__7212__auto___34272 = (0);
while(true){
if((i__7212__auto___34272 < len__7211__auto___34271)){
args34265.push((arguments[i__7212__auto___34272]));

var G__34273 = (i__7212__auto___34272 + (1));
i__7212__auto___34272 = G__34273;
continue;
} else {
}
break;
}

var G__34270 = args34265.length;
switch (G__34270) {
case 1:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34265.slice((2)),(0)));
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$1 = (function (x){
return false;
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});

cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
});

cljs.core.not_EQ_.cljs$lang$applyTo = (function (seq34266){
var G__34267 = cljs.core.first(seq34266);
var seq34266__$1 = cljs.core.next(seq34266);
var G__34268 = cljs.core.first(seq34266__$1);
var seq34266__$2 = cljs.core.next(seq34266__$1);
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(G__34267,G__34268,seq34266__$2);
});

cljs.core.not_EQ_.cljs$lang$maxFixedArity = (2);
/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t_cljs$core34278 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.t_cljs$core34278 = (function (nil_iter,meta34279){
this.nil_iter = nil_iter;
this.meta34279 = meta34279;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.t_cljs$core34278.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_34280,meta34279__$1){
var self__ = this;
var _34280__$1 = this;
return (new cljs.core.t_cljs$core34278(self__.nil_iter,meta34279__$1));
});

cljs.core.t_cljs$core34278.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_34280){
var self__ = this;
var _34280__$1 = this;
return self__.meta34279;
});

cljs.core.t_cljs$core34278.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t_cljs$core34278.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t_cljs$core34278.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t_cljs$core34278.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$meta34279], null);
});

cljs.core.t_cljs$core34278.cljs$lang$type = true;

cljs.core.t_cljs$core34278.cljs$lang$ctorStr = "cljs.core/t_cljs$core34278";

cljs.core.t_cljs$core34278.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/t_cljs$core34278");
});

cljs.core.__GT_t_cljs$core34278 = (function cljs$core$nil_iter_$___GT_t_cljs$core34278(nil_iter__$1,meta34279){
return (new cljs.core.t_cljs$core34278(nil_iter__$1,meta34279));
});

}

return (new cljs.core.t_cljs$core34278(cljs$core$nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$_seq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$_next,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__6141__auto__ = !((lt.stepper == null));
if(and__6141__auto__){
return self__.iter.hasNext();
} else {
return and__6141__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__34281 = lt;
var G__34282 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__34281,G__34282) : self__.xform.call(null,G__34281,G__34282));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.Stepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$iter], null);
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__34283 = cljs.core.next(iters__$1);
iters__$1 = G__34283;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__7056__auto___34284 = self__.iters.length;
var i_34285 = (0);
while(true){
if((i_34285 < n__7056__auto___34284)){
(self__.nexts[i_34285] = (self__.iters[i_34285]).next());

var G__34286 = (i_34285 + (1));
i_34285 = G__34286;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__6141__auto__ = !((lt.stepper == null));
if(and__6141__auto__){
return this$.hasNext();
} else {
return and__6141__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(lt) : self__.xform.call(null,lt));
}
});

cljs.core.MultiStepper.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$iters,cljs.core.cst$sym$nexts], null);
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function cljs$core$multi_stepper(var_args){
var args34287 = [];
var len__7211__auto___34290 = arguments.length;
var i__7212__auto___34291 = (0);
while(true){
if((i__7212__auto___34291 < len__7211__auto___34290)){
args34287.push((arguments[i__7212__auto___34291]));

var G__34292 = (i__7212__auto___34291 + (1));
i__7212__auto___34291 = G__34292;
continue;
} else {
}
break;
}

var G__34289 = args34287.length;
switch (G__34289) {
case 2:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34287.length)].join('')));

}
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$2 = (function (xform,iters){
return cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});

cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$stepfn = null;
var cljs$core$stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepfn__1.call(this,result);
case 2:
return cljs$core$stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepfn__1;
cljs$core$stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepfn__2;
return cljs$core$stepfn;
})()
;
return (new cljs.core.MultiStepper((xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(stepfn) : xform.call(null,stepfn)),iters,nexts));
});

cljs.core.multi_stepper.cljs$lang$maxFixedArity = 3;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$stepper,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$first,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$rest,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$meta], null);
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__34294_34298 = cljs.core.seq(colls);
var chunk__34295_34299 = null;
var count__34296_34300 = (0);
var i__34297_34301 = (0);
while(true){
if((i__34297_34301 < count__34296_34300)){
var coll_34302 = chunk__34295_34299.cljs$core$IIndexed$_nth$arity$2(null,i__34297_34301);
iters.push(cljs.core.iter(coll_34302));

var G__34303 = seq__34294_34298;
var G__34304 = chunk__34295_34299;
var G__34305 = count__34296_34300;
var G__34306 = (i__34297_34301 + (1));
seq__34294_34298 = G__34303;
chunk__34295_34299 = G__34304;
count__34296_34300 = G__34305;
i__34297_34301 = G__34306;
continue;
} else {
var temp__4657__auto___34307 = cljs.core.seq(seq__34294_34298);
if(temp__4657__auto___34307){
var seq__34294_34308__$1 = temp__4657__auto___34307;
if(cljs.core.chunked_seq_QMARK_(seq__34294_34308__$1)){
var c__6956__auto___34309 = cljs.core.chunk_first(seq__34294_34308__$1);
var G__34310 = cljs.core.chunk_rest(seq__34294_34308__$1);
var G__34311 = c__6956__auto___34309;
var G__34312 = cljs.core.count(c__6956__auto___34309);
var G__34313 = (0);
seq__34294_34298 = G__34310;
chunk__34295_34299 = G__34311;
count__34296_34300 = G__34312;
i__34297_34301 = G__34313;
continue;
} else {
var coll_34314 = cljs.core.first(seq__34294_34308__$1);
iters.push(cljs.core.iter(coll_34314));

var G__34315 = cljs.core.next(seq__34294_34308__$1);
var G__34316 = null;
var G__34317 = (0);
var G__34318 = (0);
seq__34294_34298 = G__34315;
chunk__34295_34299 = G__34316;
count__34296_34300 = G__34317;
i__34297_34301 = G__34318;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 *   one. Will not force a lazy seq. (sequence nil) yields (), When a
 *   transducer is supplied, returns a lazy sequence of applications of
 *   the transform to the items in coll(s), i.e. to the set of first
 *   items of each coll, followed by the set of second
 *   items in each coll, until any one of the colls is exhausted.  Any
 *   remaining items in other colls are ignored. The transform should accept
 *   number-of-colls arguments
 */
cljs.core.sequence = (function cljs$core$sequence(var_args){
var args34319 = [];
var len__7211__auto___34325 = arguments.length;
var i__7212__auto___34326 = (0);
while(true){
if((i__7212__auto___34326 < len__7211__auto___34325)){
args34319.push((arguments[i__7212__auto___34326]));

var G__34327 = (i__7212__auto___34326 + (1));
i__7212__auto___34326 = G__34327;
continue;
} else {
}
break;
}

var G__34324 = args34319.length;
switch (G__34324) {
case 1:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34319.slice((2)),(0)));
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__6153__auto__ = cljs.core.seq(coll);
if(or__6153__auto__){
return or__6153__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});

cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic = (function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
});

cljs.core.sequence.cljs$lang$applyTo = (function (seq34320){
var G__34321 = cljs.core.first(seq34320);
var seq34320__$1 = cljs.core.next(seq34320);
var G__34322 = cljs.core.first(seq34320__$1);
var seq34320__$2 = cljs.core.next(seq34320__$1);
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$variadic(G__34321,G__34322,seq34320__$2);
});

cljs.core.sequence.cljs$lang$maxFixedArity = (2);
/**
 * Returns true if (pred x) is logical true for every x in coll, else
 *   false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__34330 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__34330) : pred.call(null,G__34330));
})())){
var G__34331 = pred;
var G__34332 = cljs.core.next(coll);
pred = G__34331;
coll = G__34332;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 *   coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 *   else nil.  One common idiom is to use a set as pred, for example
 *   this will return :fred if :fred is in the sequence, otherwise nil:
 *   (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__6153__auto__ = (function (){var G__34336 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__34336) : pred.call(null,G__34336));
})();
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var G__34337 = pred;
var G__34338 = cljs.core.next(coll);
pred = G__34337;
coll = G__34338;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 *   else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 *   has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__34339 = null;
var G__34339__0 = (function (){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
});
var G__34339__1 = (function (x){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
});
var G__34339__2 = (function (x,y){
return cljs.core.not((f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)));
});
var G__34339__3 = (function() { 
var G__34340__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__34340 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__34341__i = 0, G__34341__a = new Array(arguments.length -  2);
while (G__34341__i < G__34341__a.length) {G__34341__a[G__34341__i] = arguments[G__34341__i + 2]; ++G__34341__i;}
  zs = new cljs.core.IndexedSeq(G__34341__a,0);
} 
return G__34340__delegate.call(this,x,y,zs);};
G__34340.cljs$lang$maxFixedArity = 2;
G__34340.cljs$lang$applyTo = (function (arglist__34342){
var x = cljs.core.first(arglist__34342);
arglist__34342 = cljs.core.next(arglist__34342);
var y = cljs.core.first(arglist__34342);
var zs = cljs.core.rest(arglist__34342);
return G__34340__delegate(x,y,zs);
});
G__34340.cljs$core$IFn$_invoke$arity$variadic = G__34340__delegate;
return G__34340;
})()
;
G__34339 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__34339__0.call(this);
case 1:
return G__34339__1.call(this,x);
case 2:
return G__34339__2.call(this,x,y);
default:
var G__34343 = null;
if (arguments.length > 2) {
var G__34344__i = 0, G__34344__a = new Array(arguments.length -  2);
while (G__34344__i < G__34344__a.length) {G__34344__a[G__34344__i] = arguments[G__34344__i + 2]; ++G__34344__i;}
G__34343 = new cljs.core.IndexedSeq(G__34344__a,0);
}
return G__34339__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__34343);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34339.cljs$lang$maxFixedArity = 2;
G__34339.cljs$lang$applyTo = G__34339__3.cljs$lang$applyTo;
G__34339.cljs$core$IFn$_invoke$arity$0 = G__34339__0;
G__34339.cljs$core$IFn$_invoke$arity$1 = G__34339__1;
G__34339.cljs$core$IFn$_invoke$arity$2 = G__34339__2;
G__34339.cljs$core$IFn$_invoke$arity$variadic = G__34339__3.cljs$core$IFn$_invoke$arity$variadic;
return G__34339;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__34345__delegate = function (args){
return x;
};
var G__34345 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34346__i = 0, G__34346__a = new Array(arguments.length -  0);
while (G__34346__i < G__34346__a.length) {G__34346__a[G__34346__i] = arguments[G__34346__i + 0]; ++G__34346__i;}
  args = new cljs.core.IndexedSeq(G__34346__a,0);
} 
return G__34345__delegate.call(this,args);};
G__34345.cljs$lang$maxFixedArity = 0;
G__34345.cljs$lang$applyTo = (function (arglist__34347){
var args = cljs.core.seq(arglist__34347);
return G__34345__delegate(args);
});
G__34345.cljs$core$IFn$_invoke$arity$variadic = G__34345__delegate;
return G__34345;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 *   of those fns.  The returned fn takes a variable number of args,
 *   applies the rightmost of fns to the args, the next
 *   fn (right-to-left) to the result, etc.
 */
cljs.core.comp = (function cljs$core$comp(var_args){
var args34348 = [];
var len__7211__auto___34375 = arguments.length;
var i__7212__auto___34376 = (0);
while(true){
if((i__7212__auto___34376 < len__7211__auto___34375)){
args34348.push((arguments[i__7212__auto___34376]));

var G__34377 = (i__7212__auto___34376 + (1));
i__7212__auto___34376 = G__34377;
continue;
} else {
}
break;
}

var G__34354 = args34348.length;
switch (G__34354) {
case 0:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.comp.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34348.slice((3)),(0)));
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.identity;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__34379 = null;
var G__34379__0 = (function (){
var G__34355 = (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34355) : f.call(null,G__34355));
});
var G__34379__1 = (function (x){
var G__34356 = (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34356) : f.call(null,G__34356));
});
var G__34379__2 = (function (x,y){
var G__34357 = (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34357) : f.call(null,G__34357));
});
var G__34379__3 = (function (x,y,z){
var G__34358 = (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z));
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34358) : f.call(null,G__34358));
});
var G__34379__4 = (function() { 
var G__34380__delegate = function (x,y,z,args){
var G__34359 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34359) : f.call(null,G__34359));
};
var G__34380 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34381__i = 0, G__34381__a = new Array(arguments.length -  3);
while (G__34381__i < G__34381__a.length) {G__34381__a[G__34381__i] = arguments[G__34381__i + 3]; ++G__34381__i;}
  args = new cljs.core.IndexedSeq(G__34381__a,0);
} 
return G__34380__delegate.call(this,x,y,z,args);};
G__34380.cljs$lang$maxFixedArity = 3;
G__34380.cljs$lang$applyTo = (function (arglist__34382){
var x = cljs.core.first(arglist__34382);
arglist__34382 = cljs.core.next(arglist__34382);
var y = cljs.core.first(arglist__34382);
arglist__34382 = cljs.core.next(arglist__34382);
var z = cljs.core.first(arglist__34382);
var args = cljs.core.rest(arglist__34382);
return G__34380__delegate(x,y,z,args);
});
G__34380.cljs$core$IFn$_invoke$arity$variadic = G__34380__delegate;
return G__34380;
})()
;
G__34379 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__34379__0.call(this);
case 1:
return G__34379__1.call(this,x);
case 2:
return G__34379__2.call(this,x,y);
case 3:
return G__34379__3.call(this,x,y,z);
default:
var G__34383 = null;
if (arguments.length > 3) {
var G__34384__i = 0, G__34384__a = new Array(arguments.length -  3);
while (G__34384__i < G__34384__a.length) {G__34384__a[G__34384__i] = arguments[G__34384__i + 3]; ++G__34384__i;}
G__34383 = new cljs.core.IndexedSeq(G__34384__a,0);
}
return G__34379__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34379.cljs$lang$maxFixedArity = 3;
G__34379.cljs$lang$applyTo = G__34379__4.cljs$lang$applyTo;
G__34379.cljs$core$IFn$_invoke$arity$0 = G__34379__0;
G__34379.cljs$core$IFn$_invoke$arity$1 = G__34379__1;
G__34379.cljs$core$IFn$_invoke$arity$2 = G__34379__2;
G__34379.cljs$core$IFn$_invoke$arity$3 = G__34379__3;
G__34379.cljs$core$IFn$_invoke$arity$variadic = G__34379__4.cljs$core$IFn$_invoke$arity$variadic;
return G__34379;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__34385 = null;
var G__34385__0 = (function (){
var G__34361 = (function (){var G__34362 = (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__34362) : g.call(null,G__34362));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34361) : f.call(null,G__34361));
});
var G__34385__1 = (function (x){
var G__34364 = (function (){var G__34365 = (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__34365) : g.call(null,G__34365));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34364) : f.call(null,G__34364));
});
var G__34385__2 = (function (x,y){
var G__34367 = (function (){var G__34368 = (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__34368) : g.call(null,G__34368));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34367) : f.call(null,G__34367));
});
var G__34385__3 = (function (x,y,z){
var G__34370 = (function (){var G__34371 = (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z));
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__34371) : g.call(null,G__34371));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34370) : f.call(null,G__34370));
});
var G__34385__4 = (function() { 
var G__34386__delegate = function (x,y,z,args){
var G__34373 = (function (){var G__34374 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__34374) : g.call(null,G__34374));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34373) : f.call(null,G__34373));
};
var G__34386 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34387__i = 0, G__34387__a = new Array(arguments.length -  3);
while (G__34387__i < G__34387__a.length) {G__34387__a[G__34387__i] = arguments[G__34387__i + 3]; ++G__34387__i;}
  args = new cljs.core.IndexedSeq(G__34387__a,0);
} 
return G__34386__delegate.call(this,x,y,z,args);};
G__34386.cljs$lang$maxFixedArity = 3;
G__34386.cljs$lang$applyTo = (function (arglist__34388){
var x = cljs.core.first(arglist__34388);
arglist__34388 = cljs.core.next(arglist__34388);
var y = cljs.core.first(arglist__34388);
arglist__34388 = cljs.core.next(arglist__34388);
var z = cljs.core.first(arglist__34388);
var args = cljs.core.rest(arglist__34388);
return G__34386__delegate(x,y,z,args);
});
G__34386.cljs$core$IFn$_invoke$arity$variadic = G__34386__delegate;
return G__34386;
})()
;
G__34385 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__34385__0.call(this);
case 1:
return G__34385__1.call(this,x);
case 2:
return G__34385__2.call(this,x,y);
case 3:
return G__34385__3.call(this,x,y,z);
default:
var G__34389 = null;
if (arguments.length > 3) {
var G__34390__i = 0, G__34390__a = new Array(arguments.length -  3);
while (G__34390__i < G__34390__a.length) {G__34390__a[G__34390__i] = arguments[G__34390__i + 3]; ++G__34390__i;}
G__34389 = new cljs.core.IndexedSeq(G__34390__a,0);
}
return G__34385__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34389);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34385.cljs$lang$maxFixedArity = 3;
G__34385.cljs$lang$applyTo = G__34385__4.cljs$lang$applyTo;
G__34385.cljs$core$IFn$_invoke$arity$0 = G__34385__0;
G__34385.cljs$core$IFn$_invoke$arity$1 = G__34385__1;
G__34385.cljs$core$IFn$_invoke$arity$2 = G__34385__2;
G__34385.cljs$core$IFn$_invoke$arity$3 = G__34385__3;
G__34385.cljs$core$IFn$_invoke$arity$variadic = G__34385__4.cljs$core$IFn$_invoke$arity$variadic;
return G__34385;
})()
});

cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic = (function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__34391__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__34392 = cljs.core.first(fs__$2).call(null,ret);
var G__34393 = cljs.core.next(fs__$2);
ret = G__34392;
fs__$2 = G__34393;
continue;
} else {
return ret;
}
break;
}
};
var G__34391 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34394__i = 0, G__34394__a = new Array(arguments.length -  0);
while (G__34394__i < G__34394__a.length) {G__34394__a[G__34394__i] = arguments[G__34394__i + 0]; ++G__34394__i;}
  args = new cljs.core.IndexedSeq(G__34394__a,0);
} 
return G__34391__delegate.call(this,args);};
G__34391.cljs$lang$maxFixedArity = 0;
G__34391.cljs$lang$applyTo = (function (arglist__34395){
var args = cljs.core.seq(arglist__34395);
return G__34391__delegate(args);
});
G__34391.cljs$core$IFn$_invoke$arity$variadic = G__34391__delegate;
return G__34391;
})()
;
;})(fs__$1))
});

cljs.core.comp.cljs$lang$applyTo = (function (seq34349){
var G__34350 = cljs.core.first(seq34349);
var seq34349__$1 = cljs.core.next(seq34349);
var G__34351 = cljs.core.first(seq34349__$1);
var seq34349__$2 = cljs.core.next(seq34349__$1);
var G__34352 = cljs.core.first(seq34349__$2);
var seq34349__$3 = cljs.core.next(seq34349__$2);
return cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(G__34350,G__34351,G__34352,seq34349__$3);
});

cljs.core.comp.cljs$lang$maxFixedArity = (3);
/**
 * Takes a function f and fewer than the normal arguments to f, and
 *   returns a fn that takes a variable number of additional args. When
 *   called, the returned function calls f with args + additional args.
 */
cljs.core.partial = (function cljs$core$partial(var_args){
var args34396 = [];
var len__7211__auto___34404 = arguments.length;
var i__7212__auto___34405 = (0);
while(true){
if((i__7212__auto___34405 < len__7211__auto___34404)){
args34396.push((arguments[i__7212__auto___34405]));

var G__34406 = (i__7212__auto___34405 + (1));
i__7212__auto___34405 = G__34406;
continue;
} else {
}
break;
}

var G__34403 = args34396.length;
switch (G__34403) {
case 1:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partial.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34396.slice((4)),(0)));
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7230__auto__);

}
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$1 = (function (f){
return f;
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$2 = (function (f,arg1){
return (function() {
var G__34408 = null;
var G__34408__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(arg1) : f.call(null,arg1));
});
var G__34408__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,x) : f.call(null,arg1,x));
});
var G__34408__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,x,y) : f.call(null,arg1,x,y));
});
var G__34408__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,x,y,z) : f.call(null,arg1,x,y,z));
});
var G__34408__4 = (function() { 
var G__34409__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__34409 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34410__i = 0, G__34410__a = new Array(arguments.length -  3);
while (G__34410__i < G__34410__a.length) {G__34410__a[G__34410__i] = arguments[G__34410__i + 3]; ++G__34410__i;}
  args = new cljs.core.IndexedSeq(G__34410__a,0);
} 
return G__34409__delegate.call(this,x,y,z,args);};
G__34409.cljs$lang$maxFixedArity = 3;
G__34409.cljs$lang$applyTo = (function (arglist__34411){
var x = cljs.core.first(arglist__34411);
arglist__34411 = cljs.core.next(arglist__34411);
var y = cljs.core.first(arglist__34411);
arglist__34411 = cljs.core.next(arglist__34411);
var z = cljs.core.first(arglist__34411);
var args = cljs.core.rest(arglist__34411);
return G__34409__delegate(x,y,z,args);
});
G__34409.cljs$core$IFn$_invoke$arity$variadic = G__34409__delegate;
return G__34409;
})()
;
G__34408 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__34408__0.call(this);
case 1:
return G__34408__1.call(this,x);
case 2:
return G__34408__2.call(this,x,y);
case 3:
return G__34408__3.call(this,x,y,z);
default:
var G__34412 = null;
if (arguments.length > 3) {
var G__34413__i = 0, G__34413__a = new Array(arguments.length -  3);
while (G__34413__i < G__34413__a.length) {G__34413__a[G__34413__i] = arguments[G__34413__i + 3]; ++G__34413__i;}
G__34412 = new cljs.core.IndexedSeq(G__34413__a,0);
}
return G__34408__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34408.cljs$lang$maxFixedArity = 3;
G__34408.cljs$lang$applyTo = G__34408__4.cljs$lang$applyTo;
G__34408.cljs$core$IFn$_invoke$arity$0 = G__34408__0;
G__34408.cljs$core$IFn$_invoke$arity$1 = G__34408__1;
G__34408.cljs$core$IFn$_invoke$arity$2 = G__34408__2;
G__34408.cljs$core$IFn$_invoke$arity$3 = G__34408__3;
G__34408.cljs$core$IFn$_invoke$arity$variadic = G__34408__4.cljs$core$IFn$_invoke$arity$variadic;
return G__34408;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$3 = (function (f,arg1,arg2){
return (function() {
var G__34414 = null;
var G__34414__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(arg1,arg2) : f.call(null,arg1,arg2));
});
var G__34414__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,x) : f.call(null,arg1,arg2,x));
});
var G__34414__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,x,y) : f.call(null,arg1,arg2,x,y));
});
var G__34414__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,x,y,z) : f.call(null,arg1,arg2,x,y,z));
});
var G__34414__4 = (function() { 
var G__34415__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__34415 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34416__i = 0, G__34416__a = new Array(arguments.length -  3);
while (G__34416__i < G__34416__a.length) {G__34416__a[G__34416__i] = arguments[G__34416__i + 3]; ++G__34416__i;}
  args = new cljs.core.IndexedSeq(G__34416__a,0);
} 
return G__34415__delegate.call(this,x,y,z,args);};
G__34415.cljs$lang$maxFixedArity = 3;
G__34415.cljs$lang$applyTo = (function (arglist__34417){
var x = cljs.core.first(arglist__34417);
arglist__34417 = cljs.core.next(arglist__34417);
var y = cljs.core.first(arglist__34417);
arglist__34417 = cljs.core.next(arglist__34417);
var z = cljs.core.first(arglist__34417);
var args = cljs.core.rest(arglist__34417);
return G__34415__delegate(x,y,z,args);
});
G__34415.cljs$core$IFn$_invoke$arity$variadic = G__34415__delegate;
return G__34415;
})()
;
G__34414 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__34414__0.call(this);
case 1:
return G__34414__1.call(this,x);
case 2:
return G__34414__2.call(this,x,y);
case 3:
return G__34414__3.call(this,x,y,z);
default:
var G__34418 = null;
if (arguments.length > 3) {
var G__34419__i = 0, G__34419__a = new Array(arguments.length -  3);
while (G__34419__i < G__34419__a.length) {G__34419__a[G__34419__i] = arguments[G__34419__i + 3]; ++G__34419__i;}
G__34418 = new cljs.core.IndexedSeq(G__34419__a,0);
}
return G__34414__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34418);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34414.cljs$lang$maxFixedArity = 3;
G__34414.cljs$lang$applyTo = G__34414__4.cljs$lang$applyTo;
G__34414.cljs$core$IFn$_invoke$arity$0 = G__34414__0;
G__34414.cljs$core$IFn$_invoke$arity$1 = G__34414__1;
G__34414.cljs$core$IFn$_invoke$arity$2 = G__34414__2;
G__34414.cljs$core$IFn$_invoke$arity$3 = G__34414__3;
G__34414.cljs$core$IFn$_invoke$arity$variadic = G__34414__4.cljs$core$IFn$_invoke$arity$variadic;
return G__34414;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__34420 = null;
var G__34420__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(arg1,arg2,arg3) : f.call(null,arg1,arg2,arg3));
});
var G__34420__1 = (function (x){
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(arg1,arg2,arg3,x) : f.call(null,arg1,arg2,arg3,x));
});
var G__34420__2 = (function (x,y){
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(arg1,arg2,arg3,x,y) : f.call(null,arg1,arg2,arg3,x,y));
});
var G__34420__3 = (function (x,y,z){
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(arg1,arg2,arg3,x,y,z) : f.call(null,arg1,arg2,arg3,x,y,z));
});
var G__34420__4 = (function() { 
var G__34421__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__34421 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34422__i = 0, G__34422__a = new Array(arguments.length -  3);
while (G__34422__i < G__34422__a.length) {G__34422__a[G__34422__i] = arguments[G__34422__i + 3]; ++G__34422__i;}
  args = new cljs.core.IndexedSeq(G__34422__a,0);
} 
return G__34421__delegate.call(this,x,y,z,args);};
G__34421.cljs$lang$maxFixedArity = 3;
G__34421.cljs$lang$applyTo = (function (arglist__34423){
var x = cljs.core.first(arglist__34423);
arglist__34423 = cljs.core.next(arglist__34423);
var y = cljs.core.first(arglist__34423);
arglist__34423 = cljs.core.next(arglist__34423);
var z = cljs.core.first(arglist__34423);
var args = cljs.core.rest(arglist__34423);
return G__34421__delegate(x,y,z,args);
});
G__34421.cljs$core$IFn$_invoke$arity$variadic = G__34421__delegate;
return G__34421;
})()
;
G__34420 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__34420__0.call(this);
case 1:
return G__34420__1.call(this,x);
case 2:
return G__34420__2.call(this,x,y);
case 3:
return G__34420__3.call(this,x,y,z);
default:
var G__34424 = null;
if (arguments.length > 3) {
var G__34425__i = 0, G__34425__a = new Array(arguments.length -  3);
while (G__34425__i < G__34425__a.length) {G__34425__a[G__34425__i] = arguments[G__34425__i + 3]; ++G__34425__i;}
G__34424 = new cljs.core.IndexedSeq(G__34425__a,0);
}
return G__34420__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34420.cljs$lang$maxFixedArity = 3;
G__34420.cljs$lang$applyTo = G__34420__4.cljs$lang$applyTo;
G__34420.cljs$core$IFn$_invoke$arity$0 = G__34420__0;
G__34420.cljs$core$IFn$_invoke$arity$1 = G__34420__1;
G__34420.cljs$core$IFn$_invoke$arity$2 = G__34420__2;
G__34420.cljs$core$IFn$_invoke$arity$3 = G__34420__3;
G__34420.cljs$core$IFn$_invoke$arity$variadic = G__34420__4.cljs$core$IFn$_invoke$arity$variadic;
return G__34420;
})()
});

cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic = (function (f,arg1,arg2,arg3,more){
return (function() { 
var G__34426__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__34426 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__34427__i = 0, G__34427__a = new Array(arguments.length -  0);
while (G__34427__i < G__34427__a.length) {G__34427__a[G__34427__i] = arguments[G__34427__i + 0]; ++G__34427__i;}
  args = new cljs.core.IndexedSeq(G__34427__a,0);
} 
return G__34426__delegate.call(this,args);};
G__34426.cljs$lang$maxFixedArity = 0;
G__34426.cljs$lang$applyTo = (function (arglist__34428){
var args = cljs.core.seq(arglist__34428);
return G__34426__delegate(args);
});
G__34426.cljs$core$IFn$_invoke$arity$variadic = G__34426__delegate;
return G__34426;
})()
;
});

cljs.core.partial.cljs$lang$applyTo = (function (seq34397){
var G__34398 = cljs.core.first(seq34397);
var seq34397__$1 = cljs.core.next(seq34397);
var G__34399 = cljs.core.first(seq34397__$1);
var seq34397__$2 = cljs.core.next(seq34397__$1);
var G__34400 = cljs.core.first(seq34397__$2);
var seq34397__$3 = cljs.core.next(seq34397__$2);
var G__34401 = cljs.core.first(seq34397__$3);
var seq34397__$4 = cljs.core.next(seq34397__$3);
return cljs.core.partial.cljs$core$IFn$_invoke$arity$variadic(G__34398,G__34399,G__34400,G__34401,seq34397__$4);
});

cljs.core.partial.cljs$lang$maxFixedArity = (4);
/**
 * Takes a function f, and returns a function that calls f, replacing
 *   a nil first argument to f with the supplied value x. Higher arity
 *   versions can replace arguments in the second and third
 *   positions (y, z). Note that the function f can take any number of
 *   arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function cljs$core$fnil(var_args){
var args34429 = [];
var len__7211__auto___34448 = arguments.length;
var i__7212__auto___34449 = (0);
while(true){
if((i__7212__auto___34449 < len__7211__auto___34448)){
args34429.push((arguments[i__7212__auto___34449]));

var G__34450 = (i__7212__auto___34449 + (1));
i__7212__auto___34449 = G__34450;
continue;
} else {
}
break;
}

var G__34431 = args34429.length;
switch (G__34431) {
case 2:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.fnil.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34429.length)].join('')));

}
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$2 = (function (f,x){
return (function() {
var G__34452 = null;
var G__34452__1 = (function (a){
var G__34432 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34432) : f.call(null,G__34432));
});
var G__34452__2 = (function (a,b){
var G__34433 = (((a == null))?x:a);
var G__34434 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34433,G__34434) : f.call(null,G__34433,G__34434));
});
var G__34452__3 = (function (a,b,c){
var G__34435 = (((a == null))?x:a);
var G__34436 = b;
var G__34437 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34435,G__34436,G__34437) : f.call(null,G__34435,G__34436,G__34437));
});
var G__34452__4 = (function() { 
var G__34453__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__34453 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__34454__i = 0, G__34454__a = new Array(arguments.length -  3);
while (G__34454__i < G__34454__a.length) {G__34454__a[G__34454__i] = arguments[G__34454__i + 3]; ++G__34454__i;}
  ds = new cljs.core.IndexedSeq(G__34454__a,0);
} 
return G__34453__delegate.call(this,a,b,c,ds);};
G__34453.cljs$lang$maxFixedArity = 3;
G__34453.cljs$lang$applyTo = (function (arglist__34455){
var a = cljs.core.first(arglist__34455);
arglist__34455 = cljs.core.next(arglist__34455);
var b = cljs.core.first(arglist__34455);
arglist__34455 = cljs.core.next(arglist__34455);
var c = cljs.core.first(arglist__34455);
var ds = cljs.core.rest(arglist__34455);
return G__34453__delegate(a,b,c,ds);
});
G__34453.cljs$core$IFn$_invoke$arity$variadic = G__34453__delegate;
return G__34453;
})()
;
G__34452 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__34452__1.call(this,a);
case 2:
return G__34452__2.call(this,a,b);
case 3:
return G__34452__3.call(this,a,b,c);
default:
var G__34456 = null;
if (arguments.length > 3) {
var G__34457__i = 0, G__34457__a = new Array(arguments.length -  3);
while (G__34457__i < G__34457__a.length) {G__34457__a[G__34457__i] = arguments[G__34457__i + 3]; ++G__34457__i;}
G__34456 = new cljs.core.IndexedSeq(G__34457__a,0);
}
return G__34452__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__34456);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34452.cljs$lang$maxFixedArity = 3;
G__34452.cljs$lang$applyTo = G__34452__4.cljs$lang$applyTo;
G__34452.cljs$core$IFn$_invoke$arity$1 = G__34452__1;
G__34452.cljs$core$IFn$_invoke$arity$2 = G__34452__2;
G__34452.cljs$core$IFn$_invoke$arity$3 = G__34452__3;
G__34452.cljs$core$IFn$_invoke$arity$variadic = G__34452__4.cljs$core$IFn$_invoke$arity$variadic;
return G__34452;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$3 = (function (f,x,y){
return (function() {
var G__34458 = null;
var G__34458__2 = (function (a,b){
var G__34438 = (((a == null))?x:a);
var G__34439 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34438,G__34439) : f.call(null,G__34438,G__34439));
});
var G__34458__3 = (function (a,b,c){
var G__34440 = (((a == null))?x:a);
var G__34441 = (((b == null))?y:b);
var G__34442 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34440,G__34441,G__34442) : f.call(null,G__34440,G__34441,G__34442));
});
var G__34458__4 = (function() { 
var G__34459__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__34459 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__34460__i = 0, G__34460__a = new Array(arguments.length -  3);
while (G__34460__i < G__34460__a.length) {G__34460__a[G__34460__i] = arguments[G__34460__i + 3]; ++G__34460__i;}
  ds = new cljs.core.IndexedSeq(G__34460__a,0);
} 
return G__34459__delegate.call(this,a,b,c,ds);};
G__34459.cljs$lang$maxFixedArity = 3;
G__34459.cljs$lang$applyTo = (function (arglist__34461){
var a = cljs.core.first(arglist__34461);
arglist__34461 = cljs.core.next(arglist__34461);
var b = cljs.core.first(arglist__34461);
arglist__34461 = cljs.core.next(arglist__34461);
var c = cljs.core.first(arglist__34461);
var ds = cljs.core.rest(arglist__34461);
return G__34459__delegate(a,b,c,ds);
});
G__34459.cljs$core$IFn$_invoke$arity$variadic = G__34459__delegate;
return G__34459;
})()
;
G__34458 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__34458__2.call(this,a,b);
case 3:
return G__34458__3.call(this,a,b,c);
default:
var G__34462 = null;
if (arguments.length > 3) {
var G__34463__i = 0, G__34463__a = new Array(arguments.length -  3);
while (G__34463__i < G__34463__a.length) {G__34463__a[G__34463__i] = arguments[G__34463__i + 3]; ++G__34463__i;}
G__34462 = new cljs.core.IndexedSeq(G__34463__a,0);
}
return G__34458__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__34462);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34458.cljs$lang$maxFixedArity = 3;
G__34458.cljs$lang$applyTo = G__34458__4.cljs$lang$applyTo;
G__34458.cljs$core$IFn$_invoke$arity$2 = G__34458__2;
G__34458.cljs$core$IFn$_invoke$arity$3 = G__34458__3;
G__34458.cljs$core$IFn$_invoke$arity$variadic = G__34458__4.cljs$core$IFn$_invoke$arity$variadic;
return G__34458;
})()
});

cljs.core.fnil.cljs$core$IFn$_invoke$arity$4 = (function (f,x,y,z){
return (function() {
var G__34464 = null;
var G__34464__2 = (function (a,b){
var G__34443 = (((a == null))?x:a);
var G__34444 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34443,G__34444) : f.call(null,G__34443,G__34444));
});
var G__34464__3 = (function (a,b,c){
var G__34445 = (((a == null))?x:a);
var G__34446 = (((b == null))?y:b);
var G__34447 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34445,G__34446,G__34447) : f.call(null,G__34445,G__34446,G__34447));
});
var G__34464__4 = (function() { 
var G__34465__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__34465 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__34466__i = 0, G__34466__a = new Array(arguments.length -  3);
while (G__34466__i < G__34466__a.length) {G__34466__a[G__34466__i] = arguments[G__34466__i + 3]; ++G__34466__i;}
  ds = new cljs.core.IndexedSeq(G__34466__a,0);
} 
return G__34465__delegate.call(this,a,b,c,ds);};
G__34465.cljs$lang$maxFixedArity = 3;
G__34465.cljs$lang$applyTo = (function (arglist__34467){
var a = cljs.core.first(arglist__34467);
arglist__34467 = cljs.core.next(arglist__34467);
var b = cljs.core.first(arglist__34467);
arglist__34467 = cljs.core.next(arglist__34467);
var c = cljs.core.first(arglist__34467);
var ds = cljs.core.rest(arglist__34467);
return G__34465__delegate(a,b,c,ds);
});
G__34465.cljs$core$IFn$_invoke$arity$variadic = G__34465__delegate;
return G__34465;
})()
;
G__34464 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__34464__2.call(this,a,b);
case 3:
return G__34464__3.call(this,a,b,c);
default:
var G__34468 = null;
if (arguments.length > 3) {
var G__34469__i = 0, G__34469__a = new Array(arguments.length -  3);
while (G__34469__i < G__34469__a.length) {G__34469__a[G__34469__i] = arguments[G__34469__i + 3]; ++G__34469__i;}
G__34468 = new cljs.core.IndexedSeq(G__34469__a,0);
}
return G__34464__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__34468);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34464.cljs$lang$maxFixedArity = 3;
G__34464.cljs$lang$applyTo = G__34464__4.cljs$lang$applyTo;
G__34464.cljs$core$IFn$_invoke$arity$2 = G__34464__2;
G__34464.cljs$core$IFn$_invoke$arity$3 = G__34464__3;
G__34464.cljs$core$IFn$_invoke$arity$variadic = G__34464__4.cljs$core$IFn$_invoke$arity$variadic;
return G__34464;
})()
});

cljs.core.fnil.cljs$lang$maxFixedArity = 4;
/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 *   and the first item of coll, followed by applying f to 1 and the second
 *   item in coll, etc, until coll is exhausted. Thus function f should
 *   accept 2 arguments, index and item. Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.map_indexed = (function cljs$core$map_indexed(var_args){
var args34470 = [];
var len__7211__auto___34503 = arguments.length;
var i__7212__auto___34504 = (0);
while(true){
if((i__7212__auto___34504 < len__7211__auto___34503)){
args34470.push((arguments[i__7212__auto___34504]));

var G__34505 = (i__7212__auto___34504 + (1));
i__7212__auto___34504 = G__34505;
continue;
} else {
}
break;
}

var G__34472 = args34470.length;
switch (G__34472) {
case 1:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34470.length)].join('')));

}
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var i = (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1((-1)) : cljs.core.volatile_BANG_.call(null,(-1)));
return ((function (i){
return (function() {
var G__34507 = null;
var G__34507__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34507__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34507__2 = (function (result,input){
var G__34475 = result;
var G__34476 = (function (){var G__34477 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__34478 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34477,G__34478) : f.call(null,G__34477,G__34478));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__34475,G__34476) : rf.call(null,G__34475,G__34476));
});
G__34507 = function(result,input){
switch(arguments.length){
case 0:
return G__34507__0.call(this);
case 1:
return G__34507__1.call(this,result);
case 2:
return G__34507__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34507.cljs$core$IFn$_invoke$arity$0 = G__34507__0;
G__34507.cljs$core$IFn$_invoke$arity$1 = G__34507__1;
G__34507.cljs$core$IFn$_invoke$arity$2 = G__34507__2;
return G__34507;
})()
;})(i))
});
});

cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var mapi = (function cljs$core$mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7056__auto___34508 = size;
var i_34509 = (0);
while(true){
if((i_34509 < n__7056__auto___34508)){
cljs.core.chunk_append(b,(function (){var G__34499 = (idx + i_34509);
var G__34500 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_34509);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34499,G__34500) : f.call(null,G__34499,G__34500));
})());

var G__34510 = (i_34509 + (1));
i_34509 = G__34510;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__34501 = idx;
var G__34502 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34501,G__34502) : f.call(null,G__34501,G__34502));
})(),cljs$core$mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});

cljs.core.map_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function cljs$core$keep(var_args){
var args34511 = [];
var len__7211__auto___34516 = arguments.length;
var i__7212__auto___34517 = (0);
while(true){
if((i__7212__auto___34517 < len__7211__auto___34516)){
args34511.push((arguments[i__7212__auto___34517]));

var G__34518 = (i__7212__auto___34517 + (1));
i__7212__auto___34517 = G__34518;
continue;
} else {
}
break;
}

var G__34513 = args34511.length;
switch (G__34513) {
case 1:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34511.length)].join('')));

}
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__34520 = null;
var G__34520__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34520__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34520__2 = (function (result,input){
var v = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__34520 = function(result,input){
switch(arguments.length){
case 0:
return G__34520__0.call(this);
case 1:
return G__34520__1.call(this,result);
case 2:
return G__34520__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34520.cljs$core$IFn$_invoke$arity$0 = G__34520__0;
G__34520.cljs$core$IFn$_invoke$arity$1 = G__34520__1;
G__34520.cljs$core$IFn$_invoke$arity$2 = G__34520__2;
return G__34520;
})()
});
});

cljs.core.keep.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7056__auto___34521 = size;
var i_34522 = (0);
while(true){
if((i_34522 < n__7056__auto___34521)){
var x_34523 = (function (){var G__34514 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_34522);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34514) : f.call(null,G__34514));
})();
if((x_34523 == null)){
} else {
cljs.core.chunk_append(b,x_34523);
}

var G__34524 = (i_34522 + (1));
i_34522 = G__34524;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__34515 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34515) : f.call(null,G__34515));
})();
if((x == null)){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.keep.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {cljs.core.IWatchable}
 * @implements {cljs.core.IAtom}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition1$ = 16386;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
})
cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__34525 = cljs.core.seq(self__.watches);
var chunk__34526 = null;
var count__34527 = (0);
var i__34528 = (0);
while(true){
if((i__34528 < count__34527)){
var vec__34529 = chunk__34526.cljs$core$IIndexed$_nth$arity$2(null,i__34528);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34529,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34529,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__34531 = seq__34525;
var G__34532 = chunk__34526;
var G__34533 = count__34527;
var G__34534 = (i__34528 + (1));
seq__34525 = G__34531;
chunk__34526 = G__34532;
count__34527 = G__34533;
i__34528 = G__34534;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__34525);
if(temp__4657__auto__){
var seq__34525__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__34525__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__34525__$1);
var G__34535 = cljs.core.chunk_rest(seq__34525__$1);
var G__34536 = c__6956__auto__;
var G__34537 = cljs.core.count(c__6956__auto__);
var G__34538 = (0);
seq__34525 = G__34535;
chunk__34526 = G__34536;
count__34527 = G__34537;
i__34528 = G__34538;
continue;
} else {
var vec__34530 = cljs.core.first(seq__34525__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34530,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34530,(1),null);
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(key,this$__$1,oldval,newval) : f.call(null,key,this$__$1,oldval,newval));

var G__34539 = cljs.core.next(seq__34525__$1);
var G__34540 = null;
var G__34541 = (0);
var G__34542 = (0);
seq__34525 = G__34539;
chunk__34526 = G__34540;
count__34527 = G__34541;
i__34528 = G__34542;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return goog.getUid(this$__$1);
});

cljs.core.Atom.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$state,cljs.core.cst$sym$meta,cljs.core.cst$sym$validator,cljs.core.cst$sym$watches], null);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 *   more options (in any order):
 * 
 *   :meta metadata-map
 * 
 *   :validator validate-fn
 * 
 *   If metadata-map is supplied, it will be come the metadata on the
 *   atom. validate-fn must be nil or a side-effect-free fn of one
 *   argument, which will be passed the intended new state on any state
 *   change. If the new state is unacceptable, the validate-fn should
 *   return false or throw an Error.  If either of these error conditions
 *   occur, then the value of the atom will not change.
 */
cljs.core.atom = (function cljs$core$atom(var_args){
var args34543 = [];
var len__7211__auto___34551 = arguments.length;
var i__7212__auto___34552 = (0);
while(true){
if((i__7212__auto___34552 < len__7211__auto___34551)){
args34543.push((arguments[i__7212__auto___34552]));

var G__34553 = (i__7212__auto___34552 + (1));
i__7212__auto___34552 = G__34553;
continue;
} else {
}
break;
}

var G__34547 = args34543.length;
switch (G__34547) {
case 1:
return cljs.core.atom.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34543.slice((1)),(0)));
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7230__auto__);

}
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});

cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic = (function (x,p__34548){
var map__34549 = p__34548;
var map__34549__$1 = ((((!((map__34549 == null)))?((((map__34549.cljs$lang$protocol_mask$partition0$ & (64))) || (map__34549.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34549):map__34549);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34549__$1,cljs.core.cst$kw$meta);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34549__$1,cljs.core.cst$kw$validator);
return (new cljs.core.Atom(x,meta,validator,null));
});

cljs.core.atom.cljs$lang$applyTo = (function (seq34544){
var G__34545 = cljs.core.first(seq34544);
var seq34544__$1 = cljs.core.next(seq34544);
return cljs.core.atom.cljs$core$IFn$_invoke$arity$variadic(G__34545,seq34544__$1);
});

cljs.core.atom.cljs$lang$maxFixedArity = (1);
/**
 * Sets the value of atom to newval without regard for the
 *   current value. Returns newval.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(new_value) : validate.call(null,new_value)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__34556 = cljs.core.list(cljs.core.cst$sym$validate,cljs.core.cst$sym$new_DASH_value);
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__34556) : cljs.core.pr_str.call(null,G__34556));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 *   (apply f current-value-of-atom args). Note that f may be called
 *   multiple times, and thus should be free of side effects.  Returns
 *   the value that was swapped in.
 */
cljs.core.swap_BANG_ = (function cljs$core$swap_BANG_(var_args){
var args34557 = [];
var len__7211__auto___34571 = arguments.length;
var i__7212__auto___34572 = (0);
while(true){
if((i__7212__auto___34572 < len__7211__auto___34571)){
args34557.push((arguments[i__7212__auto___34572]));

var G__34573 = (i__7212__auto___34572 + (1));
i__7212__auto___34572 = G__34573;
continue;
} else {
}
break;
}

var G__34564 = args34557.length;
switch (G__34564) {
case 2:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34557.slice((4)),(0)));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7230__auto__);

}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__34565 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34565) : f.call(null,G__34565));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__34566 = a.state;
var G__34567 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34566,G__34567) : f.call(null,G__34566,G__34567));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__34568 = a.state;
var G__34569 = x;
var G__34570 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34568,G__34569,G__34570) : f.call(null,G__34568,G__34569,G__34570));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
});

cljs.core.swap_BANG_.cljs$lang$applyTo = (function (seq34558){
var G__34559 = cljs.core.first(seq34558);
var seq34558__$1 = cljs.core.next(seq34558);
var G__34560 = cljs.core.first(seq34558__$1);
var seq34558__$2 = cljs.core.next(seq34558__$1);
var G__34561 = cljs.core.first(seq34558__$2);
var seq34558__$3 = cljs.core.next(seq34558__$2);
var G__34562 = cljs.core.first(seq34558__$3);
var seq34558__$4 = cljs.core.next(seq34558__$3);
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__34559,G__34560,G__34561,G__34562,seq34558__$4);
});

cljs.core.swap_BANG_.cljs$lang$maxFixedArity = (4);
/**
 * Atomically sets the value of atom to newval if and only if the
 *   current value of the atom is equal to oldval. Returns true if
 *   set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 *   side-effect-free fn of one argument, which will be passed the intended
 *   new state on any state change. If the new state is unacceptable, the
 *   validator-fn should return false or throw an Error. If the current state
 *   is not acceptable to the new validator, an Error will be thrown and the
 *   validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
 * @implements {cljs.core.IVolatile}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$state,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 *   this means false return values will be included.  f must be free of
 *   side-effects.  Returns a stateful transducer when no collection is
 *   provided.
 */
cljs.core.keep_indexed = (function cljs$core$keep_indexed(var_args){
var args34575 = [];
var len__7211__auto___34606 = arguments.length;
var i__7212__auto___34607 = (0);
while(true){
if((i__7212__auto___34607 < len__7211__auto___34606)){
args34575.push((arguments[i__7212__auto___34607]));

var G__34608 = (i__7212__auto___34607 + (1));
i__7212__auto___34607 = G__34608;
continue;
} else {
}
break;
}

var G__34577 = args34575.length;
switch (G__34577) {
case 1:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34575.length)].join('')));

}
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__34610 = null;
var G__34610__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34610__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34610__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
var v = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(i,input) : f.call(null,i,input));
if((v == null)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
}
});
G__34610 = function(result,input){
switch(arguments.length){
case 0:
return G__34610__0.call(this);
case 1:
return G__34610__1.call(this,result);
case 2:
return G__34610__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34610.cljs$core$IFn$_invoke$arity$0 = G__34610__0;
G__34610.cljs$core$IFn$_invoke$arity$1 = G__34610__1;
G__34610.cljs$core$IFn$_invoke$arity$2 = G__34610__2;
return G__34610;
})()
;})(ia))
});
});

cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
var keepi = (function cljs$core$keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7056__auto___34611 = size;
var i_34612 = (0);
while(true){
if((i_34612 < n__7056__auto___34611)){
var x_34613 = (function (){var G__34602 = (idx + i_34612);
var G__34603 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_34612);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34602,G__34603) : f.call(null,G__34602,G__34603));
})();
if((x_34613 == null)){
} else {
cljs.core.chunk_append(b,x_34613);
}

var G__34614 = (i_34612 + (1));
i_34612 = G__34614;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__34604 = idx;
var G__34605 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34604,G__34605) : f.call(null,G__34604,G__34605));
})();
if((x == null)){
return cljs$core$keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});

cljs.core.keep_indexed.cljs$lang$maxFixedArity = 2;
/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 *   composing predicates return a logical true value against all of its arguments, else it returns
 *   false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical false result against the original predicates.
 */
cljs.core.every_pred = (function cljs$core$every_pred(var_args){
var args34621 = [];
var len__7211__auto___34628 = arguments.length;
var i__7212__auto___34629 = (0);
while(true){
if((i__7212__auto___34629 < len__7211__auto___34628)){
args34621.push((arguments[i__7212__auto___34629]));

var G__34630 = (i__7212__auto___34629 + (1));
i__7212__auto___34629 = G__34630;
continue;
} else {
}
break;
}

var G__34627 = args34621.length;
switch (G__34627) {
case 1:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34621.slice((3)),(0)));
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$ep1 = null;
var cljs$core$ep1__0 = (function (){
return true;
});
var cljs$core$ep1__1 = (function (x){
return cljs.core.boolean$((p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x)));
});
var cljs$core$ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6141__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
} else {
return and__6141__auto__;
}
})());
});
var cljs$core$ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6141__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(and__6141__auto____$1)){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})());
});
var cljs$core$ep1__4 = (function() { 
var G__34632__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6141__auto__ = cljs$core$ep1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6141__auto__)){
return cljs.core.every_QMARK_(p,args);
} else {
return and__6141__auto__;
}
})());
};
var G__34632 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34633__i = 0, G__34633__a = new Array(arguments.length -  3);
while (G__34633__i < G__34633__a.length) {G__34633__a[G__34633__i] = arguments[G__34633__i + 3]; ++G__34633__i;}
  args = new cljs.core.IndexedSeq(G__34633__a,0);
} 
return G__34632__delegate.call(this,x,y,z,args);};
G__34632.cljs$lang$maxFixedArity = 3;
G__34632.cljs$lang$applyTo = (function (arglist__34634){
var x = cljs.core.first(arglist__34634);
arglist__34634 = cljs.core.next(arglist__34634);
var y = cljs.core.first(arglist__34634);
arglist__34634 = cljs.core.next(arglist__34634);
var z = cljs.core.first(arglist__34634);
var args = cljs.core.rest(arglist__34634);
return G__34632__delegate(x,y,z,args);
});
G__34632.cljs$core$IFn$_invoke$arity$variadic = G__34632__delegate;
return G__34632;
})()
;
cljs$core$ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep1__0.call(this);
case 1:
return cljs$core$ep1__1.call(this,x);
case 2:
return cljs$core$ep1__2.call(this,x,y);
case 3:
return cljs$core$ep1__3.call(this,x,y,z);
default:
var G__34635 = null;
if (arguments.length > 3) {
var G__34636__i = 0, G__34636__a = new Array(arguments.length -  3);
while (G__34636__i < G__34636__a.length) {G__34636__a[G__34636__i] = arguments[G__34636__i + 3]; ++G__34636__i;}
G__34635 = new cljs.core.IndexedSeq(G__34636__a,0);
}
return cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34635);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep1.cljs$lang$maxFixedArity = 3;
cljs$core$ep1.cljs$lang$applyTo = cljs$core$ep1__4.cljs$lang$applyTo;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep1__0;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep1__1;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep1__2;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep1__3;
cljs$core$ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep1;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$ep2 = null;
var cljs$core$ep2__0 = (function (){
return true;
});
var cljs$core$ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__6141__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
} else {
return and__6141__auto__;
}
})());
});
var cljs$core$ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6141__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6141__auto____$1)){
var and__6141__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6141__auto____$2)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
} else {
return and__6141__auto____$2;
}
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})());
});
var cljs$core$ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6141__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6141__auto____$1)){
var and__6141__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__6141__auto____$2)){
var and__6141__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6141__auto____$3)){
var and__6141__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6141__auto____$4)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
} else {
return and__6141__auto____$4;
}
} else {
return and__6141__auto____$3;
}
} else {
return and__6141__auto____$2;
}
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})());
});
var cljs$core$ep2__4 = (function() { 
var G__34637__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6141__auto__ = cljs$core$ep2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6141__auto__)){
return cljs.core.every_QMARK_(((function (and__6141__auto__){
return (function (p1__34615_SHARP_){
var and__6141__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__34615_SHARP_) : p1.call(null,p1__34615_SHARP_));
if(cljs.core.truth_(and__6141__auto____$1)){
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__34615_SHARP_) : p2.call(null,p1__34615_SHARP_));
} else {
return and__6141__auto____$1;
}
});})(and__6141__auto__))
,args);
} else {
return and__6141__auto__;
}
})());
};
var G__34637 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34638__i = 0, G__34638__a = new Array(arguments.length -  3);
while (G__34638__i < G__34638__a.length) {G__34638__a[G__34638__i] = arguments[G__34638__i + 3]; ++G__34638__i;}
  args = new cljs.core.IndexedSeq(G__34638__a,0);
} 
return G__34637__delegate.call(this,x,y,z,args);};
G__34637.cljs$lang$maxFixedArity = 3;
G__34637.cljs$lang$applyTo = (function (arglist__34639){
var x = cljs.core.first(arglist__34639);
arglist__34639 = cljs.core.next(arglist__34639);
var y = cljs.core.first(arglist__34639);
arglist__34639 = cljs.core.next(arglist__34639);
var z = cljs.core.first(arglist__34639);
var args = cljs.core.rest(arglist__34639);
return G__34637__delegate(x,y,z,args);
});
G__34637.cljs$core$IFn$_invoke$arity$variadic = G__34637__delegate;
return G__34637;
})()
;
cljs$core$ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep2__0.call(this);
case 1:
return cljs$core$ep2__1.call(this,x);
case 2:
return cljs$core$ep2__2.call(this,x,y);
case 3:
return cljs$core$ep2__3.call(this,x,y,z);
default:
var G__34640 = null;
if (arguments.length > 3) {
var G__34641__i = 0, G__34641__a = new Array(arguments.length -  3);
while (G__34641__i < G__34641__a.length) {G__34641__a[G__34641__i] = arguments[G__34641__i + 3]; ++G__34641__i;}
G__34640 = new cljs.core.IndexedSeq(G__34641__a,0);
}
return cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep2.cljs$lang$maxFixedArity = 3;
cljs$core$ep2.cljs$lang$applyTo = cljs$core$ep2__4.cljs$lang$applyTo;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep2__0;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep2__1;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep2__2;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep2__3;
cljs$core$ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep2;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$ep3 = null;
var cljs$core$ep3__0 = (function (){
return true;
});
var cljs$core$ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__6141__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6141__auto____$1)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})());
});
var cljs$core$ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__6141__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6141__auto____$1)){
var and__6141__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__6141__auto____$2)){
var and__6141__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6141__auto____$3)){
var and__6141__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6141__auto____$4)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
} else {
return and__6141__auto____$4;
}
} else {
return and__6141__auto____$3;
}
} else {
return and__6141__auto____$2;
}
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})());
});
var cljs$core$ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__6141__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(and__6141__auto____$1)){
var and__6141__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(and__6141__auto____$2)){
var and__6141__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(and__6141__auto____$3)){
var and__6141__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(and__6141__auto____$4)){
var and__6141__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(and__6141__auto____$5)){
var and__6141__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(and__6141__auto____$6)){
var and__6141__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(and__6141__auto____$7)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
} else {
return and__6141__auto____$7;
}
} else {
return and__6141__auto____$6;
}
} else {
return and__6141__auto____$5;
}
} else {
return and__6141__auto____$4;
}
} else {
return and__6141__auto____$3;
}
} else {
return and__6141__auto____$2;
}
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})());
});
var cljs$core$ep3__4 = (function() { 
var G__34642__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6141__auto__ = cljs$core$ep3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6141__auto__)){
return cljs.core.every_QMARK_(((function (and__6141__auto__){
return (function (p1__34616_SHARP_){
var and__6141__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__34616_SHARP_) : p1.call(null,p1__34616_SHARP_));
if(cljs.core.truth_(and__6141__auto____$1)){
var and__6141__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__34616_SHARP_) : p2.call(null,p1__34616_SHARP_));
if(cljs.core.truth_(and__6141__auto____$2)){
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__34616_SHARP_) : p3.call(null,p1__34616_SHARP_));
} else {
return and__6141__auto____$2;
}
} else {
return and__6141__auto____$1;
}
});})(and__6141__auto__))
,args);
} else {
return and__6141__auto__;
}
})());
};
var G__34642 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34643__i = 0, G__34643__a = new Array(arguments.length -  3);
while (G__34643__i < G__34643__a.length) {G__34643__a[G__34643__i] = arguments[G__34643__i + 3]; ++G__34643__i;}
  args = new cljs.core.IndexedSeq(G__34643__a,0);
} 
return G__34642__delegate.call(this,x,y,z,args);};
G__34642.cljs$lang$maxFixedArity = 3;
G__34642.cljs$lang$applyTo = (function (arglist__34644){
var x = cljs.core.first(arglist__34644);
arglist__34644 = cljs.core.next(arglist__34644);
var y = cljs.core.first(arglist__34644);
arglist__34644 = cljs.core.next(arglist__34644);
var z = cljs.core.first(arglist__34644);
var args = cljs.core.rest(arglist__34644);
return G__34642__delegate(x,y,z,args);
});
G__34642.cljs$core$IFn$_invoke$arity$variadic = G__34642__delegate;
return G__34642;
})()
;
cljs$core$ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$ep3__0.call(this);
case 1:
return cljs$core$ep3__1.call(this,x);
case 2:
return cljs$core$ep3__2.call(this,x,y);
case 3:
return cljs$core$ep3__3.call(this,x,y,z);
default:
var G__34645 = null;
if (arguments.length > 3) {
var G__34646__i = 0, G__34646__a = new Array(arguments.length -  3);
while (G__34646__i < G__34646__a.length) {G__34646__a[G__34646__i] = arguments[G__34646__i + 3]; ++G__34646__i;}
G__34645 = new cljs.core.IndexedSeq(G__34646__a,0);
}
return cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34645);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ep3.cljs$lang$maxFixedArity = 3;
cljs$core$ep3.cljs$lang$applyTo = cljs$core$ep3__4.cljs$lang$applyTo;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$ep3__0;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$ep3__1;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$ep3__2;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$ep3__3;
cljs$core$ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$ep3;
})()
});

cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$epn = null;
var cljs$core$epn__0 = (function (){
return true;
});
var cljs$core$epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__34617_SHARP_){
return (p1__34617_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34617_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__34617_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__34618_SHARP_){
var and__6141__auto__ = (p1__34618_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34618_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__34618_SHARP_.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
return (p1__34618_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34618_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__34618_SHARP_.call(null,y));
} else {
return and__6141__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__34619_SHARP_){
var and__6141__auto__ = (p1__34619_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34619_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__34619_SHARP_.call(null,x));
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (p1__34619_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34619_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__34619_SHARP_.call(null,y));
if(cljs.core.truth_(and__6141__auto____$1)){
return (p1__34619_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34619_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__34619_SHARP_.call(null,z));
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$epn__4 = (function() { 
var G__34647__delegate = function (x,y,z,args){
return cljs.core.boolean$((function (){var and__6141__auto__ = cljs$core$epn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(and__6141__auto__)){
return cljs.core.every_QMARK_(((function (and__6141__auto__,ps__$1){
return (function (p1__34620_SHARP_){
return cljs.core.every_QMARK_(p1__34620_SHARP_,args);
});})(and__6141__auto__,ps__$1))
,ps__$1);
} else {
return and__6141__auto__;
}
})());
};
var G__34647 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34648__i = 0, G__34648__a = new Array(arguments.length -  3);
while (G__34648__i < G__34648__a.length) {G__34648__a[G__34648__i] = arguments[G__34648__i + 3]; ++G__34648__i;}
  args = new cljs.core.IndexedSeq(G__34648__a,0);
} 
return G__34647__delegate.call(this,x,y,z,args);};
G__34647.cljs$lang$maxFixedArity = 3;
G__34647.cljs$lang$applyTo = (function (arglist__34649){
var x = cljs.core.first(arglist__34649);
arglist__34649 = cljs.core.next(arglist__34649);
var y = cljs.core.first(arglist__34649);
arglist__34649 = cljs.core.next(arglist__34649);
var z = cljs.core.first(arglist__34649);
var args = cljs.core.rest(arglist__34649);
return G__34647__delegate(x,y,z,args);
});
G__34647.cljs$core$IFn$_invoke$arity$variadic = G__34647__delegate;
return G__34647;
})()
;
cljs$core$epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$epn__0.call(this);
case 1:
return cljs$core$epn__1.call(this,x);
case 2:
return cljs$core$epn__2.call(this,x,y);
case 3:
return cljs$core$epn__3.call(this,x,y,z);
default:
var G__34650 = null;
if (arguments.length > 3) {
var G__34651__i = 0, G__34651__a = new Array(arguments.length -  3);
while (G__34651__i < G__34651__a.length) {G__34651__a[G__34651__i] = arguments[G__34651__i + 3]; ++G__34651__i;}
G__34650 = new cljs.core.IndexedSeq(G__34651__a,0);
}
return cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$epn.cljs$lang$maxFixedArity = 3;
cljs$core$epn.cljs$lang$applyTo = cljs$core$epn__4.cljs$lang$applyTo;
cljs$core$epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$epn__0;
cljs$core$epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$epn__1;
cljs$core$epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$epn__2;
cljs$core$epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$epn__3;
cljs$core$epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$epn;
})()
;})(ps__$1))
});

cljs.core.every_pred.cljs$lang$applyTo = (function (seq34622){
var G__34623 = cljs.core.first(seq34622);
var seq34622__$1 = cljs.core.next(seq34622);
var G__34624 = cljs.core.first(seq34622__$1);
var seq34622__$2 = cljs.core.next(seq34622__$1);
var G__34625 = cljs.core.first(seq34622__$2);
var seq34622__$3 = cljs.core.next(seq34622__$2);
return cljs.core.every_pred.cljs$core$IFn$_invoke$arity$variadic(G__34623,G__34624,G__34625,seq34622__$3);
});

cljs.core.every_pred.cljs$lang$maxFixedArity = (3);
/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 *   returned by one of its composing predicates against any of its arguments, else it returns
 *   logical false. Note that f is short-circuiting in that it will stop execution on the first
 *   argument that triggers a logical true result against the original predicates.
 */
cljs.core.some_fn = (function cljs$core$some_fn(var_args){
var args34658 = [];
var len__7211__auto___34665 = arguments.length;
var i__7212__auto___34666 = (0);
while(true){
if((i__7212__auto___34666 < len__7211__auto___34665)){
args34658.push((arguments[i__7212__auto___34666]));

var G__34667 = (i__7212__auto___34666 + (1));
i__7212__auto___34666 = G__34667;
continue;
} else {
}
break;
}

var G__34664 = args34658.length;
switch (G__34664) {
case 1:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34658.slice((3)),(0)));
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$1 = (function (p){
return (function() {
var cljs$core$sp1 = null;
var cljs$core$sp1__0 = (function (){
return null;
});
var cljs$core$sp1__1 = (function (x){
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
});
var cljs$core$sp1__2 = (function (x,y){
var or__6153__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
}
});
var cljs$core$sp1__3 = (function (x,y,z){
var or__6153__auto__ = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(x) : p.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(y) : p.call(null,y));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(z) : p.call(null,z));
}
}
});
var cljs$core$sp1__4 = (function() { 
var G__34669__delegate = function (x,y,z,args){
var or__6153__auto__ = cljs$core$sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__34669 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34670__i = 0, G__34670__a = new Array(arguments.length -  3);
while (G__34670__i < G__34670__a.length) {G__34670__a[G__34670__i] = arguments[G__34670__i + 3]; ++G__34670__i;}
  args = new cljs.core.IndexedSeq(G__34670__a,0);
} 
return G__34669__delegate.call(this,x,y,z,args);};
G__34669.cljs$lang$maxFixedArity = 3;
G__34669.cljs$lang$applyTo = (function (arglist__34671){
var x = cljs.core.first(arglist__34671);
arglist__34671 = cljs.core.next(arglist__34671);
var y = cljs.core.first(arglist__34671);
arglist__34671 = cljs.core.next(arglist__34671);
var z = cljs.core.first(arglist__34671);
var args = cljs.core.rest(arglist__34671);
return G__34669__delegate(x,y,z,args);
});
G__34669.cljs$core$IFn$_invoke$arity$variadic = G__34669__delegate;
return G__34669;
})()
;
cljs$core$sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp1__0.call(this);
case 1:
return cljs$core$sp1__1.call(this,x);
case 2:
return cljs$core$sp1__2.call(this,x,y);
case 3:
return cljs$core$sp1__3.call(this,x,y,z);
default:
var G__34672 = null;
if (arguments.length > 3) {
var G__34673__i = 0, G__34673__a = new Array(arguments.length -  3);
while (G__34673__i < G__34673__a.length) {G__34673__a[G__34673__i] = arguments[G__34673__i + 3]; ++G__34673__i;}
G__34672 = new cljs.core.IndexedSeq(G__34673__a,0);
}
return cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp1.cljs$lang$maxFixedArity = 3;
cljs$core$sp1.cljs$lang$applyTo = cljs$core$sp1__4.cljs$lang$applyTo;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp1__0;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp1__1;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp1__2;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp1__3;
cljs$core$sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp1;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$2 = (function (p1,p2){
return (function() {
var cljs$core$sp2 = null;
var cljs$core$sp2__0 = (function (){
return null;
});
var cljs$core$sp2__1 = (function (x){
var or__6153__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
}
});
var cljs$core$sp2__2 = (function (x,y){
var or__6153__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
var or__6153__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6153__auto____$2)){
return or__6153__auto____$2;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
}
}
}
});
var cljs$core$sp2__3 = (function (x,y,z){
var or__6153__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
var or__6153__auto____$2 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__6153__auto____$2)){
return or__6153__auto____$2;
} else {
var or__6153__auto____$3 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6153__auto____$3)){
return or__6153__auto____$3;
} else {
var or__6153__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6153__auto____$4)){
return or__6153__auto____$4;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
}
}
}
}
}
});
var cljs$core$sp2__4 = (function() { 
var G__34674__delegate = function (x,y,z,args){
var or__6153__auto__ = cljs$core$sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.some(((function (or__6153__auto__){
return (function (p1__34652_SHARP_){
var or__6153__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__34652_SHARP_) : p1.call(null,p1__34652_SHARP_));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__34652_SHARP_) : p2.call(null,p1__34652_SHARP_));
}
});})(or__6153__auto__))
,args);
}
};
var G__34674 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34675__i = 0, G__34675__a = new Array(arguments.length -  3);
while (G__34675__i < G__34675__a.length) {G__34675__a[G__34675__i] = arguments[G__34675__i + 3]; ++G__34675__i;}
  args = new cljs.core.IndexedSeq(G__34675__a,0);
} 
return G__34674__delegate.call(this,x,y,z,args);};
G__34674.cljs$lang$maxFixedArity = 3;
G__34674.cljs$lang$applyTo = (function (arglist__34676){
var x = cljs.core.first(arglist__34676);
arglist__34676 = cljs.core.next(arglist__34676);
var y = cljs.core.first(arglist__34676);
arglist__34676 = cljs.core.next(arglist__34676);
var z = cljs.core.first(arglist__34676);
var args = cljs.core.rest(arglist__34676);
return G__34674__delegate(x,y,z,args);
});
G__34674.cljs$core$IFn$_invoke$arity$variadic = G__34674__delegate;
return G__34674;
})()
;
cljs$core$sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp2__0.call(this);
case 1:
return cljs$core$sp2__1.call(this,x);
case 2:
return cljs$core$sp2__2.call(this,x,y);
case 3:
return cljs$core$sp2__3.call(this,x,y,z);
default:
var G__34677 = null;
if (arguments.length > 3) {
var G__34678__i = 0, G__34678__a = new Array(arguments.length -  3);
while (G__34678__i < G__34678__a.length) {G__34678__a[G__34678__i] = arguments[G__34678__i + 3]; ++G__34678__i;}
G__34677 = new cljs.core.IndexedSeq(G__34678__a,0);
}
return cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34677);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp2.cljs$lang$maxFixedArity = 3;
cljs$core$sp2.cljs$lang$applyTo = cljs$core$sp2__4.cljs$lang$applyTo;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp2__0;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp2__1;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp2__2;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp2__3;
cljs$core$sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp2;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$3 = (function (p1,p2,p3){
return (function() {
var cljs$core$sp3 = null;
var cljs$core$sp3__0 = (function (){
return null;
});
var cljs$core$sp3__1 = (function (x){
var or__6153__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
}
}
});
var cljs$core$sp3__2 = (function (x,y){
var or__6153__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
var or__6153__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__6153__auto____$2)){
return or__6153__auto____$2;
} else {
var or__6153__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6153__auto____$3)){
return or__6153__auto____$3;
} else {
var or__6153__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6153__auto____$4)){
return or__6153__auto____$4;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
}
}
}
}
}
});
var cljs$core$sp3__3 = (function (x,y,z){
var or__6153__auto__ = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(x) : p1.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(x) : p2.call(null,x));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
var or__6153__auto____$2 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(x) : p3.call(null,x));
if(cljs.core.truth_(or__6153__auto____$2)){
return or__6153__auto____$2;
} else {
var or__6153__auto____$3 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(y) : p1.call(null,y));
if(cljs.core.truth_(or__6153__auto____$3)){
return or__6153__auto____$3;
} else {
var or__6153__auto____$4 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(y) : p2.call(null,y));
if(cljs.core.truth_(or__6153__auto____$4)){
return or__6153__auto____$4;
} else {
var or__6153__auto____$5 = (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(y) : p3.call(null,y));
if(cljs.core.truth_(or__6153__auto____$5)){
return or__6153__auto____$5;
} else {
var or__6153__auto____$6 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(z) : p1.call(null,z));
if(cljs.core.truth_(or__6153__auto____$6)){
return or__6153__auto____$6;
} else {
var or__6153__auto____$7 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(z) : p2.call(null,z));
if(cljs.core.truth_(or__6153__auto____$7)){
return or__6153__auto____$7;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(z) : p3.call(null,z));
}
}
}
}
}
}
}
}
});
var cljs$core$sp3__4 = (function() { 
var G__34679__delegate = function (x,y,z,args){
var or__6153__auto__ = cljs$core$sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.some(((function (or__6153__auto__){
return (function (p1__34653_SHARP_){
var or__6153__auto____$1 = (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(p1__34653_SHARP_) : p1.call(null,p1__34653_SHARP_));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
var or__6153__auto____$2 = (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(p1__34653_SHARP_) : p2.call(null,p1__34653_SHARP_));
if(cljs.core.truth_(or__6153__auto____$2)){
return or__6153__auto____$2;
} else {
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(p1__34653_SHARP_) : p3.call(null,p1__34653_SHARP_));
}
}
});})(or__6153__auto__))
,args);
}
};
var G__34679 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34680__i = 0, G__34680__a = new Array(arguments.length -  3);
while (G__34680__i < G__34680__a.length) {G__34680__a[G__34680__i] = arguments[G__34680__i + 3]; ++G__34680__i;}
  args = new cljs.core.IndexedSeq(G__34680__a,0);
} 
return G__34679__delegate.call(this,x,y,z,args);};
G__34679.cljs$lang$maxFixedArity = 3;
G__34679.cljs$lang$applyTo = (function (arglist__34681){
var x = cljs.core.first(arglist__34681);
arglist__34681 = cljs.core.next(arglist__34681);
var y = cljs.core.first(arglist__34681);
arglist__34681 = cljs.core.next(arglist__34681);
var z = cljs.core.first(arglist__34681);
var args = cljs.core.rest(arglist__34681);
return G__34679__delegate(x,y,z,args);
});
G__34679.cljs$core$IFn$_invoke$arity$variadic = G__34679__delegate;
return G__34679;
})()
;
cljs$core$sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$sp3__0.call(this);
case 1:
return cljs$core$sp3__1.call(this,x);
case 2:
return cljs$core$sp3__2.call(this,x,y);
case 3:
return cljs$core$sp3__3.call(this,x,y,z);
default:
var G__34682 = null;
if (arguments.length > 3) {
var G__34683__i = 0, G__34683__a = new Array(arguments.length -  3);
while (G__34683__i < G__34683__a.length) {G__34683__a[G__34683__i] = arguments[G__34683__i + 3]; ++G__34683__i;}
G__34682 = new cljs.core.IndexedSeq(G__34683__a,0);
}
return cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sp3.cljs$lang$maxFixedArity = 3;
cljs$core$sp3.cljs$lang$applyTo = cljs$core$sp3__4.cljs$lang$applyTo;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$sp3__0;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$sp3__1;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$sp3__2;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$sp3__3;
cljs$core$sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sp3;
})()
});

cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic = (function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$spn = null;
var cljs$core$spn__0 = (function (){
return null;
});
var cljs$core$spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__34654_SHARP_){
return (p1__34654_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34654_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__34654_SHARP_.call(null,x));
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__34655_SHARP_){
var or__6153__auto__ = (p1__34655_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34655_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__34655_SHARP_.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return (p1__34655_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34655_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__34655_SHARP_.call(null,y));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__34656_SHARP_){
var or__6153__auto__ = (p1__34656_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34656_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p1__34656_SHARP_.call(null,x));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = (p1__34656_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34656_SHARP_.cljs$core$IFn$_invoke$arity$1(y) : p1__34656_SHARP_.call(null,y));
if(cljs.core.truth_(or__6153__auto____$1)){
return or__6153__auto____$1;
} else {
return (p1__34656_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__34656_SHARP_.cljs$core$IFn$_invoke$arity$1(z) : p1__34656_SHARP_.call(null,z));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$spn__4 = (function() { 
var G__34684__delegate = function (x,y,z,args){
var or__6153__auto__ = cljs$core$spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.some(((function (or__6153__auto__,ps__$1){
return (function (p1__34657_SHARP_){
return cljs.core.some(p1__34657_SHARP_,args);
});})(or__6153__auto__,ps__$1))
,ps__$1);
}
};
var G__34684 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__34685__i = 0, G__34685__a = new Array(arguments.length -  3);
while (G__34685__i < G__34685__a.length) {G__34685__a[G__34685__i] = arguments[G__34685__i + 3]; ++G__34685__i;}
  args = new cljs.core.IndexedSeq(G__34685__a,0);
} 
return G__34684__delegate.call(this,x,y,z,args);};
G__34684.cljs$lang$maxFixedArity = 3;
G__34684.cljs$lang$applyTo = (function (arglist__34686){
var x = cljs.core.first(arglist__34686);
arglist__34686 = cljs.core.next(arglist__34686);
var y = cljs.core.first(arglist__34686);
arglist__34686 = cljs.core.next(arglist__34686);
var z = cljs.core.first(arglist__34686);
var args = cljs.core.rest(arglist__34686);
return G__34684__delegate(x,y,z,args);
});
G__34684.cljs$core$IFn$_invoke$arity$variadic = G__34684__delegate;
return G__34684;
})()
;
cljs$core$spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$spn__0.call(this);
case 1:
return cljs$core$spn__1.call(this,x);
case 2:
return cljs$core$spn__2.call(this,x,y);
case 3:
return cljs$core$spn__3.call(this,x,y,z);
default:
var G__34687 = null;
if (arguments.length > 3) {
var G__34688__i = 0, G__34688__a = new Array(arguments.length -  3);
while (G__34688__i < G__34688__a.length) {G__34688__a[G__34688__i] = arguments[G__34688__i + 3]; ++G__34688__i;}
G__34687 = new cljs.core.IndexedSeq(G__34688__a,0);
}
return cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__34687);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$spn.cljs$lang$maxFixedArity = 3;
cljs$core$spn.cljs$lang$applyTo = cljs$core$spn__4.cljs$lang$applyTo;
cljs$core$spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$spn__0;
cljs$core$spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$spn__1;
cljs$core$spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$spn__2;
cljs$core$spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$spn__3;
cljs$core$spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$spn;
})()
;})(ps__$1))
});

cljs.core.some_fn.cljs$lang$applyTo = (function (seq34659){
var G__34660 = cljs.core.first(seq34659);
var seq34659__$1 = cljs.core.next(seq34659);
var G__34661 = cljs.core.first(seq34659__$1);
var seq34659__$2 = cljs.core.next(seq34659__$1);
var G__34662 = cljs.core.first(seq34659__$2);
var seq34659__$3 = cljs.core.next(seq34659__$2);
return cljs.core.some_fn.cljs$core$IFn$_invoke$arity$variadic(G__34660,G__34661,G__34662,seq34659__$3);
});

cljs.core.some_fn.cljs$lang$maxFixedArity = (3);
/**
 * Returns a lazy sequence consisting of the result of applying f to
 *   the set of first items of each coll, followed by applying f to the
 *   set of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments. Returns a transducer when
 *   no collection is provided.
 */
cljs.core.map = (function cljs$core$map(var_args){
var args34690 = [];
var len__7211__auto___34710 = arguments.length;
var i__7212__auto___34711 = (0);
while(true){
if((i__7212__auto___34711 < len__7211__auto___34710)){
args34690.push((arguments[i__7212__auto___34711]));

var G__34712 = (i__7212__auto___34711 + (1));
i__7212__auto___34711 = G__34712;
continue;
} else {
}
break;
}

var G__34697 = args34690.length;
switch (G__34697) {
case 1:
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.map.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34690.slice((4)),(0)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7230__auto__);

}
});

cljs.core.map.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
return (function() {
var G__34714 = null;
var G__34714__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34714__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34714__2 = (function (result,input){
var G__34698 = result;
var G__34699 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__34698,G__34699) : rf.call(null,G__34698,G__34699));
});
var G__34714__3 = (function() { 
var G__34715__delegate = function (result,input,inputs){
var G__34700 = result;
var G__34701 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__34700,G__34701) : rf.call(null,G__34700,G__34701));
};
var G__34715 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__34716__i = 0, G__34716__a = new Array(arguments.length -  2);
while (G__34716__i < G__34716__a.length) {G__34716__a[G__34716__i] = arguments[G__34716__i + 2]; ++G__34716__i;}
  inputs = new cljs.core.IndexedSeq(G__34716__a,0);
} 
return G__34715__delegate.call(this,result,input,inputs);};
G__34715.cljs$lang$maxFixedArity = 2;
G__34715.cljs$lang$applyTo = (function (arglist__34717){
var result = cljs.core.first(arglist__34717);
arglist__34717 = cljs.core.next(arglist__34717);
var input = cljs.core.first(arglist__34717);
var inputs = cljs.core.rest(arglist__34717);
return G__34715__delegate(result,input,inputs);
});
G__34715.cljs$core$IFn$_invoke$arity$variadic = G__34715__delegate;
return G__34715;
})()
;
G__34714 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__34714__0.call(this);
case 1:
return G__34714__1.call(this,result);
case 2:
return G__34714__2.call(this,result,input);
default:
var G__34718 = null;
if (arguments.length > 2) {
var G__34719__i = 0, G__34719__a = new Array(arguments.length -  2);
while (G__34719__i < G__34719__a.length) {G__34719__a[G__34719__i] = arguments[G__34719__i + 2]; ++G__34719__i;}
G__34718 = new cljs.core.IndexedSeq(G__34719__a,0);
}
return G__34714__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__34718);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34714.cljs$lang$maxFixedArity = 2;
G__34714.cljs$lang$applyTo = G__34714__3.cljs$lang$applyTo;
G__34714.cljs$core$IFn$_invoke$arity$0 = G__34714__0;
G__34714.cljs$core$IFn$_invoke$arity$1 = G__34714__1;
G__34714.cljs$core$IFn$_invoke$arity$2 = G__34714__2;
G__34714.cljs$core$IFn$_invoke$arity$variadic = G__34714__3.cljs$core$IFn$_invoke$arity$variadic;
return G__34714;
})()
});
});

cljs.core.map.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7056__auto___34720 = size;
var i_34721 = (0);
while(true){
if((i_34721 < n__7056__auto___34720)){
cljs.core.chunk_append(b,(function (){var G__34702 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_34721);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34702) : f.call(null,G__34702));
})());

var G__34722 = (i_34721 + (1));
i_34721 = G__34722;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__34703 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34703) : f.call(null,G__34703));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__34704 = cljs.core.first(s1);
var G__34705 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34704,G__34705) : f.call(null,G__34704,G__34705));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__34706 = cljs.core.first(s1);
var G__34707 = cljs.core.first(s2);
var G__34708 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34706,G__34707,G__34708) : f.call(null,G__34706,G__34707,G__34708));
})(),cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});

cljs.core.map.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
var step = (function cljs$core$step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$step(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__34689_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__34689_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
});

cljs.core.map.cljs$lang$applyTo = (function (seq34691){
var G__34692 = cljs.core.first(seq34691);
var seq34691__$1 = cljs.core.next(seq34691);
var G__34693 = cljs.core.first(seq34691__$1);
var seq34691__$2 = cljs.core.next(seq34691__$1);
var G__34694 = cljs.core.first(seq34691__$2);
var seq34691__$3 = cljs.core.next(seq34691__$2);
var G__34695 = cljs.core.first(seq34691__$3);
var seq34691__$4 = cljs.core.next(seq34691__$3);
return cljs.core.map.cljs$core$IFn$_invoke$arity$variadic(G__34692,G__34693,G__34694,G__34695,seq34691__$4);
});

cljs.core.map.cljs$lang$maxFixedArity = (4);
/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 *   there are fewer than n.  Returns a stateful transducer when
 *   no collection is provided.
 */
cljs.core.take = (function cljs$core$take(var_args){
var args34723 = [];
var len__7211__auto___34728 = arguments.length;
var i__7212__auto___34729 = (0);
while(true){
if((i__7212__auto___34729 < len__7211__auto___34728)){
args34723.push((arguments[i__7212__auto___34729]));

var G__34730 = (i__7212__auto___34729 + (1));
i__7212__auto___34729 = G__34730;
continue;
} else {
}
break;
}

var G__34725 = args34723.length;
switch (G__34725) {
case 1:
return cljs.core.take.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34723.length)].join('')));

}
});

cljs.core.take.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__34726 = cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n);
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__34726) : cljs.core.pr_str.call(null,G__34726));
})())].join('')));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__34732 = null;
var G__34732__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34732__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34732__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));
var result__$1 = (((n__$1 > (0)))?(rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input)):result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__34732 = function(result,input){
switch(arguments.length){
case 0:
return G__34732__0.call(this);
case 1:
return G__34732__1.call(this,result);
case 2:
return G__34732__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34732.cljs$core$IFn$_invoke$arity$0 = G__34732__0;
G__34732.cljs$core$IFn$_invoke$arity$1 = G__34732__1;
G__34732.cljs$core$IFn$_invoke$arity$2 = G__34732__2;
return G__34732;
})()
;})(na))
});
});

cljs.core.take.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__34727 = cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n);
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__34727) : cljs.core.pr_str.call(null,G__34727));
})())].join('')));
}

return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of all but the first n items in coll.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function cljs$core$drop(var_args){
var args34733 = [];
var len__7211__auto___34738 = arguments.length;
var i__7212__auto___34739 = (0);
while(true){
if((i__7212__auto___34739 < len__7211__auto___34738)){
args34733.push((arguments[i__7212__auto___34739]));

var G__34740 = (i__7212__auto___34739 + (1));
i__7212__auto___34739 = G__34740;
continue;
} else {
}
break;
}

var G__34735 = args34733.length;
switch (G__34735) {
case 1:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34733.length)].join('')));

}
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__34736 = cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n);
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__34736) : cljs.core.pr_str.call(null,G__34736));
})())].join('')));
}

return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__34742 = null;
var G__34742__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34742__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34742__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
cljs.core._vreset_BANG_(na,(cljs.core._deref(na) - (1)));

if((n__$1 > (0))){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__34742 = function(result,input){
switch(arguments.length){
case 0:
return G__34742__0.call(this);
case 1:
return G__34742__1.call(this,result);
case 2:
return G__34742__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34742.cljs$core$IFn$_invoke$arity$0 = G__34742__0;
G__34742.cljs$core$IFn$_invoke$arity$1 = G__34742__1;
G__34742.cljs$core$IFn$_invoke$arity$2 = G__34742__2;
return G__34742;
})()
;})(na))
});
});

cljs.core.drop.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__34737 = cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n);
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__34737) : cljs.core.pr_str.call(null,G__34737));
})())].join('')));
}

var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__34743 = (n__$1 - (1));
var G__34744 = cljs.core.rest(s);
n__$1 = G__34743;
coll__$1 = G__34744;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});

cljs.core.drop.cljs$lang$maxFixedArity = 2;
/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function cljs$core$drop_last(var_args){
var args34745 = [];
var len__7211__auto___34748 = arguments.length;
var i__7212__auto___34749 = (0);
while(true){
if((i__7212__auto___34749 < len__7211__auto___34748)){
args34745.push((arguments[i__7212__auto___34749]));

var G__34750 = (i__7212__auto___34749 + (1));
i__7212__auto___34749 = G__34750;
continue;
} else {
}
break;
}

var G__34747 = args34745.length;
switch (G__34747) {
case 1:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34745.length)].join('')));

}
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});

cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});

cljs.core.drop_last.cljs$lang$maxFixedArity = 2;
/**
 * Returns a seq of the last n items in coll.  Depending on the type
 *   of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__34752 = cljs.core.next(s);
var G__34753 = cljs.core.next(lead);
s = G__34752;
lead = G__34753;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 *   first item for which (pred item) returns logical false.  Returns a
 *   stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function cljs$core$drop_while(var_args){
var args34754 = [];
var len__7211__auto___34759 = arguments.length;
var i__7212__auto___34760 = (0);
while(true){
if((i__7212__auto___34760 < len__7211__auto___34759)){
args34754.push((arguments[i__7212__auto___34760]));

var G__34761 = (i__7212__auto___34760 + (1));
i__7212__auto___34760 = G__34761;
continue;
} else {
}
break;
}

var G__34756 = args34754.length;
switch (G__34756) {
case 1:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34754.length)].join('')));

}
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__34763 = null;
var G__34763__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34763__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34763__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__6141__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__6141__auto__)){
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input));
} else {
return and__6141__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__34763 = function(result,input){
switch(arguments.length){
case 0:
return G__34763__0.call(this);
case 1:
return G__34763__1.call(this,result);
case 2:
return G__34763__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34763.cljs$core$IFn$_invoke$arity$0 = G__34763__0;
G__34763.cljs$core$IFn$_invoke$arity$1 = G__34763__1;
G__34763.cljs$core$IFn$_invoke$arity$2 = G__34763__2;
return G__34763;
})()
;})(da))
});
});

cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__6141__auto__ = s;
if(and__6141__auto__){
var G__34758 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__34758) : pred__$1.call(null,G__34758));
} else {
return and__6141__auto__;
}
})())){
var G__34764 = pred__$1;
var G__34765 = cljs.core.rest(s);
pred__$1 = G__34764;
coll__$1 = G__34765;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});

cljs.core.drop_while.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs$core$cycle(s));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function cljs$core$repeat(var_args){
var args34766 = [];
var len__7211__auto___34769 = arguments.length;
var i__7212__auto___34770 = (0);
while(true){
if((i__7212__auto___34770 < len__7211__auto___34769)){
args34766.push((arguments[i__7212__auto___34770]));

var G__34771 = (i__7212__auto___34770 + (1));
i__7212__auto___34770 = G__34771;
continue;
} else {
}
break;
}

var G__34768 = args34766.length;
switch (G__34768) {
case 1:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34766.length)].join('')));

}
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});

cljs.core.repeat.cljs$core$IFn$_invoke$arity$2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});

cljs.core.repeat.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 *   returns an infinite (or length n if supplied) lazy sequence of calls
 *   to it
 */
cljs.core.repeatedly = (function cljs$core$repeatedly(var_args){
var args34773 = [];
var len__7211__auto___34776 = arguments.length;
var i__7212__auto___34777 = (0);
while(true){
if((i__7212__auto___34777 < len__7211__auto___34776)){
args34773.push((arguments[i__7212__auto___34777]));

var G__34778 = (i__7212__auto___34777 + (1));
i__7212__auto___34777 = G__34778;
continue;
} else {
}
break;
}

var G__34775 = args34773.length;
switch (G__34775) {
case 1:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34773.length)].join('')));

}
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});

cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});

cljs.core.repeatedly.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return cljs$core$iterate(f,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)));
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 */
cljs.core.interleave = (function cljs$core$interleave(var_args){
var args34782 = [];
var len__7211__auto___34788 = arguments.length;
var i__7212__auto___34789 = (0);
while(true){
if((i__7212__auto___34789 < len__7211__auto___34788)){
args34782.push((arguments[i__7212__auto___34789]));

var G__34790 = (i__7212__auto___34789 + (1));
i__7212__auto___34789 = G__34790;
continue;
} else {
}
break;
}

var G__34787 = args34782.length;
switch (G__34787) {
case 2:
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34782.slice((2)),(0)));
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7230__auto__);

}
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic = (function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});

cljs.core.interleave.cljs$lang$applyTo = (function (seq34783){
var G__34784 = cljs.core.first(seq34783);
var seq34783__$1 = cljs.core.next(seq34783);
var G__34785 = cljs.core.first(seq34783__$1);
var seq34783__$2 = cljs.core.next(seq34783__$1);
return cljs.core.interleave.cljs$core$IFn$_invoke$arity$variadic(G__34784,G__34785,seq34783__$2);
});

cljs.core.interleave.cljs$lang$maxFixedArity = (2);
/**
 * Returns a lazy seq of the elements of coll separated by sep.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.interpose = (function cljs$core$interpose(var_args){
var args34792 = [];
var len__7211__auto___34795 = arguments.length;
var i__7212__auto___34796 = (0);
while(true){
if((i__7212__auto___34796 < len__7211__auto___34795)){
args34792.push((arguments[i__7212__auto___34796]));

var G__34797 = (i__7212__auto___34796 + (1));
i__7212__auto___34796 = G__34797;
continue;
} else {
}
break;
}

var G__34794 = args34792.length;
switch (G__34794) {
case 1:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34792.length)].join('')));

}
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__34799 = null;
var G__34799__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34799__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34799__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,sep) : rf.call(null,result,sep));
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(sepr,input) : rf.call(null,sepr,input));
}
} else {
cljs.core.vreset_BANG_(started,true);

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__34799 = function(result,input){
switch(arguments.length){
case 0:
return G__34799__0.call(this);
case 1:
return G__34799__1.call(this,result);
case 2:
return G__34799__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34799.cljs$core$IFn$_invoke$arity$0 = G__34799__0;
G__34799.cljs$core$IFn$_invoke$arity$1 = G__34799__1;
G__34799.cljs$core$IFn$_invoke$arity$2 = G__34799__2;
return G__34799;
})()
;})(started))
});
});

cljs.core.interpose.cljs$core$IFn$_invoke$arity$2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});

cljs.core.interpose.cljs$lang$maxFixedArity = 2;
/**
 * Take a collection of collections, and return a lazy seq
 *   of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var coll__$1 = temp__4655__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 *   to f and colls.  Thus function f should return a collection. Returns
 *   a transducer when no collections are provided
 */
cljs.core.mapcat = (function cljs$core$mapcat(var_args){
var args34808 = [];
var len__7211__auto___34813 = arguments.length;
var i__7212__auto___34814 = (0);
while(true){
if((i__7212__auto___34814 < len__7211__auto___34813)){
args34808.push((arguments[i__7212__auto___34814]));

var G__34815 = (i__7212__auto___34814 + (1));
i__7212__auto___34814 = G__34815;
continue;
} else {
}
break;
}

var G__34812 = args34808.length;
switch (G__34812) {
case 1:
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34808.slice((1)),(0)));
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7230__auto__);

}
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});

cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic = (function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
});

cljs.core.mapcat.cljs$lang$applyTo = (function (seq34809){
var G__34810 = cljs.core.first(seq34809);
var seq34809__$1 = cljs.core.next(seq34809);
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(G__34810,seq34809__$1);
});

cljs.core.mapcat.cljs$lang$maxFixedArity = (1);
/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function cljs$core$filter(var_args){
var args34817 = [];
var len__7211__auto___34821 = arguments.length;
var i__7212__auto___34822 = (0);
while(true){
if((i__7212__auto___34822 < len__7211__auto___34821)){
args34817.push((arguments[i__7212__auto___34822]));

var G__34823 = (i__7212__auto___34822 + (1));
i__7212__auto___34822 = G__34823;
continue;
} else {
}
break;
}

var G__34819 = args34817.length;
switch (G__34819) {
case 1:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34817.length)].join('')));

}
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__34825 = null;
var G__34825__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__34825__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__34825__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__34825 = function(result,input){
switch(arguments.length){
case 0:
return G__34825__0.call(this);
case 1:
return G__34825__1.call(this,result);
case 2:
return G__34825__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34825.cljs$core$IFn$_invoke$arity$0 = G__34825__0;
G__34825.cljs$core$IFn$_invoke$arity$1 = G__34825__1;
G__34825.cljs$core$IFn$_invoke$arity$2 = G__34825__2;
return G__34825;
})()
});
});

cljs.core.filter.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__7056__auto___34826 = size;
var i_34827 = (0);
while(true){
if((i_34827 < n__7056__auto___34826)){
if(cljs.core.truth_((function (){var G__34820 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_34827);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__34820) : pred.call(null,G__34820));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_34827));
} else {
}

var G__34828 = (i_34827 + (1));
i_34827 = G__34828;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(f) : pred.call(null,f)))){
return cljs.core.cons(f,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});

cljs.core.filter.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the items in coll for which
 *   (pred item) returns false. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function cljs$core$remove(var_args){
var args34829 = [];
var len__7211__auto___34832 = arguments.length;
var i__7212__auto___34833 = (0);
while(true){
if((i__7212__auto___34833 < len__7211__auto___34832)){
args34829.push((arguments[i__7212__auto___34833]));

var G__34834 = (i__7212__auto___34833 + (1));
i__7212__auto___34833 = G__34834;
continue;
} else {
}
break;
}

var G__34831 = args34829.length;
switch (G__34831) {
case 1:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34829.length)].join('')));

}
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});

cljs.core.remove.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});

cljs.core.remove.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 * branch? must be a fn of one arg that returns true if passed a node
 * that can have children (but may not).  children must be a fn of one
 * arg that returns a sequence of the children. Will only be called on
 * nodes for which branch? returns true. Root is the root node of the
 *   tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(node) : branch_QMARK_.call(null,node)))?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(node) : children.call(null,node))], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 *   etc.) and returns their contents as a single, flat sequence.
 *   (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__34836_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__34836_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 *   from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function cljs$core$into(var_args){
var args34837 = [];
var len__7211__auto___34842 = arguments.length;
var i__7212__auto___34843 = (0);
while(true){
if((i__7212__auto___34843 < len__7211__auto___34842)){
args34837.push((arguments[i__7212__auto___34843]));

var G__34844 = (i__7212__auto___34843 + (1));
i__7212__auto___34843 = G__34844;
continue;
} else {
}
break;
}

var G__34839 = args34837.length;
switch (G__34839) {
case 2:
return cljs.core.into.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.into.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34837.length)].join('')));

}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$2 = (function (to,from){
if(!((to == null))){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || (to.cljs$core$IEditableCollection$))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});

cljs.core.into.cljs$core$IFn$_invoke$arity$3 = (function (to,xform,from){
if(((!((to == null)))?((((to.cljs$lang$protocol_mask$partition1$ & (4))) || (to.cljs$core$IEditableCollection$))?true:false):false)){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});

cljs.core.into.cljs$lang$maxFixedArity = 3;
/**
 * Returns a vector consisting of the result of applying f to the
 *   set of first items of each coll, followed by applying f to the set
 *   of second items in each coll, until any one of the colls is
 *   exhausted.  Any remaining items in other colls are ignored. Function
 *   f should accept number-of-colls arguments.
 */
cljs.core.mapv = (function cljs$core$mapv(var_args){
var args34846 = [];
var len__7211__auto___34854 = arguments.length;
var i__7212__auto___34855 = (0);
while(true){
if((i__7212__auto___34855 < len__7211__auto___34854)){
args34846.push((arguments[i__7212__auto___34855]));

var G__34856 = (i__7212__auto___34855 + (1));
i__7212__auto___34855 = G__34856;
continue;
} else {
}
break;
}

var G__34853 = args34846.length;
switch (G__34853) {
case 2:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34846.slice((4)),(0)));
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__7230__auto__);

}
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(o) : f.call(null,o)));
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});

cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic = (function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
});

cljs.core.mapv.cljs$lang$applyTo = (function (seq34847){
var G__34848 = cljs.core.first(seq34847);
var seq34847__$1 = cljs.core.next(seq34847);
var G__34849 = cljs.core.first(seq34847__$1);
var seq34847__$2 = cljs.core.next(seq34847__$1);
var G__34850 = cljs.core.first(seq34847__$2);
var seq34847__$3 = cljs.core.next(seq34847__$2);
var G__34851 = cljs.core.first(seq34847__$3);
var seq34847__$4 = cljs.core.next(seq34847__$3);
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$variadic(G__34848,G__34849,G__34850,G__34851,seq34847__$4);
});

cljs.core.mapv.cljs$lang$maxFixedArity = (4);
/**
 * Returns a vector of the items in coll for which
 *   (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(o) : pred.call(null,o)))){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 *   apart. If step is not supplied, defaults to n, i.e. the partitions
 *   do not overlap. If a pad collection is supplied, use its elements as
 *   necessary to complete last partition up to n items. In case there are
 *   not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function cljs$core$partition(var_args){
var args34858 = [];
var len__7211__auto___34861 = arguments.length;
var i__7212__auto___34862 = (0);
while(true){
if((i__7212__auto___34862 < len__7211__auto___34861)){
args34858.push((arguments[i__7212__auto___34862]));

var G__34863 = (i__7212__auto___34862 + (1));
i__7212__auto___34862 = G__34863;
continue;
} else {
}
break;
}

var G__34860 = args34858.length;
switch (G__34860) {
case 2:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.partition.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34858.length)].join('')));

}
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$core$IFn$_invoke$arity$4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs.core.partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});

cljs.core.partition.cljs$lang$maxFixedArity = 4;
/**
 * Returns the value in a nested associative structure,
 *   where ks is a sequence of keys. Returns nil if the key is not present,
 *   or the not-found value if supplied.
 */
cljs.core.get_in = (function cljs$core$get_in(var_args){
var args34865 = [];
var len__7211__auto___34869 = arguments.length;
var i__7212__auto___34870 = (0);
while(true){
if((i__7212__auto___34870 < len__7211__auto___34869)){
args34865.push((arguments[i__7212__auto___34870]));

var G__34871 = (i__7212__auto___34870 + (1));
i__7212__auto___34870 = G__34871;
continue;
} else {
}
break;
}

var G__34867 = args34865.length;
switch (G__34867) {
case 2:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args34865.length)].join('')));

}
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$2 = (function (m,ks){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});

cljs.core.get_in.cljs$core$IFn$_invoke$arity$3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!(((!((m__$1 == null)))?((((m__$1.cljs$lang$protocol_mask$partition0$ & (256))) || (m__$1.cljs$core$ILookup$))?true:(((!m__$1.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,m__$1):false)):cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,m__$1)))){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__34873 = sentinel;
var G__34874 = m__$2;
var G__34875 = cljs.core.next(ks__$1);
sentinel = G__34873;
m__$1 = G__34874;
ks__$1 = G__34875;
continue;
}
}
} else {
return m__$1;
}
break;
}
});

cljs.core.get_in.cljs$lang$maxFixedArity = 3;
/**
 * Associates a value in a nested associative structure, where ks is a
 *   sequence of keys and v is the new value and returns a new nested structure.
 *   If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__34876,v){
var vec__34881 = p__34876;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34881,(0),null);
var ks = cljs.core.nthnext(vec__34881,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 *   sequence of keys and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   nested structure.  If any levels do not exist, hash-maps will be
 *   created.
 */
cljs.core.update_in = (function cljs$core$update_in(var_args){
var args34882 = [];
var len__7211__auto___34912 = arguments.length;
var i__7212__auto___34913 = (0);
while(true){
if((i__7212__auto___34913 < len__7211__auto___34912)){
args34882.push((arguments[i__7212__auto___34913]));

var G__34914 = (i__7212__auto___34913 + (1));
i__7212__auto___34913 = G__34914;
continue;
} else {
}
break;
}

var G__34891 = args34882.length;
switch (G__34891) {
case 3:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34882.slice((6)),(0)));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7230__auto__);

}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$3 = (function (m,p__34892,f){
var vec__34893 = p__34892;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34893,(0),null);
var ks = cljs.core.nthnext(vec__34893,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34894 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34894) : f.call(null,G__34894));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$4 = (function (m,p__34895,f,a){
var vec__34896 = p__34895;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34896,(0),null);
var ks = cljs.core.nthnext(vec__34896,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34897 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__34898 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34897,G__34898) : f.call(null,G__34897,G__34898));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$5 = (function (m,p__34899,f,a,b){
var vec__34900 = p__34899;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34900,(0),null);
var ks = cljs.core.nthnext(vec__34900,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34901 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__34902 = a;
var G__34903 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34901,G__34902,G__34903) : f.call(null,G__34901,G__34902,G__34903));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$6 = (function (m,p__34904,f,a,b,c){
var vec__34905 = p__34904;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34905,(0),null);
var ks = cljs.core.nthnext(vec__34905,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34906 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__34907 = a;
var G__34908 = b;
var G__34909 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__34906,G__34907,G__34908,G__34909) : f.call(null,G__34906,G__34907,G__34908,G__34909));
})());
}
});

cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic = (function (m,p__34910,f,a,b,c,args){
var vec__34911 = p__34910;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34911,(0),null);
var ks = cljs.core.nthnext(vec__34911,(1));
if(cljs.core.truth_(ks)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
});

cljs.core.update_in.cljs$lang$applyTo = (function (seq34883){
var G__34884 = cljs.core.first(seq34883);
var seq34883__$1 = cljs.core.next(seq34883);
var G__34885 = cljs.core.first(seq34883__$1);
var seq34883__$2 = cljs.core.next(seq34883__$1);
var G__34886 = cljs.core.first(seq34883__$2);
var seq34883__$3 = cljs.core.next(seq34883__$2);
var G__34887 = cljs.core.first(seq34883__$3);
var seq34883__$4 = cljs.core.next(seq34883__$3);
var G__34888 = cljs.core.first(seq34883__$4);
var seq34883__$5 = cljs.core.next(seq34883__$4);
var G__34889 = cljs.core.first(seq34883__$5);
var seq34883__$6 = cljs.core.next(seq34883__$5);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(G__34884,G__34885,G__34886,G__34887,G__34888,G__34889,seq34883__$6);
});

cljs.core.update_in.cljs$lang$maxFixedArity = (6);
/**
 * 'Updates' a value in an associative structure, where k is a
 *   key and f is a function that will take the old value
 *   and any supplied args and return the new value, and returns a new
 *   structure.  If the key does not exist, nil is passed as the old value.
 */
cljs.core.update = (function cljs$core$update(var_args){
var args34916 = [];
var len__7211__auto___34936 = arguments.length;
var i__7212__auto___34937 = (0);
while(true){
if((i__7212__auto___34937 < len__7211__auto___34936)){
args34916.push((arguments[i__7212__auto___34937]));

var G__34938 = (i__7212__auto___34937 + (1));
i__7212__auto___34937 = G__34938;
continue;
} else {
}
break;
}

var G__34925 = args34916.length;
switch (G__34925) {
case 3:
return cljs.core.update.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.update.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.update.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.update.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args34916.slice((6)),(0)));
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),argseq__7230__auto__);

}
});

cljs.core.update.cljs$core$IFn$_invoke$arity$3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34926 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__34926) : f.call(null,G__34926));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34927 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__34928 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34927,G__34928) : f.call(null,G__34927,G__34928));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34929 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__34930 = x;
var G__34931 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34929,G__34930,G__34931) : f.call(null,G__34929,G__34930,G__34931));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__34932 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__34933 = x;
var G__34934 = y;
var G__34935 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__34932,G__34933,G__34934,G__34935) : f.call(null,G__34932,G__34933,G__34934,G__34935));
})());
});

cljs.core.update.cljs$core$IFn$_invoke$arity$variadic = (function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
});

cljs.core.update.cljs$lang$applyTo = (function (seq34917){
var G__34918 = cljs.core.first(seq34917);
var seq34917__$1 = cljs.core.next(seq34917);
var G__34919 = cljs.core.first(seq34917__$1);
var seq34917__$2 = cljs.core.next(seq34917__$1);
var G__34920 = cljs.core.first(seq34917__$2);
var seq34917__$3 = cljs.core.next(seq34917__$2);
var G__34921 = cljs.core.first(seq34917__$3);
var seq34917__$4 = cljs.core.next(seq34917__$3);
var G__34922 = cljs.core.first(seq34917__$4);
var seq34917__$5 = cljs.core.next(seq34917__$4);
var G__34923 = cljs.core.first(seq34917__$5);
var seq34917__$6 = cljs.core.next(seq34917__$5);
return cljs.core.update.cljs$core$IFn$_invoke$arity$variadic(G__34918,G__34919,G__34920,G__34921,G__34922,G__34923,seq34917__$6);
});

cljs.core.update.cljs$lang$maxFixedArity = (6);

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.cst$sym$arr], null);
});

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__34940 = (ll - (5));
var G__34941 = r;
ll = G__34940;
ret = G__34941;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = cljs$core$push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__34946 = cljs.core.pv_aget(node,(0));
var G__34947 = (level - (5));
node = G__34946;
level = G__34947;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__34948 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__34949 = (level - (5));
node = G__34948;
level = G__34949;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,cljs$core$do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$base,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end], null);
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__34959 = init__$2;
var G__34960 = (j + i);
var G__34961 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__34959,G__34960,G__34961) : f.call(null,G__34959,G__34960,G__34961));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__34968 = (j + (1));
var G__34969 = init__$3;
j = G__34968;
init__$2 = G__34969;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__34970 = (i + len);
var G__34971 = init__$2;
i = G__34970;
init__$1 = G__34971;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(self__.root) : cljs.core.tv_editable_root.call(null,self__.root)),(cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(self__.tail) : cljs.core.tv_editable_tail.call(null,self__.tail))));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__34962 = init__$2;
var G__34963 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__34962,G__34963) : f.call(null,G__34962,G__34963));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__34972 = (j + (1));
var G__34973 = init__$3;
j = G__34972;
init__$2 = G__34973;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__34974 = (i + len);
var G__34975 = init__$2;
i = G__34974;
init__$1 = G__34975;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__34964 = coll__$1;
var G__34965 = cljs.core.first_array_for_longvec(coll__$1);
var G__34966 = (0);
var G__34967 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__34964,G__34965,G__34966,G__34967) : cljs.core.chunked_seq.call(null,G__34964,G__34965,G__34966,G__34967));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__7056__auto___34976 = len;
var i_34977 = (0);
while(true){
if((i_34977 < n__7056__auto___34976)){
(new_tail[i_34977] = (self__.tail[i_34977]));

var G__34978 = (i_34977 + (1));
i_34977 = G__34978;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__34979 = null;
var G__34979__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__34979__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__34979 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__34979__2.call(this,self__,k);
case 3:
return G__34979__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__34979.cljs$core$IFn$_invoke$arity$2 = G__34979__2;
G__34979.cljs$core$IFn$_invoke$arity$3 = G__34979__3;
return G__34979;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args34958){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args34958)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$shift,cljs.core.cst$sym$root,cljs.core.cst$sym$tail,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__34980 = (i + (1));
var G__34981 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__34980;
out = G__34981;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 *   will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 */
cljs.core.vector = (function cljs$core$vector(var_args){
var args__7218__auto__ = [];
var len__7211__auto___34983 = arguments.length;
var i__7212__auto___34984 = (0);
while(true){
if((i__7212__auto___34984 < len__7211__auto___34983)){
args__7218__auto__.push((arguments[i__7212__auto___34984]));

var G__34985 = (i__7212__auto___34984 + (1));
i__7212__auto___34984 = G__34985;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic = (function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
});

cljs.core.vector.cljs$lang$maxFixedArity = (0);

cljs.core.vector.cljs$lang$applyTo = (function (seq34982){
return cljs.core.vector.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq34982));
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ASeq}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IChunkedNext}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IChunkedSeq}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__34986 = self__.vec;
var G__34987 = self__.node;
var G__34988 = self__.i;
var G__34989 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__34986,G__34987,G__34988,G__34989) : cljs.core.chunked_seq.call(null,G__34986,G__34987,G__34988,G__34989));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__34990 = self__.vec;
var G__34991 = (self__.i + self__.off);
var G__34992 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__34990,G__34991,G__34992) : cljs.core.subvec.call(null,G__34990,G__34991,G__34992));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__34993 = self__.vec;
var G__34994 = (self__.i + self__.off);
var G__34995 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__34993,G__34994,G__34995) : cljs.core.subvec.call(null,G__34993,G__34994,G__34995));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__34996 = self__.vec;
var G__34997 = self__.node;
var G__34998 = self__.i;
var G__34999 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__34996,G__34997,G__34998,G__34999) : cljs.core.chunked_seq.call(null,G__34996,G__34997,G__34998,G__34999));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__35000 = self__.vec;
var G__35001 = cljs.core.unchecked_array_for(self__.vec,end);
var G__35002 = end;
var G__35003 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__35000,G__35001,G__35002,G__35003) : cljs.core.chunked_seq.call(null,G__35000,G__35001,G__35002,G__35003));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(self__.vec,self__.node,self__.i,self__.off,m) : cljs.core.chunked_seq.call(null,self__.vec,self__.node,self__.i,self__.off,m));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__35004 = self__.vec;
var G__35005 = cljs.core.unchecked_array_for(self__.vec,end);
var G__35006 = end;
var G__35007 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__35004,G__35005,G__35006,G__35007) : cljs.core.chunked_seq.call(null,G__35004,G__35005,G__35006,G__35007));
} else {
return null;
}
});

cljs.core.ChunkedSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$vec,cljs.core.cst$sym$node,cljs.core.cst$sym$i,cljs.core.cst$sym$off,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.chunked_seq = (function cljs$core$chunked_seq(var_args){
var args35008 = [];
var len__7211__auto___35011 = arguments.length;
var i__7212__auto___35012 = (0);
while(true){
if((i__7212__auto___35012 < len__7211__auto___35011)){
args35008.push((arguments[i__7212__auto___35012]));

var G__35013 = (i__7212__auto___35012 + (1));
i__7212__auto___35012 = G__35013;
continue;
} else {
}
break;
}

var G__35010 = args35008.length;
switch (G__35010) {
case 3:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35008.length)].join('')));

}
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});

cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});

cljs.core.chunked_seq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__35016 = init__$1;
var G__35017 = j;
var G__35018 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__35016,G__35017,G__35018) : f.call(null,G__35016,G__35017,G__35018));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__35035 = (i + (1));
var G__35036 = (j + (1));
var G__35037 = init__$2;
i = G__35035;
j = G__35036;
init__$1 = G__35037;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__35019 = self__.meta;
var G__35020 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__35021 = self__.start;
var G__35022 = (function (){var x__6484__auto__ = self__.end;
var y__6485__auto__ = (v_pos + (1));
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})();
var G__35023 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__35019,G__35020,G__35021,G__35022,G__35023) : cljs.core.build_subvec.call(null,G__35019,G__35020,G__35021,G__35022,G__35023));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__35024 = self__.meta;
var G__35025 = self__.v;
var G__35026 = self__.start;
var G__35027 = (self__.end - (1));
var G__35028 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__35024,G__35025,G__35026,G__35027,G__35028) : cljs.core.build_subvec.call(null,G__35024,G__35025,G__35026,G__35027,G__35028));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(meta__$1,self__.v,self__.start,self__.end,self__.__hash) : cljs.core.build_subvec.call(null,meta__$1,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__35030 = self__.meta;
var G__35031 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__35032 = self__.start;
var G__35033 = (self__.end + (1));
var G__35034 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__35030,G__35031,G__35032,G__35033,G__35034) : cljs.core.build_subvec.call(null,G__35030,G__35031,G__35032,G__35033,G__35034));
});

cljs.core.Subvec.prototype.call = (function() {
var G__35038 = null;
var G__35038__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__35038__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__35038 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35038__2.call(this,self__,k);
case 3:
return G__35038__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35038.cljs$core$IFn$_invoke$arity$2 = G__35038__2;
G__35038.cljs$core$IFn$_invoke$arity$3 = G__35038__3;
return G__35038;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args35015){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35015)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$v,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__35039 = meta;
var G__35040 = v.v;
var G__35041 = (v.start + start);
var G__35042 = (v.start + end);
var G__35043 = __hash;
meta = G__35039;
v = G__35040;
start = G__35041;
end = G__35042;
__hash = G__35043;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 *   start (inclusive) to end (exclusive).  If end is not supplied,
 *   defaults to (count vector). This operation is O(1) and very fast, as
 *   the resulting vector shares structure with the original and no
 *   trimming is done.
 */
cljs.core.subvec = (function cljs$core$subvec(var_args){
var args35044 = [];
var len__7211__auto___35047 = arguments.length;
var i__7212__auto___35048 = (0);
while(true){
if((i__7212__auto___35048 < len__7211__auto___35047)){
args35044.push((arguments[i__7212__auto___35048]));

var G__35049 = (i__7212__auto___35048 + (1));
i__7212__auto___35048 = G__35049;
continue;
} else {
}
break;
}

var G__35046 = args35044.length;
switch (G__35046) {
case 2:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35044.length)].join('')));

}
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$2 = (function (v,start){
return cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});

cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});

cljs.core.subvec.cljs$lang$maxFixedArity = 3;
cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode({},cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return cljs$core$tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__35062 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__35063 = (level - (5));
node = G__35062;
level = G__35063;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientVector}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition1$ = 88;
this.cljs$lang$protocol_mask$partition0$ = 275;
})
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.call = (function() {
var G__35067 = null;
var G__35067__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35067__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35067 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35067__2.call(this,self__,k);
case 3:
return G__35067__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35067.cljs$core$IFn$_invoke$arity$2 = G__35067__2;
G__35067.cljs$core$IFn$_invoke$arity$3 = G__35067__3;
return G__35067;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args35064){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35064)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$shift,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$tail,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueIter = (function (fseq,riter){
this.fseq = fseq;
this.riter = riter;
})
cljs.core.PersistentQueueIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__6153__auto__ = (cljs.core.some_QMARK_(self__.fseq)) && (cljs.core.seq(self__.fseq));
if(or__6153__auto__){
return or__6153__auto__;
} else {
var and__6141__auto__ = cljs.core.some_QMARK_(self__.riter);
if(and__6141__auto__){
return self__.riter.hasNext();
} else {
return and__6141__auto__;
}
}
});

cljs.core.PersistentQueueIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(cljs.core.some_QMARK_(self__.fseq)){
var ret = cljs.core.first(self__.fseq);
self__.fseq = cljs.core.next(self__.fseq);

return ret;
} else {
if((cljs.core.some_QMARK_(self__.riter)) && (self__.riter.hasNext())){
return self__.riter.next();
} else {
throw (new Error("No such element"));

}
}
});

cljs.core.PersistentQueueIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.PersistentQueueIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$fseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$riter], null);
});

cljs.core.PersistentQueueIter.cljs$lang$type = true;

cljs.core.PersistentQueueIter.cljs$lang$ctorStr = "cljs.core/PersistentQueueIter";

cljs.core.PersistentQueueIter.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentQueueIter");
});

cljs.core.__GT_PersistentQueueIter = (function cljs$core$__GT_PersistentQueueIter(fseq,riter){
return (new cljs.core.PersistentQueueIter(fseq,riter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4655__auto__ = cljs.core.next(self__.front);
if(temp__4655__auto__){
var f1 = temp__4655__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueIter(self__.front,cljs.core._iterator(self__.rear)));
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4655__auto__ = cljs.core.next(self__.front);
if(temp__4655__auto__){
var f1 = temp__4655__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__6153__auto__ = self__.front;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6153__auto__ = self__.rear;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$count,cljs.core.cst$sym$front,cljs.core.cst$sym$rear,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IEquiv}
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition0$ = 2097152;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 *   false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__35068 = (i + incr);
i = G__35068;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__35069 = (i + (1));
var G__35070 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__35069;
out = G__35070;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = {};
var l = ks.length;
var i_35075 = (0);
while(true){
if((i_35075 < l)){
var k_35076 = (ks[i_35075]);
(new_obj[k_35076] = (obj[k_35076]));

var G__35077 = (i_35075 + (1));
i_35075 = G__35077;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__35080 = init__$1;
var G__35081 = k;
var G__35082 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__35080,G__35081,G__35082) : f.call(null,G__35080,G__35081,G__35082));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__35083 = cljs.core.rest(keys__$1);
var G__35084 = init__$2;
keys__$1 = G__35083;
init__$1 = G__35084;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(goog.isString(k)){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((goog.isString(k)) && (!((cljs.core.scan_array((1),k,self__.keys) == null)))){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__35078_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__35078_SHARP_,(self__.strobj[p1__35078_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__35085 = null;
var G__35085__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35085__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35085 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35085__2.call(this,self__,k);
case 3:
return G__35085__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35085.cljs$core$IFn$_invoke$arity$2 = G__35085__2;
G__35085.cljs$core$IFn$_invoke$arity$3 = G__35085__3;
return G__35085;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args35079){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35079)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$keys,cljs.core.cst$sym$strobj,cljs.core.cst$sym$update_DASH_count,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],{},(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.RecordIter = (function (i,record,base_count,fields,ext_map_iter){
this.i = i;
this.record = record;
this.base_count = base_count;
this.fields = fields;
this.ext_map_iter = ext_map_iter;
})
cljs.core.RecordIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var or__6153__auto__ = (self__.i < self__.base_count);
if(or__6153__auto__){
return or__6153__auto__;
} else {
return self__.ext_map_iter.hasNext();
}
});

cljs.core.RecordIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if((self__.i < self__.base_count)){
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(self__.fields,self__.i);
self__.i = (self__.i + (1));

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(self__.record,k)], null);
} else {
return self__.ext_map_iter.next();
}
});

cljs.core.RecordIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.RecordIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$record,cljs.core.cst$sym$base_DASH_count,cljs.core.cst$sym$fields,cljs.core.cst$sym$ext_DASH_map_DASH_iter], null);
});

cljs.core.RecordIter.cljs$lang$type = true;

cljs.core.RecordIter.cljs$lang$ctorStr = "cljs.core/RecordIter";

cljs.core.RecordIter.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/RecordIter");
});

cljs.core.__GT_RecordIter = (function cljs$core$__GT_RecordIter(i,record,base_count,fields,ext_map_iter){
return (new cljs.core.RecordIter(i,record,base_count,fields,ext_map_iter));
});


/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__35088 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35088,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35088,(1),null);
self__.s = cljs.core.next(self__.s);

return {"value": [k,v], "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6EntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"value": [x,x], "done": false};
} else {
return {"value": null, "done": true};
}
});

cljs.core.ES6SetEntriesIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_index_of_nil_QMARK_ = (function cljs$core$array_index_of_nil_QMARK_(arr){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__35089 = (i + (2));
i = G__35089;
continue;

}
}
break;
}
});
cljs.core.array_index_of_keyword_QMARK_ = (function cljs$core$array_index_of_keyword_QMARK_(arr,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Keyword)) && ((kstr === (arr[i]).fqn))){
return i;
} else {
var G__35090 = (i + (2));
i = G__35090;
continue;

}
}
break;
}
});
cljs.core.array_index_of_symbol_QMARK_ = (function cljs$core$array_index_of_symbol_QMARK_(arr,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((((arr[i]) instanceof cljs.core.Symbol)) && ((kstr === (arr[i]).str))){
return i;
} else {
var G__35091 = (i + (2));
i = G__35091;
continue;

}
}
break;
}
});
cljs.core.array_index_of_identical_QMARK_ = (function cljs$core$array_index_of_identical_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__35092 = (i + (2));
i = G__35092;
continue;

}
}
break;
}
});
cljs.core.array_index_of_equiv_QMARK_ = (function cljs$core$array_index_of_equiv_QMARK_(arr,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__35093 = (i + (2));
i = G__35093;
continue;

}
}
break;
}
});
cljs.core.array_index_of = (function cljs$core$array_index_of(arr,k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_index_of_keyword_QMARK_(arr,k);
} else {
if((goog.isString(k)) || (typeof k === 'number')){
return cljs.core.array_index_of_identical_QMARK_(arr,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_index_of_symbol_QMARK_(arr,k);
} else {
if((k == null)){
return cljs.core.array_index_of_nil_QMARK_(arr);
} else {
return cljs.core.array_index_of_equiv_QMARK_(arr,k);

}
}
}
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
return cljs.core.array_index_of(m.arr,k);
});
cljs.core.array_extend_kv = (function cljs$core$array_extend_kv(arr,k,v){
var l = arr.length;
var narr = (new Array((l + (2))));
var i_35094 = (0);
while(true){
if((i_35094 < l)){
(narr[i_35094] = (arr[i_35094]));

var G__35095 = (i_35094 + (1));
i_35094 = G__35095;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
return cljs.core.array_extend_kv(m.arr,k,v);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.cst$sym$i,cljs.core.cst$sym$_meta], null);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$cnt], null);
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__35097 = cljs.core.seq(coll);
var chunk__35098 = null;
var count__35099 = (0);
var i__35100 = (0);
while(true){
if((i__35100 < count__35099)){
var vec__35101 = chunk__35098.cljs$core$IIndexed$_nth$arity$2(null,i__35100);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35101,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35101,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35110 = seq__35097;
var G__35111 = chunk__35098;
var G__35112 = count__35099;
var G__35113 = (i__35100 + (1));
seq__35097 = G__35110;
chunk__35098 = G__35111;
count__35099 = G__35112;
i__35100 = G__35113;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35097);
if(temp__4657__auto__){
var seq__35097__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35097__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__35097__$1);
var G__35114 = cljs.core.chunk_rest(seq__35097__$1);
var G__35115 = c__6956__auto__;
var G__35116 = cljs.core.count(c__6956__auto__);
var G__35117 = (0);
seq__35097 = G__35114;
chunk__35098 = G__35115;
count__35099 = G__35116;
i__35100 = G__35117;
continue;
} else {
var vec__35102 = cljs.core.first(seq__35097__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35102,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35102,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35118 = cljs.core.next(seq__35097__$1);
var G__35119 = null;
var G__35120 = (0);
var G__35121 = (0);
seq__35097 = G__35118;
chunk__35098 = G__35119;
count__35099 = G__35120;
i__35100 = G__35121;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__35103 = init__$1;
var G__35104 = (self__.arr[i]);
var G__35105 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__35103,G__35104,G__35105) : f.call(null,G__35103,G__35104,G__35105));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__35122 = (i + (2));
var G__35123 = init__$2;
i = G__35122;
init__$1 = G__35123;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if(((!((other == null)))?((((other.cljs$lang$protocol_mask$partition0$ & (1024))) || (other.cljs$core$IMap$))?true:false):false)){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__35124 = (i + (2));
i = G__35124;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap({},self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__35125 = (s + (2));
var G__35126 = d;
s = G__35125;
d = G__35126;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__35127 = (s + (2));
var G__35128 = (d + (2));
s = G__35127;
d = G__35128;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__35109 = cljs.core.aclone(self__.arr);
(G__35109[(idx + (1))] = v);

return G__35109;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__35129 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__35130 = cljs.core.next(es);
ret = G__35129;
es = G__35130;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__35131 = null;
var G__35131__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35131__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35131 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35131__2.call(this,self__,k);
case 3:
return G__35131__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35131.cljs$core$IFn$_invoke$arity$2 = G__35131__2;
G__35131.cljs$core$IFn$_invoke$arity$3 = G__35131__3;
return G__35131;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args35096){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35096)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var arr__$2 = ((no_check)?arr__$1:(function (){var ret = [];
var i_35132 = (0);
while(true){
if((i_35132 < arr__$1.length)){
var k_35133 = (arr__$1[i_35132]);
var v_35134 = (arr__$1[(i_35132 + (1))]);
var idx_35135 = cljs.core.array_index_of(ret,k_35133);
if((idx_35135 === (-1))){
ret.push(k_35133);

ret.push(v_35134);
} else {
}

var G__35136 = (i_35132 + (2));
i_35132 = G__35136;
continue;
} else {
}
break;
}

return ret;
})());
var cnt = (arr__$2.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$2,null));
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || (o.cljs$core$IMapEntry$))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return cljs.core._assoc_BANG_(tcoll__$1,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4655__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
var G__35139 = cljs.core.next(es);
var G__35140 = cljs.core._assoc_BANG_(tcoll__$2,(cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__35139;
tcoll__$2 = G__35140;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(self__.len,self__.arr) : cljs.core.array__GT_transient_hash_map.call(null,self__.len,self__.arr)),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__35138_35141 = self__.arr;
G__35138_35141.pop();

G__35138_35141.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$editable_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$len,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$arr], null);
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__35142 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__35143 = (i + (2));
out = G__35142;
i = G__35143;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function cljs$core$clone_and_set(var_args){
var args35144 = [];
var len__7211__auto___35149 = arguments.length;
var i__7212__auto___35150 = (0);
while(true){
if((i__7212__auto___35150 < len__7211__auto___35149)){
args35144.push((arguments[i__7212__auto___35150]));

var G__35151 = (i__7212__auto___35150 + (1));
i__7212__auto___35150 = G__35151;
continue;
} else {
}
break;
}

var G__35146 = args35144.length;
switch (G__35146) {
case 3:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35144.length)].join('')));

}
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3 = (function (arr,i,a){
var G__35147 = cljs.core.aclone(arr);
(G__35147[i] = a);

return G__35147;
});

cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5 = (function (arr,i,a,j,b){
var G__35148 = cljs.core.aclone(arr);
(G__35148[i] = a);

(G__35148[j] = b);

return G__35148;
});

cljs.core.clone_and_set.cljs$lang$maxFixedArity = 5;
cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function cljs$core$edit_and_set(var_args){
var args35153 = [];
var len__7211__auto___35156 = arguments.length;
var i__7212__auto___35157 = (0);
while(true){
if((i__7212__auto___35157 < len__7211__auto___35156)){
args35153.push((arguments[i__7212__auto___35157]));

var G__35158 = (i__7212__auto___35157 + (1));
i__7212__auto___35157 = G__35158;
continue;
} else {
}
break;
}

var G__35155 = args35153.length;
switch (G__35155) {
case 4:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 6:
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35153.length)].join('')));

}
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});

cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});

cljs.core.edit_and_set.cljs$lang$maxFixedArity = 6;
cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__35163 = init__$1;
var G__35164 = k;
var G__35165 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__35163,G__35164,G__35165) : f.call(null,G__35163,G__35164,G__35165));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__35166 = (i + (2));
var G__35167 = init__$2;
i = G__35166;
init__$1 = G__35167;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.NodeIterator = (function (arr,i,next_entry,next_iter){
this.arr = arr;
this.i = i;
this.next_entry = next_entry;
this.next_iter = next_iter;
})
cljs.core.NodeIterator.prototype.advance = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if((self__.i < len)){
var key = (self__.arr[self__.i]);
var node_or_val = (self__.arr[(self__.i + (1))]);
var found = ((cljs.core.some_QMARK_(key))?self__.next_entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key,node_or_val], null):((cljs.core.some_QMARK_(node_or_val))?(function (){var new_iter = cljs.core._iterator(node_or_val);
if(new_iter.hasNext()){
return self__.next_iter = new_iter;
} else {
return false;
}
})():false
));
self__.i = (self__.i + (2));

if(found){
return true;
} else {
continue;
}
} else {
return false;
}
break;
}
});

cljs.core.NodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var or__6153__auto__ = cljs.core.some_QMARK_(self__.next_entry);
if(or__6153__auto__){
return or__6153__auto__;
} else {
var or__6153__auto____$1 = cljs.core.some_QMARK_(self__.next_iter);
if(or__6153__auto____$1){
return or__6153__auto____$1;
} else {
return this$.advance();
}
}
});

cljs.core.NodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.some_QMARK_(self__.next_entry)){
var ret = self__.next_entry;
self__.next_entry = null;

return ret;
} else {
if(cljs.core.some_QMARK_(self__.next_iter)){
var ret = self__.next_iter.next();
if(self__.next_iter.hasNext()){
} else {
self__.next_iter = null;
}

return ret;
} else {
if(this$.advance()){
return this$.next();
} else {
throw (new Error("No such element"));

}
}
}
});

cljs.core.NodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.NodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_entry,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeIterator.cljs$lang$type = true;

cljs.core.NodeIterator.cljs$lang$ctorStr = "cljs.core/NodeIterator";

cljs.core.NodeIterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/NodeIterator");
});

cljs.core.__GT_NodeIterator = (function cljs$core$__GT_NodeIterator(arr,i,next_entry,next_iter){
return (new cljs.core.NodeIterator(arr,i,next_entry,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_35181 = (0);
var j_35182 = (0);
while(true){
if((i_35181 < (32))){
if((((self__.bitmap >>> i_35181) & (1)) === (0))){
var G__35183 = (i_35181 + (1));
var G__35184 = j_35182;
i_35181 = G__35183;
j_35182 = G__35184;
continue;
} else {
(nodes[i_35181] = ((!(((self__.arr[j_35182]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_35182])),(self__.arr[j_35182]),(self__.arr[(j_35182 + (1))]),added_leaf_QMARK_):(self__.arr[(j_35182 + (1))])));

var G__35185 = (i_35181 + (1));
var G__35186 = (j_35182 + (2));
i_35181 = G__35185;
j_35182 = G__35186;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__35168 = edit__$1;
var G__35169 = (shift + (5));
var G__35170 = key_or_nil;
var G__35171 = val_or_node;
var G__35172 = hash;
var G__35173 = key;
var G__35174 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__35168,G__35169,G__35170,G__35171,G__35172,G__35173,G__35174) : cljs.core.create_node.call(null,G__35168,G__35169,G__35170,G__35171,G__35172,G__35173,G__35174));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_35187 = (0);
var j_35188 = (0);
while(true){
if((i_35187 < (32))){
if((((self__.bitmap >>> i_35187) & (1)) === (0))){
var G__35189 = (i_35187 + (1));
var G__35190 = j_35188;
i_35187 = G__35189;
j_35188 = G__35190;
continue;
} else {
(nodes[i_35187] = ((!(((self__.arr[j_35188]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_35188])),(self__.arr[j_35188]),(self__.arr[(j_35188 + (1))]),added_leaf_QMARK_):(self__.arr[(j_35188 + (1))])));

var G__35191 = (i_35187 + (1));
var G__35192 = (j_35188 + (2));
i_35187 = G__35191;
j_35188 = G__35192;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__35175 = (shift + (5));
var G__35176 = key_or_nil;
var G__35177 = val_or_node;
var G__35178 = hash;
var G__35179 = key;
var G__35180 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__35175,G__35176,G__35177,G__35178,G__35179,G__35180) : cljs.core.create_node.call(null,G__35175,G__35176,G__35177,G__35178,G__35179,G__35180));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$ = true;

cljs.core.BitmapIndexedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.BitmapIndexedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$bitmap,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__35193 = (i + (1));
var G__35194 = (j + (2));
var G__35195 = (bitmap | ((1) << i));
i = G__35193;
j = G__35194;
bitmap = G__35195;
continue;
} else {
var G__35196 = (i + (1));
var G__35197 = j;
var G__35198 = bitmap;
i = G__35196;
j = G__35197;
bitmap = G__35198;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNodeIterator = (function (arr,i,next_iter){
this.arr = arr;
this.i = i;
this.next_iter = next_iter;
})
cljs.core.ArrayNodeIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
var len = self__.arr.length;
while(true){
if(!((cljs.core.some_QMARK_(self__.next_iter)) && (self__.next_iter.hasNext()))){
if((self__.i < len)){
var node = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

if(cljs.core.some_QMARK_(node)){
self__.next_iter = cljs.core._iterator(node);
} else {
}

continue;
} else {
return false;
}
} else {
return true;
}
break;
}
});

cljs.core.ArrayNodeIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(this$.hasNext()){
return self__.next_iter.next();
} else {
throw (new Error("No such element"));
}
});

cljs.core.ArrayNodeIterator.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayNodeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$arr,cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$next_DASH_iter,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeIterator.cljs$lang$type = true;

cljs.core.ArrayNodeIterator.cljs$lang$ctorStr = "cljs.core/ArrayNodeIterator";

cljs.core.ArrayNodeIterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ArrayNodeIterator");
});

cljs.core.__GT_ArrayNodeIterator = (function cljs$core$__GT_ArrayNodeIterator(arr,i,next_iter){
return (new cljs.core.ArrayNodeIterator(arr,i,next_iter));
});


/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_array_node_seq.call(null,self__.arr));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var G__35199 = (i + (1));
var G__35200 = init__$2;
i = G__35199;
init__$1 = G__35200;
continue;
}
} else {
var G__35201 = (i + (1));
var G__35202 = init__$1;
i = G__35201;
init__$1 = G__35202;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.prototype.cljs$core$IIterable$ = true;

cljs.core.ArrayNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeIterator(self__.arr,(0),null));
});

cljs.core.ArrayNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__35203 = (i + (2));
i = G__35203;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IIterable}
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(self__.arr) : cljs.core.create_inode_seq.call(null,self__.arr));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$ = true;

cljs.core.HashCollisionNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeIterator(self__.arr,(0),null,null));
});

cljs.core.HashCollisionNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$edit,cljs.core.with_meta(cljs.core.cst$sym$collision_DASH_hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$cnt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function cljs$core$create_node(var_args){
var args35204 = [];
var len__7211__auto___35207 = arguments.length;
var i__7212__auto___35208 = (0);
while(true){
if((i__7212__auto___35208 < len__7211__auto___35207)){
args35204.push((arguments[i__7212__auto___35208]));

var G__35209 = (i__7212__auto___35208 + (1));
i__7212__auto___35208 = G__35209;
continue;
} else {
}
break;
}

var G__35206 = args35204.length;
switch (G__35206) {
case 6:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return cljs.core.create_node.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35204.length)].join('')));

}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});

cljs.core.create_node.cljs$lang$maxFixedArity = 7;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__35211 = self__.nodes;
var G__35212 = (self__.i + (2));
var G__35213 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__35211,G__35212,G__35213) : cljs.core.create_inode_seq.call(null,G__35211,G__35212,G__35213));
} else {
var G__35214 = self__.nodes;
var G__35215 = self__.i;
var G__35216 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__35214,G__35215,G__35216) : cljs.core.create_inode_seq.call(null,G__35214,G__35215,G__35216));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.create_inode_seq = (function cljs$core$create_inode_seq(var_args){
var args35217 = [];
var len__7211__auto___35220 = arguments.length;
var i__7212__auto___35221 = (0);
while(true){
if((i__7212__auto___35221 < len__7211__auto___35220)){
args35217.push((arguments[i__7212__auto___35221]));

var G__35222 = (i__7212__auto___35221 + (1));
i__7212__auto___35221 = G__35222;
continue;
} else {
}
break;
}

var G__35219 = args35217.length;
switch (G__35219) {
case 1:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 3:
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35217.length)].join('')));

}
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});

cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4655__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4655__auto__)){
var node = temp__4655__auto__;
var temp__4655__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4655__auto____$1)){
var node_seq = temp__4655__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__35224 = (j + (2));
j = G__35224;
continue;
}
} else {
var G__35225 = (j + (2));
j = G__35225;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});

cljs.core.create_inode_seq.cljs$lang$maxFixedArity = 3;

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__35226 = null;
var G__35227 = self__.nodes;
var G__35228 = self__.i;
var G__35229 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__35226,G__35227,G__35228,G__35229) : cljs.core.create_array_node_seq.call(null,G__35226,G__35227,G__35228,G__35229));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$nodes,cljs.core.cst$sym$i,cljs.core.cst$sym$s,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.create_array_node_seq = (function cljs$core$create_array_node_seq(var_args){
var args35230 = [];
var len__7211__auto___35233 = arguments.length;
var i__7212__auto___35234 = (0);
while(true){
if((i__7212__auto___35234 < len__7211__auto___35233)){
args35230.push((arguments[i__7212__auto___35234]));

var G__35235 = (i__7212__auto___35234 + (1));
i__7212__auto___35234 = G__35235;
continue;
} else {
}
break;
}

var G__35232 = args35230.length;
switch (G__35232) {
case 1:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35230.length)].join('')));

}
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = (function (nodes){
return cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});

cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4655__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4655__auto__)){
var nj = temp__4655__auto__;
var temp__4655__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4655__auto____$1)){
var ns = temp__4655__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__35237 = (j + (1));
j = G__35237;
continue;
}
} else {
var G__35238 = (j + (1));
j = G__35238;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});

cljs.core.create_array_node_seq.cljs$lang$maxFixedArity = 4;

/**
* @constructor
*/
cljs.core.HashMapIter = (function (nil_val,root_iter,seen){
this.nil_val = nil_val;
this.root_iter = root_iter;
this.seen = seen;
})
cljs.core.HashMapIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.seen) && (self__.root_iter.hasNext());
});

cljs.core.HashMapIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!(self__.seen)){
self__.seen = true;

return self__.nil_val;
} else {
return self__.root_iter.next();
}
});

cljs.core.HashMapIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashMapIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$nil_DASH_val,cljs.core.cst$sym$root_DASH_iter,cljs.core.with_meta(cljs.core.cst$sym$seen,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.HashMapIter.cljs$lang$type = true;

cljs.core.HashMapIter.cljs$lang$ctorStr = "cljs.core/HashMapIter";

cljs.core.HashMapIter.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/HashMapIter");
});

cljs.core.__GT_HashMapIter = (function cljs$core$__GT_HashMapIter(nil_val,root_iter,seen){
return (new cljs.core.HashMapIter(nil_val,root_iter,seen));
});


/**
* @constructor
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__35240 = cljs.core.seq(coll);
var chunk__35241 = null;
var count__35242 = (0);
var i__35243 = (0);
while(true){
if((i__35243 < count__35242)){
var vec__35244 = chunk__35241.cljs$core$IIndexed$_nth$arity$2(null,i__35243);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35244,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35244,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35248 = seq__35240;
var G__35249 = chunk__35241;
var G__35250 = count__35242;
var G__35251 = (i__35243 + (1));
seq__35240 = G__35248;
chunk__35241 = G__35249;
count__35242 = G__35250;
i__35243 = G__35251;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35240);
if(temp__4657__auto__){
var seq__35240__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35240__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__35240__$1);
var G__35252 = cljs.core.chunk_rest(seq__35240__$1);
var G__35253 = c__6956__auto__;
var G__35254 = cljs.core.count(c__6956__auto__);
var G__35255 = (0);
seq__35240 = G__35252;
chunk__35241 = G__35253;
count__35242 = G__35254;
i__35243 = G__35255;
continue;
} else {
var vec__35245 = cljs.core.first(seq__35240__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35245,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35245,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35256 = cljs.core.next(seq__35240__$1);
var G__35257 = null;
var G__35258 = (0);
var G__35259 = (0);
seq__35240 = G__35256;
chunk__35241 = G__35257;
count__35242 = G__35258;
i__35243 = G__35259;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(init,null,self__.nil_val) : f.call(null,init,null,self__.nil_val)):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var root_iter = ((self__.root)?cljs.core._iterator(self__.root):cljs.core.nil_iter);
if(self__.has_nil_QMARK_){
return (new cljs.core.HashMapIter(self__.nil_val,root_iter,false));
} else {
return root_iter;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap({},self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__35260 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__35261 = cljs.core.next(es);
ret = G__35260;
es = G__35261;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__35262 = null;
var G__35262__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35262__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35262 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35262__2.call(this,self__,k);
case 3:
return G__35262__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35262.cljs$core$IFn$_invoke$arity$2 = G__35262__2;
G__35262.cljs$core$IFn$_invoke$arity$3 = G__35262__3;
return G__35262;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args35239){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35239)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$cnt,cljs.core.cst$sym$root,cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$nil_DASH_val,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__35263 = (i + (2));
var G__35264 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__35263;
ret = G__35264;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__35265 = (i + (1));
var G__35266 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__35265;
out = G__35266;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientMap}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ITransientAssociative}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition0$ = 258;
this.cljs$lang$protocol_mask$partition1$ = 56;
})
cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if(((!((o == null)))?((((o.cljs$lang$protocol_mask$partition0$ & (2048))) || (o.cljs$core$IMapEntry$))?true:(((!o.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,o))){
return tcoll.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.key.call(null,o)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(o) : cljs.core.val.call(null,o)));
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4655__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
var G__35268 = cljs.core.next(es);
var G__35269 = tcoll__$1.assoc_BANG_((cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.key.call(null,e)),(cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(e) : cljs.core.val.call(null,e)));
es = G__35268;
tcoll__$1 = G__35269;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$edit,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$root,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$has_DASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean,cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$nil_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__35270 = ((ascending_QMARK_)?t.left:t.right);
var G__35271 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__35270;
stack__$1 = G__35271;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$stack,cljs.core.with_meta(cljs.core.cst$sym$ascending_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$boolean], null)),cljs.core.cst$sym$cnt,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?cljs$core$tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$1) : cljs.core.deref.call(null,init__$1));
} else {
var init__$2 = (function (){var G__35281 = init__$1;
var G__35282 = node.key;
var G__35283 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__35281,G__35282,G__35283) : f.call(null,G__35281,G__35282,G__35283));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$2) : cljs.core.deref.call(null,init__$2));
} else {
var init__$3 = ((!((node.right == null)))?cljs$core$tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(init__$3) : cljs.core.deref.call(null,init__$3));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__35285 = null;
var G__35285__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35285__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35285 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35285__2.call(this,self__,k);
case 3:
return G__35285__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35285.cljs$core$IFn$_invoke$arity$2 = G__35285__2;
G__35285.cljs$core$IFn$_invoke$arity$3 = G__35285__3;
return G__35285;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args35284){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35284)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IVector}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IMapEntry}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
 * @implements {cljs.core.IReduce}
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__35287 = null;
var G__35287__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35287__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35287 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35287__2.call(this,self__,k);
case 3:
return G__35287__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35287.cljs$core$IFn$_invoke$arity$2 = G__35287__2;
G__35287.cljs$core$IFn$_invoke$arity$3 = G__35287__3;
return G__35287;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args35286){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35286)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$val,cljs.core.cst$sym$left,cljs.core.cst$sym$right,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__35300 = k;
var G__35301 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__35300,G__35301) : comp.call(null,G__35300,G__35301));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs$core$tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs$core$tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs$core$tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs$core$tree_map_append(left,right.left),right.right,null));
} else {
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__35320 = k;
var G__35321 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__35320,G__35321) : comp.call(null,G__35320,G__35321));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs$core$tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs$core$tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(k,tk) : comp.call(null,k,tk));
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs$core$tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs$core$tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__35331 = cljs.core.seq(coll);
var chunk__35332 = null;
var count__35333 = (0);
var i__35334 = (0);
while(true){
if((i__35334 < count__35333)){
var vec__35335 = chunk__35332.cljs$core$IIndexed$_nth$arity$2(null,i__35334);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35335,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35335,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35341 = seq__35331;
var G__35342 = chunk__35332;
var G__35343 = count__35333;
var G__35344 = (i__35334 + (1));
seq__35331 = G__35341;
chunk__35332 = G__35342;
count__35333 = G__35343;
i__35334 = G__35344;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35331);
if(temp__4657__auto__){
var seq__35331__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35331__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__35331__$1);
var G__35345 = cljs.core.chunk_rest(seq__35331__$1);
var G__35346 = c__6956__auto__;
var G__35347 = cljs.core.count(c__6956__auto__);
var G__35348 = (0);
seq__35331 = G__35345;
chunk__35332 = G__35346;
count__35333 = G__35347;
i__35334 = G__35348;
continue;
} else {
var vec__35336 = cljs.core.first(seq__35331__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35336,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35336,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35349 = cljs.core.next(seq__35331__$1);
var G__35350 = null;
var G__35351 = (0);
var G__35352 = (0);
seq__35331 = G__35349;
chunk__35332 = G__35350;
count__35333 = G__35351;
i__35334 = G__35352;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.keys.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(coll) : cljs.core.vals.call(null,coll)));
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__35337 = k;
var G__35338 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__35337,G__35338) : self__.comp.call(null,G__35337,G__35338));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__35353 = t.left;
t = G__35353;
continue;
} else {
var G__35354 = t.right;
t = G__35354;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__35355 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__35356 = cljs.core.next(es);
ret = G__35355;
es = G__35356;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__35357 = null;
var G__35357__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35357__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35357 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35357__2.call(this,self__,k);
case 3:
return G__35357__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35357.cljs$core$IFn$_invoke$arity$2 = G__35357__2;
G__35357.cljs$core$IFn$_invoke$arity$3 = G__35357__3;
return G__35357;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args35330){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35330)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__35339 = k;
var G__35340 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__35339,G__35340) : self__.comp.call(null,G__35339,G__35340));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__35358 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__35359 = t.left;
stack = G__35358;
t = G__35359;
continue;
} else {
var G__35360 = stack;
var G__35361 = t.right;
stack = G__35360;
t = G__35361;
continue;
}
} else {
if((c > (0))){
var G__35362 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__35363 = t.right;
stack = G__35362;
t = G__35363;
continue;
} else {
var G__35364 = stack;
var G__35365 = t.left;
stack = G__35364;
t = G__35365;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(entry) : cljs.core.key.call(null,entry));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$comp,cljs.core.cst$sym$tree,cljs.core.cst$sym$cnt,cljs.core.cst$sym$meta,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * keyval => key val
 *   Returns a new hash map with supplied mappings.
 */
cljs.core.hash_map = (function cljs$core$hash_map(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35367 = arguments.length;
var i__7212__auto___35368 = (0);
while(true){
if((i__7212__auto___35368 < len__7211__auto___35367)){
args__7218__auto__.push((arguments[i__7212__auto___35368]));

var G__35369 = (i__7212__auto___35368 + (1));
i__7212__auto___35368 = G__35369;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__35370 = cljs.core.nnext(in$);
var G__35371 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__35370;
out = G__35371;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});

cljs.core.hash_map.cljs$lang$maxFixedArity = (0);

cljs.core.hash_map.cljs$lang$applyTo = (function (seq35366){
return cljs.core.hash_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35366));
});
/**
 * keyval => key val
 *   Returns a new array map with supplied mappings.
 */
cljs.core.array_map = (function cljs$core$array_map(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35373 = arguments.length;
var i__7212__auto___35374 = (0);
while(true){
if((i__7212__auto___35374 < len__7211__auto___35373)){
args__7218__auto__.push((arguments[i__7212__auto___35374]));

var G__35375 = (i__7212__auto___35374 + (1));
i__7212__auto___35374 = G__35375;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var arr = ((((keyvals instanceof cljs.core.IndexedSeq)) && ((keyvals.i === (0))))?keyvals.arr:cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(keyvals));
return cljs.core.PersistentArrayMap.fromArray(arr,true,false);
});

cljs.core.array_map.cljs$lang$maxFixedArity = (0);

cljs.core.array_map.cljs$lang$applyTo = (function (seq35372){
return cljs.core.array_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35372));
});
/**
 * keyval => key val
 *   Returns a new object map with supplied mappings.
 */
cljs.core.obj_map = (function cljs$core$obj_map(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35379 = arguments.length;
var i__7212__auto___35380 = (0);
while(true){
if((i__7212__auto___35380 < len__7211__auto___35379)){
args__7218__auto__.push((arguments[i__7212__auto___35380]));

var G__35381 = (i__7212__auto___35380 + (1));
i__7212__auto___35380 = G__35381;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var ks = [];
var obj = {};
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__35382 = cljs.core.nnext(kvs);
kvs = G__35382;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
});

cljs.core.obj_map.cljs$lang$maxFixedArity = (0);

cljs.core.obj_map.cljs$lang$applyTo = (function (seq35376){
return cljs.core.obj_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35376));
});
/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings.
 */
cljs.core.sorted_map = (function cljs$core$sorted_map(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35384 = arguments.length;
var i__7212__auto___35385 = (0);
while(true){
if((i__7212__auto___35385 < len__7211__auto___35384)){
args__7218__auto__.push((arguments[i__7212__auto___35385]));

var G__35386 = (i__7212__auto___35385 + (1));
i__7212__auto___35385 = G__35386;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__35387 = cljs.core.nnext(in$);
var G__35388 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__35387;
out = G__35388;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_map.cljs$lang$applyTo = (function (seq35383){
return cljs.core.sorted_map.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35383));
});
/**
 * keyval => key val
 *   Returns a new sorted map with supplied mappings, using the supplied comparator.
 */
cljs.core.sorted_map_by = (function cljs$core$sorted_map_by(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35391 = arguments.length;
var i__7212__auto___35392 = (0);
while(true){
if((i__7212__auto___35392 < len__7211__auto___35391)){
args__7218__auto__.push((arguments[i__7212__auto___35392]));

var G__35393 = (i__7212__auto___35392 + (1));
i__7212__auto___35392 = G__35393;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((1) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((1)),(0))):null);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7219__auto__);
});

cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__35394 = cljs.core.nnext(in$);
var G__35395 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__35394;
out = G__35395;
continue;
} else {
return out;
}
break;
}
});

cljs.core.sorted_map_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_map_by.cljs$lang$applyTo = (function (seq35389){
var G__35390 = cljs.core.first(seq35389);
var seq35389__$1 = cljs.core.next(seq35389);
return cljs.core.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(G__35390,seq35389__$1);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || (self__.mseq.cljs$core$INext$))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || (self__.mseq.cljs$core$INext$))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4657__auto__ = cljs.core.seq(hash_map);
if(temp__4657__auto__){
var mseq = temp__4657__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || (self__.mseq.cljs$core$INext$))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = ((((!((self__.mseq == null)))?((((self__.mseq.cljs$lang$protocol_mask$partition0$ & (128))) || (self__.mseq.cljs$core$INext$))?true:(((!self__.mseq.cljs$lang$protocol_mask$partition0$))?cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq):false)):cljs.core.native_satisfies_QMARK_(cljs.core.INext,self__.mseq)))?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mseq,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$not_DASH_native], null)),cljs.core.cst$sym$_meta], null);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4657__auto__ = cljs.core.seq(hash_map);
if(temp__4657__auto__){
var mseq = temp__4657__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping from
 *   the latter (left-to-right) will be the mapping in the result.
 */
cljs.core.merge = (function cljs$core$merge(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35403 = arguments.length;
var i__7212__auto___35404 = (0);
while(true){
if((i__7212__auto___35404 < len__7211__auto___35403)){
args__7218__auto__.push((arguments[i__7212__auto___35404]));

var G__35405 = (i__7212__auto___35404 + (1));
i__7212__auto___35404 = G__35405;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__35400_SHARP_,p2__35401_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6153__auto__ = p1__35400_SHARP_;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__35401_SHARP_);
}),maps);
} else {
return null;
}
});

cljs.core.merge.cljs$lang$maxFixedArity = (0);

cljs.core.merge.cljs$lang$applyTo = (function (seq35402){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35402));
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 *   the first.  If a key occurs in more than one map, the mapping(s)
 *   from the latter (left-to-right) will be combined with the mapping in
 *   the result by calling (f val-in-result val-in-latter).
 */
cljs.core.merge_with = (function cljs$core$merge_with(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35410 = arguments.length;
var i__7212__auto___35411 = (0);
while(true){
if((i__7212__auto___35411 < len__7211__auto___35410)){
args__7218__auto__.push((arguments[i__7212__auto___35411]));

var G__35412 = (i__7212__auto___35411 + (1));
i__7212__auto___35411 = G__35412;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((1) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((1)),(0))):null);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7219__auto__);
});

cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__35408 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__35409 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__35408,G__35409) : f.call(null,G__35408,G__35409));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__6153__auto__ = m1;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
});

cljs.core.merge_with.cljs$lang$maxFixedArity = (1);

cljs.core.merge_with.cljs$lang$applyTo = (function (seq35406){
var G__35407 = cljs.core.first(seq35406);
var seq35406__$1 = cljs.core.next(seq35406);
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(G__35407,seq35406__$1);
});
/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found);
var G__35413 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,cljs.core.cst$kw$cljs$core_SLASH_not_DASH_found))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__35414 = cljs.core.next(keys);
ret = G__35413;
keys = G__35414;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashSetIter = (function (iter){
this.iter = iter;
})
cljs.core.HashSetIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return self__.iter.hasNext();
});

cljs.core.HashSetIter.prototype.next = (function (){
var self__ = this;
var _ = this;
if(self__.iter.hasNext()){
return (self__.iter.next().tail[(0)]);
} else {
throw (new Error("No such element"));
}
});

cljs.core.HashSetIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.HashSetIter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$iter], null);
});

cljs.core.HashSetIter.cljs$lang$type = true;

cljs.core.HashSetIter.cljs$lang$ctorStr = "cljs.core/HashSetIter";

cljs.core.HashSetIter.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/HashSetIter");
});

cljs.core.__GT_HashSetIter = (function cljs$core$__GT_HashSetIter(iter){
return (new cljs.core.HashSetIter(iter));
});


/**
* @constructor
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEditableCollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__35417 = cljs.core.seq(coll);
var chunk__35418 = null;
var count__35419 = (0);
var i__35420 = (0);
while(true){
if((i__35420 < count__35419)){
var vec__35421 = chunk__35418.cljs$core$IIndexed$_nth$arity$2(null,i__35420);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35421,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35421,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35423 = seq__35417;
var G__35424 = chunk__35418;
var G__35425 = count__35419;
var G__35426 = (i__35420 + (1));
seq__35417 = G__35423;
chunk__35418 = G__35424;
count__35419 = G__35425;
i__35420 = G__35426;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35417);
if(temp__4657__auto__){
var seq__35417__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35417__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__35417__$1);
var G__35427 = cljs.core.chunk_rest(seq__35417__$1);
var G__35428 = c__6956__auto__;
var G__35429 = cljs.core.count(c__6956__auto__);
var G__35430 = (0);
seq__35417 = G__35427;
chunk__35418 = G__35428;
count__35419 = G__35429;
i__35420 = G__35430;
continue;
} else {
var vec__35422 = cljs.core.first(seq__35417__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35422,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35422,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35431 = cljs.core.next(seq__35417__$1);
var G__35432 = null;
var G__35433 = (0);
var G__35434 = (0);
seq__35417 = G__35431;
chunk__35418 = G__35432;
count__35419 = G__35433;
i__35420 = G__35434;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.HashSetIter(cljs.core._iterator(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__35415_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__35415_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__35435 = null;
var G__35435__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35435__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35435 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35435__2.call(this,self__,k);
case 3:
return G__35435__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35435.cljs$core$IFn$_invoke$arity$2 = G__35435__2;
G__35435.cljs$core$IFn$_invoke$arity$3 = G__35435__3;
return G__35435;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args35416){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35416)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$hash_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__35436 = (i + (1));
var G__35437 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__35436;
out = G__35437;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__35438 = (i + (1));
var G__35439 = cljs.core._conj_BANG_(out,(items[i]));
i = G__35438;
out = G__35439;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));

/**
* @constructor
 * @implements {cljs.core.ITransientSet}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ITransientCollection}
 * @implements {cljs.core.ILookup}
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition1$ = 136;
this.cljs$lang$protocol_mask$partition0$ = 259;
})
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.call = (function() {
var G__35441 = null;
var G__35441__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__35441__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__35441 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35441__2.call(this,self__,k);
case 3:
return G__35441__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35441.cljs$core$IFn$_invoke$arity$2 = G__35441__2;
G__35441.cljs$core$IFn$_invoke$arity$3 = G__35441__3;
return G__35441;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args35440){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35440)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$transient_DASH_map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ISet}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.ILookup}
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__35444 = cljs.core.seq(coll);
var chunk__35445 = null;
var count__35446 = (0);
var i__35447 = (0);
while(true){
if((i__35447 < count__35446)){
var vec__35448 = chunk__35445.cljs$core$IIndexed$_nth$arity$2(null,i__35447);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35448,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35448,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35450 = seq__35444;
var G__35451 = chunk__35445;
var G__35452 = count__35446;
var G__35453 = (i__35447 + (1));
seq__35444 = G__35450;
chunk__35445 = G__35451;
count__35446 = G__35452;
i__35447 = G__35453;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35444);
if(temp__4657__auto__){
var seq__35444__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35444__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__35444__$1);
var G__35454 = cljs.core.chunk_rest(seq__35444__$1);
var G__35455 = c__6956__auto__;
var G__35456 = cljs.core.count(c__6956__auto__);
var G__35457 = (0);
seq__35444 = G__35454;
chunk__35445 = G__35455;
count__35446 = G__35456;
i__35447 = G__35457;
continue;
} else {
var vec__35449 = cljs.core.first(seq__35444__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35449,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35449,(1),null);
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(v,k) : f.call(null,v,k));

var G__35458 = cljs.core.next(seq__35444__$1);
var G__35459 = null;
var G__35460 = (0);
var G__35461 = (0);
seq__35444 = G__35458;
chunk__35445 = G__35459;
count__35446 = G__35460;
i__35447 = G__35461;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__35442_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__35442_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__35462 = null;
var G__35462__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__35462__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__35462 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__35462__2.call(this,self__,k);
case 3:
return G__35462__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35462.cljs$core$IFn$_invoke$arity$2 = G__35462__2;
G__35462.cljs$core$IFn$_invoke$arity$3 = G__35462__3;
return G__35462;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args35443){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args35443)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$tree_DASH_map,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__7050__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__7050__auto__.length)){
var G__35463 = (i + (1));
var G__35464 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__35463;
res = G__35464;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__35465 = cljs.core.next(in$__$1);
var G__35466 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__35465;
out = G__35466;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 *   handled as if by repeated uses of conj.
 */
cljs.core.hash_set = (function cljs$core$hash_set(var_args){
var args35467 = [];
var len__7211__auto___35471 = arguments.length;
var i__7212__auto___35472 = (0);
while(true){
if((i__7212__auto___35472 < len__7211__auto___35471)){
args35467.push((arguments[i__7212__auto___35472]));

var G__35473 = (i__7212__auto___35472 + (1));
i__7212__auto___35472 = G__35473;
continue;
} else {
}
break;
}

var G__35470 = args35467.length;
switch (G__35470) {
case 0:
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0();

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args35467.slice((0)),(0)));
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__7230__auto__);

}
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});

cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.set(keys);
});

cljs.core.hash_set.cljs$lang$applyTo = (function (seq35468){
return cljs.core.hash_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35468));
});

cljs.core.hash_set.cljs$lang$maxFixedArity = (0);
/**
 * Returns a new sorted set with supplied keys.
 */
cljs.core.sorted_set = (function cljs$core$sorted_set(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35476 = arguments.length;
var i__7212__auto___35477 = (0);
while(true){
if((i__7212__auto___35477 < len__7211__auto___35476)){
args__7218__auto__.push((arguments[i__7212__auto___35477]));

var G__35478 = (i__7212__auto___35477 + (1));
i__7212__auto___35477 = G__35478;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic = (function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
});

cljs.core.sorted_set.cljs$lang$maxFixedArity = (0);

cljs.core.sorted_set.cljs$lang$applyTo = (function (seq35475){
return cljs.core.sorted_set.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35475));
});
/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 */
cljs.core.sorted_set_by = (function cljs$core$sorted_set_by(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35481 = arguments.length;
var i__7212__auto___35482 = (0);
while(true){
if((i__7212__auto___35482 < len__7211__auto___35481)){
args__7218__auto__.push((arguments[i__7212__auto___35482]));

var G__35483 = (i__7212__auto___35482 + (1));
i__7212__auto___35482 = G__35483;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((1) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((1)),(0))):null);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7219__auto__);
});

cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
});

cljs.core.sorted_set_by.cljs$lang$maxFixedArity = (1);

cljs.core.sorted_set_by.cljs$lang$applyTo = (function (seq35479){
var G__35480 = cljs.core.first(seq35479);
var seq35479__$1 = cljs.core.next(seq35479);
return cljs.core.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic(G__35480,seq35479__$1);
});
/**
 * Given a map of replacement pairs and a vector/collection, returns a
 *   vector/seq with any elements = a key in smap replaced with the
 *   corresponding val in smap.  Returns a transducer when no collection
 *   is provided.
 */
cljs.core.replace = (function cljs$core$replace(var_args){
var args35486 = [];
var len__7211__auto___35489 = arguments.length;
var i__7212__auto___35490 = (0);
while(true){
if((i__7212__auto___35490 < len__7211__auto___35489)){
args35486.push((arguments[i__7212__auto___35490]));

var G__35491 = (i__7212__auto___35490 + (1));
i__7212__auto___35490 = G__35491;
continue;
} else {
}
break;
}

var G__35488 = args35486.length;
switch (G__35488) {
case 1:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.replace.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35486.length)].join('')));

}
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__35484_SHARP_){
var temp__4655__auto__ = cljs.core.find(smap,p1__35484_SHARP_);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.val(e);
} else {
return p1__35484_SHARP_;
}
}));
});

cljs.core.replace.cljs$core$IFn$_invoke$arity$2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4655__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35485_SHARP_){
var temp__4655__auto__ = cljs.core.find(smap,p1__35485_SHARP_);
if(cljs.core.truth_(temp__4655__auto__)){
var e = temp__4655__auto__;
return cljs.core.second(e);
} else {
return p1__35485_SHARP_;
}
}),coll);
}
});

cljs.core.replace.cljs$lang$maxFixedArity = 2;
/**
 * Returns a lazy sequence of the elements of coll with duplicates removed.
 *   Returns a stateful transducer when no collection is provided.
 */
cljs.core.distinct = (function cljs$core$distinct(var_args){
var args35493 = [];
var len__7211__auto___35502 = arguments.length;
var i__7212__auto___35503 = (0);
while(true){
if((i__7212__auto___35503 < len__7211__auto___35502)){
args35493.push((arguments[i__7212__auto___35503]));

var G__35504 = (i__7212__auto___35503 + (1));
i__7212__auto___35503 = G__35504;
continue;
} else {
}
break;
}

var G__35495 = args35493.length;
switch (G__35495) {
case 0:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35493.length)].join('')));

}
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__35506 = null;
var G__35506__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__35506__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__35506__2 = (function (result,input){
if(cljs.core.contains_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(seen) : cljs.core.deref.call(null,seen)),input)){
return result;
} else {
cljs.core._vreset_BANG_(seen,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core._deref(seen),input));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__35506 = function(result,input){
switch(arguments.length){
case 0:
return G__35506__0.call(this);
case 1:
return G__35506__1.call(this,result);
case 2:
return G__35506__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35506.cljs$core$IFn$_invoke$arity$0 = G__35506__0;
G__35506.cljs$core$IFn$_invoke$arity$1 = G__35506__1;
G__35506.cljs$core$IFn$_invoke$arity$2 = G__35506__2;
return G__35506;
})()
;})(seen))
});
});

cljs.core.distinct.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var step = (function cljs$core$step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__35500,seen__$1){
while(true){
var vec__35501 = p__35500;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35501,(0),null);
var xs__$1 = vec__35501;
var temp__4657__auto__ = cljs.core.seq(xs__$1);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__35507 = cljs.core.rest(s);
var G__35508 = seen__$1;
p__35500 = G__35507;
seen__$1 = G__35508;
continue;
} else {
return cljs.core.cons(f,cljs$core$step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});

cljs.core.distinct.cljs$lang$maxFixedArity = 1;
/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__35509 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__35510 = cljs.core.next(s__$1);
ret = G__35509;
s__$1 = G__35510;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if(((!((x == null)))?((((x.cljs$lang$protocol_mask$partition1$ & (4096))) || (x.cljs$core$INamed$))?true:false):false)){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__35513 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__35514 = cljs.core.next(ks);
var G__35515 = cljs.core.next(vs);
map = G__35513;
ks = G__35514;
vs = G__35515;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 */
cljs.core.max_key = (function cljs$core$max_key(var_args){
var args35518 = [];
var len__7211__auto___35525 = arguments.length;
var i__7212__auto___35526 = (0);
while(true){
if((i__7212__auto___35526 < len__7211__auto___35525)){
args35518.push((arguments[i__7212__auto___35526]));

var G__35527 = (i__7212__auto___35526 + (1));
i__7212__auto___35526 = G__35527;
continue;
} else {
}
break;
}

var G__35524 = args35518.length;
switch (G__35524) {
case 2:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args35518.slice((3)),(0)));
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) > (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__35516_SHARP_,p2__35517_SHARP_){
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,p1__35516_SHARP_,p2__35517_SHARP_);
}),cljs.core.max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.max_key.cljs$lang$applyTo = (function (seq35519){
var G__35520 = cljs.core.first(seq35519);
var seq35519__$1 = cljs.core.next(seq35519);
var G__35521 = cljs.core.first(seq35519__$1);
var seq35519__$2 = cljs.core.next(seq35519__$1);
var G__35522 = cljs.core.first(seq35519__$2);
var seq35519__$3 = cljs.core.next(seq35519__$2);
return cljs.core.max_key.cljs$core$IFn$_invoke$arity$variadic(G__35520,G__35521,G__35522,seq35519__$3);
});

cljs.core.max_key.cljs$lang$maxFixedArity = (3);
/**
 * Returns the x for which (k x), a number, is least.
 */
cljs.core.min_key = (function cljs$core$min_key(var_args){
var args35531 = [];
var len__7211__auto___35538 = arguments.length;
var i__7212__auto___35539 = (0);
while(true){
if((i__7212__auto___35539 < len__7211__auto___35538)){
args35531.push((arguments[i__7212__auto___35539]));

var G__35540 = (i__7212__auto___35539 + (1));
i__7212__auto___35539 = G__35540;
continue;
} else {
}
break;
}

var G__35537 = args35531.length;
switch (G__35537) {
case 2:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args35531.slice((3)),(0)));
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$2 = (function (k,x){
return x;
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$3 = (function (k,x,y){
if(((k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(x) : k.call(null,x)) < (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(y) : k.call(null,y)))){
return x;
} else {
return y;
}
});

cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic = (function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__35529_SHARP_,p2__35530_SHARP_){
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,p1__35529_SHARP_,p2__35530_SHARP_);
}),cljs.core.min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
});

cljs.core.min_key.cljs$lang$applyTo = (function (seq35532){
var G__35533 = cljs.core.first(seq35532);
var seq35532__$1 = cljs.core.next(seq35532);
var G__35534 = cljs.core.first(seq35532__$1);
var seq35532__$2 = cljs.core.next(seq35532__$1);
var G__35535 = cljs.core.first(seq35532__$2);
var seq35532__$3 = cljs.core.next(seq35532__$2);
return cljs.core.min_key.cljs$core$IFn$_invoke$arity$variadic(G__35533,G__35534,G__35535,seq35532__$3);
});

cljs.core.min_key.cljs$lang$maxFixedArity = (3);

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$arr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 *   partitions with fewer than n items at the end.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.partition_all = (function cljs$core$partition_all(var_args){
var args35542 = [];
var len__7211__auto___35545 = arguments.length;
var i__7212__auto___35546 = (0);
while(true){
if((i__7212__auto___35546 < len__7211__auto___35545)){
args35542.push((arguments[i__7212__auto___35546]));

var G__35547 = (i__7212__auto___35546 + (1));
i__7212__auto___35546 = G__35547;
continue;
} else {
}
break;
}

var G__35544 = args35542.length;
switch (G__35544) {
case 1:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35542.length)].join('')));

}
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__35549 = null;
var G__35549__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__35549__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__35549__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
} else {
return result;
}
});
G__35549 = function(result,input){
switch(arguments.length){
case 0:
return G__35549__0.call(this);
case 1:
return G__35549__1.call(this,result);
case 2:
return G__35549__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35549.cljs$core$IFn$_invoke$arity$0 = G__35549__0;
G__35549.cljs$core$IFn$_invoke$arity$1 = G__35549__1;
G__35549.cljs$core$IFn$_invoke$arity$2 = G__35549__2;
return G__35549;
})()
;})(a))
});
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
return cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});

cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs.core.partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_all.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy sequence of successive items from coll while
 *   (pred item) returns true. pred must be free of side-effects.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function cljs$core$take_while(var_args){
var args35550 = [];
var len__7211__auto___35554 = arguments.length;
var i__7212__auto___35555 = (0);
while(true){
if((i__7212__auto___35555 < len__7211__auto___35554)){
args35550.push((arguments[i__7212__auto___35555]));

var G__35556 = (i__7212__auto___35555 + (1));
i__7212__auto___35555 = G__35556;
continue;
} else {
}
break;
}

var G__35552 = args35550.length;
switch (G__35552) {
case 1:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35550.length)].join('')));

}
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$1 = (function (pred){
return (function (rf){
return (function() {
var G__35558 = null;
var G__35558__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__35558__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__35558__2 = (function (result,input){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(input) : pred.call(null,input)))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return cljs.core.reduced(result);
}
});
G__35558 = function(result,input){
switch(arguments.length){
case 0:
return G__35558__0.call(this);
case 1:
return G__35558__1.call(this,result);
case 2:
return G__35558__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35558.cljs$core$IFn$_invoke$arity$0 = G__35558__0;
G__35558.cljs$core$IFn$_invoke$arity$1 = G__35558__1;
G__35558.cljs$core$IFn$_invoke$arity$2 = G__35558__2;
return G__35558;
})()
});
});

cljs.core.take_while.cljs$core$IFn$_invoke$arity$2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
if(cljs.core.truth_((function (){var G__35553 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__35553) : pred.call(null,G__35553));
})())){
return cljs.core.cons(cljs.core.first(s),cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});

cljs.core.take_while.cljs$lang$maxFixedArity = 2;
cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__35567 = (function (){var G__35569 = cljs.core._entry_key(sc,e);
var G__35570 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__35569,G__35570) : comp.call(null,G__35569,G__35570));
})();
var G__35568 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__35567,G__35568) : test.call(null,G__35567,G__35568));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function cljs$core$subseq(var_args){
var args35571 = [];
var len__7211__auto___35576 = arguments.length;
var i__7212__auto___35577 = (0);
while(true){
if((i__7212__auto___35577 < len__7211__auto___35576)){
args35571.push((arguments[i__7212__auto___35577]));

var G__35578 = (i__7212__auto___35577 + (1));
i__7212__auto___35577 = G__35578;
continue;
} else {
}
break;
}

var G__35573 = args35571.length;
switch (G__35573) {
case 3:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.subseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35571.length)].join('')));

}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__35574 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35574,(0),null);
var s = vec__35574;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});

cljs.core.subseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__35575 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35575,(0),null);
var s = vec__35575;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.subseq.cljs$lang$maxFixedArity = 5;
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 *   >=. Returns a reverse seq of those entries with keys ek for
 *   which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function cljs$core$rsubseq(var_args){
var args35580 = [];
var len__7211__auto___35585 = arguments.length;
var i__7212__auto___35586 = (0);
while(true){
if((i__7212__auto___35586 < len__7211__auto___35585)){
args35580.push((arguments[i__7212__auto___35586]));

var G__35587 = (i__7212__auto___35586 + (1));
i__7212__auto___35586 = G__35587;
continue;
} else {
}
break;
}

var G__35582 = args35580.length;
switch (G__35582) {
case 3:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 5:
return cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35580.length)].join('')));

}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__35583 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35583,(0),null);
var s = vec__35583;
if(cljs.core.truth_((include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(e) : include.call(null,e)))){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});

cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4657__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__35584 = temp__4657__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35584,(0),null);
var s = vec__35584;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});

cljs.core.rsubseq.cljs$lang$maxFixedArity = 5;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$i,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.cst$sym$end,cljs.core.cst$sym$step], null);
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeq}
 * @implements {cljs.core.INext}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__35589 = ((self__.end - self__.start) / self__.step);
return Math.ceil(G__35589);
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(ret,i) : f.call(null,ret,i));
if(cljs.core.reduced_QMARK_(ret__$1)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret__$1) : cljs.core.deref.call(null,ret__$1));
} else {
var G__35590 = (i + self__.step);
var G__35591 = ret__$1;
i = G__35590;
ret = G__35591;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.step < (0))){
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start === self__.end)){
return null;
} else {
return rng__$1;
}

}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta,cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$step,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function cljs$core$range(var_args){
var args35592 = [];
var len__7211__auto___35595 = arguments.length;
var i__7212__auto___35596 = (0);
while(true){
if((i__7212__auto___35596 < len__7211__auto___35595)){
args35592.push((arguments[i__7212__auto___35596]));

var G__35597 = (i__7212__auto___35596 + (1));
i__7212__auto___35596 = G__35597;
continue;
} else {
}
break;
}

var G__35594 = args35592.length;
switch (G__35594) {
case 0:
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35592.length)].join('')));

}
});

cljs.core.range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});

cljs.core.range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});

cljs.core.range.cljs$lang$maxFixedArity = 3;
/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 *   transducer when no collection is provided.
 */
cljs.core.take_nth = (function cljs$core$take_nth(var_args){
var args35599 = [];
var len__7211__auto___35604 = arguments.length;
var i__7212__auto___35605 = (0);
while(true){
if((i__7212__auto___35605 < len__7211__auto___35604)){
args35599.push((arguments[i__7212__auto___35605]));

var G__35606 = (i__7212__auto___35605 + (1));
i__7212__auto___35605 = G__35606;
continue;
} else {
}
break;
}

var G__35601 = args35599.length;
switch (G__35601) {
case 1:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35599.length)].join('')));

}
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$1 = (function (n){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__35602 = cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n);
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__35602) : cljs.core.pr_str.call(null,G__35602));
})())].join('')));
}

return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__35608 = null;
var G__35608__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__35608__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__35608__2 = (function (result,input){
var i = cljs.core._vreset_BANG_(ia,(cljs.core._deref(ia) + (1)));
if((cljs.core.rem(i,n) === (0))){
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
} else {
return result;
}
});
G__35608 = function(result,input){
switch(arguments.length){
case 0:
return G__35608__0.call(this);
case 1:
return G__35608__1.call(this,result);
case 2:
return G__35608__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35608.cljs$core$IFn$_invoke$arity$0 = G__35608__0;
G__35608.cljs$core$IFn$_invoke$arity$1 = G__35608__1;
G__35608.cljs$core$IFn$_invoke$arity$2 = G__35608__2;
return G__35608;
})()
;})(ia))
});
});

cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
if(typeof n === 'number'){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str((function (){var G__35603 = cljs.core.list(cljs.core.cst$sym$number_QMARK_,cljs.core.cst$sym$n);
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__35603) : cljs.core.pr_str.call(null,G__35603));
})())].join('')));
}

return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.cons(cljs.core.first(s),cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});

cljs.core.take_nth.cljs$lang$maxFixedArity = 2;
/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function cljs$core$partition_by(var_args){
var args35610 = [];
var len__7211__auto___35613 = arguments.length;
var i__7212__auto___35614 = (0);
while(true){
if((i__7212__auto___35614 < len__7211__auto___35613)){
args35610.push((arguments[i__7212__auto___35614]));

var G__35615 = (i__7212__auto___35614 + (1));
i__7212__auto___35614 = G__35615;
continue;
} else {
}
break;
}

var G__35612 = args35610.length;
switch (G__35612) {
case 1:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35610.length)].join('')));

}
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(cljs.core.cst$kw$cljs$core_SLASH_none);
return ((function (a,pa){
return (function() {
var G__35617 = null;
var G__35617__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__35617__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v)));
})());
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result__$1) : rf.call(null,result__$1));
});
var G__35617__2 = (function (result,input){
var pval = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pa) : cljs.core.deref.call(null,pa));
var val = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(input) : f.call(null,input));
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,cljs.core.cst$kw$cljs$core_SLASH_none)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,v) : rf.call(null,result,v));
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__35617 = function(result,input){
switch(arguments.length){
case 0:
return G__35617__0.call(this);
case 1:
return G__35617__1.call(this,result);
case 2:
return G__35617__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35617.cljs$core$IFn$_invoke$arity$0 = G__35617__0;
G__35617.cljs$core$IFn$_invoke$arity$1 = G__35617__1;
G__35617.cljs$core$IFn$_invoke$arity$2 = G__35617__2;
return G__35617;
})()
;})(a,pa))
});
});

cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
var fst = cljs.core.first(s);
var fv = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(fst) : f.call(null,fst));
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4657__auto__){
return (function (p1__35609_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(p1__35609_SHARP_) : f.call(null,p1__35609_SHARP_)));
});})(fst,fv,s,temp__4657__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});

cljs.core.partition_by.cljs$lang$maxFixedArity = 2;
/**
 * Returns a map from distinct items in coll to the number of times
 *   they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 *   per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function cljs$core$reductions(var_args){
var args35618 = [];
var len__7211__auto___35623 = arguments.length;
var i__7212__auto___35624 = (0);
while(true){
if((i__7212__auto___35624 < len__7211__auto___35623)){
args35618.push((arguments[i__7212__auto___35624]));

var G__35625 = (i__7212__auto___35624 + (1));
i__7212__auto___35624 = G__35625;
continue;
} else {
}
break;
}

var G__35620 = args35618.length;
switch (G__35620) {
case 2:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35618.length)].join('')));

}
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4655__auto__ = cljs.core.seq(coll);
if(temp__4655__auto__){
var s = temp__4655__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)));
}
}),null,null));
});

cljs.core.reductions.cljs$core$IFn$_invoke$arity$3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4657__auto__ = cljs.core.seq(coll);
if(temp__4657__auto__){
var s = temp__4657__auto__;
return cljs.core.reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__35621 = init;
var G__35622 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__35621,G__35622) : f.call(null,G__35621,G__35622));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});

cljs.core.reductions.cljs$lang$maxFixedArity = 3;
/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 *   of those fns.  The returned fn takes a variable number of args, and
 *   returns a vector containing the result of applying each fn to the
 *   args (left-to-right).
 *   ((juxt a b c) x) => [(a x) (b x) (c x)]
 */
cljs.core.juxt = (function cljs$core$juxt(var_args){
var args35637 = [];
var len__7211__auto___35644 = arguments.length;
var i__7212__auto___35645 = (0);
while(true){
if((i__7212__auto___35645 < len__7211__auto___35644)){
args35637.push((arguments[i__7212__auto___35645]));

var G__35646 = (i__7212__auto___35645 + (1));
i__7212__auto___35645 = G__35646;
continue;
} else {
}
break;
}

var G__35643 = args35637.length;
switch (G__35643) {
case 1:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var argseq__7230__auto__ = (new cljs.core.IndexedSeq(args35637.slice((3)),(0)));
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7230__auto__);

}
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$1 = (function (f){
return (function() {
var G__35648 = null;
var G__35648__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null))],null));
});
var G__35648__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x))],null));
});
var G__35648__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y))],null));
});
var G__35648__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z))],null));
});
var G__35648__4 = (function() { 
var G__35649__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__35649 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__35650__i = 0, G__35650__a = new Array(arguments.length -  3);
while (G__35650__i < G__35650__a.length) {G__35650__a[G__35650__i] = arguments[G__35650__i + 3]; ++G__35650__i;}
  args = new cljs.core.IndexedSeq(G__35650__a,0);
} 
return G__35649__delegate.call(this,x,y,z,args);};
G__35649.cljs$lang$maxFixedArity = 3;
G__35649.cljs$lang$applyTo = (function (arglist__35651){
var x = cljs.core.first(arglist__35651);
arglist__35651 = cljs.core.next(arglist__35651);
var y = cljs.core.first(arglist__35651);
arglist__35651 = cljs.core.next(arglist__35651);
var z = cljs.core.first(arglist__35651);
var args = cljs.core.rest(arglist__35651);
return G__35649__delegate(x,y,z,args);
});
G__35649.cljs$core$IFn$_invoke$arity$variadic = G__35649__delegate;
return G__35649;
})()
;
G__35648 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__35648__0.call(this);
case 1:
return G__35648__1.call(this,x);
case 2:
return G__35648__2.call(this,x,y);
case 3:
return G__35648__3.call(this,x,y,z);
default:
var G__35652 = null;
if (arguments.length > 3) {
var G__35653__i = 0, G__35653__a = new Array(arguments.length -  3);
while (G__35653__i < G__35653__a.length) {G__35653__a[G__35653__i] = arguments[G__35653__i + 3]; ++G__35653__i;}
G__35652 = new cljs.core.IndexedSeq(G__35653__a,0);
}
return G__35648__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__35652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35648.cljs$lang$maxFixedArity = 3;
G__35648.cljs$lang$applyTo = G__35648__4.cljs$lang$applyTo;
G__35648.cljs$core$IFn$_invoke$arity$0 = G__35648__0;
G__35648.cljs$core$IFn$_invoke$arity$1 = G__35648__1;
G__35648.cljs$core$IFn$_invoke$arity$2 = G__35648__2;
G__35648.cljs$core$IFn$_invoke$arity$3 = G__35648__3;
G__35648.cljs$core$IFn$_invoke$arity$variadic = G__35648__4.cljs$core$IFn$_invoke$arity$variadic;
return G__35648;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$2 = (function (f,g){
return (function() {
var G__35654 = null;
var G__35654__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null))],null));
});
var G__35654__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x))],null));
});
var G__35654__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y))],null));
});
var G__35654__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z))],null));
});
var G__35654__4 = (function() { 
var G__35655__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__35655 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__35656__i = 0, G__35656__a = new Array(arguments.length -  3);
while (G__35656__i < G__35656__a.length) {G__35656__a[G__35656__i] = arguments[G__35656__i + 3]; ++G__35656__i;}
  args = new cljs.core.IndexedSeq(G__35656__a,0);
} 
return G__35655__delegate.call(this,x,y,z,args);};
G__35655.cljs$lang$maxFixedArity = 3;
G__35655.cljs$lang$applyTo = (function (arglist__35657){
var x = cljs.core.first(arglist__35657);
arglist__35657 = cljs.core.next(arglist__35657);
var y = cljs.core.first(arglist__35657);
arglist__35657 = cljs.core.next(arglist__35657);
var z = cljs.core.first(arglist__35657);
var args = cljs.core.rest(arglist__35657);
return G__35655__delegate(x,y,z,args);
});
G__35655.cljs$core$IFn$_invoke$arity$variadic = G__35655__delegate;
return G__35655;
})()
;
G__35654 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__35654__0.call(this);
case 1:
return G__35654__1.call(this,x);
case 2:
return G__35654__2.call(this,x,y);
case 3:
return G__35654__3.call(this,x,y,z);
default:
var G__35658 = null;
if (arguments.length > 3) {
var G__35659__i = 0, G__35659__a = new Array(arguments.length -  3);
while (G__35659__i < G__35659__a.length) {G__35659__a[G__35659__i] = arguments[G__35659__i + 3]; ++G__35659__i;}
G__35658 = new cljs.core.IndexedSeq(G__35659__a,0);
}
return G__35654__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__35658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35654.cljs$lang$maxFixedArity = 3;
G__35654.cljs$lang$applyTo = G__35654__4.cljs$lang$applyTo;
G__35654.cljs$core$IFn$_invoke$arity$0 = G__35654__0;
G__35654.cljs$core$IFn$_invoke$arity$1 = G__35654__1;
G__35654.cljs$core$IFn$_invoke$arity$2 = G__35654__2;
G__35654.cljs$core$IFn$_invoke$arity$3 = G__35654__3;
G__35654.cljs$core$IFn$_invoke$arity$variadic = G__35654__4.cljs$core$IFn$_invoke$arity$variadic;
return G__35654;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$3 = (function (f,g,h){
return (function() {
var G__35660 = null;
var G__35660__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null)),(g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null)),(h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null))],null));
});
var G__35660__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(x) : f.call(null,x)),(g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(x) : g.call(null,x)),(h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(x) : h.call(null,x))],null));
});
var G__35660__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(x,y) : f.call(null,x,y)),(g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(x,y) : g.call(null,x,y)),(h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(x,y) : h.call(null,x,y))],null));
});
var G__35660__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(x,y,z) : f.call(null,x,y,z)),(g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(x,y,z) : g.call(null,x,y,z)),(h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(x,y,z) : h.call(null,x,y,z))],null));
});
var G__35660__4 = (function() { 
var G__35661__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__35661 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__35662__i = 0, G__35662__a = new Array(arguments.length -  3);
while (G__35662__i < G__35662__a.length) {G__35662__a[G__35662__i] = arguments[G__35662__i + 3]; ++G__35662__i;}
  args = new cljs.core.IndexedSeq(G__35662__a,0);
} 
return G__35661__delegate.call(this,x,y,z,args);};
G__35661.cljs$lang$maxFixedArity = 3;
G__35661.cljs$lang$applyTo = (function (arglist__35663){
var x = cljs.core.first(arglist__35663);
arglist__35663 = cljs.core.next(arglist__35663);
var y = cljs.core.first(arglist__35663);
arglist__35663 = cljs.core.next(arglist__35663);
var z = cljs.core.first(arglist__35663);
var args = cljs.core.rest(arglist__35663);
return G__35661__delegate(x,y,z,args);
});
G__35661.cljs$core$IFn$_invoke$arity$variadic = G__35661__delegate;
return G__35661;
})()
;
G__35660 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__35660__0.call(this);
case 1:
return G__35660__1.call(this,x);
case 2:
return G__35660__2.call(this,x,y);
case 3:
return G__35660__3.call(this,x,y,z);
default:
var G__35664 = null;
if (arguments.length > 3) {
var G__35665__i = 0, G__35665__a = new Array(arguments.length -  3);
while (G__35665__i < G__35665__a.length) {G__35665__a[G__35665__i] = arguments[G__35665__i + 3]; ++G__35665__i;}
G__35664 = new cljs.core.IndexedSeq(G__35665__a,0);
}
return G__35660__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__35664);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35660.cljs$lang$maxFixedArity = 3;
G__35660.cljs$lang$applyTo = G__35660__4.cljs$lang$applyTo;
G__35660.cljs$core$IFn$_invoke$arity$0 = G__35660__0;
G__35660.cljs$core$IFn$_invoke$arity$1 = G__35660__1;
G__35660.cljs$core$IFn$_invoke$arity$2 = G__35660__2;
G__35660.cljs$core$IFn$_invoke$arity$3 = G__35660__3;
G__35660.cljs$core$IFn$_invoke$arity$variadic = G__35660__4.cljs$core$IFn$_invoke$arity$variadic;
return G__35660;
})()
});

cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic = (function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__35666 = null;
var G__35666__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__35627_SHARP_,p2__35628_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35627_SHARP_,(p2__35628_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__35628_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__35628_SHARP_.call(null)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__35666__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__35629_SHARP_,p2__35630_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35629_SHARP_,(p2__35630_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__35630_SHARP_.cljs$core$IFn$_invoke$arity$1(x) : p2__35630_SHARP_.call(null,x)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__35666__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__35631_SHARP_,p2__35632_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35631_SHARP_,(p2__35632_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__35632_SHARP_.cljs$core$IFn$_invoke$arity$2(x,y) : p2__35632_SHARP_.call(null,x,y)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__35666__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__35633_SHARP_,p2__35634_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35633_SHARP_,(p2__35634_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__35634_SHARP_.cljs$core$IFn$_invoke$arity$3(x,y,z) : p2__35634_SHARP_.call(null,x,y,z)));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__35666__4 = (function() { 
var G__35667__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__35635_SHARP_,p2__35636_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35635_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__35636_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__35667 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__35668__i = 0, G__35668__a = new Array(arguments.length -  3);
while (G__35668__i < G__35668__a.length) {G__35668__a[G__35668__i] = arguments[G__35668__i + 3]; ++G__35668__i;}
  args = new cljs.core.IndexedSeq(G__35668__a,0);
} 
return G__35667__delegate.call(this,x,y,z,args);};
G__35667.cljs$lang$maxFixedArity = 3;
G__35667.cljs$lang$applyTo = (function (arglist__35669){
var x = cljs.core.first(arglist__35669);
arglist__35669 = cljs.core.next(arglist__35669);
var y = cljs.core.first(arglist__35669);
arglist__35669 = cljs.core.next(arglist__35669);
var z = cljs.core.first(arglist__35669);
var args = cljs.core.rest(arglist__35669);
return G__35667__delegate(x,y,z,args);
});
G__35667.cljs$core$IFn$_invoke$arity$variadic = G__35667__delegate;
return G__35667;
})()
;
G__35666 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__35666__0.call(this);
case 1:
return G__35666__1.call(this,x);
case 2:
return G__35666__2.call(this,x,y);
case 3:
return G__35666__3.call(this,x,y,z);
default:
var G__35670 = null;
if (arguments.length > 3) {
var G__35671__i = 0, G__35671__a = new Array(arguments.length -  3);
while (G__35671__i < G__35671__a.length) {G__35671__a[G__35671__i] = arguments[G__35671__i + 3]; ++G__35671__i;}
G__35670 = new cljs.core.IndexedSeq(G__35671__a,0);
}
return G__35666__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__35670);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35666.cljs$lang$maxFixedArity = 3;
G__35666.cljs$lang$applyTo = G__35666__4.cljs$lang$applyTo;
G__35666.cljs$core$IFn$_invoke$arity$0 = G__35666__0;
G__35666.cljs$core$IFn$_invoke$arity$1 = G__35666__1;
G__35666.cljs$core$IFn$_invoke$arity$2 = G__35666__2;
G__35666.cljs$core$IFn$_invoke$arity$3 = G__35666__3;
G__35666.cljs$core$IFn$_invoke$arity$variadic = G__35666__4.cljs$core$IFn$_invoke$arity$variadic;
return G__35666;
})()
;})(fs__$1))
});

cljs.core.juxt.cljs$lang$applyTo = (function (seq35638){
var G__35639 = cljs.core.first(seq35638);
var seq35638__$1 = cljs.core.next(seq35638);
var G__35640 = cljs.core.first(seq35638__$1);
var seq35638__$2 = cljs.core.next(seq35638__$1);
var G__35641 = cljs.core.first(seq35638__$2);
var seq35638__$3 = cljs.core.next(seq35638__$2);
return cljs.core.juxt.cljs$core$IFn$_invoke$arity$variadic(G__35639,G__35640,G__35641,seq35638__$3);
});

cljs.core.juxt.cljs$lang$maxFixedArity = (3);
/**
 * When lazy sequences are produced via functions that have side
 *   effects, any effects other than those needed to produce the first
 *   element in the seq do not occur until the seq is consumed. dorun can
 *   be used to force any effects. Walks through the successive nexts of
 *   the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function cljs$core$dorun(var_args){
var args35672 = [];
var len__7211__auto___35675 = arguments.length;
var i__7212__auto___35676 = (0);
while(true){
if((i__7212__auto___35676 < len__7211__auto___35675)){
args35672.push((arguments[i__7212__auto___35676]));

var G__35677 = (i__7212__auto___35676 + (1));
i__7212__auto___35676 = G__35677;
continue;
} else {
}
break;
}

var G__35674 = args35672.length;
switch (G__35674) {
case 1:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.dorun.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35672.length)].join('')));

}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__35679 = cljs.core.next(coll);
coll = G__35679;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__35680 = (n - (1));
var G__35681 = cljs.core.next(coll);
n = G__35680;
coll = G__35681;
continue;
} else {
return null;
}
break;
}
});

cljs.core.dorun.cljs$lang$maxFixedArity = 2;
/**
 * When lazy sequences are produced via functions that have side
 *   effects, any effects other than those needed to produce the first
 *   element in the seq do not occur until the seq is consumed. doall can
 *   be used to force any effects. Walks through the successive nexts of
 *   the seq, retains the head and returns it, thus causing the entire
 *   seq to reside in memory at one time.
 */
cljs.core.doall = (function cljs$core$doall(var_args){
var args35682 = [];
var len__7211__auto___35685 = arguments.length;
var i__7212__auto___35686 = (0);
while(true){
if((i__7212__auto___35686 < len__7211__auto___35685)){
args35682.push((arguments[i__7212__auto___35686]));

var G__35687 = (i__7212__auto___35686 + (1));
i__7212__auto___35686 = G__35687;
continue;
} else {
}
break;
}

var G__35684 = args35682.length;
switch (G__35684) {
case 1:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.doall.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35682.length)].join('')));

}
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});

cljs.core.doall.cljs$core$IFn$_invoke$arity$2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});

cljs.core.doall.cljs$lang$maxFixedArity = 2;
/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 *   re.exec(s). Returns a vector, containing first the matching
 *   substring, then any capturing groups if the regular expression contains
 *   capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?cljs$core$re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__35690 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35690,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35690,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__6153__auto__ = flags;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_35698 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((cljs.core.cst$kw$print_DASH_length.cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__6153__auto__ = cljs.core.cst$kw$more_DASH_marker.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__35699_35705 = cljs.core.first(coll);
var G__35700_35706 = writer;
var G__35701_35707 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__35699_35705,G__35700_35706,G__35701_35707) : print_one.call(null,G__35699_35705,G__35700_35706,G__35701_35707));
} else {
}

var coll_35708__$1 = cljs.core.next(coll);
var n_35709 = (cljs.core.cst$kw$print_DASH_length.cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_35708__$1) && (((n_35709 == null)) || (!((n_35709 === (0)))))){
cljs.core._write(writer,sep);

var G__35702_35710 = cljs.core.first(coll_35708__$1);
var G__35703_35711 = writer;
var G__35704_35712 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__35702_35710,G__35703_35711,G__35704_35712) : print_one.call(null,G__35702_35710,G__35703_35711,G__35704_35712));

var G__35713 = cljs.core.next(coll_35708__$1);
var G__35714 = (n_35709 - (1));
coll_35708__$1 = G__35713;
n_35709 = G__35714;
continue;
} else {
if((cljs.core.seq(coll_35708__$1)) && ((n_35709 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__6153__auto__ = cljs.core.cst$kw$more_DASH_marker.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_35698;
}});
cljs.core.write_all = (function cljs$core$write_all(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35721 = arguments.length;
var i__7212__auto___35722 = (0);
while(true){
if((i__7212__auto___35722 < len__7211__auto___35721)){
args__7218__auto__.push((arguments[i__7212__auto___35722]));

var G__35723 = (i__7212__auto___35722 + (1));
i__7212__auto___35722 = G__35723;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((1) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((1)),(0))):null);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7219__auto__);
});

cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic = (function (writer,ss){
var seq__35717 = cljs.core.seq(ss);
var chunk__35718 = null;
var count__35719 = (0);
var i__35720 = (0);
while(true){
if((i__35720 < count__35719)){
var s = chunk__35718.cljs$core$IIndexed$_nth$arity$2(null,i__35720);
cljs.core._write(writer,s);

var G__35724 = seq__35717;
var G__35725 = chunk__35718;
var G__35726 = count__35719;
var G__35727 = (i__35720 + (1));
seq__35717 = G__35724;
chunk__35718 = G__35725;
count__35719 = G__35726;
i__35720 = G__35727;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35717);
if(temp__4657__auto__){
var seq__35717__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35717__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__35717__$1);
var G__35728 = cljs.core.chunk_rest(seq__35717__$1);
var G__35729 = c__6956__auto__;
var G__35730 = cljs.core.count(c__6956__auto__);
var G__35731 = (0);
seq__35717 = G__35728;
chunk__35718 = G__35729;
count__35719 = G__35730;
i__35720 = G__35731;
continue;
} else {
var s = cljs.core.first(seq__35717__$1);
cljs.core._write(writer,s);

var G__35732 = cljs.core.next(seq__35717__$1);
var G__35733 = null;
var G__35734 = (0);
var G__35735 = (0);
seq__35717 = G__35732;
chunk__35718 = G__35733;
count__35719 = G__35734;
i__35720 = G__35735;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.write_all.cljs$lang$maxFixedArity = (1);

cljs.core.write_all.cljs$lang$applyTo = (function (seq35715){
var G__35716 = cljs.core.first(seq35715);
var seq35715__$1 = cljs.core.next(seq35715);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(G__35716,seq35715__$1);
});
cljs.core.string_print = (function cljs$core$string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function cljs$core$flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj35737 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj35737;
})();
cljs.core.quote_string = (function cljs$core$quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace(RegExp("[\\\\\"\b\f\n\r\t]","g"),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
cljs.core.print_meta_QMARK_ = (function cljs$core$print_meta_QMARK_(opts,obj){
var and__6141__auto__ = cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.cst$kw$meta));
if(and__6141__auto__){
var and__6141__auto____$1 = ((!((obj == null)))?((((obj.cljs$lang$protocol_mask$partition0$ & (131072))) || (obj.cljs$core$IMeta$))?true:false):false);
if(and__6141__auto____$1){
return !((cljs.core.meta(obj) == null));
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
});
cljs.core.pr_writer_impl = (function cljs$core$pr_writer_impl(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(cljs.core.print_meta_QMARK_(opts,obj)){
cljs.core._write(writer,"^");

var G__35753_35762 = cljs.core.meta(obj);
var G__35754_35763 = writer;
var G__35755_35764 = opts;
(cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3(G__35753_35762,G__35754_35763,G__35755_35764) : cljs.core.pr_writer.call(null,G__35753_35762,G__35754_35763,G__35755_35764));

cljs.core._write(writer," ");
} else {
}

if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if(((!((obj == null)))?((((obj.cljs$lang$protocol_mask$partition0$ & (2147483648))) || (obj.cljs$core$IPrintWithWriter$))?true:false):false)){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if((obj === true) || (obj === false) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__35757 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__35758 = cljs.core.pr_writer;
var G__35759 = writer;
var G__35760 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__35757,G__35758,G__35759,G__35760) : cljs.core.print_map.call(null,G__35757,G__35758,G__35759,G__35760));
} else {
if(cljs.core.array_QMARK_(obj)){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#js ["," ","]",opts,obj);
} else {
if(goog.isString(obj)){
if(cljs.core.truth_(cljs.core.cst$kw$readably.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(goog.isFunction(obj)){
var name = obj.name;
var name__$1 = (cljs.core.truth_((function (){var or__6153__auto__ = (name == null);
if(or__6153__auto__){
return or__6153__auto__;
} else {
return goog.string.isEmpty(name);
}
})())?"Function":name);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#object[",name__$1," \"",[cljs.core.str(obj)].join(''),"\"]"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__35765 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__35765;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.regexp_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if(((!((obj == null)))?((((obj.cljs$lang$protocol_mask$partition0$ & (2147483648))) || (obj.cljs$core$IPrintWithWriter$))?true:false):false)){
return cljs.core._pr_writer(obj,writer,opts);
} else {
if(cljs.core.truth_(obj.constructor.cljs$lang$ctorStr)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#object[",obj.constructor.cljs$lang$ctorStr.replace((new RegExp("/","g")),"."),"]"], 0));
} else {
var name = obj.constructor.name;
var name__$1 = (cljs.core.truth_((function (){var or__6153__auto__ = (name == null);
if(or__6153__auto__){
return or__6153__auto__;
} else {
return goog.string.isEmpty(name);
}
})())?"Object":name);
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#object[",name__$1," ",[cljs.core.str(obj)].join(''),"]"], 0));
}

}
}
}
}
}
}
}
}
}
}

}
});
/**
 * Prefer this to pr-seq, because it makes the printing function
 * configurable, allowing efficient implementations such as appending
 * to a StringBuffer.
 */
cljs.core.pr_writer = (function cljs$core$pr_writer(obj,writer,opts){
var temp__4655__auto__ = cljs.core.cst$kw$alt_DASH_impl.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4655__auto__)){
var alt_impl = temp__4655__auto__;
var G__35769 = obj;
var G__35770 = writer;
var G__35771 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$fallback_DASH_impl,cljs.core.pr_writer_impl);
return (alt_impl.cljs$core$IFn$_invoke$arity$3 ? alt_impl.cljs$core$IFn$_invoke$arity$3(G__35769,G__35770,G__35771) : alt_impl.call(null,G__35769,G__35770,G__35771));
} else {
return cljs.core.pr_writer_impl(obj,writer,opts);
}
});
cljs.core.pr_seq_writer = (function cljs$core$pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__35776 = cljs.core.seq(cljs.core.next(objs));
var chunk__35777 = null;
var count__35778 = (0);
var i__35779 = (0);
while(true){
if((i__35779 < count__35778)){
var obj = chunk__35777.cljs$core$IIndexed$_nth$arity$2(null,i__35779);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__35780 = seq__35776;
var G__35781 = chunk__35777;
var G__35782 = count__35778;
var G__35783 = (i__35779 + (1));
seq__35776 = G__35780;
chunk__35777 = G__35781;
count__35778 = G__35782;
i__35779 = G__35783;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__35776);
if(temp__4657__auto__){
var seq__35776__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__35776__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__35776__$1);
var G__35784 = cljs.core.chunk_rest(seq__35776__$1);
var G__35785 = c__6956__auto__;
var G__35786 = cljs.core.count(c__6956__auto__);
var G__35787 = (0);
seq__35776 = G__35784;
chunk__35777 = G__35785;
count__35778 = G__35786;
i__35779 = G__35787;
continue;
} else {
var obj = cljs.core.first(seq__35776__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__35788 = cljs.core.next(seq__35776__$1);
var G__35789 = null;
var G__35790 = (0);
var G__35791 = (0);
seq__35776 = G__35788;
chunk__35777 = G__35789;
count__35778 = G__35790;
i__35779 = G__35791;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function cljs$core$pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
 * Prints a sequence of objects to a string, observing all the
 *   options given in opts
 */
cljs.core.pr_str_with_opts = (function cljs$core$pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
 * Same as pr-str-with-opts followed by (newline)
 */
cljs.core.prn_str_with_opts = (function cljs$core$prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
 * Prints a sequence of objects using string-print, observing all
 *   the options given in opts
 */
cljs.core.pr_with_opts = (function cljs$core$pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function cljs$core$newline(var_args){
var args35792 = [];
var len__7211__auto___35795 = arguments.length;
var i__7212__auto___35796 = (0);
while(true){
if((i__7212__auto___35796 < len__7211__auto___35795)){
args35792.push((arguments[i__7212__auto___35796]));

var G__35797 = (i__7212__auto___35796 + (1));
i__7212__auto___35796 = G__35797;
continue;
} else {
}
break;
}

var G__35794 = args35792.length;
switch (G__35794) {
case 0:
return cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35792.length)].join('')));

}
});

cljs.core.newline.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.newline.cljs$core$IFn$_invoke$arity$1 = (function (opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,cljs.core.cst$kw$flush_DASH_on_DASH_newline))){
return cljs.core.flush();
} else {
return null;
}
});

cljs.core.newline.cljs$lang$maxFixedArity = 1;
/**
 * pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
 */
cljs.core.pr_str = (function cljs$core$pr_str(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35800 = arguments.length;
var i__7212__auto___35801 = (0);
while(true){
if((i__7212__auto___35801 < len__7211__auto___35800)){
args__7218__auto__.push((arguments[i__7212__auto___35801]));

var G__35802 = (i__7212__auto___35801 + (1));
i__7212__auto___35801 = G__35802;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr_str.cljs$lang$maxFixedArity = (0);

cljs.core.pr_str.cljs$lang$applyTo = (function (seq35799){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35799));
});
/**
 * Same as pr-str followed by (newline)
 */
cljs.core.prn_str = (function cljs$core$prn_str(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35804 = arguments.length;
var i__7212__auto___35805 = (0);
while(true){
if((i__7212__auto___35805 < len__7211__auto___35804)){
args__7218__auto__.push((arguments[i__7212__auto___35805]));

var G__35806 = (i__7212__auto___35805 + (1));
i__7212__auto___35805 = G__35806;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.prn_str.cljs$lang$maxFixedArity = (0);

cljs.core.prn_str.cljs$lang$applyTo = (function (seq35803){
return cljs.core.prn_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35803));
});
/**
 * Prints the object(s) using string-print.  Prints the
 *   object(s), separated by spaces if there is more than one.
 *   By default, pr and prn print in a way that objects can be
 *   read by the reader
 */
cljs.core.pr = (function cljs$core$pr(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35808 = arguments.length;
var i__7212__auto___35809 = (0);
while(true){
if((i__7212__auto___35809 < len__7211__auto___35808)){
args__7218__auto__.push((arguments[i__7212__auto___35809]));

var G__35810 = (i__7212__auto___35809 + (1));
i__7212__auto___35809 = G__35810;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
});

cljs.core.pr.cljs$lang$maxFixedArity = (0);

cljs.core.pr.cljs$lang$applyTo = (function (seq35807){
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35807));
});
/**
 * Prints the object(s) using string-print.
 *   print and println produce output for human consumption.
 * @param {...*} var_args
 */
cljs.core.print = (function() { 
var cljs$core$cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),cljs.core.cst$kw$readably,false));
};
var cljs$core$cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__35811__i = 0, G__35811__a = new Array(arguments.length -  0);
while (G__35811__i < G__35811__a.length) {G__35811__a[G__35811__i] = arguments[G__35811__i + 0]; ++G__35811__i;}
  objs = new cljs.core.IndexedSeq(G__35811__a,0);
} 
return cljs$core$cljs_core_print__delegate.call(this,objs);};
cljs$core$cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs$core$cljs_core_print.cljs$lang$applyTo = (function (arglist__35812){
var objs = cljs.core.seq(arglist__35812);
return cljs$core$cljs_core_print__delegate(objs);
});
cljs$core$cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs$core$cljs_core_print__delegate;
return cljs$core$cljs_core_print;
})()
;
/**
 * print to a string, returning it
 */
cljs.core.print_str = (function cljs$core$print_str(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35814 = arguments.length;
var i__7212__auto___35815 = (0);
while(true){
if((i__7212__auto___35815 < len__7211__auto___35814)){
args__7218__auto__.push((arguments[i__7212__auto___35815]));

var G__35816 = (i__7212__auto___35815 + (1));
i__7212__auto___35815 = G__35816;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),cljs.core.cst$kw$readably,false));
});

cljs.core.print_str.cljs$lang$maxFixedArity = (0);

cljs.core.print_str.cljs$lang$applyTo = (function (seq35813){
return cljs.core.print_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35813));
});
/**
 * Same as print followed by (newline)
 */
cljs.core.println = (function cljs$core$println(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35818 = arguments.length;
var i__7212__auto___35819 = (0);
while(true){
if((i__7212__auto___35819 < len__7211__auto___35818)){
args__7218__auto__.push((arguments[i__7212__auto___35819]));

var G__35820 = (i__7212__auto___35819 + (1));
i__7212__auto___35819 = G__35820;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),cljs.core.cst$kw$readably,false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.println.cljs$lang$maxFixedArity = (0);

cljs.core.println.cljs$lang$applyTo = (function (seq35817){
return cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35817));
});
/**
 * println to a string, returning it
 */
cljs.core.println_str = (function cljs$core$println_str(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35822 = arguments.length;
var i__7212__auto___35823 = (0);
while(true){
if((i__7212__auto___35823 < len__7211__auto___35822)){
args__7218__auto__.push((arguments[i__7212__auto___35823]));

var G__35824 = (i__7212__auto___35823 + (1));
i__7212__auto___35823 = G__35824;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),cljs.core.cst$kw$readably,false));
});

cljs.core.println_str.cljs$lang$maxFixedArity = (0);

cljs.core.println_str.cljs$lang$applyTo = (function (seq35821){
return cljs.core.println_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35821));
});
/**
 * Same as pr followed by (newline).
 */
cljs.core.prn = (function cljs$core$prn(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35826 = arguments.length;
var i__7212__auto___35827 = (0);
while(true){
if((i__7212__auto___35827 < len__7211__auto___35826)){
args__7218__auto__.push((arguments[i__7212__auto___35827]));

var G__35828 = (i__7212__auto___35827 + (1));
i__7212__auto___35827 = G__35828;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic = (function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline.cljs$core$IFn$_invoke$arity$1(cljs.core.pr_opts());
} else {
return null;
}
});

cljs.core.prn.cljs$lang$maxFixedArity = (0);

cljs.core.prn.cljs$lang$applyTo = (function (seq35825){
return cljs.core.prn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35825));
});
cljs.core.print_map = (function cljs$core$print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__35835_35841 = cljs.core.key(e);
var G__35836_35842 = w;
var G__35837_35843 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__35835_35841,G__35836_35842,G__35837_35843) : print_one.call(null,G__35835_35841,G__35836_35842,G__35837_35843));

cljs.core._write(w," ");

var G__35838 = cljs.core.val(e);
var G__35839 = w;
var G__35840 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__35838,G__35839,G__35840) : print_one.call(null,G__35838,G__35839,G__35840));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#object [cljs.core.Volatile ");

cljs.core.pr_writer(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$val,a__$1.state], null),writer,opts);

return cljs.core._write(writer,"]");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#object [cljs.core.Atom ");

cljs.core.pr_writer(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$val,a__$1.state], null),writer,opts);

return cljs.core._write(writer,"]");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if((y instanceof cljs.core.Symbol)){
return cljs.core.compare_symbols(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if((y instanceof cljs.core.Keyword)){
return cljs.core.compare_keywords(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if(cljs.core.vector_QMARK_(y)){
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});

cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
if(cljs.core.vector_QMARK_(y)){
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
} else {
throw (new Error([cljs.core.str("Cannot compare "),cljs.core.str(x__$1),cljs.core.str(" to "),cljs.core.str(y)].join('')));
}
});
/**
 * Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
 * 
 *   (apply f its-current-meta args)
 * 
 *   f must be free of side-effects
 */
cljs.core.alter_meta_BANG_ = (function cljs$core$alter_meta_BANG_(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35847 = arguments.length;
var i__7212__auto___35848 = (0);
while(true){
if((i__7212__auto___35848 < len__7211__auto___35847)){
args__7218__auto__.push((arguments[i__7212__auto___35848]));

var G__35849 = (i__7212__auto___35848 + (1));
i__7212__auto___35848 = G__35849;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((2) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((2)),(0))):null);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7219__auto__);
});

cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
});

cljs.core.alter_meta_BANG_.cljs$lang$maxFixedArity = (2);

cljs.core.alter_meta_BANG_.cljs$lang$applyTo = (function (seq35844){
var G__35845 = cljs.core.first(seq35844);
var seq35844__$1 = cljs.core.next(seq35844);
var G__35846 = cljs.core.first(seq35844__$1);
var seq35844__$2 = cljs.core.next(seq35844__$1);
return cljs.core.alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__35845,G__35846,seq35844__$2);
});
/**
 * Atomically resets the metadata for an atom
 */
cljs.core.reset_meta_BANG_ = (function cljs$core$reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
 * Adds a watch function to an atom reference. The watch fn must be a
 *   fn of 4 args: a key, the reference, its old-state, its
 *   new-state. Whenever the reference's state might have been changed,
 *   any registered watches will have their functions called. The watch
 *   fn will be called synchronously. Note that an atom's state
 *   may have changed again prior to the fn call, so use old/new-state
 *   rather than derefing the reference. Keys must be unique per
 *   reference, and can be used to remove the watch with remove-watch,
 *   but are otherwise considered opaque by the watch mechanism.  Bear in
 *   mind that regardless of the result or action of the watch fns the
 *   atom's value will change.  Example:
 * 
 *    (def a (atom 0))
 *    (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
 *    (swap! a inc)
 *    ;; Assertion Error
 *    (deref a)
 *    ;=> 1
 */
cljs.core.add_watch = (function cljs$core$add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
 * Removes a watch (set by add-watch) from a reference
 */
cljs.core.remove_watch = (function cljs$core$remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
/**
 * @type {*}
 */
cljs.core.gensym_counter = null;
/**
 * Returns a new symbol with a unique name. If a prefix string is
 *   supplied, the name is prefix# where # is some unique number. If
 *   prefix is not supplied, the prefix is 'G__'.
 */
cljs.core.gensym = (function cljs$core$gensym(var_args){
var args35850 = [];
var len__7211__auto___35853 = arguments.length;
var i__7212__auto___35854 = (0);
while(true){
if((i__7212__auto___35854 < len__7211__auto___35853)){
args35850.push((arguments[i__7212__auto___35854]));

var G__35855 = (i__7212__auto___35854 + (1));
i__7212__auto___35854 = G__35855;
continue;
} else {
}
break;
}

var G__35852 = args35850.length;
switch (G__35852) {
case 0:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35850.length)].join('')));

}
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("G__");
});

cljs.core.gensym.cljs$core$IFn$_invoke$arity$1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0)) : cljs.core.atom.call(null,(0)));
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});

cljs.core.gensym.cljs$lang$maxFixedArity = 1;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
 * @implements {cljs.core.IPending}
 * @implements {cljs.core.IDeref}
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition0$ = 32768;
this.cljs$lang$protocol_mask$partition1$ = 1;
})
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (x){
var self__ = this;
var x__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$f,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null)),cljs.core.with_meta(cljs.core.cst$sym$value,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function cljs$core$__GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
 * returns true if x is a Delay created with delay
 */
cljs.core.delay_QMARK_ = (function cljs$core$delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
 * If x is a Delay, returns the (possibly cached) value of its expression, else returns x
 */
cljs.core.force = (function cljs$core$force(x){
if(cljs.core.delay_QMARK_(x)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(x) : cljs.core.deref.call(null,x));
} else {
return x;
}
});
/**
 * Returns true if a value has been produced for a delay or lazy sequence.
 */
cljs.core.realized_QMARK_ = (function cljs$core$realized_QMARK_(x){
return cljs.core._realized_QMARK_(x);
});
cljs.core.preserving_reduced = (function cljs$core$preserving_reduced(rf){
return (function (p1__35857_SHARP_,p2__35858_SHARP_){
var ret = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(p1__35857_SHARP_,p2__35858_SHARP_) : rf.call(null,p1__35857_SHARP_,p2__35858_SHARP_));
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
 * A transducer which concatenates the contents of each input, which must be a
 *   collection, into the reduction.
 */
cljs.core.cat = (function cljs$core$cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__35859 = null;
var G__35859__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__35859__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__35859__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__35859 = function(result,input){
switch(arguments.length){
case 0:
return G__35859__0.call(this);
case 1:
return G__35859__1.call(this,result);
case 2:
return G__35859__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35859.cljs$core$IFn$_invoke$arity$0 = G__35859__0;
G__35859.cljs$core$IFn$_invoke$arity$1 = G__35859__1;
G__35859.cljs$core$IFn$_invoke$arity$2 = G__35859__2;
return G__35859;
})()
;})(rf1))
});
/**
 * Returns a lazy sequence removing consecutive duplicates in coll.
 *   Returns a transducer when no collection is provided.
 */
cljs.core.dedupe = (function cljs$core$dedupe(var_args){
var args35860 = [];
var len__7211__auto___35863 = arguments.length;
var i__7212__auto___35864 = (0);
while(true){
if((i__7212__auto___35864 < len__7211__auto___35863)){
args35860.push((arguments[i__7212__auto___35864]));

var G__35865 = (i__7212__auto___35864 + (1));
i__7212__auto___35864 = G__35865;
continue;
} else {
}
break;
}

var G__35862 = args35860.length;
switch (G__35862) {
case 0:
return cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35860.length)].join('')));

}
});

cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(cljs.core.cst$kw$cljs$core_SLASH_none);
return ((function (pa){
return (function() {
var G__35867 = null;
var G__35867__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__35867__1 = (function (result){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(result) : rf.call(null,result));
});
var G__35867__2 = (function (result,input){
var prior = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pa) : cljs.core.deref.call(null,pa));
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(result,input) : rf.call(null,result,input));
}
});
G__35867 = function(result,input){
switch(arguments.length){
case 0:
return G__35867__0.call(this);
case 1:
return G__35867__1.call(this,result);
case 2:
return G__35867__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__35867.cljs$core$IFn$_invoke$arity$0 = G__35867__0;
G__35867.cljs$core$IFn$_invoke$arity$1 = G__35867__1;
G__35867.cljs$core$IFn$_invoke$arity$2 = G__35867__2;
return G__35867;
})()
;})(pa))
});
});

cljs.core.dedupe.cljs$core$IFn$_invoke$arity$1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs.core.dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});

cljs.core.dedupe.cljs$lang$maxFixedArity = 1;
/**
 * Returns items from coll with random probability of prob (0.0 -
 *   1.0).  Returns a transducer when no collection is provided.
 */
cljs.core.random_sample = (function cljs$core$random_sample(var_args){
var args35868 = [];
var len__7211__auto___35871 = arguments.length;
var i__7212__auto___35872 = (0);
while(true){
if((i__7212__auto___35872 < len__7211__auto___35871)){
args35868.push((arguments[i__7212__auto___35872]));

var G__35873 = (i__7212__auto___35872 + (1));
i__7212__auto___35872 = G__35873;
continue;
} else {
}
break;
}

var G__35870 = args35868.length;
switch (G__35870) {
case 1:
return cljs.core.random_sample.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.random_sample.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args35868.length)].join('')));

}
});

cljs.core.random_sample.cljs$core$IFn$_invoke$arity$1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null)) < prob);
}));
});

cljs.core.random_sample.cljs$core$IFn$_invoke$arity$2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null)) < prob);
}),coll);
});

cljs.core.random_sample.cljs$lang$maxFixedArity = 2;

/**
* @constructor
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.ISequential}
 * @implements {cljs.core.IReduce}
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (_,f){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$3(self__.xform,cljs.core.completing.cljs$core$IFn$_invoke$arity$1(f),self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,cljs.core.completing.cljs$core$IFn$_invoke$arity$1(f),init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$xform,cljs.core.cst$sym$coll], null);
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function cljs$core$__GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__7147__auto__ = this;
return cljs.core.es6_iterator(this__7147__auto__);
}));
/**
 * Returns a reducible/iterable application of the transducers
 *   to the items in coll. Transducers are applied in order as if
 *   combined with comp. Note that these applications will be
 *   performed every time reduce/iterator is called.
 */
cljs.core.eduction = (function cljs$core$eduction(var_args){
var args__7218__auto__ = [];
var len__7211__auto___35876 = arguments.length;
var i__7212__auto___35877 = (0);
while(true){
if((i__7212__auto___35877 < len__7211__auto___35876)){
args__7218__auto__.push((arguments[i__7212__auto___35877]));

var G__35878 = (i__7212__auto___35877 + (1));
i__7212__auto___35877 = G__35878;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((0) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((0)),(0))):null);
return cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(argseq__7219__auto__);
});

cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic = (function (xforms){
return (new cljs.core.Eduction(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,cljs.core.butlast(xforms)),cljs.core.last(xforms)));
});

cljs.core.eduction.cljs$lang$maxFixedArity = (0);

cljs.core.eduction.cljs$lang$applyTo = (function (seq35875){
return cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq35875));
});
/**
 * Runs the supplied procedure (via reduce), for purposes of side
 *   effects, on successive items in the collection. Returns nil
 */
cljs.core.run_BANG_ = (function cljs$core$run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__35880_SHARP_,p2__35879_SHARP_){
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(p2__35879_SHARP_) : proc.call(null,p2__35879_SHARP_));
}),null,coll);
});

/**
 * @interface
 */
cljs.core.IEncodeJS = function(){};

/**
 * Recursively transforms clj values to JavaScript
 */
cljs.core._clj__GT_js = (function cljs$core$_clj__GT_js(x){
if((!((x == null))) && (!((x.cljs$core$IEncodeJS$_clj__GT_js$arity$1 == null)))){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__6808__auto__ = (((x == null))?null:x);
var m__6809__auto__ = (cljs.core._clj__GT_js[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto__.call(null,x));
} else {
var m__6809__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
}
});

/**
 * Transforms map keys to valid JavaScript keys. Arbitrary keys are
 *   encoded to their string representation via (pr-str x)
 */
cljs.core._key__GT_js = (function cljs$core$_key__GT_js(x){
if((!((x == null))) && (!((x.cljs$core$IEncodeJS$_key__GT_js$arity$1 == null)))){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__6808__auto__ = (((x == null))?null:x);
var m__6809__auto__ = (cljs.core._key__GT_js[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto__.call(null,x));
} else {
var m__6809__auto____$1 = (cljs.core._key__GT_js["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(x) : m__6809__auto____$1.call(null,x));
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
}
});

cljs.core.key__GT_js = (function cljs$core$key__GT_js(k){
if(((!((k == null)))?(((false) || (k.cljs$core$IEncodeJS$))?true:(((!k.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,k):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,k))){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(k) : cljs.core.clj__GT_js.call(null,k));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
 * Maps become Objects. Arbitrary keys are encoded to by key->js.
 */
cljs.core.clj__GT_js = (function cljs$core$clj__GT_js(x){
if((x == null)){
return null;
} else {
if(((!((x == null)))?(((false) || (x.cljs$core$IEncodeJS$))?true:(((!x.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x):false)):cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,x))){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = {};
var seq__35899_35909 = cljs.core.seq(x);
var chunk__35900_35910 = null;
var count__35901_35911 = (0);
var i__35902_35912 = (0);
while(true){
if((i__35902_35912 < count__35901_35911)){
var vec__35903_35913 = chunk__35900_35910.cljs$core$IIndexed$_nth$arity$2(null,i__35902_35912);
var k_35914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35903_35913,(0),null);
var v_35915 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35903_35913,(1),null);
(m[cljs.core.key__GT_js(k_35914)] = cljs$core$clj__GT_js(v_35915));

var G__35916 = seq__35899_35909;
var G__35917 = chunk__35900_35910;
var G__35918 = count__35901_35911;
var G__35919 = (i__35902_35912 + (1));
seq__35899_35909 = G__35916;
chunk__35900_35910 = G__35917;
count__35901_35911 = G__35918;
i__35902_35912 = G__35919;
continue;
} else {
var temp__4657__auto___35920 = cljs.core.seq(seq__35899_35909);
if(temp__4657__auto___35920){
var seq__35899_35921__$1 = temp__4657__auto___35920;
if(cljs.core.chunked_seq_QMARK_(seq__35899_35921__$1)){
var c__6956__auto___35922 = cljs.core.chunk_first(seq__35899_35921__$1);
var G__35923 = cljs.core.chunk_rest(seq__35899_35921__$1);
var G__35924 = c__6956__auto___35922;
var G__35925 = cljs.core.count(c__6956__auto___35922);
var G__35926 = (0);
seq__35899