// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args38154 = [];
var len__7211__auto___38160 = arguments.length;
var i__7212__auto___38161 = (0);
while(true){
if((i__7212__auto___38161 < len__7211__auto___38160)){
args38154.push((arguments[i__7212__auto___38161]));

var G__38162 = (i__7212__auto___38161 + (1));
i__7212__auto___38161 = G__38162;
continue;
} else {
}
break;
}

var G__38156 = args38154.length;
switch (G__38156) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38154.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async38157 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38157 = (function (f,blockable,meta38158){
this.f = f;
this.blockable = blockable;
this.meta38158 = meta38158;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38157.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38159,meta38158__$1){
var self__ = this;
var _38159__$1 = this;
return (new cljs.core.async.t_cljs$core$async38157(self__.f,self__.blockable,meta38158__$1));
});

cljs.core.async.t_cljs$core$async38157.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38159){
var self__ = this;
var _38159__$1 = this;
return self__.meta38158;
});

cljs.core.async.t_cljs$core$async38157.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async38157.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async38157.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async38157.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async38157.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta38158], null);
});

cljs.core.async.t_cljs$core$async38157.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38157.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38157";

cljs.core.async.t_cljs$core$async38157.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async38157");
});

cljs.core.async.__GT_t_cljs$core$async38157 = (function cljs$core$async$__GT_t_cljs$core$async38157(f__$1,blockable__$1,meta38158){
return (new cljs.core.async.t_cljs$core$async38157(f__$1,blockable__$1,meta38158));
});

}

return (new cljs.core.async.t_cljs$core$async38157(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;
/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args38166 = [];
var len__7211__auto___38169 = arguments.length;
var i__7212__auto___38170 = (0);
while(true){
if((i__7212__auto___38170 < len__7211__auto___38169)){
args38166.push((arguments[i__7212__auto___38170]));

var G__38171 = (i__7212__auto___38170 + (1));
i__7212__auto___38170 = G__38171;
continue;
} else {
}
break;
}

var G__38168 = args38166.length;
switch (G__38168) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38166.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$buf_DASH_or_DASH_n], 0)))].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args38173 = [];
var len__7211__auto___38176 = arguments.length;
var i__7212__auto___38177 = (0);
while(true){
if((i__7212__auto___38177 < len__7211__auto___38176)){
args38173.push((arguments[i__7212__auto___38177]));

var G__38178 = (i__7212__auto___38177 + (1));
i__7212__auto___38177 = G__38178;
continue;
} else {
}
break;
}

var G__38175 = args38173.length;
switch (G__38175) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38173.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args38180 = [];
var len__7211__auto___38183 = arguments.length;
var i__7212__auto___38184 = (0);
while(true){
if((i__7212__auto___38184 < len__7211__auto___38183)){
args38180.push((arguments[i__7212__auto___38184]));

var G__38185 = (i__7212__auto___38184 + (1));
i__7212__auto___38184 = G__38185;
continue;
} else {
}
break;
}

var G__38182 = args38180.length;
switch (G__38182) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38180.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_38187 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_38187) : fn1.call(null,val_38187));
} else {
cljs.core.async.impl.dispatch.run(((function (val_38187,ret){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_38187) : fn1.call(null,val_38187));
});})(val_38187,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;
cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args38188 = [];
var len__7211__auto___38191 = arguments.length;
var i__7212__auto___38192 = (0);
while(true){
if((i__7212__auto___38192 < len__7211__auto___38191)){
args38188.push((arguments[i__7212__auto___38192]));

var G__38193 = (i__7212__auto___38192 + (1));
i__7212__auto___38192 = G__38193;
continue;
} else {
}
break;
}

var G__38190 = args38188.length;
switch (G__38190) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38188.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(retb) : cljs.core.deref.call(null,retb));
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run(((function (ret,retb,temp__4655__auto__){
return (function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;
cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7056__auto___38195 = n;
var x_38196 = (0);
while(true){
if((x_38196 < n__7056__auto___38195)){
(a[x_38196] = (0));

var G__38197 = (x_38196 + (1));
x_38196 = G__38197;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(i,n)){
return a;
} else {
var j = cljs.core.rand_int(i);
(a[i] = (a[j]));

(a[j] = i);

var G__38198 = (i + (1));
i = G__38198;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true) : cljs.core.atom.call(null,true));
if(typeof cljs.core.async.t_cljs$core$async38202 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38202 = (function (alt_flag,flag,meta38203){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta38203 = meta38203;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38202.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_38204,meta38203__$1){
var self__ = this;
var _38204__$1 = this;
return (new cljs.core.async.t_cljs$core$async38202(self__.alt_flag,self__.flag,meta38203__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async38202.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_38204){
var self__ = this;
var _38204__$1 = this;
return self__.meta38203;
});})(flag))
;

cljs.core.async.t_cljs$core$async38202.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async38202.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.flag) : cljs.core.deref.call(null,self__.flag));
});})(flag))
;

cljs.core.async.t_cljs$core$async38202.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async38202.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.flag,null) : cljs.core.reset_BANG_.call(null,self__.flag,null));

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async38202.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_flag,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$meta38203], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async38202.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38202.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38202";

cljs.core.async.t_cljs$core$async38202.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async38202");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async38202 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async38202(alt_flag__$1,flag__$1,meta38203){
return (new cljs.core.async.t_cljs$core$async38202(alt_flag__$1,flag__$1,meta38203));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async38202(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async38208 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async38208 = (function (alt_handler,flag,cb,meta38209){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta38209 = meta38209;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async38208.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_38210,meta38209__$1){
var self__ = this;
var _38210__$1 = this;
return (new cljs.core.async.t_cljs$core$async38208(self__.alt_handler,self__.flag,self__.cb,meta38209__$1));
});

cljs.core.async.t_cljs$core$async38208.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_38210){
var self__ = this;
var _38210__$1 = this;
return self__.meta38209;
});

cljs.core.async.t_cljs$core$async38208.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async38208.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
});

cljs.core.async.t_cljs$core$async38208.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async38208.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async38208.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$alt_DASH_handler,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$private,true,cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb], null)))], null)),cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta38209], null);
});

cljs.core.async.t_cljs$core$async38208.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async38208.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async38208";

cljs.core.async.t_cljs$core$async38208.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async38208");
});

cljs.core.async.__GT_t_cljs$core$async38208 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async38208(alt_handler__$1,flag__$1,cb__$1,meta38209){
return (new cljs.core.async.t_cljs$core$async38208(alt_handler__$1,flag__$1,cb__$1,meta38209));
});

}

return (new cljs.core.async.t_cljs$core$async38208(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__38211_SHARP_){
var G__38215 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38211_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__38215) : fret.call(null,G__38215));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__38212_SHARP_){
var G__38216 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__38212_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__38216) : fret.call(null,G__38216));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(vbox) : cljs.core.deref.call(null,vbox)),(function (){var or__6153__auto__ = wport;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return port;
}
})()], null));
} else {
var G__38217 = (i + (1));
i = G__38217;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6153__auto__ = ret;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__4657__auto__ = (function (){var and__6141__auto__ = cljs.core.async.impl.protocols.active_QMARK_(flag);
if(cljs.core.truth_(and__6141__auto__)){
return cljs.core.async.impl.protocols.commit(flag);
} else {
return and__6141__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7218__auto__ = [];
var len__7211__auto___38223 = arguments.length;
var i__7212__auto___38224 = (0);
while(true){
if((i__7212__auto___38224 < len__7211__auto___38223)){
args__7218__auto__.push((arguments[i__7212__auto___38224]));

var G__38225 = (i__7212__auto___38224 + (1));
i__7212__auto___38224 = G__38225;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((1) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((1)),(0))):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7219__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__38220){
var map__38221 = p__38220;
var map__38221__$1 = ((((!((map__38221 == null)))?((((map__38221.cljs$lang$protocol_mask$partition0$ & (64))) || (map__38221.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__38221):map__38221);
var opts = map__38221__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq38218){
var G__38219 = cljs.core.first(seq38218);
var seq38218__$1 = cljs.core.next(seq38218);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__38219,seq38218__$1);
});
/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args38226 = [];
var len__7211__auto___38276 = arguments.length;
var i__7212__auto___38277 = (0);
while(true){
if((i__7212__auto___38277 < len__7211__auto___38276)){
args38226.push((arguments[i__7212__auto___38277]));

var G__38278 = (i__7212__auto___38277 + (1));
i__7212__auto___38277 = G__38278;
continue;
} else {
}
break;
}

var G__38228 = args38226.length;
switch (G__38228) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38226.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__38109__auto___38280 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___38280){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___38280){
return (function (state_38252){
var state_val_38253 = (state_38252[(1)]);
if((state_val_38253 === (7))){
var inst_38248 = (state_38252[(2)]);
var state_38252__$1 = state_38252;
var statearr_38254_38281 = state_38252__$1;
(statearr_38254_38281[(2)] = inst_38248);

(statearr_38254_38281[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (1))){
var state_38252__$1 = state_38252;
var statearr_38255_38282 = state_38252__$1;
(statearr_38255_38282[(2)] = null);

(statearr_38255_38282[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (4))){
var inst_38231 = (state_38252[(7)]);
var inst_38231__$1 = (state_38252[(2)]);
var inst_38232 = (inst_38231__$1 == null);
var state_38252__$1 = (function (){var statearr_38256 = state_38252;
(statearr_38256[(7)] = inst_38231__$1);

return statearr_38256;
})();
if(cljs.core.truth_(inst_38232)){
var statearr_38257_38283 = state_38252__$1;
(statearr_38257_38283[(1)] = (5));

} else {
var statearr_38258_38284 = state_38252__$1;
(statearr_38258_38284[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (13))){
var state_38252__$1 = state_38252;
var statearr_38259_38285 = state_38252__$1;
(statearr_38259_38285[(2)] = null);

(statearr_38259_38285[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (6))){
var inst_38231 = (state_38252[(7)]);
var state_38252__$1 = state_38252;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38252__$1,(11),to,inst_38231);
} else {
if((state_val_38253 === (3))){
var inst_38250 = (state_38252[(2)]);
var state_38252__$1 = state_38252;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38252__$1,inst_38250);
} else {
if((state_val_38253 === (12))){
var state_38252__$1 = state_38252;
var statearr_38260_38286 = state_38252__$1;
(statearr_38260_38286[(2)] = null);

(statearr_38260_38286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (2))){
var state_38252__$1 = state_38252;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38252__$1,(4),from);
} else {
if((state_val_38253 === (11))){
var inst_38241 = (state_38252[(2)]);
var state_38252__$1 = state_38252;
if(cljs.core.truth_(inst_38241)){
var statearr_38261_38287 = state_38252__$1;
(statearr_38261_38287[(1)] = (12));

} else {
var statearr_38262_38288 = state_38252__$1;
(statearr_38262_38288[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (9))){
var state_38252__$1 = state_38252;
var statearr_38263_38289 = state_38252__$1;
(statearr_38263_38289[(2)] = null);

(statearr_38263_38289[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (5))){
var state_38252__$1 = state_38252;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38264_38290 = state_38252__$1;
(statearr_38264_38290[(1)] = (8));

} else {
var statearr_38265_38291 = state_38252__$1;
(statearr_38265_38291[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (14))){
var inst_38246 = (state_38252[(2)]);
var state_38252__$1 = state_38252;
var statearr_38266_38292 = state_38252__$1;
(statearr_38266_38292[(2)] = inst_38246);

(statearr_38266_38292[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (10))){
var inst_38238 = (state_38252[(2)]);
var state_38252__$1 = state_38252;
var statearr_38267_38293 = state_38252__$1;
(statearr_38267_38293[(2)] = inst_38238);

(statearr_38267_38293[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38253 === (8))){
var inst_38235 = cljs.core.async.close_BANG_(to);
var state_38252__$1 = state_38252;
var statearr_38268_38294 = state_38252__$1;
(statearr_38268_38294[(2)] = inst_38235);

(statearr_38268_38294[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___38280))
;
return ((function (switch__37995__auto__,c__38109__auto___38280){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_38272 = [null,null,null,null,null,null,null,null];
(statearr_38272[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_38272[(1)] = (1));

return statearr_38272;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_38252){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38252);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38273){if((e38273 instanceof Object)){
var ex__37999__auto__ = e38273;
var statearr_38274_38295 = state_38252;
(statearr_38274_38295[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38252);

return cljs.core.cst$kw$recur;
} else {
throw e38273;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38296 = state_38252;
state_38252 = G__38296;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_38252){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_38252);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___38280))
})();
var state__38111__auto__ = (function (){var statearr_38275 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38275[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___38280);

return statearr_38275;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___38280))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;
cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$pos_QMARK_,cljs.core.cst$sym$n)], 0)))].join('')));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = ((function (jobs,results){
return (function (p__38480){
var vec__38481 = p__38480;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38481,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38481,(1),null);
var job = vec__38481;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__38109__auto___38663 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___38663,res,vec__38481,v,p,job,jobs,results){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___38663,res,vec__38481,v,p,job,jobs,results){
return (function (state_38486){
var state_val_38487 = (state_38486[(1)]);
if((state_val_38487 === (1))){
var state_38486__$1 = state_38486;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38486__$1,(2),res,v);
} else {
if((state_val_38487 === (2))){
var inst_38483 = (state_38486[(2)]);
var inst_38484 = cljs.core.async.close_BANG_(res);
var state_38486__$1 = (function (){var statearr_38488 = state_38486;
(statearr_38488[(7)] = inst_38483);

return statearr_38488;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_38486__$1,inst_38484);
} else {
return null;
}
}
});})(c__38109__auto___38663,res,vec__38481,v,p,job,jobs,results))
;
return ((function (switch__37995__auto__,c__38109__auto___38663,res,vec__38481,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0 = (function (){
var statearr_38492 = [null,null,null,null,null,null,null,null];
(statearr_38492[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__);

(statearr_38492[(1)] = (1));

return statearr_38492;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1 = (function (state_38486){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38486);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38493){if((e38493 instanceof Object)){
var ex__37999__auto__ = e38493;
var statearr_38494_38664 = state_38486;
(statearr_38494_38664[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38486);

return cljs.core.cst$kw$recur;
} else {
throw e38493;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38665 = state_38486;
state_38486 = G__38665;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = function(state_38486){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1.call(this,state_38486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___38663,res,vec__38481,v,p,job,jobs,results))
})();
var state__38111__auto__ = (function (){var statearr_38495 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38495[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___38663);

return statearr_38495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___38663,res,vec__38481,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__38496){
var vec__38497 = p__38496;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38497,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38497,(1),null);
var job = vec__38497;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});})(jobs,results,process))
;
var n__7056__auto___38666 = n;
var __38667 = (0);
while(true){
if((__38667 < n__7056__auto___38666)){
var G__38498_38668 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__38498_38668) {
case "compute":
var c__38109__auto___38670 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__38667,c__38109__auto___38670,G__38498_38668,n__7056__auto___38666,jobs,results,process,async){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (__38667,c__38109__auto___38670,G__38498_38668,n__7056__auto___38666,jobs,results,process,async){
return (function (state_38511){
var state_val_38512 = (state_38511[(1)]);
if((state_val_38512 === (1))){
var state_38511__$1 = state_38511;
var statearr_38513_38671 = state_38511__$1;
(statearr_38513_38671[(2)] = null);

(statearr_38513_38671[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38512 === (2))){
var state_38511__$1 = state_38511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38511__$1,(4),jobs);
} else {
if((state_val_38512 === (3))){
var inst_38509 = (state_38511[(2)]);
var state_38511__$1 = state_38511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38511__$1,inst_38509);
} else {
if((state_val_38512 === (4))){
var inst_38501 = (state_38511[(2)]);
var inst_38502 = process(inst_38501);
var state_38511__$1 = state_38511;
if(cljs.core.truth_(inst_38502)){
var statearr_38514_38672 = state_38511__$1;
(statearr_38514_38672[(1)] = (5));

} else {
var statearr_38515_38673 = state_38511__$1;
(statearr_38515_38673[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38512 === (5))){
var state_38511__$1 = state_38511;
var statearr_38516_38674 = state_38511__$1;
(statearr_38516_38674[(2)] = null);

(statearr_38516_38674[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38512 === (6))){
var state_38511__$1 = state_38511;
var statearr_38517_38675 = state_38511__$1;
(statearr_38517_38675[(2)] = null);

(statearr_38517_38675[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38512 === (7))){
var inst_38507 = (state_38511[(2)]);
var state_38511__$1 = state_38511;
var statearr_38518_38676 = state_38511__$1;
(statearr_38518_38676[(2)] = inst_38507);

(statearr_38518_38676[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__38667,c__38109__auto___38670,G__38498_38668,n__7056__auto___38666,jobs,results,process,async))
;
return ((function (__38667,switch__37995__auto__,c__38109__auto___38670,G__38498_38668,n__7056__auto___38666,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0 = (function (){
var statearr_38522 = [null,null,null,null,null,null,null];
(statearr_38522[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__);

(statearr_38522[(1)] = (1));

return statearr_38522;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1 = (function (state_38511){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38511);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38523){if((e38523 instanceof Object)){
var ex__37999__auto__ = e38523;
var statearr_38524_38677 = state_38511;
(statearr_38524_38677[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38511);

return cljs.core.cst$kw$recur;
} else {
throw e38523;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38678 = state_38511;
state_38511 = G__38678;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = function(state_38511){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1.call(this,state_38511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__;
})()
;})(__38667,switch__37995__auto__,c__38109__auto___38670,G__38498_38668,n__7056__auto___38666,jobs,results,process,async))
})();
var state__38111__auto__ = (function (){var statearr_38525 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38525[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___38670);

return statearr_38525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(__38667,c__38109__auto___38670,G__38498_38668,n__7056__auto___38666,jobs,results,process,async))
);


break;
case "async":
var c__38109__auto___38679 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__38667,c__38109__auto___38679,G__38498_38668,n__7056__auto___38666,jobs,results,process,async){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (__38667,c__38109__auto___38679,G__38498_38668,n__7056__auto___38666,jobs,results,process,async){
return (function (state_38538){
var state_val_38539 = (state_38538[(1)]);
if((state_val_38539 === (1))){
var state_38538__$1 = state_38538;
var statearr_38540_38680 = state_38538__$1;
(statearr_38540_38680[(2)] = null);

(statearr_38540_38680[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38539 === (2))){
var state_38538__$1 = state_38538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38538__$1,(4),jobs);
} else {
if((state_val_38539 === (3))){
var inst_38536 = (state_38538[(2)]);
var state_38538__$1 = state_38538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38538__$1,inst_38536);
} else {
if((state_val_38539 === (4))){
var inst_38528 = (state_38538[(2)]);
var inst_38529 = async(inst_38528);
var state_38538__$1 = state_38538;
if(cljs.core.truth_(inst_38529)){
var statearr_38541_38681 = state_38538__$1;
(statearr_38541_38681[(1)] = (5));

} else {
var statearr_38542_38682 = state_38538__$1;
(statearr_38542_38682[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38539 === (5))){
var state_38538__$1 = state_38538;
var statearr_38543_38683 = state_38538__$1;
(statearr_38543_38683[(2)] = null);

(statearr_38543_38683[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38539 === (6))){
var state_38538__$1 = state_38538;
var statearr_38544_38684 = state_38538__$1;
(statearr_38544_38684[(2)] = null);

(statearr_38544_38684[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38539 === (7))){
var inst_38534 = (state_38538[(2)]);
var state_38538__$1 = state_38538;
var statearr_38545_38685 = state_38538__$1;
(statearr_38545_38685[(2)] = inst_38534);

(statearr_38545_38685[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__38667,c__38109__auto___38679,G__38498_38668,n__7056__auto___38666,jobs,results,process,async))
;
return ((function (__38667,switch__37995__auto__,c__38109__auto___38679,G__38498_38668,n__7056__auto___38666,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0 = (function (){
var statearr_38549 = [null,null,null,null,null,null,null];
(statearr_38549[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__);

(statearr_38549[(1)] = (1));

return statearr_38549;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1 = (function (state_38538){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38538);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38550){if((e38550 instanceof Object)){
var ex__37999__auto__ = e38550;
var statearr_38551_38686 = state_38538;
(statearr_38551_38686[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38538);

return cljs.core.cst$kw$recur;
} else {
throw e38550;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38687 = state_38538;
state_38538 = G__38687;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = function(state_38538){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1.call(this,state_38538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__;
})()
;})(__38667,switch__37995__auto__,c__38109__auto___38679,G__38498_38668,n__7056__auto___38666,jobs,results,process,async))
})();
var state__38111__auto__ = (function (){var statearr_38552 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38552[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___38679);

return statearr_38552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(__38667,c__38109__auto___38679,G__38498_38668,n__7056__auto___38666,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__38688 = (__38667 + (1));
__38667 = G__38688;
continue;
} else {
}
break;
}

var c__38109__auto___38689 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___38689,jobs,results,process,async){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___38689,jobs,results,process,async){
return (function (state_38574){
var state_val_38575 = (state_38574[(1)]);
if((state_val_38575 === (1))){
var state_38574__$1 = state_38574;
var statearr_38576_38690 = state_38574__$1;
(statearr_38576_38690[(2)] = null);

(statearr_38576_38690[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (2))){
var state_38574__$1 = state_38574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38574__$1,(4),from);
} else {
if((state_val_38575 === (3))){
var inst_38572 = (state_38574[(2)]);
var state_38574__$1 = state_38574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38574__$1,inst_38572);
} else {
if((state_val_38575 === (4))){
var inst_38555 = (state_38574[(7)]);
var inst_38555__$1 = (state_38574[(2)]);
var inst_38556 = (inst_38555__$1 == null);
var state_38574__$1 = (function (){var statearr_38577 = state_38574;
(statearr_38577[(7)] = inst_38555__$1);

return statearr_38577;
})();
if(cljs.core.truth_(inst_38556)){
var statearr_38578_38691 = state_38574__$1;
(statearr_38578_38691[(1)] = (5));

} else {
var statearr_38579_38692 = state_38574__$1;
(statearr_38579_38692[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (5))){
var inst_38558 = cljs.core.async.close_BANG_(jobs);
var state_38574__$1 = state_38574;
var statearr_38580_38693 = state_38574__$1;
(statearr_38580_38693[(2)] = inst_38558);

(statearr_38580_38693[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (6))){
var inst_38560 = (state_38574[(8)]);
var inst_38555 = (state_38574[(7)]);
var inst_38560__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_38561 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38562 = [inst_38555,inst_38560__$1];
var inst_38563 = (new cljs.core.PersistentVector(null,2,(5),inst_38561,inst_38562,null));
var state_38574__$1 = (function (){var statearr_38581 = state_38574;
(statearr_38581[(8)] = inst_38560__$1);

return statearr_38581;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38574__$1,(8),jobs,inst_38563);
} else {
if((state_val_38575 === (7))){
var inst_38570 = (state_38574[(2)]);
var state_38574__$1 = state_38574;
var statearr_38582_38694 = state_38574__$1;
(statearr_38582_38694[(2)] = inst_38570);

(statearr_38582_38694[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38575 === (8))){
var inst_38560 = (state_38574[(8)]);
var inst_38565 = (state_38574[(2)]);
var state_38574__$1 = (function (){var statearr_38583 = state_38574;
(statearr_38583[(9)] = inst_38565);

return statearr_38583;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38574__$1,(9),results,inst_38560);
} else {
if((state_val_38575 === (9))){
var inst_38567 = (state_38574[(2)]);
var state_38574__$1 = (function (){var statearr_38584 = state_38574;
(statearr_38584[(10)] = inst_38567);

return statearr_38584;
})();
var statearr_38585_38695 = state_38574__$1;
(statearr_38585_38695[(2)] = null);

(statearr_38585_38695[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___38689,jobs,results,process,async))
;
return ((function (switch__37995__auto__,c__38109__auto___38689,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0 = (function (){
var statearr_38589 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_38589[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__);

(statearr_38589[(1)] = (1));

return statearr_38589;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1 = (function (state_38574){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38574);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38590){if((e38590 instanceof Object)){
var ex__37999__auto__ = e38590;
var statearr_38591_38696 = state_38574;
(statearr_38591_38696[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38574);

return cljs.core.cst$kw$recur;
} else {
throw e38590;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38697 = state_38574;
state_38574 = G__38697;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = function(state_38574){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1.call(this,state_38574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___38689,jobs,results,process,async))
})();
var state__38111__auto__ = (function (){var statearr_38592 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38592[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___38689);

return statearr_38592;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___38689,jobs,results,process,async))
);


var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__,jobs,results,process,async){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__,jobs,results,process,async){
return (function (state_38630){
var state_val_38631 = (state_38630[(1)]);
if((state_val_38631 === (7))){
var inst_38626 = (state_38630[(2)]);
var state_38630__$1 = state_38630;
var statearr_38632_38698 = state_38630__$1;
(statearr_38632_38698[(2)] = inst_38626);

(statearr_38632_38698[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (20))){
var state_38630__$1 = state_38630;
var statearr_38633_38699 = state_38630__$1;
(statearr_38633_38699[(2)] = null);

(statearr_38633_38699[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (1))){
var state_38630__$1 = state_38630;
var statearr_38634_38700 = state_38630__$1;
(statearr_38634_38700[(2)] = null);

(statearr_38634_38700[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (4))){
var inst_38595 = (state_38630[(7)]);
var inst_38595__$1 = (state_38630[(2)]);
var inst_38596 = (inst_38595__$1 == null);
var state_38630__$1 = (function (){var statearr_38635 = state_38630;
(statearr_38635[(7)] = inst_38595__$1);

return statearr_38635;
})();
if(cljs.core.truth_(inst_38596)){
var statearr_38636_38701 = state_38630__$1;
(statearr_38636_38701[(1)] = (5));

} else {
var statearr_38637_38702 = state_38630__$1;
(statearr_38637_38702[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (15))){
var inst_38608 = (state_38630[(8)]);
var state_38630__$1 = state_38630;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38630__$1,(18),to,inst_38608);
} else {
if((state_val_38631 === (21))){
var inst_38621 = (state_38630[(2)]);
var state_38630__$1 = state_38630;
var statearr_38638_38703 = state_38630__$1;
(statearr_38638_38703[(2)] = inst_38621);

(statearr_38638_38703[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (13))){
var inst_38623 = (state_38630[(2)]);
var state_38630__$1 = (function (){var statearr_38639 = state_38630;
(statearr_38639[(9)] = inst_38623);

return statearr_38639;
})();
var statearr_38640_38704 = state_38630__$1;
(statearr_38640_38704[(2)] = null);

(statearr_38640_38704[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (6))){
var inst_38595 = (state_38630[(7)]);
var state_38630__$1 = state_38630;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38630__$1,(11),inst_38595);
} else {
if((state_val_38631 === (17))){
var inst_38616 = (state_38630[(2)]);
var state_38630__$1 = state_38630;
if(cljs.core.truth_(inst_38616)){
var statearr_38641_38705 = state_38630__$1;
(statearr_38641_38705[(1)] = (19));

} else {
var statearr_38642_38706 = state_38630__$1;
(statearr_38642_38706[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (3))){
var inst_38628 = (state_38630[(2)]);
var state_38630__$1 = state_38630;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38630__$1,inst_38628);
} else {
if((state_val_38631 === (12))){
var inst_38605 = (state_38630[(10)]);
var state_38630__$1 = state_38630;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38630__$1,(14),inst_38605);
} else {
if((state_val_38631 === (2))){
var state_38630__$1 = state_38630;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38630__$1,(4),results);
} else {
if((state_val_38631 === (19))){
var state_38630__$1 = state_38630;
var statearr_38643_38707 = state_38630__$1;
(statearr_38643_38707[(2)] = null);

(statearr_38643_38707[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (11))){
var inst_38605 = (state_38630[(2)]);
var state_38630__$1 = (function (){var statearr_38644 = state_38630;
(statearr_38644[(10)] = inst_38605);

return statearr_38644;
})();
var statearr_38645_38708 = state_38630__$1;
(statearr_38645_38708[(2)] = null);

(statearr_38645_38708[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (9))){
var state_38630__$1 = state_38630;
var statearr_38646_38709 = state_38630__$1;
(statearr_38646_38709[(2)] = null);

(statearr_38646_38709[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (5))){
var state_38630__$1 = state_38630;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38647_38710 = state_38630__$1;
(statearr_38647_38710[(1)] = (8));

} else {
var statearr_38648_38711 = state_38630__$1;
(statearr_38648_38711[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (14))){
var inst_38608 = (state_38630[(8)]);
var inst_38610 = (state_38630[(11)]);
var inst_38608__$1 = (state_38630[(2)]);
var inst_38609 = (inst_38608__$1 == null);
var inst_38610__$1 = cljs.core.not(inst_38609);
var state_38630__$1 = (function (){var statearr_38649 = state_38630;
(statearr_38649[(8)] = inst_38608__$1);

(statearr_38649[(11)] = inst_38610__$1);

return statearr_38649;
})();
if(inst_38610__$1){
var statearr_38650_38712 = state_38630__$1;
(statearr_38650_38712[(1)] = (15));

} else {
var statearr_38651_38713 = state_38630__$1;
(statearr_38651_38713[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (16))){
var inst_38610 = (state_38630[(11)]);
var state_38630__$1 = state_38630;
var statearr_38652_38714 = state_38630__$1;
(statearr_38652_38714[(2)] = inst_38610);

(statearr_38652_38714[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (10))){
var inst_38602 = (state_38630[(2)]);
var state_38630__$1 = state_38630;
var statearr_38653_38715 = state_38630__$1;
(statearr_38653_38715[(2)] = inst_38602);

(statearr_38653_38715[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (18))){
var inst_38613 = (state_38630[(2)]);
var state_38630__$1 = state_38630;
var statearr_38654_38716 = state_38630__$1;
(statearr_38654_38716[(2)] = inst_38613);

(statearr_38654_38716[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38631 === (8))){
var inst_38599 = cljs.core.async.close_BANG_(to);
var state_38630__$1 = state_38630;
var statearr_38655_38717 = state_38630__$1;
(statearr_38655_38717[(2)] = inst_38599);

(statearr_38655_38717[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto__,jobs,results,process,async))
;
return ((function (switch__37995__auto__,c__38109__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0 = (function (){
var statearr_38659 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38659[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__);

(statearr_38659[(1)] = (1));

return statearr_38659;
});
var cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1 = (function (state_38630){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38630);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38660){if((e38660 instanceof Object)){
var ex__37999__auto__ = e38660;
var statearr_38661_38718 = state_38630;
(statearr_38661_38718[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38630);

return cljs.core.cst$kw$recur;
} else {
throw e38660;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38719 = state_38630;
state_38630 = G__38719;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__ = function(state_38630){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1.call(this,state_38630);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__37996__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__,jobs,results,process,async))
})();
var state__38111__auto__ = (function (){var statearr_38662 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38662[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_38662;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__,jobs,results,process,async))
);

return c__38109__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args38720 = [];
var len__7211__auto___38723 = arguments.length;
var i__7212__auto___38724 = (0);
while(true){
if((i__7212__auto___38724 < len__7211__auto___38723)){
args38720.push((arguments[i__7212__auto___38724]));

var G__38725 = (i__7212__auto___38724 + (1));
i__7212__auto___38724 = G__38725;
continue;
} else {
}
break;
}

var G__38722 = args38720.length;
switch (G__38722) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38720.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args38727 = [];
var len__7211__auto___38730 = arguments.length;
var i__7212__auto___38731 = (0);
while(true){
if((i__7212__auto___38731 < len__7211__auto___38730)){
args38727.push((arguments[i__7212__auto___38731]));

var G__38732 = (i__7212__auto___38731 + (1));
i__7212__auto___38731 = G__38732;
continue;
} else {
}
break;
}

var G__38729 = args38727.length;
switch (G__38729) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38727.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;
/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args38734 = [];
var len__7211__auto___38787 = arguments.length;
var i__7212__auto___38788 = (0);
while(true){
if((i__7212__auto___38788 < len__7211__auto___38787)){
args38734.push((arguments[i__7212__auto___38788]));

var G__38789 = (i__7212__auto___38788 + (1));
i__7212__auto___38788 = G__38789;
continue;
} else {
}
break;
}

var G__38736 = args38734.length;
switch (G__38736) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38734.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__38109__auto___38791 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___38791,tc,fc){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___38791,tc,fc){
return (function (state_38762){
var state_val_38763 = (state_38762[(1)]);
if((state_val_38763 === (7))){
var inst_38758 = (state_38762[(2)]);
var state_38762__$1 = state_38762;
var statearr_38764_38792 = state_38762__$1;
(statearr_38764_38792[(2)] = inst_38758);

(statearr_38764_38792[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (1))){
var state_38762__$1 = state_38762;
var statearr_38765_38793 = state_38762__$1;
(statearr_38765_38793[(2)] = null);

(statearr_38765_38793[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (4))){
var inst_38739 = (state_38762[(7)]);
var inst_38739__$1 = (state_38762[(2)]);
var inst_38740 = (inst_38739__$1 == null);
var state_38762__$1 = (function (){var statearr_38766 = state_38762;
(statearr_38766[(7)] = inst_38739__$1);

return statearr_38766;
})();
if(cljs.core.truth_(inst_38740)){
var statearr_38767_38794 = state_38762__$1;
(statearr_38767_38794[(1)] = (5));

} else {
var statearr_38768_38795 = state_38762__$1;
(statearr_38768_38795[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (13))){
var state_38762__$1 = state_38762;
var statearr_38769_38796 = state_38762__$1;
(statearr_38769_38796[(2)] = null);

(statearr_38769_38796[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (6))){
var inst_38739 = (state_38762[(7)]);
var inst_38745 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_38739) : p.call(null,inst_38739));
var state_38762__$1 = state_38762;
if(cljs.core.truth_(inst_38745)){
var statearr_38770_38797 = state_38762__$1;
(statearr_38770_38797[(1)] = (9));

} else {
var statearr_38771_38798 = state_38762__$1;
(statearr_38771_38798[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (3))){
var inst_38760 = (state_38762[(2)]);
var state_38762__$1 = state_38762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38762__$1,inst_38760);
} else {
if((state_val_38763 === (12))){
var state_38762__$1 = state_38762;
var statearr_38772_38799 = state_38762__$1;
(statearr_38772_38799[(2)] = null);

(statearr_38772_38799[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (2))){
var state_38762__$1 = state_38762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38762__$1,(4),ch);
} else {
if((state_val_38763 === (11))){
var inst_38739 = (state_38762[(7)]);
var inst_38749 = (state_38762[(2)]);
var state_38762__$1 = state_38762;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38762__$1,(8),inst_38749,inst_38739);
} else {
if((state_val_38763 === (9))){
var state_38762__$1 = state_38762;
var statearr_38773_38800 = state_38762__$1;
(statearr_38773_38800[(2)] = tc);

(statearr_38773_38800[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (5))){
var inst_38742 = cljs.core.async.close_BANG_(tc);
var inst_38743 = cljs.core.async.close_BANG_(fc);
var state_38762__$1 = (function (){var statearr_38774 = state_38762;
(statearr_38774[(8)] = inst_38742);

return statearr_38774;
})();
var statearr_38775_38801 = state_38762__$1;
(statearr_38775_38801[(2)] = inst_38743);

(statearr_38775_38801[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (14))){
var inst_38756 = (state_38762[(2)]);
var state_38762__$1 = state_38762;
var statearr_38776_38802 = state_38762__$1;
(statearr_38776_38802[(2)] = inst_38756);

(statearr_38776_38802[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (10))){
var state_38762__$1 = state_38762;
var statearr_38777_38803 = state_38762__$1;
(statearr_38777_38803[(2)] = fc);

(statearr_38777_38803[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38763 === (8))){
var inst_38751 = (state_38762[(2)]);
var state_38762__$1 = state_38762;
if(cljs.core.truth_(inst_38751)){
var statearr_38778_38804 = state_38762__$1;
(statearr_38778_38804[(1)] = (12));

} else {
var statearr_38779_38805 = state_38762__$1;
(statearr_38779_38805[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___38791,tc,fc))
;
return ((function (switch__37995__auto__,c__38109__auto___38791,tc,fc){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_38783 = [null,null,null,null,null,null,null,null,null];
(statearr_38783[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_38783[(1)] = (1));

return statearr_38783;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_38762){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38762);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38784){if((e38784 instanceof Object)){
var ex__37999__auto__ = e38784;
var statearr_38785_38806 = state_38762;
(statearr_38785_38806[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38762);

return cljs.core.cst$kw$recur;
} else {
throw e38784;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38807 = state_38762;
state_38762 = G__38807;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_38762){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_38762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___38791,tc,fc))
})();
var state__38111__auto__ = (function (){var statearr_38786 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38786[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___38791);

return statearr_38786;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___38791,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;
/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__){
return (function (state_38871){
var state_val_38872 = (state_38871[(1)]);
if((state_val_38872 === (7))){
var inst_38867 = (state_38871[(2)]);
var state_38871__$1 = state_38871;
var statearr_38873_38894 = state_38871__$1;
(statearr_38873_38894[(2)] = inst_38867);

(statearr_38873_38894[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38872 === (1))){
var inst_38851 = init;
var state_38871__$1 = (function (){var statearr_38874 = state_38871;
(statearr_38874[(7)] = inst_38851);

return statearr_38874;
})();
var statearr_38875_38895 = state_38871__$1;
(statearr_38875_38895[(2)] = null);

(statearr_38875_38895[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38872 === (4))){
var inst_38854 = (state_38871[(8)]);
var inst_38854__$1 = (state_38871[(2)]);
var inst_38855 = (inst_38854__$1 == null);
var state_38871__$1 = (function (){var statearr_38876 = state_38871;
(statearr_38876[(8)] = inst_38854__$1);

return statearr_38876;
})();
if(cljs.core.truth_(inst_38855)){
var statearr_38877_38896 = state_38871__$1;
(statearr_38877_38896[(1)] = (5));

} else {
var statearr_38878_38897 = state_38871__$1;
(statearr_38878_38897[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38872 === (6))){
var inst_38851 = (state_38871[(7)]);
var inst_38854 = (state_38871[(8)]);
var inst_38858 = (state_38871[(9)]);
var inst_38858__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_38851,inst_38854) : f.call(null,inst_38851,inst_38854));
var inst_38859 = cljs.core.reduced_QMARK_(inst_38858__$1);
var state_38871__$1 = (function (){var statearr_38879 = state_38871;
(statearr_38879[(9)] = inst_38858__$1);

return statearr_38879;
})();
if(inst_38859){
var statearr_38880_38898 = state_38871__$1;
(statearr_38880_38898[(1)] = (8));

} else {
var statearr_38881_38899 = state_38871__$1;
(statearr_38881_38899[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38872 === (3))){
var inst_38869 = (state_38871[(2)]);
var state_38871__$1 = state_38871;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38871__$1,inst_38869);
} else {
if((state_val_38872 === (2))){
var state_38871__$1 = state_38871;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38871__$1,(4),ch);
} else {
if((state_val_38872 === (9))){
var inst_38858 = (state_38871[(9)]);
var inst_38851 = inst_38858;
var state_38871__$1 = (function (){var statearr_38882 = state_38871;
(statearr_38882[(7)] = inst_38851);

return statearr_38882;
})();
var statearr_38883_38900 = state_38871__$1;
(statearr_38883_38900[(2)] = null);

(statearr_38883_38900[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38872 === (5))){
var inst_38851 = (state_38871[(7)]);
var state_38871__$1 = state_38871;
var statearr_38884_38901 = state_38871__$1;
(statearr_38884_38901[(2)] = inst_38851);

(statearr_38884_38901[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38872 === (10))){
var inst_38865 = (state_38871[(2)]);
var state_38871__$1 = state_38871;
var statearr_38885_38902 = state_38871__$1;
(statearr_38885_38902[(2)] = inst_38865);

(statearr_38885_38902[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38872 === (8))){
var inst_38858 = (state_38871[(9)]);
var inst_38861 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(inst_38858) : cljs.core.deref.call(null,inst_38858));
var state_38871__$1 = state_38871;
var statearr_38886_38903 = state_38871__$1;
(statearr_38886_38903[(2)] = inst_38861);

(statearr_38886_38903[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto__))
;
return ((function (switch__37995__auto__,c__38109__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__37996__auto__ = null;
var cljs$core$async$reduce_$_state_machine__37996__auto____0 = (function (){
var statearr_38890 = [null,null,null,null,null,null,null,null,null,null];
(statearr_38890[(0)] = cljs$core$async$reduce_$_state_machine__37996__auto__);

(statearr_38890[(1)] = (1));

return statearr_38890;
});
var cljs$core$async$reduce_$_state_machine__37996__auto____1 = (function (state_38871){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38871);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38891){if((e38891 instanceof Object)){
var ex__37999__auto__ = e38891;
var statearr_38892_38904 = state_38871;
(statearr_38892_38904[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38871);

return cljs.core.cst$kw$recur;
} else {
throw e38891;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38905 = state_38871;
state_38871 = G__38905;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__37996__auto__ = function(state_38871){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__37996__auto____1.call(this,state_38871);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__37996__auto____0;
cljs$core$async$reduce_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__37996__auto____1;
return cljs$core$async$reduce_$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__))
})();
var state__38111__auto__ = (function (){var statearr_38893 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38893[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_38893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__))
);

return c__38109__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args38906 = [];
var len__7211__auto___38958 = arguments.length;
var i__7212__auto___38959 = (0);
while(true){
if((i__7212__auto___38959 < len__7211__auto___38958)){
args38906.push((arguments[i__7212__auto___38959]));

var G__38960 = (i__7212__auto___38959 + (1));
i__7212__auto___38959 = G__38960;
continue;
} else {
}
break;
}

var G__38908 = args38906.length;
switch (G__38908) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args38906.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__){
return (function (state_38933){
var state_val_38934 = (state_38933[(1)]);
if((state_val_38934 === (7))){
var inst_38915 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
var statearr_38935_38962 = state_38933__$1;
(statearr_38935_38962[(2)] = inst_38915);

(statearr_38935_38962[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (1))){
var inst_38909 = cljs.core.seq(coll);
var inst_38910 = inst_38909;
var state_38933__$1 = (function (){var statearr_38936 = state_38933;
(statearr_38936[(7)] = inst_38910);

return statearr_38936;
})();
var statearr_38937_38963 = state_38933__$1;
(statearr_38937_38963[(2)] = null);

(statearr_38937_38963[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (4))){
var inst_38910 = (state_38933[(7)]);
var inst_38913 = cljs.core.first(inst_38910);
var state_38933__$1 = state_38933;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_38933__$1,(7),ch,inst_38913);
} else {
if((state_val_38934 === (13))){
var inst_38927 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
var statearr_38938_38964 = state_38933__$1;
(statearr_38938_38964[(2)] = inst_38927);

(statearr_38938_38964[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (6))){
var inst_38918 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
if(cljs.core.truth_(inst_38918)){
var statearr_38939_38965 = state_38933__$1;
(statearr_38939_38965[(1)] = (8));

} else {
var statearr_38940_38966 = state_38933__$1;
(statearr_38940_38966[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (3))){
var inst_38931 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38933__$1,inst_38931);
} else {
if((state_val_38934 === (12))){
var state_38933__$1 = state_38933;
var statearr_38941_38967 = state_38933__$1;
(statearr_38941_38967[(2)] = null);

(statearr_38941_38967[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (2))){
var inst_38910 = (state_38933[(7)]);
var state_38933__$1 = state_38933;
if(cljs.core.truth_(inst_38910)){
var statearr_38942_38968 = state_38933__$1;
(statearr_38942_38968[(1)] = (4));

} else {
var statearr_38943_38969 = state_38933__$1;
(statearr_38943_38969[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (11))){
var inst_38924 = cljs.core.async.close_BANG_(ch);
var state_38933__$1 = state_38933;
var statearr_38944_38970 = state_38933__$1;
(statearr_38944_38970[(2)] = inst_38924);

(statearr_38944_38970[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (9))){
var state_38933__$1 = state_38933;
if(cljs.core.truth_(close_QMARK_)){
var statearr_38945_38971 = state_38933__$1;
(statearr_38945_38971[(1)] = (11));

} else {
var statearr_38946_38972 = state_38933__$1;
(statearr_38946_38972[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (5))){
var inst_38910 = (state_38933[(7)]);
var state_38933__$1 = state_38933;
var statearr_38947_38973 = state_38933__$1;
(statearr_38947_38973[(2)] = inst_38910);

(statearr_38947_38973[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (10))){
var inst_38929 = (state_38933[(2)]);
var state_38933__$1 = state_38933;
var statearr_38948_38974 = state_38933__$1;
(statearr_38948_38974[(2)] = inst_38929);

(statearr_38948_38974[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38934 === (8))){
var inst_38910 = (state_38933[(7)]);
var inst_38920 = cljs.core.next(inst_38910);
var inst_38910__$1 = inst_38920;
var state_38933__$1 = (function (){var statearr_38949 = state_38933;
(statearr_38949[(7)] = inst_38910__$1);

return statearr_38949;
})();
var statearr_38950_38975 = state_38933__$1;
(statearr_38950_38975[(2)] = null);

(statearr_38950_38975[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto__))
;
return ((function (switch__37995__auto__,c__38109__auto__){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_38954 = [null,null,null,null,null,null,null,null];
(statearr_38954[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_38954[(1)] = (1));

return statearr_38954;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_38933){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_38933);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e38955){if((e38955 instanceof Object)){
var ex__37999__auto__ = e38955;
var statearr_38956_38976 = state_38933;
(statearr_38956_38976[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_38933);

return cljs.core.cst$kw$recur;
} else {
throw e38955;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__38977 = state_38933;
state_38933 = G__38977;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_38933){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_38933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__))
})();
var state__38111__auto__ = (function (){var statearr_38957 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_38957[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_38957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__))
);

return c__38109__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;
/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__6808__auto__ = (((_ == null))?null:_);
var m__6809__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__6809__auto__.call(null,_));
} else {
var m__6809__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(_) : m__6809__auto____$1.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6809__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__6809__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__6809__auto____$1.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto__.call(null,m,ch));
} else {
var m__6809__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6809__auto__.call(null,m));
} else {
var m__6809__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6809__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = (function (){var G__39202 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__39202) : cljs.core.atom.call(null,G__39202));
})();
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async39203 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39203 = (function (mult,ch,cs,meta39204){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta39204 = meta39204;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async39203.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_39205,meta39204__$1){
var self__ = this;
var _39205__$1 = this;
return (new cljs.core.async.t_cljs$core$async39203(self__.mult,self__.ch,self__.cs,meta39204__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async39203.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_39205){
var self__ = this;
var _39205__$1 = this;
return self__.meta39204;
});})(cs))
;

cljs.core.async.t_cljs$core$async39203.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async39203.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async39203.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async39203.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39203.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39203.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__39206_39426 = self__.cs;
var G__39207_39427 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__39206_39426,G__39207_39427) : cljs.core.reset_BANG_.call(null,G__39206_39426,G__39207_39427));

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async39203.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$mult,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta39204], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async39203.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39203.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39203";

cljs.core.async.t_cljs$core$async39203.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async39203");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async39203 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async39203(mult__$1,ch__$1,cs__$1,meta39204){
return (new cljs.core.async.t_cljs$core$async39203(mult__$1,ch__$1,cs__$1,meta39204));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async39203(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__38109__auto___39428 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___39428,cs,m,dchan,dctr,done){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___39428,cs,m,dchan,dctr,done){
return (function (state_39338){
var state_val_39339 = (state_39338[(1)]);
if((state_val_39339 === (7))){
var inst_39334 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39340_39429 = state_39338__$1;
(statearr_39340_39429[(2)] = inst_39334);

(statearr_39340_39429[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (20))){
var inst_39239 = (state_39338[(7)]);
var inst_39249 = cljs.core.first(inst_39239);
var inst_39250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39249,(0),null);
var inst_39251 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39249,(1),null);
var state_39338__$1 = (function (){var statearr_39341 = state_39338;
(statearr_39341[(8)] = inst_39250);

return statearr_39341;
})();
if(cljs.core.truth_(inst_39251)){
var statearr_39342_39430 = state_39338__$1;
(statearr_39342_39430[(1)] = (22));

} else {
var statearr_39343_39431 = state_39338__$1;
(statearr_39343_39431[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (27))){
var inst_39281 = (state_39338[(9)]);
var inst_39286 = (state_39338[(10)]);
var inst_39279 = (state_39338[(11)]);
var inst_39210 = (state_39338[(12)]);
var inst_39286__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_39279,inst_39281);
var inst_39287 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_39286__$1,inst_39210,done);
var state_39338__$1 = (function (){var statearr_39344 = state_39338;
(statearr_39344[(10)] = inst_39286__$1);

return statearr_39344;
})();
if(cljs.core.truth_(inst_39287)){
var statearr_39345_39432 = state_39338__$1;
(statearr_39345_39432[(1)] = (30));

} else {
var statearr_39346_39433 = state_39338__$1;
(statearr_39346_39433[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (1))){
var state_39338__$1 = state_39338;
var statearr_39347_39434 = state_39338__$1;
(statearr_39347_39434[(2)] = null);

(statearr_39347_39434[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (24))){
var inst_39239 = (state_39338[(7)]);
var inst_39256 = (state_39338[(2)]);
var inst_39257 = cljs.core.next(inst_39239);
var inst_39219 = inst_39257;
var inst_39220 = null;
var inst_39221 = (0);
var inst_39222 = (0);
var state_39338__$1 = (function (){var statearr_39348 = state_39338;
(statearr_39348[(13)] = inst_39221);

(statearr_39348[(14)] = inst_39256);

(statearr_39348[(15)] = inst_39220);

(statearr_39348[(16)] = inst_39219);

(statearr_39348[(17)] = inst_39222);

return statearr_39348;
})();
var statearr_39349_39435 = state_39338__$1;
(statearr_39349_39435[(2)] = null);

(statearr_39349_39435[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (39))){
var state_39338__$1 = state_39338;
var statearr_39353_39436 = state_39338__$1;
(statearr_39353_39436[(2)] = null);

(statearr_39353_39436[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (4))){
var inst_39210 = (state_39338[(12)]);
var inst_39210__$1 = (state_39338[(2)]);
var inst_39211 = (inst_39210__$1 == null);
var state_39338__$1 = (function (){var statearr_39354 = state_39338;
(statearr_39354[(12)] = inst_39210__$1);

return statearr_39354;
})();
if(cljs.core.truth_(inst_39211)){
var statearr_39355_39437 = state_39338__$1;
(statearr_39355_39437[(1)] = (5));

} else {
var statearr_39356_39438 = state_39338__$1;
(statearr_39356_39438[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (15))){
var inst_39221 = (state_39338[(13)]);
var inst_39220 = (state_39338[(15)]);
var inst_39219 = (state_39338[(16)]);
var inst_39222 = (state_39338[(17)]);
var inst_39235 = (state_39338[(2)]);
var inst_39236 = (inst_39222 + (1));
var tmp39350 = inst_39221;
var tmp39351 = inst_39220;
var tmp39352 = inst_39219;
var inst_39219__$1 = tmp39352;
var inst_39220__$1 = tmp39351;
var inst_39221__$1 = tmp39350;
var inst_39222__$1 = inst_39236;
var state_39338__$1 = (function (){var statearr_39357 = state_39338;
(statearr_39357[(13)] = inst_39221__$1);

(statearr_39357[(15)] = inst_39220__$1);

(statearr_39357[(16)] = inst_39219__$1);

(statearr_39357[(17)] = inst_39222__$1);

(statearr_39357[(18)] = inst_39235);

return statearr_39357;
})();
var statearr_39358_39439 = state_39338__$1;
(statearr_39358_39439[(2)] = null);

(statearr_39358_39439[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (21))){
var inst_39260 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39362_39440 = state_39338__$1;
(statearr_39362_39440[(2)] = inst_39260);

(statearr_39362_39440[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (31))){
var inst_39286 = (state_39338[(10)]);
var inst_39290 = done(null);
var inst_39291 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_39286);
var state_39338__$1 = (function (){var statearr_39363 = state_39338;
(statearr_39363[(19)] = inst_39290);

return statearr_39363;
})();
var statearr_39364_39441 = state_39338__$1;
(statearr_39364_39441[(2)] = inst_39291);

(statearr_39364_39441[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (32))){
var inst_39281 = (state_39338[(9)]);
var inst_39280 = (state_39338[(20)]);
var inst_39278 = (state_39338[(21)]);
var inst_39279 = (state_39338[(11)]);
var inst_39293 = (state_39338[(2)]);
var inst_39294 = (inst_39281 + (1));
var tmp39359 = inst_39280;
var tmp39360 = inst_39278;
var tmp39361 = inst_39279;
var inst_39278__$1 = tmp39360;
var inst_39279__$1 = tmp39361;
var inst_39280__$1 = tmp39359;
var inst_39281__$1 = inst_39294;
var state_39338__$1 = (function (){var statearr_39365 = state_39338;
(statearr_39365[(9)] = inst_39281__$1);

(statearr_39365[(20)] = inst_39280__$1);

(statearr_39365[(21)] = inst_39278__$1);

(statearr_39365[(11)] = inst_39279__$1);

(statearr_39365[(22)] = inst_39293);

return statearr_39365;
})();
var statearr_39366_39442 = state_39338__$1;
(statearr_39366_39442[(2)] = null);

(statearr_39366_39442[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (40))){
var inst_39306 = (state_39338[(23)]);
var inst_39310 = done(null);
var inst_39311 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_39306);
var state_39338__$1 = (function (){var statearr_39367 = state_39338;
(statearr_39367[(24)] = inst_39310);

return statearr_39367;
})();
var statearr_39368_39443 = state_39338__$1;
(statearr_39368_39443[(2)] = inst_39311);

(statearr_39368_39443[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (33))){
var inst_39297 = (state_39338[(25)]);
var inst_39299 = cljs.core.chunked_seq_QMARK_(inst_39297);
var state_39338__$1 = state_39338;
if(inst_39299){
var statearr_39369_39444 = state_39338__$1;
(statearr_39369_39444[(1)] = (36));

} else {
var statearr_39370_39445 = state_39338__$1;
(statearr_39370_39445[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (13))){
var inst_39229 = (state_39338[(26)]);
var inst_39232 = cljs.core.async.close_BANG_(inst_39229);
var state_39338__$1 = state_39338;
var statearr_39371_39446 = state_39338__$1;
(statearr_39371_39446[(2)] = inst_39232);

(statearr_39371_39446[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (22))){
var inst_39250 = (state_39338[(8)]);
var inst_39253 = cljs.core.async.close_BANG_(inst_39250);
var state_39338__$1 = state_39338;
var statearr_39372_39447 = state_39338__$1;
(statearr_39372_39447[(2)] = inst_39253);

(statearr_39372_39447[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (36))){
var inst_39297 = (state_39338[(25)]);
var inst_39301 = cljs.core.chunk_first(inst_39297);
var inst_39302 = cljs.core.chunk_rest(inst_39297);
var inst_39303 = cljs.core.count(inst_39301);
var inst_39278 = inst_39302;
var inst_39279 = inst_39301;
var inst_39280 = inst_39303;
var inst_39281 = (0);
var state_39338__$1 = (function (){var statearr_39373 = state_39338;
(statearr_39373[(9)] = inst_39281);

(statearr_39373[(20)] = inst_39280);

(statearr_39373[(21)] = inst_39278);

(statearr_39373[(11)] = inst_39279);

return statearr_39373;
})();
var statearr_39374_39448 = state_39338__$1;
(statearr_39374_39448[(2)] = null);

(statearr_39374_39448[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (41))){
var inst_39297 = (state_39338[(25)]);
var inst_39313 = (state_39338[(2)]);
var inst_39314 = cljs.core.next(inst_39297);
var inst_39278 = inst_39314;
var inst_39279 = null;
var inst_39280 = (0);
var inst_39281 = (0);
var state_39338__$1 = (function (){var statearr_39375 = state_39338;
(statearr_39375[(9)] = inst_39281);

(statearr_39375[(27)] = inst_39313);

(statearr_39375[(20)] = inst_39280);

(statearr_39375[(21)] = inst_39278);

(statearr_39375[(11)] = inst_39279);

return statearr_39375;
})();
var statearr_39376_39449 = state_39338__$1;
(statearr_39376_39449[(2)] = null);

(statearr_39376_39449[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (43))){
var state_39338__$1 = state_39338;
var statearr_39377_39450 = state_39338__$1;
(statearr_39377_39450[(2)] = null);

(statearr_39377_39450[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (29))){
var inst_39322 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39378_39451 = state_39338__$1;
(statearr_39378_39451[(2)] = inst_39322);

(statearr_39378_39451[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (44))){
var inst_39331 = (state_39338[(2)]);
var state_39338__$1 = (function (){var statearr_39379 = state_39338;
(statearr_39379[(28)] = inst_39331);

return statearr_39379;
})();
var statearr_39380_39452 = state_39338__$1;
(statearr_39380_39452[(2)] = null);

(statearr_39380_39452[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (6))){
var inst_39270 = (state_39338[(29)]);
var inst_39269 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_39270__$1 = cljs.core.keys(inst_39269);
var inst_39271 = cljs.core.count(inst_39270__$1);
var inst_39272 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,inst_39271) : cljs.core.reset_BANG_.call(null,dctr,inst_39271));
var inst_39277 = cljs.core.seq(inst_39270__$1);
var inst_39278 = inst_39277;
var inst_39279 = null;
var inst_39280 = (0);
var inst_39281 = (0);
var state_39338__$1 = (function (){var statearr_39381 = state_39338;
(statearr_39381[(9)] = inst_39281);

(statearr_39381[(29)] = inst_39270__$1);

(statearr_39381[(20)] = inst_39280);

(statearr_39381[(30)] = inst_39272);

(statearr_39381[(21)] = inst_39278);

(statearr_39381[(11)] = inst_39279);

return statearr_39381;
})();
var statearr_39382_39453 = state_39338__$1;
(statearr_39382_39453[(2)] = null);

(statearr_39382_39453[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (28))){
var inst_39278 = (state_39338[(21)]);
var inst_39297 = (state_39338[(25)]);
var inst_39297__$1 = cljs.core.seq(inst_39278);
var state_39338__$1 = (function (){var statearr_39383 = state_39338;
(statearr_39383[(25)] = inst_39297__$1);

return statearr_39383;
})();
if(inst_39297__$1){
var statearr_39384_39454 = state_39338__$1;
(statearr_39384_39454[(1)] = (33));

} else {
var statearr_39385_39455 = state_39338__$1;
(statearr_39385_39455[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (25))){
var inst_39281 = (state_39338[(9)]);
var inst_39280 = (state_39338[(20)]);
var inst_39283 = (inst_39281 < inst_39280);
var inst_39284 = inst_39283;
var state_39338__$1 = state_39338;
if(cljs.core.truth_(inst_39284)){
var statearr_39386_39456 = state_39338__$1;
(statearr_39386_39456[(1)] = (27));

} else {
var statearr_39387_39457 = state_39338__$1;
(statearr_39387_39457[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (34))){
var state_39338__$1 = state_39338;
var statearr_39388_39458 = state_39338__$1;
(statearr_39388_39458[(2)] = null);

(statearr_39388_39458[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (17))){
var state_39338__$1 = state_39338;
var statearr_39389_39459 = state_39338__$1;
(statearr_39389_39459[(2)] = null);

(statearr_39389_39459[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (3))){
var inst_39336 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39338__$1,inst_39336);
} else {
if((state_val_39339 === (12))){
var inst_39265 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39390_39460 = state_39338__$1;
(statearr_39390_39460[(2)] = inst_39265);

(statearr_39390_39460[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (2))){
var state_39338__$1 = state_39338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39338__$1,(4),ch);
} else {
if((state_val_39339 === (23))){
var state_39338__$1 = state_39338;
var statearr_39391_39461 = state_39338__$1;
(statearr_39391_39461[(2)] = null);

(statearr_39391_39461[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (35))){
var inst_39320 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39392_39462 = state_39338__$1;
(statearr_39392_39462[(2)] = inst_39320);

(statearr_39392_39462[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (19))){
var inst_39239 = (state_39338[(7)]);
var inst_39243 = cljs.core.chunk_first(inst_39239);
var inst_39244 = cljs.core.chunk_rest(inst_39239);
var inst_39245 = cljs.core.count(inst_39243);
var inst_39219 = inst_39244;
var inst_39220 = inst_39243;
var inst_39221 = inst_39245;
var inst_39222 = (0);
var state_39338__$1 = (function (){var statearr_39393 = state_39338;
(statearr_39393[(13)] = inst_39221);

(statearr_39393[(15)] = inst_39220);

(statearr_39393[(16)] = inst_39219);

(statearr_39393[(17)] = inst_39222);

return statearr_39393;
})();
var statearr_39394_39463 = state_39338__$1;
(statearr_39394_39463[(2)] = null);

(statearr_39394_39463[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (11))){
var inst_39219 = (state_39338[(16)]);
var inst_39239 = (state_39338[(7)]);
var inst_39239__$1 = cljs.core.seq(inst_39219);
var state_39338__$1 = (function (){var statearr_39395 = state_39338;
(statearr_39395[(7)] = inst_39239__$1);

return statearr_39395;
})();
if(inst_39239__$1){
var statearr_39396_39464 = state_39338__$1;
(statearr_39396_39464[(1)] = (16));

} else {
var statearr_39397_39465 = state_39338__$1;
(statearr_39397_39465[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (9))){
var inst_39267 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39398_39466 = state_39338__$1;
(statearr_39398_39466[(2)] = inst_39267);

(statearr_39398_39466[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (5))){
var inst_39217 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var inst_39218 = cljs.core.seq(inst_39217);
var inst_39219 = inst_39218;
var inst_39220 = null;
var inst_39221 = (0);
var inst_39222 = (0);
var state_39338__$1 = (function (){var statearr_39399 = state_39338;
(statearr_39399[(13)] = inst_39221);

(statearr_39399[(15)] = inst_39220);

(statearr_39399[(16)] = inst_39219);

(statearr_39399[(17)] = inst_39222);

return statearr_39399;
})();
var statearr_39400_39467 = state_39338__$1;
(statearr_39400_39467[(2)] = null);

(statearr_39400_39467[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (14))){
var state_39338__$1 = state_39338;
var statearr_39401_39468 = state_39338__$1;
(statearr_39401_39468[(2)] = null);

(statearr_39401_39468[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (45))){
var inst_39328 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39402_39469 = state_39338__$1;
(statearr_39402_39469[(2)] = inst_39328);

(statearr_39402_39469[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (26))){
var inst_39270 = (state_39338[(29)]);
var inst_39324 = (state_39338[(2)]);
var inst_39325 = cljs.core.seq(inst_39270);
var state_39338__$1 = (function (){var statearr_39403 = state_39338;
(statearr_39403[(31)] = inst_39324);

return statearr_39403;
})();
if(inst_39325){
var statearr_39404_39470 = state_39338__$1;
(statearr_39404_39470[(1)] = (42));

} else {
var statearr_39405_39471 = state_39338__$1;
(statearr_39405_39471[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (16))){
var inst_39239 = (state_39338[(7)]);
var inst_39241 = cljs.core.chunked_seq_QMARK_(inst_39239);
var state_39338__$1 = state_39338;
if(inst_39241){
var statearr_39406_39472 = state_39338__$1;
(statearr_39406_39472[(1)] = (19));

} else {
var statearr_39407_39473 = state_39338__$1;
(statearr_39407_39473[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (38))){
var inst_39317 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39408_39474 = state_39338__$1;
(statearr_39408_39474[(2)] = inst_39317);

(statearr_39408_39474[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (30))){
var state_39338__$1 = state_39338;
var statearr_39409_39475 = state_39338__$1;
(statearr_39409_39475[(2)] = null);

(statearr_39409_39475[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (10))){
var inst_39220 = (state_39338[(15)]);
var inst_39222 = (state_39338[(17)]);
var inst_39228 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_39220,inst_39222);
var inst_39229 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39228,(0),null);
var inst_39230 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39228,(1),null);
var state_39338__$1 = (function (){var statearr_39410 = state_39338;
(statearr_39410[(26)] = inst_39229);

return statearr_39410;
})();
if(cljs.core.truth_(inst_39230)){
var statearr_39411_39476 = state_39338__$1;
(statearr_39411_39476[(1)] = (13));

} else {
var statearr_39412_39477 = state_39338__$1;
(statearr_39412_39477[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (18))){
var inst_39263 = (state_39338[(2)]);
var state_39338__$1 = state_39338;
var statearr_39413_39478 = state_39338__$1;
(statearr_39413_39478[(2)] = inst_39263);

(statearr_39413_39478[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (42))){
var state_39338__$1 = state_39338;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39338__$1,(45),dchan);
} else {
if((state_val_39339 === (37))){
var inst_39306 = (state_39338[(23)]);
var inst_39210 = (state_39338[(12)]);
var inst_39297 = (state_39338[(25)]);
var inst_39306__$1 = cljs.core.first(inst_39297);
var inst_39307 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_39306__$1,inst_39210,done);
var state_39338__$1 = (function (){var statearr_39414 = state_39338;
(statearr_39414[(23)] = inst_39306__$1);

return statearr_39414;
})();
if(cljs.core.truth_(inst_39307)){
var statearr_39415_39479 = state_39338__$1;
(statearr_39415_39479[(1)] = (39));

} else {
var statearr_39416_39480 = state_39338__$1;
(statearr_39416_39480[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39339 === (8))){
var inst_39221 = (state_39338[(13)]);
var inst_39222 = (state_39338[(17)]);
var inst_39224 = (inst_39222 < inst_39221);
var inst_39225 = inst_39224;
var state_39338__$1 = state_39338;
if(cljs.core.truth_(inst_39225)){
var statearr_39417_39481 = state_39338__$1;
(statearr_39417_39481[(1)] = (10));

} else {
var statearr_39418_39482 = state_39338__$1;
(statearr_39418_39482[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___39428,cs,m,dchan,dctr,done))
;
return ((function (switch__37995__auto__,c__38109__auto___39428,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__37996__auto__ = null;
var cljs$core$async$mult_$_state_machine__37996__auto____0 = (function (){
var statearr_39422 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39422[(0)] = cljs$core$async$mult_$_state_machine__37996__auto__);

(statearr_39422[(1)] = (1));

return statearr_39422;
});
var cljs$core$async$mult_$_state_machine__37996__auto____1 = (function (state_39338){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_39338);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e39423){if((e39423 instanceof Object)){
var ex__37999__auto__ = e39423;
var statearr_39424_39483 = state_39338;
(statearr_39424_39483[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39338);

return cljs.core.cst$kw$recur;
} else {
throw e39423;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__39484 = state_39338;
state_39338 = G__39484;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__37996__auto__ = function(state_39338){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__37996__auto____1.call(this,state_39338);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__37996__auto____0;
cljs$core$async$mult_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__37996__auto____1;
return cljs$core$async$mult_$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___39428,cs,m,dchan,dctr,done))
})();
var state__38111__auto__ = (function (){var statearr_39425 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_39425[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___39428);

return statearr_39425;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___39428,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args39485 = [];
var len__7211__auto___39488 = arguments.length;
var i__7212__auto___39489 = (0);
while(true){
if((i__7212__auto___39489 < len__7211__auto___39488)){
args39485.push((arguments[i__7212__auto___39489]));

var G__39490 = (i__7212__auto___39489 + (1));
i__7212__auto___39489 = G__39490;
continue;
} else {
}
break;
}

var G__39487 = args39485.length;
switch (G__39487) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39485.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;
/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto__.call(null,m,ch));
} else {
var m__6809__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto__.call(null,m,ch));
} else {
var m__6809__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,ch) : m__6809__auto____$1.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__6809__auto__.call(null,m));
} else {
var m__6809__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(m) : m__6809__auto____$1.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6809__auto__.call(null,m,state_map));
} else {
var m__6809__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__6809__auto____$1.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__6808__auto__ = (((m == null))?null:m);
var m__6809__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6809__auto__.call(null,m,mode));
} else {
var m__6809__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(m,mode) : m__6809__auto____$1.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7218__auto__ = [];
var len__7211__auto___39502 = arguments.length;
var i__7212__auto___39503 = (0);
while(true){
if((i__7212__auto___39503 < len__7211__auto___39502)){
args__7218__auto__.push((arguments[i__7212__auto___39503]));

var G__39504 = (i__7212__auto___39503 + (1));
i__7212__auto___39503 = G__39504;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((3) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((3)),(0))):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7219__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__39496){
var map__39497 = p__39496;
var map__39497__$1 = ((((!((map__39497 == null)))?((((map__39497.cljs$lang$protocol_mask$partition0$ & (64))) || (map__39497.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__39497):map__39497);
var opts = map__39497__$1;
var statearr_39499_39505 = state;
(statearr_39499_39505[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts(((function (map__39497,map__39497__$1,opts){
return (function (val){
var statearr_39500_39506 = state;
(statearr_39500_39506[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
});})(map__39497,map__39497__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_39501_39507 = state;
(statearr_39501_39507[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cb) : cljs.core.deref.call(null,cb)));


return cljs.core.cst$kw$recur;
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq39492){
var G__39493 = cljs.core.first(seq39492);
var seq39492__$1 = cljs.core.next(seq39492);
var G__39494 = cljs.core.first(seq39492__$1);
var seq39492__$2 = cljs.core.next(seq39492__$1);
var G__39495 = cljs.core.first(seq39492__$2);
var seq39492__$3 = cljs.core.next(seq39492__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__39493,G__39494,G__39495,seq39492__$3);
});
/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = (function (){var G__39674 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__39674) : cljs.core.atom.call(null,G__39674));
})();
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute) : cljs.core.atom.call(null,cljs.core.cst$kw$mute));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv(((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(cs) : cljs.core.deref.call(null,cs));
var mode = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(solo_mode) : cljs.core.deref.call(null,solo_mode));
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && (!(cljs.core.empty_QMARK_(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async39675 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39675 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta39676){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta39676 = meta39676;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_39677,meta39676__$1){
var self__ = this;
var _39677__$1 = this;
return (new cljs.core.async.t_cljs$core$async39675(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta39676__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_39677){
var self__ = this;
var _39677__$1 = this;
return self__.meta39676;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__39678_39840 = self__.cs;
var G__39679_39841 = cljs.core.PersistentArrayMap.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__39678_39840,G__39679_39841) : cljs.core.reset_BANG_.call(null,G__39678_39840,G__39679_39841));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$mode)], 0)))].join('')));
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(self__.solo_mode,mode) : cljs.core.reset_BANG_.call(null,self__.solo_mode,mode));

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.with_meta(cljs.core.cst$sym$mix,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out], null))),cljs.core.cst$kw$doc,"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta39676], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async39675.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39675.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39675";

cljs.core.async.t_cljs$core$async39675.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async39675");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async39675 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async39675(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta39676){
return (new cljs.core.async.t_cljs$core$async39675(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta39676));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async39675(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38109__auto___39842 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___39842,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___39842,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_39777){
var state_val_39778 = (state_39777[(1)]);
if((state_val_39778 === (7))){
var inst_39695 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
var statearr_39779_39843 = state_39777__$1;
(statearr_39779_39843[(2)] = inst_39695);

(statearr_39779_39843[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (20))){
var inst_39707 = (state_39777[(7)]);
var state_39777__$1 = state_39777;
var statearr_39780_39844 = state_39777__$1;
(statearr_39780_39844[(2)] = inst_39707);

(statearr_39780_39844[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (27))){
var state_39777__$1 = state_39777;
var statearr_39781_39845 = state_39777__$1;
(statearr_39781_39845[(2)] = null);

(statearr_39781_39845[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (1))){
var inst_39683 = (state_39777[(8)]);
var inst_39683__$1 = calc_state();
var inst_39685 = (inst_39683__$1 == null);
var inst_39686 = cljs.core.not(inst_39685);
var state_39777__$1 = (function (){var statearr_39782 = state_39777;
(statearr_39782[(8)] = inst_39683__$1);

return statearr_39782;
})();
if(inst_39686){
var statearr_39783_39846 = state_39777__$1;
(statearr_39783_39846[(1)] = (2));

} else {
var statearr_39784_39847 = state_39777__$1;
(statearr_39784_39847[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (24))){
var inst_39737 = (state_39777[(9)]);
var inst_39730 = (state_39777[(10)]);
var inst_39751 = (state_39777[(11)]);
var inst_39751__$1 = (inst_39730.cljs$core$IFn$_invoke$arity$1 ? inst_39730.cljs$core$IFn$_invoke$arity$1(inst_39737) : inst_39730.call(null,inst_39737));
var state_39777__$1 = (function (){var statearr_39785 = state_39777;
(statearr_39785[(11)] = inst_39751__$1);

return statearr_39785;
})();
if(cljs.core.truth_(inst_39751__$1)){
var statearr_39786_39848 = state_39777__$1;
(statearr_39786_39848[(1)] = (29));

} else {
var statearr_39787_39849 = state_39777__$1;
(statearr_39787_39849[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (4))){
var inst_39698 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
if(cljs.core.truth_(inst_39698)){
var statearr_39788_39850 = state_39777__$1;
(statearr_39788_39850[(1)] = (8));

} else {
var statearr_39789_39851 = state_39777__$1;
(statearr_39789_39851[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (15))){
var inst_39724 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
if(cljs.core.truth_(inst_39724)){
var statearr_39790_39852 = state_39777__$1;
(statearr_39790_39852[(1)] = (19));

} else {
var statearr_39791_39853 = state_39777__$1;
(statearr_39791_39853[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (21))){
var inst_39729 = (state_39777[(12)]);
var inst_39729__$1 = (state_39777[(2)]);
var inst_39730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39729__$1,cljs.core.cst$kw$solos);
var inst_39731 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39729__$1,cljs.core.cst$kw$mutes);
var inst_39732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39729__$1,cljs.core.cst$kw$reads);
var state_39777__$1 = (function (){var statearr_39792 = state_39777;
(statearr_39792[(10)] = inst_39730);

(statearr_39792[(13)] = inst_39731);

(statearr_39792[(12)] = inst_39729__$1);

return statearr_39792;
})();
return cljs.core.async.ioc_alts_BANG_(state_39777__$1,(22),inst_39732);
} else {
if((state_val_39778 === (31))){
var inst_39759 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
if(cljs.core.truth_(inst_39759)){
var statearr_39793_39854 = state_39777__$1;
(statearr_39793_39854[(1)] = (32));

} else {
var statearr_39794_39855 = state_39777__$1;
(statearr_39794_39855[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (32))){
var inst_39736 = (state_39777[(14)]);
var state_39777__$1 = state_39777;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39777__$1,(35),out,inst_39736);
} else {
if((state_val_39778 === (33))){
var inst_39729 = (state_39777[(12)]);
var inst_39707 = inst_39729;
var state_39777__$1 = (function (){var statearr_39795 = state_39777;
(statearr_39795[(7)] = inst_39707);

return statearr_39795;
})();
var statearr_39796_39856 = state_39777__$1;
(statearr_39796_39856[(2)] = null);

(statearr_39796_39856[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (13))){
var inst_39707 = (state_39777[(7)]);
var inst_39714 = inst_39707.cljs$lang$protocol_mask$partition0$;
var inst_39715 = (inst_39714 & (64));
var inst_39716 = inst_39707.cljs$core$ISeq$;
var inst_39717 = (inst_39715) || (inst_39716);
var state_39777__$1 = state_39777;
if(cljs.core.truth_(inst_39717)){
var statearr_39797_39857 = state_39777__$1;
(statearr_39797_39857[(1)] = (16));

} else {
var statearr_39798_39858 = state_39777__$1;
(statearr_39798_39858[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (22))){
var inst_39737 = (state_39777[(9)]);
var inst_39736 = (state_39777[(14)]);
var inst_39735 = (state_39777[(2)]);
var inst_39736__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39735,(0),null);
var inst_39737__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39735,(1),null);
var inst_39738 = (inst_39736__$1 == null);
var inst_39739 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_39737__$1,change);
var inst_39740 = (inst_39738) || (inst_39739);
var state_39777__$1 = (function (){var statearr_39799 = state_39777;
(statearr_39799[(9)] = inst_39737__$1);

(statearr_39799[(14)] = inst_39736__$1);

return statearr_39799;
})();
if(cljs.core.truth_(inst_39740)){
var statearr_39800_39859 = state_39777__$1;
(statearr_39800_39859[(1)] = (23));

} else {
var statearr_39801_39860 = state_39777__$1;
(statearr_39801_39860[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (36))){
var inst_39729 = (state_39777[(12)]);
var inst_39707 = inst_39729;
var state_39777__$1 = (function (){var statearr_39802 = state_39777;
(statearr_39802[(7)] = inst_39707);

return statearr_39802;
})();
var statearr_39803_39861 = state_39777__$1;
(statearr_39803_39861[(2)] = null);

(statearr_39803_39861[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (29))){
var inst_39751 = (state_39777[(11)]);
var state_39777__$1 = state_39777;
var statearr_39804_39862 = state_39777__$1;
(statearr_39804_39862[(2)] = inst_39751);

(statearr_39804_39862[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (6))){
var state_39777__$1 = state_39777;
var statearr_39805_39863 = state_39777__$1;
(statearr_39805_39863[(2)] = false);

(statearr_39805_39863[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (28))){
var inst_39747 = (state_39777[(2)]);
var inst_39748 = calc_state();
var inst_39707 = inst_39748;
var state_39777__$1 = (function (){var statearr_39806 = state_39777;
(statearr_39806[(15)] = inst_39747);

(statearr_39806[(7)] = inst_39707);

return statearr_39806;
})();
var statearr_39807_39864 = state_39777__$1;
(statearr_39807_39864[(2)] = null);

(statearr_39807_39864[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (25))){
var inst_39773 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
var statearr_39808_39865 = state_39777__$1;
(statearr_39808_39865[(2)] = inst_39773);

(statearr_39808_39865[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (34))){
var inst_39771 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
var statearr_39809_39866 = state_39777__$1;
(statearr_39809_39866[(2)] = inst_39771);

(statearr_39809_39866[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (17))){
var state_39777__$1 = state_39777;
var statearr_39810_39867 = state_39777__$1;
(statearr_39810_39867[(2)] = false);

(statearr_39810_39867[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (3))){
var state_39777__$1 = state_39777;
var statearr_39811_39868 = state_39777__$1;
(statearr_39811_39868[(2)] = false);

(statearr_39811_39868[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (12))){
var inst_39775 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39777__$1,inst_39775);
} else {
if((state_val_39778 === (2))){
var inst_39683 = (state_39777[(8)]);
var inst_39688 = inst_39683.cljs$lang$protocol_mask$partition0$;
var inst_39689 = (inst_39688 & (64));
var inst_39690 = inst_39683.cljs$core$ISeq$;
var inst_39691 = (inst_39689) || (inst_39690);
var state_39777__$1 = state_39777;
if(cljs.core.truth_(inst_39691)){
var statearr_39812_39869 = state_39777__$1;
(statearr_39812_39869[(1)] = (5));

} else {
var statearr_39813_39870 = state_39777__$1;
(statearr_39813_39870[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (23))){
var inst_39736 = (state_39777[(14)]);
var inst_39742 = (inst_39736 == null);
var state_39777__$1 = state_39777;
if(cljs.core.truth_(inst_39742)){
var statearr_39814_39871 = state_39777__$1;
(statearr_39814_39871[(1)] = (26));

} else {
var statearr_39815_39872 = state_39777__$1;
(statearr_39815_39872[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (35))){
var inst_39762 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
if(cljs.core.truth_(inst_39762)){
var statearr_39816_39873 = state_39777__$1;
(statearr_39816_39873[(1)] = (36));

} else {
var statearr_39817_39874 = state_39777__$1;
(statearr_39817_39874[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (19))){
var inst_39707 = (state_39777[(7)]);
var inst_39726 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_39707);
var state_39777__$1 = state_39777;
var statearr_39818_39875 = state_39777__$1;
(statearr_39818_39875[(2)] = inst_39726);

(statearr_39818_39875[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (11))){
var inst_39707 = (state_39777[(7)]);
var inst_39711 = (inst_39707 == null);
var inst_39712 = cljs.core.not(inst_39711);
var state_39777__$1 = state_39777;
if(inst_39712){
var statearr_39819_39876 = state_39777__$1;
(statearr_39819_39876[(1)] = (13));

} else {
var statearr_39820_39877 = state_39777__$1;
(statearr_39820_39877[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (9))){
var inst_39683 = (state_39777[(8)]);
var state_39777__$1 = state_39777;
var statearr_39821_39878 = state_39777__$1;
(statearr_39821_39878[(2)] = inst_39683);

(statearr_39821_39878[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (5))){
var state_39777__$1 = state_39777;
var statearr_39822_39879 = state_39777__$1;
(statearr_39822_39879[(2)] = true);

(statearr_39822_39879[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (14))){
var state_39777__$1 = state_39777;
var statearr_39823_39880 = state_39777__$1;
(statearr_39823_39880[(2)] = false);

(statearr_39823_39880[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (26))){
var inst_39737 = (state_39777[(9)]);
var inst_39744 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_39737);
var state_39777__$1 = state_39777;
var statearr_39824_39881 = state_39777__$1;
(statearr_39824_39881[(2)] = inst_39744);

(statearr_39824_39881[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (16))){
var state_39777__$1 = state_39777;
var statearr_39825_39882 = state_39777__$1;
(statearr_39825_39882[(2)] = true);

(statearr_39825_39882[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (38))){
var inst_39767 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
var statearr_39826_39883 = state_39777__$1;
(statearr_39826_39883[(2)] = inst_39767);

(statearr_39826_39883[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (30))){
var inst_39737 = (state_39777[(9)]);
var inst_39730 = (state_39777[(10)]);
var inst_39731 = (state_39777[(13)]);
var inst_39754 = cljs.core.empty_QMARK_(inst_39730);
var inst_39755 = (inst_39731.cljs$core$IFn$_invoke$arity$1 ? inst_39731.cljs$core$IFn$_invoke$arity$1(inst_39737) : inst_39731.call(null,inst_39737));
var inst_39756 = cljs.core.not(inst_39755);
var inst_39757 = (inst_39754) && (inst_39756);
var state_39777__$1 = state_39777;
var statearr_39827_39884 = state_39777__$1;
(statearr_39827_39884[(2)] = inst_39757);

(statearr_39827_39884[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (10))){
var inst_39683 = (state_39777[(8)]);
var inst_39703 = (state_39777[(2)]);
var inst_39704 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39703,cljs.core.cst$kw$solos);
var inst_39705 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39703,cljs.core.cst$kw$mutes);
var inst_39706 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39703,cljs.core.cst$kw$reads);
var inst_39707 = inst_39683;
var state_39777__$1 = (function (){var statearr_39828 = state_39777;
(statearr_39828[(16)] = inst_39704);

(statearr_39828[(7)] = inst_39707);

(statearr_39828[(17)] = inst_39705);

(statearr_39828[(18)] = inst_39706);

return statearr_39828;
})();
var statearr_39829_39885 = state_39777__$1;
(statearr_39829_39885[(2)] = null);

(statearr_39829_39885[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (18))){
var inst_39721 = (state_39777[(2)]);
var state_39777__$1 = state_39777;
var statearr_39830_39886 = state_39777__$1;
(statearr_39830_39886[(2)] = inst_39721);

(statearr_39830_39886[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (37))){
var state_39777__$1 = state_39777;
var statearr_39831_39887 = state_39777__$1;
(statearr_39831_39887[(2)] = null);

(statearr_39831_39887[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39778 === (8))){
var inst_39683 = (state_39777[(8)]);
var inst_39700 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_39683);
var state_39777__$1 = state_39777;
var statearr_39832_39888 = state_39777__$1;
(statearr_39832_39888[(2)] = inst_39700);

(statearr_39832_39888[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___39842,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__37995__auto__,c__38109__auto___39842,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__37996__auto__ = null;
var cljs$core$async$mix_$_state_machine__37996__auto____0 = (function (){
var statearr_39836 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39836[(0)] = cljs$core$async$mix_$_state_machine__37996__auto__);

(statearr_39836[(1)] = (1));

return statearr_39836;
});
var cljs$core$async$mix_$_state_machine__37996__auto____1 = (function (state_39777){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_39777);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e39837){if((e39837 instanceof Object)){
var ex__37999__auto__ = e39837;
var statearr_39838_39889 = state_39777;
(statearr_39838_39889[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39777);

return cljs.core.cst$kw$recur;
} else {
throw e39837;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__39890 = state_39777;
state_39777 = G__39890;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__37996__auto__ = function(state_39777){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__37996__auto____1.call(this,state_39777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__37996__auto____0;
cljs$core$async$mix_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__37996__auto____1;
return cljs$core$async$mix_$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___39842,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__38111__auto__ = (function (){var statearr_39839 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_39839[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___39842);

return statearr_39839;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___39842,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__6808__auto__ = (((p == null))?null:p);
var m__6809__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$4 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6809__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__6809__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$4 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__6809__auto____$1.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__6808__auto__ = (((p == null))?null:p);
var m__6809__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6809__auto__.call(null,p,v,ch));
} else {
var m__6809__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__6809__auto____$1.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args39891 = [];
var len__7211__auto___39894 = arguments.length;
var i__7212__auto___39895 = (0);
while(true){
if((i__7212__auto___39895 < len__7211__auto___39894)){
args39891.push((arguments[i__7212__auto___39895]));

var G__39896 = (i__7212__auto___39895 + (1));
i__7212__auto___39895 = G__39896;
continue;
} else {
}
break;
}

var G__39893 = args39891.length;
switch (G__39893) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39891.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__6808__auto__ = (((p == null))?null:p);
var m__6809__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__6809__auto__.call(null,p));
} else {
var m__6809__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(p) : m__6809__auto____$1.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__6808__auto__ = (((p == null))?null:p);
var m__6809__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__6809__auto__.call(null,p,v));
} else {
var m__6809__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(p,v) : m__6809__auto____$1.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;

/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args39899 = [];
var len__7211__auto___40027 = arguments.length;
var i__7212__auto___40028 = (0);
while(true){
if((i__7212__auto___40028 < len__7211__auto___40027)){
args39899.push((arguments[i__7212__auto___40028]));

var G__40029 = (i__7212__auto___40028 + (1));
i__7212__auto___40028 = G__40029;
continue;
} else {
}
break;
}

var G__39901 = args39899.length;
switch (G__39901) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args39899.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = (function (){var G__39902 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__39902) : cljs.core.atom.call(null,G__39902));
})();
var ensure_mult = ((function (mults){
return (function (topic){
var or__6153__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults)),topic);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,((function (or__6153__auto__,mults){
return (function (p1__39898_SHARP_){
if(cljs.core.truth_((p1__39898_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__39898_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__39898_SHARP_.call(null,topic)))){
return p1__39898_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__39898_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
});})(or__6153__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async39903 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async39903 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta39904){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta39904 = meta39904;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_39905,meta39904__$1){
var self__ = this;
var _39905__$1 = this;
return (new cljs.core.async.t_cljs$core$async39903(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta39904__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_39905){
var self__ = this;
var _39905__$1 = this;
return self__.meta39904;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(self__.mults) : cljs.core.deref.call(null,self__.mults)),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
var G__39906 = self__.mults;
var G__39907 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__39906,G__39907) : cljs.core.reset_BANG_.call(null,G__39906,G__39907));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39903.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39903.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta39904], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async39903.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async39903.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async39903";

cljs.core.async.t_cljs$core$async39903.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async39903");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async39903 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async39903(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta39904){
return (new cljs.core.async.t_cljs$core$async39903(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta39904));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async39903(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__38109__auto___40031 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___40031,mults,ensure_mult,p){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___40031,mults,ensure_mult,p){
return (function (state_39979){
var state_val_39980 = (state_39979[(1)]);
if((state_val_39980 === (7))){
var inst_39975 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
var statearr_39981_40032 = state_39979__$1;
(statearr_39981_40032[(2)] = inst_39975);

(statearr_39981_40032[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (20))){
var state_39979__$1 = state_39979;
var statearr_39982_40033 = state_39979__$1;
(statearr_39982_40033[(2)] = null);

(statearr_39982_40033[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (1))){
var state_39979__$1 = state_39979;
var statearr_39983_40034 = state_39979__$1;
(statearr_39983_40034[(2)] = null);

(statearr_39983_40034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (24))){
var inst_39958 = (state_39979[(7)]);
var inst_39967 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_39958);
var state_39979__$1 = state_39979;
var statearr_39984_40035 = state_39979__$1;
(statearr_39984_40035[(2)] = inst_39967);

(statearr_39984_40035[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (4))){
var inst_39910 = (state_39979[(8)]);
var inst_39910__$1 = (state_39979[(2)]);
var inst_39911 = (inst_39910__$1 == null);
var state_39979__$1 = (function (){var statearr_39985 = state_39979;
(statearr_39985[(8)] = inst_39910__$1);

return statearr_39985;
})();
if(cljs.core.truth_(inst_39911)){
var statearr_39986_40036 = state_39979__$1;
(statearr_39986_40036[(1)] = (5));

} else {
var statearr_39987_40037 = state_39979__$1;
(statearr_39987_40037[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (15))){
var inst_39952 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
var statearr_39988_40038 = state_39979__$1;
(statearr_39988_40038[(2)] = inst_39952);

(statearr_39988_40038[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (21))){
var inst_39972 = (state_39979[(2)]);
var state_39979__$1 = (function (){var statearr_39989 = state_39979;
(statearr_39989[(9)] = inst_39972);

return statearr_39989;
})();
var statearr_39990_40039 = state_39979__$1;
(statearr_39990_40039[(2)] = null);

(statearr_39990_40039[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (13))){
var inst_39934 = (state_39979[(10)]);
var inst_39936 = cljs.core.chunked_seq_QMARK_(inst_39934);
var state_39979__$1 = state_39979;
if(inst_39936){
var statearr_39991_40040 = state_39979__$1;
(statearr_39991_40040[(1)] = (16));

} else {
var statearr_39992_40041 = state_39979__$1;
(statearr_39992_40041[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (22))){
var inst_39964 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
if(cljs.core.truth_(inst_39964)){
var statearr_39993_40042 = state_39979__$1;
(statearr_39993_40042[(1)] = (23));

} else {
var statearr_39994_40043 = state_39979__$1;
(statearr_39994_40043[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (6))){
var inst_39958 = (state_39979[(7)]);
var inst_39910 = (state_39979[(8)]);
var inst_39960 = (state_39979[(11)]);
var inst_39958__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_39910) : topic_fn.call(null,inst_39910));
var inst_39959 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_39960__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_39959,inst_39958__$1);
var state_39979__$1 = (function (){var statearr_39995 = state_39979;
(statearr_39995[(7)] = inst_39958__$1);

(statearr_39995[(11)] = inst_39960__$1);

return statearr_39995;
})();
if(cljs.core.truth_(inst_39960__$1)){
var statearr_39996_40044 = state_39979__$1;
(statearr_39996_40044[(1)] = (19));

} else {
var statearr_39997_40045 = state_39979__$1;
(statearr_39997_40045[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (25))){
var inst_39969 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
var statearr_39998_40046 = state_39979__$1;
(statearr_39998_40046[(2)] = inst_39969);

(statearr_39998_40046[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (17))){
var inst_39934 = (state_39979[(10)]);
var inst_39943 = cljs.core.first(inst_39934);
var inst_39944 = cljs.core.async.muxch_STAR_(inst_39943);
var inst_39945 = cljs.core.async.close_BANG_(inst_39944);
var inst_39946 = cljs.core.next(inst_39934);
var inst_39920 = inst_39946;
var inst_39921 = null;
var inst_39922 = (0);
var inst_39923 = (0);
var state_39979__$1 = (function (){var statearr_39999 = state_39979;
(statearr_39999[(12)] = inst_39920);

(statearr_39999[(13)] = inst_39922);

(statearr_39999[(14)] = inst_39921);

(statearr_39999[(15)] = inst_39923);

(statearr_39999[(16)] = inst_39945);

return statearr_39999;
})();
var statearr_40000_40047 = state_39979__$1;
(statearr_40000_40047[(2)] = null);

(statearr_40000_40047[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (3))){
var inst_39977 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39979__$1,inst_39977);
} else {
if((state_val_39980 === (12))){
var inst_39954 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
var statearr_40001_40048 = state_39979__$1;
(statearr_40001_40048[(2)] = inst_39954);

(statearr_40001_40048[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (2))){
var state_39979__$1 = state_39979;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39979__$1,(4),ch);
} else {
if((state_val_39980 === (23))){
var state_39979__$1 = state_39979;
var statearr_40002_40049 = state_39979__$1;
(statearr_40002_40049[(2)] = null);

(statearr_40002_40049[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (19))){
var inst_39910 = (state_39979[(8)]);
var inst_39960 = (state_39979[(11)]);
var inst_39962 = cljs.core.async.muxch_STAR_(inst_39960);
var state_39979__$1 = state_39979;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_39979__$1,(22),inst_39962,inst_39910);
} else {
if((state_val_39980 === (11))){
var inst_39920 = (state_39979[(12)]);
var inst_39934 = (state_39979[(10)]);
var inst_39934__$1 = cljs.core.seq(inst_39920);
var state_39979__$1 = (function (){var statearr_40003 = state_39979;
(statearr_40003[(10)] = inst_39934__$1);

return statearr_40003;
})();
if(inst_39934__$1){
var statearr_40004_40050 = state_39979__$1;
(statearr_40004_40050[(1)] = (13));

} else {
var statearr_40005_40051 = state_39979__$1;
(statearr_40005_40051[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (9))){
var inst_39956 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
var statearr_40006_40052 = state_39979__$1;
(statearr_40006_40052[(2)] = inst_39956);

(statearr_40006_40052[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (5))){
var inst_39917 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(mults) : cljs.core.deref.call(null,mults));
var inst_39918 = cljs.core.vals(inst_39917);
var inst_39919 = cljs.core.seq(inst_39918);
var inst_39920 = inst_39919;
var inst_39921 = null;
var inst_39922 = (0);
var inst_39923 = (0);
var state_39979__$1 = (function (){var statearr_40007 = state_39979;
(statearr_40007[(12)] = inst_39920);

(statearr_40007[(13)] = inst_39922);

(statearr_40007[(14)] = inst_39921);

(statearr_40007[(15)] = inst_39923);

return statearr_40007;
})();
var statearr_40008_40053 = state_39979__$1;
(statearr_40008_40053[(2)] = null);

(statearr_40008_40053[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (14))){
var state_39979__$1 = state_39979;
var statearr_40012_40054 = state_39979__$1;
(statearr_40012_40054[(2)] = null);

(statearr_40012_40054[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (16))){
var inst_39934 = (state_39979[(10)]);
var inst_39938 = cljs.core.chunk_first(inst_39934);
var inst_39939 = cljs.core.chunk_rest(inst_39934);
var inst_39940 = cljs.core.count(inst_39938);
var inst_39920 = inst_39939;
var inst_39921 = inst_39938;
var inst_39922 = inst_39940;
var inst_39923 = (0);
var state_39979__$1 = (function (){var statearr_40013 = state_39979;
(statearr_40013[(12)] = inst_39920);

(statearr_40013[(13)] = inst_39922);

(statearr_40013[(14)] = inst_39921);

(statearr_40013[(15)] = inst_39923);

return statearr_40013;
})();
var statearr_40014_40055 = state_39979__$1;
(statearr_40014_40055[(2)] = null);

(statearr_40014_40055[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (10))){
var inst_39920 = (state_39979[(12)]);
var inst_39922 = (state_39979[(13)]);
var inst_39921 = (state_39979[(14)]);
var inst_39923 = (state_39979[(15)]);
var inst_39928 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_39921,inst_39923);
var inst_39929 = cljs.core.async.muxch_STAR_(inst_39928);
var inst_39930 = cljs.core.async.close_BANG_(inst_39929);
var inst_39931 = (inst_39923 + (1));
var tmp40009 = inst_39920;
var tmp40010 = inst_39922;
var tmp40011 = inst_39921;
var inst_39920__$1 = tmp40009;
var inst_39921__$1 = tmp40011;
var inst_39922__$1 = tmp40010;
var inst_39923__$1 = inst_39931;
var state_39979__$1 = (function (){var statearr_40015 = state_39979;
(statearr_40015[(17)] = inst_39930);

(statearr_40015[(12)] = inst_39920__$1);

(statearr_40015[(13)] = inst_39922__$1);

(statearr_40015[(14)] = inst_39921__$1);

(statearr_40015[(15)] = inst_39923__$1);

return statearr_40015;
})();
var statearr_40016_40056 = state_39979__$1;
(statearr_40016_40056[(2)] = null);

(statearr_40016_40056[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (18))){
var inst_39949 = (state_39979[(2)]);
var state_39979__$1 = state_39979;
var statearr_40017_40057 = state_39979__$1;
(statearr_40017_40057[(2)] = inst_39949);

(statearr_40017_40057[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39980 === (8))){
var inst_39922 = (state_39979[(13)]);
var inst_39923 = (state_39979[(15)]);
var inst_39925 = (inst_39923 < inst_39922);
var inst_39926 = inst_39925;
var state_39979__$1 = state_39979;
if(cljs.core.truth_(inst_39926)){
var statearr_40018_40058 = state_39979__$1;
(statearr_40018_40058[(1)] = (10));

} else {
var statearr_40019_40059 = state_39979__$1;
(statearr_40019_40059[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___40031,mults,ensure_mult,p))
;
return ((function (switch__37995__auto__,c__38109__auto___40031,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_40023 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40023[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_40023[(1)] = (1));

return statearr_40023;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_39979){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_39979);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40024){if((e40024 instanceof Object)){
var ex__37999__auto__ = e40024;
var statearr_40025_40060 = state_39979;
(statearr_40025_40060[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_39979);

return cljs.core.cst$kw$recur;
} else {
throw e40024;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40061 = state_39979;
state_39979 = G__40061;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_39979){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_39979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___40031,mults,ensure_mult,p))
})();
var state__38111__auto__ = (function (){var statearr_40026 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40026[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___40031);

return statearr_40026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___40031,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;
/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args40062 = [];
var len__7211__auto___40065 = arguments.length;
var i__7212__auto___40066 = (0);
while(true){
if((i__7212__auto___40066 < len__7211__auto___40065)){
args40062.push((arguments[i__7212__auto___40066]));

var G__40067 = (i__7212__auto___40066 + (1));
i__7212__auto___40066 = G__40067;
continue;
} else {
}
break;
}

var G__40064 = args40062.length;
switch (G__40064) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40062.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;
/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args40069 = [];
var len__7211__auto___40072 = arguments.length;
var i__7212__auto___40073 = (0);
while(true){
if((i__7212__auto___40073 < len__7211__auto___40072)){
args40069.push((arguments[i__7212__auto___40073]));

var G__40074 = (i__7212__auto___40073 + (1));
i__7212__auto___40073 = G__40074;
continue;
} else {
}
break;
}

var G__40071 = args40069.length;
switch (G__40071) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40069.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;
/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args40076 = [];
var len__7211__auto___40147 = arguments.length;
var i__7212__auto___40148 = (0);
while(true){
if((i__7212__auto___40148 < len__7211__auto___40147)){
args40076.push((arguments[i__7212__auto___40148]));

var G__40149 = (i__7212__auto___40148 + (1));
i__7212__auto___40148 = G__40149;
continue;
} else {
}
break;
}

var G__40078 = args40076.length;
switch (G__40078) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40076.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null) : cljs.core.atom.call(null,null));
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__38109__auto___40151 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___40151,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___40151,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_40117){
var state_val_40118 = (state_40117[(1)]);
if((state_val_40118 === (7))){
var state_40117__$1 = state_40117;
var statearr_40119_40152 = state_40117__$1;
(statearr_40119_40152[(2)] = null);

(statearr_40119_40152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (1))){
var state_40117__$1 = state_40117;
var statearr_40120_40153 = state_40117__$1;
(statearr_40120_40153[(2)] = null);

(statearr_40120_40153[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (4))){
var inst_40081 = (state_40117[(7)]);
var inst_40083 = (inst_40081 < cnt);
var state_40117__$1 = state_40117;
if(cljs.core.truth_(inst_40083)){
var statearr_40121_40154 = state_40117__$1;
(statearr_40121_40154[(1)] = (6));

} else {
var statearr_40122_40155 = state_40117__$1;
(statearr_40122_40155[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (15))){
var inst_40113 = (state_40117[(2)]);
var state_40117__$1 = state_40117;
var statearr_40123_40156 = state_40117__$1;
(statearr_40123_40156[(2)] = inst_40113);

(statearr_40123_40156[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (13))){
var inst_40106 = cljs.core.async.close_BANG_(out);
var state_40117__$1 = state_40117;
var statearr_40124_40157 = state_40117__$1;
(statearr_40124_40157[(2)] = inst_40106);

(statearr_40124_40157[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (6))){
var state_40117__$1 = state_40117;
var statearr_40125_40158 = state_40117__$1;
(statearr_40125_40158[(2)] = null);

(statearr_40125_40158[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (3))){
var inst_40115 = (state_40117[(2)]);
var state_40117__$1 = state_40117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40117__$1,inst_40115);
} else {
if((state_val_40118 === (12))){
var inst_40103 = (state_40117[(8)]);
var inst_40103__$1 = (state_40117[(2)]);
var inst_40104 = cljs.core.some(cljs.core.nil_QMARK_,inst_40103__$1);
var state_40117__$1 = (function (){var statearr_40126 = state_40117;
(statearr_40126[(8)] = inst_40103__$1);

return statearr_40126;
})();
if(cljs.core.truth_(inst_40104)){
var statearr_40127_40159 = state_40117__$1;
(statearr_40127_40159[(1)] = (13));

} else {
var statearr_40128_40160 = state_40117__$1;
(statearr_40128_40160[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (2))){
var inst_40080 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cnt) : cljs.core.reset_BANG_.call(null,dctr,cnt));
var inst_40081 = (0);
var state_40117__$1 = (function (){var statearr_40129 = state_40117;
(statearr_40129[(7)] = inst_40081);

(statearr_40129[(9)] = inst_40080);

return statearr_40129;
})();
var statearr_40130_40161 = state_40117__$1;
(statearr_40130_40161[(2)] = null);

(statearr_40130_40161[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (11))){
var inst_40081 = (state_40117[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame(state_40117,(10),Object,null,(9));
var inst_40090 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_40081) : chs__$1.call(null,inst_40081));
var inst_40091 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_40081) : done.call(null,inst_40081));
var inst_40092 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_40090,inst_40091);
var state_40117__$1 = state_40117;
var statearr_40131_40162 = state_40117__$1;
(statearr_40131_40162[(2)] = inst_40092);


cljs.core.async.impl.ioc_helpers.process_exception(state_40117__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (9))){
var inst_40081 = (state_40117[(7)]);
var inst_40094 = (state_40117[(2)]);
var inst_40095 = (inst_40081 + (1));
var inst_40081__$1 = inst_40095;
var state_40117__$1 = (function (){var statearr_40132 = state_40117;
(statearr_40132[(10)] = inst_40094);

(statearr_40132[(7)] = inst_40081__$1);

return statearr_40132;
})();
var statearr_40133_40163 = state_40117__$1;
(statearr_40133_40163[(2)] = null);

(statearr_40133_40163[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (5))){
var inst_40101 = (state_40117[(2)]);
var state_40117__$1 = (function (){var statearr_40134 = state_40117;
(statearr_40134[(11)] = inst_40101);

return statearr_40134;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40117__$1,(12),dchan);
} else {
if((state_val_40118 === (14))){
var inst_40103 = (state_40117[(8)]);
var inst_40108 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_40103);
var state_40117__$1 = state_40117;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40117__$1,(16),out,inst_40108);
} else {
if((state_val_40118 === (16))){
var inst_40110 = (state_40117[(2)]);
var state_40117__$1 = (function (){var statearr_40135 = state_40117;
(statearr_40135[(12)] = inst_40110);

return statearr_40135;
})();
var statearr_40136_40164 = state_40117__$1;
(statearr_40136_40164[(2)] = null);

(statearr_40136_40164[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (10))){
var inst_40085 = (state_40117[(2)]);
var inst_40086 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_40117__$1 = (function (){var statearr_40137 = state_40117;
(statearr_40137[(13)] = inst_40085);

return statearr_40137;
})();
var statearr_40138_40165 = state_40117__$1;
(statearr_40138_40165[(2)] = inst_40086);


cljs.core.async.impl.ioc_helpers.process_exception(state_40117__$1);

return cljs.core.cst$kw$recur;
} else {
if((state_val_40118 === (8))){
var inst_40099 = (state_40117[(2)]);
var state_40117__$1 = state_40117;
var statearr_40139_40166 = state_40117__$1;
(statearr_40139_40166[(2)] = inst_40099);

(statearr_40139_40166[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___40151,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__37995__auto__,c__38109__auto___40151,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_40143 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40143[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_40143[(1)] = (1));

return statearr_40143;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_40117){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_40117);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40144){if((e40144 instanceof Object)){
var ex__37999__auto__ = e40144;
var statearr_40145_40167 = state_40117;
(statearr_40145_40167[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40117);

return cljs.core.cst$kw$recur;
} else {
throw e40144;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40168 = state_40117;
state_40117 = G__40168;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_40117){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_40117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___40151,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__38111__auto__ = (function (){var statearr_40146 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40146[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___40151);

return statearr_40146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___40151,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;
/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args40170 = [];
var len__7211__auto___40226 = arguments.length;
var i__7212__auto___40227 = (0);
while(true){
if((i__7212__auto___40227 < len__7211__auto___40226)){
args40170.push((arguments[i__7212__auto___40227]));

var G__40228 = (i__7212__auto___40227 + (1));
i__7212__auto___40227 = G__40228;
continue;
} else {
}
break;
}

var G__40172 = args40170.length;
switch (G__40172) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40170.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__38109__auto___40230 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___40230,out){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___40230,out){
return (function (state_40202){
var state_val_40203 = (state_40202[(1)]);
if((state_val_40203 === (7))){
var inst_40181 = (state_40202[(7)]);
var inst_40182 = (state_40202[(8)]);
var inst_40181__$1 = (state_40202[(2)]);
var inst_40182__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40181__$1,(0),null);
var inst_40183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_40181__$1,(1),null);
var inst_40184 = (inst_40182__$1 == null);
var state_40202__$1 = (function (){var statearr_40204 = state_40202;
(statearr_40204[(7)] = inst_40181__$1);

(statearr_40204[(9)] = inst_40183);

(statearr_40204[(8)] = inst_40182__$1);

return statearr_40204;
})();
if(cljs.core.truth_(inst_40184)){
var statearr_40205_40231 = state_40202__$1;
(statearr_40205_40231[(1)] = (8));

} else {
var statearr_40206_40232 = state_40202__$1;
(statearr_40206_40232[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40203 === (1))){
var inst_40173 = cljs.core.vec(chs);
var inst_40174 = inst_40173;
var state_40202__$1 = (function (){var statearr_40207 = state_40202;
(statearr_40207[(10)] = inst_40174);

return statearr_40207;
})();
var statearr_40208_40233 = state_40202__$1;
(statearr_40208_40233[(2)] = null);

(statearr_40208_40233[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40203 === (4))){
var inst_40174 = (state_40202[(10)]);
var state_40202__$1 = state_40202;
return cljs.core.async.ioc_alts_BANG_(state_40202__$1,(7),inst_40174);
} else {
if((state_val_40203 === (6))){
var inst_40198 = (state_40202[(2)]);
var state_40202__$1 = state_40202;
var statearr_40209_40234 = state_40202__$1;
(statearr_40209_40234[(2)] = inst_40198);

(statearr_40209_40234[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40203 === (3))){
var inst_40200 = (state_40202[(2)]);
var state_40202__$1 = state_40202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40202__$1,inst_40200);
} else {
if((state_val_40203 === (2))){
var inst_40174 = (state_40202[(10)]);
var inst_40176 = cljs.core.count(inst_40174);
var inst_40177 = (inst_40176 > (0));
var state_40202__$1 = state_40202;
if(cljs.core.truth_(inst_40177)){
var statearr_40211_40235 = state_40202__$1;
(statearr_40211_40235[(1)] = (4));

} else {
var statearr_40212_40236 = state_40202__$1;
(statearr_40212_40236[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40203 === (11))){
var inst_40174 = (state_40202[(10)]);
var inst_40191 = (state_40202[(2)]);
var tmp40210 = inst_40174;
var inst_40174__$1 = tmp40210;
var state_40202__$1 = (function (){var statearr_40213 = state_40202;
(statearr_40213[(10)] = inst_40174__$1);

(statearr_40213[(11)] = inst_40191);

return statearr_40213;
})();
var statearr_40214_40237 = state_40202__$1;
(statearr_40214_40237[(2)] = null);

(statearr_40214_40237[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40203 === (9))){
var inst_40182 = (state_40202[(8)]);
var state_40202__$1 = state_40202;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40202__$1,(11),out,inst_40182);
} else {
if((state_val_40203 === (5))){
var inst_40196 = cljs.core.async.close_BANG_(out);
var state_40202__$1 = state_40202;
var statearr_40215_40238 = state_40202__$1;
(statearr_40215_40238[(2)] = inst_40196);

(statearr_40215_40238[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40203 === (10))){
var inst_40194 = (state_40202[(2)]);
var state_40202__$1 = state_40202;
var statearr_40216_40239 = state_40202__$1;
(statearr_40216_40239[(2)] = inst_40194);

(statearr_40216_40239[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40203 === (8))){
var inst_40174 = (state_40202[(10)]);
var inst_40181 = (state_40202[(7)]);
var inst_40183 = (state_40202[(9)]);
var inst_40182 = (state_40202[(8)]);
var inst_40186 = (function (){var cs = inst_40174;
var vec__40179 = inst_40181;
var v = inst_40182;
var c = inst_40183;
return ((function (cs,vec__40179,v,c,inst_40174,inst_40181,inst_40183,inst_40182,state_val_40203,c__38109__auto___40230,out){
return (function (p1__40169_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__40169_SHARP_);
});
;})(cs,vec__40179,v,c,inst_40174,inst_40181,inst_40183,inst_40182,state_val_40203,c__38109__auto___40230,out))
})();
var inst_40187 = cljs.core.filterv(inst_40186,inst_40174);
var inst_40174__$1 = inst_40187;
var state_40202__$1 = (function (){var statearr_40217 = state_40202;
(statearr_40217[(10)] = inst_40174__$1);

return statearr_40217;
})();
var statearr_40218_40240 = state_40202__$1;
(statearr_40218_40240[(2)] = null);

(statearr_40218_40240[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___40230,out))
;
return ((function (switch__37995__auto__,c__38109__auto___40230,out){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_40222 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40222[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_40222[(1)] = (1));

return statearr_40222;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_40202){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_40202);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40223){if((e40223 instanceof Object)){
var ex__37999__auto__ = e40223;
var statearr_40224_40241 = state_40202;
(statearr_40224_40241[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40202);

return cljs.core.cst$kw$recur;
} else {
throw e40223;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40242 = state_40202;
state_40202 = G__40242;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_40202){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_40202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___40230,out))
})();
var state__38111__auto__ = (function (){var statearr_40225 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40225[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___40230);

return statearr_40225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___40230,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;
/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args40243 = [];
var len__7211__auto___40292 = arguments.length;
var i__7212__auto___40293 = (0);
while(true){
if((i__7212__auto___40293 < len__7211__auto___40292)){
args40243.push((arguments[i__7212__auto___40293]));

var G__40294 = (i__7212__auto___40293 + (1));
i__7212__auto___40293 = G__40294;
continue;
} else {
}
break;
}

var G__40245 = args40243.length;
switch (G__40245) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40243.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__38109__auto___40296 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___40296,out){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___40296,out){
return (function (state_40269){
var state_val_40270 = (state_40269[(1)]);
if((state_val_40270 === (7))){
var inst_40251 = (state_40269[(7)]);
var inst_40251__$1 = (state_40269[(2)]);
var inst_40252 = (inst_40251__$1 == null);
var inst_40253 = cljs.core.not(inst_40252);
var state_40269__$1 = (function (){var statearr_40271 = state_40269;
(statearr_40271[(7)] = inst_40251__$1);

return statearr_40271;
})();
if(inst_40253){
var statearr_40272_40297 = state_40269__$1;
(statearr_40272_40297[(1)] = (8));

} else {
var statearr_40273_40298 = state_40269__$1;
(statearr_40273_40298[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40270 === (1))){
var inst_40246 = (0);
var state_40269__$1 = (function (){var statearr_40274 = state_40269;
(statearr_40274[(8)] = inst_40246);

return statearr_40274;
})();
var statearr_40275_40299 = state_40269__$1;
(statearr_40275_40299[(2)] = null);

(statearr_40275_40299[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40270 === (4))){
var state_40269__$1 = state_40269;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40269__$1,(7),ch);
} else {
if((state_val_40270 === (6))){
var inst_40264 = (state_40269[(2)]);
var state_40269__$1 = state_40269;
var statearr_40276_40300 = state_40269__$1;
(statearr_40276_40300[(2)] = inst_40264);

(statearr_40276_40300[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40270 === (3))){
var inst_40266 = (state_40269[(2)]);
var inst_40267 = cljs.core.async.close_BANG_(out);
var state_40269__$1 = (function (){var statearr_40277 = state_40269;
(statearr_40277[(9)] = inst_40266);

return statearr_40277;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40269__$1,inst_40267);
} else {
if((state_val_40270 === (2))){
var inst_40246 = (state_40269[(8)]);
var inst_40248 = (inst_40246 < n);
var state_40269__$1 = state_40269;
if(cljs.core.truth_(inst_40248)){
var statearr_40278_40301 = state_40269__$1;
(statearr_40278_40301[(1)] = (4));

} else {
var statearr_40279_40302 = state_40269__$1;
(statearr_40279_40302[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40270 === (11))){
var inst_40246 = (state_40269[(8)]);
var inst_40256 = (state_40269[(2)]);
var inst_40257 = (inst_40246 + (1));
var inst_40246__$1 = inst_40257;
var state_40269__$1 = (function (){var statearr_40280 = state_40269;
(statearr_40280[(8)] = inst_40246__$1);

(statearr_40280[(10)] = inst_40256);

return statearr_40280;
})();
var statearr_40281_40303 = state_40269__$1;
(statearr_40281_40303[(2)] = null);

(statearr_40281_40303[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40270 === (9))){
var state_40269__$1 = state_40269;
var statearr_40282_40304 = state_40269__$1;
(statearr_40282_40304[(2)] = null);

(statearr_40282_40304[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40270 === (5))){
var state_40269__$1 = state_40269;
var statearr_40283_40305 = state_40269__$1;
(statearr_40283_40305[(2)] = null);

(statearr_40283_40305[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40270 === (10))){
var inst_40261 = (state_40269[(2)]);
var state_40269__$1 = state_40269;
var statearr_40284_40306 = state_40269__$1;
(statearr_40284_40306[(2)] = inst_40261);

(statearr_40284_40306[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40270 === (8))){
var inst_40251 = (state_40269[(7)]);
var state_40269__$1 = state_40269;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40269__$1,(11),out,inst_40251);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___40296,out))
;
return ((function (switch__37995__auto__,c__38109__auto___40296,out){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_40288 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40288[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_40288[(1)] = (1));

return statearr_40288;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_40269){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_40269);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40289){if((e40289 instanceof Object)){
var ex__37999__auto__ = e40289;
var statearr_40290_40307 = state_40269;
(statearr_40290_40307[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40269);

return cljs.core.cst$kw$recur;
} else {
throw e40289;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40308 = state_40269;
state_40269 = G__40308;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_40269){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_40269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___40296,out))
})();
var state__38111__auto__ = (function (){var statearr_40291 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40291[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___40296);

return statearr_40291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___40296,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async40318 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40318 = (function (map_LT_,f,ch,meta40319){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta40319 = meta40319;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40320,meta40319__$1){
var self__ = this;
var _40320__$1 = this;
return (new cljs.core.async.t_cljs$core$async40318(self__.map_LT_,self__.f,self__.ch,meta40319__$1));
});

cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40320){
var self__ = this;
var _40320__$1 = this;
return self__.meta40319;
});

cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async40321 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40321 = (function (map_LT_,f,ch,meta40319,_,fn1,meta40322){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta40319 = meta40319;
this._ = _;
this.fn1 = fn1;
this.meta40322 = meta40322;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async40321.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_40323,meta40322__$1){
var self__ = this;
var _40323__$1 = this;
return (new cljs.core.async.t_cljs$core$async40321(self__.map_LT_,self__.f,self__.ch,self__.meta40319,self__._,self__.fn1,meta40322__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async40321.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_40323){
var self__ = this;
var _40323__$1 = this;
return self__.meta40322;
});})(___$1))
;

cljs.core.async.t_cljs$core$async40321.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async40321.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async40321.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async40321.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__40309_SHARP_){
var G__40324 = (((p1__40309_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__40309_SHARP_) : self__.f.call(null,p1__40309_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__40324) : f1.call(null,G__40324));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async40321.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta40319,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async40318], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta40322], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async40321.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40321.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40321";

cljs.core.async.t_cljs$core$async40321.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async40321");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async40321 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async40321(map_LT___$1,f__$1,ch__$1,meta40319__$1,___$2,fn1__$1,meta40322){
return (new cljs.core.async.t_cljs$core$async40321(map_LT___$1,f__$1,ch__$1,meta40319__$1,___$2,fn1__$1,meta40322));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async40321(self__.map_LT_,self__.f,self__.ch,self__.meta40319,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6141__auto__ = ret;
if(cljs.core.truth_(and__6141__auto__)){
return !(((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret)) == null));
} else {
return and__6141__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__40325 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(ret) : cljs.core.deref.call(null,ret));
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__40325) : self__.f.call(null,G__40325));
})());
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async40318.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async40318.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_LT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta40319], null);
});

cljs.core.async.t_cljs$core$async40318.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40318.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40318";

cljs.core.async.t_cljs$core$async40318.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async40318");
});

cljs.core.async.__GT_t_cljs$core$async40318 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async40318(map_LT___$1,f__$1,ch__$1,meta40319){
return (new cljs.core.async.t_cljs$core$async40318(map_LT___$1,f__$1,ch__$1,meta40319));
});

}

return (new cljs.core.async.t_cljs$core$async40318(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async40329 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40329 = (function (map_GT_,f,ch,meta40330){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta40330 = meta40330;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async40329.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40331,meta40330__$1){
var self__ = this;
var _40331__$1 = this;
return (new cljs.core.async.t_cljs$core$async40329(self__.map_GT_,self__.f,self__.ch,meta40330__$1));
});

cljs.core.async.t_cljs$core$async40329.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40331){
var self__ = this;
var _40331__$1 = this;
return self__.meta40330;
});

cljs.core.async.t_cljs$core$async40329.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async40329.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async40329.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async40329.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async40329.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async40329.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
});

cljs.core.async.t_cljs$core$async40329.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$map_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta40330], null);
});

cljs.core.async.t_cljs$core$async40329.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40329.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40329";

cljs.core.async.t_cljs$core$async40329.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async40329");
});

cljs.core.async.__GT_t_cljs$core$async40329 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async40329(map_GT___$1,f__$1,ch__$1,meta40330){
return (new cljs.core.async.t_cljs$core$async40329(map_GT___$1,f__$1,ch__$1,meta40330));
});

}

return (new cljs.core.async.t_cljs$core$async40329(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async40335 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async40335 = (function (filter_GT_,p,ch,meta40336){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta40336 = meta40336;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_40337,meta40336__$1){
var self__ = this;
var _40337__$1 = this;
return (new cljs.core.async.t_cljs$core$async40335(self__.filter_GT_,self__.p,self__.ch,meta40336__$1));
});

cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_40337){
var self__ = this;
var _40337__$1 = this;
return self__.meta40336;
});

cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
});

cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
});

cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async40335.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
});

cljs.core.async.t_cljs$core$async40335.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(cljs.core.cst$sym$filter_GT_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$arglists,cljs.core.list(cljs.core.cst$sym$quote,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch], null))),cljs.core.cst$kw$doc,"Deprecated - this function will be removed. Use transducer instead"], null)),cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta40336], null);
});

cljs.core.async.t_cljs$core$async40335.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async40335.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async40335";

cljs.core.async.t_cljs$core$async40335.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"cljs.core.async/t_cljs$core$async40335");
});

cljs.core.async.__GT_t_cljs$core$async40335 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async40335(filter_GT___$1,p__$1,ch__$1,meta40336){
return (new cljs.core.async.t_cljs$core$async40335(filter_GT___$1,p__$1,ch__$1,meta40336));
});

}

return (new cljs.core.async.t_cljs$core$async40335(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args40338 = [];
var len__7211__auto___40382 = arguments.length;
var i__7212__auto___40383 = (0);
while(true){
if((i__7212__auto___40383 < len__7211__auto___40382)){
args40338.push((arguments[i__7212__auto___40383]));

var G__40384 = (i__7212__auto___40383 + (1));
i__7212__auto___40383 = G__40384;
continue;
} else {
}
break;
}

var G__40340 = args40338.length;
switch (G__40340) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40338.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__38109__auto___40386 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___40386,out){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___40386,out){
return (function (state_40361){
var state_val_40362 = (state_40361[(1)]);
if((state_val_40362 === (7))){
var inst_40357 = (state_40361[(2)]);
var state_40361__$1 = state_40361;
var statearr_40363_40387 = state_40361__$1;
(statearr_40363_40387[(2)] = inst_40357);

(statearr_40363_40387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40362 === (1))){
var state_40361__$1 = state_40361;
var statearr_40364_40388 = state_40361__$1;
(statearr_40364_40388[(2)] = null);

(statearr_40364_40388[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40362 === (4))){
var inst_40343 = (state_40361[(7)]);
var inst_40343__$1 = (state_40361[(2)]);
var inst_40344 = (inst_40343__$1 == null);
var state_40361__$1 = (function (){var statearr_40365 = state_40361;
(statearr_40365[(7)] = inst_40343__$1);

return statearr_40365;
})();
if(cljs.core.truth_(inst_40344)){
var statearr_40366_40389 = state_40361__$1;
(statearr_40366_40389[(1)] = (5));

} else {
var statearr_40367_40390 = state_40361__$1;
(statearr_40367_40390[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40362 === (6))){
var inst_40343 = (state_40361[(7)]);
var inst_40348 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_40343) : p.call(null,inst_40343));
var state_40361__$1 = state_40361;
if(cljs.core.truth_(inst_40348)){
var statearr_40368_40391 = state_40361__$1;
(statearr_40368_40391[(1)] = (8));

} else {
var statearr_40369_40392 = state_40361__$1;
(statearr_40369_40392[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40362 === (3))){
var inst_40359 = (state_40361[(2)]);
var state_40361__$1 = state_40361;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40361__$1,inst_40359);
} else {
if((state_val_40362 === (2))){
var state_40361__$1 = state_40361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40361__$1,(4),ch);
} else {
if((state_val_40362 === (11))){
var inst_40351 = (state_40361[(2)]);
var state_40361__$1 = state_40361;
var statearr_40370_40393 = state_40361__$1;
(statearr_40370_40393[(2)] = inst_40351);

(statearr_40370_40393[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40362 === (9))){
var state_40361__$1 = state_40361;
var statearr_40371_40394 = state_40361__$1;
(statearr_40371_40394[(2)] = null);

(statearr_40371_40394[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40362 === (5))){
var inst_40346 = cljs.core.async.close_BANG_(out);
var state_40361__$1 = state_40361;
var statearr_40372_40395 = state_40361__$1;
(statearr_40372_40395[(2)] = inst_40346);

(statearr_40372_40395[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40362 === (10))){
var inst_40354 = (state_40361[(2)]);
var state_40361__$1 = (function (){var statearr_40373 = state_40361;
(statearr_40373[(8)] = inst_40354);

return statearr_40373;
})();
var statearr_40374_40396 = state_40361__$1;
(statearr_40374_40396[(2)] = null);

(statearr_40374_40396[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40362 === (8))){
var inst_40343 = (state_40361[(7)]);
var state_40361__$1 = state_40361;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40361__$1,(11),out,inst_40343);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___40386,out))
;
return ((function (switch__37995__auto__,c__38109__auto___40386,out){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_40378 = [null,null,null,null,null,null,null,null,null];
(statearr_40378[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_40378[(1)] = (1));

return statearr_40378;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_40361){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_40361);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40379){if((e40379 instanceof Object)){
var ex__37999__auto__ = e40379;
var statearr_40380_40397 = state_40361;
(statearr_40380_40397[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40361);

return cljs.core.cst$kw$recur;
} else {
throw e40379;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40398 = state_40361;
state_40361 = G__40398;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_40361){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_40361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___40386,out))
})();
var state__38111__auto__ = (function (){var statearr_40381 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40381[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___40386);

return statearr_40381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___40386,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args40399 = [];
var len__7211__auto___40402 = arguments.length;
var i__7212__auto___40403 = (0);
while(true){
if((i__7212__auto___40403 < len__7211__auto___40402)){
args40399.push((arguments[i__7212__auto___40403]));

var G__40404 = (i__7212__auto___40403 + (1));
i__7212__auto___40403 = G__40404;
continue;
} else {
}
break;
}

var G__40401 = args40399.length;
switch (G__40401) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40399.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;
cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__){
return (function (state_40571){
var state_val_40572 = (state_40571[(1)]);
if((state_val_40572 === (7))){
var inst_40567 = (state_40571[(2)]);
var state_40571__$1 = state_40571;
var statearr_40573_40614 = state_40571__$1;
(statearr_40573_40614[(2)] = inst_40567);

(statearr_40573_40614[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (20))){
var inst_40537 = (state_40571[(7)]);
var inst_40548 = (state_40571[(2)]);
var inst_40549 = cljs.core.next(inst_40537);
var inst_40523 = inst_40549;
var inst_40524 = null;
var inst_40525 = (0);
var inst_40526 = (0);
var state_40571__$1 = (function (){var statearr_40574 = state_40571;
(statearr_40574[(8)] = inst_40548);

(statearr_40574[(9)] = inst_40524);

(statearr_40574[(10)] = inst_40526);

(statearr_40574[(11)] = inst_40525);

(statearr_40574[(12)] = inst_40523);

return statearr_40574;
})();
var statearr_40575_40615 = state_40571__$1;
(statearr_40575_40615[(2)] = null);

(statearr_40575_40615[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (1))){
var state_40571__$1 = state_40571;
var statearr_40576_40616 = state_40571__$1;
(statearr_40576_40616[(2)] = null);

(statearr_40576_40616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (4))){
var inst_40512 = (state_40571[(13)]);
var inst_40512__$1 = (state_40571[(2)]);
var inst_40513 = (inst_40512__$1 == null);
var state_40571__$1 = (function (){var statearr_40577 = state_40571;
(statearr_40577[(13)] = inst_40512__$1);

return statearr_40577;
})();
if(cljs.core.truth_(inst_40513)){
var statearr_40578_40617 = state_40571__$1;
(statearr_40578_40617[(1)] = (5));

} else {
var statearr_40579_40618 = state_40571__$1;
(statearr_40579_40618[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (15))){
var state_40571__$1 = state_40571;
var statearr_40583_40619 = state_40571__$1;
(statearr_40583_40619[(2)] = null);

(statearr_40583_40619[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (21))){
var state_40571__$1 = state_40571;
var statearr_40584_40620 = state_40571__$1;
(statearr_40584_40620[(2)] = null);

(statearr_40584_40620[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (13))){
var inst_40524 = (state_40571[(9)]);
var inst_40526 = (state_40571[(10)]);
var inst_40525 = (state_40571[(11)]);
var inst_40523 = (state_40571[(12)]);
var inst_40533 = (state_40571[(2)]);
var inst_40534 = (inst_40526 + (1));
var tmp40580 = inst_40524;
var tmp40581 = inst_40525;
var tmp40582 = inst_40523;
var inst_40523__$1 = tmp40582;
var inst_40524__$1 = tmp40580;
var inst_40525__$1 = tmp40581;
var inst_40526__$1 = inst_40534;
var state_40571__$1 = (function (){var statearr_40585 = state_40571;
(statearr_40585[(14)] = inst_40533);

(statearr_40585[(9)] = inst_40524__$1);

(statearr_40585[(10)] = inst_40526__$1);

(statearr_40585[(11)] = inst_40525__$1);

(statearr_40585[(12)] = inst_40523__$1);

return statearr_40585;
})();
var statearr_40586_40621 = state_40571__$1;
(statearr_40586_40621[(2)] = null);

(statearr_40586_40621[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (22))){
var state_40571__$1 = state_40571;
var statearr_40587_40622 = state_40571__$1;
(statearr_40587_40622[(2)] = null);

(statearr_40587_40622[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (6))){
var inst_40512 = (state_40571[(13)]);
var inst_40521 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_40512) : f.call(null,inst_40512));
var inst_40522 = cljs.core.seq(inst_40521);
var inst_40523 = inst_40522;
var inst_40524 = null;
var inst_40525 = (0);
var inst_40526 = (0);
var state_40571__$1 = (function (){var statearr_40588 = state_40571;
(statearr_40588[(9)] = inst_40524);

(statearr_40588[(10)] = inst_40526);

(statearr_40588[(11)] = inst_40525);

(statearr_40588[(12)] = inst_40523);

return statearr_40588;
})();
var statearr_40589_40623 = state_40571__$1;
(statearr_40589_40623[(2)] = null);

(statearr_40589_40623[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (17))){
var inst_40537 = (state_40571[(7)]);
var inst_40541 = cljs.core.chunk_first(inst_40537);
var inst_40542 = cljs.core.chunk_rest(inst_40537);
var inst_40543 = cljs.core.count(inst_40541);
var inst_40523 = inst_40542;
var inst_40524 = inst_40541;
var inst_40525 = inst_40543;
var inst_40526 = (0);
var state_40571__$1 = (function (){var statearr_40590 = state_40571;
(statearr_40590[(9)] = inst_40524);

(statearr_40590[(10)] = inst_40526);

(statearr_40590[(11)] = inst_40525);

(statearr_40590[(12)] = inst_40523);

return statearr_40590;
})();
var statearr_40591_40624 = state_40571__$1;
(statearr_40591_40624[(2)] = null);

(statearr_40591_40624[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (3))){
var inst_40569 = (state_40571[(2)]);
var state_40571__$1 = state_40571;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40571__$1,inst_40569);
} else {
if((state_val_40572 === (12))){
var inst_40557 = (state_40571[(2)]);
var state_40571__$1 = state_40571;
var statearr_40592_40625 = state_40571__$1;
(statearr_40592_40625[(2)] = inst_40557);

(statearr_40592_40625[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (2))){
var state_40571__$1 = state_40571;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40571__$1,(4),in$);
} else {
if((state_val_40572 === (23))){
var inst_40565 = (state_40571[(2)]);
var state_40571__$1 = state_40571;
var statearr_40593_40626 = state_40571__$1;
(statearr_40593_40626[(2)] = inst_40565);

(statearr_40593_40626[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (19))){
var inst_40552 = (state_40571[(2)]);
var state_40571__$1 = state_40571;
var statearr_40594_40627 = state_40571__$1;
(statearr_40594_40627[(2)] = inst_40552);

(statearr_40594_40627[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (11))){
var inst_40537 = (state_40571[(7)]);
var inst_40523 = (state_40571[(12)]);
var inst_40537__$1 = cljs.core.seq(inst_40523);
var state_40571__$1 = (function (){var statearr_40595 = state_40571;
(statearr_40595[(7)] = inst_40537__$1);

return statearr_40595;
})();
if(inst_40537__$1){
var statearr_40596_40628 = state_40571__$1;
(statearr_40596_40628[(1)] = (14));

} else {
var statearr_40597_40629 = state_40571__$1;
(statearr_40597_40629[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (9))){
var inst_40559 = (state_40571[(2)]);
var inst_40560 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_40571__$1 = (function (){var statearr_40598 = state_40571;
(statearr_40598[(15)] = inst_40559);

return statearr_40598;
})();
if(cljs.core.truth_(inst_40560)){
var statearr_40599_40630 = state_40571__$1;
(statearr_40599_40630[(1)] = (21));

} else {
var statearr_40600_40631 = state_40571__$1;
(statearr_40600_40631[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (5))){
var inst_40515 = cljs.core.async.close_BANG_(out);
var state_40571__$1 = state_40571;
var statearr_40601_40632 = state_40571__$1;
(statearr_40601_40632[(2)] = inst_40515);

(statearr_40601_40632[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (14))){
var inst_40537 = (state_40571[(7)]);
var inst_40539 = cljs.core.chunked_seq_QMARK_(inst_40537);
var state_40571__$1 = state_40571;
if(inst_40539){
var statearr_40602_40633 = state_40571__$1;
(statearr_40602_40633[(1)] = (17));

} else {
var statearr_40603_40634 = state_40571__$1;
(statearr_40603_40634[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (16))){
var inst_40555 = (state_40571[(2)]);
var state_40571__$1 = state_40571;
var statearr_40604_40635 = state_40571__$1;
(statearr_40604_40635[(2)] = inst_40555);

(statearr_40604_40635[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40572 === (10))){
var inst_40524 = (state_40571[(9)]);
var inst_40526 = (state_40571[(10)]);
var inst_40531 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_40524,inst_40526);
var state_40571__$1 = state_40571;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40571__$1,(13),out,inst_40531);
} else {
if((state_val_40572 === (18))){
var inst_40537 = (state_40571[(7)]);
var inst_40546 = cljs.core.first(inst_40537);
var state_40571__$1 = state_40571;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40571__$1,(20),out,inst_40546);
} else {
if((state_val_40572 === (8))){
var inst_40526 = (state_40571[(10)]);
var inst_40525 = (state_40571[(11)]);
var inst_40528 = (inst_40526 < inst_40525);
var inst_40529 = inst_40528;
var state_40571__$1 = state_40571;
if(cljs.core.truth_(inst_40529)){
var statearr_40605_40636 = state_40571__$1;
(statearr_40605_40636[(1)] = (10));

} else {
var statearr_40606_40637 = state_40571__$1;
(statearr_40606_40637[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto__))
;
return ((function (switch__37995__auto__,c__38109__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__37996__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__37996__auto____0 = (function (){
var statearr_40610 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40610[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__37996__auto__);

(statearr_40610[(1)] = (1));

return statearr_40610;
});
var cljs$core$async$mapcat_STAR__$_state_machine__37996__auto____1 = (function (state_40571){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_40571);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40611){if((e40611 instanceof Object)){
var ex__37999__auto__ = e40611;
var statearr_40612_40638 = state_40571;
(statearr_40612_40638[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40571);

return cljs.core.cst$kw$recur;
} else {
throw e40611;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40639 = state_40571;
state_40571 = G__40639;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__37996__auto__ = function(state_40571){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__37996__auto____1.call(this,state_40571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__37996__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__37996__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__))
})();
var state__38111__auto__ = (function (){var statearr_40613 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40613[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_40613;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__))
);

return c__38109__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args40640 = [];
var len__7211__auto___40643 = arguments.length;
var i__7212__auto___40644 = (0);
while(true){
if((i__7212__auto___40644 < len__7211__auto___40643)){
args40640.push((arguments[i__7212__auto___40644]));

var G__40645 = (i__7212__auto___40644 + (1));
i__7212__auto___40644 = G__40645;
continue;
} else {
}
break;
}

var G__40642 = args40640.length;
switch (G__40642) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40640.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args40647 = [];
var len__7211__auto___40650 = arguments.length;
var i__7212__auto___40651 = (0);
while(true){
if((i__7212__auto___40651 < len__7211__auto___40650)){
args40647.push((arguments[i__7212__auto___40651]));

var G__40652 = (i__7212__auto___40651 + (1));
i__7212__auto___40651 = G__40652;
continue;
} else {
}
break;
}

var G__40649 = args40647.length;
switch (G__40649) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40647.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args40654 = [];
var len__7211__auto___40705 = arguments.length;
var i__7212__auto___40706 = (0);
while(true){
if((i__7212__auto___40706 < len__7211__auto___40705)){
args40654.push((arguments[i__7212__auto___40706]));

var G__40707 = (i__7212__auto___40706 + (1));
i__7212__auto___40706 = G__40707;
continue;
} else {
}
break;
}

var G__40656 = args40654.length;
switch (G__40656) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40654.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__38109__auto___40709 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___40709,out){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___40709,out){
return (function (state_40680){
var state_val_40681 = (state_40680[(1)]);
if((state_val_40681 === (7))){
var inst_40675 = (state_40680[(2)]);
var state_40680__$1 = state_40680;
var statearr_40682_40710 = state_40680__$1;
(statearr_40682_40710[(2)] = inst_40675);

(statearr_40682_40710[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40681 === (1))){
var inst_40657 = null;
var state_40680__$1 = (function (){var statearr_40683 = state_40680;
(statearr_40683[(7)] = inst_40657);

return statearr_40683;
})();
var statearr_40684_40711 = state_40680__$1;
(statearr_40684_40711[(2)] = null);

(statearr_40684_40711[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40681 === (4))){
var inst_40660 = (state_40680[(8)]);
var inst_40660__$1 = (state_40680[(2)]);
var inst_40661 = (inst_40660__$1 == null);
var inst_40662 = cljs.core.not(inst_40661);
var state_40680__$1 = (function (){var statearr_40685 = state_40680;
(statearr_40685[(8)] = inst_40660__$1);

return statearr_40685;
})();
if(inst_40662){
var statearr_40686_40712 = state_40680__$1;
(statearr_40686_40712[(1)] = (5));

} else {
var statearr_40687_40713 = state_40680__$1;
(statearr_40687_40713[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40681 === (6))){
var state_40680__$1 = state_40680;
var statearr_40688_40714 = state_40680__$1;
(statearr_40688_40714[(2)] = null);

(statearr_40688_40714[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40681 === (3))){
var inst_40677 = (state_40680[(2)]);
var inst_40678 = cljs.core.async.close_BANG_(out);
var state_40680__$1 = (function (){var statearr_40689 = state_40680;
(statearr_40689[(9)] = inst_40677);

return statearr_40689;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_40680__$1,inst_40678);
} else {
if((state_val_40681 === (2))){
var state_40680__$1 = state_40680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40680__$1,(4),ch);
} else {
if((state_val_40681 === (11))){
var inst_40660 = (state_40680[(8)]);
var inst_40669 = (state_40680[(2)]);
var inst_40657 = inst_40660;
var state_40680__$1 = (function (){var statearr_40690 = state_40680;
(statearr_40690[(10)] = inst_40669);

(statearr_40690[(7)] = inst_40657);

return statearr_40690;
})();
var statearr_40691_40715 = state_40680__$1;
(statearr_40691_40715[(2)] = null);

(statearr_40691_40715[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40681 === (9))){
var inst_40660 = (state_40680[(8)]);
var state_40680__$1 = state_40680;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40680__$1,(11),out,inst_40660);
} else {
if((state_val_40681 === (5))){
var inst_40657 = (state_40680[(7)]);
var inst_40660 = (state_40680[(8)]);
var inst_40664 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40660,inst_40657);
var state_40680__$1 = state_40680;
if(inst_40664){
var statearr_40693_40716 = state_40680__$1;
(statearr_40693_40716[(1)] = (8));

} else {
var statearr_40694_40717 = state_40680__$1;
(statearr_40694_40717[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40681 === (10))){
var inst_40672 = (state_40680[(2)]);
var state_40680__$1 = state_40680;
var statearr_40695_40718 = state_40680__$1;
(statearr_40695_40718[(2)] = inst_40672);

(statearr_40695_40718[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40681 === (8))){
var inst_40657 = (state_40680[(7)]);
var tmp40692 = inst_40657;
var inst_40657__$1 = tmp40692;
var state_40680__$1 = (function (){var statearr_40696 = state_40680;
(statearr_40696[(7)] = inst_40657__$1);

return statearr_40696;
})();
var statearr_40697_40719 = state_40680__$1;
(statearr_40697_40719[(2)] = null);

(statearr_40697_40719[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___40709,out))
;
return ((function (switch__37995__auto__,c__38109__auto___40709,out){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_40701 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40701[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_40701[(1)] = (1));

return statearr_40701;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_40680){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_40680);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40702){if((e40702 instanceof Object)){
var ex__37999__auto__ = e40702;
var statearr_40703_40720 = state_40680;
(statearr_40703_40720[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40680);

return cljs.core.cst$kw$recur;
} else {
throw e40702;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40721 = state_40680;
state_40680 = G__40721;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_40680){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_40680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___40709,out))
})();
var state__38111__auto__ = (function (){var statearr_40704 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40704[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___40709);

return statearr_40704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___40709,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args40722 = [];
var len__7211__auto___40792 = arguments.length;
var i__7212__auto___40793 = (0);
while(true){
if((i__7212__auto___40793 < len__7211__auto___40792)){
args40722.push((arguments[i__7212__auto___40793]));

var G__40794 = (i__7212__auto___40793 + (1));
i__7212__auto___40793 = G__40794;
continue;
} else {
}
break;
}

var G__40724 = args40722.length;
switch (G__40724) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40722.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__38109__auto___40796 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___40796,out){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___40796,out){
return (function (state_40762){
var state_val_40763 = (state_40762[(1)]);
if((state_val_40763 === (7))){
var inst_40758 = (state_40762[(2)]);
var state_40762__$1 = state_40762;
var statearr_40764_40797 = state_40762__$1;
(statearr_40764_40797[(2)] = inst_40758);

(statearr_40764_40797[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (1))){
var inst_40725 = (new Array(n));
var inst_40726 = inst_40725;
var inst_40727 = (0);
var state_40762__$1 = (function (){var statearr_40765 = state_40762;
(statearr_40765[(7)] = inst_40726);

(statearr_40765[(8)] = inst_40727);

return statearr_40765;
})();
var statearr_40766_40798 = state_40762__$1;
(statearr_40766_40798[(2)] = null);

(statearr_40766_40798[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (4))){
var inst_40730 = (state_40762[(9)]);
var inst_40730__$1 = (state_40762[(2)]);
var inst_40731 = (inst_40730__$1 == null);
var inst_40732 = cljs.core.not(inst_40731);
var state_40762__$1 = (function (){var statearr_40767 = state_40762;
(statearr_40767[(9)] = inst_40730__$1);

return statearr_40767;
})();
if(inst_40732){
var statearr_40768_40799 = state_40762__$1;
(statearr_40768_40799[(1)] = (5));

} else {
var statearr_40769_40800 = state_40762__$1;
(statearr_40769_40800[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (15))){
var inst_40752 = (state_40762[(2)]);
var state_40762__$1 = state_40762;
var statearr_40770_40801 = state_40762__$1;
(statearr_40770_40801[(2)] = inst_40752);

(statearr_40770_40801[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (13))){
var state_40762__$1 = state_40762;
var statearr_40771_40802 = state_40762__$1;
(statearr_40771_40802[(2)] = null);

(statearr_40771_40802[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (6))){
var inst_40727 = (state_40762[(8)]);
var inst_40748 = (inst_40727 > (0));
var state_40762__$1 = state_40762;
if(cljs.core.truth_(inst_40748)){
var statearr_40772_40803 = state_40762__$1;
(statearr_40772_40803[(1)] = (12));

} else {
var statearr_40773_40804 = state_40762__$1;
(statearr_40773_40804[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (3))){
var inst_40760 = (state_40762[(2)]);
var state_40762__$1 = state_40762;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40762__$1,inst_40760);
} else {
if((state_val_40763 === (12))){
var inst_40726 = (state_40762[(7)]);
var inst_40750 = cljs.core.vec(inst_40726);
var state_40762__$1 = state_40762;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40762__$1,(15),out,inst_40750);
} else {
if((state_val_40763 === (2))){
var state_40762__$1 = state_40762;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40762__$1,(4),ch);
} else {
if((state_val_40763 === (11))){
var inst_40742 = (state_40762[(2)]);
var inst_40743 = (new Array(n));
var inst_40726 = inst_40743;
var inst_40727 = (0);
var state_40762__$1 = (function (){var statearr_40774 = state_40762;
(statearr_40774[(10)] = inst_40742);

(statearr_40774[(7)] = inst_40726);

(statearr_40774[(8)] = inst_40727);

return statearr_40774;
})();
var statearr_40775_40805 = state_40762__$1;
(statearr_40775_40805[(2)] = null);

(statearr_40775_40805[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (9))){
var inst_40726 = (state_40762[(7)]);
var inst_40740 = cljs.core.vec(inst_40726);
var state_40762__$1 = state_40762;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40762__$1,(11),out,inst_40740);
} else {
if((state_val_40763 === (5))){
var inst_40735 = (state_40762[(11)]);
var inst_40726 = (state_40762[(7)]);
var inst_40730 = (state_40762[(9)]);
var inst_40727 = (state_40762[(8)]);
var inst_40734 = (inst_40726[inst_40727] = inst_40730);
var inst_40735__$1 = (inst_40727 + (1));
var inst_40736 = (inst_40735__$1 < n);
var state_40762__$1 = (function (){var statearr_40776 = state_40762;
(statearr_40776[(12)] = inst_40734);

(statearr_40776[(11)] = inst_40735__$1);

return statearr_40776;
})();
if(cljs.core.truth_(inst_40736)){
var statearr_40777_40806 = state_40762__$1;
(statearr_40777_40806[(1)] = (8));

} else {
var statearr_40778_40807 = state_40762__$1;
(statearr_40778_40807[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (14))){
var inst_40755 = (state_40762[(2)]);
var inst_40756 = cljs.core.async.close_BANG_(out);
var state_40762__$1 = (function (){var statearr_40780 = state_40762;
(statearr_40780[(13)] = inst_40755);

return statearr_40780;
})();
var statearr_40781_40808 = state_40762__$1;
(statearr_40781_40808[(2)] = inst_40756);

(statearr_40781_40808[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (10))){
var inst_40746 = (state_40762[(2)]);
var state_40762__$1 = state_40762;
var statearr_40782_40809 = state_40762__$1;
(statearr_40782_40809[(2)] = inst_40746);

(statearr_40782_40809[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40763 === (8))){
var inst_40735 = (state_40762[(11)]);
var inst_40726 = (state_40762[(7)]);
var tmp40779 = inst_40726;
var inst_40726__$1 = tmp40779;
var inst_40727 = inst_40735;
var state_40762__$1 = (function (){var statearr_40783 = state_40762;
(statearr_40783[(7)] = inst_40726__$1);

(statearr_40783[(8)] = inst_40727);

return statearr_40783;
})();
var statearr_40784_40810 = state_40762__$1;
(statearr_40784_40810[(2)] = null);

(statearr_40784_40810[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___40796,out))
;
return ((function (switch__37995__auto__,c__38109__auto___40796,out){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_40788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40788[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_40788[(1)] = (1));

return statearr_40788;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_40762){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_40762);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40789){if((e40789 instanceof Object)){
var ex__37999__auto__ = e40789;
var statearr_40790_40811 = state_40762;
(statearr_40790_40811[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40762);

return cljs.core.cst$kw$recur;
} else {
throw e40789;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40812 = state_40762;
state_40762 = G__40812;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_40762){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_40762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___40796,out))
})();
var state__38111__auto__ = (function (){var statearr_40791 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40791[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___40796);

return statearr_40791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___40796,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args40813 = [];
var len__7211__auto___40887 = arguments.length;
var i__7212__auto___40888 = (0);
while(true){
if((i__7212__auto___40888 < len__7211__auto___40887)){
args40813.push((arguments[i__7212__auto___40888]));

var G__40889 = (i__7212__auto___40888 + (1));
i__7212__auto___40888 = G__40889;
continue;
} else {
}
break;
}

var G__40815 = args40813.length;
switch (G__40815) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args40813.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__38109__auto___40891 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___40891,out){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___40891,out){
return (function (state_40857){
var state_val_40858 = (state_40857[(1)]);
if((state_val_40858 === (7))){
var inst_40853 = (state_40857[(2)]);
var state_40857__$1 = state_40857;
var statearr_40859_40892 = state_40857__$1;
(statearr_40859_40892[(2)] = inst_40853);

(statearr_40859_40892[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (1))){
var inst_40816 = [];
var inst_40817 = inst_40816;
var inst_40818 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_40857__$1 = (function (){var statearr_40860 = state_40857;
(statearr_40860[(7)] = inst_40817);

(statearr_40860[(8)] = inst_40818);

return statearr_40860;
})();
var statearr_40861_40893 = state_40857__$1;
(statearr_40861_40893[(2)] = null);

(statearr_40861_40893[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (4))){
var inst_40821 = (state_40857[(9)]);
var inst_40821__$1 = (state_40857[(2)]);
var inst_40822 = (inst_40821__$1 == null);
var inst_40823 = cljs.core.not(inst_40822);
var state_40857__$1 = (function (){var statearr_40862 = state_40857;
(statearr_40862[(9)] = inst_40821__$1);

return statearr_40862;
})();
if(inst_40823){
var statearr_40863_40894 = state_40857__$1;
(statearr_40863_40894[(1)] = (5));

} else {
var statearr_40864_40895 = state_40857__$1;
(statearr_40864_40895[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (15))){
var inst_40847 = (state_40857[(2)]);
var state_40857__$1 = state_40857;
var statearr_40865_40896 = state_40857__$1;
(statearr_40865_40896[(2)] = inst_40847);

(statearr_40865_40896[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (13))){
var state_40857__$1 = state_40857;
var statearr_40866_40897 = state_40857__$1;
(statearr_40866_40897[(2)] = null);

(statearr_40866_40897[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (6))){
var inst_40817 = (state_40857[(7)]);
var inst_40842 = inst_40817.length;
var inst_40843 = (inst_40842 > (0));
var state_40857__$1 = state_40857;
if(cljs.core.truth_(inst_40843)){
var statearr_40867_40898 = state_40857__$1;
(statearr_40867_40898[(1)] = (12));

} else {
var statearr_40868_40899 = state_40857__$1;
(statearr_40868_40899[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (3))){
var inst_40855 = (state_40857[(2)]);
var state_40857__$1 = state_40857;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40857__$1,inst_40855);
} else {
if((state_val_40858 === (12))){
var inst_40817 = (state_40857[(7)]);
var inst_40845 = cljs.core.vec(inst_40817);
var state_40857__$1 = state_40857;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40857__$1,(15),out,inst_40845);
} else {
if((state_val_40858 === (2))){
var state_40857__$1 = state_40857;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40857__$1,(4),ch);
} else {
if((state_val_40858 === (11))){
var inst_40821 = (state_40857[(9)]);
var inst_40825 = (state_40857[(10)]);
var inst_40835 = (state_40857[(2)]);
var inst_40836 = [];
var inst_40837 = inst_40836.push(inst_40821);
var inst_40817 = inst_40836;
var inst_40818 = inst_40825;
var state_40857__$1 = (function (){var statearr_40869 = state_40857;
(statearr_40869[(11)] = inst_40835);

(statearr_40869[(12)] = inst_40837);

(statearr_40869[(7)] = inst_40817);

(statearr_40869[(8)] = inst_40818);

return statearr_40869;
})();
var statearr_40870_40900 = state_40857__$1;
(statearr_40870_40900[(2)] = null);

(statearr_40870_40900[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (9))){
var inst_40817 = (state_40857[(7)]);
var inst_40833 = cljs.core.vec(inst_40817);
var state_40857__$1 = state_40857;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_40857__$1,(11),out,inst_40833);
} else {
if((state_val_40858 === (5))){
var inst_40821 = (state_40857[(9)]);
var inst_40818 = (state_40857[(8)]);
var inst_40825 = (state_40857[(10)]);
var inst_40825__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_40821) : f.call(null,inst_40821));
var inst_40826 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_40825__$1,inst_40818);
var inst_40827 = cljs.core.keyword_identical_QMARK_(inst_40818,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var inst_40828 = (inst_40826) || (inst_40827);
var state_40857__$1 = (function (){var statearr_40871 = state_40857;
(statearr_40871[(10)] = inst_40825__$1);

return statearr_40871;
})();
if(cljs.core.truth_(inst_40828)){
var statearr_40872_40901 = state_40857__$1;
(statearr_40872_40901[(1)] = (8));

} else {
var statearr_40873_40902 = state_40857__$1;
(statearr_40873_40902[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (14))){
var inst_40850 = (state_40857[(2)]);
var inst_40851 = cljs.core.async.close_BANG_(out);
var state_40857__$1 = (function (){var statearr_40875 = state_40857;
(statearr_40875[(13)] = inst_40850);

return statearr_40875;
})();
var statearr_40876_40903 = state_40857__$1;
(statearr_40876_40903[(2)] = inst_40851);

(statearr_40876_40903[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (10))){
var inst_40840 = (state_40857[(2)]);
var state_40857__$1 = state_40857;
var statearr_40877_40904 = state_40857__$1;
(statearr_40877_40904[(2)] = inst_40840);

(statearr_40877_40904[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40858 === (8))){
var inst_40821 = (state_40857[(9)]);
var inst_40817 = (state_40857[(7)]);
var inst_40825 = (state_40857[(10)]);
var inst_40830 = inst_40817.push(inst_40821);
var tmp40874 = inst_40817;
var inst_40817__$1 = tmp40874;
var inst_40818 = inst_40825;
var state_40857__$1 = (function (){var statearr_40878 = state_40857;
(statearr_40878[(7)] = inst_40817__$1);

(statearr_40878[(14)] = inst_40830);

(statearr_40878[(8)] = inst_40818);

return statearr_40878;
})();
var statearr_40879_40905 = state_40857__$1;
(statearr_40879_40905[(2)] = null);

(statearr_40879_40905[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___40891,out))
;
return ((function (switch__37995__auto__,c__38109__auto___40891,out){
return (function() {
var cljs$core$async$state_machine__37996__auto__ = null;
var cljs$core$async$state_machine__37996__auto____0 = (function (){
var statearr_40883 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40883[(0)] = cljs$core$async$state_machine__37996__auto__);

(statearr_40883[(1)] = (1));

return statearr_40883;
});
var cljs$core$async$state_machine__37996__auto____1 = (function (state_40857){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_40857);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e40884){if((e40884 instanceof Object)){
var ex__37999__auto__ = e40884;
var statearr_40885_40906 = state_40857;
(statearr_40885_40906[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_40857);

return cljs.core.cst$kw$recur;
} else {
throw e40884;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__40907 = state_40857;
state_40857 = G__40907;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
cljs$core$async$state_machine__37996__auto__ = function(state_40857){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__37996__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__37996__auto____1.call(this,state_40857);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__37996__auto____0;
cljs$core$async$state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__37996__auto____1;
return cljs$core$async$state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___40891,out))
})();
var state__38111__auto__ = (function (){var statearr_40886 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_40886[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___40891);

return statearr_40886;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___40891,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;
