// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('org.nfrac.comportex.cells');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('org.nfrac.comportex.protocols');
goog.require('org.nfrac.comportex.synapses');
goog.require('org.nfrac.comportex.columns');
goog.require('org.nfrac.comportex.topology');
goog.require('clojure.test.check.random');
goog.require('org.nfrac.comportex.util');
goog.require('org.nfrac.comportex.inhibition');
/**
 * Default parameters for distal dendrite segments. The
 *   same parameters are also used for proximal segments, but with
 *   different default values.
 * 
 *   * `max-segments` - maximum number of dendrites segments per cell (or
 *   column for proximal dendrites).
 * 
 *   * `max-synapse-count` - maximum number of synapses per segment.
 * 
 *   * `new-synapse-count` - number of synapses on a new dendrite
 *   segment.
 * 
 *   * `stimulus-threshold` - minimum number of active synapses on a
 *   segment for it to become active.
 * 
 *   * `learn-threshold` - minimum number of active synapses on a segment
 *   for it to be reinforced and extended if it is the best matching.
 * 
 *   * `perm-inc` - amount by which to increase synapse permanence to
 *   active sources when reinforcing a segment.
 * 
 *   * `perm-stable-inc` - amount by which to increase a synapse
 *   permanence to stable (predicted) sources.
 * 
 *   * `perm-dec` - amount by which to decrease synapse permanence to
 *   inactive sources when reinforcing a segment.
 * 
 *   * `perm-punish` - amount by which to decrease synapse permanence
 *   when punishing segments in case of failed prediction.
 * 
 *   * `perm-connected` - permanence value at which a synapse is
 *   functionally connected. Permanence values are defined to be between
 *   0 and 1.
 * 
 *   * `perm-init` - permanence value for new synapses on segments.
 * 
 *   * `punish?` - whether to reduce synapse permanence on segments
 *   incorrectly predicting activation.
 * 
 *   * `learn?` - whether to reinforce and grow synapses.
 */
org.nfrac.comportex.cells.dendrite_parameter_defaults = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$perm_DASH_connected,cljs.core.cst$kw$perm_DASH_punish,cljs.core.cst$kw$max_DASH_synapse_DASH_count,cljs.core.cst$kw$max_DASH_segments,cljs.core.cst$kw$perm_DASH_init,cljs.core.cst$kw$new_DASH_synapse_DASH_count,cljs.core.cst$kw$stimulus_DASH_threshold,cljs.core.cst$kw$punish_QMARK_,cljs.core.cst$kw$learn_QMARK_,cljs.core.cst$kw$perm_DASH_dec,cljs.core.cst$kw$learn_DASH_threshold,cljs.core.cst$kw$perm_DASH_inc,cljs.core.cst$kw$perm_DASH_stable_DASH_inc],[0.2,0.002,(22),(5),0.16,(12),(9),true,true,0.01,(7),0.05,0.05]);
/**
 * Default parameter specification map.
 * 
 *   * `input-dimensions` - size of input bit grid as a vector, one
 *   dimensional `[size]`, two dimensional `[width height]`, etc.
 * 
 *   * `column-dimensions` - size of column field as a vector, one
 *   dimensional `[size]` or two dimensional `[width height]`.
 * 
 *   * `ff-potential-radius` - range of potential feed-forward synapse
 *   connections, as a fraction of the longest single dimension in the
 *   input space.
 * 
 *   * `ff-init-frac` - fraction of inputs within radius that will be
 *   part of the initially connected set.
 * 
 *   * `ff-perm-init-hi` - highest initial permanence value on new synapses.
 * 
 *   * `ff-perm-init-lo` - lowest initial permanence value on new synapses.
 * 
 *   * `proximal` - map of parameters for proximal dendrite segments,
 *   see `dendrite-parameter-defaults`.
 * 
 *   *  `distal` - map of parameters for distal dendrite segments,
 *   see `dendrite-parameter-defaults`.
 * 
 *   *  `apical` - map of parameters for apical dendrite segments,
 *   see `dendrite-parameter-defaults`. Ignored unless :use-feedback?
 * 
 *   * `max-boost` - ceiling on the column boosting factor used to
 *   increase activation frequency.
 * 
 *   * `duty-cycle-period` - number of time steps to average over when
 *   updating duty cycles and (thereby) column boosting measures.
 * 
 *   * `boost-active-duty-ratio` - when a column's activation frequency
 *   is below this proportion of the _highest_ of its neighbours, its
 *   boost factor is increased.
 * 
 *   * `adjust-overlap-duty-ratio` - when a column's overlap frequency
 *   differs from any of its neighbours by at least this fraction, its
 *   permanences are adjusted.
 * 
 *   *  `boost-active-every` - number of time steps between recalculating
 *   column boosting factors.
 * 
 *   *  `adjust-overlap-every` - number of time steps between adjusting
 *   column permanences to stabilise overlap frequencies.
 * 
 *   * `inh-radius-every` - number of time steps between recalculating
 *   the effective inhibition radius.
 * 
 *   * `lateral-synapses?` - whether distal synapses can connect
 *   laterally to other cells in this layer.
 * 
 *   * `use-feedback?` - whether distal synapses can connect to top-down
 *   feedback cells.
 * 
 *   * `distal-motor-dimensions` - defines bit field available for
 *   feed-forward motor input to distal synapses.
 * 
 *   * `distal-topdown-dimensions` - defines bit field available for
 *   top-down feedback to distal synapses.
 * 
 *   * `depth` - number of cells per column.
 * 
 *   * `activation-level` - fraction of columns that can be
 *   active (either locally or globally); inhibition kicks in to reduce
 *   it to this level.
 * 
 *   * `inhibition-base-distance` - the distance in columns within which
 *   a cell *will always* inhibit neighbouring cells with lower
 *   excitation. Used by `:spatial-pooling :local-inhibition`.
 * 
 *   * `distal-vs-proximal-weight` - scaling to apply to the number of
 *   active distal synapses (on the winning segment) before adding to the
 *   number of active proximal synapses, when selecting active
 *   columns. Set to zero to disable ``prediction-assisted'' activation.
 * 
 *   * `apical-bias-frac` - probability of choosing a winner cell
 *   according to apical excitation when otherwise the choice would have
 *   been random. Generates similarity between cases in similar contexts.
 * 
 *   * `spontaneous-activation?` - if true, cells may become active with
 *   sufficient distal synapse excitation, even in the absence of any
 *   proximal synapse excitation.
 * 
 *   * `dominance-margin` - an amount of excitation (generally measured
 *   in number of active synapses) by which one cell must exceed all
 *   others in the column to be considered dominant. And therefore to
 *   inhibit all other cells in the column.
 * 
 *   * `stable-activation-steps` - number of time steps that synapses
 *   remain active from cells whose activation was predicted and thus
 *   generated minibursts to metabotropic receptors. They might be
 *   curtailed earlier by a manual break.
 * 
 *   * `transition-similarity` - effective time steps are delayed until
 *   the similarity (normalised column overlap) between successive states
 *   falls below this level. So 1.0 means every time step is effective -
 *   the usual behaviour.
 * 
 *   * `random-seed` - the random seed (for reproducible results).
 * 
 *   * `spatial-pooling` - keyword to look up a spatial pooling
 *   implementation of the multimethod
 *   `org.nfrac.comportex.cells/spatial-pooling`.
 *   An alternative is `:local-inhibition`, implemented in this namespace.
 * 
 *   * `temporal-pooling` - keyword to look up a temporal pooling
 *   implementation of the multimethod
 *   `org.nfrac.comportex.cells/temporal-pooling`.
 */
org.nfrac.comportex.cells.parameter_defaults = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$spatial_DASH_pooling,cljs.core.cst$kw$ff_DASH_perm_DASH_init_DASH_hi,cljs.core.cst$kw$ilateral,cljs.core.cst$kw$ff_DASH_perm_DASH_init_DASH_lo,cljs.core.cst$kw$temporal_DASH_pooling,cljs.core.cst$kw$boost_DASH_active_DASH_duty_DASH_ratio,cljs.core.cst$kw$lateral_DASH_synapses_QMARK_,cljs.core.cst$kw$random_DASH_seed,cljs.core.cst$kw$column_DASH_dimensions,cljs.core.cst$kw$adjust_DASH_overlap_DASH_every,cljs.core.cst$kw$distal_DASH_vs_DASH_proximal_DASH_weight,cljs.core.cst$kw$ff_DASH_init_DASH_frac,cljs.core.cst$kw$float_DASH_overlap_DASH_duty_DASH_ratio,cljs.core.cst$kw$distal,cljs.core.cst$kw$float_DASH_overlap_DASH_every,cljs.core.cst$kw$distal_DASH_topdown_DASH_dimensions,cljs.core.cst$kw$float_DASH_overlap_DASH_duty_DASH_ratio_DASH_hi,cljs.core.cst$kw$use_DASH_feedback_QMARK_,cljs.core.cst$kw$distal_DASH_motor_DASH_dimensions,cljs.core.cst$kw$inh_DASH_radius_DASH_scale,cljs.core.cst$kw$boost_DASH_active_DASH_every,cljs.core.cst$kw$max_DASH_boost,cljs.core.cst$kw$ff_DASH_potential_DASH_radius,cljs.core.cst$kw$activation_DASH_level,cljs.core.cst$kw$proximal,cljs.core.cst$kw$stable_DASH_activation_DASH_steps,cljs.core.cst$kw$input_DASH_dimensions,cljs.core.cst$kw$depth,cljs.core.cst$kw$inhibition_DASH_base_DASH_distance,cljs.core.cst$kw$apical,cljs.core.cst$kw$transition_DASH_similarity,cljs.core.cst$kw$apical_DASH_bias_DASH_frac,cljs.core.cst$kw$duty_DASH_cycle_DASH_period,cljs.core.cst$kw$dominance_DASH_margin,cljs.core.cst$kw$spontaneous_DASH_activation_QMARK_,cljs.core.cst$kw$adjust_DASH_overlap_DASH_duty_DASH_ratio,cljs.core.cst$kw$inh_DASH_radius_DASH_every],[cljs.core.cst$kw$standard,0.25,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$perm_DASH_connected,cljs.core.cst$kw$max_DASH_synapse_DASH_count,cljs.core.cst$kw$max_DASH_segments,cljs.core.cst$kw$perm_DASH_init,cljs.core.cst$kw$new_DASH_synapse_DASH_count,cljs.core.cst$kw$stimulus_DASH_threshold,cljs.core.cst$kw$learn_QMARK_,cljs.core.cst$kw$perm_DASH_dec,cljs.core.cst$kw$perm_DASH_inc],[0.5,(22),(1),0.08,(12),(1),false,0.01,0.08]),0.1,cljs.core.cst$kw$standard,(1.0 / (200)),true,(42),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(1000)], null),(300),0.0,0.25,0.1,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(org.nfrac.comportex.cells.dendrite_parameter_defaults,cljs.core.cst$kw$learn_QMARK_,true),(100),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),10.0,false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),1.0,(100),1.5,1.0,0.02,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$perm_DASH_connected,cljs.core.cst$kw$perm_DASH_punish,cljs.core.cst$kw$max_DASH_synapse_DASH_count,cljs.core.cst$kw$max_DASH_segments,cljs.core.cst$kw$perm_DASH_init,cljs.core.cst$kw$new_DASH_synapse_DASH_count,cljs.core.cst$kw$stimulus_DASH_threshold,cljs.core.cst$kw$punish_QMARK_,cljs.core.cst$kw$grow_QMARK_,cljs.core.cst$kw$learn_QMARK_,cljs.core.cst$kw$perm_DASH_dec,cljs.core.cst$kw$learn_DASH_threshold,cljs.core.cst$kw$perm_DASH_inc,cljs.core.cst$kw$perm_DASH_stable_DASH_inc],[0.2,0.002,(300),(1),0.25,(12),(2),false,false,true,0.01,(7),0.04,0.15]),(5),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$define_DASH_me_BANG_], null),(5),(1),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(org.nfrac.comportex.cells.dendrite_parameter_defaults,cljs.core.cst$kw$learn_QMARK_,false),1.0,0.0,(1000),(4),false,(1.0 / (100)),(1000)]);
org.nfrac.comportex.cells.better_parameter_defaults = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(org.nfrac.comportex.cells.parameter_defaults,cljs.core.cst$kw$column_DASH_dimensions,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2048)], null),cljs.core.array_seq([cljs.core.cst$kw$depth,(16),cljs.core.cst$kw$distal,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(org.nfrac.comportex.cells.dendrite_parameter_defaults,cljs.core.cst$kw$max_DASH_segments,(8),cljs.core.array_seq([cljs.core.cst$kw$max_DASH_synapse_DASH_count,(32),cljs.core.cst$kw$new_DASH_synapse_DASH_count,(20),cljs.core.cst$kw$stimulus_DASH_threshold,(13),cljs.core.cst$kw$learn_DASH_threshold,(10)], 0))], 0));
org.nfrac.comportex.cells.distal_sources_widths = (function org$nfrac$comportex$cells$distal_sources_widths(spec){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(cljs.core.cst$kw$lateral_DASH_synapses_QMARK_.cljs$core$IFn$_invoke$arity$1(spec))?cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._STAR_,cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$column_DASH_dimensions.cljs$core$IFn$_invoke$arity$1(spec)):(0)),cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,cljs.core.cst$kw$distal_DASH_motor_DASH_dimensions.cljs$core$IFn$_invoke$arity$1(spec))], null);
});
org.nfrac.comportex.cells.cell__GT_id = (function org$nfrac$comportex$cells$cell__GT_id(depth,p__36636){
var vec__36638 = p__36636;
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36638,(0),null);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36638,(1),null);
return ((col * depth) + ci);
});
org.nfrac.comportex.cells.cells__GT_bits = (function org$nfrac$comportex$cells$cells__GT_bits(depth,cells){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(org.nfrac.comportex.cells.cell__GT_id,depth),cells);
});
org.nfrac.comportex.cells.id__GT_cell = (function org$nfrac$comportex$cells$id__GT_cell(depth,id){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.quot(id,depth),cljs.core.rem(id,depth)], null);
});
/**
 * Returns a vector [k v] where k is one of :this or :ff. In the
 * case of :this, v is [col ci], otherwise v gives the index in the
 * feed-forward distal input field.
 */
org.nfrac.comportex.cells.id__GT_source = (function org$nfrac$comportex$cells$id__GT_source(spec,id){
var vec__36640 = org.nfrac.comportex.cells.distal_sources_widths(spec);
var this_w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36640,(0),null);
var ff_w = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36640,(1),null);
if((id < this_w)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$this,org.nfrac.comportex.cells.id__GT_cell(cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(spec),id)], null);
} else {
if((id < (this_w + ff_w))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ff,(id - this_w)], null);
} else {
return null;
}
}
});
/**
 * Returns the number of active cells to which the synapses are
 *   connected, i.e. where synapse permanence is equal to or greater than
 *   `pcon`.
 */
org.nfrac.comportex.cells.segment_activation = (function org$nfrac$comportex$cells$segment_activation(syns,active_bits,pcon){
return org.nfrac.comportex.util.count_filter((function (p__36643){
var vec__36644 = p__36643;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36644,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36644,(1),null);
var and__6141__auto__ = (p >= pcon);
if(and__6141__auto__){
return (active_bits.cljs$core$IFn$_invoke$arity$1 ? active_bits.cljs$core$IFn$_invoke$arity$1(id) : active_bits.call(null,id));
} else {
return and__6141__auto__;
}
}),syns);
});
/**
 * Returns a seq of the segment indexes in the cell with activation at
 *   or above the activation threshold `th`, only considering synapses
 *   with permanence values at or above `pcon`.
 */
org.nfrac.comportex.cells.cell_active_segments = (function org$nfrac$comportex$cells$cell_active_segments(cell_segs,active_bits,th,pcon){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (si,syns){
var act = org.nfrac.comportex.cells.segment_activation(syns,active_bits,pcon);
if((act >= th)){
return si;
} else {
return null;
}
}),cell_segs);
});
/**
 * Finds the segment in the cell having the most active synapses, as
 *   long as is above the activation threshold `min-act`, only considering
 *   synapses with permanence values at or above `pcon`.
 *   Returns
 *   `[seg-index activation synapses]`. If no such segments exist,
 *   returns `[nil 0 {}]`.
 */
org.nfrac.comportex.cells.best_matching_segment = (function org$nfrac$comportex$cells$best_matching_segment(cell_segs,active_bits,min_act,pcon){
var segs = cljs.core.seq(cell_segs);
var si = (0);
var best_si = (0);
var best_act = (0);
var best_syns = null;
while(true){
var temp__4655__auto__ = cljs.core.first(segs);
if(cljs.core.truth_(temp__4655__auto__)){
var syns = temp__4655__auto__;
var act = cljs.core.long$(org.nfrac.comportex.cells.segment_activation(syns,active_bits,pcon));
var best_QMARK_ = (act > best_act);
var G__36645 = cljs.core.next(segs);
var G__36646 = (si + (1));
var G__36647 = ((best_QMARK_)?si:best_si);
var G__36648 = ((best_QMARK_)?act:best_act);
var G__36649 = ((best_QMARK_)?syns:best_syns);
segs = G__36645;
si = G__36646;
best_si = G__36647;
best_act = G__36648;
best_syns = G__36649;
continue;
} else {
if((best_act >= min_act)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [best_si,best_act,best_syns], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,(0),cljs.core.PersistentArrayMap.EMPTY], null);
}
}
break;
}
});
/**
 * Finds the most excited dendrite segment for each cell. Returns
 *   `[cell-exc cell-seg-exc]` where
 * 
 *   * cell-exc is a map from cell-id to best excitation value.
 *   * cell-seg-exc is a map from cell-id to best [seg-path exc].
 */
org.nfrac.comportex.cells.best_segment_excitations_and_paths = (function org$nfrac$comportex$cells$best_segment_excitations_and_paths(seg_exc){
var seg_exc__$1 = cljs.core.seq(seg_exc);
var excs = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var paths = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
var temp__4655__auto__ = cljs.core.first(seg_exc__$1);
if(cljs.core.truth_(temp__4655__auto__)){
var vec__36651 = temp__4655__auto__;
var path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36651,(0),null);
var exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36651,(1),null);
var id = cljs.core.pop(path);
var prev_exc = cljs.core.get.cljs$core$IFn$_invoke$arity$3(excs,id,0.0);
if((exc > prev_exc)){
var G__36652 = cljs.core.next(seg_exc__$1);
var G__36653 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(excs,id,exc);
var G__36654 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(paths,id,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,exc], null));
seg_exc__$1 = G__36652;
excs = G__36653;
paths = G__36654;
continue;
} else {
var G__36655 = cljs.core.next(seg_exc__$1);
var G__36656 = excs;
var G__36657 = paths;
seg_exc__$1 = G__36655;
excs = G__36656;
paths = G__36657;
continue;
}
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.persistent_BANG_(excs),cljs.core.persistent_BANG_(paths)], null);
}
break;
}
});
/**
 * Returns a map of column ids to representative excitation values,
 *   being the greatest excitation of its constituent cells or segments.
 */
org.nfrac.comportex.cells.best_by_column = (function org$nfrac$comportex$cells$best_by_column(cell_exc){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,id,exc){
var vec__36659 = id;
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36659,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36659,(1),null);
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,col,(function (){var x__6484__auto__ = exc;
var y__6485__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m,col,0.0);
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})());
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),cell_exc));
});
/**
 * Combine the proximal and distal excitations in a map of cell id to
 *   excitation, as a weighted sum. Normally only cells with some
 *   proximal input are included, but if `spontaneous-activation?` is
 *   true, this is relaxed (i.e. prediction alone could cause
 *   activation).
 * 
 *   * col-exc is keyed by column as [col 0].
 */
org.nfrac.comportex.cells.total_excitations = (function org$nfrac$comportex$cells$total_excitations(col_exc,distal_exc,distal_weight,spontaneous_activation_QMARK_,depth){
var basic_exc = (function (){var iter__6925__auto__ = (function org$nfrac$comportex$cells$total_excitations_$_iter__36677(s__36678){
return (new cljs.core.LazySeq(null,(function (){
var s__36678__$1 = s__36678;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36678__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var vec__36688 = cljs.core.first(xs__5205__auto__);
var vec__36689 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36688,(0),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36689,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36689,(1),null);
var exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36688,(1),null);
var iterys__6921__auto__ = ((function (s__36678__$1,vec__36688,vec__36689,col,_,exc,xs__5205__auto__,temp__4657__auto__){
return (function org$nfrac$comportex$cells$total_excitations_$_iter__36677_$_iter__36679(s__36680){
return (new cljs.core.LazySeq(null,((function (s__36678__$1,vec__36688,vec__36689,col,_,exc,xs__5205__auto__,temp__4657__auto__){
return (function (){
var s__36680__$1 = s__36680;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__36680__$1);
if(temp__4657__auto____$1){
var s__36680__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__36680__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__36680__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__36682 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__36681 = (0);
while(true){
if((i__36681 < size__6924__auto__)){
var ci = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__36681);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
cljs.core.chunk_append(b__36682,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cell_id,exc], null));

var G__36694 = (i__36681 + (1));
i__36681 = G__36694;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36682),org$nfrac$comportex$cells$total_excitations_$_iter__36677_$_iter__36679(cljs.core.chunk_rest(s__36680__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36682),null);
}
} else {
var ci = cljs.core.first(s__36680__$2);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cell_id,exc], null),org$nfrac$comportex$cells$total_excitations_$_iter__36677_$_iter__36679(cljs.core.rest(s__36680__$2)));
}
} else {
return null;
}
break;
}
});})(s__36678__$1,vec__36688,vec__36689,col,_,exc,xs__5205__auto__,temp__4657__auto__))
,null,null));
});})(s__36678__$1,vec__36688,vec__36689,col,_,exc,xs__5205__auto__,temp__4657__auto__))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(depth)));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$nfrac$comportex$cells$total_excitations_$_iter__36677(cljs.core.rest(s__36678__$1)));
} else {
var G__36695 = cljs.core.rest(s__36678__$1);
s__36678__$1 = G__36695;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6925__auto__(col_exc);
})();
if((distal_weight === (0))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,basic_exc);
} else {
var basic_exc__$1 = (cljs.core.truth_(spontaneous_activation_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.zipmap(cljs.core.keys(distal_exc),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(0.0)),basic_exc):basic_exc);
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (basic_exc__$1,basic_exc){
return (function (m,p__36692){
var vec__36693 = p__36692;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36693,(0),null);
var p_exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36693,(1),null);
var d_exc = (distal_exc.cljs$core$IFn$_invoke$arity$2 ? distal_exc.cljs$core$IFn$_invoke$arity$2(id,0.0) : distal_exc.call(null,id,0.0));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,id,(p_exc + (distal_weight * d_exc)));
});})(basic_exc__$1,basic_exc))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),basic_exc__$1));
}
});
/**
 * Returns a sequence of cell ids to become active in the column.
 *   If no cells have excitation over the threshold, then all become
 *   active (bursting). Otherwise, only cells above the threshold become
 *   active; but if the top excitation exceeds all others by at least
 *   `dominance-margin` then the others are inhibited even if they are
 *   over the threshold.
 */
org.nfrac.comportex.cells.column_active_cells = (function org$nfrac$comportex$cells$column_active_cells(col,cell_exc,depth,threshold,dominance_margin){
var cell_ids = (function (){var iter__6925__auto__ = (function org$nfrac$comportex$cells$column_active_cells_$_iter__36702(s__36703){
return (new cljs.core.LazySeq(null,(function (){
var s__36703__$1 = s__36703;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36703__$1);
if(temp__4657__auto__){
var s__36703__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36703__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__36703__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__36705 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__36704 = (0);
while(true){
if((i__36704 < size__6924__auto__)){
var ci = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__36704);
cljs.core.chunk_append(b__36705,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null));

var G__36708 = (i__36704 + (1));
i__36704 = G__36708;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36705),org$nfrac$comportex$cells$column_active_cells_$_iter__36702(cljs.core.chunk_rest(s__36703__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36705),null);
}
} else {
var ci = cljs.core.first(s__36703__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null),org$nfrac$comportex$cells$column_active_cells_$_iter__36702(cljs.core.rest(s__36703__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6925__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(depth));
})();
var ids = cell_ids;
var best_ids = cljs.core.List.EMPTY;
var best_exc = -99999.9;
var good_ids = cljs.core.List.EMPTY;
var second_exc = threshold;
while(true){
var temp__4655__auto__ = cljs.core.first(ids);
if(cljs.core.truth_(temp__4655__auto__)){
var id = temp__4655__auto__;
var exc = (cell_exc.cljs$core$IFn$_invoke$arity$2 ? cell_exc.cljs$core$IFn$_invoke$arity$2(id,(0)) : cell_exc.call(null,id,(0)));
var equal_best_QMARK_ = (exc === best_exc);
var new_best_QMARK_ = (exc > best_exc);
var good_QMARK_ = (exc >= threshold);
var G__36709 = cljs.core.next(ids);
var G__36710 = ((equal_best_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(best_ids,id):((new_best_QMARK_)?cljs.core._conj(cljs.core.List.EMPTY,id):best_ids
));
var G__36711 = ((new_best_QMARK_)?exc:best_exc);
var G__36712 = ((good_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(good_ids,id):good_ids);
var G__36713 = ((new_best_QMARK_)?(function (){var x__6484__auto__ = best_exc;
var y__6485__auto__ = second_exc;
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})():((((second_exc < exc)) && ((exc < best_exc)))?exc:second_exc));
ids = G__36709;
best_ids = G__36710;
best_exc = G__36711;
good_ids = G__36712;
second_exc = G__36713;
continue;
} else {
if((best_exc < threshold)){
return cell_ids;
} else {
if(((best_exc - second_exc) >= dominance_margin)){
return best_ids;
} else {
return good_ids;

}
}
}
break;
}
});
/**
 * Determines active cells in the given columns and whether they are bursting.
 *   Returns keys
 * 
 *   * `:col-active-cells` - map of column id to seq of active cell ids.
 *   * `:active-cells` - the set of active cell ids.
 *   * `:stable-active-cells` - the set of non-bursting active cells.
 *   * `:burst-cols` - the set of bursting column ids.
 */
org.nfrac.comportex.cells.select_active_cells = (function org$nfrac$comportex$cells$select_active_cells(a_cols,cell_exc,depth,threshold,dominance_margin){
var cols = cljs.core.seq(a_cols);
var col_ac = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ac = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
var sac = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
var b_cols = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
var temp__4655__auto__ = cljs.core.first(cols);
if(cljs.core.truth_(temp__4655__auto__)){
var col = temp__4655__auto__;
var this_ac = org.nfrac.comportex.cells.column_active_cells(col,cell_exc,depth,threshold,dominance_margin);
var bursting_QMARK_ = ((function (){var G__36716 = cljs.core.first(this_ac);
var G__36717 = (0);
return (cell_exc.cljs$core$IFn$_invoke$arity$2 ? cell_exc.cljs$core$IFn$_invoke$arity$2(G__36716,G__36717) : cell_exc.call(null,G__36716,G__36717));
})() < threshold);
var G__36718 = cljs.core.next(cols);
var G__36719 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(col_ac,col,this_ac);
var G__36720 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj_BANG_,ac,this_ac);
var G__36721 = ((bursting_QMARK_)?sac:cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj_BANG_,sac,this_ac));
var G__36722 = ((bursting_QMARK_)?cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(b_cols,col):b_cols);
cols = G__36718;
col_ac = G__36719;
ac = G__36720;
sac = G__36721;
b_cols = G__36722;
continue;
} else {
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$col_DASH_active_DASH_cells,cljs.core.persistent_BANG_(col_ac),cljs.core.cst$kw$active_DASH_cells,cljs.core.persistent_BANG_(ac),cljs.core.cst$kw$stable_DASH_active_DASH_cells,cljs.core.persistent_BANG_(sac),cljs.core.cst$kw$burst_DASH_cols,cljs.core.persistent_BANG_(b_cols)], null);
}
break;
}
});
/**
 * Returns [winner-cell [distal-seg-path exc] [apical-seg-path exc]]
 *   giving the best matching existing segments to learn on, if any.
 */
org.nfrac.comportex.cells.select_winner_cell = (function org$nfrac$comportex$cells$select_winner_cell(ac,distal_state,apical_state,distal_sg,apical_sg,spec,rng){
var full_matching_distal = cljs.core.cst$kw$matching_DASH_seg_DASH_paths.cljs$core$IFn$_invoke$arity$1(distal_state);
var full_matching_apical = cljs.core.cst$kw$matching_DASH_seg_DASH_paths.cljs$core$IFn$_invoke$arity$1(apical_state);
var d_full_matches = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(full_matching_distal,ac);
var a_full_matches = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(full_matching_apical,ac);
var distal_bits = cljs.core.cst$kw$active_DASH_bits.cljs$core$IFn$_invoke$arity$1(distal_state);
var apical_bits = cljs.core.cst$kw$active_DASH_bits.cljs$core$IFn$_invoke$arity$1(apical_state);
var min_distal = cljs.core.cst$kw$learn_DASH_threshold.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(spec));
var min_apical = cljs.core.cst$kw$learn_DASH_threshold.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(spec));
var apical_bias_frac = cljs.core.cst$kw$apical_DASH_bias_DASH_frac.cljs$core$IFn$_invoke$arity$1(spec);
var best_partial_distal_segment = ((function (full_matching_distal,full_matching_apical,d_full_matches,a_full_matches,distal_bits,apical_bits,min_distal,min_apical,apical_bias_frac){
return (function (cell_id){
var cell_segs = org.nfrac.comportex.protocols.cell_segments(distal_sg,cell_id);
var vec__36725 = org.nfrac.comportex.cells.best_matching_segment(cell_segs,distal_bits,min_distal,0.0);
var match_si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36725,(0),null);
var exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36725,(1),null);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36725,(2),null);
if(cljs.core.truth_(match_si)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cell_id,match_si),exc], null);
} else {
return null;
}
});})(full_matching_distal,full_matching_apical,d_full_matches,a_full_matches,distal_bits,apical_bits,min_distal,min_apical,apical_bias_frac))
;
var best_partial_apical_segment = ((function (full_matching_distal,full_matching_apical,d_full_matches,a_full_matches,distal_bits,apical_bits,min_distal,min_apical,apical_bias_frac,best_partial_distal_segment){
return (function (cell_id){
var cell_segs = org.nfrac.comportex.protocols.cell_segments(apical_sg,cell_id);
var vec__36726 = org.nfrac.comportex.cells.best_matching_segment(cell_segs,apical_bits,min_apical,0.0);
var match_si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36726,(0),null);
var exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36726,(1),null);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36726,(2),null);
if(cljs.core.truth_(match_si)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cell_id,match_si),exc], null);
} else {
return null;
}
});})(full_matching_distal,full_matching_apical,d_full_matches,a_full_matches,distal_bits,apical_bits,min_distal,min_apical,apical_bias_frac,best_partial_distal_segment))
;
var distal_match_STAR_ = (((cljs.core.count(d_full_matches) === (1)))?cljs.core.first(d_full_matches):(((cljs.core.count(d_full_matches) > (1)))?null:(function (){var partial_matches = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(best_partial_distal_segment,ac);
if(cljs.core.seq(partial_matches)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.second,partial_matches);
} else {
return null;
}
})()
));
var apical_match = (cljs.core.truth_(distal_match_STAR_)?(function (){var cell_id = cljs.core.pop(cljs.core.first(distal_match_STAR_));
var temp__4655__auto__ = (full_matching_apical.cljs$core$IFn$_invoke$arity$1 ? full_matching_apical.cljs$core$IFn$_invoke$arity$1(cell_id) : full_matching_apical.call(null,cell_id));
if(cljs.core.truth_(temp__4655__auto__)){
var full_match = temp__4655__auto__;
return full_match;
} else {
return best_partial_apical_segment(cell_id);
}
})():((((cljs.core.count(d_full_matches) > (1))) || (((apical_bias_frac > (0))) && ((clojure.test.check.random.rand_double(rng) <= apical_bias_frac))))?((cljs.core.seq(a_full_matches))?org.nfrac.comportex.util.rand_nth(rng,a_full_matches):(function (){var partial_matches = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(best_partial_apical_segment,ac);
if(cljs.core.seq(partial_matches)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.second,partial_matches);
} else {
return null;
}
})()):null
));
var distal_match = (cljs.core.truth_(distal_match_STAR_)?distal_match_STAR_:(((cljs.core.count(d_full_matches) > (1)))?(function (){var cell_id = (cljs.core.truth_(apical_match)?cljs.core.pop(cljs.core.first(apical_match)):org.nfrac.comportex.util.rand_nth(rng,ac));
var match = (full_matching_distal.cljs$core$IFn$_invoke$arity$1 ? full_matching_distal.cljs$core$IFn$_invoke$arity$1(cell_id) : full_matching_distal.call(null,cell_id));
if(cljs.core.truth_(match)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("fully active distal, if any, should equal active cells"),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.cst$sym$match], 0)))].join('')));
}

return match;
})():null
));
var winner_cell = (cljs.core.truth_(distal_match)?cljs.core.pop(cljs.core.first(distal_match)):(cljs.core.truth_(apical_match)?cljs.core.pop(cljs.core.first(apical_match)):org.nfrac.comportex.util.rand_nth(rng,ac)
));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [winner_cell,distal_match,apical_match], null);
});
/**
 * Returns keys / nested keys
 * 
 *   * `:col-winners` - maps column id to winning cell id;
 *   * `:winner-seg :distal` - maps cell id to [seg-path exc] for a lateral segment;
 *   * `:winner-seg :apical` - maps cell id to [seg-path exc] for an apical segment;
 * 
 *   These :winner-seg maps contain only the winning cell ids for which an
 *   existing segment matches sufficiently to be learning. Otherwise, a
 *   new (effectively new) segment will be grown. We keep winner cells stable
 *   in continuing active columns.
 */
org.nfrac.comportex.cells.select_winner_cells = (function org$nfrac$comportex$cells$select_winner_cells(col_ac,prior_winners,distal_state,apical_state,distal_sg,apical_sg,spec,rng){
var reset_QMARK_ = cljs.core.empty_QMARK_(cljs.core.cst$kw$active_DASH_bits.cljs$core$IFn$_invoke$arity$1(distal_state));
var col_ac__$1 = col_ac;
var col_winners = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var winning_distal = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var winning_apical = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var rng__$1 = rng;
while(true){
var temp__4655__auto__ = cljs.core.first(col_ac__$1);
if(cljs.core.truth_(temp__4655__auto__)){
var vec__36731 = temp__4655__auto__;
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36731,(0),null);
var ac = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36731,(1),null);
if(reset_QMARK_){
var G__36734 = cljs.core.next(col_ac__$1);
var G__36735 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(col_winners,col,cljs.core.first(ac));
var G__36736 = winning_distal;
var G__36737 = winning_apical;
var G__36738 = rng__$1;
col_ac__$1 = G__36734;
col_winners = G__36735;
winning_distal = G__36736;
winning_apical = G__36737;
rng__$1 = G__36738;
continue;
} else {
var prior_winner = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prior_winners,col);
var ac__$1 = (cljs.core.truth_((function (){var and__6141__auto__ = prior_winner;
if(cljs.core.truth_(and__6141__auto__)){
return cljs.core.some(((function (col_ac__$1,col_winners,winning_distal,winning_apical,rng__$1,and__6141__auto__,prior_winner,vec__36731,col,ac,temp__4655__auto__,reset_QMARK_){
return (function (p1__36727_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__36727_SHARP_,prior_winner);
});})(col_ac__$1,col_winners,winning_distal,winning_apical,rng__$1,and__6141__auto__,prior_winner,vec__36731,col,ac,temp__4655__auto__,reset_QMARK_))
,ac);
} else {
return and__6141__auto__;
}
})())?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [prior_winner], null):ac);
var vec__36732 = clojure.test.check.random.split(rng__$1);
var rng_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36732,(0),null);
var rng__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36732,(1),null);
var vec__36733 = org.nfrac.comportex.cells.select_winner_cell(ac__$1,distal_state,apical_state,distal_sg,apical_sg,spec,rng_STAR_);
var winner = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36733,(0),null);
var dmatch = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36733,(1),null);
var amatch = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36733,(2),null);
var G__36739 = cljs.core.next(col_ac__$1);
var G__36740 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(col_winners,col,winner);
var G__36741 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(winning_distal,winner,dmatch);
var G__36742 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(winning_apical,winner,amatch);
var G__36743 = rng__$2;
col_ac__$1 = G__36739;
col_winners = G__36740;
winning_distal = G__36741;
winning_apical = G__36742;
rng__$1 = G__36743;
continue;
}
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$col_DASH_winners,cljs.core.persistent_BANG_(col_winners),cljs.core.cst$kw$winner_DASH_seg,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$distal,cljs.core.persistent_BANG_(winning_distal),cljs.core.cst$kw$apical,cljs.core.persistent_BANG_(winning_apical)], null)], null);
}
break;
}
});
/**
 * Returns a segment index on the cell at which to grow a new segment,
 *   together with any existing synapses at that index. It may refer to
 *   the end of the existing vector to append to it, or it may refer to
 *   an existing segment that is to be culled before the new one
 *   grows. If the maximum number of segments has been reached, an
 *   existing one is chosen to be replaced based on having the fewest
 *   connected synapses, or fewest synapses to break ties.
 */
org.nfrac.comportex.cells.new_segment_id = (function org$nfrac$comportex$cells$new_segment_id(segs,pcon,max_segs,max_syns){
var segs__$1 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,segs);
if((cljs.core.count(segs__$1) >= max_segs)){
var si = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.min_key,((function (segs__$1){
return (function (si){
var syns = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(segs__$1,si);
var n_conn = org.nfrac.comportex.util.count_filter(((function (syns,segs__$1){
return (function (p1__36744_SHARP_){
return (p1__36744_SHARP_ >= pcon);
});})(syns,segs__$1))
,cljs.core.vals(syns));
return (((n_conn * max_syns) + cljs.core.count(syns)) + (si / cljs.core.count(segs__$1)));
});})(segs__$1))
,cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(segs__$1)));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(segs__$1,si)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.count(segs__$1),null], null);
}
});
/**
 * Returns a collection of up to n ids chosen from the learnable
 *   source bits. May be less than `n` if the random samples have
 *   duplicates or some already exist on the segment, or if there are
 *   fewer than `n` learnable cells.
 */
org.nfrac.comportex.cells.segment_new_synapse_source_ids = (function org$nfrac$comportex$cells$segment_new_synapse_source_ids(seg,learnable_bits_vec,n,rng){
if(cljs.core.seq(learnable_bits_vec)){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(seg,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(org.nfrac.comportex.util.sample(rng,n,learnable_bits_vec)));
} else {
return null;
}
});
/**
 * Takes the learning `cells` and maps each to a SegUpdate record,
 *   which includes the segment path to learn on, together with lists of
 *   any synapse sources to add or remove. Any matching segments to learn
 *   on are given as `matching-segs`, mapping cell ids to `[seg-path
 *   exc]`. If this is missing for a cell then a new segment will be
 *   grown, perhaps replacing an existing one.
 * 
 *   Note that ''cell-ids'' here may also refer to columns in a proximal
 *   synapse graph, where the convention is [col 0]. Everything else is
 *   the same since proximal synapses graphs can also have multiple
 *   segments [col 0 seg-idx].
 */
org.nfrac.comportex.cells.learning_updates = (function org$nfrac$comportex$cells$learning_updates(cells,matching_segs,sg,learnable_bits,rng,p__36745){
var map__36752 = p__36745;
var map__36752__$1 = ((((!((map__36752 == null)))?((((map__36752.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36752.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36752):map__36752);
var pcon = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36752__$1,cljs.core.cst$kw$perm_DASH_connected);
var min_act = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36752__$1,cljs.core.cst$kw$learn_DASH_threshold);
var new_syns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36752__$1,cljs.core.cst$kw$new_DASH_synapse_DASH_count);
var max_syns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36752__$1,cljs.core.cst$kw$max_DASH_synapse_DASH_count);
var max_segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36752__$1,cljs.core.cst$kw$max_DASH_segments);
var learnable_bits__$1 = cljs.core.vec(learnable_bits);
var cells__$1 = cljs.core.seq(cells);
var m = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var rng__$1 = rng;
while(true){
var temp__4655__auto__ = cljs.core.first(cells__$1);
if(cljs.core.truth_(temp__4655__auto__)){
var cell_id = temp__4655__auto__;
var vec__36754 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(matching_segs,cell_id);
var matching_path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36754,(0),null);
var exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36754,(1),null);
var new_segment_QMARK_ = cljs.core.not(matching_path);
var cell_segs = org.nfrac.comportex.protocols.cell_segments(sg,cell_id);
var vec__36755 = ((new_segment_QMARK_)?org.nfrac.comportex.cells.new_segment_id(cell_segs,pcon,max_segs,max_syns):null);
var new_si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36755,(0),null);
var replaced_syns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36755,(1),null);
var seg = ((new_segment_QMARK_)?cljs.core.PersistentArrayMap.EMPTY:(function (){var vec__36757 = matching_path;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36757,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36757,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36757,(2),null);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cell_segs,si);
})());
var grow_n = (function (){var x__6484__auto__ = (function (){var x__6491__auto__ = (new_syns - (function (){var or__6153__auto__ = exc;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return (0);
}
})());
var y__6492__auto__ = (max_syns - cljs.core.count(seg));
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
})();
var y__6485__auto__ = (0);
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})();
var vec__36756 = clojure.test.check.random.split(rng__$1);
var rng_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36756,(0),null);
var rng__$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36756,(1),null);
var grow_source_ids = org.nfrac.comportex.cells.segment_new_synapse_source_ids(seg,learnable_bits__$1,grow_n,rng_STAR_);
var die_source_ids = ((new_segment_QMARK_)?cljs.core.keys(replaced_syns):null);
var seg_path = ((new_segment_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cell_id,new_si):matching_path);
var G__36758 = cljs.core.next(cells__$1);
var G__36759 = (((new_segment_QMARK_) && ((cljs.core.count(grow_source_ids) < min_act)))?m:cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,cell_id,org.nfrac.comportex.synapses.seg_update.cljs$core$IFn$_invoke$arity$4(seg_path,cljs.core.cst$kw$learn,grow_source_ids,die_source_ids)));
var G__36760 = rng__$2;
cells__$1 = G__36758;
m = G__36759;
rng__$1 = G__36760;
continue;
} else {
return cljs.core.persistent_BANG_(m);
}
break;
}
});
org.nfrac.comportex.cells.learn_distal = (function org$nfrac$comportex$cells$learn_distal(sg,distal_state,cells,matching_segs,dspec,rng){
var learning = org.nfrac.comportex.cells.learning_updates(cells,matching_segs,sg,cljs.core.cst$kw$learnable_DASH_bits.cljs$core$IFn$_invoke$arity$1(distal_state),rng,dspec);
var new_sg = ((cljs.core.seq(learning))?org.nfrac.comportex.protocols.bulk_learn(sg,cljs.core.vals(learning),cljs.core.cst$kw$active_DASH_bits.cljs$core$IFn$_invoke$arity$1(distal_state),cljs.core.cst$kw$perm_DASH_inc.cljs$core$IFn$_invoke$arity$1(dspec),cljs.core.cst$kw$perm_DASH_dec.cljs$core$IFn$_invoke$arity$1(dspec),cljs.core.cst$kw$perm_DASH_init.cljs$core$IFn$_invoke$arity$1(dspec)):sg);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_sg,learning], null);
});
org.nfrac.comportex.cells.punish_distal = (function org$nfrac$comportex$cells$punish_distal(sg,distal_state,prior_distal_state,prior_active_cells,dspec){
var bad_cells = clojure.set.difference.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$pred_DASH_cells.cljs$core$IFn$_invoke$arity$1(prior_distal_state),cljs.core.cst$kw$pred_DASH_cells.cljs$core$IFn$_invoke$arity$1(distal_state),cljs.core.array_seq([prior_active_cells], 0));
var matching_segs = cljs.core.cst$kw$matching_DASH_seg_DASH_paths.cljs$core$IFn$_invoke$arity$1(prior_distal_state);
var punishments = (function (){var iter__6925__auto__ = ((function (bad_cells,matching_segs){
return (function org$nfrac$comportex$cells$punish_distal_$_iter__36771(s__36772){
return (new cljs.core.LazySeq(null,((function (bad_cells,matching_segs){
return (function (){
var s__36772__$1 = s__36772;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36772__$1);
if(temp__4657__auto__){
var s__36772__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36772__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__36772__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__36774 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__36773 = (0);
while(true){
if((i__36773 < size__6924__auto__)){
var cell = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__36773);
var vec__36779 = (matching_segs.cljs$core$IFn$_invoke$arity$1 ? matching_segs.cljs$core$IFn$_invoke$arity$1(cell) : matching_segs.call(null,cell));
var seg_path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36779,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36779,(1),null);
cljs.core.chunk_append(b__36774,org.nfrac.comportex.synapses.seg_update.cljs$core$IFn$_invoke$arity$4(seg_path,cljs.core.cst$kw$punish,null,null));

var G__36781 = (i__36773 + (1));
i__36773 = G__36781;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36774),org$nfrac$comportex$cells$punish_distal_$_iter__36771(cljs.core.chunk_rest(s__36772__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36774),null);
}
} else {
var cell = cljs.core.first(s__36772__$2);
var vec__36780 = (matching_segs.cljs$core$IFn$_invoke$arity$1 ? matching_segs.cljs$core$IFn$_invoke$arity$1(cell) : matching_segs.call(null,cell));
var seg_path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36780,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36780,(1),null);
return cljs.core.cons(org.nfrac.comportex.synapses.seg_update.cljs$core$IFn$_invoke$arity$4(seg_path,cljs.core.cst$kw$punish,null,null),org$nfrac$comportex$cells$punish_distal_$_iter__36771(cljs.core.rest(s__36772__$2)));
}
} else {
return null;
}
break;
}
});})(bad_cells,matching_segs))
,null,null));
});})(bad_cells,matching_segs))
;
return iter__6925__auto__(bad_cells);
})();
var new_sg = (cljs.core.truth_(punishments)?org.nfrac.comportex.protocols.bulk_learn(sg,punishments,cljs.core.cst$kw$active_DASH_bits.cljs$core$IFn$_invoke$arity$1(prior_distal_state),cljs.core.cst$kw$perm_DASH_inc.cljs$core$IFn$_invoke$arity$1(dspec),cljs.core.cst$kw$perm_DASH_punish.cljs$core$IFn$_invoke$arity$1(dspec),cljs.core.cst$kw$perm_DASH_init.cljs$core$IFn$_invoke$arity$1(dspec)):sg);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_sg,punishments], null);
});
org.nfrac.comportex.cells.layer_learn_lateral = (function org$nfrac$comportex$cells$layer_learn_lateral(this$,cells,matching_segs){
var sg = cljs.core.cst$kw$distal_DASH_sg.cljs$core$IFn$_invoke$arity$1(this$);
var dstate = cljs.core.cst$kw$distal_DASH_state.cljs$core$IFn$_invoke$arity$1(this$);
var dspec = cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(this$));
var vec__36784 = clojure.test.check.random.split(cljs.core.cst$kw$rng.cljs$core$IFn$_invoke$arity$1(this$));
var rng_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36784,(0),null);
var rng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36784,(1),null);
var vec__36785 = org.nfrac.comportex.cells.learn_distal(sg,dstate,cells,matching_segs,dspec,rng_STAR_);
var new_sg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36785,(0),null);
var learning = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36785,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$,cljs.core.cst$kw$rng,rng,cljs.core.array_seq([cljs.core.cst$kw$learn_DASH_state,cljs.core.assoc_in(cljs.core.cst$kw$learn_DASH_state.cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$learning,cljs.core.cst$kw$distal], null),learning),cljs.core.cst$kw$distal_DASH_sg,new_sg], 0));
});
org.nfrac.comportex.cells.layer_learn_apical = (function org$nfrac$comportex$cells$layer_learn_apical(this$,cells,matching_segs){
var sg = cljs.core.cst$kw$apical_DASH_sg.cljs$core$IFn$_invoke$arity$1(this$);
var dstate = cljs.core.cst$kw$apical_DASH_state.cljs$core$IFn$_invoke$arity$1(this$);
var dspec = cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(this$));
var vec__36788 = clojure.test.check.random.split(cljs.core.cst$kw$rng.cljs$core$IFn$_invoke$arity$1(this$));
var rng_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36788,(0),null);
var rng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36788,(1),null);
var vec__36789 = org.nfrac.comportex.cells.learn_distal(sg,dstate,cells,matching_segs,dspec,rng_STAR_);
var new_sg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36789,(0),null);
var learning = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36789,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$,cljs.core.cst$kw$rng,rng,cljs.core.array_seq([cljs.core.cst$kw$learn_DASH_state,cljs.core.assoc_in(cljs.core.cst$kw$learn_DASH_state.cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$learning,cljs.core.cst$kw$apical], null),learning),cljs.core.cst$kw$apical_DASH_sg,new_sg], 0));
});
org.nfrac.comportex.cells.layer_punish_lateral = (function org$nfrac$comportex$cells$layer_punish_lateral(this$,prior_ac){
var sg = cljs.core.cst$kw$distal_DASH_sg.cljs$core$IFn$_invoke$arity$1(this$);
var dstate = cljs.core.cst$kw$distal_DASH_state.cljs$core$IFn$_invoke$arity$1(this$);
var pdstate = cljs.core.cst$kw$prior_DASH_distal_DASH_state.cljs$core$IFn$_invoke$arity$1(this$);
var dspec = cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(this$));
var vec__36791 = org.nfrac.comportex.cells.punish_distal(sg,dstate,pdstate,prior_ac,dspec);
var new_sg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36791,(0),null);
var punishments = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36791,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$,cljs.core.cst$kw$learn_DASH_state,cljs.core.assoc_in(cljs.core.cst$kw$learn_DASH_state.cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$punishments,cljs.core.cst$kw$distal], null),punishments),cljs.core.array_seq([cljs.core.cst$kw$distal_DASH_sg,new_sg], 0));
});
org.nfrac.comportex.cells.layer_punish_apical = (function org$nfrac$comportex$cells$layer_punish_apical(this$,prior_ac){
var sg = cljs.core.cst$kw$apical_DASH_sg.cljs$core$IFn$_invoke$arity$1(this$);
var dstate = cljs.core.cst$kw$apical_DASH_state.cljs$core$IFn$_invoke$arity$1(this$);
var pdstate = cljs.core.cst$kw$prior_DASH_apical_DASH_state.cljs$core$IFn$_invoke$arity$1(this$);
var dspec = cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(this$));
var vec__36793 = org.nfrac.comportex.cells.punish_distal(sg,dstate,pdstate,prior_ac,dspec);
var new_sg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36793,(0),null);
var punishments = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36793,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$,cljs.core.cst$kw$learn_DASH_state,cljs.core.assoc_in(cljs.core.cst$kw$learn_DASH_state.cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$punishments,cljs.core.cst$kw$apical], null),punishments),cljs.core.array_seq([cljs.core.cst$kw$apical_DASH_sg,new_sg], 0));
});
org.nfrac.comportex.cells.layer_learn_ilateral = (function org$nfrac$comportex$cells$layer_learn_ilateral(this$,cols){
var sg = cljs.core.cst$kw$ilateral_DASH_sg.cljs$core$IFn$_invoke$arity$1(this$);
var dspec = cljs.core.cst$kw$ilateral.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(this$));
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cols,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((0)));
var matching_segs = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (sg,dspec,ids){
return (function (id){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(id,(0)),1.0], null)], null);
});})(sg,dspec,ids))
),ids);
var state = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$active_DASH_bits,cols,cljs.core.cst$kw$learnable_DASH_bits,cols], null);
var vec__36796 = clojure.test.check.random.split(cljs.core.cst$kw$rng.cljs$core$IFn$_invoke$arity$1(this$));
var rng_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36796,(0),null);
var rng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36796,(1),null);
var vec__36797 = org.nfrac.comportex.cells.learn_distal(sg,state,ids,matching_segs,dspec,rng_STAR_);
var new_sg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36797,(0),null);
var learning = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36797,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$,cljs.core.cst$kw$rng,rng,cljs.core.array_seq([cljs.core.cst$kw$learn_DASH_state,cljs.core.assoc_in(cljs.core.cst$kw$learn_DASH_state.cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$learning,cljs.core.cst$kw$ilateral], null),learning),cljs.core.cst$kw$ilateral_DASH_sg,new_sg], 0));
});
org.nfrac.comportex.cells.layer_learn_proximal = (function org$nfrac$comportex$cells$layer_learn_proximal(this$,cols){
var sg = cljs.core.cst$kw$proximal_DASH_sg.cljs$core$IFn$_invoke$arity$1(this$);
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(this$);
var pspec = cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(this$));
var min_prox = cljs.core.cst$kw$learn_DASH_threshold.cljs$core$IFn$_invoke$arity$1(pspec);
var active_bits = cljs.core.cst$kw$in_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(state);
var full_matching_segs = cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths.cljs$core$IFn$_invoke$arity$1(state);
var ids = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cols,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((0)));
var matching_segs = cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (sg,state,pspec,min_prox,active_bits,full_matching_segs,ids){
return (function (m,id){
var temp__4655__auto__ = (full_matching_segs.cljs$core$IFn$_invoke$arity$1 ? full_matching_segs.cljs$core$IFn$_invoke$arity$1(id) : full_matching_segs.call(null,id));
if(cljs.core.truth_(temp__4655__auto__)){
var full_match = temp__4655__auto__;
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,id,full_match);
} else {
var cell_segs = org.nfrac.comportex.protocols.cell_segments(sg,id);
var vec__36803 = org.nfrac.comportex.cells.best_matching_segment(cell_segs,active_bits,min_prox,0.0);
var match_si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36803,(0),null);
var exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36803,(1),null);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36803,(2),null);
if(cljs.core.truth_(match_si)){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,id,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2(id,match_si),exc], null));
} else {
return m;
}
}
});})(sg,state,pspec,min_prox,active_bits,full_matching_segs,ids))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),ids));
var vec__36802 = clojure.test.check.random.split(cljs.core.cst$kw$rng.cljs$core$IFn$_invoke$arity$1(this$));
var rng_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36802,(0),null);
var rng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36802,(1),null);
var prox_learning = org.nfrac.comportex.cells.learning_updates(ids,matching_segs,sg,(cljs.core.truth_(cljs.core.cst$kw$grow_QMARK_.cljs$core$IFn$_invoke$arity$1(pspec))?cljs.core.cst$kw$in_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(state):null),rng_STAR_,pspec);
var psg = (function (){var G__36804 = sg;
var G__36804__$1 = ((cljs.core.seq(prox_learning))?org.nfrac.comportex.protocols.bulk_learn(G__36804,cljs.core.vals(prox_learning),cljs.core.cst$kw$in_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$perm_DASH_inc.cljs$core$IFn$_invoke$arity$1(pspec),cljs.core.cst$kw$perm_DASH_dec.cljs$core$IFn$_invoke$arity$1(pspec),cljs.core.cst$kw$perm_DASH_init.cljs$core$IFn$_invoke$arity$1(pspec)):G__36804);
if((cljs.core.seq(prox_learning)) && (cljs.core.seq(cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(state))) && ((cljs.core.cst$kw$perm_DASH_stable_DASH_inc.cljs$core$IFn$_invoke$arity$1(pspec) > cljs.core.cst$kw$perm_DASH_inc.cljs$core$IFn$_invoke$arity$1(pspec)))){
return org.nfrac.comportex.protocols.bulk_learn(G__36804__$1,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (G__36804,G__36804__$1,sg,state,pspec,min_prox,active_bits,full_matching_segs,ids,matching_segs,vec__36802,rng_STAR_,rng,prox_learning){
return (function (p1__36798_SHARP_){
return org.nfrac.comportex.synapses.seg_update.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$target_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__36798_SHARP_),cljs.core.cst$kw$reinforce,null,null);
});})(G__36804,G__36804__$1,sg,state,pspec,min_prox,active_bits,full_matching_segs,ids,matching_segs,vec__36802,rng_STAR_,rng,prox_learning))
,cljs.core.vals(prox_learning)),cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(state),(cljs.core.cst$kw$perm_DASH_stable_DASH_inc.cljs$core$IFn$_invoke$arity$1(pspec) - cljs.core.cst$kw$perm_DASH_inc.cljs$core$IFn$_invoke$arity$1(pspec)),cljs.core.cst$kw$perm_DASH_dec.cljs$core$IFn$_invoke$arity$1(pspec),cljs.core.cst$kw$perm_DASH_init.cljs$core$IFn$_invoke$arity$1(pspec));
} else {
return G__36804__$1;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$,cljs.core.cst$kw$rng,rng,cljs.core.array_seq([cljs.core.cst$kw$learn_DASH_state,cljs.core.assoc_in(cljs.core.cst$kw$learn_DASH_state.cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$learning,cljs.core.cst$kw$proximal], null),prox_learning),cljs.core.cst$kw$proximal_DASH_sg,psg], 0));
});
org.nfrac.comportex.cells.punish_proximal = (function org$nfrac$comportex$cells$punish_proximal(sg,state,pspec){
var matching_segs = cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths.cljs$core$IFn$_invoke$arity$1(state);
var pred_cells = cljs.core.set(cljs.core.keys(matching_segs));
var active_cells = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.cst$kw$active_DASH_cols.cljs$core$IFn$_invoke$arity$1(state),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((0))));
var bad_cells = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(pred_cells,active_cells);
var punishments = (function (){var iter__6925__auto__ = ((function (matching_segs,pred_cells,active_cells,bad_cells){
return (function org$nfrac$comportex$cells$punish_proximal_$_iter__36815(s__36816){
return (new cljs.core.LazySeq(null,((function (matching_segs,pred_cells,active_cells,bad_cells){
return (function (){
var s__36816__$1 = s__36816;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__36816__$1);
if(temp__4657__auto__){
var s__36816__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36816__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__36816__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__36818 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__36817 = (0);
while(true){
if((i__36817 < size__6924__auto__)){
var cell = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__36817);
var vec__36823 = (matching_segs.cljs$core$IFn$_invoke$arity$1 ? matching_segs.cljs$core$IFn$_invoke$arity$1(cell) : matching_segs.call(null,cell));
var seg_path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36823,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36823,(1),null);
if(cljs.core.truth_(seg_path)){
cljs.core.chunk_append(b__36818,org.nfrac.comportex.synapses.seg_update.cljs$core$IFn$_invoke$arity$4(seg_path,cljs.core.cst$kw$punish,null,null));

var G__36825 = (i__36817 + (1));
i__36817 = G__36825;
continue;
} else {
var G__36826 = (i__36817 + (1));
i__36817 = G__36826;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36818),org$nfrac$comportex$cells$punish_proximal_$_iter__36815(cljs.core.chunk_rest(s__36816__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36818),null);
}
} else {
var cell = cljs.core.first(s__36816__$2);
var vec__36824 = (matching_segs.cljs$core$IFn$_invoke$arity$1 ? matching_segs.cljs$core$IFn$_invoke$arity$1(cell) : matching_segs.call(null,cell));
var seg_path = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36824,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36824,(1),null);
if(cljs.core.truth_(seg_path)){
return cljs.core.cons(org.nfrac.comportex.synapses.seg_update.cljs$core$IFn$_invoke$arity$4(seg_path,cljs.core.cst$kw$punish,null,null),org$nfrac$comportex$cells$punish_proximal_$_iter__36815(cljs.core.rest(s__36816__$2)));
} else {
var G__36827 = cljs.core.rest(s__36816__$2);
s__36816__$1 = G__36827;
continue;
}
}
} else {
return null;
}
break;
}
});})(matching_segs,pred_cells,active_cells,bad_cells))
,null,null));
});})(matching_segs,pred_cells,active_cells,bad_cells))
;
return iter__6925__auto__(bad_cells);
})();
var new_sg = (cljs.core.truth_(punishments)?org.nfrac.comportex.protocols.bulk_learn(sg,punishments,cljs.core.cst$kw$in_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(state),cljs.core.cst$kw$perm_DASH_inc.cljs$core$IFn$_invoke$arity$1(pspec),cljs.core.cst$kw$perm_DASH_punish.cljs$core$IFn$_invoke$arity$1(pspec),cljs.core.cst$kw$perm_DASH_init.cljs$core$IFn$_invoke$arity$1(pspec)):sg);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_sg,punishments], null);
});
org.nfrac.comportex.cells.layer_punish_proximal = (function org$nfrac$comportex$cells$layer_punish_proximal(this$){
var sg = cljs.core.cst$kw$proximal_DASH_sg.cljs$core$IFn$_invoke$arity$1(this$);
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(this$);
var pspec = cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(this$));
var vec__36829 = org.nfrac.comportex.cells.punish_proximal(sg,state,pspec);
var new_sg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36829,(0),null);
var punishments = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36829,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$,cljs.core.cst$kw$learn_DASH_state,cljs.core.assoc_in(cljs.core.cst$kw$learn_DASH_state.cljs$core$IFn$_invoke$arity$1(this$),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$punishments,cljs.core.cst$kw$proximal], null),punishments),cljs.core.array_seq([cljs.core.cst$kw$proximal_DASH_sg,new_sg], 0));
});
org.nfrac.comportex.cells.update_inhibition_radius = (function org$nfrac$comportex$cells$update_inhibition_radius(layer){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(layer,cljs.core.cst$kw$inh_DASH_radius,org.nfrac.comportex.inhibition.inhibition_radius(cljs.core.cst$kw$proximal_DASH_sg.cljs$core$IFn$_invoke$arity$1(layer),cljs.core.cst$kw$topology.cljs$core$IFn$_invoke$arity$1(layer),cljs.core.cst$kw$input_DASH_topology.cljs$core$IFn$_invoke$arity$1(layer)));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
org.nfrac.comportex.cells.LayerActiveState = (function (in_ff_bits,in_stable_ff_bits,col_overlaps,matching_ff_seg_paths,stable_active_cells,active_cols,burst_cols,col_active_cells,active_cells,timestep,__meta,__extmap,__hash){
this.in_ff_bits = in_ff_bits;
this.in_stable_ff_bits = in_stable_ff_bits;
this.col_overlaps = col_overlaps;
this.matching_ff_seg_paths = matching_ff_seg_paths;
this.stable_active_cells = stable_active_cells;
this.active_cols = active_cols;
this.burst_cols = burst_cols;
this.col_active_cells = col_active_cells;
this.active_cells = active_cells;
this.timestep = timestep;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6767__auto__,k__6768__auto__){
var self__ = this;
var this__6767__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__6767__auto____$1,k__6768__auto__,null);
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6769__auto__,k36831,else__6770__auto__){
var self__ = this;
var this__6769__auto____$1 = this;
var G__36833 = (((k36831 instanceof cljs.core.Keyword))?k36831.fqn:null);
switch (G__36833) {
case "burst-cols":
return self__.burst_cols;

break;
case "in-ff-bits":
return self__.in_ff_bits;

break;
case "timestep":
return self__.timestep;

break;
case "col-active-cells":
return self__.col_active_cells;

break;
case "matching-ff-seg-paths":
return self__.matching_ff_seg_paths;

break;
case "active-cols":
return self__.active_cols;

break;
case "col-overlaps":
return self__.col_overlaps;

break;
case "stable-active-cells":
return self__.stable_active_cells;

break;
case "active-cells":
return self__.active_cells;

break;
case "in-stable-ff-bits":
return self__.in_stable_ff_bits;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k36831,else__6770__auto__);

}
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6781__auto__,writer__6782__auto__,opts__6783__auto__){
var self__ = this;
var this__6781__auto____$1 = this;
var pr_pair__6784__auto__ = ((function (this__6781__auto____$1){
return (function (keyval__6785__auto__){
return cljs.core.pr_sequential_writer(writer__6782__auto__,cljs.core.pr_writer,""," ","",opts__6783__auto__,keyval__6785__auto__);
});})(this__6781__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__6782__auto__,pr_pair__6784__auto__,"#org.nfrac.comportex.cells.LayerActiveState{",", ","}",opts__6783__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$in_DASH_ff_DASH_bits,self__.in_ff_bits],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits,self__.in_stable_ff_bits],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$col_DASH_overlaps,self__.col_overlaps],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,self__.matching_ff_seg_paths],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stable_DASH_active_DASH_cells,self__.stable_active_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$active_DASH_cols,self__.active_cols],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$burst_DASH_cols,self__.burst_cols],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$col_DASH_active_DASH_cells,self__.col_active_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$active_DASH_cells,self__.active_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timestep,self__.timestep],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IIterable$ = true;

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36830){
var self__ = this;
var G__36830__$1 = this;
return (new cljs.core.RecordIter((0),G__36830__$1,10,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$in_DASH_ff_DASH_bits,cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits,cljs.core.cst$kw$col_DASH_overlaps,cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,cljs.core.cst$kw$stable_DASH_active_DASH_cells,cljs.core.cst$kw$active_DASH_cols,cljs.core.cst$kw$burst_DASH_cols,cljs.core.cst$kw$col_DASH_active_DASH_cells,cljs.core.cst$kw$active_DASH_cells,cljs.core.cst$kw$timestep], null),cljs.core._iterator(self__.__extmap)));
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6765__auto__){
var self__ = this;
var this__6765__auto____$1 = this;
return self__.__meta;
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6761__auto__){
var self__ = this;
var this__6761__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6771__auto__){
var self__ = this;
var this__6771__auto____$1 = this;
return (10 + cljs.core.count(self__.__extmap));
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6762__auto__){
var self__ = this;
var this__6762__auto____$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_imap(this__6762__auto____$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6763__auto__,other__6764__auto__){
var self__ = this;
var this__6763__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6141__auto__ = other__6764__auto__;
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (this__6763__auto____$1.constructor === other__6764__auto__.constructor);
if(and__6141__auto____$1){
return cljs.core.equiv_map(this__6763__auto____$1,other__6764__auto__);
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})())){
return true;
} else {
return false;
}
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6776__auto__,k__6777__auto__){
var self__ = this;
var this__6776__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [cljs.core.cst$kw$burst_DASH_cols,null,cljs.core.cst$kw$in_DASH_ff_DASH_bits,null,cljs.core.cst$kw$timestep,null,cljs.core.cst$kw$col_DASH_active_DASH_cells,null,cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,null,cljs.core.cst$kw$active_DASH_cols,null,cljs.core.cst$kw$col_DASH_overlaps,null,cljs.core.cst$kw$stable_DASH_active_DASH_cells,null,cljs.core.cst$kw$active_DASH_cells,null,cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits,null], null), null),k__6777__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__6776__auto____$1),self__.__meta),k__6777__auto__);
} else {
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__6777__auto__)),null));
}
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6774__auto__,k__6775__auto__,G__36830){
var self__ = this;
var this__6774__auto____$1 = this;
var pred__36834 = cljs.core.keyword_identical_QMARK_;
var expr__36835 = k__6775__auto__;
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$in_DASH_ff_DASH_bits,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$in_DASH_ff_DASH_bits,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(G__36830,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,G__36830,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$col_DASH_overlaps,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$col_DASH_overlaps,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,G__36830,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,G__36830,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stable_DASH_active_DASH_cells,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$stable_DASH_active_DASH_cells,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,G__36830,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$active_DASH_cols,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$active_DASH_cols,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,G__36830,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$burst_DASH_cols,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$burst_DASH_cols,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,G__36830,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$col_DASH_active_DASH_cells,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$col_DASH_active_DASH_cells,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,G__36830,self__.active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$active_DASH_cells,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$active_DASH_cells,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,G__36830,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36834.cljs$core$IFn$_invoke$arity$2 ? pred__36834.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$timestep,expr__36835) : pred__36834.call(null,cljs.core.cst$kw$timestep,expr__36835)))){
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,G__36830,self__.__meta,self__.__extmap,null));
} else {
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__6775__auto__,G__36830),null));
}
}
}
}
}
}
}
}
}
}
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6779__auto__){
var self__ = this;
var this__6779__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$in_DASH_ff_DASH_bits,self__.in_ff_bits],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits,self__.in_stable_ff_bits],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$col_DASH_overlaps,self__.col_overlaps],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,self__.matching_ff_seg_paths],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stable_DASH_active_DASH_cells,self__.stable_active_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$active_DASH_cols,self__.active_cols],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$burst_DASH_cols,self__.burst_cols],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$col_DASH_active_DASH_cells,self__.col_active_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$active_DASH_cells,self__.active_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timestep,self__.timestep],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6766__auto__,G__36830){
var self__ = this;
var this__6766__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerActiveState(self__.in_ff_bits,self__.in_stable_ff_bits,self__.col_overlaps,self__.matching_ff_seg_paths,self__.stable_active_cells,self__.active_cols,self__.burst_cols,self__.col_active_cells,self__.active_cells,self__.timestep,G__36830,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerActiveState.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6772__auto__,entry__6773__auto__){
var self__ = this;
var this__6772__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__6773__auto__)){
return cljs.core._assoc(this__6772__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__6772__auto____$1,entry__6773__auto__);
}
});

org.nfrac.comportex.cells.LayerActiveState.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$in_DASH_ff_DASH_bits,cljs.core.cst$sym$in_DASH_stable_DASH_ff_DASH_bits,cljs.core.cst$sym$col_DASH_overlaps,cljs.core.cst$sym$matching_DASH_ff_DASH_seg_DASH_paths,cljs.core.cst$sym$stable_DASH_active_DASH_cells,cljs.core.cst$sym$active_DASH_cols,cljs.core.cst$sym$burst_DASH_cols,cljs.core.cst$sym$col_DASH_active_DASH_cells,cljs.core.cst$sym$active_DASH_cells,cljs.core.cst$sym$timestep], null);
});

org.nfrac.comportex.cells.LayerActiveState.cljs$lang$type = true;

org.nfrac.comportex.cells.LayerActiveState.cljs$lang$ctorPrSeq = (function (this__6801__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"org.nfrac.comportex.cells/LayerActiveState");
});

org.nfrac.comportex.cells.LayerActiveState.cljs$lang$ctorPrWriter = (function (this__6801__auto__,writer__6802__auto__){
return cljs.core._write(writer__6802__auto__,"org.nfrac.comportex.cells/LayerActiveState");
});

org.nfrac.comportex.cells.__GT_LayerActiveState = (function org$nfrac$comportex$cells$__GT_LayerActiveState(in_ff_bits,in_stable_ff_bits,col_overlaps,matching_ff_seg_paths,stable_active_cells,active_cols,burst_cols,col_active_cells,active_cells,timestep){
return (new org.nfrac.comportex.cells.LayerActiveState(in_ff_bits,in_stable_ff_bits,col_overlaps,matching_ff_seg_paths,stable_active_cells,active_cols,burst_cols,col_active_cells,active_cells,timestep,null,null,null));
});

org.nfrac.comportex.cells.map__GT_LayerActiveState = (function org$nfrac$comportex$cells$map__GT_LayerActiveState(G__36832){
return (new org.nfrac.comportex.cells.LayerActiveState(cljs.core.cst$kw$in_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$col_DASH_overlaps.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$stable_DASH_active_DASH_cells.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$active_DASH_cols.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$burst_DASH_cols.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$col_DASH_active_DASH_cells.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$active_DASH_cells.cljs$core$IFn$_invoke$arity$1(G__36832),cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(G__36832),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__36832,cljs.core.cst$kw$in_DASH_ff_DASH_bits,cljs.core.array_seq([cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits,cljs.core.cst$kw$col_DASH_overlaps,cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,cljs.core.cst$kw$stable_DASH_active_DASH_cells,cljs.core.cst$kw$active_DASH_cols,cljs.core.cst$kw$burst_DASH_cols,cljs.core.cst$kw$col_DASH_active_DASH_cells,cljs.core.cst$kw$active_DASH_cells,cljs.core.cst$kw$timestep], 0)),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
org.nfrac.comportex.cells.LayerTPState = (function (out_stable_ff_bits,__meta,__extmap,__hash){
this.out_stable_ff_bits = out_stable_ff_bits;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6767__auto__,k__6768__auto__){
var self__ = this;
var this__6767__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__6767__auto____$1,k__6768__auto__,null);
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6769__auto__,k36839,else__6770__auto__){
var self__ = this;
var this__6769__auto____$1 = this;
var G__36841 = (((k36839 instanceof cljs.core.Keyword))?k36839.fqn:null);
switch (G__36841) {
case "out-stable-ff-bits":
return self__.out_stable_ff_bits;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k36839,else__6770__auto__);

}
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6781__auto__,writer__6782__auto__,opts__6783__auto__){
var self__ = this;
var this__6781__auto____$1 = this;
var pr_pair__6784__auto__ = ((function (this__6781__auto____$1){
return (function (keyval__6785__auto__){
return cljs.core.pr_sequential_writer(writer__6782__auto__,cljs.core.pr_writer,""," ","",opts__6783__auto__,keyval__6785__auto__);
});})(this__6781__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__6782__auto__,pr_pair__6784__auto__,"#org.nfrac.comportex.cells.LayerTPState{",", ","}",opts__6783__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits,self__.out_stable_ff_bits],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IIterable$ = true;

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36838){
var self__ = this;
var G__36838__$1 = this;
return (new cljs.core.RecordIter((0),G__36838__$1,1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits], null),cljs.core._iterator(self__.__extmap)));
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6765__auto__){
var self__ = this;
var this__6765__auto____$1 = this;
return self__.__meta;
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6761__auto__){
var self__ = this;
var this__6761__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerTPState(self__.out_stable_ff_bits,self__.__meta,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6771__auto__){
var self__ = this;
var this__6771__auto____$1 = this;
return (1 + cljs.core.count(self__.__extmap));
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6762__auto__){
var self__ = this;
var this__6762__auto____$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_imap(this__6762__auto____$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6763__auto__,other__6764__auto__){
var self__ = this;
var this__6763__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6141__auto__ = other__6764__auto__;
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (this__6763__auto____$1.constructor === other__6764__auto__.constructor);
if(and__6141__auto____$1){
return cljs.core.equiv_map(this__6763__auto____$1,other__6764__auto__);
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})())){
return true;
} else {
return false;
}
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6776__auto__,k__6777__auto__){
var self__ = this;
var this__6776__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits,null], null), null),k__6777__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__6776__auto____$1),self__.__meta),k__6777__auto__);
} else {
return (new org.nfrac.comportex.cells.LayerTPState(self__.out_stable_ff_bits,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__6777__auto__)),null));
}
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6774__auto__,k__6775__auto__,G__36838){
var self__ = this;
var this__6774__auto____$1 = this;
var pred__36842 = cljs.core.keyword_identical_QMARK_;
var expr__36843 = k__6775__auto__;
if(cljs.core.truth_((pred__36842.cljs$core$IFn$_invoke$arity$2 ? pred__36842.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits,expr__36843) : pred__36842.call(null,cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits,expr__36843)))){
return (new org.nfrac.comportex.cells.LayerTPState(G__36838,self__.__meta,self__.__extmap,null));
} else {
return (new org.nfrac.comportex.cells.LayerTPState(self__.out_stable_ff_bits,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__6775__auto__,G__36838),null));
}
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6779__auto__){
var self__ = this;
var this__6779__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits,self__.out_stable_ff_bits],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6766__auto__,G__36838){
var self__ = this;
var this__6766__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerTPState(self__.out_stable_ff_bits,G__36838,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerTPState.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6772__auto__,entry__6773__auto__){
var self__ = this;
var this__6772__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__6773__auto__)){
return cljs.core._assoc(this__6772__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__6772__auto____$1,entry__6773__auto__);
}
});

org.nfrac.comportex.cells.LayerTPState.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$out_DASH_stable_DASH_ff_DASH_bits], null);
});

org.nfrac.comportex.cells.LayerTPState.cljs$lang$type = true;

org.nfrac.comportex.cells.LayerTPState.cljs$lang$ctorPrSeq = (function (this__6801__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"org.nfrac.comportex.cells/LayerTPState");
});

org.nfrac.comportex.cells.LayerTPState.cljs$lang$ctorPrWriter = (function (this__6801__auto__,writer__6802__auto__){
return cljs.core._write(writer__6802__auto__,"org.nfrac.comportex.cells/LayerTPState");
});

org.nfrac.comportex.cells.__GT_LayerTPState = (function org$nfrac$comportex$cells$__GT_LayerTPState(out_stable_ff_bits){
return (new org.nfrac.comportex.cells.LayerTPState(out_stable_ff_bits,null,null,null));
});

org.nfrac.comportex.cells.map__GT_LayerTPState = (function org$nfrac$comportex$cells$map__GT_LayerTPState(G__36840){
return (new org.nfrac.comportex.cells.LayerTPState(cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(G__36840),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(G__36840,cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
org.nfrac.comportex.cells.LayerLearnState = (function (col_winners,winner_seg,learning_cells,learning,punishments,prior_active_cells,timestep,__meta,__extmap,__hash){
this.col_winners = col_winners;
this.winner_seg = winner_seg;
this.learning_cells = learning_cells;
this.learning = learning;
this.punishments = punishments;
this.prior_active_cells = prior_active_cells;
this.timestep = timestep;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6767__auto__,k__6768__auto__){
var self__ = this;
var this__6767__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__6767__auto____$1,k__6768__auto__,null);
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6769__auto__,k36847,else__6770__auto__){
var self__ = this;
var this__6769__auto____$1 = this;
var G__36849 = (((k36847 instanceof cljs.core.Keyword))?k36847.fqn:null);
switch (G__36849) {
case "col-winners":
return self__.col_winners;

break;
case "winner-seg":
return self__.winner_seg;

break;
case "learning-cells":
return self__.learning_cells;

break;
case "learning":
return self__.learning;

break;
case "punishments":
return self__.punishments;

break;
case "prior-active-cells":
return self__.prior_active_cells;

break;
case "timestep":
return self__.timestep;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k36847,else__6770__auto__);

}
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6781__auto__,writer__6782__auto__,opts__6783__auto__){
var self__ = this;
var this__6781__auto____$1 = this;
var pr_pair__6784__auto__ = ((function (this__6781__auto____$1){
return (function (keyval__6785__auto__){
return cljs.core.pr_sequential_writer(writer__6782__auto__,cljs.core.pr_writer,""," ","",opts__6783__auto__,keyval__6785__auto__);
});})(this__6781__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__6782__auto__,pr_pair__6784__auto__,"#org.nfrac.comportex.cells.LayerLearnState{",", ","}",opts__6783__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$col_DASH_winners,self__.col_winners],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$winner_DASH_seg,self__.winner_seg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$learning_DASH_cells,self__.learning_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$learning,self__.learning],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$punishments,self__.punishments],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$prior_DASH_active_DASH_cells,self__.prior_active_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timestep,self__.timestep],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IIterable$ = true;

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36846){
var self__ = this;
var G__36846__$1 = this;
return (new cljs.core.RecordIter((0),G__36846__$1,7,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$col_DASH_winners,cljs.core.cst$kw$winner_DASH_seg,cljs.core.cst$kw$learning_DASH_cells,cljs.core.cst$kw$learning,cljs.core.cst$kw$punishments,cljs.core.cst$kw$prior_DASH_active_DASH_cells,cljs.core.cst$kw$timestep], null),cljs.core._iterator(self__.__extmap)));
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6765__auto__){
var self__ = this;
var this__6765__auto____$1 = this;
return self__.__meta;
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6761__auto__){
var self__ = this;
var this__6761__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,self__.learning_cells,self__.learning,self__.punishments,self__.prior_active_cells,self__.timestep,self__.__meta,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6771__auto__){
var self__ = this;
var this__6771__auto____$1 = this;
return (7 + cljs.core.count(self__.__extmap));
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6762__auto__){
var self__ = this;
var this__6762__auto____$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_imap(this__6762__auto____$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6763__auto__,other__6764__auto__){
var self__ = this;
var this__6763__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6141__auto__ = other__6764__auto__;
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (this__6763__auto____$1.constructor === other__6764__auto__.constructor);
if(and__6141__auto____$1){
return cljs.core.equiv_map(this__6763__auto____$1,other__6764__auto__);
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})())){
return true;
} else {
return false;
}
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6776__auto__,k__6777__auto__){
var self__ = this;
var this__6776__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$prior_DASH_active_DASH_cells,null,cljs.core.cst$kw$punishments,null,cljs.core.cst$kw$timestep,null,cljs.core.cst$kw$winner_DASH_seg,null,cljs.core.cst$kw$learning,null,cljs.core.cst$kw$learning_DASH_cells,null,cljs.core.cst$kw$col_DASH_winners,null], null), null),k__6777__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__6776__auto____$1),self__.__meta),k__6777__auto__);
} else {
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,self__.learning_cells,self__.learning,self__.punishments,self__.prior_active_cells,self__.timestep,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__6777__auto__)),null));
}
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6774__auto__,k__6775__auto__,G__36846){
var self__ = this;
var this__6774__auto____$1 = this;
var pred__36850 = cljs.core.keyword_identical_QMARK_;
var expr__36851 = k__6775__auto__;
if(cljs.core.truth_((pred__36850.cljs$core$IFn$_invoke$arity$2 ? pred__36850.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$col_DASH_winners,expr__36851) : pred__36850.call(null,cljs.core.cst$kw$col_DASH_winners,expr__36851)))){
return (new org.nfrac.comportex.cells.LayerLearnState(G__36846,self__.winner_seg,self__.learning_cells,self__.learning,self__.punishments,self__.prior_active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36850.cljs$core$IFn$_invoke$arity$2 ? pred__36850.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$winner_DASH_seg,expr__36851) : pred__36850.call(null,cljs.core.cst$kw$winner_DASH_seg,expr__36851)))){
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,G__36846,self__.learning_cells,self__.learning,self__.punishments,self__.prior_active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36850.cljs$core$IFn$_invoke$arity$2 ? pred__36850.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$learning_DASH_cells,expr__36851) : pred__36850.call(null,cljs.core.cst$kw$learning_DASH_cells,expr__36851)))){
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,G__36846,self__.learning,self__.punishments,self__.prior_active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36850.cljs$core$IFn$_invoke$arity$2 ? pred__36850.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$learning,expr__36851) : pred__36850.call(null,cljs.core.cst$kw$learning,expr__36851)))){
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,self__.learning_cells,G__36846,self__.punishments,self__.prior_active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36850.cljs$core$IFn$_invoke$arity$2 ? pred__36850.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$punishments,expr__36851) : pred__36850.call(null,cljs.core.cst$kw$punishments,expr__36851)))){
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,self__.learning_cells,self__.learning,G__36846,self__.prior_active_cells,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36850.cljs$core$IFn$_invoke$arity$2 ? pred__36850.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$prior_DASH_active_DASH_cells,expr__36851) : pred__36850.call(null,cljs.core.cst$kw$prior_DASH_active_DASH_cells,expr__36851)))){
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,self__.learning_cells,self__.learning,self__.punishments,G__36846,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36850.cljs$core$IFn$_invoke$arity$2 ? pred__36850.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$timestep,expr__36851) : pred__36850.call(null,cljs.core.cst$kw$timestep,expr__36851)))){
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,self__.learning_cells,self__.learning,self__.punishments,self__.prior_active_cells,G__36846,self__.__meta,self__.__extmap,null));
} else {
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,self__.learning_cells,self__.learning,self__.punishments,self__.prior_active_cells,self__.timestep,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__6775__auto__,G__36846),null));
}
}
}
}
}
}
}
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6779__auto__){
var self__ = this;
var this__6779__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$col_DASH_winners,self__.col_winners],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$winner_DASH_seg,self__.winner_seg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$learning_DASH_cells,self__.learning_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$learning,self__.learning],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$punishments,self__.punishments],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$prior_DASH_active_DASH_cells,self__.prior_active_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timestep,self__.timestep],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6766__auto__,G__36846){
var self__ = this;
var this__6766__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerLearnState(self__.col_winners,self__.winner_seg,self__.learning_cells,self__.learning,self__.punishments,self__.prior_active_cells,self__.timestep,G__36846,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerLearnState.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6772__auto__,entry__6773__auto__){
var self__ = this;
var this__6772__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__6773__auto__)){
return cljs.core._assoc(this__6772__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__6772__auto____$1,entry__6773__auto__);
}
});

org.nfrac.comportex.cells.LayerLearnState.getBasis = (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$col_DASH_winners,cljs.core.cst$sym$winner_DASH_seg,cljs.core.cst$sym$learning_DASH_cells,cljs.core.cst$sym$learning,cljs.core.cst$sym$punishments,cljs.core.cst$sym$prior_DASH_active_DASH_cells,cljs.core.cst$sym$timestep], null);
});

org.nfrac.comportex.cells.LayerLearnState.cljs$lang$type = true;

org.nfrac.comportex.cells.LayerLearnState.cljs$lang$ctorPrSeq = (function (this__6801__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"org.nfrac.comportex.cells/LayerLearnState");
});

org.nfrac.comportex.cells.LayerLearnState.cljs$lang$ctorPrWriter = (function (this__6801__auto__,writer__6802__auto__){
return cljs.core._write(writer__6802__auto__,"org.nfrac.comportex.cells/LayerLearnState");
});

org.nfrac.comportex.cells.__GT_LayerLearnState = (function org$nfrac$comportex$cells$__GT_LayerLearnState(col_winners,winner_seg,learning_cells,learning,punishments,prior_active_cells,timestep){
return (new org.nfrac.comportex.cells.LayerLearnState(col_winners,winner_seg,learning_cells,learning,punishments,prior_active_cells,timestep,null,null,null));
});

org.nfrac.comportex.cells.map__GT_LayerLearnState = (function org$nfrac$comportex$cells$map__GT_LayerLearnState(G__36848){
return (new org.nfrac.comportex.cells.LayerLearnState(cljs.core.cst$kw$col_DASH_winners.cljs$core$IFn$_invoke$arity$1(G__36848),cljs.core.cst$kw$winner_DASH_seg.cljs$core$IFn$_invoke$arity$1(G__36848),cljs.core.cst$kw$learning_DASH_cells.cljs$core$IFn$_invoke$arity$1(G__36848),cljs.core.cst$kw$learning.cljs$core$IFn$_invoke$arity$1(G__36848),cljs.core.cst$kw$punishments.cljs$core$IFn$_invoke$arity$1(G__36848),cljs.core.cst$kw$prior_DASH_active_DASH_cells.cljs$core$IFn$_invoke$arity$1(G__36848),cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(G__36848),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__36848,cljs.core.cst$kw$col_DASH_winners,cljs.core.array_seq([cljs.core.cst$kw$winner_DASH_seg,cljs.core.cst$kw$learning_DASH_cells,cljs.core.cst$kw$learning,cljs.core.cst$kw$punishments,cljs.core.cst$kw$prior_DASH_active_DASH_cells,cljs.core.cst$kw$timestep], 0)),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
org.nfrac.comportex.cells.LayerDistalState = (function (active_bits,learnable_bits,cell_exc,pred_cells,matching_seg_paths,timestep,__meta,__extmap,__hash){
this.active_bits = active_bits;
this.learnable_bits = learnable_bits;
this.cell_exc = cell_exc;
this.pred_cells = pred_cells;
this.matching_seg_paths = matching_seg_paths;
this.timestep = timestep;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6767__auto__,k__6768__auto__){
var self__ = this;
var this__6767__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__6767__auto____$1,k__6768__auto__,null);
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6769__auto__,k36855,else__6770__auto__){
var self__ = this;
var this__6769__auto____$1 = this;
var G__36857 = (((k36855 instanceof cljs.core.Keyword))?k36855.fqn:null);
switch (G__36857) {
case "active-bits":
return self__.active_bits;

break;
case "learnable-bits":
return self__.learnable_bits;

break;
case "cell-exc":
return self__.cell_exc;

break;
case "pred-cells":
return self__.pred_cells;

break;
case "matching-seg-paths":
return self__.matching_seg_paths;

break;
case "timestep":
return self__.timestep;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k36855,else__6770__auto__);

}
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6781__auto__,writer__6782__auto__,opts__6783__auto__){
var self__ = this;
var this__6781__auto____$1 = this;
var pr_pair__6784__auto__ = ((function (this__6781__auto____$1){
return (function (keyval__6785__auto__){
return cljs.core.pr_sequential_writer(writer__6782__auto__,cljs.core.pr_writer,""," ","",opts__6783__auto__,keyval__6785__auto__);
});})(this__6781__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__6782__auto__,pr_pair__6784__auto__,"#org.nfrac.comportex.cells.LayerDistalState{",", ","}",opts__6783__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$active_DASH_bits,self__.active_bits],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$learnable_DASH_bits,self__.learnable_bits],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$cell_DASH_exc,self__.cell_exc],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pred_DASH_cells,self__.pred_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$matching_DASH_seg_DASH_paths,self__.matching_seg_paths],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timestep,self__.timestep],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IIterable$ = true;

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36854){
var self__ = this;
var G__36854__$1 = this;
return (new cljs.core.RecordIter((0),G__36854__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$active_DASH_bits,cljs.core.cst$kw$learnable_DASH_bits,cljs.core.cst$kw$cell_DASH_exc,cljs.core.cst$kw$pred_DASH_cells,cljs.core.cst$kw$matching_DASH_seg_DASH_paths,cljs.core.cst$kw$timestep], null),cljs.core._iterator(self__.__extmap)));
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6765__auto__){
var self__ = this;
var this__6765__auto____$1 = this;
return self__.__meta;
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6761__auto__){
var self__ = this;
var this__6761__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,self__.learnable_bits,self__.cell_exc,self__.pred_cells,self__.matching_seg_paths,self__.timestep,self__.__meta,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6771__auto__){
var self__ = this;
var this__6771__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6762__auto__){
var self__ = this;
var this__6762__auto____$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_imap(this__6762__auto____$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6763__auto__,other__6764__auto__){
var self__ = this;
var this__6763__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6141__auto__ = other__6764__auto__;
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (this__6763__auto____$1.constructor === other__6764__auto__.constructor);
if(and__6141__auto____$1){
return cljs.core.equiv_map(this__6763__auto____$1,other__6764__auto__);
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})())){
return true;
} else {
return false;
}
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6776__auto__,k__6777__auto__){
var self__ = this;
var this__6776__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$pred_DASH_cells,null,cljs.core.cst$kw$learnable_DASH_bits,null,cljs.core.cst$kw$active_DASH_bits,null,cljs.core.cst$kw$matching_DASH_seg_DASH_paths,null,cljs.core.cst$kw$timestep,null,cljs.core.cst$kw$cell_DASH_exc,null], null), null),k__6777__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__6776__auto____$1),self__.__meta),k__6777__auto__);
} else {
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,self__.learnable_bits,self__.cell_exc,self__.pred_cells,self__.matching_seg_paths,self__.timestep,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__6777__auto__)),null));
}
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6774__auto__,k__6775__auto__,G__36854){
var self__ = this;
var this__6774__auto____$1 = this;
var pred__36858 = cljs.core.keyword_identical_QMARK_;
var expr__36859 = k__6775__auto__;
if(cljs.core.truth_((pred__36858.cljs$core$IFn$_invoke$arity$2 ? pred__36858.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$active_DASH_bits,expr__36859) : pred__36858.call(null,cljs.core.cst$kw$active_DASH_bits,expr__36859)))){
return (new org.nfrac.comportex.cells.LayerDistalState(G__36854,self__.learnable_bits,self__.cell_exc,self__.pred_cells,self__.matching_seg_paths,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36858.cljs$core$IFn$_invoke$arity$2 ? pred__36858.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$learnable_DASH_bits,expr__36859) : pred__36858.call(null,cljs.core.cst$kw$learnable_DASH_bits,expr__36859)))){
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,G__36854,self__.cell_exc,self__.pred_cells,self__.matching_seg_paths,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36858.cljs$core$IFn$_invoke$arity$2 ? pred__36858.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$cell_DASH_exc,expr__36859) : pred__36858.call(null,cljs.core.cst$kw$cell_DASH_exc,expr__36859)))){
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,self__.learnable_bits,G__36854,self__.pred_cells,self__.matching_seg_paths,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36858.cljs$core$IFn$_invoke$arity$2 ? pred__36858.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$pred_DASH_cells,expr__36859) : pred__36858.call(null,cljs.core.cst$kw$pred_DASH_cells,expr__36859)))){
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,self__.learnable_bits,self__.cell_exc,G__36854,self__.matching_seg_paths,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36858.cljs$core$IFn$_invoke$arity$2 ? pred__36858.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$matching_DASH_seg_DASH_paths,expr__36859) : pred__36858.call(null,cljs.core.cst$kw$matching_DASH_seg_DASH_paths,expr__36859)))){
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,self__.learnable_bits,self__.cell_exc,self__.pred_cells,G__36854,self__.timestep,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36858.cljs$core$IFn$_invoke$arity$2 ? pred__36858.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$timestep,expr__36859) : pred__36858.call(null,cljs.core.cst$kw$timestep,expr__36859)))){
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,self__.learnable_bits,self__.cell_exc,self__.pred_cells,self__.matching_seg_paths,G__36854,self__.__meta,self__.__extmap,null));
} else {
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,self__.learnable_bits,self__.cell_exc,self__.pred_cells,self__.matching_seg_paths,self__.timestep,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__6775__auto__,G__36854),null));
}
}
}
}
}
}
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6779__auto__){
var self__ = this;
var this__6779__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$active_DASH_bits,self__.active_bits],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$learnable_DASH_bits,self__.learnable_bits],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$cell_DASH_exc,self__.cell_exc],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pred_DASH_cells,self__.pred_cells],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$matching_DASH_seg_DASH_paths,self__.matching_seg_paths],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$timestep,self__.timestep],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6766__auto__,G__36854){
var self__ = this;
var this__6766__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerDistalState(self__.active_bits,self__.learnable_bits,self__.cell_exc,self__.pred_cells,self__.matching_seg_paths,self__.timestep,G__36854,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerDistalState.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6772__auto__,entry__6773__auto__){
var self__ = this;
var this__6772__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__6773__auto__)){
return cljs.core._assoc(this__6772__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__6772__auto____$1,entry__6773__auto__);
}
});

org.nfrac.comportex.cells.LayerDistalState.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$active_DASH_bits,cljs.core.cst$sym$learnable_DASH_bits,cljs.core.cst$sym$cell_DASH_exc,cljs.core.cst$sym$pred_DASH_cells,cljs.core.cst$sym$matching_DASH_seg_DASH_paths,cljs.core.cst$sym$timestep], null);
});

org.nfrac.comportex.cells.LayerDistalState.cljs$lang$type = true;

org.nfrac.comportex.cells.LayerDistalState.cljs$lang$ctorPrSeq = (function (this__6801__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"org.nfrac.comportex.cells/LayerDistalState");
});

org.nfrac.comportex.cells.LayerDistalState.cljs$lang$ctorPrWriter = (function (this__6801__auto__,writer__6802__auto__){
return cljs.core._write(writer__6802__auto__,"org.nfrac.comportex.cells/LayerDistalState");
});

org.nfrac.comportex.cells.__GT_LayerDistalState = (function org$nfrac$comportex$cells$__GT_LayerDistalState(active_bits,learnable_bits,cell_exc,pred_cells,matching_seg_paths,timestep){
return (new org.nfrac.comportex.cells.LayerDistalState(active_bits,learnable_bits,cell_exc,pred_cells,matching_seg_paths,timestep,null,null,null));
});

org.nfrac.comportex.cells.map__GT_LayerDistalState = (function org$nfrac$comportex$cells$map__GT_LayerDistalState(G__36856){
return (new org.nfrac.comportex.cells.LayerDistalState(cljs.core.cst$kw$active_DASH_bits.cljs$core$IFn$_invoke$arity$1(G__36856),cljs.core.cst$kw$learnable_DASH_bits.cljs$core$IFn$_invoke$arity$1(G__36856),cljs.core.cst$kw$cell_DASH_exc.cljs$core$IFn$_invoke$arity$1(G__36856),cljs.core.cst$kw$pred_DASH_cells.cljs$core$IFn$_invoke$arity$1(G__36856),cljs.core.cst$kw$matching_DASH_seg_DASH_paths.cljs$core$IFn$_invoke$arity$1(G__36856),cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(G__36856),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__36856,cljs.core.cst$kw$active_DASH_bits,cljs.core.array_seq([cljs.core.cst$kw$learnable_DASH_bits,cljs.core.cst$kw$cell_DASH_exc,cljs.core.cst$kw$pred_DASH_cells,cljs.core.cst$kw$matching_DASH_seg_DASH_paths,cljs.core.cst$kw$timestep], 0)),null));
});

org.nfrac.comportex.cells.empty_active_state = org.nfrac.comportex.cells.map__GT_LayerActiveState(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$active_DASH_cells,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$active_DASH_cols,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,cljs.core.PersistentArrayMap.EMPTY], null));
org.nfrac.comportex.cells.empty_learn_state = org.nfrac.comportex.cells.map__GT_LayerLearnState(new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$col_DASH_winners,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$learning_DASH_cells,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$learning,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$punishments,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$prior_DASH_active_DASH_cells,cljs.core.PersistentHashSet.EMPTY], null));
org.nfrac.comportex.cells.empty_distal_state = org.nfrac.comportex.cells.map__GT_LayerDistalState(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$active_DASH_bits,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$cell_DASH_exc,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$pred_DASH_cells,cljs.core.PersistentHashSet.EMPTY,cljs.core.cst$kw$matching_DASH_seg_DASH_paths,cljs.core.PersistentArrayMap.EMPTY], null));
if(typeof org.nfrac.comportex.cells.spatial_pooling !== 'undefined'){
} else {
/**
 * Spatial pooling: choosing a column representation.
 *   Returns keys
 * 
 *   * :active-cols
 *   * :matching-ff-seg-paths
 *   * :col-overlaps
 *   
 */
org.nfrac.comportex.cells.spatial_pooling = (function (){var method_table__7066__auto__ = (function (){var G__36862 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36862) : cljs.core.atom.call(null,G__36862));
})();
var prefer_table__7067__auto__ = (function (){var G__36863 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36863) : cljs.core.atom.call(null,G__36863));
})();
var method_cache__7068__auto__ = (function (){var G__36864 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36864) : cljs.core.atom.call(null,G__36864));
})();
var cached_hierarchy__7069__auto__ = (function (){var G__36865 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36865) : cljs.core.atom.call(null,G__36865));
})();
var hierarchy__7070__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("org.nfrac.comportex.cells","spatial-pooling"),((function (method_table__7066__auto__,prefer_table__7067__auto__,method_cache__7068__auto__,cached_hierarchy__7069__auto__,hierarchy__7070__auto__){
return (function (layer,ff_bits,stable_ff_bits,fb_cell_exc){
return cljs.core.cst$kw$spatial_DASH_pooling.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(layer));
});})(method_table__7066__auto__,prefer_table__7067__auto__,method_cache__7068__auto__,cached_hierarchy__7069__auto__,hierarchy__7070__auto__))
,cljs.core.cst$kw$default,hierarchy__7070__auto__,method_table__7066__auto__,prefer_table__7067__auto__,method_cache__7068__auto__,cached_hierarchy__7069__auto__));
})();
}
if(typeof org.nfrac.comportex.cells.temporal_pooling !== 'undefined'){
} else {
/**
 * Temporal pooling: a relatively stable layer output signal over time.
 *   Returns keys
 * 
 *   * :out-stable-ff-bits
 *   
 */
org.nfrac.comportex.cells.temporal_pooling = (function (){var method_table__7066__auto__ = (function (){var G__36866 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36866) : cljs.core.atom.call(null,G__36866));
})();
var prefer_table__7067__auto__ = (function (){var G__36867 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36867) : cljs.core.atom.call(null,G__36867));
})();
var method_cache__7068__auto__ = (function (){var G__36868 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36868) : cljs.core.atom.call(null,G__36868));
})();
var cached_hierarchy__7069__auto__ = (function (){var G__36869 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__36869) : cljs.core.atom.call(null,G__36869));
})();
var hierarchy__7070__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,cljs.core.get_global_hierarchy());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("org.nfrac.comportex.cells","temporal-pooling"),((function (method_table__7066__auto__,prefer_table__7067__auto__,method_cache__7068__auto__,cached_hierarchy__7069__auto__,hierarchy__7070__auto__){
return (function (layer,active_state,prev_tp_state){
return cljs.core.cst$kw$temporal_DASH_pooling.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(layer));
});})(method_table__7066__auto__,prefer_table__7067__auto__,method_cache__7068__auto__,cached_hierarchy__7069__auto__,hierarchy__7070__auto__))
,cljs.core.cst$kw$default,hierarchy__7070__auto__,method_table__7066__auto__,prefer_table__7067__auto__,method_cache__7068__auto__,cached_hierarchy__7069__auto__));
})();
}
org.nfrac.comportex.cells.spatial_pooling.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$standard,(function (layer,ff_bits,stable_ff_bits,fb_cell_exc){
var proximal_sg = cljs.core.cst$kw$proximal_DASH_sg.cljs$core$IFn$_invoke$arity$1(layer);
var boosts = cljs.core.cst$kw$boosts.cljs$core$IFn$_invoke$arity$1(layer);
var spec = cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(layer);
var col_seg_overlaps = org.nfrac.comportex.protocols.excitations(proximal_sg,ff_bits,cljs.core.cst$kw$stimulus_DASH_threshold.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(spec)));
var vec__36870 = org.nfrac.comportex.cells.best_segment_excitations_and_paths(col_seg_overlaps);
var raw_col_exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36870,(0),null);
var ff_seg_paths = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36870,(1),null);
var col_exc = org.nfrac.comportex.columns.apply_overlap_boosting(raw_col_exc,boosts);
var abs_cell_exc = org.nfrac.comportex.cells.total_excitations(col_exc,fb_cell_exc,cljs.core.cst$kw$distal_DASH_vs_DASH_proximal_DASH_weight.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$spontaneous_DASH_activation_QMARK_.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(spec));
var n_on = (function (){var x__6484__auto__ = (1);
var y__6485__auto__ = org.nfrac.comportex.util.round.cljs$core$IFn$_invoke$arity$1((cljs.core.cst$kw$activation_DASH_level.cljs$core$IFn$_invoke$arity$1(spec) * org.nfrac.comportex.protocols.size_of(layer)));
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})();
var a_cols = cljs.core.set(org.nfrac.comportex.inhibition.inhibit_globally(org.nfrac.comportex.cells.best_by_column(abs_cell_exc),n_on));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$active_DASH_cols,a_cols,cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,ff_seg_paths,cljs.core.cst$kw$col_DASH_overlaps,raw_col_exc], null);
}));
org.nfrac.comportex.cells.spatial_pooling.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_inhibition,(function (layer,ff_bits,stable_ff_bits,fb_cell_exc){
var proximal_sg = cljs.core.cst$kw$proximal_DASH_sg.cljs$core$IFn$_invoke$arity$1(layer);
var boosts = cljs.core.cst$kw$boosts.cljs$core$IFn$_invoke$arity$1(layer);
var spec = cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(layer);
var col_seg_overlaps = org.nfrac.comportex.protocols.excitations(proximal_sg,ff_bits,cljs.core.cst$kw$stimulus_DASH_threshold.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(spec)));
var vec__36871 = org.nfrac.comportex.cells.best_segment_excitations_and_paths(col_seg_overlaps);
var raw_col_exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36871,(0),null);
var ff_seg_paths = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36871,(1),null);
var col_exc = org.nfrac.comportex.columns.apply_overlap_boosting(raw_col_exc,boosts);
var abs_cell_exc = org.nfrac.comportex.cells.total_excitations(col_exc,fb_cell_exc,cljs.core.cst$kw$distal_DASH_vs_DASH_proximal_DASH_weight.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$spontaneous_DASH_activation_QMARK_.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(spec));
var n_on = (function (){var x__6484__auto__ = (1);
var y__6485__auto__ = org.nfrac.comportex.util.round.cljs$core$IFn$_invoke$arity$1((cljs.core.cst$kw$activation_DASH_level.cljs$core$IFn$_invoke$arity$1(spec) * org.nfrac.comportex.protocols.size_of(layer)));
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})();
var a_cols = cljs.core.set(org.nfrac.comportex.inhibition.inhibit_locally(org.nfrac.comportex.cells.best_by_column(abs_cell_exc),cljs.core.cst$kw$topology.cljs$core$IFn$_invoke$arity$1(layer),(cljs.core.cst$kw$inh_DASH_radius.cljs$core$IFn$_invoke$arity$1(layer) * cljs.core.cst$kw$inh_DASH_radius_DASH_scale.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$inhibition_DASH_base_DASH_distance.cljs$core$IFn$_invoke$arity$1(spec),n_on));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$active_DASH_cols,a_cols,cljs.core.cst$kw$matching_DASH_ff_DASH_seg_DASH_paths,ff_seg_paths,cljs.core.cst$kw$col_DASH_overlaps,raw_col_exc], null);
}));
org.nfrac.comportex.cells.compute_active_state = (function org$nfrac$comportex$cells$compute_active_state(layer,ff_bits,stable_ff_bits){
var spec = cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(layer);
var distal_state = cljs.core.cst$kw$distal_DASH_state.cljs$core$IFn$_invoke$arity$1(layer);
var apical_state = cljs.core.cst$kw$apical_DASH_state.cljs$core$IFn$_invoke$arity$1(layer);
var fb_cell_exc = (cljs.core.truth_(cljs.core.cst$kw$use_DASH_feedback_QMARK_.cljs$core$IFn$_invoke$arity$1(spec))?cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._PLUS_,cljs.core.array_seq([cljs.core.cst$kw$cell_DASH_exc.cljs$core$IFn$_invoke$arity$1(distal_state),cljs.core.select_keys(cljs.core.cst$kw$cell_DASH_exc.cljs$core$IFn$_invoke$arity$1(apical_state),cljs.core.keys(cljs.core.cst$kw$cell_DASH_exc.cljs$core$IFn$_invoke$arity$1(distal_state)))], 0)):cljs.core.cst$kw$cell_DASH_exc.cljs$core$IFn$_invoke$arity$1(distal_state));
var sp_info = (org.nfrac.comportex.cells.spatial_pooling.cljs$core$IFn$_invoke$arity$4 ? org.nfrac.comportex.cells.spatial_pooling.cljs$core$IFn$_invoke$arity$4(layer,ff_bits,stable_ff_bits,fb_cell_exc) : org.nfrac.comportex.cells.spatial_pooling.call(null,layer,ff_bits,stable_ff_bits,fb_cell_exc));
var cell_info = org.nfrac.comportex.cells.select_active_cells(cljs.core.cst$kw$active_DASH_cols.cljs$core$IFn$_invoke$arity$1(sp_info),fb_cell_exc,cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$stimulus_DASH_threshold.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$dominance_DASH_margin.cljs$core$IFn$_invoke$arity$1(spec));
var depth = cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(spec);
return org.nfrac.comportex.cells.map__GT_LayerActiveState(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([sp_info,cell_info,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$in_DASH_ff_DASH_bits,ff_bits,cljs.core.cst$kw$in_DASH_stable_DASH_ff_DASH_bits,stable_ff_bits,cljs.core.cst$kw$out_DASH_immediate_DASH_ff_DASH_bits,org.nfrac.comportex.cells.cells__GT_bits(depth,cljs.core.cst$kw$active_DASH_cells.cljs$core$IFn$_invoke$arity$1(cell_info)),cljs.core.cst$kw$timestep,(cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(layer)) + (1))], null)], 0)));
});
org.nfrac.comportex.cells.temporal_pooling.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$standard,(function (layer,active_state,prev_tp_state){
var spec = cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(layer);
var new_stable_cells = cljs.core.cst$kw$stable_DASH_active_DASH_cells.cljs$core$IFn$_invoke$arity$1(active_state);
var stable_cells_buffer = cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var q = (function (){var or__6153__auto__ = cljs.core.cst$kw$stable_DASH_cells_DASH_buffer.cljs$core$IFn$_invoke$arity$1(prev_tp_state);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return org.nfrac.comportex.util.empty_queue;
}
})();
while(true){
if((cljs.core.count(q) >= cljs.core.cst$kw$stable_DASH_activation_DASH_steps.cljs$core$IFn$_invoke$arity$1(spec))){
var G__36872 = cljs.core.pop(q);
q = G__36872;
continue;
} else {
return q;
}
break;
}
})(),new_stable_cells);
var all_stable_cells = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(clojure.set.union,stable_cells_buffer);
var depth = cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(spec);
var all_stable_bits = cljs.core.set(org.nfrac.comportex.cells.cells__GT_bits(depth,all_stable_cells));
return org.nfrac.comportex.cells.map__GT_LayerTPState(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits,all_stable_bits,cljs.core.cst$kw$stable_DASH_cells_DASH_buffer,stable_cells_buffer], null));
}));
org.nfrac.comportex.cells.compute_tp_state = (function org$nfrac$comportex$cells$compute_tp_state(layer,active_state){
var G__36876 = layer;
var G__36877 = active_state;
var G__36878 = cljs.core.cst$kw$tp_DASH_state.cljs$core$IFn$_invoke$arity$1(layer);
return (org.nfrac.comportex.cells.temporal_pooling.cljs$core$IFn$_invoke$arity$3 ? org.nfrac.comportex.cells.temporal_pooling.cljs$core$IFn$_invoke$arity$3(G__36876,G__36877,G__36878) : org.nfrac.comportex.cells.temporal_pooling.call(null,G__36876,G__36877,G__36878));
});
org.nfrac.comportex.cells.compute_distal_state = (function org$nfrac$comportex$cells$compute_distal_state(sg,active_bits,learnable_bits,dspec,t){
var seg_exc = org.nfrac.comportex.protocols.excitations(sg,active_bits,cljs.core.cst$kw$stimulus_DASH_threshold.cljs$core$IFn$_invoke$arity$1(dspec));
var vec__36880 = org.nfrac.comportex.cells.best_segment_excitations_and_paths(seg_exc);
var cell_exc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36880,(0),null);
var seg_paths = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36880,(1),null);
var pc = cljs.core.set(cljs.core.keys(cell_exc));
return org.nfrac.comportex.cells.map__GT_LayerDistalState(new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$active_DASH_bits,cljs.core.set(active_bits),cljs.core.cst$kw$learnable_DASH_bits,cljs.core.set(learnable_bits),cljs.core.cst$kw$cell_DASH_exc,cell_exc,cljs.core.cst$kw$matching_DASH_seg_DASH_paths,seg_paths,cljs.core.cst$kw$pred_DASH_cells,pc,cljs.core.cst$kw$timestep,t], null));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {org.nfrac.comportex.protocols.PParameterised}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {org.nfrac.comportex.protocols.PFeedForward}
 * @implements {org.nfrac.comportex.protocols.PTemporal}
 * @implements {cljs.core.ICounted}
 * @implements {org.nfrac.comportex.protocols.PLayerOfCells}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {org.nfrac.comportex.protocols.PFeedBack}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {org.nfrac.comportex.protocols.PInterruptable}
 * @implements {org.nfrac.comportex.protocols.PTopological}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
org.nfrac.comportex.cells.LayerOfCells = (function (spec,rng,topology,input_topology,inh_radius,boosts,active_duty_cycles,overlap_duty_cycles,proximal_sg,distal_sg,apical_sg,ilateral_sg,state,prior_state,tp_state,distal_state,prior_distal_state,apical_state,prior_apical_state,learn_state,__meta,__extmap,__hash){
this.spec = spec;
this.rng = rng;
this.topology = topology;
this.input_topology = input_topology;
this.inh_radius = inh_radius;
this.boosts = boosts;
this.active_duty_cycles = active_duty_cycles;
this.overlap_duty_cycles = overlap_duty_cycles;
this.proximal_sg = proximal_sg;
this.distal_sg = distal_sg;
this.apical_sg = apical_sg;
this.ilateral_sg = ilateral_sg;
this.state = state;
this.prior_state = prior_state;
this.tp_state = tp_state;
this.distal_state = distal_state;
this.prior_distal_state = prior_distal_state;
this.apical_state = apical_state;
this.prior_apical_state = prior_apical_state;
this.learn_state = learn_state;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__6767__auto__,k__6768__auto__){
var self__ = this;
var this__6767__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__6767__auto____$1,k__6768__auto__,null);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__6769__auto__,k36882,else__6770__auto__){
var self__ = this;
var this__6769__auto____$1 = this;
var G__36884 = (((k36882 instanceof cljs.core.Keyword))?k36882.fqn:null);
switch (G__36884) {
case "rng":
return self__.rng;

break;
case "boosts":
return self__.boosts;

break;
case "inh-radius":
return self__.inh_radius;

break;
case "tp-state":
return self__.tp_state;

break;
case "apical-state":
return self__.apical_state;

break;
case "distal-state":
return self__.distal_state;

break;
case "active-duty-cycles":
return self__.active_duty_cycles;

break;
case "learn-state":
return self__.learn_state;

break;
case "state":
return self__.state;

break;
case "proximal-sg":
return self__.proximal_sg;

break;
case "overlap-duty-cycles":
return self__.overlap_duty_cycles;

break;
case "prior-state":
return self__.prior_state;

break;
case "spec":
return self__.spec;

break;
case "distal-sg":
return self__.distal_sg;

break;
case "prior-distal-state":
return self__.prior_distal_state;

break;
case "input-topology":
return self__.input_topology;

break;
case "apical-sg":
return self__.apical_sg;

break;
case "ilateral-sg":
return self__.ilateral_sg;

break;
case "prior-apical-state":
return self__.prior_apical_state;

break;
case "topology":
return self__.topology;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k36882,else__6770__auto__);

}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PTopological$ = true;

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PTopological$topology$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.cst$kw$topology.cljs$core$IFn$_invoke$arity$1(this$__$1);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__6781__auto__,writer__6782__auto__,opts__6783__auto__){
var self__ = this;
var this__6781__auto____$1 = this;
var pr_pair__6784__auto__ = ((function (this__6781__auto____$1){
return (function (keyval__6785__auto__){
return cljs.core.pr_sequential_writer(writer__6782__auto__,cljs.core.pr_writer,""," ","",opts__6783__auto__,keyval__6785__auto__);
});})(this__6781__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__6782__auto__,pr_pair__6784__auto__,"#org.nfrac.comportex.cells.LayerOfCells{",", ","}",opts__6783__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spec,self__.spec],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rng,self__.rng],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$topology,self__.topology],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$input_DASH_topology,self__.input_topology],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$inh_DASH_radius,self__.inh_radius],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$boosts,self__.boosts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$active_DASH_duty_DASH_cycles,self__.active_duty_cycles],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,self__.overlap_duty_cycles],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$proximal_DASH_sg,self__.proximal_sg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$distal_DASH_sg,self__.distal_sg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$apical_DASH_sg,self__.apical_sg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$ilateral_DASH_sg,self__.ilateral_sg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$prior_DASH_state,self__.prior_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tp_DASH_state,self__.tp_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$distal_DASH_state,self__.distal_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$prior_DASH_distal_DASH_state,self__.prior_distal_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$apical_DASH_state,self__.apical_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$prior_DASH_apical_DASH_state,self__.prior_apical_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$learn_DASH_state,self__.learn_state],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IIterable$ = true;

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__36881){
var self__ = this;
var G__36881__$1 = this;
return (new cljs.core.RecordIter((0),G__36881__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spec,cljs.core.cst$kw$rng,cljs.core.cst$kw$topology,cljs.core.cst$kw$input_DASH_topology,cljs.core.cst$kw$inh_DASH_radius,cljs.core.cst$kw$boosts,cljs.core.cst$kw$active_DASH_duty_DASH_cycles,cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,cljs.core.cst$kw$proximal_DASH_sg,cljs.core.cst$kw$distal_DASH_sg,cljs.core.cst$kw$apical_DASH_sg,cljs.core.cst$kw$ilateral_DASH_sg,cljs.core.cst$kw$state,cljs.core.cst$kw$prior_DASH_state,cljs.core.cst$kw$tp_DASH_state,cljs.core.cst$kw$distal_DASH_state,cljs.core.cst$kw$prior_DASH_distal_DASH_state,cljs.core.cst$kw$apical_DASH_state,cljs.core.cst$kw$prior_DASH_apical_DASH_state,cljs.core.cst$kw$learn_DASH_state], null),cljs.core._iterator(self__.__extmap)));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__6765__auto__){
var self__ = this;
var this__6765__auto____$1 = this;
return self__.__meta;
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PInterruptable$ = true;

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PInterruptable$break$arity$2 = (function (this$,mode){
var self__ = this;
var this$__$1 = this;
var G__36885 = (((mode instanceof cljs.core.Keyword))?mode.fqn:null);
switch (G__36885) {
case "tm":
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$distal_DASH_state,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(org.nfrac.comportex.cells.empty_distal_state,cljs.core.cst$kw$timestep,cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state)));

break;
case "fb":
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$apical_DASH_state,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(org.nfrac.comportex.cells.empty_distal_state,cljs.core.cst$kw$timestep,cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state)));

break;
case "syns":
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(this$__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$state,cljs.core.cst$kw$stable_DASH_cells_DASH_buffer], null),cljs.core.empty);

break;
case "winners":
return cljs.core.assoc_in(this$__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$learn_DASH_state,cljs.core.cst$kw$break_DASH_winners_QMARK_], null),true);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(mode)].join('')));

}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__6761__auto__){
var self__ = this;
var this__6761__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__6771__auto__){
var self__ = this;
var this__6771__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$ = true;

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$layer_activate$arity$3 = (function (this$,ff_bits,stable_ff_bits){
var self__ = this;
var this$__$1 = this;
var new_active_state = org.nfrac.comportex.cells.compute_active_state(this$__$1,ff_bits,stable_ff_bits);
var timestep = cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(new_active_state);
var effective_QMARK_ = (org.nfrac.comportex.util.set_similarity(cljs.core.cst$kw$active_DASH_cols.cljs$core$IFn$_invoke$arity$1(new_active_state),cljs.core.cst$kw$active_DASH_cols.cljs$core$IFn$_invoke$arity$1(self__.prior_state)) <= cljs.core.cst$kw$transition_DASH_similarity.cljs$core$IFn$_invoke$arity$1(self__.spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$__$1,cljs.core.cst$kw$state,new_active_state,cljs.core.array_seq([cljs.core.cst$kw$tp_DASH_state,((effective_QMARK_)?org.nfrac.comportex.cells.compute_tp_state(this$__$1,new_active_state):self__.tp_state),cljs.core.cst$kw$prior_DASH_state,((effective_QMARK_)?new_active_state:self__.prior_state)], 0));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$layer_depolarise$arity$4 = (function (this$,distal_ff_bits,apical_fb_bits,apical_fb_wc_bits){
var self__ = this;
var this$__$1 = this;
var depth = cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(self__.spec);
var widths = org.nfrac.comportex.cells.distal_sources_widths(self__.spec);
var distal_bits = org.nfrac.comportex.util.align_indices.cljs$core$IFn$_invoke$arity$2(widths,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(cljs.core.cst$kw$lateral_DASH_synapses_QMARK_.cljs$core$IFn$_invoke$arity$1(self__.spec))?cljs.core.cst$kw$out_DASH_immediate_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(self__.prior_state):cljs.core.PersistentVector.EMPTY),distal_ff_bits], null));
var distal_lbits = org.nfrac.comportex.util.align_indices.cljs$core$IFn$_invoke$arity$2(widths,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(cljs.core.cst$kw$lateral_DASH_synapses_QMARK_.cljs$core$IFn$_invoke$arity$1(self__.spec))?cljs.core.cst$kw$out_DASH_wc_DASH_bits.cljs$core$IFn$_invoke$arity$1(self__.learn_state):cljs.core.PersistentVector.EMPTY),distal_ff_bits], null));
var apical_bits = (cljs.core.truth_(cljs.core.cst$kw$use_DASH_feedback_QMARK_.cljs$core$IFn$_invoke$arity$1(self__.spec))?apical_fb_bits:cljs.core.PersistentVector.EMPTY);
var apical_lbits = (cljs.core.truth_(cljs.core.cst$kw$use_DASH_feedback_QMARK_.cljs$core$IFn$_invoke$arity$1(self__.spec))?apical_fb_wc_bits:cljs.core.PersistentVector.EMPTY);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(this$__$1,cljs.core.cst$kw$prior_DASH_distal_DASH_state,self__.distal_state,cljs.core.array_seq([cljs.core.cst$kw$prior_DASH_apical_DASH_state,self__.apical_state,cljs.core.cst$kw$distal_DASH_state,org.nfrac.comportex.cells.compute_distal_state(self__.distal_sg,distal_bits,distal_lbits,cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(self__.spec),cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state)),cljs.core.cst$kw$apical_DASH_state,org.nfrac.comportex.cells.compute_distal_state(self__.apical_sg,apical_bits,apical_lbits,cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(self__.spec),cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state))], 0));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$bursting_columns$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cst$kw$burst_DASH_cols.cljs$core$IFn$_invoke$arity$1(self__.state);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$winner_cells$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.set(cljs.core.vals(cljs.core.cst$kw$col_DASH_winners.cljs$core$IFn$_invoke$arity$1(self__.learn_state)));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$layer_learn$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.prior_state) < cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state))){
return this$__$1;
} else {
var a_cols = cljs.core.cst$kw$active_DASH_cols.cljs$core$IFn$_invoke$arity$1(self__.state);
var col_ac = cljs.core.cst$kw$col_DASH_active_DASH_cells.cljs$core$IFn$_invoke$arity$1(self__.state);
var prior_winners = (cljs.core.truth_(cljs.core.cst$kw$break_DASH_winners_QMARK_.cljs$core$IFn$_invoke$arity$1(self__.learn_state))?null:cljs.core.cst$kw$col_DASH_winners.cljs$core$IFn$_invoke$arity$1(self__.learn_state));
var vec__36886 = clojure.test.check.random.split(self__.rng);
var rng_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36886,(0),null);
var rng__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36886,(1),null);
var map__36887 = org.nfrac.comportex.cells.select_winner_cells(col_ac,prior_winners,self__.distal_state,self__.apical_state,self__.distal_sg,self__.apical_sg,self__.spec,rng_STAR_);
var map__36887__$1 = ((((!((map__36887 == null)))?((((map__36887.cljs$lang$protocol_mask$partition0$ & (64))) || (map__36887.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__36887):map__36887);
var col_winners = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36887__$1,cljs.core.cst$kw$col_DASH_winners);
var winner_seg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36887__$1,cljs.core.cst$kw$winner_DASH_seg);
var winner_cells = cljs.core.vals(col_winners);
var lc = winner_cells;
var depth = cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(self__.spec);
var out_wc_bits = cljs.core.set(org.nfrac.comportex.cells.cells__GT_bits(depth,winner_cells));
var timestep = cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state);
var G__36889 = this$__$1;
var G__36889__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(G__36889,cljs.core.cst$kw$learn_DASH_state,cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(org.nfrac.comportex.cells.empty_learn_state,cljs.core.cst$kw$col_DASH_winners,col_winners,cljs.core.array_seq([cljs.core.cst$kw$winner_DASH_seg,winner_seg,cljs.core.cst$kw$learning_DASH_cells,lc,cljs.core.cst$kw$out_DASH_wc_DASH_bits,out_wc_bits,cljs.core.cst$kw$prior_DASH_active_DASH_cells,cljs.core.cst$kw$active_DASH_cells.cljs$core$IFn$_invoke$arity$1(self__.state),cljs.core.cst$kw$timestep,timestep], 0)),cljs.core.array_seq([cljs.core.cst$kw$rng,rng__$1], 0))
;
var G__36889__$2 = (cljs.core.truth_(cljs.core.cst$kw$learn_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(self__.spec)))?org.nfrac.comportex.cells.layer_learn_lateral(G__36889__$1,lc,cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(winner_seg)):G__36889__$1);
var G__36889__$3 = (cljs.core.truth_(cljs.core.cst$kw$learn_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(self__.spec)))?org.nfrac.comportex.cells.layer_learn_apical(G__36889__$2,lc,cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(winner_seg)):G__36889__$2);
var G__36889__$4 = (cljs.core.truth_(cljs.core.cst$kw$learn_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$ilateral.cljs$core$IFn$_invoke$arity$1(self__.spec)))?org.nfrac.comportex.cells.layer_learn_ilateral(G__36889__$3,a_cols):G__36889__$3);
var G__36889__$5 = (cljs.core.truth_(cljs.core.cst$kw$learn_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(self__.spec)))?org.nfrac.comportex.cells.layer_learn_proximal(G__36889__$4,a_cols):G__36889__$4);
var G__36889__$6 = (cljs.core.truth_(cljs.core.cst$kw$punish_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(self__.spec)))?org.nfrac.comportex.cells.layer_punish_lateral(G__36889__$5,cljs.core.cst$kw$prior_DASH_active_DASH_cells.cljs$core$IFn$_invoke$arity$1(self__.learn_state)):G__36889__$5);
var G__36889__$7 = (cljs.core.truth_(cljs.core.cst$kw$punish_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(self__.spec)))?org.nfrac.comportex.cells.layer_punish_apical(G__36889__$6,cljs.core.cst$kw$prior_DASH_active_DASH_cells.cljs$core$IFn$_invoke$arity$1(self__.learn_state)):G__36889__$6);
var G__36889__$8 = (cljs.core.truth_(cljs.core.cst$kw$punish_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(self__.spec)))?org.nfrac.comportex.cells.layer_punish_proximal(G__36889__$7):G__36889__$7);
var G__36889__$9 = cljs.core.update.cljs$core$IFn$_invoke$arity$5(G__36889__$8,cljs.core.cst$kw$active_DASH_duty_DASH_cycles,org.nfrac.comportex.columns.update_duty_cycles,a_cols,cljs.core.cst$kw$duty_DASH_cycle_DASH_period.cljs$core$IFn$_invoke$arity$1(self__.spec))
;
var G__36889__$10 = cljs.core.update.cljs$core$IFn$_invoke$arity$5(G__36889__$9,cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,org.nfrac.comportex.columns.update_duty_cycles,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.keys(cljs.core.cst$kw$col_DASH_overlaps.cljs$core$IFn$_invoke$arity$1(self__.state))),cljs.core.cst$kw$duty_DASH_cycle_DASH_period.cljs$core$IFn$_invoke$arity$1(self__.spec))
;
var G__36889__$11 = (((cljs.core.mod(timestep,cljs.core.cst$kw$boost_DASH_active_DASH_every.cljs$core$IFn$_invoke$arity$1(self__.spec)) === (0)))?org.nfrac.comportex.columns.boost_active(G__36889__$10):G__36889__$10);
var G__36889__$12 = (((cljs.core.mod(timestep,cljs.core.cst$kw$adjust_DASH_overlap_DASH_every.cljs$core$IFn$_invoke$arity$1(self__.spec)) === (0)))?org.nfrac.comportex.columns.adjust_overlap(G__36889__$11):G__36889__$11);
var G__36889__$13 = (((cljs.core.mod(timestep,cljs.core.cst$kw$float_DASH_overlap_DASH_every.cljs$core$IFn$_invoke$arity$1(self__.spec)) === (0)))?org.nfrac.comportex.columns.layer_float_overlap(G__36889__$12):G__36889__$12);
if((cljs.core.mod(timestep,cljs.core.cst$kw$inh_DASH_radius_DASH_every.cljs$core$IFn$_invoke$arity$1(self__.spec)) === (0))){
return org.nfrac.comportex.cells.update_inhibition_radius(G__36889__$13);
} else {
return G__36889__$13;
}
}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$layer_depth$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(self__.spec);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$active_columns$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cst$kw$active_DASH_cols.cljs$core$IFn$_invoke$arity$1(self__.state);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$prior_predictive_cells$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var t_1 = (cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state) - (1));
if((t_1 === cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.prior_distal_state))){
return cljs.core.cst$kw$pred_DASH_cells.cljs$core$IFn$_invoke$arity$1(self__.prior_distal_state);
} else {
if((t_1 === cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.distal_state))){
return cljs.core.cst$kw$pred_DASH_cells.cljs$core$IFn$_invoke$arity$1(self__.distal_state);
} else {
return null;
}
}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$active_cells$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cst$kw$active_DASH_cells.cljs$core$IFn$_invoke$arity$1(self__.state);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PLayerOfCells$predictive_cells$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state) === cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.distal_state))){
return cljs.core.cst$kw$pred_DASH_cells.cljs$core$IFn$_invoke$arity$1(self__.distal_state);
} else {
return null;
}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__6762__auto__){
var self__ = this;
var this__6762__auto____$1 = this;
var h__6588__auto__ = self__.__hash;
if(!((h__6588__auto__ == null))){
return h__6588__auto__;
} else {
var h__6588__auto____$1 = cljs.core.hash_imap(this__6762__auto____$1);
self__.__hash = h__6588__auto____$1;

return h__6588__auto____$1;
}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__6763__auto__,other__6764__auto__){
var self__ = this;
var this__6763__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6141__auto__ = other__6764__auto__;
if(cljs.core.truth_(and__6141__auto__)){
var and__6141__auto____$1 = (this__6763__auto____$1.constructor === other__6764__auto__.constructor);
if(and__6141__auto____$1){
return cljs.core.equiv_map(this__6763__auto____$1,other__6764__auto__);
} else {
return and__6141__auto____$1;
}
} else {
return and__6141__auto__;
}
})())){
return true;
} else {
return false;
}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PParameterised$ = true;

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PParameterised$params$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.spec;
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PFeedForward$ = true;

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PFeedForward$ff_topology$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return org.nfrac.comportex.topology.make_topology(cljs.core.conj.cljs$core$IFn$_invoke$arity$2(org.nfrac.comportex.protocols.dims_of(this$__$1),org.nfrac.comportex.protocols.layer_depth(this$__$1)));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PFeedForward$bits_value$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$out_DASH_immediate_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(self__.state),cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(self__.tp_state));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PFeedForward$stable_bits_value$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cst$kw$out_DASH_stable_DASH_ff_DASH_bits.cljs$core$IFn$_invoke$arity$1(self__.tp_state);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PFeedForward$source_of_bit$arity$2 = (function (_,i){
var self__ = this;
var ___$1 = this;
return org.nfrac.comportex.cells.id__GT_cell(cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(self__.spec),i);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PTemporal$ = true;

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PTemporal$timestep$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(self__.state);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__6776__auto__,k__6777__auto__){
var self__ = this;
var this__6776__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$rng,null,cljs.core.cst$kw$boosts,null,cljs.core.cst$kw$inh_DASH_radius,null,cljs.core.cst$kw$tp_DASH_state,null,cljs.core.cst$kw$apical_DASH_state,null,cljs.core.cst$kw$distal_DASH_state,null,cljs.core.cst$kw$active_DASH_duty_DASH_cycles,null,cljs.core.cst$kw$learn_DASH_state,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$proximal_DASH_sg,null,cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,null,cljs.core.cst$kw$prior_DASH_state,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$distal_DASH_sg,null,cljs.core.cst$kw$prior_DASH_distal_DASH_state,null,cljs.core.cst$kw$input_DASH_topology,null,cljs.core.cst$kw$apical_DASH_sg,null,cljs.core.cst$kw$ilateral_DASH_sg,null,cljs.core.cst$kw$prior_DASH_apical_DASH_state,null,cljs.core.cst$kw$topology,null], null), null),k__6777__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__6776__auto____$1),self__.__meta),k__6777__auto__);
} else {
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__6777__auto__)),null));
}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PFeedBack$ = true;

org.nfrac.comportex.cells.LayerOfCells.prototype.org$nfrac$comportex$protocols$PFeedBack$wc_bits_value$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.cst$kw$out_DASH_wc_DASH_bits.cljs$core$IFn$_invoke$arity$1(self__.learn_state);
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__6774__auto__,k__6775__auto__,G__36881){
var self__ = this;
var this__6774__auto____$1 = this;
var pred__36890 = cljs.core.keyword_identical_QMARK_;
var expr__36891 = k__6775__auto__;
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spec,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$spec,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(G__36881,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$rng,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$rng,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,G__36881,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$topology,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$topology,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,G__36881,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$input_DASH_topology,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$input_DASH_topology,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,G__36881,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$inh_DASH_radius,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$inh_DASH_radius,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,G__36881,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boosts,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$boosts,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,G__36881,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$active_DASH_duty_DASH_cycles,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$active_DASH_duty_DASH_cycles,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,G__36881,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,G__36881,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$proximal_DASH_sg,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$proximal_DASH_sg,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,G__36881,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$distal_DASH_sg,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$distal_DASH_sg,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,G__36881,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$apical_DASH_sg,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$apical_DASH_sg,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,G__36881,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ilateral_DASH_sg,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$ilateral_DASH_sg,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,G__36881,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$state,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,G__36881,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$prior_DASH_state,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$prior_DASH_state,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,G__36881,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tp_DASH_state,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$tp_DASH_state,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,G__36881,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$distal_DASH_state,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$distal_DASH_state,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,G__36881,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$prior_DASH_distal_DASH_state,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$prior_DASH_distal_DASH_state,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,G__36881,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$apical_DASH_state,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$apical_DASH_state,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,G__36881,self__.prior_apical_state,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$prior_DASH_apical_DASH_state,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$prior_DASH_apical_DASH_state,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,G__36881,self__.learn_state,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__36890.cljs$core$IFn$_invoke$arity$2 ? pred__36890.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$learn_DASH_state,expr__36891) : pred__36890.call(null,cljs.core.cst$kw$learn_DASH_state,expr__36891)))){
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,G__36881,self__.__meta,self__.__extmap,null));
} else {
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__6775__auto__,G__36881),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__6779__auto__){
var self__ = this;
var this__6779__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spec,self__.spec],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rng,self__.rng],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$topology,self__.topology],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$input_DASH_topology,self__.input_topology],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$inh_DASH_radius,self__.inh_radius],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$boosts,self__.boosts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$active_DASH_duty_DASH_cycles,self__.active_duty_cycles],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,self__.overlap_duty_cycles],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$proximal_DASH_sg,self__.proximal_sg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$distal_DASH_sg,self__.distal_sg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$apical_DASH_sg,self__.apical_sg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$ilateral_DASH_sg,self__.ilateral_sg],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$prior_DASH_state,self__.prior_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tp_DASH_state,self__.tp_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$distal_DASH_state,self__.distal_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$prior_DASH_distal_DASH_state,self__.prior_distal_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$apical_DASH_state,self__.apical_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$prior_DASH_apical_DASH_state,self__.prior_apical_state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$learn_DASH_state,self__.learn_state],null))], null),self__.__extmap));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__6766__auto__,G__36881){
var self__ = this;
var this__6766__auto____$1 = this;
return (new org.nfrac.comportex.cells.LayerOfCells(self__.spec,self__.rng,self__.topology,self__.input_topology,self__.inh_radius,self__.boosts,self__.active_duty_cycles,self__.overlap_duty_cycles,self__.proximal_sg,self__.distal_sg,self__.apical_sg,self__.ilateral_sg,self__.state,self__.prior_state,self__.tp_state,self__.distal_state,self__.prior_distal_state,self__.apical_state,self__.prior_apical_state,self__.learn_state,G__36881,self__.__extmap,self__.__hash));
});

org.nfrac.comportex.cells.LayerOfCells.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__6772__auto__,entry__6773__auto__){
var self__ = this;
var this__6772__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__6773__auto__)){
return cljs.core._assoc(this__6772__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__6773__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__6772__auto____$1,entry__6773__auto__);
}
});

org.nfrac.comportex.cells.LayerOfCells.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$spec,cljs.core.cst$sym$rng,cljs.core.cst$sym$topology,cljs.core.cst$sym$input_DASH_topology,cljs.core.cst$sym$inh_DASH_radius,cljs.core.cst$sym$boosts,cljs.core.cst$sym$active_DASH_duty_DASH_cycles,cljs.core.cst$sym$overlap_DASH_duty_DASH_cycles,cljs.core.cst$sym$proximal_DASH_sg,cljs.core.cst$sym$distal_DASH_sg,cljs.core.cst$sym$apical_DASH_sg,cljs.core.cst$sym$ilateral_DASH_sg,cljs.core.cst$sym$state,cljs.core.cst$sym$prior_DASH_state,cljs.core.cst$sym$tp_DASH_state,cljs.core.cst$sym$distal_DASH_state,cljs.core.cst$sym$prior_DASH_distal_DASH_state,cljs.core.cst$sym$apical_DASH_state,cljs.core.cst$sym$prior_DASH_apical_DASH_state,cljs.core.cst$sym$learn_DASH_state], null);
});

org.nfrac.comportex.cells.LayerOfCells.cljs$lang$type = true;

org.nfrac.comportex.cells.LayerOfCells.cljs$lang$ctorPrSeq = (function (this__6801__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"org.nfrac.comportex.cells/LayerOfCells");
});

org.nfrac.comportex.cells.LayerOfCells.cljs$lang$ctorPrWriter = (function (this__6801__auto__,writer__6802__auto__){
return cljs.core._write(writer__6802__auto__,"org.nfrac.comportex.cells/LayerOfCells");
});

org.nfrac.comportex.cells.__GT_LayerOfCells = (function org$nfrac$comportex$cells$__GT_LayerOfCells(spec,rng,topology,input_topology,inh_radius,boosts,active_duty_cycles,overlap_duty_cycles,proximal_sg,distal_sg,apical_sg,ilateral_sg,state,prior_state,tp_state,distal_state,prior_distal_state,apical_state,prior_apical_state,learn_state){
return (new org.nfrac.comportex.cells.LayerOfCells(spec,rng,topology,input_topology,inh_radius,boosts,active_duty_cycles,overlap_duty_cycles,proximal_sg,distal_sg,apical_sg,ilateral_sg,state,prior_state,tp_state,distal_state,prior_distal_state,apical_state,prior_apical_state,learn_state,null,null,null));
});

org.nfrac.comportex.cells.map__GT_LayerOfCells = (function org$nfrac$comportex$cells$map__GT_LayerOfCells(G__36883){
return (new org.nfrac.comportex.cells.LayerOfCells(cljs.core.cst$kw$spec.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$rng.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$topology.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$input_DASH_topology.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$inh_DASH_radius.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$boosts.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$active_DASH_duty_DASH_cycles.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$proximal_DASH_sg.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$distal_DASH_sg.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$apical_DASH_sg.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$ilateral_DASH_sg.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$prior_DASH_state.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$tp_DASH_state.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$distal_DASH_state.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$prior_DASH_distal_DASH_state.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$apical_DASH_state.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$prior_DASH_apical_DASH_state.cljs$core$IFn$_invoke$arity$1(G__36883),cljs.core.cst$kw$learn_DASH_state.cljs$core$IFn$_invoke$arity$1(G__36883),null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__36883,cljs.core.cst$kw$spec,cljs.core.array_seq([cljs.core.cst$kw$rng,cljs.core.cst$kw$topology,cljs.core.cst$kw$input_DASH_topology,cljs.core.cst$kw$inh_DASH_radius,cljs.core.cst$kw$boosts,cljs.core.cst$kw$active_DASH_duty_DASH_cycles,cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,cljs.core.cst$kw$proximal_DASH_sg,cljs.core.cst$kw$distal_DASH_sg,cljs.core.cst$kw$apical_DASH_sg,cljs.core.cst$kw$ilateral_DASH_sg,cljs.core.cst$kw$state,cljs.core.cst$kw$prior_DASH_state,cljs.core.cst$kw$tp_DASH_state,cljs.core.cst$kw$distal_DASH_state,cljs.core.cst$kw$prior_DASH_distal_DASH_state,cljs.core.cst$kw$apical_DASH_state,cljs.core.cst$kw$prior_DASH_apical_DASH_state,cljs.core.cst$kw$learn_DASH_state], 0)),null));
});

org.nfrac.comportex.cells.validate_spec_BANG_ = (function org$nfrac$comportex$cells$validate_spec_BANG_(spec){
if(!(cljs.core.contains_QMARK_(spec,cljs.core.cst$kw$global_DASH_inhibition_QMARK_))){
return null;
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str(":global-inhibition? now implied by default :spatial-pooling; "),cljs.core.str("for local algorithm use :spatial-pooling :local-inhibition")].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(cljs.core.cst$sym$not,cljs.core.list(cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$spec,cljs.core.cst$kw$global_DASH_inhibition_QMARK_))], 0)))].join('')));
}
});
org.nfrac.comportex.cells.init_layer_state = (function org$nfrac$comportex$cells$init_layer_state(spec){
var spec__$1 = org.nfrac.comportex.util.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([org.nfrac.comportex.cells.parameter_defaults,spec], 0));
var input_topo = org.nfrac.comportex.topology.make_topology(cljs.core.cst$kw$input_DASH_dimensions.cljs$core$IFn$_invoke$arity$1(spec__$1));
var col_topo = org.nfrac.comportex.topology.make_topology(cljs.core.cst$kw$column_DASH_dimensions.cljs$core$IFn$_invoke$arity$1(spec__$1));
var n_cols = org.nfrac.comportex.protocols.size(col_topo);
var depth = cljs.core.cst$kw$depth.cljs$core$IFn$_invoke$arity$1(spec__$1);
var n_distal = ((cljs.core.truth_(cljs.core.cst$kw$lateral_DASH_synapses_QMARK_.cljs$core$IFn$_invoke$arity$1(spec__$1))?(n_cols * depth):(0)) + cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,cljs.core.cst$kw$distal_DASH_motor_DASH_dimensions.cljs$core$IFn$_invoke$arity$1(spec__$1)));
var n_apical = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,cljs.core.cst$kw$distal_DASH_topdown_DASH_dimensions.cljs$core$IFn$_invoke$arity$1(spec__$1));
var vec__36896 = clojure.test.check.random.split(clojure.test.check.random.make_random.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$random_DASH_seed.cljs$core$IFn$_invoke$arity$1(spec__$1)));
var rng = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36896,(0),null);
var rng_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36896,(1),null);
var col_prox_syns = org.nfrac.comportex.columns.uniform_ff_synapses(col_topo,input_topo,spec__$1,rng_STAR_);
var proximal_sg = org.nfrac.comportex.synapses.col_segs_synapse_graph(col_prox_syns,n_cols,cljs.core.cst$kw$max_DASH_segments.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(spec__$1)),org.nfrac.comportex.protocols.size(input_topo),cljs.core.cst$kw$perm_DASH_connected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(spec__$1)),cljs.core.cst$kw$grow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$proximal.cljs$core$IFn$_invoke$arity$1(spec__$1)));
var distal_sg = org.nfrac.comportex.synapses.cell_segs_synapse_graph(n_cols,depth,cljs.core.cst$kw$max_DASH_segments.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(spec__$1)),n_distal,cljs.core.cst$kw$perm_DASH_connected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$distal.cljs$core$IFn$_invoke$arity$1(spec__$1)),true);
var apical_sg = org.nfrac.comportex.synapses.cell_segs_synapse_graph(n_cols,depth,cljs.core.cst$kw$max_DASH_segments.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(spec__$1)),n_apical,cljs.core.cst$kw$perm_DASH_connected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$apical.cljs$core$IFn$_invoke$arity$1(spec__$1)),true);
var ilateral_sg = org.nfrac.comportex.synapses.cell_segs_synapse_graph(n_cols,(1),cljs.core.cst$kw$max_DASH_segments.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$ilateral.cljs$core$IFn$_invoke$arity$1(spec__$1)),n_cols,cljs.core.cst$kw$perm_DASH_connected.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$ilateral.cljs$core$IFn$_invoke$arity$1(spec__$1)),true);
var state = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(org.nfrac.comportex.cells.empty_active_state,cljs.core.cst$kw$timestep,(0));
var learn_state = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(org.nfrac.comportex.cells.empty_learn_state,cljs.core.cst$kw$timestep,(0));
var distal_state = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(org.nfrac.comportex.cells.empty_distal_state,cljs.core.cst$kw$timestep,(0));
org.nfrac.comportex.cells.validate_spec_BANG_(spec__$1);

return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$rng,cljs.core.cst$kw$boosts,cljs.core.cst$kw$inh_DASH_radius,cljs.core.cst$kw$distal_DASH_state,cljs.core.cst$kw$active_DASH_duty_DASH_cycles,cljs.core.cst$kw$learn_DASH_state,cljs.core.cst$kw$state,cljs.core.cst$kw$proximal_DASH_sg,cljs.core.cst$kw$overlap_DASH_duty_DASH_cycles,cljs.core.cst$kw$prior_DASH_state,cljs.core.cst$kw$spec,cljs.core.cst$kw$distal_DASH_sg,cljs.core.cst$kw$prior_DASH_distal_DASH_state,cljs.core.cst$kw$input_DASH_topology,cljs.core.cst$kw$apical_DASH_sg,cljs.core.cst$kw$ilateral_DASH_sg,cljs.core.cst$kw$topology],[rng,cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(n_cols,1.0)),(1),distal_state,cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(n_cols,cljs.core.cst$kw$activation_DASH_level.cljs$core$IFn$_invoke$arity$1(spec__$1))),learn_state,state,proximal_sg,cljs.core.vec(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(n_cols,cljs.core.cst$kw$activation_DASH_level.cljs$core$IFn$_invoke$arity$1(spec__$1))),state,spec__$1,distal_sg,distal_state,input_topo,apical_sg,ilateral_sg,col_topo]);
});
org.nfrac.comportex.cells.layer_of_cells = (function org$nfrac$comportex$cells$layer_of_cells(spec){
return org.nfrac.comportex.cells.update_inhibition_radius(org.nfrac.comportex.cells.map__GT_LayerOfCells(org.nfrac.comportex.cells.init_layer_state(spec)));
});
