// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('org.numenta.sanity.comportex.data');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('org.nfrac.comportex.core');
goog.require('org.nfrac.comportex.protocols');
goog.require('org.nfrac.comportex.util');
org.numenta.sanity.comportex.data.all_cell_segments = (function org$numenta$sanity$comportex$data$all_cell_segments(sg,cell_id){
return cljs.core.reverse(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(cljs.core.empty_QMARK_,cljs.core.reverse(org.nfrac.comportex.protocols.cell_segments(sg,cell_id))));
});
org.numenta.sanity.comportex.data.group_synapses = (function org$numenta$sanity$comportex$data$group_synapses(syns,ac,pcon){
return cljs.core.group_by((function (p__40912){
var vec__40913 = p__40912;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40913,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40913,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(((p >= pcon))?cljs.core.cst$kw$connected:cljs.core.cst$kw$disconnected),(cljs.core.truth_((ac.cljs$core$IFn$_invoke$arity$1 ? ac.cljs$core$IFn$_invoke$arity$1(id) : ac.call(null,id)))?cljs.core.cst$kw$active:cljs.core.cst$kw$inactive)], null);
}),syns);
});
org.numenta.sanity.comportex.data.active_bits = (function org$numenta$sanity$comportex$data$active_bits(sense_node){
var or__6153__auto__ = cljs.core.seq(org.nfrac.comportex.protocols.bits_value(sense_node));
if(or__6153__auto__){
return or__6153__auto__;
} else {
return org.nfrac.comportex.protocols.motor_bits_value(sense_node);
}
});
org.numenta.sanity.comportex.data.count_segs_in_column = (function org$numenta$sanity$comportex$data$count_segs_in_column(distal_sg,depth,col){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (n,ci){
return (n + org.nfrac.comportex.util.count_filter(cljs.core.seq,org.nfrac.comportex.protocols.cell_segments(distal_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null))));
}),(0),cljs.core.range.cljs$core$IFn$_invoke$arity$1(depth));
});
org.numenta.sanity.comportex.data.syns_from_source_bit = (function org$numenta$sanity$comportex$data$syns_from_source_bit(htm,sense_id,bit,syn_states){
var active_bit_QMARK_ = cljs.core.boolean$(cljs.core.some(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,bit),org.numenta.sanity.comportex.data.active_bits(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$senses,sense_id], null)))));
var iter__6925__auto__ = ((function (active_bit_QMARK_){
return (function org$numenta$sanity$comportex$data$syns_from_source_bit_$_iter__40935(s__40936){
return (new cljs.core.LazySeq(null,((function (active_bit_QMARK_){
return (function (){
var s__40936__$1 = s__40936;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__40936__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var rgn_id = cljs.core.first(xs__5205__auto__);
var rgn = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id], null));
var vec__40949 = org.nfrac.comportex.core.layers(rgn);
var lyr_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40949,(0),null);
var lyr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(rgn,lyr_id);
var sg = cljs.core.cst$kw$proximal_DASH_sg.cljs$core$IFn$_invoke$arity$1(lyr);
var adjusted_bit = (org.nfrac.comportex.core.ff_base(htm,rgn_id,sense_id) + bit);
var to_segs = org.nfrac.comportex.protocols.targets_connected_from(sg,adjusted_bit);
var predictive_columns = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,org.nfrac.comportex.protocols.prior_predictive_cells(lyr)));
var iterys__6921__auto__ = ((function (s__40936__$1,rgn,vec__40949,lyr_id,lyr,sg,adjusted_bit,to_segs,predictive_columns,rgn_id,xs__5205__auto__,temp__4657__auto__,active_bit_QMARK_){
return (function org$numenta$sanity$comportex$data$syns_from_source_bit_$_iter__40935_$_iter__40937(s__40938){
return (new cljs.core.LazySeq(null,((function (s__40936__$1,rgn,vec__40949,lyr_id,lyr,sg,adjusted_bit,to_segs,predictive_columns,rgn_id,xs__5205__auto__,temp__4657__auto__,active_bit_QMARK_){
return (function (){
var s__40938__$1 = s__40938;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__40938__$1);
if(temp__4657__auto____$1){
var s__40938__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__40938__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__40938__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__40940 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__40939 = (0);
while(true){
if((i__40939 < size__6924__auto__)){
var vec__40954 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__40939);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40954,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40954,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40954,(2),null);
var seg_path = vec__40954;
var predictive_col_QMARK_ = cljs.core.contains_QMARK_(predictive_columns,col);
if((cljs.core.contains_QMARK_(syn_states,"inactive")) || ((cljs.core.contains_QMARK_(syn_states,"predicted")) && (predictive_col_QMARK_)) || (active_bit_QMARK_)){
var perm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(org.nfrac.comportex.protocols.in_synapses(sg,seg_path),adjusted_bit);
cljs.core.chunk_append(b__40940,new cljs.core.PersistentArrayMap(null, 6, ["target-id",rgn_id,"target-lyr",lyr_id,"target-col",col,"target-dt",(0),"syn-state",((active_bit_QMARK_)?((predictive_col_QMARK_)?"active-predicted":"active"):((predictive_col_QMARK_)?"predicted":"inactive")),"perm",perm], null));

var G__40956 = (i__40939 + (1));
i__40939 = G__40956;
continue;
} else {
var G__40957 = (i__40939 + (1));
i__40939 = G__40957;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__40940),org$numenta$sanity$comportex$data$syns_from_source_bit_$_iter__40935_$_iter__40937(cljs.core.chunk_rest(s__40938__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__40940),null);
}
} else {
var vec__40955 = cljs.core.first(s__40938__$2);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40955,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40955,(1),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40955,(2),null);
var seg_path = vec__40955;
var predictive_col_QMARK_ = cljs.core.contains_QMARK_(predictive_columns,col);
if((cljs.core.contains_QMARK_(syn_states,"inactive")) || ((cljs.core.contains_QMARK_(syn_states,"predicted")) && (predictive_col_QMARK_)) || (active_bit_QMARK_)){
var perm = cljs.core.get.cljs$core$IFn$_invoke$arity$2(org.nfrac.comportex.protocols.in_synapses(sg,seg_path),adjusted_bit);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 6, ["target-id",rgn_id,"target-lyr",lyr_id,"target-col",col,"target-dt",(0),"syn-state",((active_bit_QMARK_)?((predictive_col_QMARK_)?"active-predicted":"active"):((predictive_col_QMARK_)?"predicted":"inactive")),"perm",perm], null),org$numenta$sanity$comportex$data$syns_from_source_bit_$_iter__40935_$_iter__40937(cljs.core.rest(s__40938__$2)));
} else {
var G__40958 = cljs.core.rest(s__40938__$2);
s__40938__$1 = G__40958;
continue;
}
}
} else {
return null;
}
break;
}
});})(s__40936__$1,rgn,vec__40949,lyr_id,lyr,sg,adjusted_bit,to_segs,predictive_columns,rgn_id,xs__5205__auto__,temp__4657__auto__,active_bit_QMARK_))
,null,null));
});})(s__40936__$1,rgn,vec__40949,lyr_id,lyr,sg,adjusted_bit,to_segs,predictive_columns,rgn_id,xs__5205__auto__,temp__4657__auto__,active_bit_QMARK_))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(to_segs));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$numenta$sanity$comportex$data$syns_from_source_bit_$_iter__40935(cljs.core.rest(s__40936__$1)));
} else {
var G__40959 = cljs.core.rest(s__40936__$1);
s__40936__$1 = G__40959;
continue;
}
} else {
return null;
}
break;
}
});})(active_bit_QMARK_))
,null,null));
});})(active_bit_QMARK_))
;
return iter__6925__auto__(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fb_DASH_deps,sense_id], null)));
});
/**
 * Lazily convert a seg-selector into a tree of indices.
 * 
 *   Some example seg-selectors:
 *   [] ;; none
 *   [1 7] ;; all segments for columns 1, 7
 *   {1 [2]} ;; all segments for column 1, cell 2
 *   {1 {2 [3 4]}} ;; the third and fourth segments on column 1, cell 2
 */
org.numenta.sanity.comportex.data.expand_seg_selector = (function org$numenta$sanity$comportex$data$expand_seg_selector(seg_selector,layer_depth,sg,seg_type){
var specific_cells_QMARK_ = cljs.core.map_QMARK_(seg_selector);
var cols = ((specific_cells_QMARK_)?cljs.core.keys(seg_selector):seg_selector);
var iter__6925__auto__ = ((function (specific_cells_QMARK_,cols){
return (function org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086(s__41087){
return (new cljs.core.LazySeq(null,((function (specific_cells_QMARK_,cols){
return (function (){
var s__41087__$1 = s__41087;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41087__$1);
if(temp__4657__auto__){
var s__41087__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41087__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__41087__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__41089 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__41088 = (0);
while(true){
if((i__41088 < size__6924__auto__)){
var col = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__41088);
var selector_within_col = ((specific_cells_QMARK_)?cljs.core.get.cljs$core$IFn$_invoke$arity$2(seg_selector,col):null);
var specific_segs_QMARK_ = cljs.core.map_QMARK_(selector_within_col);
var cell_indices = ((specific_cells_QMARK_)?((specific_segs_QMARK_)?cljs.core.keys(selector_within_col):selector_within_col):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(seg_type,cljs.core.cst$kw$proximal))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null):cljs.core.range.cljs$core$IFn$_invoke$arity$1(layer_depth)));
cljs.core.chunk_append(b__41089,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,(function (){var iter__6925__auto__ = ((function (i__41088,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152(s__41153){
return (new cljs.core.LazySeq(null,((function (i__41088,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function (){
var s__41153__$1 = s__41153;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__41153__$1);
if(temp__4657__auto____$1){
var s__41153__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41153__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__41153__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__41155 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__41154 = (0);
while(true){
if((i__41154 < size__6924__auto____$1)){
var ci = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__41154);
var seg_indices = ((specific_segs_QMARK_)?cljs.core.get.cljs$core$IFn$_invoke$arity$2(selector_within_col,ci):cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(org.numenta.sanity.comportex.data.all_cell_segments(sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)))));
cljs.core.chunk_append(b__41155,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,(function (){var iter__6925__auto__ = ((function (i__41154,i__41088,seg_indices,ci,c__6923__auto____$1,size__6924__auto____$1,b__41155,s__41153__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152_$_iter__41170(s__41171){
return (new cljs.core.LazySeq(null,((function (i__41154,i__41088,seg_indices,ci,c__6923__auto____$1,size__6924__auto____$1,b__41155,s__41153__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function (){
var s__41171__$1 = s__41171;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__41171__$1);
if(temp__4657__auto____$2){
var s__41171__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__41171__$2)){
var c__6923__auto____$2 = cljs.core.chunk_first(s__41171__$2);
var size__6924__auto____$2 = cljs.core.count(c__6923__auto____$2);
var b__41173 = cljs.core.chunk_buffer(size__6924__auto____$2);
if((function (){var i__41172 = (0);
while(true){
if((i__41172 < size__6924__auto____$2)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$2,i__41172);
cljs.core.chunk_append(b__41173,si);

var G__41212 = (i__41172 + (1));
i__41172 = G__41212;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41173),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152_$_iter__41170(cljs.core.chunk_rest(s__41171__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41173),null);
}
} else {
var si = cljs.core.first(s__41171__$2);
return cljs.core.cons(si,org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152_$_iter__41170(cljs.core.rest(s__41171__$2)));
}
} else {
return null;
}
break;
}
});})(i__41154,i__41088,seg_indices,ci,c__6923__auto____$1,size__6924__auto____$1,b__41155,s__41153__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
,null,null));
});})(i__41154,i__41088,seg_indices,ci,c__6923__auto____$1,size__6924__auto____$1,b__41155,s__41153__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
;
return iter__6925__auto__(seg_indices);
})()], null));

var G__41213 = (i__41154 + (1));
i__41154 = G__41213;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41155),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152(cljs.core.chunk_rest(s__41153__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41155),null);
}
} else {
var ci = cljs.core.first(s__41153__$2);
var seg_indices = ((specific_segs_QMARK_)?cljs.core.get.cljs$core$IFn$_invoke$arity$2(selector_within_col,ci):cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(org.numenta.sanity.comportex.data.all_cell_segments(sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)))));
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,(function (){var iter__6925__auto__ = ((function (i__41088,seg_indices,ci,s__41153__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152_$_iter__41176(s__41177){
return (new cljs.core.LazySeq(null,((function (i__41088,seg_indices,ci,s__41153__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function (){
var s__41177__$1 = s__41177;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__41177__$1);
if(temp__4657__auto____$2){
var s__41177__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__41177__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__41177__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__41179 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__41178 = (0);
while(true){
if((i__41178 < size__6924__auto____$1)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__41178);
cljs.core.chunk_append(b__41179,si);

var G__41214 = (i__41178 + (1));
i__41178 = G__41214;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41179),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152_$_iter__41176(cljs.core.chunk_rest(s__41177__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41179),null);
}
} else {
var si = cljs.core.first(s__41177__$2);
return cljs.core.cons(si,org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152_$_iter__41176(cljs.core.rest(s__41177__$2)));
}
} else {
return null;
}
break;
}
});})(i__41088,seg_indices,ci,s__41153__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
,null,null));
});})(i__41088,seg_indices,ci,s__41153__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
;
return iter__6925__auto__(seg_indices);
})()], null),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41152(cljs.core.rest(s__41153__$2)));
}
} else {
return null;
}
break;
}
});})(i__41088,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
,null,null));
});})(i__41088,selector_within_col,specific_segs_QMARK_,cell_indices,col,c__6923__auto__,size__6924__auto__,b__41089,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
;
return iter__6925__auto__(cell_indices);
})()], null));

var G__41215 = (i__41088 + (1));
i__41088 = G__41215;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41089),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086(cljs.core.chunk_rest(s__41087__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41089),null);
}
} else {
var col = cljs.core.first(s__41087__$2);
var selector_within_col = ((specific_cells_QMARK_)?cljs.core.get.cljs$core$IFn$_invoke$arity$2(seg_selector,col):null);
var specific_segs_QMARK_ = cljs.core.map_QMARK_(selector_within_col);
var cell_indices = ((specific_cells_QMARK_)?((specific_segs_QMARK_)?cljs.core.keys(selector_within_col):selector_within_col):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(seg_type,cljs.core.cst$kw$proximal))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null):cljs.core.range.cljs$core$IFn$_invoke$arity$1(layer_depth)));
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,(function (){var iter__6925__auto__ = ((function (selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182(s__41183){
return (new cljs.core.LazySeq(null,((function (selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function (){
var s__41183__$1 = s__41183;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__41183__$1);
if(temp__4657__auto____$1){
var s__41183__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41183__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__41183__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__41185 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__41184 = (0);
while(true){
if((i__41184 < size__6924__auto__)){
var ci = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__41184);
var seg_indices = ((specific_segs_QMARK_)?cljs.core.get.cljs$core$IFn$_invoke$arity$2(selector_within_col,ci):cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(org.numenta.sanity.comportex.data.all_cell_segments(sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)))));
cljs.core.chunk_append(b__41185,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,(function (){var iter__6925__auto__ = ((function (i__41184,seg_indices,ci,c__6923__auto__,size__6924__auto__,b__41185,s__41183__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182_$_iter__41200(s__41201){
return (new cljs.core.LazySeq(null,((function (i__41184,seg_indices,ci,c__6923__auto__,size__6924__auto__,b__41185,s__41183__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function (){
var s__41201__$1 = s__41201;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__41201__$1);
if(temp__4657__auto____$2){
var s__41201__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__41201__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__41201__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__41203 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__41202 = (0);
while(true){
if((i__41202 < size__6924__auto____$1)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__41202);
cljs.core.chunk_append(b__41203,si);

var G__41216 = (i__41202 + (1));
i__41202 = G__41216;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41203),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182_$_iter__41200(cljs.core.chunk_rest(s__41201__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41203),null);
}
} else {
var si = cljs.core.first(s__41201__$2);
return cljs.core.cons(si,org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182_$_iter__41200(cljs.core.rest(s__41201__$2)));
}
} else {
return null;
}
break;
}
});})(i__41184,seg_indices,ci,c__6923__auto__,size__6924__auto__,b__41185,s__41183__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
,null,null));
});})(i__41184,seg_indices,ci,c__6923__auto__,size__6924__auto__,b__41185,s__41183__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
;
return iter__6925__auto__(seg_indices);
})()], null));

var G__41217 = (i__41184 + (1));
i__41184 = G__41217;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41185),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182(cljs.core.chunk_rest(s__41183__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41185),null);
}
} else {
var ci = cljs.core.first(s__41183__$2);
var seg_indices = ((specific_segs_QMARK_)?cljs.core.get.cljs$core$IFn$_invoke$arity$2(selector_within_col,ci):cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(org.numenta.sanity.comportex.data.all_cell_segments(sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)))));
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,(function (){var iter__6925__auto__ = ((function (seg_indices,ci,s__41183__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182_$_iter__41206(s__41207){
return (new cljs.core.LazySeq(null,((function (seg_indices,ci,s__41183__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols){
return (function (){
var s__41207__$1 = s__41207;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__41207__$1);
if(temp__4657__auto____$2){
var s__41207__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__41207__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__41207__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__41209 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__41208 = (0);
while(true){
if((i__41208 < size__6924__auto__)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__41208);
cljs.core.chunk_append(b__41209,si);

var G__41218 = (i__41208 + (1));
i__41208 = G__41218;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41209),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182_$_iter__41206(cljs.core.chunk_rest(s__41207__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41209),null);
}
} else {
var si = cljs.core.first(s__41207__$2);
return cljs.core.cons(si,org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182_$_iter__41206(cljs.core.rest(s__41207__$2)));
}
} else {
return null;
}
break;
}
});})(seg_indices,ci,s__41183__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
,null,null));
});})(seg_indices,ci,s__41183__$2,temp__4657__auto____$1,selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
;
return iter__6925__auto__(seg_indices);
})()], null),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086_$_iter__41182(cljs.core.rest(s__41183__$2)));
}
} else {
return null;
}
break;
}
});})(selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
,null,null));
});})(selector_within_col,specific_segs_QMARK_,cell_indices,col,s__41087__$2,temp__4657__auto__,specific_cells_QMARK_,cols))
;
return iter__6925__auto__(cell_indices);
})()], null),org$numenta$sanity$comportex$data$expand_seg_selector_$_iter__41086(cljs.core.rest(s__41087__$2)));
}
} else {
return null;
}
break;
}
});})(specific_cells_QMARK_,cols))
,null,null));
});})(specific_cells_QMARK_,cols))
;
return iter__6925__auto__(cols);
});
org.numenta.sanity.comportex.data.query_segs = (function org$numenta$sanity$comportex$data$query_segs(htm,prev_htm,rgn_id,lyr_id,seg_selector,seg_type){
var lyr = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id,lyr_id], null));
var spec = org.nfrac.comportex.protocols.params(lyr);
var dspec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(spec,seg_type);
var stimulus_th = cljs.core.cst$kw$stimulus_DASH_threshold.cljs$core$IFn$_invoke$arity$1(dspec);
var learning_th = cljs.core.cst$kw$learn_DASH_threshold.cljs$core$IFn$_invoke$arity$1(dspec);
var pcon = cljs.core.cst$kw$perm_DASH_connected.cljs$core$IFn$_invoke$arity$1(dspec);
var on_bits = (function (){var G__41655 = (((seg_type instanceof cljs.core.Keyword))?seg_type.fqn:null);
switch (G__41655) {
case "apical":
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(lyr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$prior_DASH_apical_DASH_state,cljs.core.cst$kw$active_DASH_bits], null));

break;
case "distal":
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(lyr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$prior_DASH_distal_DASH_state,cljs.core.cst$kw$active_DASH_bits], null));

break;
case "proximal":
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(lyr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$state,cljs.core.cst$kw$in_DASH_ff_DASH_bits], null));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(seg_type)].join('')));

}
})();
var learning = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(lyr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$learn_DASH_state,cljs.core.cst$kw$learning,seg_type], null));
var sg_key = (function (){var G__41656 = (((seg_type instanceof cljs.core.Keyword))?seg_type.fqn:null);
switch (G__41656) {
case "apical":
return cljs.core.cst$kw$apical_DASH_sg;

break;
case "distal":
return cljs.core.cst$kw$distal_DASH_sg;

break;
case "proximal":
return cljs.core.cst$kw$proximal_DASH_sg;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(seg_type)].join('')));

}
})();
var sg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(lyr,sg_key);
var prev_sg = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(prev_htm,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id,lyr_id,sg_key], null));
var depth = org.nfrac.comportex.protocols.layer_depth(lyr);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function org$numenta$sanity$comportex$data$query_segs_$_iter__41657(s__41658){
return (new cljs.core.LazySeq(null,((function (lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (){
var s__41658__$1 = s__41658;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__41658__$1);
if(temp__4657__auto__){
var s__41658__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__41658__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__41658__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__41660 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__41659 = (0);
while(true){
if((i__41659 < size__6924__auto__)){
var vec__41877 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__41659);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41877,(0),null);
var cells = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41877,(1),null);
cljs.core.chunk_append(b__41660,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (i__41659,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878(s__41879){
return (new cljs.core.LazySeq(null,((function (i__41659,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (){
var s__41879__$1 = s__41879;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__41879__$1);
if(temp__4657__auto____$1){
var s__41879__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41879__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__41879__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__41881 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__41880 = (0);
while(true){
if((i__41880 < size__6924__auto____$1)){
var vec__41934 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__41880);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41934,(0),null);
var seg_indices = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41934,(1),null);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
var learn_seg_paths = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$target_DASH_id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(learning,cell_id));
var learn_seg_indices = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (i__41880,i__41659,cell_id,learn_seg_paths,vec__41934,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__41881,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (p__41935){
var vec__41936 = p__41935;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41936,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41936,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41936,(2),null);
return si;
});})(i__41880,i__41659,cell_id,learn_seg_paths,vec__41934,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__41881,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
),learn_seg_paths);
var p_segs = (cljs.core.truth_(prev_htm)?org.numenta.sanity.comportex.data.all_cell_segments(prev_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)):null);
cljs.core.chunk_append(b__41881,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (i__41880,i__41659,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__41934,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__41881,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878_$_iter__41937(s__41938){
return (new cljs.core.LazySeq(null,((function (i__41880,i__41659,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__41934,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__41881,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (){
var s__41938__$1 = s__41938;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__41938__$1);
if(temp__4657__auto____$2){
var s__41938__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__41938__$2)){
var c__6923__auto____$2 = cljs.core.chunk_first(s__41938__$2);
var size__6924__auto____$2 = cljs.core.count(c__6923__auto____$2);
var b__41940 = cljs.core.chunk_buffer(size__6924__auto____$2);
if((function (){var i__41939 = (0);
while(true){
if((i__41939 < size__6924__auto____$2)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$2,i__41939);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var conn_act = cljs.core.count((function (){var G__41951 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41951) : grouped_syns.call(null,G__41951));
})());
var conn_tot = (cljs.core.count((function (){var G__41952 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41952) : grouped_syns.call(null,G__41952));
})()) + conn_act);
var disc_act = cljs.core.count((function (){var G__41953 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41953) : grouped_syns.call(null,G__41953));
})());
var disc_tot = (cljs.core.count((function (){var G__41954 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41954) : grouped_syns.call(null,G__41954));
})()) + disc_act);
cljs.core.chunk_append(b__41940,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,new cljs.core.PersistentArrayMap(null, 7, ["learn-seg?",cljs.core.contains_QMARK_(learn_seg_indices,si),"n-conn-act",conn_act,"n-conn-tot",conn_tot,"n-disc-act",disc_act,"n-disc-tot",disc_tot,"stimulus-th",stimulus_th,"learning-th",learning_th], null)], null));

var G__42093 = (i__41939 + (1));
i__41939 = G__42093;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41940),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878_$_iter__41937(cljs.core.chunk_rest(s__41938__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41940),null);
}
} else {
var si = cljs.core.first(s__41938__$2);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var conn_act = cljs.core.count((function (){var G__41955 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41955) : grouped_syns.call(null,G__41955));
})());
var conn_tot = (cljs.core.count((function (){var G__41956 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41956) : grouped_syns.call(null,G__41956));
})()) + conn_act);
var disc_act = cljs.core.count((function (){var G__41957 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41957) : grouped_syns.call(null,G__41957));
})());
var disc_tot = (cljs.core.count((function (){var G__41958 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41958) : grouped_syns.call(null,G__41958));
})()) + disc_act);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,new cljs.core.PersistentArrayMap(null, 7, ["learn-seg?",cljs.core.contains_QMARK_(learn_seg_indices,si),"n-conn-act",conn_act,"n-conn-tot",conn_tot,"n-disc-act",disc_act,"n-disc-tot",disc_tot,"stimulus-th",stimulus_th,"learning-th",learning_th], null)], null),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878_$_iter__41937(cljs.core.rest(s__41938__$2)));
}
} else {
return null;
}
break;
}
});})(i__41880,i__41659,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__41934,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__41881,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
,null,null));
});})(i__41880,i__41659,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__41934,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__41881,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
;
return iter__6925__auto__(seg_indices);
})())], null));

var G__42094 = (i__41880 + (1));
i__41880 = G__42094;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41881),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878(cljs.core.chunk_rest(s__41879__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41881),null);
}
} else {
var vec__41959 = cljs.core.first(s__41879__$2);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41959,(0),null);
var seg_indices = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41959,(1),null);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
var learn_seg_paths = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$target_DASH_id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(learning,cell_id));
var learn_seg_indices = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (i__41659,cell_id,learn_seg_paths,vec__41959,ci,seg_indices,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (p__41960){
var vec__41961 = p__41960;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41961,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41961,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41961,(2),null);
return si;
});})(i__41659,cell_id,learn_seg_paths,vec__41959,ci,seg_indices,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
),learn_seg_paths);
var p_segs = (cljs.core.truth_(prev_htm)?org.numenta.sanity.comportex.data.all_cell_segments(prev_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)):null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (i__41659,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__41959,ci,seg_indices,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878_$_iter__41962(s__41963){
return (new cljs.core.LazySeq(null,((function (i__41659,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__41959,ci,seg_indices,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (){
var s__41963__$1 = s__41963;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__41963__$1);
if(temp__4657__auto____$2){
var s__41963__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__41963__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__41963__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__41965 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__41964 = (0);
while(true){
if((i__41964 < size__6924__auto____$1)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__41964);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var conn_act = cljs.core.count((function (){var G__41976 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41976) : grouped_syns.call(null,G__41976));
})());
var conn_tot = (cljs.core.count((function (){var G__41977 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41977) : grouped_syns.call(null,G__41977));
})()) + conn_act);
var disc_act = cljs.core.count((function (){var G__41978 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41978) : grouped_syns.call(null,G__41978));
})());
var disc_tot = (cljs.core.count((function (){var G__41979 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41979) : grouped_syns.call(null,G__41979));
})()) + disc_act);
cljs.core.chunk_append(b__41965,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,new cljs.core.PersistentArrayMap(null, 7, ["learn-seg?",cljs.core.contains_QMARK_(learn_seg_indices,si),"n-conn-act",conn_act,"n-conn-tot",conn_tot,"n-disc-act",disc_act,"n-disc-tot",disc_tot,"stimulus-th",stimulus_th,"learning-th",learning_th], null)], null));

var G__42095 = (i__41964 + (1));
i__41964 = G__42095;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41965),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878_$_iter__41962(cljs.core.chunk_rest(s__41963__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41965),null);
}
} else {
var si = cljs.core.first(s__41963__$2);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var conn_act = cljs.core.count((function (){var G__41980 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41980) : grouped_syns.call(null,G__41980));
})());
var conn_tot = (cljs.core.count((function (){var G__41981 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41981) : grouped_syns.call(null,G__41981));
})()) + conn_act);
var disc_act = cljs.core.count((function (){var G__41982 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41982) : grouped_syns.call(null,G__41982));
})());
var disc_tot = (cljs.core.count((function (){var G__41983 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__41983) : grouped_syns.call(null,G__41983));
})()) + disc_act);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,new cljs.core.PersistentArrayMap(null, 7, ["learn-seg?",cljs.core.contains_QMARK_(learn_seg_indices,si),"n-conn-act",conn_act,"n-conn-tot",conn_tot,"n-disc-act",disc_act,"n-disc-tot",disc_tot,"stimulus-th",stimulus_th,"learning-th",learning_th], null)], null),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878_$_iter__41962(cljs.core.rest(s__41963__$2)));
}
} else {
return null;
}
break;
}
});})(i__41659,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__41959,ci,seg_indices,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
,null,null));
});})(i__41659,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__41959,ci,seg_indices,s__41879__$2,temp__4657__auto____$1,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
;
return iter__6925__auto__(seg_indices);
})())], null),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41878(cljs.core.rest(s__41879__$2)));
}
} else {
return null;
}
break;
}
});})(i__41659,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
,null,null));
});})(i__41659,vec__41877,col,cells,c__6923__auto__,size__6924__auto__,b__41660,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
;
return iter__6925__auto__(cells);
})())], null));

var G__42096 = (i__41659 + (1));
i__41659 = G__42096;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41660),org$numenta$sanity$comportex$data$query_segs_$_iter__41657(cljs.core.chunk_rest(s__41658__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41660),null);
}
} else {
var vec__41984 = cljs.core.first(s__41658__$2);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41984,(0),null);
var cells = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41984,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985(s__41986){
return (new cljs.core.LazySeq(null,((function (vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (){
var s__41986__$1 = s__41986;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__41986__$1);
if(temp__4657__auto____$1){
var s__41986__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__41986__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__41986__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__41988 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__41987 = (0);
while(true){
if((i__41987 < size__6924__auto__)){
var vec__42041 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__41987);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42041,(0),null);
var seg_indices = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42041,(1),null);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
var learn_seg_paths = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$target_DASH_id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(learning,cell_id));
var learn_seg_indices = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (i__41987,cell_id,learn_seg_paths,vec__42041,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__41988,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (p__42042){
var vec__42043 = p__42042;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42043,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42043,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42043,(2),null);
return si;
});})(i__41987,cell_id,learn_seg_paths,vec__42041,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__41988,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
),learn_seg_paths);
var p_segs = (cljs.core.truth_(prev_htm)?org.numenta.sanity.comportex.data.all_cell_segments(prev_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)):null);
cljs.core.chunk_append(b__41988,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (i__41987,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__42041,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__41988,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985_$_iter__42044(s__42045){
return (new cljs.core.LazySeq(null,((function (i__41987,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__42041,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__41988,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (){
var s__42045__$1 = s__42045;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__42045__$1);
if(temp__4657__auto____$2){
var s__42045__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__42045__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__42045__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__42047 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__42046 = (0);
while(true){
if((i__42046 < size__6924__auto____$1)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__42046);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var conn_act = cljs.core.count((function (){var G__42058 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42058) : grouped_syns.call(null,G__42058));
})());
var conn_tot = (cljs.core.count((function (){var G__42059 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42059) : grouped_syns.call(null,G__42059));
})()) + conn_act);
var disc_act = cljs.core.count((function (){var G__42060 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42060) : grouped_syns.call(null,G__42060));
})());
var disc_tot = (cljs.core.count((function (){var G__42061 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42061) : grouped_syns.call(null,G__42061));
})()) + disc_act);
cljs.core.chunk_append(b__42047,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,new cljs.core.PersistentArrayMap(null, 7, ["learn-seg?",cljs.core.contains_QMARK_(learn_seg_indices,si),"n-conn-act",conn_act,"n-conn-tot",conn_tot,"n-disc-act",disc_act,"n-disc-tot",disc_tot,"stimulus-th",stimulus_th,"learning-th",learning_th], null)], null));

var G__42097 = (i__42046 + (1));
i__42046 = G__42097;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42047),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985_$_iter__42044(cljs.core.chunk_rest(s__42045__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42047),null);
}
} else {
var si = cljs.core.first(s__42045__$2);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var conn_act = cljs.core.count((function (){var G__42062 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42062) : grouped_syns.call(null,G__42062));
})());
var conn_tot = (cljs.core.count((function (){var G__42063 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42063) : grouped_syns.call(null,G__42063));
})()) + conn_act);
var disc_act = cljs.core.count((function (){var G__42064 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42064) : grouped_syns.call(null,G__42064));
})());
var disc_tot = (cljs.core.count((function (){var G__42065 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42065) : grouped_syns.call(null,G__42065));
})()) + disc_act);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,new cljs.core.PersistentArrayMap(null, 7, ["learn-seg?",cljs.core.contains_QMARK_(learn_seg_indices,si),"n-conn-act",conn_act,"n-conn-tot",conn_tot,"n-disc-act",disc_act,"n-disc-tot",disc_tot,"stimulus-th",stimulus_th,"learning-th",learning_th], null)], null),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985_$_iter__42044(cljs.core.rest(s__42045__$2)));
}
} else {
return null;
}
break;
}
});})(i__41987,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__42041,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__41988,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
,null,null));
});})(i__41987,cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__42041,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__41988,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
;
return iter__6925__auto__(seg_indices);
})())], null));

var G__42098 = (i__41987 + (1));
i__41987 = G__42098;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__41988),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985(cljs.core.chunk_rest(s__41986__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__41988),null);
}
} else {
var vec__42066 = cljs.core.first(s__41986__$2);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42066,(0),null);
var seg_indices = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42066,(1),null);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
var learn_seg_paths = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$target_DASH_id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(learning,cell_id));
var learn_seg_indices = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (cell_id,learn_seg_paths,vec__42066,ci,seg_indices,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (p__42067){
var vec__42068 = p__42067;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42068,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42068,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42068,(2),null);
return si;
});})(cell_id,learn_seg_paths,vec__42066,ci,seg_indices,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
),learn_seg_paths);
var p_segs = (cljs.core.truth_(prev_htm)?org.numenta.sanity.comportex.data.all_cell_segments(prev_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)):null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__42066,ci,seg_indices,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985_$_iter__42069(s__42070){
return (new cljs.core.LazySeq(null,((function (cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__42066,ci,seg_indices,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth){
return (function (){
var s__42070__$1 = s__42070;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__42070__$1);
if(temp__4657__auto____$2){
var s__42070__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__42070__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__42070__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__42072 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__42071 = (0);
while(true){
if((i__42071 < size__6924__auto__)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__42071);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var conn_act = cljs.core.count((function (){var G__42083 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42083) : grouped_syns.call(null,G__42083));
})());
var conn_tot = (cljs.core.count((function (){var G__42084 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42084) : grouped_syns.call(null,G__42084));
})()) + conn_act);
var disc_act = cljs.core.count((function (){var G__42085 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42085) : grouped_syns.call(null,G__42085));
})());
var disc_tot = (cljs.core.count((function (){var G__42086 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42086) : grouped_syns.call(null,G__42086));
})()) + disc_act);
cljs.core.chunk_append(b__42072,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,new cljs.core.PersistentArrayMap(null, 7, ["learn-seg?",cljs.core.contains_QMARK_(learn_seg_indices,si),"n-conn-act",conn_act,"n-conn-tot",conn_tot,"n-disc-act",disc_act,"n-disc-tot",disc_tot,"stimulus-th",stimulus_th,"learning-th",learning_th], null)], null));

var G__42099 = (i__42071 + (1));
i__42071 = G__42099;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__42072),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985_$_iter__42069(cljs.core.chunk_rest(s__42070__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__42072),null);
}
} else {
var si = cljs.core.first(s__42070__$2);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var conn_act = cljs.core.count((function (){var G__42087 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42087) : grouped_syns.call(null,G__42087));
})());
var conn_tot = (cljs.core.count((function (){var G__42088 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42088) : grouped_syns.call(null,G__42088));
})()) + conn_act);
var disc_act = cljs.core.count((function (){var G__42089 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42089) : grouped_syns.call(null,G__42089));
})());
var disc_tot = (cljs.core.count((function (){var G__42090 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_syns.cljs$core$IFn$_invoke$arity$1(G__42090) : grouped_syns.call(null,G__42090));
})()) + disc_act);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,new cljs.core.PersistentArrayMap(null, 7, ["learn-seg?",cljs.core.contains_QMARK_(learn_seg_indices,si),"n-conn-act",conn_act,"n-conn-tot",conn_tot,"n-disc-act",disc_act,"n-disc-tot",disc_tot,"stimulus-th",stimulus_th,"learning-th",learning_th], null)], null),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985_$_iter__42069(cljs.core.rest(s__42070__$2)));
}
} else {
return null;
}
break;
}
});})(cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__42066,ci,seg_indices,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
,null,null));
});})(cell_id,learn_seg_paths,learn_seg_indices,p_segs,vec__42066,ci,seg_indices,s__41986__$2,temp__4657__auto____$1,vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
;
return iter__6925__auto__(seg_indices);
})())], null),org$numenta$sanity$comportex$data$query_segs_$_iter__41657_$_iter__41985(cljs.core.rest(s__41986__$2)));
}
} else {
return null;
}
break;
}
});})(vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
,null,null));
});})(vec__41984,col,cells,s__41658__$2,temp__4657__auto__,lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
;
return iter__6925__auto__(cells);
})())], null),org$numenta$sanity$comportex$data$query_segs_$_iter__41657(cljs.core.rest(s__41658__$2)));
}
} else {
return null;
}
break;
}
});})(lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
,null,null));
});})(lyr,spec,dspec,stimulus_th,learning_th,pcon,on_bits,learning,sg_key,sg,prev_sg,depth))
;
return iter__6925__auto__(org.numenta.sanity.comportex.data.expand_seg_selector(seg_selector,depth,sg,seg_type));
})());
});
org.numenta.sanity.comportex.data.query_syns = (function org$numenta$sanity$comportex$data$query_syns(htm,prev_htm,rgn_id,lyr_id,seg_selector,syn_states,seg_type){
var regions = cljs.core.cst$kw$regions.cljs$core$IFn$_invoke$arity$1(htm);
var lyr = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(regions,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id,lyr_id], null));
var spec = org.nfrac.comportex.protocols.params(lyr);
var dspec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(spec,seg_type);
var pcon = cljs.core.cst$kw$perm_DASH_connected.cljs$core$IFn$_invoke$arity$1(dspec);
var pinit = cljs.core.cst$kw$perm_DASH_init.cljs$core$IFn$_invoke$arity$1(dspec);
var on_bits = (function (){var G__43617 = (((seg_type instanceof cljs.core.Keyword))?seg_type.fqn:null);
switch (G__43617) {
case "apical":
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(lyr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$prior_DASH_apical_DASH_state,cljs.core.cst$kw$active_DASH_bits], null));

break;
case "distal":
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(lyr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$prior_DASH_distal_DASH_state,cljs.core.cst$kw$active_DASH_bits], null));

break;
case "proximal":
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(lyr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$state,cljs.core.cst$kw$in_DASH_ff_DASH_bits], null));

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(seg_type)].join('')));

}
})();
var depth = org.nfrac.comportex.protocols.layer_depth(lyr);
var learning = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(lyr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$learn_DASH_state,cljs.core.cst$kw$learning,seg_type], null));
var sg_key = (function (){var G__43618 = (((seg_type instanceof cljs.core.Keyword))?seg_type.fqn:null);
switch (G__43618) {
case "apical":
return cljs.core.cst$kw$apical_DASH_sg;

break;
case "distal":
return cljs.core.cst$kw$distal_DASH_sg;

break;
case "proximal":
return cljs.core.cst$kw$proximal_DASH_sg;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(seg_type)].join('')));

}
})();
var sg = cljs.core.get.cljs$core$IFn$_invoke$arity$2(lyr,sg_key);
var prev_sg = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(prev_htm,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id,lyr_id,sg_key], null));
var input_layer_QMARK_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg){
return (function (p__43619){
var vec__43620 = p__43619;
var rgn_id__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43620,(0),null);
var rgn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43620,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id__$1,cljs.core.first(org.nfrac.comportex.core.layers(rgn))], null);
});})(regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg))
,regions));
var output_layer = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_){
return (function (p__43621){
var vec__43622 = p__43621;
var rgn_id__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43622,(0),null);
var rgn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43622,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id__$1,cljs.core.last(org.nfrac.comportex.core.layers(rgn))], null);
});})(regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_))
,regions));
var dt = (function (){var G__43623 = (((seg_type instanceof cljs.core.Keyword))?seg_type.fqn:null);
switch (G__43623) {
case "apical":
return (-1);

break;
case "distal":
return (-1);

break;
case "proximal":
return (0);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(seg_type)].join('')));

}
})();
var source_of_bit = (function (){var G__43624 = (((seg_type instanceof cljs.core.Keyword))?seg_type.fqn:null);
switch (G__43624) {
case "apical":
return org.nfrac.comportex.core.source_of_apical_bit;

break;
case "distal":
return org.nfrac.comportex.core.source_of_distal_bit;

break;
case "proximal":
return ((function (G__43624,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt){
return (function (htm__$1,rgn_id__$1,lyr_id__$1,i){
if(cljs.core.truth_((function (){var G__43625 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id__$1,lyr_id__$1], null);
return (input_layer_QMARK_.cljs$core$IFn$_invoke$arity$1 ? input_layer_QMARK_.cljs$core$IFn$_invoke$arity$1(G__43625) : input_layer_QMARK_.call(null,G__43625));
})())){
var vec__43626 = org.nfrac.comportex.core.source_of_incoming_bit.cljs$core$IFn$_invoke$arity$4(htm__$1,rgn_id__$1,i,cljs.core.cst$kw$ff_DASH_deps);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43626,(0),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43626,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [src_id,(output_layer.cljs$core$IFn$_invoke$arity$1 ? output_layer.cljs$core$IFn$_invoke$arity$1(src_id) : output_layer.call(null,src_id)),src_i], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id__$1,cljs.core.cst$kw$layer_DASH_4,i], null);
}
});
;})(G__43624,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt))

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(seg_type)].join('')));

}
})();
var source_id_and_dt_of_bit = ((function (regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit){
return (function (htm__$1,rgn_id__$1,lyr_id__$1,i){
var vec__43627 = (source_of_bit.cljs$core$IFn$_invoke$arity$4 ? source_of_bit.cljs$core$IFn$_invoke$arity$4(htm__$1,rgn_id__$1,lyr_id__$1,i) : source_of_bit.call(null,htm__$1,rgn_id__$1,lyr_id__$1,i));
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43627,(0),null);
var src_lyr_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43627,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43627,(2),null);
if((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$proximal,seg_type)) && (cljs.core.contains_QMARK_(cljs.core.cst$kw$regions.cljs$core$IFn$_invoke$arity$1(htm__$1),src_id))){
var src_state = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm__$1,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,src_id,src_lyr_id,cljs.core.cst$kw$state], null));
var src_depth = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm__$1,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,src_id,src_lyr_id,cljs.core.cst$kw$spec,cljs.core.cst$kw$depth], null));
var prev_ss = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(prev_htm,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,src_id,src_lyr_id,cljs.core.cst$kw$state], null));
var src_cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.quot(src_i,src_depth),cljs.core.rem(src_i,src_depth)], null);
var src_dt = (function (){var dt__$1 = (0);
var csets = cljs.core.cons(cljs.core.cst$kw$active_DASH_cells.cljs$core$IFn$_invoke$arity$1(src_state),cljs.core.reverse(cljs.core.cst$kw$stable_DASH_cells_DASH_buffer.cljs$core$IFn$_invoke$arity$1(prev_ss)));
while(true){
var temp__4655__auto__ = cljs.core.first(csets);
if(cljs.core.truth_(temp__4655__auto__)){
var cset = temp__4655__auto__;
if(cljs.core.contains_QMARK_(cset,src_cell_id)){
return dt__$1;
} else {
var G__45138 = (dt__$1 - (1));
var G__45139 = cljs.core.next(csets);
dt__$1 = G__45138;
csets = G__45139;
continue;
}
} else {
return (0);
}
break;
}
})();
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [src_id,src_lyr_id,src_i,src_dt], null);
} else {
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [src_id,src_lyr_id,src_i,dt], null);
}
});})(regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit))
;
var iter__6925__auto__ = ((function (regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628(s__43629){
return (new cljs.core.LazySeq(null,((function (regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__43629__$1 = s__43629;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__43629__$1);
if(temp__4657__auto__){
var s__43629__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__43629__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__43629__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__43631 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__43630 = (0);
while(true){
if((i__43630 < size__6924__auto__)){
var vec__44384 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__43630);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44384,(0),null);
var cells = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44384,(1),null);
cljs.core.chunk_append(b__43631,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (i__43630,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385(s__44386){
return (new cljs.core.LazySeq(null,((function (i__43630,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44386__$1 = s__44386;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__44386__$1);
if(temp__4657__auto____$1){
var s__44386__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__44386__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__44386__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__44388 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__44387 = (0);
while(true){
if((i__44387 < size__6924__auto____$1)){
var vec__44575 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__44387);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44575,(0),null);
var seg_indices = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44575,(1),null);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
var si__GT_seg_update = (function (){var upd = cljs.core.get.cljs$core$IFn$_invoke$arity$2(learning,cell_id);
var vec__44576 = cljs.core.cst$kw$target_DASH_id.cljs$core$IFn$_invoke$arity$1(upd);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44576,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44576,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44576,(2),null);
return cljs.core.PersistentArrayMap.fromArray([si,upd], true, false);
})();
var p_segs = (cljs.core.truth_(prev_htm)?org.numenta.sanity.comportex.data.all_cell_segments(prev_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)):null);
cljs.core.chunk_append(b__44388,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (i__44387,i__43630,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577(s__44578){
return (new cljs.core.LazySeq(null,((function (i__44387,i__43630,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44578__$1 = s__44578;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__44578__$1);
if(temp__4657__auto____$2){
var s__44578__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__44578__$2)){
var c__6923__auto____$2 = cljs.core.chunk_first(s__44578__$2);
var size__6924__auto____$2 = cljs.core.count(c__6923__auto____$2);
var b__44580 = cljs.core.chunk_buffer(size__6924__auto____$2);
if((function (){var i__44579 = (0);
while(true){
if((i__44579 < size__6924__auto____$2)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$2,i__44579);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grow_sources = cljs.core.cst$kw$grow_DASH_sources.cljs$core$IFn$_invoke$arity$1((si__GT_seg_update.cljs$core$IFn$_invoke$arity$1 ? si__GT_seg_update.cljs$core$IFn$_invoke$arity$1(si) : si__GT_seg_update.call(null,si)));
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var grouped_sourced_syns = org.nfrac.comportex.util.remap(((function (i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (syns){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (p__44625){
var vec__44626 = p__44625;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44626,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44626,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,source_id_and_dt_of_bit(htm,rgn_id,lyr_id,i),p], null);
});})(i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syns);
});})(i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(grouped_syns,cljs.core.cst$kw$growing,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,grow_sources,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(pinit))));
var syn_sources = (function (){var G__44627 = cljs.core.PersistentArrayMap.EMPTY;
var G__44627__$1 = ((cljs.core.contains_QMARK_(syn_states,"active"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44627,"active",(function (){var G__44628 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44628) : grouped_sourced_syns.call(null,G__44628));
})()):G__44627);
var G__44627__$2 = ((cljs.core.contains_QMARK_(syn_states,"inactive"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44627__$1,"inactive",cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var G__44629 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44629) : grouped_sourced_syns.call(null,G__44629));
})(),(cljs.core.truth_(cljs.core.cst$kw$disconnected.cljs$core$IFn$_invoke$arity$1(syn_states))?(function (){var G__44630 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44630) : grouped_sourced_syns.call(null,G__44630));
})():null))):G__44627__$1);
var G__44627__$3 = ((cljs.core.contains_QMARK_(syn_states,"disconnected"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44627__$2,"disconnected",(function (){var G__44631 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44631) : grouped_sourced_syns.call(null,G__44631));
})()):G__44627__$2);
if(cljs.core.contains_QMARK_(syn_states,"growing")){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44627__$3,"growing",(grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$growing) : grouped_sourced_syns.call(null,cljs.core.cst$kw$growing)));
} else {
return G__44627__$3;
}
})();
cljs.core.chunk_append(b__44580,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,org.nfrac.comportex.util.remap(((function (i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (source_info){
var iter__6925__auto__ = ((function (i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577_$_iter__44632(s__44633){
return (new cljs.core.LazySeq(null,((function (i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44633__$1 = s__44633;
while(true){
var temp__4657__auto____$3 = cljs.core.seq(s__44633__$1);
if(temp__4657__auto____$3){
var s__44633__$2 = temp__4657__auto____$3;
if(cljs.core.chunked_seq_QMARK_(s__44633__$2)){
var c__6923__auto____$3 = cljs.core.chunk_first(s__44633__$2);
var size__6924__auto____$3 = cljs.core.count(c__6923__auto____$3);
var b__44635 = cljs.core.chunk_buffer(size__6924__auto____$3);
if((function (){var i__44634 = (0);
while(true){
if((i__44634 < size__6924__auto____$3)){
var vec__44642 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$3,i__44634);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44642,(0),null);
var vec__44643 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44642,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44643,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44643,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44643,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44643,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44642,(2),null);
cljs.core.chunk_append(b__44635,new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null));

var G__45140 = (i__44634 + (1));
i__44634 = G__45140;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44635),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577_$_iter__44632(cljs.core.chunk_rest(s__44633__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44635),null);
}
} else {
var vec__44644 = cljs.core.first(s__44633__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44644,(0),null);
var vec__44645 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44644,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44645,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44645,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44645,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44645,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44644,(2),null);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577_$_iter__44632(cljs.core.rest(s__44633__$2)));
}
} else {
return null;
}
break;
}
});})(i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(source_info);
});})(i__44579,i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$2,size__6924__auto____$2,b__44580,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syn_sources)], null));

var G__45141 = (i__44579 + (1));
i__44579 = G__45141;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44580),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577(cljs.core.chunk_rest(s__44578__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44580),null);
}
} else {
var si = cljs.core.first(s__44578__$2);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grow_sources = cljs.core.cst$kw$grow_DASH_sources.cljs$core$IFn$_invoke$arity$1((si__GT_seg_update.cljs$core$IFn$_invoke$arity$1 ? si__GT_seg_update.cljs$core$IFn$_invoke$arity$1(si) : si__GT_seg_update.call(null,si)));
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var grouped_sourced_syns = org.nfrac.comportex.util.remap(((function (i__44387,i__43630,seg,grow_sources,grouped_syns,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (syns){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__44387,i__43630,seg,grow_sources,grouped_syns,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (p__44646){
var vec__44647 = p__44646;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44647,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44647,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,source_id_and_dt_of_bit(htm,rgn_id,lyr_id,i),p], null);
});})(i__44387,i__43630,seg,grow_sources,grouped_syns,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syns);
});})(i__44387,i__43630,seg,grow_sources,grouped_syns,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(grouped_syns,cljs.core.cst$kw$growing,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,grow_sources,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(pinit))));
var syn_sources = (function (){var G__44648 = cljs.core.PersistentArrayMap.EMPTY;
var G__44648__$1 = ((cljs.core.contains_QMARK_(syn_states,"active"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44648,"active",(function (){var G__44649 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44649) : grouped_sourced_syns.call(null,G__44649));
})()):G__44648);
var G__44648__$2 = ((cljs.core.contains_QMARK_(syn_states,"inactive"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44648__$1,"inactive",cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var G__44650 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44650) : grouped_sourced_syns.call(null,G__44650));
})(),(cljs.core.truth_(cljs.core.cst$kw$disconnected.cljs$core$IFn$_invoke$arity$1(syn_states))?(function (){var G__44651 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44651) : grouped_sourced_syns.call(null,G__44651));
})():null))):G__44648__$1);
var G__44648__$3 = ((cljs.core.contains_QMARK_(syn_states,"disconnected"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44648__$2,"disconnected",(function (){var G__44652 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44652) : grouped_sourced_syns.call(null,G__44652));
})()):G__44648__$2);
if(cljs.core.contains_QMARK_(syn_states,"growing")){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44648__$3,"growing",(grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$growing) : grouped_sourced_syns.call(null,cljs.core.cst$kw$growing)));
} else {
return G__44648__$3;
}
})();
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,org.nfrac.comportex.util.remap(((function (i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (source_info){
var iter__6925__auto__ = ((function (i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577_$_iter__44653(s__44654){
return (new cljs.core.LazySeq(null,((function (i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44654__$1 = s__44654;
while(true){
var temp__4657__auto____$3 = cljs.core.seq(s__44654__$1);
if(temp__4657__auto____$3){
var s__44654__$2 = temp__4657__auto____$3;
if(cljs.core.chunked_seq_QMARK_(s__44654__$2)){
var c__6923__auto____$2 = cljs.core.chunk_first(s__44654__$2);
var size__6924__auto____$2 = cljs.core.count(c__6923__auto____$2);
var b__44656 = cljs.core.chunk_buffer(size__6924__auto____$2);
if((function (){var i__44655 = (0);
while(true){
if((i__44655 < size__6924__auto____$2)){
var vec__44663 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$2,i__44655);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44663,(0),null);
var vec__44664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44663,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44664,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44663,(2),null);
cljs.core.chunk_append(b__44656,new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null));

var G__45142 = (i__44655 + (1));
i__44655 = G__45142;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44656),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577_$_iter__44653(cljs.core.chunk_rest(s__44654__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44656),null);
}
} else {
var vec__44665 = cljs.core.first(s__44654__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44665,(0),null);
var vec__44666 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44665,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44666,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44665,(2),null);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577_$_iter__44653(cljs.core.rest(s__44654__$2)));
}
} else {
return null;
}
break;
}
});})(i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(source_info);
});})(i__44387,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44578__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syn_sources)], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44577(cljs.core.rest(s__44578__$2)));
}
} else {
return null;
}
break;
}
});})(i__44387,i__43630,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__44387,i__43630,cell_id,si__GT_seg_update,p_segs,vec__44575,ci,seg_indices,c__6923__auto____$1,size__6924__auto____$1,b__44388,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(seg_indices);
})())], null));

var G__45143 = (i__44387 + (1));
i__44387 = G__45143;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44388),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385(cljs.core.chunk_rest(s__44386__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44388),null);
}
} else {
var vec__44667 = cljs.core.first(s__44386__$2);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44667,(0),null);
var seg_indices = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44667,(1),null);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
var si__GT_seg_update = (function (){var upd = cljs.core.get.cljs$core$IFn$_invoke$arity$2(learning,cell_id);
var vec__44668 = cljs.core.cst$kw$target_DASH_id.cljs$core$IFn$_invoke$arity$1(upd);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44668,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44668,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44668,(2),null);
return cljs.core.PersistentArrayMap.fromArray([si,upd], true, false);
})();
var p_segs = (cljs.core.truth_(prev_htm)?org.numenta.sanity.comportex.data.all_cell_segments(prev_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)):null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (i__43630,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669(s__44670){
return (new cljs.core.LazySeq(null,((function (i__43630,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44670__$1 = s__44670;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__44670__$1);
if(temp__4657__auto____$2){
var s__44670__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__44670__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__44670__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__44672 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__44671 = (0);
while(true){
if((i__44671 < size__6924__auto____$1)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__44671);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grow_sources = cljs.core.cst$kw$grow_DASH_sources.cljs$core$IFn$_invoke$arity$1((si__GT_seg_update.cljs$core$IFn$_invoke$arity$1 ? si__GT_seg_update.cljs$core$IFn$_invoke$arity$1(si) : si__GT_seg_update.call(null,si)));
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var grouped_sourced_syns = org.nfrac.comportex.util.remap(((function (i__44671,i__43630,seg,grow_sources,grouped_syns,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (syns){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__44671,i__43630,seg,grow_sources,grouped_syns,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (p__44717){
var vec__44718 = p__44717;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44718,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44718,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,source_id_and_dt_of_bit(htm,rgn_id,lyr_id,i),p], null);
});})(i__44671,i__43630,seg,grow_sources,grouped_syns,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syns);
});})(i__44671,i__43630,seg,grow_sources,grouped_syns,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(grouped_syns,cljs.core.cst$kw$growing,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,grow_sources,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(pinit))));
var syn_sources = (function (){var G__44719 = cljs.core.PersistentArrayMap.EMPTY;
var G__44719__$1 = ((cljs.core.contains_QMARK_(syn_states,"active"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44719,"active",(function (){var G__44720 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44720) : grouped_sourced_syns.call(null,G__44720));
})()):G__44719);
var G__44719__$2 = ((cljs.core.contains_QMARK_(syn_states,"inactive"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44719__$1,"inactive",cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var G__44721 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44721) : grouped_sourced_syns.call(null,G__44721));
})(),(cljs.core.truth_(cljs.core.cst$kw$disconnected.cljs$core$IFn$_invoke$arity$1(syn_states))?(function (){var G__44722 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44722) : grouped_sourced_syns.call(null,G__44722));
})():null))):G__44719__$1);
var G__44719__$3 = ((cljs.core.contains_QMARK_(syn_states,"disconnected"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44719__$2,"disconnected",(function (){var G__44723 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44723) : grouped_sourced_syns.call(null,G__44723));
})()):G__44719__$2);
if(cljs.core.contains_QMARK_(syn_states,"growing")){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44719__$3,"growing",(grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$growing) : grouped_sourced_syns.call(null,cljs.core.cst$kw$growing)));
} else {
return G__44719__$3;
}
})();
cljs.core.chunk_append(b__44672,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,org.nfrac.comportex.util.remap(((function (i__44671,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (source_info){
var iter__6925__auto__ = ((function (i__44671,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669_$_iter__44724(s__44725){
return (new cljs.core.LazySeq(null,((function (i__44671,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44725__$1 = s__44725;
while(true){
var temp__4657__auto____$3 = cljs.core.seq(s__44725__$1);
if(temp__4657__auto____$3){
var s__44725__$2 = temp__4657__auto____$3;
if(cljs.core.chunked_seq_QMARK_(s__44725__$2)){
var c__6923__auto____$2 = cljs.core.chunk_first(s__44725__$2);
var size__6924__auto____$2 = cljs.core.count(c__6923__auto____$2);
var b__44727 = cljs.core.chunk_buffer(size__6924__auto____$2);
if((function (){var i__44726 = (0);
while(true){
if((i__44726 < size__6924__auto____$2)){
var vec__44734 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$2,i__44726);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(0),null);
var vec__44735 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44735,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44735,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44735,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44735,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44734,(2),null);
cljs.core.chunk_append(b__44727,new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null));

var G__45144 = (i__44726 + (1));
i__44726 = G__45144;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44727),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669_$_iter__44724(cljs.core.chunk_rest(s__44725__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44727),null);
}
} else {
var vec__44736 = cljs.core.first(s__44725__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44736,(0),null);
var vec__44737 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44736,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44737,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44737,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44737,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44737,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44736,(2),null);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669_$_iter__44724(cljs.core.rest(s__44725__$2)));
}
} else {
return null;
}
break;
}
});})(i__44671,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__44671,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(source_info);
});})(i__44671,i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44672,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syn_sources)], null));

var G__45145 = (i__44671 + (1));
i__44671 = G__45145;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44672),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669(cljs.core.chunk_rest(s__44670__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44672),null);
}
} else {
var si = cljs.core.first(s__44670__$2);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grow_sources = cljs.core.cst$kw$grow_DASH_sources.cljs$core$IFn$_invoke$arity$1((si__GT_seg_update.cljs$core$IFn$_invoke$arity$1 ? si__GT_seg_update.cljs$core$IFn$_invoke$arity$1(si) : si__GT_seg_update.call(null,si)));
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var grouped_sourced_syns = org.nfrac.comportex.util.remap(((function (i__43630,seg,grow_sources,grouped_syns,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (syns){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__43630,seg,grow_sources,grouped_syns,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (p__44738){
var vec__44739 = p__44738;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44739,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,source_id_and_dt_of_bit(htm,rgn_id,lyr_id,i),p], null);
});})(i__43630,seg,grow_sources,grouped_syns,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syns);
});})(i__43630,seg,grow_sources,grouped_syns,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(grouped_syns,cljs.core.cst$kw$growing,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,grow_sources,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(pinit))));
var syn_sources = (function (){var G__44740 = cljs.core.PersistentArrayMap.EMPTY;
var G__44740__$1 = ((cljs.core.contains_QMARK_(syn_states,"active"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44740,"active",(function (){var G__44741 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44741) : grouped_sourced_syns.call(null,G__44741));
})()):G__44740);
var G__44740__$2 = ((cljs.core.contains_QMARK_(syn_states,"inactive"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44740__$1,"inactive",cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var G__44742 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44742) : grouped_sourced_syns.call(null,G__44742));
})(),(cljs.core.truth_(cljs.core.cst$kw$disconnected.cljs$core$IFn$_invoke$arity$1(syn_states))?(function (){var G__44743 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44743) : grouped_sourced_syns.call(null,G__44743));
})():null))):G__44740__$1);
var G__44740__$3 = ((cljs.core.contains_QMARK_(syn_states,"disconnected"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44740__$2,"disconnected",(function (){var G__44744 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__44744) : grouped_sourced_syns.call(null,G__44744));
})()):G__44740__$2);
if(cljs.core.contains_QMARK_(syn_states,"growing")){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__44740__$3,"growing",(grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$growing) : grouped_sourced_syns.call(null,cljs.core.cst$kw$growing)));
} else {
return G__44740__$3;
}
})();
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,org.nfrac.comportex.util.remap(((function (i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (source_info){
var iter__6925__auto__ = ((function (i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669_$_iter__44745(s__44746){
return (new cljs.core.LazySeq(null,((function (i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44746__$1 = s__44746;
while(true){
var temp__4657__auto____$3 = cljs.core.seq(s__44746__$1);
if(temp__4657__auto____$3){
var s__44746__$2 = temp__4657__auto____$3;
if(cljs.core.chunked_seq_QMARK_(s__44746__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__44746__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__44748 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__44747 = (0);
while(true){
if((i__44747 < size__6924__auto____$1)){
var vec__44755 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__44747);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44755,(0),null);
var vec__44756 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44755,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44756,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44756,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44756,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44756,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44755,(2),null);
cljs.core.chunk_append(b__44748,new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null));

var G__45146 = (i__44747 + (1));
i__44747 = G__45146;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44748),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669_$_iter__44745(cljs.core.chunk_rest(s__44746__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44748),null);
}
} else {
var vec__44757 = cljs.core.first(s__44746__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44757,(0),null);
var vec__44758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44757,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44758,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44758,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44758,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44758,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44757,(2),null);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669_$_iter__44745(cljs.core.rest(s__44746__$2)));
}
} else {
return null;
}
break;
}
});})(i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(source_info);
});})(i__43630,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44670__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syn_sources)], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385_$_iter__44669(cljs.core.rest(s__44670__$2)));
}
} else {
return null;
}
break;
}
});})(i__43630,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__43630,cell_id,si__GT_seg_update,p_segs,vec__44667,ci,seg_indices,s__44386__$2,temp__4657__auto____$1,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(seg_indices);
})())], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44385(cljs.core.rest(s__44386__$2)));
}
} else {
return null;
}
break;
}
});})(i__43630,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__43630,vec__44384,col,cells,c__6923__auto__,size__6924__auto__,b__43631,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(cells);
})())], null));

var G__45147 = (i__43630 + (1));
i__43630 = G__45147;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43631),org$numenta$sanity$comportex$data$query_syns_$_iter__43628(cljs.core.chunk_rest(s__43629__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43631),null);
}
} else {
var vec__44759 = cljs.core.first(s__43629__$2);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44759,(0),null);
var cells = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44759,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760(s__44761){
return (new cljs.core.LazySeq(null,((function (vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44761__$1 = s__44761;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__44761__$1);
if(temp__4657__auto____$1){
var s__44761__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__44761__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__44761__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__44763 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__44762 = (0);
while(true){
if((i__44762 < size__6924__auto__)){
var vec__44950 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__44762);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44950,(0),null);
var seg_indices = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44950,(1),null);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
var si__GT_seg_update = (function (){var upd = cljs.core.get.cljs$core$IFn$_invoke$arity$2(learning,cell_id);
var vec__44951 = cljs.core.cst$kw$target_DASH_id.cljs$core$IFn$_invoke$arity$1(upd);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44951,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44951,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44951,(2),null);
return cljs.core.PersistentArrayMap.fromArray([si,upd], true, false);
})();
var p_segs = (cljs.core.truth_(prev_htm)?org.numenta.sanity.comportex.data.all_cell_segments(prev_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)):null);
cljs.core.chunk_append(b__44763,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (i__44762,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952(s__44953){
return (new cljs.core.LazySeq(null,((function (i__44762,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__44953__$1 = s__44953;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__44953__$1);
if(temp__4657__auto____$2){
var s__44953__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__44953__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__44953__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__44955 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__44954 = (0);
while(true){
if((i__44954 < size__6924__auto____$1)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__44954);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grow_sources = cljs.core.cst$kw$grow_DASH_sources.cljs$core$IFn$_invoke$arity$1((si__GT_seg_update.cljs$core$IFn$_invoke$arity$1 ? si__GT_seg_update.cljs$core$IFn$_invoke$arity$1(si) : si__GT_seg_update.call(null,si)));
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var grouped_sourced_syns = org.nfrac.comportex.util.remap(((function (i__44954,i__44762,seg,grow_sources,grouped_syns,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (syns){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__44954,i__44762,seg,grow_sources,grouped_syns,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (p__45000){
var vec__45001 = p__45000;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45001,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45001,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,source_id_and_dt_of_bit(htm,rgn_id,lyr_id,i),p], null);
});})(i__44954,i__44762,seg,grow_sources,grouped_syns,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syns);
});})(i__44954,i__44762,seg,grow_sources,grouped_syns,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(grouped_syns,cljs.core.cst$kw$growing,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,grow_sources,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(pinit))));
var syn_sources = (function (){var G__45002 = cljs.core.PersistentArrayMap.EMPTY;
var G__45002__$1 = ((cljs.core.contains_QMARK_(syn_states,"active"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45002,"active",(function (){var G__45003 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45003) : grouped_sourced_syns.call(null,G__45003));
})()):G__45002);
var G__45002__$2 = ((cljs.core.contains_QMARK_(syn_states,"inactive"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45002__$1,"inactive",cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var G__45004 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45004) : grouped_sourced_syns.call(null,G__45004));
})(),(cljs.core.truth_(cljs.core.cst$kw$disconnected.cljs$core$IFn$_invoke$arity$1(syn_states))?(function (){var G__45005 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45005) : grouped_sourced_syns.call(null,G__45005));
})():null))):G__45002__$1);
var G__45002__$3 = ((cljs.core.contains_QMARK_(syn_states,"disconnected"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45002__$2,"disconnected",(function (){var G__45006 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45006) : grouped_sourced_syns.call(null,G__45006));
})()):G__45002__$2);
if(cljs.core.contains_QMARK_(syn_states,"growing")){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45002__$3,"growing",(grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$growing) : grouped_sourced_syns.call(null,cljs.core.cst$kw$growing)));
} else {
return G__45002__$3;
}
})();
cljs.core.chunk_append(b__44955,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,org.nfrac.comportex.util.remap(((function (i__44954,i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (source_info){
var iter__6925__auto__ = ((function (i__44954,i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952_$_iter__45007(s__45008){
return (new cljs.core.LazySeq(null,((function (i__44954,i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__45008__$1 = s__45008;
while(true){
var temp__4657__auto____$3 = cljs.core.seq(s__45008__$1);
if(temp__4657__auto____$3){
var s__45008__$2 = temp__4657__auto____$3;
if(cljs.core.chunked_seq_QMARK_(s__45008__$2)){
var c__6923__auto____$2 = cljs.core.chunk_first(s__45008__$2);
var size__6924__auto____$2 = cljs.core.count(c__6923__auto____$2);
var b__45010 = cljs.core.chunk_buffer(size__6924__auto____$2);
if((function (){var i__45009 = (0);
while(true){
if((i__45009 < size__6924__auto____$2)){
var vec__45017 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$2,i__45009);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45017,(0),null);
var vec__45018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45017,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45018,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45018,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45018,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45018,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45017,(2),null);
cljs.core.chunk_append(b__45010,new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null));

var G__45148 = (i__45009 + (1));
i__45009 = G__45148;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45010),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952_$_iter__45007(cljs.core.chunk_rest(s__45008__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45010),null);
}
} else {
var vec__45019 = cljs.core.first(s__45008__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45019,(0),null);
var vec__45020 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45019,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45020,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45020,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45020,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45020,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45019,(2),null);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952_$_iter__45007(cljs.core.rest(s__45008__$2)));
}
} else {
return null;
}
break;
}
});})(i__44954,i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__44954,i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(source_info);
});})(i__44954,i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto____$1,size__6924__auto____$1,b__44955,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syn_sources)], null));

var G__45149 = (i__44954 + (1));
i__44954 = G__45149;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44955),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952(cljs.core.chunk_rest(s__44953__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44955),null);
}
} else {
var si = cljs.core.first(s__44953__$2);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grow_sources = cljs.core.cst$kw$grow_DASH_sources.cljs$core$IFn$_invoke$arity$1((si__GT_seg_update.cljs$core$IFn$_invoke$arity$1 ? si__GT_seg_update.cljs$core$IFn$_invoke$arity$1(si) : si__GT_seg_update.call(null,si)));
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var grouped_sourced_syns = org.nfrac.comportex.util.remap(((function (i__44762,seg,grow_sources,grouped_syns,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (syns){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__44762,seg,grow_sources,grouped_syns,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (p__45021){
var vec__45022 = p__45021;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45022,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45022,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,source_id_and_dt_of_bit(htm,rgn_id,lyr_id,i),p], null);
});})(i__44762,seg,grow_sources,grouped_syns,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syns);
});})(i__44762,seg,grow_sources,grouped_syns,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(grouped_syns,cljs.core.cst$kw$growing,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,grow_sources,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(pinit))));
var syn_sources = (function (){var G__45023 = cljs.core.PersistentArrayMap.EMPTY;
var G__45023__$1 = ((cljs.core.contains_QMARK_(syn_states,"active"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45023,"active",(function (){var G__45024 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45024) : grouped_sourced_syns.call(null,G__45024));
})()):G__45023);
var G__45023__$2 = ((cljs.core.contains_QMARK_(syn_states,"inactive"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45023__$1,"inactive",cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var G__45025 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45025) : grouped_sourced_syns.call(null,G__45025));
})(),(cljs.core.truth_(cljs.core.cst$kw$disconnected.cljs$core$IFn$_invoke$arity$1(syn_states))?(function (){var G__45026 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45026) : grouped_sourced_syns.call(null,G__45026));
})():null))):G__45023__$1);
var G__45023__$3 = ((cljs.core.contains_QMARK_(syn_states,"disconnected"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45023__$2,"disconnected",(function (){var G__45027 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45027) : grouped_sourced_syns.call(null,G__45027));
})()):G__45023__$2);
if(cljs.core.contains_QMARK_(syn_states,"growing")){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45023__$3,"growing",(grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$growing) : grouped_sourced_syns.call(null,cljs.core.cst$kw$growing)));
} else {
return G__45023__$3;
}
})();
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,org.nfrac.comportex.util.remap(((function (i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (source_info){
var iter__6925__auto__ = ((function (i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952_$_iter__45028(s__45029){
return (new cljs.core.LazySeq(null,((function (i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__45029__$1 = s__45029;
while(true){
var temp__4657__auto____$3 = cljs.core.seq(s__45029__$1);
if(temp__4657__auto____$3){
var s__45029__$2 = temp__4657__auto____$3;
if(cljs.core.chunked_seq_QMARK_(s__45029__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__45029__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__45031 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__45030 = (0);
while(true){
if((i__45030 < size__6924__auto____$1)){
var vec__45038 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__45030);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45038,(0),null);
var vec__45039 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45038,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45039,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45039,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45039,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45039,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45038,(2),null);
cljs.core.chunk_append(b__45031,new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null));

var G__45150 = (i__45030 + (1));
i__45030 = G__45150;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45031),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952_$_iter__45028(cljs.core.chunk_rest(s__45029__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45031),null);
}
} else {
var vec__45040 = cljs.core.first(s__45029__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45040,(0),null);
var vec__45041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45040,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45041,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45041,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45041,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45041,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45040,(2),null);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952_$_iter__45028(cljs.core.rest(s__45029__$2)));
}
} else {
return null;
}
break;
}
});})(i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(source_info);
});})(i__44762,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__44953__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syn_sources)], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__44952(cljs.core.rest(s__44953__$2)));
}
} else {
return null;
}
break;
}
});})(i__44762,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__44762,cell_id,si__GT_seg_update,p_segs,vec__44950,ci,seg_indices,c__6923__auto__,size__6924__auto__,b__44763,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(seg_indices);
})())], null));

var G__45151 = (i__44762 + (1));
i__44762 = G__45151;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__44763),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760(cljs.core.chunk_rest(s__44761__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__44763),null);
}
} else {
var vec__45042 = cljs.core.first(s__44761__$2);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45042,(0),null);
var seg_indices = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45042,(1),null);
var cell_id = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null);
var si__GT_seg_update = (function (){var upd = cljs.core.get.cljs$core$IFn$_invoke$arity$2(learning,cell_id);
var vec__45043 = cljs.core.cst$kw$target_DASH_id.cljs$core$IFn$_invoke$arity$1(upd);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45043,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45043,(1),null);
var si = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45043,(2),null);
return cljs.core.PersistentArrayMap.fromArray([si,upd], true, false);
})();
var p_segs = (cljs.core.truth_(prev_htm)?org.numenta.sanity.comportex.data.all_cell_segments(prev_sg,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null)):null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ci,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044(s__45045){
return (new cljs.core.LazySeq(null,((function (cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__45045__$1 = s__45045;
while(true){
var temp__4657__auto____$2 = cljs.core.seq(s__45045__$1);
if(temp__4657__auto____$2){
var s__45045__$2 = temp__4657__auto____$2;
if(cljs.core.chunked_seq_QMARK_(s__45045__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__45045__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__45047 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__45046 = (0);
while(true){
if((i__45046 < size__6924__auto__)){
var si = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__45046);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grow_sources = cljs.core.cst$kw$grow_DASH_sources.cljs$core$IFn$_invoke$arity$1((si__GT_seg_update.cljs$core$IFn$_invoke$arity$1 ? si__GT_seg_update.cljs$core$IFn$_invoke$arity$1(si) : si__GT_seg_update.call(null,si)));
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var grouped_sourced_syns = org.nfrac.comportex.util.remap(((function (i__45046,seg,grow_sources,grouped_syns,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (syns){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__45046,seg,grow_sources,grouped_syns,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (p__45092){
var vec__45093 = p__45092;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45093,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45093,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,source_id_and_dt_of_bit(htm,rgn_id,lyr_id,i),p], null);
});})(i__45046,seg,grow_sources,grouped_syns,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syns);
});})(i__45046,seg,grow_sources,grouped_syns,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(grouped_syns,cljs.core.cst$kw$growing,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,grow_sources,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(pinit))));
var syn_sources = (function (){var G__45094 = cljs.core.PersistentArrayMap.EMPTY;
var G__45094__$1 = ((cljs.core.contains_QMARK_(syn_states,"active"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45094,"active",(function (){var G__45095 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45095) : grouped_sourced_syns.call(null,G__45095));
})()):G__45094);
var G__45094__$2 = ((cljs.core.contains_QMARK_(syn_states,"inactive"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45094__$1,"inactive",cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var G__45096 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45096) : grouped_sourced_syns.call(null,G__45096));
})(),(cljs.core.truth_(cljs.core.cst$kw$disconnected.cljs$core$IFn$_invoke$arity$1(syn_states))?(function (){var G__45097 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45097) : grouped_sourced_syns.call(null,G__45097));
})():null))):G__45094__$1);
var G__45094__$3 = ((cljs.core.contains_QMARK_(syn_states,"disconnected"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45094__$2,"disconnected",(function (){var G__45098 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45098) : grouped_sourced_syns.call(null,G__45098));
})()):G__45094__$2);
if(cljs.core.contains_QMARK_(syn_states,"growing")){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45094__$3,"growing",(grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$growing) : grouped_sourced_syns.call(null,cljs.core.cst$kw$growing)));
} else {
return G__45094__$3;
}
})();
cljs.core.chunk_append(b__45047,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,org.nfrac.comportex.util.remap(((function (i__45046,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (source_info){
var iter__6925__auto__ = ((function (i__45046,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044_$_iter__45099(s__45100){
return (new cljs.core.LazySeq(null,((function (i__45046,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__45100__$1 = s__45100;
while(true){
var temp__4657__auto____$3 = cljs.core.seq(s__45100__$1);
if(temp__4657__auto____$3){
var s__45100__$2 = temp__4657__auto____$3;
if(cljs.core.chunked_seq_QMARK_(s__45100__$2)){
var c__6923__auto____$1 = cljs.core.chunk_first(s__45100__$2);
var size__6924__auto____$1 = cljs.core.count(c__6923__auto____$1);
var b__45102 = cljs.core.chunk_buffer(size__6924__auto____$1);
if((function (){var i__45101 = (0);
while(true){
if((i__45101 < size__6924__auto____$1)){
var vec__45109 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto____$1,i__45101);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45109,(0),null);
var vec__45110 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45109,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45110,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45109,(2),null);
cljs.core.chunk_append(b__45102,new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null));

var G__45152 = (i__45101 + (1));
i__45101 = G__45152;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45102),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044_$_iter__45099(cljs.core.chunk_rest(s__45100__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45102),null);
}
} else {
var vec__45111 = cljs.core.first(s__45100__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45111,(0),null);
var vec__45112 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45111,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45112,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45112,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45112,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45112,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45111,(2),null);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044_$_iter__45099(cljs.core.rest(s__45100__$2)));
}
} else {
return null;
}
break;
}
});})(i__45046,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(i__45046,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(source_info);
});})(i__45046,seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,c__6923__auto__,size__6924__auto__,b__45047,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syn_sources)], null));

var G__45153 = (i__45046 + (1));
i__45046 = G__45153;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45047),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044(cljs.core.chunk_rest(s__45045__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45047),null);
}
} else {
var si = cljs.core.first(s__45045__$2);
var seg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(p_segs,si,cljs.core.PersistentArrayMap.EMPTY);
var grow_sources = cljs.core.cst$kw$grow_DASH_sources.cljs$core$IFn$_invoke$arity$1((si__GT_seg_update.cljs$core$IFn$_invoke$arity$1 ? si__GT_seg_update.cljs$core$IFn$_invoke$arity$1(si) : si__GT_seg_update.call(null,si)));
var grouped_syns = org.numenta.sanity.comportex.data.group_synapses(seg,on_bits,pcon);
var grouped_sourced_syns = org.nfrac.comportex.util.remap(((function (seg,grow_sources,grouped_syns,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (syns){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (seg,grow_sources,grouped_syns,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (p__45113){
var vec__45114 = p__45113;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45114,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45114,(1),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,source_id_and_dt_of_bit(htm,rgn_id,lyr_id,i),p], null);
});})(seg,grow_sources,grouped_syns,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syns);
});})(seg,grow_sources,grouped_syns,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(grouped_syns,cljs.core.cst$kw$growing,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,grow_sources,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(pinit))));
var syn_sources = (function (){var G__45115 = cljs.core.PersistentArrayMap.EMPTY;
var G__45115__$1 = ((cljs.core.contains_QMARK_(syn_states,"active"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45115,"active",(function (){var G__45116 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45116) : grouped_sourced_syns.call(null,G__45116));
})()):G__45115);
var G__45115__$2 = ((cljs.core.contains_QMARK_(syn_states,"inactive"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45115__$1,"inactive",cljs.core.concat.cljs$core$IFn$_invoke$arity$2((function (){var G__45117 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$connected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45117) : grouped_sourced_syns.call(null,G__45117));
})(),(cljs.core.truth_(cljs.core.cst$kw$disconnected.cljs$core$IFn$_invoke$arity$1(syn_states))?(function (){var G__45118 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$inactive], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45118) : grouped_sourced_syns.call(null,G__45118));
})():null))):G__45115__$1);
var G__45115__$3 = ((cljs.core.contains_QMARK_(syn_states,"disconnected"))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45115__$2,"disconnected",(function (){var G__45119 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$disconnected,cljs.core.cst$kw$active], null);
return (grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(G__45119) : grouped_sourced_syns.call(null,G__45119));
})()):G__45115__$2);
if(cljs.core.contains_QMARK_(syn_states,"growing")){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__45115__$3,"growing",(grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1 ? grouped_sourced_syns.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$growing) : grouped_sourced_syns.call(null,cljs.core.cst$kw$growing)));
} else {
return G__45115__$3;
}
})();
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [si,org.nfrac.comportex.util.remap(((function (seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (source_info){
var iter__6925__auto__ = ((function (seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044_$_iter__45120(s__45121){
return (new cljs.core.LazySeq(null,((function (seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit){
return (function (){
var s__45121__$1 = s__45121;
while(true){
var temp__4657__auto____$3 = cljs.core.seq(s__45121__$1);
if(temp__4657__auto____$3){
var s__45121__$2 = temp__4657__auto____$3;
if(cljs.core.chunked_seq_QMARK_(s__45121__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__45121__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__45123 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__45122 = (0);
while(true){
if((i__45122 < size__6924__auto__)){
var vec__45130 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__45122);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45130,(0),null);
var vec__45131 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45130,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45131,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45131,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45131,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45131,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45130,(2),null);
cljs.core.chunk_append(b__45123,new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null));

var G__45154 = (i__45122 + (1));
i__45122 = G__45154;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45123),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044_$_iter__45120(cljs.core.chunk_rest(s__45121__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45123),null);
}
} else {
var vec__45132 = cljs.core.first(s__45121__$2);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45132,(0),null);
var vec__45133 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45132,(1),null);
var src_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45133,(0),null);
var src_lyr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45133,(1),null);
var src_i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45133,(2),null);
var src_dt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45133,(3),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45132,(2),null);
return cljs.core.cons(new cljs.core.PersistentArrayMap(null, 5, ["src-i",src_i,"src-id",src_id,"src-lyr",(cljs.core.truth_(src_lyr)?src_lyr:null),"src-dt",src_dt,"perm",p], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044_$_iter__45120(cljs.core.rest(s__45121__$2)));
}
} else {
return null;
}
break;
}
});})(seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(source_info);
});})(seg,grow_sources,grouped_syns,grouped_sourced_syns,syn_sources,si,s__45045__$2,temp__4657__auto____$2,cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,syn_sources)], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760_$_iter__45044(cljs.core.rest(s__45045__$2)));
}
} else {
return null;
}
break;
}
});})(cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(cell_id,si__GT_seg_update,p_segs,vec__45042,ci,seg_indices,s__44761__$2,temp__4657__auto____$1,vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(seg_indices);
})())], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628_$_iter__44760(cljs.core.rest(s__44761__$2)));
}
} else {
return null;
}
break;
}
});})(vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(vec__44759,col,cells,s__43629__$2,temp__4657__auto__,regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(cells);
})())], null),org$numenta$sanity$comportex$data$query_syns_$_iter__43628(cljs.core.rest(s__43629__$2)));
}
} else {
return null;
}
break;
}
});})(regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
,null,null));
});})(regions,lyr,spec,dspec,pcon,pinit,on_bits,depth,learning,sg_key,sg,prev_sg,input_layer_QMARK_,output_layer,dt,source_of_bit,source_id_and_dt_of_bit))
;
return iter__6925__auto__(org.numenta.sanity.comportex.data.expand_seg_selector(seg_selector,depth,sg,seg_type));
});
org.numenta.sanity.comportex.data.cell_excitation_data = (function org$numenta$sanity$comportex$data$cell_excitation_data(htm,prior_htm,rgn_id,lyr_id,sel_col){
var wc = org.nfrac.comportex.protocols.winner_cells(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id,lyr_id], null)));
var wc_PLUS_ = (cljs.core.truth_(sel_col)?(function (){var prior_wc = org.nfrac.comportex.protocols.winner_cells(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(prior_htm,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id,lyr_id], null)));
var sel_cell = (function (){var or__6153__auto__ = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (prior_wc,wc){
return (function (p__45161){
var vec__45162 = p__45161;
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45162,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45162,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(col,sel_col);
});})(prior_wc,wc))
,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(prior_wc,wc)));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sel_col,(0)], null);
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(wc,sel_cell);
})():wc);
return org.nfrac.comportex.core.cell_excitation_breakdowns(htm,prior_htm,rgn_id,lyr_id,wc_PLUS_);
});
org.numenta.sanity.comportex.data.network_shape = (function org$numenta$sanity$comportex$data$network_shape(htm){
var sense_keys = org.nfrac.comportex.core.sense_keys(htm);
return new cljs.core.PersistentArrayMap(null, 2, ["senses",cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (sense_keys){
return (function (st,p__45179){
var vec__45180 = p__45179;
var ordinal = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45180,(0),null);
var sense_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45180,(1),null);
var sense = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$senses,sense_id], null));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(st,sense_id,new cljs.core.PersistentArrayMap(null, 2, ["dimensions",org.nfrac.comportex.protocols.dims_of(sense),"ordinal",ordinal], null));
});})(sense_keys))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$0(),sense_keys)),"regions",cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (sense_keys){
return (function (rt,p__45181){
var vec__45182 = p__45181;
var ordinal = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45182,(0),null);
var vec__45183 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45182,(1),null);
var rgn_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45183,(0),null);
var lyr_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45183,(1),null);
var lyr = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id,lyr_id], null));
return cljs.core.assoc_in(rt,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id,lyr_id], null),new cljs.core.PersistentArrayMap(null, 4, ["spec",org.nfrac.comportex.protocols.params(lyr),"dimensions",org.nfrac.comportex.protocols.dims_of(lyr),"cells-per-column",org.nfrac.comportex.protocols.layer_depth(lyr),"ordinal",(ordinal + cljs.core.count(sense_keys))], null));
});})(sense_keys))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,cljs.core.range.cljs$core$IFn$_invoke$arity$0(),(function (){var iter__6925__auto__ = ((function (sense_keys){
return (function org$numenta$sanity$comportex$data$network_shape_$_iter__45184(s__45185){
return (new cljs.core.LazySeq(null,((function (sense_keys){
return (function (){
var s__45185__$1 = s__45185;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__45185__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var rgn_id = cljs.core.first(xs__5205__auto__);
var rgn = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id], null));
var iterys__6921__auto__ = ((function (s__45185__$1,rgn,rgn_id,xs__5205__auto__,temp__4657__auto__,sense_keys){
return (function org$numenta$sanity$comportex$data$network_shape_$_iter__45184_$_iter__45186(s__45187){
return (new cljs.core.LazySeq(null,((function (s__45185__$1,rgn,rgn_id,xs__5205__auto__,temp__4657__auto__,sense_keys){
return (function (){
var s__45187__$1 = s__45187;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__45187__$1);
if(temp__4657__auto____$1){
var s__45187__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__45187__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__45187__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__45189 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__45188 = (0);
while(true){
if((i__45188 < size__6924__auto__)){
var lyr_id = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__45188);
cljs.core.chunk_append(b__45189,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id,lyr_id], null));

var G__45195 = (i__45188 + (1));
i__45188 = G__45195;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45189),org$numenta$sanity$comportex$data$network_shape_$_iter__45184_$_iter__45186(cljs.core.chunk_rest(s__45187__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45189),null);
}
} else {
var lyr_id = cljs.core.first(s__45187__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id,lyr_id], null),org$numenta$sanity$comportex$data$network_shape_$_iter__45184_$_iter__45186(cljs.core.rest(s__45187__$2)));
}
} else {
return null;
}
break;
}
});})(s__45185__$1,rgn,rgn_id,xs__5205__auto__,temp__4657__auto__,sense_keys))
,null,null));
});})(s__45185__$1,rgn,rgn_id,xs__5205__auto__,temp__4657__auto__,sense_keys))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(org.nfrac.comportex.core.layers(rgn)));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$numenta$sanity$comportex$data$network_shape_$_iter__45184(cljs.core.rest(s__45185__$1)));
} else {
var G__45196 = cljs.core.rest(s__45185__$1);
s__45185__$1 = G__45196;
continue;
}
} else {
return null;
}
break;
}
});})(sense_keys))
,null,null));
});})(sense_keys))
;
return iter__6925__auto__(org.nfrac.comportex.core.region_keys.cljs$core$IFn$_invoke$arity$1(htm));
})()))], null);
});
org.numenta.sanity.comportex.data.cell__GT_id = (function org$numenta$sanity$comportex$data$cell__GT_id(depth,p__45197){
var vec__45199 = p__45197;
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45199,(0),null);
var ci = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45199,(1),null);
return ((col * depth) + ci);
});
org.numenta.sanity.comportex.data.cell_cells_transitions = (function org$numenta$sanity$comportex$data$cell_cells_transitions(distal_sg,depth,n_cols){
var all_cell_ids = (function (){var iter__6925__auto__ = (function org$numenta$sanity$comportex$data$cell_cells_transitions_$_iter__45211(s__45212){
return (new cljs.core.LazySeq(null,(function (){
var s__45212__$1 = s__45212;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__45212__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var col = cljs.core.first(xs__5205__auto__);
var iterys__6921__auto__ = ((function (s__45212__$1,col,xs__5205__auto__,temp__4657__auto__){
return (function org$numenta$sanity$comportex$data$cell_cells_transitions_$_iter__45211_$_iter__45213(s__45214){
return (new cljs.core.LazySeq(null,((function (s__45212__$1,col,xs__5205__auto__,temp__4657__auto__){
return (function (){
var s__45214__$1 = s__45214;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__45214__$1);
if(temp__4657__auto____$1){
var s__45214__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__45214__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__45214__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__45216 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__45215 = (0);
while(true){
if((i__45215 < size__6924__auto__)){
var ci = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__45215);
cljs.core.chunk_append(b__45216,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null));

var G__45222 = (i__45215 + (1));
i__45215 = G__45222;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__45216),org$numenta$sanity$comportex$data$cell_cells_transitions_$_iter__45211_$_iter__45213(cljs.core.chunk_rest(s__45214__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__45216),null);
}
} else {
var ci = cljs.core.first(s__45214__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [col,ci], null),org$numenta$sanity$comportex$data$cell_cells_transitions_$_iter__45211_$_iter__45213(cljs.core.rest(s__45214__$2)));
}
} else {
return null;
}
break;
}
});})(s__45212__$1,col,xs__5205__auto__,temp__4657__auto__))
,null,null));
});})(s__45212__$1,col,xs__5205__auto__,temp__4657__auto__))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(depth)));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$numenta$sanity$comportex$data$cell_cells_transitions_$_iter__45211(cljs.core.rest(s__45212__$1)));
} else {
var G__45223 = cljs.core.rest(s__45212__$1);
s__45212__$1 = G__45223;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6925__auto__(cljs.core.range.cljs$core$IFn$_invoke$arity$1(n_cols));
})();
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (all_cell_ids){
return (function (m,from_cell){
var source_id = org.numenta.sanity.comportex.data.cell__GT_id(depth,from_cell);
var to_segs = org.nfrac.comportex.protocols.targets_connected_from(distal_sg,source_id);
var to_cells = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.pop,to_segs);
if(cljs.core.seq(to_cells)){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,from_cell,cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(m,from_cell,cljs.core.PersistentHashSet.EMPTY),to_cells));
} else {
return m;
}
});})(all_cell_ids))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),all_cell_ids));
});
org.numenta.sanity.comportex.data.cell_sdr_transitions = (function org$numenta$sanity$comportex$data$cell_sdr_transitions(cell_cells_xns,cell_sdr_fracs){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,from_cell,to_cells){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m,from_cell,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cell_sdr_fracs,to_cells)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),cell_cells_xns));
});
org.numenta.sanity.comportex.data.sdr_sdr_transitions = (function org$numenta$sanity$comportex$data$sdr_sdr_transitions(cell_sdrs_xns,cell_sdr_fracs){
return org.nfrac.comportex.util.remap((function (to_sdr_frac_sums){
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (p__45227){
var vec__45228 = p__45227;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45228,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__45228,(1),null);
return (n >= (1));
})),to_sdr_frac_sums);
}),cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (m,from_cell,to_sdrs_fracs){
return cljs.core.reduce_kv((function (m__$1,from_sdr,from_frac){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,from_sdr,cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._PLUS_,cljs.core.array_seq([cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,from_sdr,cljs.core.PersistentArrayMap.EMPTY),org.nfrac.comportex.util.remap((function (p1__45224_SHARP_){
return (p1__45224_SHARP_ * from_frac);
}),to_sdrs_fracs)], 0)));
}),m,(cell_sdr_fracs.cljs$core$IFn$_invoke$arity$1 ? cell_sdr_fracs.cljs$core$IFn$_invoke$arity$1(from_cell) : cell_sdr_fracs.call(null,from_cell)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),cell_sdrs_xns)));
});
org.numenta.sanity.comportex.data.freqs__GT_fracs = (function org$numenta$sanity$comportex$data$freqs__GT_fracs(freqs){
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(freqs));
return org.nfrac.comportex.util.remap(((function (total){
return (function (p1__45229_SHARP_){
return (p1__45229_SHARP_ / total);
});})(total))
,freqs);
});
/**
 * Argument cell-sdr-counts is a map from cell id to the SDRs it
 *   participates in. Each value gives the frequencies map by SDR id
 *   for that cell.
 * 
 *   Returns the SDR to SDR transitions, derived from the distal synapse
 *   graph. It is a map from an SDR id to any subsequent SDRs, each
 *   mapped to the number of connected synapses, weighted by the
 *   specificity of both the source and target cells to those SDRs.
 */
org.numenta.sanity.comportex.data.transitions_data = (function org$numenta$sanity$comportex$data$transitions_data(htm,rgn_id,lyr_id,cell_sdr_counts){
var lyr = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(htm,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,rgn_id,lyr_id], null));
var depth = org.nfrac.comportex.protocols.layer_depth(lyr);
var distal_sg = cljs.core.cst$kw$distal_DASH_sg.cljs$core$IFn$_invoke$arity$1(lyr);
var cell_sdr_fracs = org.nfrac.comportex.util.remap(org.numenta.sanity.comportex.data.freqs__GT_fracs,cell_sdr_counts);
return org.numenta.sanity.comportex.data.sdr_sdr_transitions(org.numenta.sanity.comportex.data.cell_sdr_transitions(org.numenta.sanity.comportex.data.cell_cells_transitions(distal_sg,depth,org.nfrac.comportex.protocols.size_of(lyr)),cell_sdr_fracs),cell_sdr_fracs);
});
