// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('org.numenta.sanity.controls_ui');
goog.require('cljs.core');
goog.require('org.numenta.sanity.plots');
goog.require('goog.dom.forms');
goog.require('goog.dom');
goog.require('goog.dom.classes');
goog.require('reagent.core');
goog.require('org.numenta.sanity.helpers');
goog.require('org.nfrac.comportex.protocols');
goog.require('goog.string');
goog.require('cljs.core.async');
goog.require('clojure.browser.repl');
goog.require('org.numenta.sanity.bridge.marshalling');
goog.require('reagent_forms.core');
goog.require('org.numenta.sanity.selection');
goog.require('clojure.string');
goog.require('cljs.reader');
goog.require('clojure.walk');
org.numenta.sanity.controls_ui.now = (function org$numenta$sanity$controls_ui$now(){
return (new Date()).getTime();
});
/**
 * Returns the simulation rate in timesteps per second for current
 * run.
 */
org.numenta.sanity.controls_ui.sim_rate = (function org$numenta$sanity$controls_ui$sim_rate(step,run_start){
var temp__4655__auto__ = cljs.core.cst$kw$time.cljs$core$IFn$_invoke$arity$1(run_start);
if(cljs.core.truth_(temp__4655__auto__)){
var time_start = temp__4655__auto__;
var dur_ms = (org.numenta.sanity.controls_ui.now() - time_start);
return (((cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(step) - cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(run_start)) / dur_ms) * (1000));
} else {
return (0);
}
});
org.numenta.sanity.controls_ui.param_type = (function org$numenta$sanity$controls_ui$param_type(v){
if((v === true) || (v === false)){
return cljs.core.cst$kw$boolean;
} else {
if(cljs.core.vector_QMARK_(v)){
return cljs.core.cst$kw$vector;
} else {
return cljs.core.cst$kw$number;

}
}
});
org.numenta.sanity.controls_ui.spec_form = (function org$numenta$sanity$controls_ui$spec_form(network_shape,partypes,spec,spec_path,skip_set){
var iter__6925__auto__ = (function org$numenta$sanity$controls_ui$spec_form_$_iter__66745(s__66746){
return (new cljs.core.LazySeq(null,(function (){
var s__66746__$1 = s__66746;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__66746__$1);
if(temp__4657__auto__){
var s__66746__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__66746__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__66746__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__66748 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__66747 = (0);
while(true){
if((i__66747 < size__6924__auto__)){
var vec__66761 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__66747);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66761,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66761,(1),null);
if(cljs.core.not((skip_set.cljs$core$IFn$_invoke$arity$1 ? skip_set.cljs$core$IFn$_invoke$arity$1(k) : skip_set.call(null,k)))){
var typ = (function (){var or__6153__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(partypes) : cljs.core.deref.call(null,partypes)),k);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(partypes,cljs.core.assoc,k,org.numenta.sanity.controls_ui.param_type(v)),k);
}
})();
var setv_BANG_ = ((function (i__66747,s__66746__$1,typ,vec__66761,k,v,c__6923__auto__,size__6924__auto__,b__66748,s__66746__$2,temp__4657__auto__){
return (function (p1__66718_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(network_shape,cljs.core.assoc_in,spec_path,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(spec,k,p1__66718_SHARP_));
});})(i__66747,s__66746__$1,typ,vec__66761,k,v,c__6923__auto__,size__6924__auto__,b__66748,s__66746__$2,temp__4657__auto__))
;
cljs.core.chunk_append(b__66748,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,((((v == null)) || (typeof v === 'string'))?"has-error":null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_8,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$control_DASH_label$text_DASH_left,cljs.core.name(k)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_4,(function (){var G__66762 = (((typ instanceof cljs.core.Keyword))?typ.fqn:null);
switch (G__66762) {
case "boolean":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control$input_DASH_sm,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$checked,(cljs.core.truth_(v)?true:null),cljs.core.cst$kw$on_DASH_change,((function (i__66747,s__66746__$1,G__66762,typ,setv_BANG_,vec__66761,k,v,c__6923__auto__,size__6924__auto__,b__66748,s__66746__$2,temp__4657__auto__){
return (function (){
return setv_BANG_(cljs.core.not(v));
});})(i__66747,s__66746__$1,G__66762,typ,setv_BANG_,vec__66761,k,v,c__6923__auto__,size__6924__auto__,b__66748,s__66746__$2,temp__4657__auto__))
], null)], null);

break;
case "vector":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control$input_DASH_sm,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,[cljs.core.str(v)].join(''),cljs.core.cst$kw$on_DASH_change,((function (i__66747,s__66746__$1,G__66762,typ,setv_BANG_,vec__66761,k,v,c__6923__auto__,size__6924__auto__,b__66748,s__66746__$2,temp__4657__auto__){
return (function (e){
var s = (function (){var G__66763 = e.target;
return goog.dom.forms.getValue(G__66763);
})();
var x = (function (){try{return cljs.reader.read_string(s);
}catch (e66764){var _ = e66764;
return s;
}})();
var newval = (((cljs.core.vector_QMARK_(x)) && (cljs.core.every_QMARK_(cljs.core.integer_QMARK_,x)))?x:s);
return setv_BANG_(newval);
});})(i__66747,s__66746__$1,G__66762,typ,setv_BANG_,vec__66761,k,v,c__6923__auto__,size__6924__auto__,b__66748,s__66746__$2,temp__4657__auto__))
], null)], null);

break;
case "number":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control$input_DASH_sm,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,v,cljs.core.cst$kw$on_DASH_change,((function (i__66747,s__66746__$1,G__66762,typ,setv_BANG_,vec__66761,k,v,c__6923__auto__,size__6924__auto__,b__66748,s__66746__$2,temp__4657__auto__){
return (function (e){
var s = (function (){var G__66765 = e.target;
return goog.dom.forms.getValue(G__66765);
})();
var parsed = parseFloat(s);
var newval = (cljs.core.truth_((function (){var or__6153__auto__ = cljs.core.empty_QMARK_(s);
if(or__6153__auto__){
return or__6153__auto__;
} else {
return isNaN(parsed);
}
})())?null:((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,[cljs.core.str(parsed)].join('')))?s:parsed));
return setv_BANG_(newval);
});})(i__66747,s__66746__$1,G__66762,typ,setv_BANG_,vec__66761,k,v,c__6923__auto__,size__6924__auto__,b__66748,s__66746__$2,temp__4657__auto__))
], null)], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
})()], null)], null));

var G__66772 = (i__66747 + (1));
i__66747 = G__66772;
continue;
} else {
var G__66773 = (i__66747 + (1));
i__66747 = G__66773;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__66748),org$numenta$sanity$controls_ui$spec_form_$_iter__66745(cljs.core.chunk_rest(s__66746__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__66748),null);
}
} else {
var vec__66766 = cljs.core.first(s__66746__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66766,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66766,(1),null);
if(cljs.core.not((skip_set.cljs$core$IFn$_invoke$arity$1 ? skip_set.cljs$core$IFn$_invoke$arity$1(k) : skip_set.call(null,k)))){
var typ = (function (){var or__6153__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(partypes) : cljs.core.deref.call(null,partypes)),k);
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(partypes,cljs.core.assoc,k,org.numenta.sanity.controls_ui.param_type(v)),k);
}
})();
var setv_BANG_ = ((function (s__66746__$1,typ,vec__66766,k,v,s__66746__$2,temp__4657__auto__){
return (function (p1__66718_SHARP_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(network_shape,cljs.core.assoc_in,spec_path,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(spec,k,p1__66718_SHARP_));
});})(s__66746__$1,typ,vec__66766,k,v,s__66746__$2,temp__4657__auto__))
;
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,((((v == null)) || (typeof v === 'string'))?"has-error":null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_8,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$control_DASH_label$text_DASH_left,cljs.core.name(k)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_4,(function (){var G__66767 = (((typ instanceof cljs.core.Keyword))?typ.fqn:null);
switch (G__66767) {
case "boolean":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control$input_DASH_sm,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$checked,(cljs.core.truth_(v)?true:null),cljs.core.cst$kw$on_DASH_change,((function (s__66746__$1,G__66767,typ,setv_BANG_,vec__66766,k,v,s__66746__$2,temp__4657__auto__){
return (function (){
return setv_BANG_(cljs.core.not(v));
});})(s__66746__$1,G__66767,typ,setv_BANG_,vec__66766,k,v,s__66746__$2,temp__4657__auto__))
], null)], null);

break;
case "vector":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control$input_DASH_sm,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,[cljs.core.str(v)].join(''),cljs.core.cst$kw$on_DASH_change,((function (s__66746__$1,G__66767,typ,setv_BANG_,vec__66766,k,v,s__66746__$2,temp__4657__auto__){
return (function (e){
var s = (function (){var G__66768 = e.target;
return goog.dom.forms.getValue(G__66768);
})();
var x = (function (){try{return cljs.reader.read_string(s);
}catch (e66769){var _ = e66769;
return s;
}})();
var newval = (((cljs.core.vector_QMARK_(x)) && (cljs.core.every_QMARK_(cljs.core.integer_QMARK_,x)))?x:s);
return setv_BANG_(newval);
});})(s__66746__$1,G__66767,typ,setv_BANG_,vec__66766,k,v,s__66746__$2,temp__4657__auto__))
], null)], null);

break;
case "number":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input$form_DASH_control$input_DASH_sm,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$value,v,cljs.core.cst$kw$on_DASH_change,((function (s__66746__$1,G__66767,typ,setv_BANG_,vec__66766,k,v,s__66746__$2,temp__4657__auto__){
return (function (e){
var s = (function (){var G__66770 = e.target;
return goog.dom.forms.getValue(G__66770);
})();
var parsed = parseFloat(s);
var newval = (cljs.core.truth_((function (){var or__6153__auto__ = cljs.core.empty_QMARK_(s);
if(or__6153__auto__){
return or__6153__auto__;
} else {
return isNaN(parsed);
}
})())?null:((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(s,[cljs.core.str(parsed)].join('')))?s:parsed));
return setv_BANG_(newval);
});})(s__66746__$1,G__66767,typ,setv_BANG_,vec__66766,k,v,s__66746__$2,temp__4657__auto__))
], null)], null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(typ)].join('')));

}
})()], null)], null),org$numenta$sanity$controls_ui$spec_form_$_iter__66745(cljs.core.rest(s__66746__$2)));
} else {
var G__66775 = cljs.core.rest(s__66746__$2);
s__66746__$1 = G__66775;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6925__auto__(cljs.core.sort.cljs$core$IFn$_invoke$arity$1(spec));
});
org.numenta.sanity.controls_ui.parameters_tab = (function org$numenta$sanity$controls_ui$parameters_tab(network_shape,_,into_sim,___$1){
cljs.core.add_watch(network_shape,cljs.core.cst$kw$org$numenta$sanity$controls_DASH_ui_SLASH_push_DASH_to_DASH_server,(function (___$2,___$3,prev_st,st){
if((prev_st == null)){
return null;
} else {
var seq__66829 = cljs.core.seq((function (){var iter__6925__auto__ = (function org$numenta$sanity$controls_ui$parameters_tab_$_iter__66835(s__66836){
return (new cljs.core.LazySeq(null,(function (){
var s__66836__$1 = s__66836;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__66836__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var vec__66845 = cljs.core.first(xs__5205__auto__);
var r_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66845,(0),null);
var rgn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66845,(1),null);
var iterys__6921__auto__ = ((function (s__66836__$1,vec__66845,r_id,rgn,xs__5205__auto__,temp__4657__auto__){
return (function org$numenta$sanity$controls_ui$parameters_tab_$_iter__66835_$_iter__66837(s__66838){
return (new cljs.core.LazySeq(null,((function (s__66836__$1,vec__66845,r_id,rgn,xs__5205__auto__,temp__4657__auto__){
return (function (){
var s__66838__$1 = s__66838;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__66838__$1);
if(temp__4657__auto____$1){
var s__66838__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__66838__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__66838__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__66840 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__66839 = (0);
while(true){
if((i__66839 < size__6924__auto__)){
var l_id = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__66839);
cljs.core.chunk_append(b__66840,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,r_id,l_id,cljs.core.cst$kw$spec], null));

var G__66882 = (i__66839 + (1));
i__66839 = G__66882;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__66840),org$numenta$sanity$controls_ui$parameters_tab_$_iter__66835_$_iter__66837(cljs.core.chunk_rest(s__66838__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__66840),null);
}
} else {
var l_id = cljs.core.first(s__66838__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,r_id,l_id,cljs.core.cst$kw$spec], null),org$numenta$sanity$controls_ui$parameters_tab_$_iter__66835_$_iter__66837(cljs.core.rest(s__66838__$2)));
}
} else {
return null;
}
break;
}
});})(s__66836__$1,vec__66845,r_id,rgn,xs__5205__auto__,temp__4657__auto__))
,null,null));
});})(s__66836__$1,vec__66845,r_id,rgn,xs__5205__auto__,temp__4657__auto__))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(cljs.core.keys(rgn)));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$numenta$sanity$controls_ui$parameters_tab_$_iter__66835(cljs.core.rest(s__66836__$1)));
} else {
var G__66883 = cljs.core.rest(s__66836__$1);
s__66836__$1 = G__66883;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6925__auto__(cljs.core.cst$kw$regions.cljs$core$IFn$_invoke$arity$1(st));
})());
var chunk__66831 = null;
var count__66832 = (0);
var i__66833 = (0);
while(true){
if((i__66833 < count__66832)){
var path = chunk__66831.cljs$core$IIndexed$_nth$arity$2(null,i__66833);
var old_spec_66884 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(prev_st,path);
var new_spec_66885 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(st,path);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_spec_66884,new_spec_66885)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["set-spec",path,new_spec_66885], null));
} else {
}

var G__66886 = seq__66829;
var G__66887 = chunk__66831;
var G__66888 = count__66832;
var G__66889 = (i__66833 + (1));
seq__66829 = G__66886;
chunk__66831 = G__66887;
count__66832 = G__66888;
i__66833 = G__66889;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__66829);
if(temp__4657__auto__){
var seq__66829__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__66829__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__66829__$1);
var G__66890 = cljs.core.chunk_rest(seq__66829__$1);
var G__66891 = c__6956__auto__;
var G__66892 = cljs.core.count(c__6956__auto__);
var G__66893 = (0);
seq__66829 = G__66890;
chunk__66831 = G__66891;
count__66832 = G__66892;
i__66833 = G__66893;
continue;
} else {
var path = cljs.core.first(seq__66829__$1);
var old_spec_66894 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(prev_st,path);
var new_spec_66895 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(st,path);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(old_spec_66894,new_spec_66895)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["set-spec",path,new_spec_66895], null));
} else {
}

var G__66896 = cljs.core.next(seq__66829__$1);
var G__66897 = null;
var G__66898 = (0);
var G__66899 = (0);
seq__66829 = G__66896;
chunk__66831 = G__66897;
count__66832 = G__66898;
i__66833 = G__66899;
continue;
}
} else {
return null;
}
}
break;
}
}
}));

var partypes = (function (){var G__66848 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__66848) : cljs.core.atom.call(null,G__66848));
})();
return ((function (partypes){
return (function (network_shape__$1,selection,into_sim__$1){
var vec__66849 = cljs.core.some(org.numenta.sanity.selection.layer,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selection) : cljs.core.deref.call(null,selection)));
var sel_region = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66849,(0),null);
var sel_layer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66849,(1),null);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,"Read/write model parameters of the selected region layer,\n                    with immediate effect. Click a layer to select it."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_info$text_DASH_center,(cljs.core.truth_(sel_layer)?[cljs.core.str(cljs.core.name(sel_region)),cljs.core.str(" "),cljs.core.str(cljs.core.name(sel_layer))].join(''):null)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_horizontal], null),(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape__$1) : cljs.core.deref.call(null,network_shape__$1)))?(function (){var spec_path = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions,sel_region,sel_layer,cljs.core.cst$kw$spec], null);
var spec = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape__$1) : cljs.core.deref.call(null,network_shape__$1)),spec_path);
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(org.numenta.sanity.controls_ui.spec_form(network_shape__$1,partypes,spec,spec_path,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$distal,null,cljs.core.cst$kw$proximal,null,cljs.core.cst$kw$apical,null], null), null)),(function (){var iter__6925__auto__ = ((function (spec_path,spec,vec__66849,sel_region,sel_layer,partypes){
return (function org$numenta$sanity$controls_ui$parameters_tab_$_iter__66850(s__66851){
return (new cljs.core.LazySeq(null,((function (spec_path,spec,vec__66849,sel_region,sel_layer,partypes){
return (function (){
var s__66851__$1 = s__66851;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__66851__$1);
if(temp__4657__auto__){
var s__66851__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__66851__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__66851__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__66853 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__66852 = (0);
while(true){
if((i__66852 < size__6924__auto__)){
var vec__66858 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__66852);
var sub_k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66858,(0),null);
var title = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66858,(1),null);
cljs.core.chunk_append(b__66853,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_heading,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$panel_DASH_title,title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_horizontal], null),org.numenta.sanity.controls_ui.spec_form(network_shape__$1,partypes,cljs.core.get.cljs$core$IFn$_invoke$arity$2(spec,sub_k),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(spec_path,sub_k),cljs.core.PersistentHashSet.EMPTY))], null)], null));

var G__66900 = (i__66852 + (1));
i__66852 = G__66900;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__66853),org$numenta$sanity$controls_ui$parameters_tab_$_iter__66850(cljs.core.chunk_rest(s__66851__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__66853),null);
}
} else {
var vec__66859 = cljs.core.first(s__66851__$2);
var sub_k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66859,(0),null);
var title = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__66859,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_heading,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$panel_DASH_title,title], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_horizontal], null),org.numenta.sanity.controls_ui.spec_form(network_shape__$1,partypes,cljs.core.get.cljs$core$IFn$_invoke$arity$2(spec,sub_k),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(spec_path,sub_k),cljs.core.PersistentHashSet.EMPTY))], null)], null),org$numenta$sanity$controls_ui$parameters_tab_$_iter__66850(cljs.core.rest(s__66851__$2)));
}
} else {
return null;
}
break;
}
});})(spec_path,spec,vec__66849,sel_region,sel_layer,partypes))
,null,null));
});})(spec_path,spec,vec__66849,sel_region,sel_layer,partypes))
;
return iter__6925__auto__(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$proximal,"Proximal dendrites"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$distal,"Distal (lateral) dendrites"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$apical,"Apical dendrites"], null)], null));
})(),cljs.core.array_seq([new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_heading,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$panel_DASH_title,"Note"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Parameter values can be altered above, but some parameters\n                     must be in effect when the HTM regions are created.\n                     Notable examples are ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$code,"column-dimensions"], null)," and ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$code,"depth"], null),". After setting such parameter values, rebuild all regions\n                 (obviously losing any learned connections in the process):"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_warning$btn_DASH_block,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (spec_path,spec,vec__66849,sel_region,sel_layer,partypes){
return (function (){
return org.numenta.sanity.helpers.ui_loading_message_until((function (){var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__,spec_path,spec,vec__66849,sel_region,sel_layer,partypes){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__,spec_path,spec,vec__66849,sel_region,sel_layer,partypes){
return (function (state_66872){
var state_val_66873 = (state_66872[(1)]);
if((state_val_66873 === (1))){
var inst_66860 = cljs.core.async.timeout((100));
var state_66872__$1 = state_66872;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66872__$1,(2),inst_66860);
} else {
if((state_val_66873 === (2))){
var inst_66862 = (state_66872[(2)]);
var inst_66863 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_66864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66865 = org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(inst_66863,true);
var inst_66866 = ["restart",inst_66865];
var inst_66867 = (new cljs.core.PersistentVector(null,2,(5),inst_66864,inst_66866,null));
var inst_66868 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim__$1,inst_66867);
var state_66872__$1 = (function (){var statearr_66874 = state_66872;
(statearr_66874[(7)] = inst_66862);

(statearr_66874[(8)] = inst_66868);

return statearr_66874;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66872__$1,(3),inst_66863);
} else {
if((state_val_66873 === (3))){
var inst_66870 = (state_66872[(2)]);
var state_66872__$1 = state_66872;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66872__$1,inst_66870);
} else {
return null;
}
}
}
});})(c__38109__auto__,spec_path,spec,vec__66849,sel_region,sel_layer,partypes))
;
return ((function (switch__37995__auto__,c__38109__auto__,spec_path,spec,vec__66849,sel_region,sel_layer,partypes){
return (function() {
var org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto__ = null;
var org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto____0 = (function (){
var statearr_66878 = [null,null,null,null,null,null,null,null,null];
(statearr_66878[(0)] = org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto__);

(statearr_66878[(1)] = (1));

return statearr_66878;
});
var org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto____1 = (function (state_66872){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_66872);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e66879){if((e66879 instanceof Object)){
var ex__37999__auto__ = e66879;
var statearr_66880_66901 = state_66872;
(statearr_66880_66901[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_66872);

return cljs.core.cst$kw$recur;
} else {
throw e66879;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__66902 = state_66872;
state_66872 = G__66902;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto__ = function(state_66872){
switch(arguments.length){
case 0:
return org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto____1.call(this,state_66872);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto____0;
org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto____1;
return org$numenta$sanity$controls_ui$parameters_tab_$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__,spec_path,spec,vec__66849,sel_region,sel_layer,partypes))
})();
var state__38111__auto__ = (function (){var statearr_66881 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_66881[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_66881;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__,spec_path,spec,vec__66849,sel_region,sel_layer,partypes))
);

return c__38109__auto__;
})());
});})(spec_path,spec,vec__66849,sel_region,sel_layer,partypes))
], null),"Rebuild model"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$small,"This will not reset, or otherwise alter, the input stream."], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Current spec value"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre,[cljs.core.str(spec)].join('')], null)], null)], 0));
})():null))], null);
});
;})(partypes))
});
org.numenta.sanity.controls_ui.gather_col_state_history_BANG_ = (function org$numenta$sanity$controls_ui$gather_col_state_history_BANG_(col_state_history,step,into_journal){
var map__67151 = step;
var map__67151__$1 = ((((!((map__67151 == null)))?((((map__67151.cljs$lang$protocol_mask$partition0$ & (64))) || (map__67151.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67151):map__67151);
var snapshot_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67151__$1,cljs.core.cst$kw$snapshot_DASH_id);
var network_shape = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67151__$1,cljs.core.cst$kw$network_DASH_shape);
var timestep = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67151__$1,cljs.core.cst$kw$timestep);
var fetches = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, ["n-unpredicted-active-columns",null,"n-predicted-inactive-columns",null,"n-predicted-active-columns",null], null), null);
var seq__67153 = cljs.core.seq(cljs.core.cst$kw$regions.cljs$core$IFn$_invoke$arity$1(network_shape));
var chunk__67160 = null;
var count__67161 = (0);
var i__67162 = (0);
while(true){
if((i__67162 < count__67161)){
var vec__67169 = chunk__67160.cljs$core$IIndexed$_nth$arity$2(null,i__67162);
var rgn_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67169,(0),null);
var rgn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67169,(1),null);
var seq__67163_67399 = cljs.core.seq(rgn);
var chunk__67165_67400 = null;
var count__67166_67401 = (0);
var i__67167_67402 = (0);
while(true){
if((i__67167_67402 < count__67166_67401)){
var vec__67170_67403 = chunk__67165_67400.cljs$core$IIndexed$_nth$arity$2(null,i__67167_67402);
var lyr_id_67404 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67170_67403,(0),null);
var lyr_67405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67170_67403,(1),null);
var response_c_67406 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["get-layer-stats",snapshot_id,rgn_id,lyr_id_67404,fetches,org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c_67406,true)], null));

var c__38109__auto___67407 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67407,response_c_67406,vec__67170_67403,lyr_id_67404,lyr_67405,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67407,response_c_67406,vec__67170_67403,lyr_id_67404,lyr_67405,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (state_67205){
var state_val_67206 = (state_67205[(1)]);
if((state_val_67206 === (7))){
var state_67205__$1 = state_67205;
var statearr_67207_67408 = state_67205__$1;
(statearr_67207_67408[(2)] = false);

(statearr_67207_67408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67206 === (1))){
var state_67205__$1 = state_67205;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67205__$1,(2),response_c_67406);
} else {
if((state_val_67206 === (4))){
var state_67205__$1 = state_67205;
var statearr_67208_67409 = state_67205__$1;
(statearr_67208_67409[(2)] = false);

(statearr_67208_67409[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67206 === (6))){
var state_67205__$1 = state_67205;
var statearr_67209_67410 = state_67205__$1;
(statearr_67209_67410[(2)] = true);

(statearr_67209_67410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67206 === (3))){
var inst_67173 = (state_67205[(7)]);
var inst_67178 = inst_67173.cljs$lang$protocol_mask$partition0$;
var inst_67179 = (inst_67178 & (64));
var inst_67180 = inst_67173.cljs$core$ISeq$;
var inst_67181 = (inst_67179) || (inst_67180);
var state_67205__$1 = state_67205;
if(cljs.core.truth_(inst_67181)){
var statearr_67210_67411 = state_67205__$1;
(statearr_67210_67411[(1)] = (6));

} else {
var statearr_67211_67412 = state_67205__$1;
(statearr_67211_67412[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67206 === (2))){
var inst_67173 = (state_67205[(7)]);
var inst_67173__$1 = (state_67205[(2)]);
var inst_67175 = (inst_67173__$1 == null);
var inst_67176 = cljs.core.not(inst_67175);
var state_67205__$1 = (function (){var statearr_67212 = state_67205;
(statearr_67212[(7)] = inst_67173__$1);

return statearr_67212;
})();
if(inst_67176){
var statearr_67213_67413 = state_67205__$1;
(statearr_67213_67413[(1)] = (3));

} else {
var statearr_67214_67414 = state_67205__$1;
(statearr_67214_67414[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67206 === (11))){
var inst_67173 = (state_67205[(7)]);
var inst_67193 = (state_67205[(2)]);
var inst_67194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67193,"n-unpredicted-active-columns");
var inst_67195 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67193,"n-predicted-inactive-columns");
var inst_67196 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67193,"n-predicted-active-columns");
var inst_67197 = cljs.core.cst$kw$dimensions.cljs$core$IFn$_invoke$arity$1(lyr_67405);
var inst_67198 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,inst_67197);
var inst_67199 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67200 = [rgn_id,lyr_id_67404];
var inst_67201 = (new cljs.core.PersistentVector(null,2,(5),inst_67199,inst_67200,null));
var inst_67202 = (function (){var r = inst_67173;
var map__67171 = inst_67193;
var active = inst_67194;
var predicted = inst_67195;
var active_predicted = inst_67196;
var size = inst_67198;
return ((function (seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,r,map__67171,active,predicted,active_predicted,size,inst_67173,inst_67193,inst_67194,inst_67195,inst_67196,inst_67197,inst_67198,inst_67199,inst_67200,inst_67201,state_val_67206,c__38109__auto___67407,response_c_67406,vec__67170_67403,lyr_id_67404,lyr_67405,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (csf_log){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6153__auto__ = csf_log;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return org.numenta.sanity.plots.empty_col_state_freqs_log();
}
})(),new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$active,active,cljs.core.cst$kw$predicted,predicted,cljs.core.cst$kw$active_DASH_predicted,active_predicted,cljs.core.cst$kw$timestep,timestep,cljs.core.cst$kw$size,size], null));
});
;})(seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,r,map__67171,active,predicted,active_predicted,size,inst_67173,inst_67193,inst_67194,inst_67195,inst_67196,inst_67197,inst_67198,inst_67199,inst_67200,inst_67201,state_val_67206,c__38109__auto___67407,response_c_67406,vec__67170_67403,lyr_id_67404,lyr_67405,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
})();
var inst_67203 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(col_state_history,cljs.core.update_in,inst_67201,inst_67202);
var state_67205__$1 = state_67205;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67205__$1,inst_67203);
} else {
if((state_val_67206 === (9))){
var inst_67173 = (state_67205[(7)]);
var inst_67190 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_67173);
var state_67205__$1 = state_67205;
var statearr_67215_67415 = state_67205__$1;
(statearr_67215_67415[(2)] = inst_67190);

(statearr_67215_67415[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67206 === (5))){
var inst_67188 = (state_67205[(2)]);
var state_67205__$1 = state_67205;
if(cljs.core.truth_(inst_67188)){
var statearr_67216_67416 = state_67205__$1;
(statearr_67216_67416[(1)] = (9));

} else {
var statearr_67217_67417 = state_67205__$1;
(statearr_67217_67417[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67206 === (10))){
var inst_67173 = (state_67205[(7)]);
var state_67205__$1 = state_67205;
var statearr_67218_67418 = state_67205__$1;
(statearr_67218_67418[(2)] = inst_67173);

(statearr_67218_67418[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67206 === (8))){
var inst_67185 = (state_67205[(2)]);
var state_67205__$1 = state_67205;
var statearr_67219_67419 = state_67205__$1;
(statearr_67219_67419[(2)] = inst_67185);

(statearr_67219_67419[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67407,response_c_67406,vec__67170_67403,lyr_id_67404,lyr_67405,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
;
return ((function (seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,switch__37995__auto__,c__38109__auto___67407,response_c_67406,vec__67170_67403,lyr_id_67404,lyr_67405,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function() {
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__ = null;
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0 = (function (){
var statearr_67223 = [null,null,null,null,null,null,null,null];
(statearr_67223[(0)] = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__);

(statearr_67223[(1)] = (1));

return statearr_67223;
});
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1 = (function (state_67205){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_67205);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e67224){if((e67224 instanceof Object)){
var ex__37999__auto__ = e67224;
var statearr_67225_67420 = state_67205;
(statearr_67225_67420[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_67205);

return cljs.core.cst$kw$recur;
} else {
throw e67224;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__67421 = state_67205;
state_67205 = G__67421;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__ = function(state_67205){
switch(arguments.length){
case 0:
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1.call(this,state_67205);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0;
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1;
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__;
})()
;})(seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,switch__37995__auto__,c__38109__auto___67407,response_c_67406,vec__67170_67403,lyr_id_67404,lyr_67405,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
})();
var state__38111__auto__ = (function (){var statearr_67226 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_67226[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___67407);

return statearr_67226;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67407,response_c_67406,vec__67170_67403,lyr_id_67404,lyr_67405,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
);


var G__67422 = seq__67163_67399;
var G__67423 = chunk__67165_67400;
var G__67424 = count__67166_67401;
var G__67425 = (i__67167_67402 + (1));
seq__67163_67399 = G__67422;
chunk__67165_67400 = G__67423;
count__67166_67401 = G__67424;
i__67167_67402 = G__67425;
continue;
} else {
var temp__4657__auto___67426 = cljs.core.seq(seq__67163_67399);
if(temp__4657__auto___67426){
var seq__67163_67427__$1 = temp__4657__auto___67426;
if(cljs.core.chunked_seq_QMARK_(seq__67163_67427__$1)){
var c__6956__auto___67428 = cljs.core.chunk_first(seq__67163_67427__$1);
var G__67429 = cljs.core.chunk_rest(seq__67163_67427__$1);
var G__67430 = c__6956__auto___67428;
var G__67431 = cljs.core.count(c__6956__auto___67428);
var G__67432 = (0);
seq__67163_67399 = G__67429;
chunk__67165_67400 = G__67430;
count__67166_67401 = G__67431;
i__67167_67402 = G__67432;
continue;
} else {
var vec__67227_67433 = cljs.core.first(seq__67163_67427__$1);
var lyr_id_67434 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67227_67433,(0),null);
var lyr_67435 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67227_67433,(1),null);
var response_c_67436 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["get-layer-stats",snapshot_id,rgn_id,lyr_id_67434,fetches,org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c_67436,true)], null));

var c__38109__auto___67437 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67437,response_c_67436,vec__67227_67433,lyr_id_67434,lyr_67435,seq__67163_67427__$1,temp__4657__auto___67426,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67437,response_c_67436,vec__67227_67433,lyr_id_67434,lyr_67435,seq__67163_67427__$1,temp__4657__auto___67426,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (state_67262){
var state_val_67263 = (state_67262[(1)]);
if((state_val_67263 === (7))){
var state_67262__$1 = state_67262;
var statearr_67264_67438 = state_67262__$1;
(statearr_67264_67438[(2)] = false);

(statearr_67264_67438[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67263 === (1))){
var state_67262__$1 = state_67262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67262__$1,(2),response_c_67436);
} else {
if((state_val_67263 === (4))){
var state_67262__$1 = state_67262;
var statearr_67265_67439 = state_67262__$1;
(statearr_67265_67439[(2)] = false);

(statearr_67265_67439[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67263 === (6))){
var state_67262__$1 = state_67262;
var statearr_67266_67440 = state_67262__$1;
(statearr_67266_67440[(2)] = true);

(statearr_67266_67440[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67263 === (3))){
var inst_67230 = (state_67262[(7)]);
var inst_67235 = inst_67230.cljs$lang$protocol_mask$partition0$;
var inst_67236 = (inst_67235 & (64));
var inst_67237 = inst_67230.cljs$core$ISeq$;
var inst_67238 = (inst_67236) || (inst_67237);
var state_67262__$1 = state_67262;
if(cljs.core.truth_(inst_67238)){
var statearr_67267_67441 = state_67262__$1;
(statearr_67267_67441[(1)] = (6));

} else {
var statearr_67268_67442 = state_67262__$1;
(statearr_67268_67442[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67263 === (2))){
var inst_67230 = (state_67262[(7)]);
var inst_67230__$1 = (state_67262[(2)]);
var inst_67232 = (inst_67230__$1 == null);
var inst_67233 = cljs.core.not(inst_67232);
var state_67262__$1 = (function (){var statearr_67269 = state_67262;
(statearr_67269[(7)] = inst_67230__$1);

return statearr_67269;
})();
if(inst_67233){
var statearr_67270_67443 = state_67262__$1;
(statearr_67270_67443[(1)] = (3));

} else {
var statearr_67271_67444 = state_67262__$1;
(statearr_67271_67444[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67263 === (11))){
var inst_67230 = (state_67262[(7)]);
var inst_67250 = (state_67262[(2)]);
var inst_67251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67250,"n-unpredicted-active-columns");
var inst_67252 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67250,"n-predicted-inactive-columns");
var inst_67253 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67250,"n-predicted-active-columns");
var inst_67254 = cljs.core.cst$kw$dimensions.cljs$core$IFn$_invoke$arity$1(lyr_67435);
var inst_67255 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,inst_67254);
var inst_67256 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67257 = [rgn_id,lyr_id_67434];
var inst_67258 = (new cljs.core.PersistentVector(null,2,(5),inst_67256,inst_67257,null));
var inst_67259 = (function (){var r = inst_67230;
var map__67228 = inst_67250;
var active = inst_67251;
var predicted = inst_67252;
var active_predicted = inst_67253;
var size = inst_67255;
return ((function (seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,r,map__67228,active,predicted,active_predicted,size,inst_67230,inst_67250,inst_67251,inst_67252,inst_67253,inst_67254,inst_67255,inst_67256,inst_67257,inst_67258,state_val_67263,c__38109__auto___67437,response_c_67436,vec__67227_67433,lyr_id_67434,lyr_67435,seq__67163_67427__$1,temp__4657__auto___67426,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (csf_log){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6153__auto__ = csf_log;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return org.numenta.sanity.plots.empty_col_state_freqs_log();
}
})(),new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$active,active,cljs.core.cst$kw$predicted,predicted,cljs.core.cst$kw$active_DASH_predicted,active_predicted,cljs.core.cst$kw$timestep,timestep,cljs.core.cst$kw$size,size], null));
});
;})(seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,r,map__67228,active,predicted,active_predicted,size,inst_67230,inst_67250,inst_67251,inst_67252,inst_67253,inst_67254,inst_67255,inst_67256,inst_67257,inst_67258,state_val_67263,c__38109__auto___67437,response_c_67436,vec__67227_67433,lyr_id_67434,lyr_67435,seq__67163_67427__$1,temp__4657__auto___67426,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
})();
var inst_67260 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(col_state_history,cljs.core.update_in,inst_67258,inst_67259);
var state_67262__$1 = state_67262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67262__$1,inst_67260);
} else {
if((state_val_67263 === (9))){
var inst_67230 = (state_67262[(7)]);
var inst_67247 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_67230);
var state_67262__$1 = state_67262;
var statearr_67272_67445 = state_67262__$1;
(statearr_67272_67445[(2)] = inst_67247);

(statearr_67272_67445[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67263 === (5))){
var inst_67245 = (state_67262[(2)]);
var state_67262__$1 = state_67262;
if(cljs.core.truth_(inst_67245)){
var statearr_67273_67446 = state_67262__$1;
(statearr_67273_67446[(1)] = (9));

} else {
var statearr_67274_67447 = state_67262__$1;
(statearr_67274_67447[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67263 === (10))){
var inst_67230 = (state_67262[(7)]);
var state_67262__$1 = state_67262;
var statearr_67275_67448 = state_67262__$1;
(statearr_67275_67448[(2)] = inst_67230);

(statearr_67275_67448[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67263 === (8))){
var inst_67242 = (state_67262[(2)]);
var state_67262__$1 = state_67262;
var statearr_67276_67449 = state_67262__$1;
(statearr_67276_67449[(2)] = inst_67242);

(statearr_67276_67449[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67437,response_c_67436,vec__67227_67433,lyr_id_67434,lyr_67435,seq__67163_67427__$1,temp__4657__auto___67426,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
;
return ((function (seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,switch__37995__auto__,c__38109__auto___67437,response_c_67436,vec__67227_67433,lyr_id_67434,lyr_67435,seq__67163_67427__$1,temp__4657__auto___67426,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function() {
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__ = null;
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0 = (function (){
var statearr_67280 = [null,null,null,null,null,null,null,null];
(statearr_67280[(0)] = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__);

(statearr_67280[(1)] = (1));

return statearr_67280;
});
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1 = (function (state_67262){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_67262);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e67281){if((e67281 instanceof Object)){
var ex__37999__auto__ = e67281;
var statearr_67282_67450 = state_67262;
(statearr_67282_67450[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_67262);

return cljs.core.cst$kw$recur;
} else {
throw e67281;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__67451 = state_67262;
state_67262 = G__67451;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__ = function(state_67262){
switch(arguments.length){
case 0:
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1.call(this,state_67262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0;
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1;
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__;
})()
;})(seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,switch__37995__auto__,c__38109__auto___67437,response_c_67436,vec__67227_67433,lyr_id_67434,lyr_67435,seq__67163_67427__$1,temp__4657__auto___67426,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
})();
var state__38111__auto__ = (function (){var statearr_67283 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_67283[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___67437);

return statearr_67283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(seq__67163_67399,chunk__67165_67400,count__67166_67401,i__67167_67402,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67437,response_c_67436,vec__67227_67433,lyr_id_67434,lyr_67435,seq__67163_67427__$1,temp__4657__auto___67426,vec__67169,rgn_id,rgn,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
);


var G__67452 = cljs.core.next(seq__67163_67427__$1);
var G__67453 = null;
var G__67454 = (0);
var G__67455 = (0);
seq__67163_67399 = G__67452;
chunk__67165_67400 = G__67453;
count__67166_67401 = G__67454;
i__67167_67402 = G__67455;
continue;
}
} else {
}
}
break;
}

var G__67456 = seq__67153;
var G__67457 = chunk__67160;
var G__67458 = count__67161;
var G__67459 = (i__67162 + (1));
seq__67153 = G__67456;
chunk__67160 = G__67457;
count__67161 = G__67458;
i__67162 = G__67459;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__67153);
if(temp__4657__auto__){
var seq__67153__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__67153__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__67153__$1);
var G__67460 = cljs.core.chunk_rest(seq__67153__$1);
var G__67461 = c__6956__auto__;
var G__67462 = cljs.core.count(c__6956__auto__);
var G__67463 = (0);
seq__67153 = G__67460;
chunk__67160 = G__67461;
count__67161 = G__67462;
i__67162 = G__67463;
continue;
} else {
var vec__67284 = cljs.core.first(seq__67153__$1);
var rgn_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67284,(0),null);
var rgn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67284,(1),null);
var seq__67154_67464 = cljs.core.seq(rgn);
var chunk__67156_67465 = null;
var count__67157_67466 = (0);
var i__67158_67467 = (0);
while(true){
if((i__67158_67467 < count__67157_67466)){
var vec__67285_67468 = chunk__67156_67465.cljs$core$IIndexed$_nth$arity$2(null,i__67158_67467);
var lyr_id_67469 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67285_67468,(0),null);
var lyr_67470 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67285_67468,(1),null);
var response_c_67471 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["get-layer-stats",snapshot_id,rgn_id,lyr_id_67469,fetches,org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c_67471,true)], null));

var c__38109__auto___67472 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67472,response_c_67471,vec__67285_67468,lyr_id_67469,lyr_67470,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67472,response_c_67471,vec__67285_67468,lyr_id_67469,lyr_67470,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (state_67320){
var state_val_67321 = (state_67320[(1)]);
if((state_val_67321 === (7))){
var state_67320__$1 = state_67320;
var statearr_67322_67473 = state_67320__$1;
(statearr_67322_67473[(2)] = false);

(statearr_67322_67473[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67321 === (1))){
var state_67320__$1 = state_67320;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67320__$1,(2),response_c_67471);
} else {
if((state_val_67321 === (4))){
var state_67320__$1 = state_67320;
var statearr_67323_67474 = state_67320__$1;
(statearr_67323_67474[(2)] = false);

(statearr_67323_67474[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67321 === (6))){
var state_67320__$1 = state_67320;
var statearr_67324_67475 = state_67320__$1;
(statearr_67324_67475[(2)] = true);

(statearr_67324_67475[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67321 === (3))){
var inst_67288 = (state_67320[(7)]);
var inst_67293 = inst_67288.cljs$lang$protocol_mask$partition0$;
var inst_67294 = (inst_67293 & (64));
var inst_67295 = inst_67288.cljs$core$ISeq$;
var inst_67296 = (inst_67294) || (inst_67295);
var state_67320__$1 = state_67320;
if(cljs.core.truth_(inst_67296)){
var statearr_67325_67476 = state_67320__$1;
(statearr_67325_67476[(1)] = (6));

} else {
var statearr_67326_67477 = state_67320__$1;
(statearr_67326_67477[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67321 === (2))){
var inst_67288 = (state_67320[(7)]);
var inst_67288__$1 = (state_67320[(2)]);
var inst_67290 = (inst_67288__$1 == null);
var inst_67291 = cljs.core.not(inst_67290);
var state_67320__$1 = (function (){var statearr_67327 = state_67320;
(statearr_67327[(7)] = inst_67288__$1);

return statearr_67327;
})();
if(inst_67291){
var statearr_67328_67478 = state_67320__$1;
(statearr_67328_67478[(1)] = (3));

} else {
var statearr_67329_67479 = state_67320__$1;
(statearr_67329_67479[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67321 === (11))){
var inst_67288 = (state_67320[(7)]);
var inst_67308 = (state_67320[(2)]);
var inst_67309 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67308,"n-unpredicted-active-columns");
var inst_67310 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67308,"n-predicted-inactive-columns");
var inst_67311 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67308,"n-predicted-active-columns");
var inst_67312 = cljs.core.cst$kw$dimensions.cljs$core$IFn$_invoke$arity$1(lyr_67470);
var inst_67313 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,inst_67312);
var inst_67314 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67315 = [rgn_id,lyr_id_67469];
var inst_67316 = (new cljs.core.PersistentVector(null,2,(5),inst_67314,inst_67315,null));
var inst_67317 = (function (){var r = inst_67288;
var map__67286 = inst_67308;
var active = inst_67309;
var predicted = inst_67310;
var active_predicted = inst_67311;
var size = inst_67313;
return ((function (seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,r,map__67286,active,predicted,active_predicted,size,inst_67288,inst_67308,inst_67309,inst_67310,inst_67311,inst_67312,inst_67313,inst_67314,inst_67315,inst_67316,state_val_67321,c__38109__auto___67472,response_c_67471,vec__67285_67468,lyr_id_67469,lyr_67470,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (csf_log){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6153__auto__ = csf_log;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return org.numenta.sanity.plots.empty_col_state_freqs_log();
}
})(),new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$active,active,cljs.core.cst$kw$predicted,predicted,cljs.core.cst$kw$active_DASH_predicted,active_predicted,cljs.core.cst$kw$timestep,timestep,cljs.core.cst$kw$size,size], null));
});
;})(seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,r,map__67286,active,predicted,active_predicted,size,inst_67288,inst_67308,inst_67309,inst_67310,inst_67311,inst_67312,inst_67313,inst_67314,inst_67315,inst_67316,state_val_67321,c__38109__auto___67472,response_c_67471,vec__67285_67468,lyr_id_67469,lyr_67470,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
})();
var inst_67318 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(col_state_history,cljs.core.update_in,inst_67316,inst_67317);
var state_67320__$1 = state_67320;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67320__$1,inst_67318);
} else {
if((state_val_67321 === (9))){
var inst_67288 = (state_67320[(7)]);
var inst_67305 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_67288);
var state_67320__$1 = state_67320;
var statearr_67330_67480 = state_67320__$1;
(statearr_67330_67480[(2)] = inst_67305);

(statearr_67330_67480[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67321 === (5))){
var inst_67303 = (state_67320[(2)]);
var state_67320__$1 = state_67320;
if(cljs.core.truth_(inst_67303)){
var statearr_67331_67481 = state_67320__$1;
(statearr_67331_67481[(1)] = (9));

} else {
var statearr_67332_67482 = state_67320__$1;
(statearr_67332_67482[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67321 === (10))){
var inst_67288 = (state_67320[(7)]);
var state_67320__$1 = state_67320;
var statearr_67333_67483 = state_67320__$1;
(statearr_67333_67483[(2)] = inst_67288);

(statearr_67333_67483[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67321 === (8))){
var inst_67300 = (state_67320[(2)]);
var state_67320__$1 = state_67320;
var statearr_67334_67484 = state_67320__$1;
(statearr_67334_67484[(2)] = inst_67300);

(statearr_67334_67484[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67472,response_c_67471,vec__67285_67468,lyr_id_67469,lyr_67470,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
;
return ((function (seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,switch__37995__auto__,c__38109__auto___67472,response_c_67471,vec__67285_67468,lyr_id_67469,lyr_67470,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function() {
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__ = null;
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0 = (function (){
var statearr_67338 = [null,null,null,null,null,null,null,null];
(statearr_67338[(0)] = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__);

(statearr_67338[(1)] = (1));

return statearr_67338;
});
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1 = (function (state_67320){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_67320);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e67339){if((e67339 instanceof Object)){
var ex__37999__auto__ = e67339;
var statearr_67340_67485 = state_67320;
(statearr_67340_67485[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_67320);

return cljs.core.cst$kw$recur;
} else {
throw e67339;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__67486 = state_67320;
state_67320 = G__67486;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__ = function(state_67320){
switch(arguments.length){
case 0:
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1.call(this,state_67320);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0;
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1;
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__;
})()
;})(seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,switch__37995__auto__,c__38109__auto___67472,response_c_67471,vec__67285_67468,lyr_id_67469,lyr_67470,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
})();
var state__38111__auto__ = (function (){var statearr_67341 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_67341[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___67472);

return statearr_67341;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67472,response_c_67471,vec__67285_67468,lyr_id_67469,lyr_67470,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
);


var G__67487 = seq__67154_67464;
var G__67488 = chunk__67156_67465;
var G__67489 = count__67157_67466;
var G__67490 = (i__67158_67467 + (1));
seq__67154_67464 = G__67487;
chunk__67156_67465 = G__67488;
count__67157_67466 = G__67489;
i__67158_67467 = G__67490;
continue;
} else {
var temp__4657__auto___67491__$1 = cljs.core.seq(seq__67154_67464);
if(temp__4657__auto___67491__$1){
var seq__67154_67492__$1 = temp__4657__auto___67491__$1;
if(cljs.core.chunked_seq_QMARK_(seq__67154_67492__$1)){
var c__6956__auto___67493 = cljs.core.chunk_first(seq__67154_67492__$1);
var G__67494 = cljs.core.chunk_rest(seq__67154_67492__$1);
var G__67495 = c__6956__auto___67493;
var G__67496 = cljs.core.count(c__6956__auto___67493);
var G__67497 = (0);
seq__67154_67464 = G__67494;
chunk__67156_67465 = G__67495;
count__67157_67466 = G__67496;
i__67158_67467 = G__67497;
continue;
} else {
var vec__67342_67498 = cljs.core.first(seq__67154_67492__$1);
var lyr_id_67499 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67342_67498,(0),null);
var lyr_67500 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67342_67498,(1),null);
var response_c_67501 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["get-layer-stats",snapshot_id,rgn_id,lyr_id_67499,fetches,org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c_67501,true)], null));

var c__38109__auto___67502 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67502,response_c_67501,vec__67342_67498,lyr_id_67499,lyr_67500,seq__67154_67492__$1,temp__4657__auto___67491__$1,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67502,response_c_67501,vec__67342_67498,lyr_id_67499,lyr_67500,seq__67154_67492__$1,temp__4657__auto___67491__$1,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (state_67377){
var state_val_67378 = (state_67377[(1)]);
if((state_val_67378 === (7))){
var state_67377__$1 = state_67377;
var statearr_67379_67503 = state_67377__$1;
(statearr_67379_67503[(2)] = false);

(statearr_67379_67503[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67378 === (1))){
var state_67377__$1 = state_67377;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67377__$1,(2),response_c_67501);
} else {
if((state_val_67378 === (4))){
var state_67377__$1 = state_67377;
var statearr_67380_67504 = state_67377__$1;
(statearr_67380_67504[(2)] = false);

(statearr_67380_67504[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67378 === (6))){
var state_67377__$1 = state_67377;
var statearr_67381_67505 = state_67377__$1;
(statearr_67381_67505[(2)] = true);

(statearr_67381_67505[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67378 === (3))){
var inst_67345 = (state_67377[(7)]);
var inst_67350 = inst_67345.cljs$lang$protocol_mask$partition0$;
var inst_67351 = (inst_67350 & (64));
var inst_67352 = inst_67345.cljs$core$ISeq$;
var inst_67353 = (inst_67351) || (inst_67352);
var state_67377__$1 = state_67377;
if(cljs.core.truth_(inst_67353)){
var statearr_67382_67506 = state_67377__$1;
(statearr_67382_67506[(1)] = (6));

} else {
var statearr_67383_67507 = state_67377__$1;
(statearr_67383_67507[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67378 === (2))){
var inst_67345 = (state_67377[(7)]);
var inst_67345__$1 = (state_67377[(2)]);
var inst_67347 = (inst_67345__$1 == null);
var inst_67348 = cljs.core.not(inst_67347);
var state_67377__$1 = (function (){var statearr_67384 = state_67377;
(statearr_67384[(7)] = inst_67345__$1);

return statearr_67384;
})();
if(inst_67348){
var statearr_67385_67508 = state_67377__$1;
(statearr_67385_67508[(1)] = (3));

} else {
var statearr_67386_67509 = state_67377__$1;
(statearr_67386_67509[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67378 === (11))){
var inst_67345 = (state_67377[(7)]);
var inst_67365 = (state_67377[(2)]);
var inst_67366 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67365,"n-unpredicted-active-columns");
var inst_67367 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67365,"n-predicted-inactive-columns");
var inst_67368 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_67365,"n-predicted-active-columns");
var inst_67369 = cljs.core.cst$kw$dimensions.cljs$core$IFn$_invoke$arity$1(lyr_67500);
var inst_67370 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,inst_67369);
var inst_67371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67372 = [rgn_id,lyr_id_67499];
var inst_67373 = (new cljs.core.PersistentVector(null,2,(5),inst_67371,inst_67372,null));
var inst_67374 = (function (){var r = inst_67345;
var map__67343 = inst_67365;
var active = inst_67366;
var predicted = inst_67367;
var active_predicted = inst_67368;
var size = inst_67370;
return ((function (seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,r,map__67343,active,predicted,active_predicted,size,inst_67345,inst_67365,inst_67366,inst_67367,inst_67368,inst_67369,inst_67370,inst_67371,inst_67372,inst_67373,state_val_67378,c__38109__auto___67502,response_c_67501,vec__67342_67498,lyr_id_67499,lyr_67500,seq__67154_67492__$1,temp__4657__auto___67491__$1,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function (csf_log){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__6153__auto__ = csf_log;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return org.numenta.sanity.plots.empty_col_state_freqs_log();
}
})(),new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$active,active,cljs.core.cst$kw$predicted,predicted,cljs.core.cst$kw$active_DASH_predicted,active_predicted,cljs.core.cst$kw$timestep,timestep,cljs.core.cst$kw$size,size], null));
});
;})(seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,r,map__67343,active,predicted,active_predicted,size,inst_67345,inst_67365,inst_67366,inst_67367,inst_67368,inst_67369,inst_67370,inst_67371,inst_67372,inst_67373,state_val_67378,c__38109__auto___67502,response_c_67501,vec__67342_67498,lyr_id_67499,lyr_67500,seq__67154_67492__$1,temp__4657__auto___67491__$1,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
})();
var inst_67375 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(col_state_history,cljs.core.update_in,inst_67373,inst_67374);
var state_67377__$1 = state_67377;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67377__$1,inst_67375);
} else {
if((state_val_67378 === (9))){
var inst_67345 = (state_67377[(7)]);
var inst_67362 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_67345);
var state_67377__$1 = state_67377;
var statearr_67387_67510 = state_67377__$1;
(statearr_67387_67510[(2)] = inst_67362);

(statearr_67387_67510[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67378 === (5))){
var inst_67360 = (state_67377[(2)]);
var state_67377__$1 = state_67377;
if(cljs.core.truth_(inst_67360)){
var statearr_67388_67511 = state_67377__$1;
(statearr_67388_67511[(1)] = (9));

} else {
var statearr_67389_67512 = state_67377__$1;
(statearr_67389_67512[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67378 === (10))){
var inst_67345 = (state_67377[(7)]);
var state_67377__$1 = state_67377;
var statearr_67390_67513 = state_67377__$1;
(statearr_67390_67513[(2)] = inst_67345);

(statearr_67390_67513[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67378 === (8))){
var inst_67357 = (state_67377[(2)]);
var state_67377__$1 = state_67377;
var statearr_67391_67514 = state_67377__$1;
(statearr_67391_67514[(2)] = inst_67357);

(statearr_67391_67514[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67502,response_c_67501,vec__67342_67498,lyr_id_67499,lyr_67500,seq__67154_67492__$1,temp__4657__auto___67491__$1,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
;
return ((function (seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,switch__37995__auto__,c__38109__auto___67502,response_c_67501,vec__67342_67498,lyr_id_67499,lyr_67500,seq__67154_67492__$1,temp__4657__auto___67491__$1,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches){
return (function() {
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__ = null;
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0 = (function (){
var statearr_67395 = [null,null,null,null,null,null,null,null];
(statearr_67395[(0)] = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__);

(statearr_67395[(1)] = (1));

return statearr_67395;
});
var org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1 = (function (state_67377){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_67377);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e67396){if((e67396 instanceof Object)){
var ex__37999__auto__ = e67396;
var statearr_67397_67515 = state_67377;
(statearr_67397_67515[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_67377);

return cljs.core.cst$kw$recur;
} else {
throw e67396;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__67516 = state_67377;
state_67377 = G__67516;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__ = function(state_67377){
switch(arguments.length){
case 0:
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1.call(this,state_67377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____0;
org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto____1;
return org$numenta$sanity$controls_ui$gather_col_state_history_BANG__$_state_machine__37996__auto__;
})()
;})(seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,switch__37995__auto__,c__38109__auto___67502,response_c_67501,vec__67342_67498,lyr_id_67499,lyr_67500,seq__67154_67492__$1,temp__4657__auto___67491__$1,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
})();
var state__38111__auto__ = (function (){var statearr_67398 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_67398[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___67502);

return statearr_67398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(seq__67154_67464,chunk__67156_67465,count__67157_67466,i__67158_67467,seq__67153,chunk__67160,count__67161,i__67162,c__38109__auto___67502,response_c_67501,vec__67342_67498,lyr_id_67499,lyr_67500,seq__67154_67492__$1,temp__4657__auto___67491__$1,vec__67284,rgn_id,rgn,seq__67153__$1,temp__4657__auto__,map__67151,map__67151__$1,snapshot_id,network_shape,timestep,fetches))
);


var G__67517 = cljs.core.next(seq__67154_67492__$1);
var G__67518 = null;
var G__67519 = (0);
var G__67520 = (0);
seq__67154_67464 = G__67517;
chunk__67156_67465 = G__67518;
count__67157_67466 = G__67519;
i__67158_67467 = G__67520;
continue;
}
} else {
}
}
break;
}

var G__67521 = cljs.core.next(seq__67153__$1);
var G__67522 = null;
var G__67523 = (0);
var G__67524 = (0);
seq__67153 = G__67521;
chunk__67160 = G__67522;
count__67161 = G__67523;
i__67162 = G__67524;
continue;
}
} else {
return null;
}
}
break;
}
});
org.numenta.sanity.controls_ui.time_plots_tab_builder = (function org$numenta$sanity$controls_ui$time_plots_tab_builder(steps,into_journal){
var col_state_history = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
cljs.core.add_watch(steps,cljs.core.cst$kw$org$numenta$sanity$controls_DASH_ui_SLASH_ts_DASH_plot_DASH_data,((function (col_state_history){
return (function (_,___$1,___$2,xs){
return org.numenta.sanity.controls_ui.gather_col_state_history_BANG_(col_state_history,cljs.core.first(xs),into_journal);
});})(col_state_history))
);

return ((function (col_state_history){
return (function org$numenta$sanity$controls_ui$time_plots_tab_builder_$_time_plots_tab(series_colors){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,"Time series of cortical column activity."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(function (){var iter__6925__auto__ = ((function (col_state_history){
return (function org$numenta$sanity$controls_ui$time_plots_tab_builder_$_time_plots_tab_$_iter__67588(s__67589){
return (new cljs.core.LazySeq(null,((function (col_state_history){
return (function (){
var s__67589__$1 = s__67589;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__67589__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var vec__67602 = cljs.core.first(xs__5205__auto__);
var rgn_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67602,(0),null);
var rgn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67602,(1),null);
var iterys__6921__auto__ = ((function (s__67589__$1,vec__67602,rgn_id,rgn,xs__5205__auto__,temp__4657__auto__,col_state_history){
return (function org$numenta$sanity$controls_ui$time_plots_tab_builder_$_time_plots_tab_$_iter__67588_$_iter__67590(s__67591){
return (new cljs.core.LazySeq(null,((function (s__67589__$1,vec__67602,rgn_id,rgn,xs__5205__auto__,temp__4657__auto__,col_state_history){
return (function (){
var s__67591__$1 = s__67591;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__67591__$1);
if(temp__4657__auto____$1){
var s__67591__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__67591__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__67591__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__67593 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__67592 = (0);
while(true){
if((i__67592 < size__6924__auto__)){
var vec__67607 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__67592);
var lyr_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67607,(0),null);
var csf_log = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67607,(1),null);
cljs.core.chunk_append(b__67593,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fieldset,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$legend,[cljs.core.str(cljs.core.name(rgn_id)),cljs.core.str(" "),cljs.core.str(cljs.core.name(lyr_id))].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.plots.ts_freqs_plot_cmp,csf_log,series_colors], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id,lyr_id], null)], null)));

var G__67609 = (i__67592 + (1));
i__67592 = G__67609;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__67593),org$numenta$sanity$controls_ui$time_plots_tab_builder_$_time_plots_tab_$_iter__67588_$_iter__67590(cljs.core.chunk_rest(s__67591__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__67593),null);
}
} else {
var vec__67608 = cljs.core.first(s__67591__$2);
var lyr_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67608,(0),null);
var csf_log = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67608,(1),null);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fieldset,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$legend,[cljs.core.str(cljs.core.name(rgn_id)),cljs.core.str(" "),cljs.core.str(cljs.core.name(lyr_id))].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.plots.ts_freqs_plot_cmp,csf_log,series_colors], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rgn_id,lyr_id], null)], null)),org$numenta$sanity$controls_ui$time_plots_tab_builder_$_time_plots_tab_$_iter__67588_$_iter__67590(cljs.core.rest(s__67591__$2)));
}
} else {
return null;
}
break;
}
});})(s__67589__$1,vec__67602,rgn_id,rgn,xs__5205__auto__,temp__4657__auto__,col_state_history))
,null,null));
});})(s__67589__$1,vec__67602,rgn_id,rgn,xs__5205__auto__,temp__4657__auto__,col_state_history))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(rgn));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$numenta$sanity$controls_ui$time_plots_tab_builder_$_time_plots_tab_$_iter__67588(cljs.core.rest(s__67589__$1)));
} else {
var G__67610 = cljs.core.rest(s__67589__$1);
s__67589__$1 = G__67610;
continue;
}
} else {
return null;
}
break;
}
});})(col_state_history))
,null,null));
});})(col_state_history))
;
return iter__6925__auto__((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(col_state_history) : cljs.core.deref.call(null,col_state_history)));
})()], null)], null);
});
;})(col_state_history))
});
org.numenta.sanity.controls_ui.sources_tab = (function org$numenta$sanity$controls_ui$sources_tab(network_shape,selection,series_colors,into_journal){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,"Plots of cell excitation broken down by source."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape)))?(function (){var iter__6925__auto__ = (function org$numenta$sanity$controls_ui$sources_tab_$_iter__67624(s__67625){
return (new cljs.core.LazySeq(null,(function (){
var s__67625__$1 = s__67625;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__67625__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var vec__67634 = cljs.core.first(xs__5205__auto__);
var region_key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67634,(0),null);
var rgn = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67634,(1),null);
var iterys__6921__auto__ = ((function (s__67625__$1,vec__67634,region_key,rgn,xs__5205__auto__,temp__4657__auto__){
return (function org$numenta$sanity$controls_ui$sources_tab_$_iter__67624_$_iter__67626(s__67627){
return (new cljs.core.LazySeq(null,((function (s__67625__$1,vec__67634,region_key,rgn,xs__5205__auto__,temp__4657__auto__){
return (function (){
var s__67627__$1 = s__67627;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__67627__$1);
if(temp__4657__auto____$1){
var s__67627__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__67627__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__67627__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__67629 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__67628 = (0);
while(true){
if((i__67628 < size__6924__auto__)){
var layer_id = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__67628);
cljs.core.chunk_append(b__67629,cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fieldset,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$legend,[cljs.core.str(cljs.core.name(region_key)),cljs.core.str(" "),cljs.core.str(cljs.core.name(layer_id))].join('')], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.plots.cell_excitation_plot_cmp,network_shape,selection,series_colors,region_key,layer_id,into_journal], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [region_key,layer_id], null)], null)));

var G__67637 = (i__67628 + (1));
i__67628 = G__67637;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__67629),org$numenta$sanity$controls_ui$sources_tab_$_iter__67624_$_iter__67626(cljs.core.chunk_rest(s__67627__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__67629),null);
}
} else {
var layer_id = cljs.core.first(s__67627__$2);
return cljs.core.cons(cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$fieldset,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$legend,[cljs.core.str(cljs.core.name(region_key)),cljs.core.str(" "),cljs.core.str(cljs.core.name(layer_id))].join('')], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.plots.cell_excitation_plot_cmp,network_shape,selection,series_colors,region_key,layer_id,into_journal], null)], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [region_key,layer_id], null)], null)),org$numenta$sanity$controls_ui$sources_tab_$_iter__67624_$_iter__67626(cljs.core.rest(s__67627__$2)));
}
} else {
return null;
}
break;
}
});})(s__67625__$1,vec__67634,region_key,rgn,xs__5205__auto__,temp__4657__auto__))
,null,null));
});})(s__67625__$1,vec__67634,region_key,rgn,xs__5205__auto__,temp__4657__auto__))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(cljs.core.keys(rgn)));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$numenta$sanity$controls_ui$sources_tab_$_iter__67624(cljs.core.rest(s__67625__$1)));
} else {
var G__67638 = cljs.core.rest(s__67625__$1);
s__67625__$1 = G__67638;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6925__auto__(cljs.core.cst$kw$regions.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape))));
})():null)], null)], null);
});
org.numenta.sanity.controls_ui.default_cell_sdrs_plot_options = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$group_DASH_contexts_QMARK_,false,cljs.core.cst$kw$spreading_DASH_activation_DASH_steps,(0),cljs.core.cst$kw$ordering,cljs.core.cst$kw$first_DASH_appearance,cljs.core.cst$kw$hide_DASH_states_DASH_older,(100),cljs.core.cst$kw$hide_DASH_states_DASH_rarer,(1),cljs.core.cst$kw$hide_DASH_conns_DASH_smaller,(5)], null);
org.numenta.sanity.controls_ui.cell_sdrs_plot_dt_limit = (300);
org.numenta.sanity.controls_ui.cell_sdrs_plot_options_template = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$small,"Group contexts?"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$id,cljs.core.cst$kw$group_DASH_contexts_QMARK_], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$small," (column-level SDRs)"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$small,"Order by"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select$form_DASH_control$input_DASH_sm,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$list,cljs.core.cst$kw$id,cljs.core.cst$kw$ordering], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$first_DASH_appearance], null),"first appearance"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$last_DASH_appearance], null),"last appearance"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$small,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$field,cljs.core.cst$kw$label,cljs.core.cst$kw$id,cljs.core.cst$kw$hide_DASH_states_DASH_older,cljs.core.cst$kw$preamble,goog.string.unescapeEntities("Seen &le; "),cljs.core.cst$kw$postamble," steps ago"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$field,cljs.core.cst$kw$range,cljs.core.cst$kw$min,(5),cljs.core.cst$kw$max,org.numenta.sanity.controls_ui.cell_sdrs_plot_dt_limit,cljs.core.cst$kw$step,(5),cljs.core.cst$kw$id,cljs.core.cst$kw$hide_DASH_states_DASH_older], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$small,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$field,cljs.core.cst$kw$label,cljs.core.cst$kw$id,cljs.core.cst$kw$hide_DASH_states_DASH_rarer,cljs.core.cst$kw$preamble,goog.string.unescapeEntities("Seen &ge; "),cljs.core.cst$kw$postamble," times"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$field,cljs.core.cst$kw$range,cljs.core.cst$kw$min,(1),cljs.core.cst$kw$max,(16),cljs.core.cst$kw$id,cljs.core.cst$kw$hide_DASH_states_DASH_rarer], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$small,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$field,cljs.core.cst$kw$label,cljs.core.cst$kw$id,cljs.core.cst$kw$hide_DASH_conns_DASH_smaller,cljs.core.cst$kw$preamble,goog.string.unescapeEntities("&ge; "),cljs.core.cst$kw$postamble,"-cell connections"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$field,cljs.core.cst$kw$range,cljs.core.cst$kw$min,(1),cljs.core.cst$kw$max,(16),cljs.core.cst$kw$id,cljs.core.cst$kw$hide_DASH_conns_DASH_smaller], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$small,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$field,cljs.core.cst$kw$label,cljs.core.cst$kw$id,cljs.core.cst$kw$spreading_DASH_activation_DASH_steps,cljs.core.cst$kw$preamble,"spreading ",cljs.core.cst$kw$postamble," steps"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$field,cljs.core.cst$kw$range,cljs.core.cst$kw$min,(0),cljs.core.cst$kw$max,(12),cljs.core.cst$kw$id,cljs.core.cst$kw$spreading_DASH_activation_DASH_steps], null)], null)], null)], null)], null);
org.numenta.sanity.controls_ui.cell_sdrs_tab_builder = (function org$numenta$sanity$controls_ui$cell_sdrs_tab_builder(steps,network_shape,selection,into_journal){
var plot_opts = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(org.numenta.sanity.controls_ui.default_cell_sdrs_plot_options);
var component = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var enable_BANG_ = ((function (plot_opts,component){
return (function (){
var G__67641 = component;
var G__67642 = org.numenta.sanity.plots.cell_sdrs_plot_builder(steps,network_shape,selection,into_journal,plot_opts);
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__67641,G__67642) : cljs.core.reset_BANG_.call(null,G__67641,G__67642));
});})(plot_opts,component))
;
var disable_BANG_ = ((function (plot_opts,component,enable_BANG_){
return (function (){
var teardown_BANG__67643 = cljs.core.cst$kw$teardown.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(component) : cljs.core.deref.call(null,component)));
(teardown_BANG__67643.cljs$core$IFn$_invoke$arity$0 ? teardown_BANG__67643.cljs$core$IFn$_invoke$arity$0() : teardown_BANG__67643.call(null));

return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(component,null) : cljs.core.reset_BANG_.call(null,component,null));
});})(plot_opts,component,enable_BANG_))
;
return ((function (plot_opts,component,enable_BANG_,disable_BANG_){
return (function org$numenta$sanity$controls_ui$cell_sdrs_tab_builder_$_cell_sdrs_tab(){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,((cljs.core.not((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(component) : cljs.core.deref.call(null,component))))?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,"Cell ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$abbr,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,"Sparse Distributed Representations"], null),"SDRs"], null)," on a state transition diagram. Labels are corresponding inputs."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_primary$btn_DASH_block,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (plot_opts,component,enable_BANG_,disable_BANG_){
return (function (e){
enable_BANG_();

return e.preventDefault();
});})(plot_opts,component,enable_BANG_,disable_BANG_))
], null),"Start from selected timestep"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$small$text_DASH_warning,"So to start from the beginning, select timestep 1 first."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$small,"Not enabled by default because it can be slow."], null)], null):new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_forms.core.bind_fields,org.numenta.sanity.controls_ui.cell_sdrs_plot_options_template,plot_opts], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$content.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(component) : cljs.core.deref.call(null,component)))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_warning$btn_DASH_block,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (plot_opts,component,enable_BANG_,disable_BANG_){
return (function (e){
disable_BANG_();

return e.preventDefault();
});})(plot_opts,component,enable_BANG_,disable_BANG_))
], null),"Disable and reset"], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"This shows the dynamics of a layer of cells as a state\n        transition diagram. The \"states\" are in fact cell SDRs,\n        i.e. sets of cells active together. They are fuzzy: cells may\n        participate in multiple states. And they are evolving: the\n        membership of a state may change over time."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"To be precise, a state is defined as a set of cells\n         weighted by their specificity to that state. So if a cell\n         participates in states A and B an equal number of times, it\n         will count only half as much to A as a cell fully specific to\n         A."], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"If the active winner cells match a known state\n        sufficiently well (meeting ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$code,"seg-learn-threshold"], null),") then the state is extended to include all current\n        cells. Otherwise, a new state is created."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Input labels (key :label) are recorded on matching\n        states, but this is only for display, it is not used to define\n        states."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"The display shows one layer at one point in\n         time. Select other layers to switch the display to them. Step\n         back and forward in time as you wish."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Reading the diagram"], null),new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"States are drawn in order of appearance."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"If any of a state's cells are currently active that\n         fraction will be shaded red (whether active due to bursting\n         or not)."], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"Similarly, any predictive cells (predicting activation for the ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"next"], null)," time step) will be shaded blue."], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"If any of a state's cells are the\n         current ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i,"winner cells"], null)," that fraction will be\n         outlined in black."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"When a matching state will be extended to include new\n         cells, those are shown in green."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"Transitions are drawn as blue curves. Thickness\n         corresponds to the number of connected synapses, weighted by\n         specificity of both the source and target cells."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"The height of a state corresponds to the (weighted)\n         number of cells it represents."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"The width of a state corresponds to the number of times\n         it has matched."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"Labels are drawn with horizonal spacing by frequency."], null)], null)], null);
});
;})(plot_opts,component,enable_BANG_,disable_BANG_))
});
org.numenta.sanity.controls_ui.fetch_details_text_BANG_ = (function org$numenta$sanity$controls_ui$fetch_details_text_BANG_(into_journal,text_response,sel){
var map__67662 = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(org.numenta.sanity.selection.layer,sel));
var map__67662__$1 = ((((!((map__67662 == null)))?((((map__67662.cljs$lang$protocol_mask$partition0$ & (64))) || (map__67662.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67662):map__67662);
var sel1 = map__67662__$1;
var step = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67662__$1,cljs.core.cst$kw$step);
var bit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67662__$1,cljs.core.cst$kw$bit);
var map__67663 = step;
var map__67663__$1 = ((((!((map__67663 == null)))?((((map__67663.cljs$lang$protocol_mask$partition0$ & (64))) || (map__67663.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67663):map__67663);
var snapshot_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67663__$1,cljs.core.cst$kw$snapshot_DASH_id);
var vec__67664 = org.numenta.sanity.selection.layer(sel1);
var rgn_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67664,(0),null);
var lyr_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67664,(1),null);
if(cljs.core.truth_(lyr_id)){
var response_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["get-details-text",snapshot_id,rgn_id,lyr_id,bit,org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c,true)], null));

var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__,response_c,map__67662,map__67662__$1,sel1,step,bit,map__67663,map__67663__$1,snapshot_id,vec__67664,rgn_id,lyr_id){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__,response_c,map__67662,map__67662__$1,sel1,step,bit,map__67663,map__67663__$1,snapshot_id,vec__67664,rgn_id,lyr_id){
return (function (state_67671){
var state_val_67672 = (state_67671[(1)]);
if((state_val_67672 === (1))){
var state_67671__$1 = state_67671;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67671__$1,(2),response_c);
} else {
if((state_val_67672 === (2))){
var inst_67668 = (state_67671[(2)]);
var inst_67669 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(text_response,inst_67668) : cljs.core.reset_BANG_.call(null,text_response,inst_67668));
var state_67671__$1 = state_67671;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67671__$1,inst_67669);
} else {
return null;
}
}
});})(c__38109__auto__,response_c,map__67662,map__67662__$1,sel1,step,bit,map__67663,map__67663__$1,snapshot_id,vec__67664,rgn_id,lyr_id))
;
return ((function (switch__37995__auto__,c__38109__auto__,response_c,map__67662,map__67662__$1,sel1,step,bit,map__67663,map__67663__$1,snapshot_id,vec__67664,rgn_id,lyr_id){
return (function() {
var org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto__ = null;
var org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto____0 = (function (){
var statearr_67676 = [null,null,null,null,null,null,null];
(statearr_67676[(0)] = org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto__);

(statearr_67676[(1)] = (1));

return statearr_67676;
});
var org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto____1 = (function (state_67671){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_67671);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e67677){if((e67677 instanceof Object)){
var ex__37999__auto__ = e67677;
var statearr_67678_67680 = state_67671;
(statearr_67678_67680[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_67671);

return cljs.core.cst$kw$recur;
} else {
throw e67677;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__67681 = state_67671;
state_67671 = G__67681;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto__ = function(state_67671){
switch(arguments.length){
case 0:
return org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto____1.call(this,state_67671);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto____0;
org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto____1;
return org$numenta$sanity$controls_ui$fetch_details_text_BANG__$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__,response_c,map__67662,map__67662__$1,sel1,step,bit,map__67663,map__67663__$1,snapshot_id,vec__67664,rgn_id,lyr_id))
})();
var state__38111__auto__ = (function (){var statearr_67679 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_67679[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_67679;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__,response_c,map__67662,map__67662__$1,sel1,step,bit,map__67663,map__67663__$1,snapshot_id,vec__67664,rgn_id,lyr_id))
);

return c__38109__auto__;
} else {
return null;
}
});
org.numenta.sanity.controls_ui.details_tab = (function org$numenta$sanity$controls_ui$details_tab(selection,into_journal){
var text_response = reagent.core.atom.cljs$core$IFn$_invoke$arity$1("");
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_will_DASH_mount,((function (text_response){
return (function (_){
cljs.core.add_watch(selection,cljs.core.cst$kw$fetch_DASH_details_DASH_text,((function (text_response){
return (function (___$1,___$2,___$3,sel){
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(text_response,"") : cljs.core.reset_BANG_.call(null,text_response,""));

return org.numenta.sanity.controls_ui.fetch_details_text_BANG_(into_journal,text_response,sel);
});})(text_response))
);

return org.numenta.sanity.controls_ui.fetch_details_text_BANG_(into_journal,text_response,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selection) : cljs.core.deref.call(null,selection)));
});})(text_response))
,cljs.core.cst$kw$component_DASH_will_DASH_unmount,((function (text_response){
return (function (_){
return cljs.core.remove_watch(selection,cljs.core.cst$kw$fetch_DASH_details_DASH_text);
});})(text_response))
,cljs.core.cst$kw$reagent_DASH_render,((function (text_response){
return (function (_,___$1){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,"The details of model state on the selected time step, selected column."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pre$pre_DASH_scrollable,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$height,"90vh",cljs.core.cst$kw$resize,"both"], null)], null),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(text_response) : cljs.core.deref.call(null,text_response))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$small,"(scrollable)"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$hr], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,"If you're brave:"], null),(function (){var map__67700 = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(org.numenta.sanity.selection.layer,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selection) : cljs.core.deref.call(null,selection))));
var map__67700__$1 = ((((!((map__67700 == null)))?((((map__67700.cljs$lang$protocol_mask$partition0$ & (64))) || (map__67700.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67700):map__67700);
var step = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67700__$1,cljs.core.cst$kw$step);
var map__67701 = step;
var map__67701__$1 = ((((!((map__67701 == null)))?((((map__67701.cljs$lang$protocol_mask$partition0$ & (64))) || (map__67701.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__67701):map__67701);
var snapshot_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__67701__$1,cljs.core.cst$kw$snapshot_DASH_id);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_warning$btn_DASH_block,(function (){var G__67704 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (map__67700,map__67700__$1,step,map__67701,map__67701__$1,snapshot_id,text_response){
return (function (e){
var response_c_67718 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$get_DASH_model,snapshot_id,org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c_67718,true),true], null));

var c__38109__auto___67719 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___67719,response_c_67718,map__67700,map__67700__$1,step,map__67701,map__67701__$1,snapshot_id,text_response){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___67719,response_c_67718,map__67700,map__67700__$1,step,map__67701,map__67701__$1,snapshot_id,text_response){
return (function (state_67709){
var state_val_67710 = (state_67709[(1)]);
if((state_val_67710 === (1))){
var state_67709__$1 = state_67709;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67709__$1,(2),response_c_67718);
} else {
if((state_val_67710 === (2))){
var inst_67706 = (state_67709[(2)]);
var inst_67707 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_67706], 0));
var state_67709__$1 = state_67709;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67709__$1,inst_67707);
} else {
return null;
}
}
});})(c__38109__auto___67719,response_c_67718,map__67700,map__67700__$1,step,map__67701,map__67701__$1,snapshot_id,text_response))
;
return ((function (switch__37995__auto__,c__38109__auto___67719,response_c_67718,map__67700,map__67700__$1,step,map__67701,map__67701__$1,snapshot_id,text_response){
return (function() {
var org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto__ = null;
var org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto____0 = (function (){
var statearr_67714 = [null,null,null,null,null,null,null];
(statearr_67714[(0)] = org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto__);

(statearr_67714[(1)] = (1));

return statearr_67714;
});
var org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto____1 = (function (state_67709){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_67709);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e67715){if((e67715 instanceof Object)){
var ex__37999__auto__ = e67715;
var statearr_67716_67720 = state_67709;
(statearr_67716_67720[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_67709);

return cljs.core.cst$kw$recur;
} else {
throw e67715;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__67721 = state_67709;
state_67709 = G__67721;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto__ = function(state_67709){
switch(arguments.length){
case 0:
return org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto____1.call(this,state_67709);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto____0;
org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto____1;
return org$numenta$sanity$controls_ui$details_tab_$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___67719,response_c_67718,map__67700,map__67700__$1,step,map__67701,map__67701__$1,snapshot_id,text_response))
})();
var state__38111__auto__ = (function (){var statearr_67717 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_67717[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___67719);

return statearr_67717;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___67719,response_c_67718,map__67700,map__67700__$1,step,map__67701,map__67701__$1,snapshot_id,text_response))
);


return e.preventDefault();
});})(map__67700,map__67700__$1,step,map__67701,map__67701__$1,snapshot_id,text_response))
], null);
if(cljs.core.not(snapshot_id)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__67704,cljs.core.cst$kw$disabled,"disabled");
} else {
return G__67704;
}
})(),"Dump entire model to console"], null);
})()], null);
});})(text_response))
], null));
});
org.numenta.sanity.controls_ui.t_chbox = (function org$numenta$sanity$controls_ui$t_chbox(id,label){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$checkbox,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$id,id], null)], null)," ",label], null)], null);
});
org.numenta.sanity.controls_ui.keep_steps_template = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_xs_DASH_12,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$font_DASH_weight,"normal"], null)], null),"Keep ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$field,cljs.core.cst$kw$numeric,cljs.core.cst$kw$id,cljs.core.cst$kw$keep_DASH_steps,cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text_DASH_align,"center"], null),cljs.core.cst$kw$size,(4)], null)], null)," steps of history"], null)], null)], null)], null)], null);
org.numenta.sanity.controls_ui.capture_tab = (function org$numenta$sanity$controls_ui$capture_tab(capture_options){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$margin_DASH_top,(15),cljs.core.cst$kw$margin_DASH_bottom,(15)], null)], null),"Choose data the server should capture."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_forms.core.bind_fields,org.numenta.sanity.controls_ui.keep_steps_template,capture_options], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_6$col_DASH_sm_DASH_12,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_heading,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$panel_DASH_title,"Feed-forward synapses"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_forms.core.bind_fields,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$ff_DASH_synapses$capture_QMARK_,"Save"),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$container,cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_top,(-5)], null),cljs.core.cst$kw$visible_QMARK_,(function (p1__67722_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__67722_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ff_DASH_synapses,cljs.core.cst$kw$capture_QMARK_], null));
})], null),org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$ff_DASH_synapses$only_DASH_active_QMARK_,"Only if active"),org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$ff_DASH_synapses$only_DASH_connected_QMARK_,"Only if connected")], null)], null),capture_options], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_6$col_DASH_sm_DASH_12,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_heading,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$panel_DASH_title,"Distal synapses"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_forms.core.bind_fields,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$distal_DASH_synapses$capture_QMARK_,"Save"),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$container,cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_top,(-5)], null),cljs.core.cst$kw$visible_QMARK_,(function (p1__67723_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__67723_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$distal_DASH_synapses,cljs.core.cst$kw$capture_QMARK_], null));
})], null),org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$distal_DASH_synapses$only_DASH_active_QMARK_,"Only if active"),org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$distal_DASH_synapses$only_DASH_connected_QMARK_,"Only if connected"),org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$distal_DASH_synapses$only_DASH_noteworthy_DASH_columns_QMARK_,"Only active / predicted columns")], null)], null),capture_options], null)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_6$col_DASH_sm_DASH_12,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_heading,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$panel_DASH_title,"Apical synapses"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_forms.core.bind_fields,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$apical_DASH_synapses$capture_QMARK_,"Save"),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$container,cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_top,(-5)], null),cljs.core.cst$kw$visible_QMARK_,(function (p1__67724_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__67724_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$apical_DASH_synapses,cljs.core.cst$kw$capture_QMARK_], null));
})], null),org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$apical_DASH_synapses$only_DASH_active_QMARK_,"Only if active"),org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$apical_DASH_synapses$only_DASH_connected_QMARK_,"Only if connected"),org.numenta.sanity.controls_ui.t_chbox(cljs.core.cst$kw$apical_DASH_synapses$only_DASH_noteworthy_DASH_columns_QMARK_,"Only active / predicted columns")], null)], null),capture_options], null)], null)], null)], null)], null)], null);
});
org.numenta.sanity.controls_ui.viz_options_template = (function (){var chbox = (function (id,label){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$checkbox,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$id,id], null)], null),[cljs.core.str(" "),cljs.core.str(label)].join('')], null)], null);
});
var group = ((function (chbox){
return (function (title,content){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_6$col_DASH_sm_DASH_12,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_heading,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$panel_DASH_title,title], null)], null),content], null)], null);
});})(chbox))
;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$radio,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$radio,cljs.core.cst$kw$name,cljs.core.cst$kw$drawing$display_DASH_mode,cljs.core.cst$kw$value,cljs.core.cst$kw$one_DASH_d], null)], null)," Draw ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$numeric,cljs.core.cst$kw$id,cljs.core.cst$kw$drawing$draw_DASH_steps,cljs.core.cst$kw$size,(4)], null)], null)," steps in 1D"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$radio,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$field,cljs.core.cst$kw$radio,cljs.core.cst$kw$name,cljs.core.cst$kw$drawing$display_DASH_mode,cljs.core.cst$kw$value,cljs.core.cst$kw$two_DASH_d], null)], null)," Draw one step in 2D"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,group("Inbits",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,chbox(cljs.core.cst$kw$inbits$active,"Active bits"),chbox(cljs.core.cst$kw$inbits$predicted,"Predicted bits")], null)),group("Columns",new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,chbox(cljs.core.cst$kw$columns$overlaps,"Overlaps"),chbox(cljs.core.cst$kw$columns$active_DASH_freq,"Active-duty"),chbox(cljs.core.cst$kw$columns$boosts,"Boosts"),chbox(cljs.core.cst$kw$columns$n_DASH_segments,"N.segments"),chbox(cljs.core.cst$kw$columns$active,"Active"),chbox(cljs.core.cst$kw$columns$predictive,"Predictive")], null)),group("Feed-forward synapses",new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,"To ",new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$list,cljs.core.cst$kw$id,cljs.core.cst$kw$ff_DASH_synapses$to], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$all], null),"all active columns"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$selected], null),"selected column"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$none], null),"none"], null)], null)], null),chbox(cljs.core.cst$kw$ff_DASH_synapses$trace_DASH_back_QMARK_,"Trace back"),chbox(cljs.core.cst$kw$ff_DASH_synapses$disconnected,"Disconnected"),chbox(cljs.core.cst$kw$ff_DASH_synapses$inactive,"Inactive"),chbox(cljs.core.cst$kw$ff_DASH_synapses$predicted,"Predictive"),chbox(cljs.core.cst$kw$ff_DASH_synapses$permanences,"Permanences")], null)),group("Distal synapses",new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,"(selected column) ",new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$field,cljs.core.cst$kw$list,cljs.core.cst$kw$id,cljs.core.cst$kw$distal_DASH_synapses$to], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$all], null),"all cell segments"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$selected], null),"selected segment"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$option,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$none], null),"none"], null)], null)], null),chbox(cljs.core.cst$kw$distal_DASH_synapses$disconnected,"Disconnected"),chbox(cljs.core.cst$kw$distal_DASH_synapses$inactive,"Inactive"),chbox(cljs.core.cst$kw$distal_DASH_synapses$permanences,"Permanences")], null))], null)], null);
})();
org.numenta.sanity.controls_ui.drawing_tab = (function org$numenta$sanity$controls_ui$drawing_tab(features,viz_options,capture_options){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$margin_DASH_top,(15),cljs.core.cst$kw$margin_DASH_bottom,(15)], null)], null),"Select drawing options, with immediate effect."], null),(cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$capture) : features.call(null,cljs.core.cst$kw$capture)))?null:new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_forms.core.bind_fields,org.numenta.sanity.controls_ui.keep_steps_template,capture_options], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_forms.core.bind_fields,org.numenta.sanity.controls_ui.viz_options_template,viz_options], null)], null);
});
org.numenta.sanity.controls_ui.default_debug_data = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$repl_DASH_url,"http://localhost:9000/repl",cljs.core.cst$kw$started_QMARK_,false,cljs.core.cst$kw$conn,null], null);
org.numenta.sanity.controls_ui.debug_tab = (function org$numenta$sanity$controls_ui$debug_tab(debug_data){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$text_DASH_muted,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$margin_DASH_top,(15),cljs.core.cst$kw$margin_DASH_bottom,(15)], null)], null),"Inspect the inspector."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_12,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel$panel_DASH_default,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_heading,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$panel_DASH_title,"REPL"], null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$panel_DASH_body,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"ClojureScript REPL URL:"], null),(cljs.core.truth_(cljs.core.cst$kw$started_QMARK_.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(debug_data) : cljs.core.deref.call(null,debug_data))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,cljs.core.cst$kw$repl_DASH_url.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(debug_data) : cljs.core.deref.call(null,debug_data)))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [reagent_forms.core.bind_fields,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,"100%"], null),cljs.core.cst$kw$field,cljs.core.cst$kw$text,cljs.core.cst$kw$id,cljs.core.cst$kw$repl_DASH_url], null)], null),debug_data], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_primary$btn_DASH_block,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,(function (_){
var conn = clojure.browser.repl.connect(cljs.core.cst$kw$repl_DASH_url.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(debug_data) : cljs.core.deref.call(null,debug_data))));
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(debug_data,cljs.core.assoc,cljs.core.cst$kw$started_QMARK_,true,cljs.core.array_seq([cljs.core.cst$kw$conn,conn], 0));
})], null),"Connect to Browser REPL"], null)], null)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Go start a ClojureScript REPL, then connect to it from here."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,"https://github.com/nupic-community/sanity"], null),"Sanity"], null)," has a browser_repl.clj that you can run."], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Pro-tip: in Emacs, do 'M-x shell', run ","'lein run -m clojure.main browser_repl.clj', ","and maybe do 'M-x paredit-mode'."], null)], null)], null)], null)], null);
});
org.numenta.sanity.controls_ui.send_command = (function org$numenta$sanity$controls_ui$send_command(var_args){
var args__7218__auto__ = [];
var len__7211__auto___67728 = arguments.length;
var i__7212__auto___67729 = (0);
while(true){
if((i__7212__auto___67729 < len__7211__auto___67728)){
args__7218__auto__.push((arguments[i__7212__auto___67729]));

var G__67730 = (i__7212__auto___67729 + (1));
i__7212__auto___67729 = G__67730;
continue;
} else {
}
break;
}

var argseq__7219__auto__ = ((((2) < args__7218__auto__.length))?(new cljs.core.IndexedSeq(args__7218__auto__.slice((2)),(0))):null);
return org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7219__auto__);
});

org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic = (function (ch,command,xs){
return (function (e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(ch,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [command], null),xs));

return e.preventDefault();
});
});

org.numenta.sanity.controls_ui.send_command.cljs$lang$maxFixedArity = (2);

org.numenta.sanity.controls_ui.send_command.cljs$lang$applyTo = (function (seq67725){
var G__67726 = cljs.core.first(seq67725);
var seq67725__$1 = cljs.core.next(seq67725);
var G__67727 = cljs.core.first(seq67725__$1);
var seq67725__$2 = cljs.core.next(seq67725__$1);
return org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic(G__67726,G__67727,seq67725__$2);
});
org.numenta.sanity.controls_ui.gather_start_data_BANG_ = (function org$numenta$sanity$controls_ui$gather_start_data_BANG_(run_start,steps){
var G__67733 = run_start;
var G__67734 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$time,org.numenta.sanity.controls_ui.now(),cljs.core.cst$kw$timestep,cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(cljs.core.first(steps))], null);
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__67733,G__67734) : cljs.core.reset_BANG_.call(null,G__67733,G__67734));
});
org.numenta.sanity.controls_ui.navbar = (function org$numenta$sanity$controls_ui$navbar(_,___$1,steps,show_help,viz_options,viz_expanded,network_shape,into_viz,into_sim){
var has_scrolled_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var has_sorted_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var has_watched_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var apply_to_all_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(true);
var run_start = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var going_QMARK_ = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var subscriber_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["subscribe-to-status",org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$1(subscriber_c)], null));

var c__38109__auto___67823 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___67823,has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___67823,has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (state_67793){
var state_val_67794 = (state_67793[(1)]);
if((state_val_67794 === (1))){
var state_67793__$1 = state_67793;
var statearr_67795_67824 = state_67793__$1;
(statearr_67795_67824[(2)] = null);

(statearr_67795_67824[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67794 === (2))){
var state_67793__$1 = state_67793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67793__$1,(4),subscriber_c);
} else {
if((state_val_67794 === (3))){
var inst_67791 = (state_67793[(2)]);
var state_67793__$1 = state_67793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67793__$1,inst_67791);
} else {
if((state_val_67794 === (4))){
var inst_67781 = (state_67793[(7)]);
var inst_67781__$1 = (state_67793[(2)]);
var state_67793__$1 = (function (){var statearr_67796 = state_67793;
(statearr_67796[(7)] = inst_67781__$1);

return statearr_67796;
})();
if(cljs.core.truth_(inst_67781__$1)){
var statearr_67797_67825 = state_67793__$1;
(statearr_67797_67825[(1)] = (5));

} else {
var statearr_67798_67826 = state_67793__$1;
(statearr_67798_67826[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67794 === (5))){
var inst_67781 = (state_67793[(7)]);
var inst_67784 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67781,(0),null);
var inst_67785 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(going_QMARK_,inst_67784) : cljs.core.reset_BANG_.call(null,going_QMARK_,inst_67784));
var state_67793__$1 = (function (){var statearr_67799 = state_67793;
(statearr_67799[(8)] = inst_67785);

return statearr_67799;
})();
var statearr_67800_67827 = state_67793__$1;
(statearr_67800_67827[(2)] = null);

(statearr_67800_67827[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67794 === (6))){
var state_67793__$1 = state_67793;
var statearr_67801_67828 = state_67793__$1;
(statearr_67801_67828[(2)] = null);

(statearr_67801_67828[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67794 === (7))){
var inst_67789 = (state_67793[(2)]);
var state_67793__$1 = state_67793;
var statearr_67802_67829 = state_67793__$1;
(statearr_67802_67829[(2)] = inst_67789);

(statearr_67802_67829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(c__38109__auto___67823,has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
;
return ((function (switch__37995__auto__,c__38109__auto___67823,has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function() {
var org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto__ = null;
var org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto____0 = (function (){
var statearr_67806 = [null,null,null,null,null,null,null,null,null];
(statearr_67806[(0)] = org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto__);

(statearr_67806[(1)] = (1));

return statearr_67806;
});
var org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto____1 = (function (state_67793){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_67793);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e67807){if((e67807 instanceof Object)){
var ex__37999__auto__ = e67807;
var statearr_67808_67830 = state_67793;
(statearr_67808_67830[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_67793);

return cljs.core.cst$kw$recur;
} else {
throw e67807;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__67831 = state_67793;
state_67793 = G__67831;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto__ = function(state_67793){
switch(arguments.length){
case 0:
return org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto____1.call(this,state_67793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto____0;
org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto____1;
return org$numenta$sanity$controls_ui$navbar_$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___67823,has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
})();
var state__38111__auto__ = (function (){var statearr_67809 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_67809[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___67823);

return statearr_67809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___67823,has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
);


cljs.core.add_watch(steps,cljs.core.cst$kw$org$numenta$sanity$controls_DASH_ui_SLASH_gather_DASH_start_DASH_data,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (___$2,___$3,___$4,xs){
cljs.core.remove_watch(steps,cljs.core.cst$kw$org$numenta$sanity$controls_DASH_ui_SLASH_gather_DASH_start_DASH_data);

return org.numenta.sanity.controls_ui.gather_start_data_BANG_(run_start,xs);
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
);

cljs.core.add_watch(going_QMARK_,cljs.core.cst$kw$org$numenta$sanity$controls_DASH_ui_SLASH_gather_DASH_start_DASH_data,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (___$2,___$3,oldv,go_QMARK_){
if(cljs.core.truth_((function (){var and__6141__auto__ = cljs.core.not(oldv);
if(and__6141__auto__){
return go_QMARK_;
} else {
return and__6141__auto__;
}
})())){
if(cljs.core.truth_(cljs.core.first((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(steps) : cljs.core.deref.call(null,steps))))){
return org.numenta.sanity.controls_ui.gather_start_data_BANG_(run_start,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(steps) : cljs.core.deref.call(null,steps)));
} else {
return null;
}
} else {
return null;
}
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
);

return ((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (title,features,___$2,___$3,___$4,___$5,___$6,___$7){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$nav$navbar$navbar_DASH_default,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$container_DASH_fluid,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$navbar_DASH_header,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$navbar_DASH_toggle$collapsed,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$data_DASH_toggle,"collapse",cljs.core.cst$kw$data_DASH_target,"#comportex-navbar-collapse"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$icon_DASH_bar], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$icon_DASH_bar], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$icon_DASH_bar], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$navbar_DASH_brand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,"https://github.com/nupic-community/sanity"], null),title], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$collapse$navbar_DASH_collapse,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,"comportex-navbar-collapse"], null),new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$nav$navbar_DASH_nav,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,(function (){var G__67810 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,org.numenta.sanity.controls_ui.send_command(into_viz,cljs.core.cst$kw$step_DASH_backward),cljs.core.cst$kw$title,"Step backward in time"], null);
if(cljs.core.not((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__67810,cljs.core.cst$kw$disabled,"disabled");
} else {
return G__67810;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_step_DASH_backward,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Step backward"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,(function (){var G__67811 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,org.numenta.sanity.controls_ui.send_command(into_viz,cljs.core.cst$kw$step_DASH_forward),cljs.core.cst$kw$title,"Step forward in time"], null);
if(cljs.core.not((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__67811,cljs.core.cst$kw$disabled,"disabled");
} else {
return G__67811;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_step_DASH_forward,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Step forward"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(going_QMARK_) : cljs.core.deref.call(null,going_QMARK_)))?null:new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,"hidden"], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,(function (){var G__67812 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["pause"], null));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,"5em"], null)], null);
if(cljs.core.not((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__67812,cljs.core.cst$kw$disabled,"disabled");
} else {
return G__67812;
}
})(),"Pause"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(going_QMARK_) : cljs.core.deref.call(null,going_QMARK_)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,"hidden"], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_primary$navbar_DASH_btn,(function (){var G__67813 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["run"], null));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,"5em"], null)], null);
if(cljs.core.not((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__67813,cljs.core.cst$kw$disabled,"disabled");
} else {
return G__67813;
}
})(),"Run"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$dropdown,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$dropdown_DASH_toggle,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_toggle,"dropdown",cljs.core.cst$kw$role,"button",cljs.core.cst$kw$href,"#"], null),"Display",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$caret], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$dropdown_DASH_menu,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$role,"menu"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(viz_options,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$drawing,cljs.core.cst$kw$display_DASH_mode], null),cljs.core.cst$kw$one_DASH_d);
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
], null),"column states over time (1D)"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(viz_options,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$drawing,cljs.core.cst$kw$display_DASH_mode], null),cljs.core.cst$kw$two_DASH_d);
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
], null),"column states over space (2D)"], null)], null)], null)], null),(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(viz_expanded) : cljs.core.deref.call(null,viz_expanded)))?null:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$hidden_DASH_xs,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (e){
var seq__67814_67832 = cljs.core.seq(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(goog.dom.getElementsByClass("viz-expandable")));
var chunk__67815_67833 = null;
var count__67816_67834 = (0);
var i__67817_67835 = (0);
while(true){
if((i__67817_67835 < count__67816_67834)){
var el_67836 = chunk__67815_67833.cljs$core$IIndexed$_nth$arity$2(null,i__67817_67835);
goog.dom.classes.swap(el_67836,"col-sm-9","col-sm-12");

var G__67837 = seq__67814_67832;
var G__67838 = chunk__67815_67833;
var G__67839 = count__67816_67834;
var G__67840 = (i__67817_67835 + (1));
seq__67814_67832 = G__67837;
chunk__67815_67833 = G__67838;
count__67816_67834 = G__67839;
i__67817_67835 = G__67840;
continue;
} else {
var temp__4657__auto___67841 = cljs.core.seq(seq__67814_67832);
if(temp__4657__auto___67841){
var seq__67814_67842__$1 = temp__4657__auto___67841;
if(cljs.core.chunked_seq_QMARK_(seq__67814_67842__$1)){
var c__6956__auto___67843 = cljs.core.chunk_first(seq__67814_67842__$1);
var G__67844 = cljs.core.chunk_rest(seq__67814_67842__$1);
var G__67845 = c__6956__auto___67843;
var G__67846 = cljs.core.count(c__6956__auto___67843);
var G__67847 = (0);
seq__67814_67832 = G__67844;
chunk__67815_67833 = G__67845;
count__67816_67834 = G__67846;
i__67817_67835 = G__67847;
continue;
} else {
var el_67848 = cljs.core.first(seq__67814_67842__$1);
goog.dom.classes.swap(el_67848,"col-sm-9","col-sm-12");

var G__67849 = cljs.core.next(seq__67814_67842__$1);
var G__67850 = null;
var G__67851 = (0);
var G__67852 = (0);
seq__67814_67832 = G__67849;
chunk__67815_67833 = G__67850;
count__67816_67834 = G__67851;
i__67817_67835 = G__67852;
continue;
}
} else {
}
}
break;
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(viz_expanded,true) : cljs.core.reset_BANG_.call(null,viz_expanded,true));

window.dispatchEvent((new Event("resize")));

return e.preventDefault();
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,cljs.core.cst$kw$title,"Expand visualisation"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_resize_DASH_full,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$sr_DASH_only,"Expand"], null)], null)], null)),(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(viz_expanded) : cljs.core.deref.call(null,viz_expanded)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$hidden_DASH_xs,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (e){
var seq__67818_67853 = cljs.core.seq(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$1(goog.dom.getElementsByClass("viz-expandable")));
var chunk__67819_67854 = null;
var count__67820_67855 = (0);
var i__67821_67856 = (0);
while(true){
if((i__67821_67856 < count__67820_67855)){
var el_67857 = chunk__67819_67854.cljs$core$IIndexed$_nth$arity$2(null,i__67821_67856);
goog.dom.classes.swap(el_67857,"col-sm-12","col-sm-9");

var G__67858 = seq__67818_67853;
var G__67859 = chunk__67819_67854;
var G__67860 = count__67820_67855;
var G__67861 = (i__67821_67856 + (1));
seq__67818_67853 = G__67858;
chunk__67819_67854 = G__67859;
count__67820_67855 = G__67860;
i__67821_67856 = G__67861;
continue;
} else {
var temp__4657__auto___67862 = cljs.core.seq(seq__67818_67853);
if(temp__4657__auto___67862){
var seq__67818_67863__$1 = temp__4657__auto___67862;
if(cljs.core.chunked_seq_QMARK_(seq__67818_67863__$1)){
var c__6956__auto___67864 = cljs.core.chunk_first(seq__67818_67863__$1);
var G__67865 = cljs.core.chunk_rest(seq__67818_67863__$1);
var G__67866 = c__6956__auto___67864;
var G__67867 = cljs.core.count(c__6956__auto___67864);
var G__67868 = (0);
seq__67818_67853 = G__67865;
chunk__67819_67854 = G__67866;
count__67820_67855 = G__67867;
i__67821_67856 = G__67868;
continue;
} else {
var el_67869 = cljs.core.first(seq__67818_67863__$1);
goog.dom.classes.swap(el_67869,"col-sm-12","col-sm-9");

var G__67870 = cljs.core.next(seq__67818_67863__$1);
var G__67871 = null;
var G__67872 = (0);
var G__67873 = (0);
seq__67818_67853 = G__67870;
chunk__67819_67854 = G__67871;
count__67820_67855 = G__67872;
i__67821_67856 = G__67873;
continue;
}
} else {
}
}
break;
}

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(viz_expanded,false) : cljs.core.reset_BANG_.call(null,viz_expanded,false));

window.dispatchEvent((new Event("resize")));

return e.preventDefault();
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,cljs.core.cst$kw$title,"Un-expand visualisation"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_resize_DASH_small,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$sr_DASH_only,"Un-expand"], null)], null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$navbar_DASH_text,"Sort/Watch/Scroll:"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (___$8){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(has_sorted_QMARK_,true) : cljs.core.reset_BANG_.call(null,has_sorted_QMARK_,true));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic(into_viz,cljs.core.cst$kw$sort,cljs.core.array_seq([(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_))], 0))),cljs.core.cst$kw$title,"Sort the columns by order of recent activity"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_sort_DASH_by_DASH_attributes_DASH_alt,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Sort by recent active columns"], null)], null)], null),(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(has_sorted_QMARK_) : cljs.core.deref.call(null,has_sorted_QMARK_)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (___$8){
if(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_)))){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(has_sorted_QMARK_,false) : cljs.core.reset_BANG_.call(null,has_sorted_QMARK_,false));
} else {
return null;
}
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic(into_viz,cljs.core.cst$kw$clear_DASH_sort,cljs.core.array_seq([(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_))], 0))),cljs.core.cst$kw$title,"Clear all sorting - revert to actual column order"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_sort_DASH_by_DASH_order,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Clear sorting"], null)], null)], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_left,"1ex"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (___$8){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(has_watched_QMARK_,true) : cljs.core.reset_BANG_.call(null,has_watched_QMARK_,true));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic(into_viz,cljs.core.cst$kw$add_DASH_facet,cljs.core.array_seq([(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_))], 0))),cljs.core.cst$kw$title,"Add a facet to watch the current active set of columns"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_eye_DASH_open,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Add facet, watching active set"], null)], null)], null),(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(has_watched_QMARK_) : cljs.core.deref.call(null,has_watched_QMARK_)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (___$8){
if(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_)))){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(has_watched_QMARK_,false) : cljs.core.reset_BANG_.call(null,has_watched_QMARK_,false));
} else {
return null;
}
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic(into_viz,cljs.core.cst$kw$clear_DASH_facets,cljs.core.array_seq([(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_))], 0))),cljs.core.cst$kw$title,"Clear all facets (watching sets of columns)"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_eye_DASH_close,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Clear all facets"], null)], null)], null):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_left,"1ex"], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (___$8){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(has_scrolled_QMARK_,true) : cljs.core.reset_BANG_.call(null,has_scrolled_QMARK_,true));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic(into_viz,cljs.core.cst$kw$scroll_DASH_down,cljs.core.array_seq([(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_))], 0))),cljs.core.cst$kw$title,"Scroll down visible columns"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_arrow_DASH_down,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Scroll down"], null)], null)], null),(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(has_scrolled_QMARK_) : cljs.core.deref.call(null,has_scrolled_QMARK_)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,org.numenta.sanity.controls_ui.send_command.cljs$core$IFn$_invoke$arity$variadic(into_viz,cljs.core.cst$kw$scroll_DASH_up,cljs.core.array_seq([(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_))], 0)),cljs.core.cst$kw$title,"Scroll up visible columns"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_arrow_DASH_up,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Scroll up"], null)], null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$navbar_DASH_form,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$form_DASH_group,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$checkbox,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$small,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,[cljs.core.str("Apply scroll/sort/watch actions to all layers; "),cljs.core.str("otherwise only the selected layer.")].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$checkbox,cljs.core.cst$kw$checked,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(apply_to_all_QMARK_) : cljs.core.deref.call(null,apply_to_all_QMARK_)))?true:null),cljs.core.cst$kw$on_DASH_change,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (e){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(apply_to_all_QMARK_,cljs.core.not);

return e.preventDefault();
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
], null)], null)," all layers"], null)], null)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$nav$navbar_DASH_nav$navbar_DASH_right,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,((cljs.core.not((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(going_QMARK_) : cljs.core.deref.call(null,going_QMARK_))))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,"hidden"], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p$navbar_DASH_text,[cljs.core.str(org.numenta.sanity.controls_ui.sim_rate(cljs.core.first((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(steps) : cljs.core.deref.call(null,steps))),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(run_start) : cljs.core.deref.call(null,run_start))).toFixed((1))),cljs.core.str("/sec.")].join('')], null)], null),(cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$speed) : features.call(null,cljs.core.cst$kw$speed)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li$dropdown,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$dropdown_DASH_toggle,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$data_DASH_toggle,"dropdown",cljs.core.cst$kw$role,"button",cljs.core.cst$kw$href,"#"], null),"Speed",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$caret], null)], null),new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$dropdown_DASH_menu,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$role,"menu"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["set-step-ms",(0)], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(viz_options,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$drawing,cljs.core.cst$kw$anim_DASH_every], null),(1));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
], null),"max sim speed"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["set-step-ms",(0)], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(viz_options,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$drawing,cljs.core.cst$kw$anim_DASH_every], null),(100));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
], null),"max sim speed, draw every 100 steps"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["set-step-ms",(250)], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(viz_options,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$drawing,cljs.core.cst$kw$anim_DASH_every], null),(1));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
], null),"limit to 4 steps/sec."], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["set-step-ms",(500)], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(viz_options,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$drawing,cljs.core.cst$kw$anim_DASH_every], null),(1));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
], null),"limit to 2 steps/sec."], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_sim,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["set-step-ms",(1000)], null));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(viz_options,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$drawing,cljs.core.cst$kw$anim_DASH_every], null),(1));
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
], null),"limit to 1 step/sec."], null)], null)], null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_default$navbar_DASH_btn,(function (){var G__67822 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$button,cljs.core.cst$kw$on_DASH_click,((function (has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c){
return (function (e){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(show_help,cljs.core.not);

return e.preventDefault();
});})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
,cljs.core.cst$kw$title,"Help"], null);
if(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(show_help) : cljs.core.deref.call(null,show_help)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__67822,cljs.core.cst$kw$class,"active");
} else {
return G__67822;
}
})(),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$glyphicon$glyphicon_DASH_question_DASH_sign,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$aria_DASH_hidden,"true"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$visible_DASH_xs_DASH_inline," Help"], null)], null)], null)], null)], null)], null)], null);
});
;})(has_scrolled_QMARK_,has_sorted_QMARK_,has_watched_QMARK_,apply_to_all_QMARK_,run_start,going_QMARK_,subscriber_c))
});
org.numenta.sanity.controls_ui.tabs = (function org$numenta$sanity$controls_ui$tabs(tab_cmps){
var current_tab = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.ffirst(tab_cmps));
return ((function (current_tab){
return (function (tab_cmps__$1){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$nav,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$nav$nav_DASH_tabs], null),(function (){var iter__6925__auto__ = ((function (current_tab){
return (function org$numenta$sanity$controls_ui$tabs_$_iter__67887(s__67888){
return (new cljs.core.LazySeq(null,((function (current_tab){
return (function (){
var s__67888__$1 = s__67888;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__67888__$1);
if(temp__4657__auto__){
var s__67888__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__67888__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__67888__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__67890 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__67889 = (0);
while(true){
if((i__67889 < size__6924__auto__)){
var vec__67895 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__67889);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67895,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67895,(1),null);
cljs.core.chunk_append(b__67890,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,"presentation",cljs.core.cst$kw$class,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(current_tab) : cljs.core.deref.call(null,current_tab)),k))?"active":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (i__67889,vec__67895,k,_,c__6923__auto__,size__6924__auto__,b__67890,s__67888__$2,temp__4657__auto__,current_tab){
return (function (e){
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(current_tab,k) : cljs.core.reset_BANG_.call(null,current_tab,k));

return e.preventDefault();
});})(i__67889,vec__67895,k,_,c__6923__auto__,size__6924__auto__,b__67890,s__67888__$2,temp__4657__auto__,current_tab))
], null),cljs.core.name(k)], null)], null));

var G__67900 = (i__67889 + (1));
i__67889 = G__67900;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__67890),org$numenta$sanity$controls_ui$tabs_$_iter__67887(cljs.core.chunk_rest(s__67888__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__67890),null);
}
} else {
var vec__67896 = cljs.core.first(s__67888__$2);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67896,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67896,(1),null);
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$role,"presentation",cljs.core.cst$kw$class,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(current_tab) : cljs.core.deref.call(null,current_tab)),k))?"active":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$href,"#",cljs.core.cst$kw$on_DASH_click,((function (vec__67896,k,_,s__67888__$2,temp__4657__auto__,current_tab){
return (function (e){
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(current_tab,k) : cljs.core.reset_BANG_.call(null,current_tab,k));

return e.preventDefault();
});})(vec__67896,k,_,s__67888__$2,temp__4657__auto__,current_tab))
], null),cljs.core.name(k)], null)], null),org$numenta$sanity$controls_ui$tabs_$_iter__67887(cljs.core.rest(s__67888__$2)));
}
} else {
return null;
}
break;
}
});})(current_tab))
,null,null));
});})(current_tab))
;
return iter__6925__auto__(tab_cmps__$1);
})())], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tabs,(function (){var vec__67897 = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (current_tab){
return (function (p__67898){
var vec__67899 = p__67898;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67899,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67899,(1),null);
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(current_tab) : cljs.core.deref.call(null,current_tab)),k);
});})(current_tab))
,tab_cmps__$1));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67897,(0),null);
var cmp = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__67897,(1),null);
return cmp;
})()], null)], null);
});
;})(current_tab))
});
org.numenta.sanity.controls_ui.help_block = (function org$numenta$sanity$controls_ui$help_block(show_help){
if(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(show_help) : cljs.core.deref.call(null,show_help)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$container_DASH_fluid,new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_3$col_DASH_md_DASH_4$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Overview"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$href,"https://github.com/nupic-community/sanity"], null),"Sanity"], null)," runs HTM models in the browser with interactive\n       controls. The model state from recent timesteps is kept, so you can step\n       back in time. You can inspect input values, encoded sense bits, and the\n       columns that make up cortical region layers. Within a column you can inspect\n       cells and their distal dendrite segments. Feed-forward and distal synapses\n       can be shown."], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_3$col_DASH_md_DASH_4$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Display"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Kept timesteps are shown in a row at the top of the display.\n      Click one to jump to it.\n      Below that, the blocks represent sensory fields (squares) and\n      layers of cortical columns (circles). Depending on the display mode,\n      these may be shown in 2D grids from a single time step, or as one\n      vertical line per timestep, allowing several time steps to be shown\n      in series."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Don't miss the various complementary displays in the other tabs."], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_3$col_DASH_md_DASH_4$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Selection"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Click on the main canvas to select one column of cells,\n      within some region layer. The individual cells\n      and their distal dendrite segments will be shown.\n      If you click off the layer, the column will be de-selected, but\n      the layer will remain selected. Its parameters can be seen and edited in\n      the 'params' tab."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Input bits can also be selected. For multiple selections,\n       hold Command / Ctrl key while clicking (on Mac / Windows,\n       respectively)."], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_3$col_DASH_md_DASH_4$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Key controls"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"When the main canvas is in focus, ",new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"up"], null),"/",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"down"], null)," select columns; "], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"page up"], null),"/",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"page down"], null)," scroll the visible field; "], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"right"], null),"/",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"left"], null)," step forward / back in time; "], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"space"], null)," starts or stops running. "], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"/"], null)," sorts the selected layer (Shift for all);"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"\\"], null)," clears sorting (Shift for all);"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"+"], null)," adds a facet (Shift for all);"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$kbd,"-"], null)," clears facets (Shift for all);"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_3$col_DASH_md_DASH_4$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Colour legend"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$b,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"red"], null)], null),"Red"], null),": active"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$b,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"blue"], null)], null),"Blue"], null),": predicted"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$b,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"purple"], null)], null),"Purple"], null),": active+predicted (i.e. recognised)"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$b,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,"green"], null)], null),"Green"], null),": growing (new synapses)"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_lg_DASH_3$col_DASH_md_DASH_4$col_DASH_sm_DASH_6,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Segment diagrams"], null),(function (){var conn_act_px = (115);
var disc_act_px = (25);
var stimulus_th_px = (100);
var learning_th_px = (60);
var conn_tot_px = (130);
var disc_tot_px = (40);
var width_label = ((function (conn_act_px,disc_act_px,stimulus_th_px,learning_th_px,conn_tot_px,disc_tot_px){
return (function (y_transform,width,label_above_QMARK_,text){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str("translate(0,"),cljs.core.str(y_transform),cljs.core.str(")")].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$x1,(0),cljs.core.cst$kw$y1,(-3),cljs.core.cst$kw$x2,(0),cljs.core.cst$kw$y2,(3),cljs.core.cst$kw$stroke,"black",cljs.core.cst$kw$stroke_DASH_width,(1)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$x1,width,cljs.core.cst$kw$y1,(-3),cljs.core.cst$kw$x2,width,cljs.core.cst$kw$y2,(3),cljs.core.cst$kw$stroke,"black",cljs.core.cst$kw$stroke_DASH_width,(1)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$line,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$x1,(0),cljs.core.cst$kw$y1,(0),cljs.core.cst$kw$x2,width,cljs.core.cst$kw$y2,(0),cljs.core.cst$kw$stroke,"black",cljs.core.cst$kw$stroke_DASH_width,(1)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$text,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(cljs.core.truth_(label_above_QMARK_)?(-5):(15)),cljs.core.cst$kw$font_DASH_family,"sans-serif",cljs.core.cst$kw$font_DASH_size,"13px"], null),text], null)], null);
});})(conn_act_px,disc_act_px,stimulus_th_px,learning_th_px,conn_tot_px,disc_tot_px))
;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Segments are displayed as a pair of progress bars.\n              The meaning of each of the widths is shown below."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$margin_DASH_left,(20)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,(200),cljs.core.cst$kw$height,(220)], null),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str("translate(1,0)")].join('')], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [width_label,(15),conn_tot_px,true,"connected synapses"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [width_label,(45),conn_act_px,true,"active connected synapses"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [width_label,(75),stimulus_th_px,true,"stimulus threshold"], null),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str("translate(0,"),cljs.core.str((90)),cljs.core.str(")")].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(1),cljs.core.cst$kw$width,conn_tot_px,cljs.core.cst$kw$height,(8),cljs.core.cst$kw$stroke,"none",cljs.core.cst$kw$fill,"black",cljs.core.cst$kw$fill_DASH_opacity,"0.1"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(11),cljs.core.cst$kw$width,disc_tot_px,cljs.core.cst$kw$height,(8),cljs.core.cst$kw$stroke,"none",cljs.core.cst$kw$fill,"black",cljs.core.cst$kw$fill_DASH_opacity,"0.1"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(1),cljs.core.cst$kw$width,conn_act_px,cljs.core.cst$kw$height,(8),cljs.core.cst$kw$stroke,"none",cljs.core.cst$kw$fill,"red"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(11),cljs.core.cst$kw$width,disc_act_px,cljs.core.cst$kw$height,(8),cljs.core.cst$kw$stroke,"none",cljs.core.cst$kw$fill,"red"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(0),cljs.core.cst$kw$width,stimulus_th_px,cljs.core.cst$kw$height,(10),cljs.core.cst$kw$stroke,"black",cljs.core.cst$kw$fill_DASH_opacity,(0)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rect,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(10),cljs.core.cst$kw$width,learning_th_px,cljs.core.cst$kw$height,(10),cljs.core.cst$kw$stroke,"black",cljs.core.cst$kw$fill_DASH_opacity,(0)], null)], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [width_label,(125),learning_th_px,false,"learning threshold"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [width_label,(155),disc_tot_px,false,"disconnected synapses"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [width_label,(185),disc_act_px,false,"active disconnected synapses"], null)], null)], null)], null)], null);
})()], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$hr], null)], null);
} else {
return null;
}
});
org.numenta.sanity.controls_ui.sanity_app = (function org$numenta$sanity$controls_ui$sanity_app(_,___$1,___$2,features,___$3,___$4,selection,steps,network_shape,___$5,___$6,___$7,into_journal,___$8){
var show_help = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var viz_expanded = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
var time_plots_tab = (cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$time_DASH_plots) : features.call(null,cljs.core.cst$kw$time_DASH_plots)))?org.numenta.sanity.controls_ui.time_plots_tab_builder(steps,into_journal):null);
var cell_sdrs_tab = (cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$cell_DASH_SDRs) : features.call(null,cljs.core.cst$kw$cell_DASH_SDRs)))?org.numenta.sanity.controls_ui.cell_sdrs_tab_builder(steps,network_shape,selection,into_journal):null);
return ((function (show_help,viz_expanded,time_plots_tab,cell_sdrs_tab){
return (function (title,model_tab,main_pane,___$9,capture_options,viz_options,selection__$1,steps__$1,network_shape__$1,series_colors,into_viz,into_sim,into_journal__$1,debug_data){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.navbar,title,features,steps__$1,show_help,viz_options,viz_expanded,network_shape__$1,into_viz,into_sim], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.help_block,show_help], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$container_DASH_fluid,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$row,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_9$viz_DASH_expandable,main_pane], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col_DASH_sm_DASH_3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.tabs,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(model_tab)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$model,model_tab], null):null),(cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$capture) : features.call(null,cljs.core.cst$kw$capture)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$capture,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.capture_tab,capture_options], null)], null):null),(cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$drawing) : features.call(null,cljs.core.cst$kw$drawing)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$drawing,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.drawing_tab,features,viz_options,capture_options], null)], null):null),(cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$params) : features.call(null,cljs.core.cst$kw$params)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$params,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.parameters_tab,network_shape__$1,selection__$1,into_sim], null)], null):null),(cljs.core.truth_(time_plots_tab)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$time_DASH_plots,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [time_plots_tab,series_colors], null)], null):null),(cljs.core.truth_(cell_sdrs_tab)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$cell_DASH_SDRs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cell_sdrs_tab], null)], null):null),(cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources) : features.call(null,cljs.core.cst$kw$sources)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$sources,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.sources_tab,network_shape__$1,selection__$1,series_colors,into_journal__$1], null)], null):null),(cljs.core.truth_((features.cljs$core$IFn$_invoke$arity$1 ? features.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$details) : features.call(null,cljs.core.cst$kw$details)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$details,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.details_tab,selection__$1,into_journal__$1], null)], null):null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$debug,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.controls_ui.debug_tab,debug_data], null)], null)], null))], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div_SHARP_loading_DASH_message,"loading"], null)], null)], null);
});
;})(show_help,viz_expanded,time_plots_tab,cell_sdrs_tab))
});
