// Compiled by ClojureScript 1.7.228 {:static-fns true, :optimize-constants true}
goog.provide('org.numenta.sanity.plots');
goog.require('cljs.core');
goog.require('org.numenta.sanity.plots_canvas');
goog.require('goog.dom');
goog.require('reagent.core');
goog.require('cljs.core.async');
goog.require('org.numenta.sanity.bridge.marshalling');
goog.require('org.numenta.sanity.selection');
goog.require('org.nfrac.comportex.core');
goog.require('tailrecursion.priority_map');
goog.require('org.nfrac.comportex.util');
goog.require('org.numenta.sanity.helpers');
goog.require('monet.canvas');
goog.require('clojure.string');

/**
 * @interface
 */
org.numenta.sanity.plots.PCompressible = function(){};

org.numenta.sanity.plots.compress = (function org$numenta$sanity$plots$compress(this$,factor){
if((!((this$ == null))) && (!((this$.org$numenta$sanity$plots$PCompressible$compress$arity$2 == null)))){
return this$.org$numenta$sanity$plots$PCompressible$compress$arity$2(this$,factor);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (org.numenta.sanity.plots.compress[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$2(this$,factor) : m__6809__auto__.call(null,this$,factor));
} else {
var m__6809__auto____$1 = (org.numenta.sanity.plots.compress["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$2(this$,factor) : m__6809__auto____$1.call(null,this$,factor));
} else {
throw cljs.core.missing_protocol("PCompressible.compress",this$);
}
}
}
});


/**
 * @interface
 */
org.numenta.sanity.plots.PBucketed = function(){};

org.numenta.sanity.plots.buckets = (function org$numenta$sanity$plots$buckets(this$){
if((!((this$ == null))) && (!((this$.org$numenta$sanity$plots$PBucketed$buckets$arity$1 == null)))){
return this$.org$numenta$sanity$plots$PBucketed$buckets$arity$1(this$);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (org.numenta.sanity.plots.buckets[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__6809__auto__.call(null,this$));
} else {
var m__6809__auto____$1 = (org.numenta.sanity.plots.buckets["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__6809__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("PBucketed.buckets",this$);
}
}
}
});

org.numenta.sanity.plots.bucket_size = (function org$numenta$sanity$plots$bucket_size(this$){
if((!((this$ == null))) && (!((this$.org$numenta$sanity$plots$PBucketed$bucket_size$arity$1 == null)))){
return this$.org$numenta$sanity$plots$PBucketed$bucket_size$arity$1(this$);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (org.numenta.sanity.plots.bucket_size[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__6809__auto__.call(null,this$));
} else {
var m__6809__auto____$1 = (org.numenta.sanity.plots.bucket_size["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__6809__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("PBucketed.bucket-size",this$);
}
}
}
});


/**
 * @interface
 */
org.numenta.sanity.plots.PCapped = function(){};

org.numenta.sanity.plots.max_count = (function org$numenta$sanity$plots$max_count(this$){
if((!((this$ == null))) && (!((this$.org$numenta$sanity$plots$PCapped$max_count$arity$1 == null)))){
return this$.org$numenta$sanity$plots$PCapped$max_count$arity$1(this$);
} else {
var x__6808__auto__ = (((this$ == null))?null:this$);
var m__6809__auto__ = (org.numenta.sanity.plots.max_count[goog.typeOf(x__6808__auto__)]);
if(!((m__6809__auto__ == null))){
return (m__6809__auto__.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__6809__auto__.call(null,this$));
} else {
var m__6809__auto____$1 = (org.numenta.sanity.plots.max_count["_"]);
if(!((m__6809__auto____$1 == null))){
return (m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1 ? m__6809__auto____$1.cljs$core$IFn$_invoke$arity$1(this$) : m__6809__auto____$1.call(null,this$));
} else {
throw cljs.core.missing_protocol("PCapped.max-count",this$);
}
}
}
});


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {org.numenta.sanity.plots.PBucketed}
 * @implements {org.numenta.sanity.plots.PCompressible}
*/
org.numenta.sanity.plots.SequenceCompressor = (function (bucket_size_STAR_,fcompress,xs,unfilled_bucket){
this.bucket_size_STAR_ = bucket_size_STAR_;
this.fcompress = fcompress;
this.xs = xs;
this.unfilled_bucket = unfilled_bucket;
this.cljs$lang$protocol_mask$partition0$ = 8388618;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
org.numenta.sanity.plots.SequenceCompressor.prototype.org$numenta$sanity$plots$PBucketed$ = true;

org.numenta.sanity.plots.SequenceCompressor.prototype.org$numenta$sanity$plots$PBucketed$bucket_size$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.bucket_size_STAR_;
});

org.numenta.sanity.plots.SequenceCompressor.prototype.org$numenta$sanity$plots$PBucketed$buckets$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.vec(self__.xs);
});

org.numenta.sanity.plots.SequenceCompressor.prototype.org$numenta$sanity$plots$PCompressible$ = true;

org.numenta.sanity.plots.SequenceCompressor.prototype.org$numenta$sanity$plots$PCompressible$compress$arity$2 = (function (_,factor){
var self__ = this;
var ___$1 = this;
return (new org.numenta.sanity.plots.SequenceCompressor((factor * self__.bucket_size_STAR_),self__.fcompress,cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.apply,self__.fcompress),cljs.core.partition.cljs$core$IFn$_invoke$arity$2(factor,self__.xs)),self__.unfilled_bucket));
});

org.numenta.sanity.plots.SequenceCompressor.prototype.cljs$core$ICollection$_conj$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
var bucket = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.unfilled_bucket,x);
if((cljs.core.count(bucket) < self__.bucket_size_STAR_)){
return (new org.numenta.sanity.plots.SequenceCompressor(self__.bucket_size_STAR_,self__.fcompress,self__.xs,bucket));
} else {
return (new org.numenta.sanity.plots.SequenceCompressor(self__.bucket_size_STAR_,self__.fcompress,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.xs,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.fcompress,bucket)),cljs.core.empty(self__.xs)));
}
});

org.numenta.sanity.plots.SequenceCompressor.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.count(self__.xs);
});

org.numenta.sanity.plots.SequenceCompressor.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(self__.xs);
});

org.numenta.sanity.plots.SequenceCompressor.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$bucket_DASH_size_STAR_,cljs.core.cst$sym$fcompress,cljs.core.cst$sym$xs,cljs.core.cst$sym$unfilled_DASH_bucket], null);
});

org.numenta.sanity.plots.SequenceCompressor.cljs$lang$type = true;

org.numenta.sanity.plots.SequenceCompressor.cljs$lang$ctorStr = "org.numenta.sanity.plots/SequenceCompressor";

org.numenta.sanity.plots.SequenceCompressor.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"org.numenta.sanity.plots/SequenceCompressor");
});

org.numenta.sanity.plots.__GT_SequenceCompressor = (function org$numenta$sanity$plots$__GT_SequenceCompressor(bucket_size_STAR_,fcompress,xs,unfilled_bucket){
return (new org.numenta.sanity.plots.SequenceCompressor(bucket_size_STAR_,fcompress,xs,unfilled_bucket));
});


/**
* @constructor
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {org.numenta.sanity.plots.PBucketed}
 * @implements {org.numenta.sanity.plots.PCompressible}
 * @implements {org.numenta.sanity.plots.PCapped}
*/
org.numenta.sanity.plots.SequenceCompressorCapped = (function (max_bucket_count,fcompress,seq_compressor){
this.max_bucket_count = max_bucket_count;
this.fcompress = fcompress;
this.seq_compressor = seq_compressor;
this.cljs$lang$protocol_mask$partition0$ = 8388618;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
org.numenta.sanity.plots.SequenceCompressorCapped.prototype.org$numenta$sanity$plots$PBucketed$ = true;

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.org$numenta$sanity$plots$PBucketed$bucket_size$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return org.numenta.sanity.plots.bucket_size(self__.seq_compressor);
});

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.org$numenta$sanity$plots$PBucketed$buckets$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return org.numenta.sanity.plots.buckets(self__.seq_compressor);
});

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.org$numenta$sanity$plots$PCompressible$ = true;

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.org$numenta$sanity$plots$PCompressible$compress$arity$2 = (function (_,factor){
var self__ = this;
var ___$1 = this;
return (new org.numenta.sanity.plots.SequenceCompressorCapped(self__.max_bucket_count,self__.fcompress,org.numenta.sanity.plots.compress(self__.seq_compressor,factor)));
});

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.org$numenta$sanity$plots$PCapped$ = true;

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.org$numenta$sanity$plots$PCapped$max_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.max_bucket_count;
});

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.cljs$core$ICollection$_conj$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
var r = (new org.numenta.sanity.plots.SequenceCompressorCapped(self__.max_bucket_count,self__.fcompress,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.seq_compressor,x)));
if((cljs.core.count(r) < self__.max_bucket_count)){
return r;
} else {
return r.org$numenta$sanity$plots$PCompressible$compress$arity$2(null,(2));
}
});

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.count(self__.seq_compressor);
});

org.numenta.sanity.plots.SequenceCompressorCapped.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(self__.seq_compressor);
});

org.numenta.sanity.plots.SequenceCompressorCapped.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$max_DASH_bucket_DASH_count,cljs.core.cst$sym$fcompress,cljs.core.cst$sym$seq_DASH_compressor], null);
});

org.numenta.sanity.plots.SequenceCompressorCapped.cljs$lang$type = true;

org.numenta.sanity.plots.SequenceCompressorCapped.cljs$lang$ctorStr = "org.numenta.sanity.plots/SequenceCompressorCapped";

org.numenta.sanity.plots.SequenceCompressorCapped.cljs$lang$ctorPrWriter = (function (this__6751__auto__,writer__6752__auto__,opt__6753__auto__){
return cljs.core._write(writer__6752__auto__,"org.numenta.sanity.plots/SequenceCompressorCapped");
});

org.numenta.sanity.plots.__GT_SequenceCompressorCapped = (function org$numenta$sanity$plots$__GT_SequenceCompressorCapped(max_bucket_count,fcompress,seq_compressor){
return (new org.numenta.sanity.plots.SequenceCompressorCapped(max_bucket_count,fcompress,seq_compressor));
});

/**
 * A sequence builder that does not necessarily grow on `conj`.
 *   Individual items are the result of compressing buckets of values
 *   into a single value. Compress the sequence or check its bucket size
 *   via methods. Specify a `max-bucket-count` to make it automatically
 *   recompress as it grows.
 * 
 *   Extract the compressed sequence via `seq` or `buckets`.
 * 
 *   `fcompress` must take an arbitrary number of args and must return a
 *   value of the same format, i.e. a value that will later be used as a
 *   fcompress arg.
 */
org.numenta.sanity.plots.sequence_compressor = (function org$numenta$sanity$plots$sequence_compressor(var_args){
var args59570 = [];
var len__7211__auto___59573 = arguments.length;
var i__7212__auto___59574 = (0);
while(true){
if((i__7212__auto___59574 < len__7211__auto___59573)){
args59570.push((arguments[i__7212__auto___59574]));

var G__59575 = (i__7212__auto___59574 + (1));
i__7212__auto___59574 = G__59575;
continue;
} else {
}
break;
}

var G__59572 = args59570.length;
switch (G__59572) {
case 1:
return org.numenta.sanity.plots.sequence_compressor.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return org.numenta.sanity.plots.sequence_compressor.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args59570.length)].join('')));

}
});

org.numenta.sanity.plots.sequence_compressor.cljs$core$IFn$_invoke$arity$1 = (function (fcompress){
return (new org.numenta.sanity.plots.SequenceCompressor((1),fcompress,cljs.core.PersistentVector.EMPTY,cljs.core.PersistentVector.EMPTY));
});

org.numenta.sanity.plots.sequence_compressor.cljs$core$IFn$_invoke$arity$2 = (function (max_bucket_count,fcompress){
return (new org.numenta.sanity.plots.SequenceCompressorCapped(max_bucket_count,fcompress,org.numenta.sanity.plots.sequence_compressor.cljs$core$IFn$_invoke$arity$1(fcompress)));
});

org.numenta.sanity.plots.sequence_compressor.cljs$lang$maxFixedArity = 2;
org.numenta.sanity.plots.mean = (function org$numenta$sanity$plots$mean(xs){
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,xs) / cljs.core.count(xs));
});
org.numenta.sanity.plots.aggregate_by = (function org$numenta$sanity$plots$aggregate_by(f,maps){
var ks = cljs.core.keys(cljs.core.first(maps));
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__6925__auto__ = ((function (ks){
return (function org$numenta$sanity$plots$aggregate_by_$_iter__59588(s__59589){
return (new cljs.core.LazySeq(null,((function (ks){
return (function (){
var s__59589__$1 = s__59589;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__59589__$1);
if(temp__4657__auto__){
var s__59589__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__59589__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__59589__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__59591 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__59590 = (0);
while(true){
if((i__59590 < size__6924__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__59590);
cljs.core.chunk_append(b__59591,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(function (){var G__59596 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (i__59590,k,c__6923__auto__,size__6924__auto__,b__59591,s__59589__$2,temp__4657__auto__,ks){
return (function (p1__59577_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__59577_SHARP_,k);
});})(i__59590,k,c__6923__auto__,size__6924__auto__,b__59591,s__59589__$2,temp__4657__auto__,ks))
,maps);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__59596) : f.call(null,G__59596));
})()], null));

var G__59598 = (i__59590 + (1));
i__59590 = G__59598;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__59591),org$numenta$sanity$plots$aggregate_by_$_iter__59588(cljs.core.chunk_rest(s__59589__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__59591),null);
}
} else {
var k = cljs.core.first(s__59589__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,(function (){var G__59597 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (k,s__59589__$2,temp__4657__auto__,ks){
return (function (p1__59577_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__59577_SHARP_,k);
});})(k,s__59589__$2,temp__4657__auto__,ks))
,maps);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__59597) : f.call(null,G__59597));
})()], null),org$numenta$sanity$plots$aggregate_by_$_iter__59588(cljs.core.rest(s__59589__$2)));
}
} else {
return null;
}
break;
}
});})(ks))
,null,null));
});})(ks))
;
return iter__6925__auto__(ks);
})());
});
org.numenta.sanity.plots.stacked_ts_plot = (function org$numenta$sanity$plots$stacked_ts_plot(ctx,col_state_freqs_log,series_keys,series_colors){
var bucket_size = org.numenta.sanity.plots.bucket_size(col_state_freqs_log);
var buckets = org.numenta.sanity.plots.buckets(col_state_freqs_log);
var n_timesteps = (bucket_size * org.numenta.sanity.plots.max_count(col_state_freqs_log));
var ncol = cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(cljs.core.peek(buckets));
var v_max = (ncol * 0.06);
var cnv = ctx.canvas;
var plot_size = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$w,(cnv.width - (25)),cljs.core.cst$kw$h,(cnv.height - (18))], null);
var plot = org.numenta.sanity.plots_canvas.xy_plot(ctx,plot_size,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),n_timesteps], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [v_max,(0)], null));
monet.canvas.clear_rect(ctx,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(0),cljs.core.cst$kw$w,cnv.width,cljs.core.cst$kw$h,cnv.height], null));

monet.canvas.stroke_width(ctx,(0));

var seq__59625_59651 = cljs.core.seq(org.numenta.sanity.plots_canvas.indexed(buckets));
var chunk__59626_59652 = null;
var count__59627_59653 = (0);
var i__59628_59654 = (0);
while(true){
if((i__59628_59654 < count__59627_59653)){
var vec__59629_59655 = chunk__59626_59652.cljs$core$IIndexed$_nth$arity$2(null,i__59628_59654);
var i_59656 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59629_59655,(0),null);
var x_59657 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59629_59655,(1),null);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (seq__59625_59651,chunk__59626_59652,count__59627_59653,i__59628_59654,vec__59629_59655,i_59656,x_59657,bucket_size,buckets,n_timesteps,ncol,v_max,cnv,plot_size,plot){
return (function (from_y,k){
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(x_59657,k);
monet.canvas.fill_style(ctx,(series_colors.cljs$core$IFn$_invoke$arity$1 ? series_colors.cljs$core$IFn$_invoke$arity$1(k) : series_colors.call(null,k)));

org.numenta.sanity.plots_canvas.rect_BANG_(plot,(i_59656 * bucket_size),from_y,bucket_size,val);

return (from_y + val);
});})(seq__59625_59651,chunk__59626_59652,count__59627_59653,i__59628_59654,vec__59629_59655,i_59656,x_59657,bucket_size,buckets,n_timesteps,ncol,v_max,cnv,plot_size,plot))
,(0),series_keys);

var G__59658 = seq__59625_59651;
var G__59659 = chunk__59626_59652;
var G__59660 = count__59627_59653;
var G__59661 = (i__59628_59654 + (1));
seq__59625_59651 = G__59658;
chunk__59626_59652 = G__59659;
count__59627_59653 = G__59660;
i__59628_59654 = G__59661;
continue;
} else {
var temp__4657__auto___59662 = cljs.core.seq(seq__59625_59651);
if(temp__4657__auto___59662){
var seq__59625_59663__$1 = temp__4657__auto___59662;
if(cljs.core.chunked_seq_QMARK_(seq__59625_59663__$1)){
var c__6956__auto___59664 = cljs.core.chunk_first(seq__59625_59663__$1);
var G__59665 = cljs.core.chunk_rest(seq__59625_59663__$1);
var G__59666 = c__6956__auto___59664;
var G__59667 = cljs.core.count(c__6956__auto___59664);
var G__59668 = (0);
seq__59625_59651 = G__59665;
chunk__59626_59652 = G__59666;
count__59627_59653 = G__59667;
i__59628_59654 = G__59668;
continue;
} else {
var vec__59630_59669 = cljs.core.first(seq__59625_59663__$1);
var i_59670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59630_59669,(0),null);
var x_59671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59630_59669,(1),null);
cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (seq__59625_59651,chunk__59626_59652,count__59627_59653,i__59628_59654,vec__59630_59669,i_59670,x_59671,seq__59625_59663__$1,temp__4657__auto___59662,bucket_size,buckets,n_timesteps,ncol,v_max,cnv,plot_size,plot){
return (function (from_y,k){
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(x_59671,k);
monet.canvas.fill_style(ctx,(series_colors.cljs$core$IFn$_invoke$arity$1 ? series_colors.cljs$core$IFn$_invoke$arity$1(k) : series_colors.call(null,k)));

org.numenta.sanity.plots_canvas.rect_BANG_(plot,(i_59670 * bucket_size),from_y,bucket_size,val);

return (from_y + val);
});})(seq__59625_59651,chunk__59626_59652,count__59627_59653,i__59628_59654,vec__59630_59669,i_59670,x_59671,seq__59625_59663__$1,temp__4657__auto___59662,bucket_size,buckets,n_timesteps,ncol,v_max,cnv,plot_size,plot))
,(0),series_keys);

var G__59672 = cljs.core.next(seq__59625_59663__$1);
var G__59673 = null;
var G__59674 = (0);
var G__59675 = (0);
seq__59625_59651 = G__59672;
chunk__59626_59652 = G__59673;
count__59627_59653 = G__59674;
i__59628_59654 = G__59675;
continue;
}
} else {
}
}
break;
}

org.numenta.sanity.plots_canvas.frame_BANG_(plot);

monet.canvas.fill_style(ctx,"black");

monet.canvas.stroke_style(ctx,"black");

monet.canvas.stroke_width(ctx,(1));

monet.canvas.text_baseline(ctx,cljs.core.cst$kw$top);

var seq__59631_59676 = cljs.core.seq(cljs.core.range.cljs$core$IFn$_invoke$arity$3((0),(n_timesteps + (1)),(n_timesteps / (8))));
var chunk__59633_59677 = null;
var count__59634_59678 = (0);
var i__59635_59679 = (0);
while(true){
if((i__59635_59679 < count__59634_59678)){
var x_59680 = chunk__59633_59677.cljs$core$IIndexed$_nth$arity$2(null,i__59635_59679);
var vec__59637_59681 = org.numenta.sanity.plots_canvas.__GT_px(plot,x_59680,(0));
var xpx_59682 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59637_59681,(0),null);
var ypx_59683 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59637_59681,(1),null);
var G__59638_59684 = ctx;
monet.canvas.begin_path(G__59638_59684);

monet.canvas.move_to(G__59638_59684,xpx_59682,ypx_59683);

monet.canvas.line_to(G__59638_59684,xpx_59682,(ypx_59683 + (5)));

monet.canvas.stroke(G__59638_59684);


monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,xpx_59682,cljs.core.cst$kw$y,(ypx_59683 + (5)),cljs.core.cst$kw$text,x_59680], null));

var G__59685 = seq__59631_59676;
var G__59686 = chunk__59633_59677;
var G__59687 = count__59634_59678;
var G__59688 = (i__59635_59679 + (1));
seq__59631_59676 = G__59685;
chunk__59633_59677 = G__59686;
count__59634_59678 = G__59687;
i__59635_59679 = G__59688;
continue;
} else {
var temp__4657__auto___59689 = cljs.core.seq(seq__59631_59676);
if(temp__4657__auto___59689){
var seq__59631_59690__$1 = temp__4657__auto___59689;
if(cljs.core.chunked_seq_QMARK_(seq__59631_59690__$1)){
var c__6956__auto___59691 = cljs.core.chunk_first(seq__59631_59690__$1);
var G__59692 = cljs.core.chunk_rest(seq__59631_59690__$1);
var G__59693 = c__6956__auto___59691;
var G__59694 = cljs.core.count(c__6956__auto___59691);
var G__59695 = (0);
seq__59631_59676 = G__59692;
chunk__59633_59677 = G__59693;
count__59634_59678 = G__59694;
i__59635_59679 = G__59695;
continue;
} else {
var x_59696 = cljs.core.first(seq__59631_59690__$1);
var vec__59639_59697 = org.numenta.sanity.plots_canvas.__GT_px(plot,x_59696,(0));
var xpx_59698 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59639_59697,(0),null);
var ypx_59699 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59639_59697,(1),null);
var G__59640_59700 = ctx;
monet.canvas.begin_path(G__59640_59700);

monet.canvas.move_to(G__59640_59700,xpx_59698,ypx_59699);

monet.canvas.line_to(G__59640_59700,xpx_59698,(ypx_59699 + (5)));

monet.canvas.stroke(G__59640_59700);


monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,xpx_59698,cljs.core.cst$kw$y,(ypx_59699 + (5)),cljs.core.cst$kw$text,x_59696], null));

var G__59701 = cljs.core.next(seq__59631_59690__$1);
var G__59702 = null;
var G__59703 = (0);
var G__59704 = (0);
seq__59631_59676 = G__59701;
chunk__59633_59677 = G__59702;
count__59634_59678 = G__59703;
i__59635_59679 = G__59704;
continue;
}
} else {
}
}
break;
}

monet.canvas.text_baseline(ctx,cljs.core.cst$kw$middle);

var labx = n_timesteps;
var seq__59641 = cljs.core.seq(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),0.02,0.04], null));
var chunk__59643 = null;
var count__59644 = (0);
var i__59645 = (0);
while(true){
if((i__59645 < count__59644)){
var f = chunk__59643.cljs$core$IIndexed$_nth$arity$2(null,i__59645);
var y_59705 = (ncol * f);
var vec__59647_59706 = org.numenta.sanity.plots_canvas.__GT_px(plot,labx,y_59705);
var xpx_59707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59647_59706,(0),null);
var ypx_59708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59647_59706,(1),null);
var G__59648_59709 = ctx;
monet.canvas.begin_path(G__59648_59709);

monet.canvas.move_to(G__59648_59709,xpx_59707,ypx_59708);

monet.canvas.line_to(G__59648_59709,(xpx_59707 + (5)),ypx_59708);

monet.canvas.stroke(G__59648_59709);


monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(xpx_59707 + (10)),cljs.core.cst$kw$y,ypx_59708,cljs.core.cst$kw$text,y_59705], null));

var G__59710 = seq__59641;
var G__59711 = chunk__59643;
var G__59712 = count__59644;
var G__59713 = (i__59645 + (1));
seq__59641 = G__59710;
chunk__59643 = G__59711;
count__59644 = G__59712;
i__59645 = G__59713;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq(seq__59641);
if(temp__4657__auto__){
var seq__59641__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__59641__$1)){
var c__6956__auto__ = cljs.core.chunk_first(seq__59641__$1);
var G__59714 = cljs.core.chunk_rest(seq__59641__$1);
var G__59715 = c__6956__auto__;
var G__59716 = cljs.core.count(c__6956__auto__);
var G__59717 = (0);
seq__59641 = G__59714;
chunk__59643 = G__59715;
count__59644 = G__59716;
i__59645 = G__59717;
continue;
} else {
var f = cljs.core.first(seq__59641__$1);
var y_59718 = (ncol * f);
var vec__59649_59719 = org.numenta.sanity.plots_canvas.__GT_px(plot,labx,y_59718);
var xpx_59720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59649_59719,(0),null);
var ypx_59721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59649_59719,(1),null);
var G__59650_59722 = ctx;
monet.canvas.begin_path(G__59650_59722);

monet.canvas.move_to(G__59650_59722,xpx_59720,ypx_59721);

monet.canvas.line_to(G__59650_59722,(xpx_59720 + (5)),ypx_59721);

monet.canvas.stroke(G__59650_59722);


monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(xpx_59720 + (10)),cljs.core.cst$kw$y,ypx_59721,cljs.core.cst$kw$text,y_59718], null));

var G__59723 = cljs.core.next(seq__59641__$1);
var G__59724 = null;
var G__59725 = (0);
var G__59726 = (0);
seq__59641 = G__59723;
chunk__59643 = G__59724;
count__59644 = G__59725;
i__59645 = G__59726;
continue;
}
} else {
return null;
}
}
break;
}
});
org.numenta.sanity.plots.empty_col_state_freqs_log = (function org$numenta$sanity$plots$empty_col_state_freqs_log(){
return org.numenta.sanity.plots.sequence_compressor.cljs$core$IFn$_invoke$arity$2((200),(function() { 
var G__59727__delegate = function (col_state_freqs_seq){
return org.numenta.sanity.plots.aggregate_by(org.numenta.sanity.plots.mean,col_state_freqs_seq);
};
var G__59727 = function (var_args){
var col_state_freqs_seq = null;
if (arguments.length > 0) {
var G__59728__i = 0, G__59728__a = new Array(arguments.length -  0);
while (G__59728__i < G__59728__a.length) {G__59728__a[G__59728__i] = arguments[G__59728__i + 0]; ++G__59728__i;}
  col_state_freqs_seq = new cljs.core.IndexedSeq(G__59728__a,0);
} 
return G__59727__delegate.call(this,col_state_freqs_seq);};
G__59727.cljs$lang$maxFixedArity = 0;
G__59727.cljs$lang$applyTo = (function (arglist__59729){
var col_state_freqs_seq = cljs.core.seq(arglist__59729);
return G__59727__delegate(col_state_freqs_seq);
});
G__59727.cljs$core$IFn$_invoke$arity$variadic = G__59727__delegate;
return G__59727;
})()
);
});
org.numenta.sanity.plots.ts_freqs_plot_cmp = (function org$numenta$sanity$plots$ts_freqs_plot_cmp(_,___$1){
var size_invalidates_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
return ((function (size_invalidates_c){
return (function (col_state_freqs_log,series_colors){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.helpers.window_resize_listener,size_invalidates_c], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.helpers.resizing_canvas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,"100%",cljs.core.cst$kw$height,(180)], null)], null),cljs.core.PersistentVector.EMPTY,((function (size_invalidates_c){
return (function (ctx){
return org.numenta.sanity.plots.stacked_ts_plot(ctx,col_state_freqs_log,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$active,cljs.core.cst$kw$active_DASH_predicted,cljs.core.cst$kw$predicted], null),series_colors);
});})(size_invalidates_c))
,size_invalidates_c], null)], null);
});
;})(size_invalidates_c))
});
org.numenta.sanity.plots.excitation_colors = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$proximal_DASH_unstable,cljs.core.cst$kw$active,cljs.core.cst$kw$proximal_DASH_stable,cljs.core.cst$kw$active_DASH_predicted,cljs.core.cst$kw$boost,cljs.core.cst$kw$highlight,cljs.core.cst$kw$distal,cljs.core.cst$kw$predicted], null);
org.numenta.sanity.plots.excitation_order = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$proximal_DASH_unstable,cljs.core.cst$kw$proximal_DASH_stable,cljs.core.cst$kw$boost,cljs.core.cst$kw$distal], null);
org.numenta.sanity.plots.viz_rgn_shades = (function org$numenta$sanity$plots$viz_rgn_shades(network_shape){
var srcs = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.keys(cljs.core.cst$kw$senses.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape)))),cljs.core.keys(cljs.core.cst$kw$regions.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape)))));
return cljs.core.zipmap(srcs,cljs.core.range.cljs$core$IFn$_invoke$arity$3(-0.3,0.31,(1.0 / cljs.core.count(srcs))));
});
org.numenta.sanity.plots.abs = (function org$numenta$sanity$plots$abs(x){
if((x < (0))){
return (- x);
} else {
return x;
}
});
org.numenta.sanity.plots.draw_cell_excitation_plot_BANG_ = (function org$numenta$sanity$plots$draw_cell_excitation_plot_BANG_(ctx,breakdowns,network_shape,sel_col,series_colors){
var width_px = ctx.canvas.width;
var height_px = ctx.canvas.height;
var plot_size = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$w,width_px,cljs.core.cst$kw$h,(200)], null);
var src_shades = org.numenta.sanity.plots.viz_rgn_shades(network_shape);
var y_max = (1.1 * cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$total,cljs.core.vals(breakdowns))));
var x_lim = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [-0.5,(cljs.core.count(breakdowns) + (3))], null);
var y_lim = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [y_max,(0)], null);
var bot_lab_y = (- (y_max * 0.02));
var draw_cell_bar = ((function (width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y){
return (function (plot,x_coord,bd,labels_QMARK_){
var series = (function (){var iter__6925__auto__ = ((function (width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y){
return (function org$numenta$sanity$plots$draw_cell_excitation_plot_BANG__$_iter__59765(s__59766){
return (new cljs.core.LazySeq(null,((function (width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y){
return (function (){
var s__59766__$1 = s__59766;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__59766__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var k = cljs.core.first(xs__5205__auto__);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(bd,k);
var iterys__6921__auto__ = ((function (s__59766__$1,v,k,xs__5205__auto__,temp__4657__auto__,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y){
return (function org$numenta$sanity$plots$draw_cell_excitation_plot_BANG__$_iter__59765_$_iter__59767(s__59768){
return (new cljs.core.LazySeq(null,((function (s__59766__$1,v,k,xs__5205__auto__,temp__4657__auto__,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y){
return (function (){
var s__59768__$1 = s__59768;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__59768__$1);
if(temp__4657__auto____$1){
var s__59768__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__59768__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__59768__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__59770 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__59769 = (0);
while(true){
if((i__59769 < size__6924__auto__)){
var vec__59782 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__59769);
var src = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59782,(0),null);
var z = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59782,(1),null);
if(cljs.core.truth_((function (){var and__6141__auto__ = z;
if(cljs.core.truth_(and__6141__auto__)){
return (z > (0));
} else {
return and__6141__auto__;
}
})())){
cljs.core.chunk_append(b__59770,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,src,z], null));

var G__59798 = (i__59769 + (1));
i__59769 = G__59798;
continue;
} else {
var G__59799 = (i__59769 + (1));
i__59769 = G__59799;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__59770),org$numenta$sanity$plots$draw_cell_excitation_plot_BANG__$_iter__59765_$_iter__59767(cljs.core.chunk_rest(s__59768__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__59770),null);
}
} else {
var vec__59783 = cljs.core.first(s__59768__$2);
var src = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59783,(0),null);
var z = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59783,(1),null);
if(cljs.core.truth_((function (){var and__6141__auto__ = z;
if(cljs.core.truth_(and__6141__auto__)){
return (z > (0));
} else {
return and__6141__auto__;
}
})())){
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,src,z], null),org$numenta$sanity$plots$draw_cell_excitation_plot_BANG__$_iter__59765_$_iter__59767(cljs.core.rest(s__59768__$2)));
} else {
var G__59800 = cljs.core.rest(s__59768__$2);
s__59768__$1 = G__59800;
continue;
}
}
} else {
return null;
}
break;
}
});})(s__59766__$1,v,k,xs__5205__auto__,temp__4657__auto__,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y))
,null,null));
});})(s__59766__$1,v,k,xs__5205__auto__,temp__4657__auto__,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(((cljs.core.map_QMARK_(v))?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(src_shades,cljs.core.key),v):new cljs.core.PersistentArrayMap(null, 1, [null,v], null))));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$numenta$sanity$plots$draw_cell_excitation_plot_BANG__$_iter__59765(cljs.core.rest(s__59766__$1)));
} else {
var G__59801 = cljs.core.rest(s__59766__$1);
s__59766__$1 = G__59801;
continue;
}
} else {
return null;
}
break;
}
});})(width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y))
,null,null));
});})(width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y))
;
return iter__6925__auto__(org.numenta.sanity.plots.excitation_order);
})();
monet.canvas.stroke_style(ctx,"black");

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (series,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y){
return (function (offset,p__59784){
var vec__59785 = p__59784;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59785,(0),null);
var src = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59785,(1),null);
var z = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59785,(2),null);
var color = (org.numenta.sanity.plots.excitation_colors.cljs$core$IFn$_invoke$arity$1 ? org.numenta.sanity.plots.excitation_colors.cljs$core$IFn$_invoke$arity$1(k) : org.numenta.sanity.plots.excitation_colors.call(null,k));
var shade = (cljs.core.truth_(src)?(src_shades.cljs$core$IFn$_invoke$arity$1 ? src_shades.cljs$core$IFn$_invoke$arity$1(src) : src_shades.call(null,src)):0.0);
monet.canvas.fill_style(ctx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(series_colors,color));

org.numenta.sanity.plots_canvas.rect_BANG_(plot,x_coord,offset,0.5,z);

if((shade === (0))){
} else {
monet.canvas.fill_style(ctx,(((shade > (0)))?"white":"black"));

monet.canvas.alpha(ctx,org.numenta.sanity.plots.abs(shade));

org.numenta.sanity.plots_canvas.rect_BANG_(plot,x_coord,offset,0.25,z);

monet.canvas.alpha(ctx,1.0);
}

var y_top_59802 = (offset + z);
org.numenta.sanity.plots_canvas.line_BANG_(plot,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_coord + 0.05),y_top_59802], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(x_coord + 0.45),y_top_59802], null)], null));

if(cljs.core.truth_(labels_QMARK_)){
monet.canvas.fill_style(ctx,"black");

var labs_59803 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name(k),/-/),(cljs.core.truth_(src)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str("("),cljs.core.str(cljs.core.name(src)),cljs.core.str(")")].join('')], null):null));
org.numenta.sanity.plots_canvas.texts_BANG_(plot,(x_coord + 0.5),(offset + (0.5 * z)),labs_59803,(10));
} else {
}

return (offset + (function (){var or__6153__auto__ = z;
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return (0);
}
})());
});})(series,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y))
,0.0,series);
});})(width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y))
;
monet.canvas.save(ctx);

monet.canvas.clear_rect(ctx,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(0),cljs.core.cst$kw$w,width_px,cljs.core.cst$kw$h,height_px], null));

monet.canvas.stroke_width(ctx,0.5);

var plot_59804 = org.numenta.sanity.plots_canvas.xy_plot(ctx,plot_size,x_lim,y_lim);
var seq__59786_59805 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$total,cljs.core.val),cljs.core._GT_,cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.key,breakdowns))));
var chunk__59788_59806 = null;
var count__59789_59807 = (0);
var i__59790_59808 = (0);
while(true){
if((i__59790_59808 < count__59789_59807)){
var vec__59792_59809 = chunk__59788_59806.cljs$core$IIndexed$_nth$arity$2(null,i__59790_59808);
var i_59810 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59792_59809,(0),null);
var vec__59793_59811 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59792_59809,(1),null);
var cell_id_59812 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59793_59811,(0),null);
var bd_59813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59793_59811,(1),null);
var x_coord_59814 = i_59810;
var vec__59794_59815 = cell_id_59812;
var col_59816 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59794_59815,(0),null);
var __59817 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59794_59815,(1),null);
var total_exc_59818 = cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(bd_59813);
draw_cell_bar(plot_59804,x_coord_59814,bd_59813,false);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(col_59816,sel_col)){
monet.canvas.fill_style(ctx,cljs.core.cst$kw$highlight.cljs$core$IFn$_invoke$arity$1(series_colors));

org.numenta.sanity.plots_canvas.rect_BANG_(plot_59804,(x_coord_59814 - 0.25),(-100),1.0,(100));
} else {
}

monet.canvas.fill_style(ctx,"black");

org.numenta.sanity.plots_canvas.text_BANG_(plot_59804,x_coord_59814,(total_exc_59818 + 0.5),total_exc_59818);

org.numenta.sanity.plots_canvas.text_rotated_BANG_(plot_59804,x_coord_59814,bot_lab_y,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(col_59816,sel_col))?cell_id_59812:col_59816));

var G__59819 = seq__59786_59805;
var G__59820 = chunk__59788_59806;
var G__59821 = count__59789_59807;
var G__59822 = (i__59790_59808 + (1));
seq__59786_59805 = G__59819;
chunk__59788_59806 = G__59820;
count__59789_59807 = G__59821;
i__59790_59808 = G__59822;
continue;
} else {
var temp__4657__auto___59823 = cljs.core.seq(seq__59786_59805);
if(temp__4657__auto___59823){
var seq__59786_59824__$1 = temp__4657__auto___59823;
if(cljs.core.chunked_seq_QMARK_(seq__59786_59824__$1)){
var c__6956__auto___59825 = cljs.core.chunk_first(seq__59786_59824__$1);
var G__59826 = cljs.core.chunk_rest(seq__59786_59824__$1);
var G__59827 = c__6956__auto___59825;
var G__59828 = cljs.core.count(c__6956__auto___59825);
var G__59829 = (0);
seq__59786_59805 = G__59826;
chunk__59788_59806 = G__59827;
count__59789_59807 = G__59828;
i__59790_59808 = G__59829;
continue;
} else {
var vec__59795_59830 = cljs.core.first(seq__59786_59824__$1);
var i_59831 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59795_59830,(0),null);
var vec__59796_59832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59795_59830,(1),null);
var cell_id_59833 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59796_59832,(0),null);
var bd_59834 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59796_59832,(1),null);
var x_coord_59835 = i_59831;
var vec__59797_59836 = cell_id_59833;
var col_59837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59797_59836,(0),null);
var __59838 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59797_59836,(1),null);
var total_exc_59839 = cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(bd_59834);
draw_cell_bar(plot_59804,x_coord_59835,bd_59834,false);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(col_59837,sel_col)){
monet.canvas.fill_style(ctx,cljs.core.cst$kw$highlight.cljs$core$IFn$_invoke$arity$1(series_colors));

org.numenta.sanity.plots_canvas.rect_BANG_(plot_59804,(x_coord_59835 - 0.25),(-100),1.0,(100));
} else {
}

monet.canvas.fill_style(ctx,"black");

org.numenta.sanity.plots_canvas.text_BANG_(plot_59804,x_coord_59835,(total_exc_59839 + 0.5),total_exc_59839);

org.numenta.sanity.plots_canvas.text_rotated_BANG_(plot_59804,x_coord_59835,bot_lab_y,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(col_59837,sel_col))?cell_id_59833:col_59837));

var G__59840 = cljs.core.next(seq__59786_59824__$1);
var G__59841 = null;
var G__59842 = (0);
var G__59843 = (0);
seq__59786_59805 = G__59840;
chunk__59788_59806 = G__59841;
count__59789_59807 = G__59842;
i__59790_59808 = G__59843;
continue;
}
} else {
}
}
break;
}

var sep_x_59844 = cljs.core.count(breakdowns);
var leg_x_59845 = (sep_x_59844 + (1));
var key_bd_STAR__59846 = org.nfrac.comportex.core.update_excitation_breakdown.cljs$core$IFn$_invoke$arity$2(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(org.nfrac.comportex.util.deep_merge_with,cljs.core._PLUS_,cljs.core.vals(breakdowns)),((function (sep_x_59844,leg_x_59845,plot_59804,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y,draw_cell_bar){
return (function (p1__59730_SHARP_){
if((p1__59730_SHARP_ > (0))){
return 1.0;
} else {
return 0.0;
}
});})(sep_x_59844,leg_x_59845,plot_59804,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y,draw_cell_bar))
);
var key_bd_59847 = org.nfrac.comportex.core.update_excitation_breakdown.cljs$core$IFn$_invoke$arity$2(key_bd_STAR__59846,((function (sep_x_59844,leg_x_59845,key_bd_STAR__59846,plot_59804,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y,draw_cell_bar){
return (function (p1__59731_SHARP_){
return (p1__59731_SHARP_ * (y_max / cljs.core.cst$kw$total.cljs$core$IFn$_invoke$arity$1(key_bd_STAR__59846)));
});})(sep_x_59844,leg_x_59845,key_bd_STAR__59846,plot_59804,width_px,height_px,plot_size,src_shades,y_max,x_lim,y_lim,bot_lab_y,draw_cell_bar))
);
monet.canvas.fill_style(ctx,cljs.core.cst$kw$background.cljs$core$IFn$_invoke$arity$1(series_colors));

org.numenta.sanity.plots_canvas.rect_BANG_(plot_59804,sep_x_59844,(0),(cljs.core.second(x_lim) - sep_x_59844),y_max);

monet.canvas.text_align(ctx,cljs.core.cst$kw$center);

draw_cell_bar(plot_59804,leg_x_59845,key_bd_59847,true);

monet.canvas.fill_style(ctx,"black");

monet.canvas.text_align(ctx,cljs.core.cst$kw$left);

org.numenta.sanity.plots_canvas.text_rotated_BANG_(plot_59804,leg_x_59845,bot_lab_y,"KEY");

monet.canvas.stroke_width(ctx,(1));

org.numenta.sanity.plots_canvas.frame_BANG_(plot_59804);

return monet.canvas.restore(ctx);
});
org.numenta.sanity.plots.fetch_excitation_data_BANG_ = (function org$numenta$sanity$plots$fetch_excitation_data_BANG_(excitation_data,region_key,layer_id,sels,into_journal){
var sel1 = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(org.numenta.sanity.selection.layer,sels));
var bit = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(org.numenta.sanity.selection.layer(sel1),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [region_key,layer_id], null)))?cljs.core.cst$kw$bit.cljs$core$IFn$_invoke$arity$1(sel1):null);
var temp__4655__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(sel1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$step,cljs.core.cst$kw$snapshot_DASH_id], null));
if(cljs.core.truth_(temp__4655__auto__)){
var snapshot_id = temp__4655__auto__;
var response_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["get-cell-excitation-data",snapshot_id,region_key,layer_id,bit,org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c,true)], null));

var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__,response_c,snapshot_id,temp__4655__auto__,sel1,bit){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__,response_c,snapshot_id,temp__4655__auto__,sel1,bit){
return (function (state_59867){
var state_val_59868 = (state_59867[(1)]);
if((state_val_59868 === (1))){
var state_59867__$1 = state_59867;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_59867__$1,(2),response_c);
} else {
if((state_val_59868 === (2))){
var inst_59864 = (state_59867[(2)]);
var inst_59865 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(excitation_data,inst_59864) : cljs.core.reset_BANG_.call(null,excitation_data,inst_59864));
var state_59867__$1 = state_59867;
return cljs.core.async.impl.ioc_helpers.return_chan(state_59867__$1,inst_59865);
} else {
return null;
}
}
});})(c__38109__auto__,response_c,snapshot_id,temp__4655__auto__,sel1,bit))
;
return ((function (switch__37995__auto__,c__38109__auto__,response_c,snapshot_id,temp__4655__auto__,sel1,bit){
return (function() {
var org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto__ = null;
var org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto____0 = (function (){
var statearr_59872 = [null,null,null,null,null,null,null];
(statearr_59872[(0)] = org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto__);

(statearr_59872[(1)] = (1));

return statearr_59872;
});
var org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto____1 = (function (state_59867){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_59867);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e59873){if((e59873 instanceof Object)){
var ex__37999__auto__ = e59873;
var statearr_59874_59878 = state_59867;
(statearr_59874_59878[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_59867);

return cljs.core.cst$kw$recur;
} else {
throw e59873;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__59879 = state_59867;
state_59867 = G__59879;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto__ = function(state_59867){
switch(arguments.length){
case 0:
return org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto____1.call(this,state_59867);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto____0;
org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto____1;
return org$numenta$sanity$plots$fetch_excitation_data_BANG__$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__,response_c,snapshot_id,temp__4655__auto__,sel1,bit))
})();
var state__38111__auto__ = (function (){var statearr_59875 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_59875[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_59875;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__,response_c,snapshot_id,temp__4655__auto__,sel1,bit))
);

return c__38109__auto__;
} else {
var G__59876 = excitation_data;
var G__59877 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__59876,G__59877) : cljs.core.reset_BANG_.call(null,G__59876,G__59877));
}
});
org.numenta.sanity.plots.cell_excitation_plot_cmp = (function org$numenta$sanity$plots$cell_excitation_plot_cmp(_,selection,___$1,region_key,layer_id,into_journal){
var excitation_data = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_will_DASH_mount,((function (excitation_data){
return (function (___$2){
cljs.core.add_watch(selection,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$org$numenta$sanity$plots_SLASH_fetch_DASH_excitation_DASH_data,region_key,layer_id], null),((function (excitation_data){
return (function (___$3,___$4,___$5,sels){
return org.numenta.sanity.plots.fetch_excitation_data_BANG_(excitation_data,region_key,layer_id,sels,into_journal);
});})(excitation_data))
);

return org.numenta.sanity.plots.fetch_excitation_data_BANG_(excitation_data,region_key,layer_id,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selection) : cljs.core.deref.call(null,selection)),into_journal);
});})(excitation_data))
,cljs.core.cst$kw$component_DASH_will_DASH_unmount,((function (excitation_data){
return (function (___$2){
return cljs.core.remove_watch(selection,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$org$numenta$sanity$plots_SLASH_fetch_DASH_excitation_DASH_data,region_key,layer_id], null));
});})(excitation_data))
,cljs.core.cst$kw$reagent_DASH_render,(function (){var size_invalidates_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
return ((function (size_invalidates_c,excitation_data){
return (function (network_shape,___$2,series_colors,region_key__$1,layer_id__$1,___$3,___$4){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.helpers.window_resize_listener,size_invalidates_c], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.helpers.resizing_canvas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,"100%",cljs.core.cst$kw$height,"240px"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [excitation_data], null),((function (size_invalidates_c,excitation_data){
return (function (ctx){
var sel = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(org.numenta.sanity.selection.layer,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selection) : cljs.core.deref.call(null,selection))));
var bit = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(org.numenta.sanity.selection.layer(sel),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [region_key__$1,layer_id__$1], null)))?cljs.core.cst$kw$bit.cljs$core$IFn$_invoke$arity$1(sel):null);
return org.numenta.sanity.plots.draw_cell_excitation_plot_BANG_(ctx,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(excitation_data) : cljs.core.deref.call(null,excitation_data)),network_shape,bit,series_colors);
});})(size_invalidates_c,excitation_data))
,size_invalidates_c], null)], null);
});
;})(size_invalidates_c,excitation_data))
})()], null));
});
org.numenta.sanity.plots.draw_cell_sdrs_plot_BANG__STAR_ = (function org$numenta$sanity$plots$draw_cell_sdrs_plot_BANG__STAR_(ctx,p__59880,p__59881){
var map__59956 = p__59880;
var map__59956__$1 = ((((!((map__59956 == null)))?((((map__59956.cljs$lang$protocol_mask$partition0$ & (64))) || (map__59956.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__59956):map__59956);
var plot_data = map__59956__$1;
var sdr_label_counts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$sdr_DASH_label_DASH_counts);
var sdr_growth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$sdr_DASH_growth);
var hit_counts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$hit_DASH_counts);
var kept_sdrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$kept_DASH_sdrs);
var timestep = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$timestep);
var title = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$title);
var threshold = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$threshold);
var sdr_transitions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$sdr_DASH_transitions);
var sdr_sizes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$sdr_DASH_sizes);
var sdr_votes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59956__$1,cljs.core.cst$kw$sdr_DASH_votes);
var map__59957 = p__59881;
var map__59957__$1 = ((((!((map__59957 == null)))?((((map__59957.cljs$lang$protocol_mask$partition0$ & (64))) || (map__59957.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__59957):map__59957);
var plot_opts = map__59957__$1;
var group_contexts_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59957__$1,cljs.core.cst$kw$group_DASH_contexts_QMARK_);
var ordering = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59957__$1,cljs.core.cst$kw$ordering);
var hide_conns_smaller = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__59957__$1,cljs.core.cst$kw$hide_DASH_conns_DASH_smaller);
var wc_sdrv = cljs.core.cst$kw$winners.cljs$core$IFn$_invoke$arity$1(sdr_votes);
var ac_sdrv = cljs.core.cst$kw$active.cljs$core$IFn$_invoke$arity$1(sdr_votes);
var pc_sdrv = cljs.core.cst$kw$pred.cljs$core$IFn$_invoke$arity$1(sdr_votes);
var kept_sdr_QMARK_ = cljs.core.set(kept_sdrs);
var sdr_label_counts_STAR_ = cljs.core.select_keys(sdr_label_counts,kept_sdrs);
var gap = threshold;
var vec__59960 = (function (){var sdrs = (function (){var G__59961 = (((ordering instanceof cljs.core.Keyword))?ordering.fqn:null);
switch (G__59961) {
case "first-appearance":
return cljs.core.sort.cljs$core$IFn$_invoke$arity$1(kept_sdrs);

break;
case "last-appearance":
return kept_sdrs;

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(ordering)].join('')));

}
})();
var m = cljs.core.PersistentArrayMap.EMPTY;
var offset = (0);
while(true){
var temp__4655__auto__ = cljs.core.first(sdrs);
if(cljs.core.truth_(temp__4655__auto__)){
var sdr = temp__4655__auto__;
var dy = (sdr_sizes.cljs$core$IFn$_invoke$arity$1 ? sdr_sizes.cljs$core$IFn$_invoke$arity$1(sdr) : sdr_sizes.call(null,sdr));
var gy = (sdr_growth.cljs$core$IFn$_invoke$arity$2 ? sdr_growth.cljs$core$IFn$_invoke$arity$2(sdr,(0)) : sdr_growth.call(null,sdr,(0)));
var ord = ((offset + gap) + (dy / (2)));
var G__60031 = cljs.core.rest(sdrs);
var G__60032 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,sdr,ord);
var G__60033 = (((offset + gap) + dy) + gy);
sdrs = G__60031;
m = G__60032;
offset = G__60033;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [m,offset], null);
}
break;
}
})();
var sdr_ordinate = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59960,(0),null);
var y_max = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59960,(1),null);
var title_px = (16);
var hits_w_px = (30);
var full_width_px = ctx.canvas.width;
var width_px = (full_width_px - hits_w_px);
var full_height_px = ctx.canvas.height;
var height_px = (full_height_px - title_px);
var y_scale = (height_px / (function (){var x__6484__auto__ = ((50) * gap);
var y__6485__auto__ = (y_max + gap);
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})());
var sdr_max_count = (function (){var x__6484__auto__ = (5);
var y__6485__auto__ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (x__6484__auto__,wc_sdrv,ac_sdrv,pc_sdrv,kept_sdr_QMARK_,sdr_label_counts_STAR_,gap,vec__59960,sdr_ordinate,y_max,title_px,hits_w_px,full_width_px,width_px,full_height_px,height_px,y_scale,map__59956,map__59956__$1,plot_data,sdr_label_counts,sdr_growth,hit_counts,kept_sdrs,timestep,title,threshold,sdr_transitions,sdr_sizes,sdr_votes,map__59957,map__59957__$1,plot_opts,group_contexts_QMARK_,ordering,hide_conns_smaller){
return (function (label_counts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(label_counts));
});})(x__6484__auto__,wc_sdrv,ac_sdrv,pc_sdrv,kept_sdr_QMARK_,sdr_label_counts_STAR_,gap,vec__59960,sdr_ordinate,y_max,title_px,hits_w_px,full_width_px,width_px,full_height_px,height_px,y_scale,map__59956,map__59956__$1,plot_data,sdr_label_counts,sdr_growth,hit_counts,kept_sdrs,timestep,title,threshold,sdr_transitions,sdr_sizes,sdr_votes,map__59957,map__59957__$1,plot_opts,group_contexts_QMARK_,ordering,hide_conns_smaller))
,cljs.core.vals(sdr_label_counts_STAR_)));
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})();
var x_scale = (width_px / sdr_max_count);
var mid_x = cljs.core.quot(width_px,(2));
var label_width = (50);
monet.canvas.save(ctx);

monet.canvas.clear_rect(ctx,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,(0),cljs.core.cst$kw$w,full_width_px,cljs.core.cst$kw$h,full_height_px], null));

monet.canvas.translate(ctx,(mid_x + hits_w_px),title_px);

var title_y_60034 = (0);
monet.canvas.text_align(ctx,cljs.core.cst$kw$center);

monet.canvas.text_baseline(ctx,cljs.core.cst$kw$bottom);

monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(0),cljs.core.cst$kw$y,title_y_60034,cljs.core.cst$kw$text,title], null));

monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(mid_x * 0.8),cljs.core.cst$kw$y,title_y_60034,cljs.core.cst$kw$text,"forward"], null));

monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(- (mid_x * 0.8)),cljs.core.cst$kw$y,title_y_60034,cljs.core.cst$kw$text,"back"], null));

monet.canvas.stroke_style(ctx,"hsl(210,50%,50%)");

var seq__59962_60035 = cljs.core.seq(sdr_transitions);
var chunk__59975_60036 = null;
var count__59976_60037 = (0);
var i__59977_60038 = (0);
while(true){
if((i__59977_60038 < count__59976_60037)){
var vec__59990_60039 = chunk__59975_60036.cljs$core$IIndexed$_nth$arity$2(null,i__59977_60038);
var from_sdr_60040 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59990_60039,(0),null);
var to_sdrs_counts_60041 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59990_60039,(1),null);
if(cljs.core.truth_((kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1 ? kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1(from_sdr_60040) : kept_sdr_QMARK_.call(null,from_sdr_60040)))){
var from_y_60042 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(from_sdr_60040) : sdr_ordinate.call(null,from_sdr_60040)));
var seq__59980_60043 = cljs.core.seq(to_sdrs_counts_60041);
var chunk__59984_60044 = null;
var count__59985_60045 = (0);
var i__59986_60046 = (0);
while(true){
if((i__59986_60046 < count__59985_60045)){
var vec__59991_60047 = chunk__59984_60044.cljs$core$IIndexed$_nth$arity$2(null,i__59986_60046);
var to_sdr_60048 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59991_60047,(0),null);
var to_sdr_count_60049 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59991_60047,(1),null);
if(cljs.core.truth_((kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1 ? kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1(to_sdr_60048) : kept_sdr_QMARK_.call(null,to_sdr_60048)))){
if((to_sdr_count_60049 >= hide_conns_smaller)){
var to_y_60050 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(to_sdr_60048) : sdr_ordinate.call(null,to_sdr_60048)));
var mid_y_60051 = ((to_y_60050 + from_y_60042) / (2));
var off_x_60052 = ((1.0 * width_px) * ((to_y_60050 - from_y_60042) / height_px));
var G__59992_60053 = ctx;
monet.canvas.stroke_width(G__59992_60053,(function (){var x__6491__auto__ = ((to_sdr_count_60049 / threshold) * (4));
var y__6492__auto__ = (6);
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
})());

monet.canvas.begin_path(G__59992_60053);

monet.canvas.move_to(G__59992_60053,(0),from_y_60042);

monet.canvas.quadratic_curve_to.cljs$core$IFn$_invoke$arity$5(G__59992_60053,off_x_60052,mid_y_60051,(0),to_y_60050);

monet.canvas.stroke(G__59992_60053);


var G__60054 = seq__59980_60043;
var G__60055 = chunk__59984_60044;
var G__60056 = count__59985_60045;
var G__60057 = (i__59986_60046 + (1));
seq__59980_60043 = G__60054;
chunk__59984_60044 = G__60055;
count__59985_60045 = G__60056;
i__59986_60046 = G__60057;
continue;
} else {
var G__60058 = seq__59980_60043;
var G__60059 = chunk__59984_60044;
var G__60060 = count__59985_60045;
var G__60061 = (i__59986_60046 + (1));
seq__59980_60043 = G__60058;
chunk__59984_60044 = G__60059;
count__59985_60045 = G__60060;
i__59986_60046 = G__60061;
continue;
}
} else {
var G__60062 = seq__59980_60043;
var G__60063 = chunk__59984_60044;
var G__60064 = count__59985_60045;
var G__60065 = (i__59986_60046 + (1));
seq__59980_60043 = G__60062;
chunk__59984_60044 = G__60063;
count__59985_60045 = G__60064;
i__59986_60046 = G__60065;
continue;
}
} else {
var temp__4657__auto___60066 = cljs.core.seq(seq__59980_60043);
if(temp__4657__auto___60066){
var seq__59980_60067__$1 = temp__4657__auto___60066;
if(cljs.core.chunked_seq_QMARK_(seq__59980_60067__$1)){
var c__6956__auto___60068 = cljs.core.chunk_first(seq__59980_60067__$1);
var G__60069 = cljs.core.chunk_rest(seq__59980_60067__$1);
var G__60070 = c__6956__auto___60068;
var G__60071 = cljs.core.count(c__6956__auto___60068);
var G__60072 = (0);
seq__59980_60043 = G__60069;
chunk__59984_60044 = G__60070;
count__59985_60045 = G__60071;
i__59986_60046 = G__60072;
continue;
} else {
var vec__59993_60073 = cljs.core.first(seq__59980_60067__$1);
var to_sdr_60074 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59993_60073,(0),null);
var to_sdr_count_60075 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59993_60073,(1),null);
if(cljs.core.truth_((kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1 ? kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1(to_sdr_60074) : kept_sdr_QMARK_.call(null,to_sdr_60074)))){
if((to_sdr_count_60075 >= hide_conns_smaller)){
var to_y_60076 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(to_sdr_60074) : sdr_ordinate.call(null,to_sdr_60074)));
var mid_y_60077 = ((to_y_60076 + from_y_60042) / (2));
var off_x_60078 = ((1.0 * width_px) * ((to_y_60076 - from_y_60042) / height_px));
var G__59994_60079 = ctx;
monet.canvas.stroke_width(G__59994_60079,(function (){var x__6491__auto__ = ((to_sdr_count_60075 / threshold) * (4));
var y__6492__auto__ = (6);
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
})());

monet.canvas.begin_path(G__59994_60079);

monet.canvas.move_to(G__59994_60079,(0),from_y_60042);

monet.canvas.quadratic_curve_to.cljs$core$IFn$_invoke$arity$5(G__59994_60079,off_x_60078,mid_y_60077,(0),to_y_60076);

monet.canvas.stroke(G__59994_60079);


var G__60080 = cljs.core.next(seq__59980_60067__$1);
var G__60081 = null;
var G__60082 = (0);
var G__60083 = (0);
seq__59980_60043 = G__60080;
chunk__59984_60044 = G__60081;
count__59985_60045 = G__60082;
i__59986_60046 = G__60083;
continue;
} else {
var G__60084 = cljs.core.next(seq__59980_60067__$1);
var G__60085 = null;
var G__60086 = (0);
var G__60087 = (0);
seq__59980_60043 = G__60084;
chunk__59984_60044 = G__60085;
count__59985_60045 = G__60086;
i__59986_60046 = G__60087;
continue;
}
} else {
var G__60088 = cljs.core.next(seq__59980_60067__$1);
var G__60089 = null;
var G__60090 = (0);
var G__60091 = (0);
seq__59980_60043 = G__60088;
chunk__59984_60044 = G__60089;
count__59985_60045 = G__60090;
i__59986_60046 = G__60091;
continue;
}
}
} else {
}
}
break;
}

var G__60092 = seq__59962_60035;
var G__60093 = chunk__59975_60036;
var G__60094 = count__59976_60037;
var G__60095 = (i__59977_60038 + (1));
seq__59962_60035 = G__60092;
chunk__59975_60036 = G__60093;
count__59976_60037 = G__60094;
i__59977_60038 = G__60095;
continue;
} else {
var G__60096 = seq__59962_60035;
var G__60097 = chunk__59975_60036;
var G__60098 = count__59976_60037;
var G__60099 = (i__59977_60038 + (1));
seq__59962_60035 = G__60096;
chunk__59975_60036 = G__60097;
count__59976_60037 = G__60098;
i__59977_60038 = G__60099;
continue;
}
} else {
var temp__4657__auto___60100 = cljs.core.seq(seq__59962_60035);
if(temp__4657__auto___60100){
var seq__59962_60101__$1 = temp__4657__auto___60100;
if(cljs.core.chunked_seq_QMARK_(seq__59962_60101__$1)){
var c__6956__auto___60102 = cljs.core.chunk_first(seq__59962_60101__$1);
var G__60103 = cljs.core.chunk_rest(seq__59962_60101__$1);
var G__60104 = c__6956__auto___60102;
var G__60105 = cljs.core.count(c__6956__auto___60102);
var G__60106 = (0);
seq__59962_60035 = G__60103;
chunk__59975_60036 = G__60104;
count__59976_60037 = G__60105;
i__59977_60038 = G__60106;
continue;
} else {
var vec__59995_60107 = cljs.core.first(seq__59962_60101__$1);
var from_sdr_60108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59995_60107,(0),null);
var to_sdrs_counts_60109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59995_60107,(1),null);
if(cljs.core.truth_((kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1 ? kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1(from_sdr_60108) : kept_sdr_QMARK_.call(null,from_sdr_60108)))){
var from_y_60110 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(from_sdr_60108) : sdr_ordinate.call(null,from_sdr_60108)));
var seq__59965_60111 = cljs.core.seq(to_sdrs_counts_60109);
var chunk__59969_60112 = null;
var count__59970_60113 = (0);
var i__59971_60114 = (0);
while(true){
if((i__59971_60114 < count__59970_60113)){
var vec__59996_60115 = chunk__59969_60112.cljs$core$IIndexed$_nth$arity$2(null,i__59971_60114);
var to_sdr_60116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59996_60115,(0),null);
var to_sdr_count_60117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59996_60115,(1),null);
if(cljs.core.truth_((kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1 ? kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1(to_sdr_60116) : kept_sdr_QMARK_.call(null,to_sdr_60116)))){
if((to_sdr_count_60117 >= hide_conns_smaller)){
var to_y_60118 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(to_sdr_60116) : sdr_ordinate.call(null,to_sdr_60116)));
var mid_y_60119 = ((to_y_60118 + from_y_60110) / (2));
var off_x_60120 = ((1.0 * width_px) * ((to_y_60118 - from_y_60110) / height_px));
var G__59997_60121 = ctx;
monet.canvas.stroke_width(G__59997_60121,(function (){var x__6491__auto__ = ((to_sdr_count_60117 / threshold) * (4));
var y__6492__auto__ = (6);
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
})());

monet.canvas.begin_path(G__59997_60121);

monet.canvas.move_to(G__59997_60121,(0),from_y_60110);

monet.canvas.quadratic_curve_to.cljs$core$IFn$_invoke$arity$5(G__59997_60121,off_x_60120,mid_y_60119,(0),to_y_60118);

monet.canvas.stroke(G__59997_60121);


var G__60122 = seq__59965_60111;
var G__60123 = chunk__59969_60112;
var G__60124 = count__59970_60113;
var G__60125 = (i__59971_60114 + (1));
seq__59965_60111 = G__60122;
chunk__59969_60112 = G__60123;
count__59970_60113 = G__60124;
i__59971_60114 = G__60125;
continue;
} else {
var G__60126 = seq__59965_60111;
var G__60127 = chunk__59969_60112;
var G__60128 = count__59970_60113;
var G__60129 = (i__59971_60114 + (1));
seq__59965_60111 = G__60126;
chunk__59969_60112 = G__60127;
count__59970_60113 = G__60128;
i__59971_60114 = G__60129;
continue;
}
} else {
var G__60130 = seq__59965_60111;
var G__60131 = chunk__59969_60112;
var G__60132 = count__59970_60113;
var G__60133 = (i__59971_60114 + (1));
seq__59965_60111 = G__60130;
chunk__59969_60112 = G__60131;
count__59970_60113 = G__60132;
i__59971_60114 = G__60133;
continue;
}
} else {
var temp__4657__auto___60134__$1 = cljs.core.seq(seq__59965_60111);
if(temp__4657__auto___60134__$1){
var seq__59965_60135__$1 = temp__4657__auto___60134__$1;
if(cljs.core.chunked_seq_QMARK_(seq__59965_60135__$1)){
var c__6956__auto___60136 = cljs.core.chunk_first(seq__59965_60135__$1);
var G__60137 = cljs.core.chunk_rest(seq__59965_60135__$1);
var G__60138 = c__6956__auto___60136;
var G__60139 = cljs.core.count(c__6956__auto___60136);
var G__60140 = (0);
seq__59965_60111 = G__60137;
chunk__59969_60112 = G__60138;
count__59970_60113 = G__60139;
i__59971_60114 = G__60140;
continue;
} else {
var vec__59998_60141 = cljs.core.first(seq__59965_60135__$1);
var to_sdr_60142 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59998_60141,(0),null);
var to_sdr_count_60143 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__59998_60141,(1),null);
if(cljs.core.truth_((kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1 ? kept_sdr_QMARK_.cljs$core$IFn$_invoke$arity$1(to_sdr_60142) : kept_sdr_QMARK_.call(null,to_sdr_60142)))){
if((to_sdr_count_60143 >= hide_conns_smaller)){
var to_y_60144 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(to_sdr_60142) : sdr_ordinate.call(null,to_sdr_60142)));
var mid_y_60145 = ((to_y_60144 + from_y_60110) / (2));
var off_x_60146 = ((1.0 * width_px) * ((to_y_60144 - from_y_60110) / height_px));
var G__59999_60147 = ctx;
monet.canvas.stroke_width(G__59999_60147,(function (){var x__6491__auto__ = ((to_sdr_count_60143 / threshold) * (4));
var y__6492__auto__ = (6);
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
})());

monet.canvas.begin_path(G__59999_60147);

monet.canvas.move_to(G__59999_60147,(0),from_y_60110);

monet.canvas.quadratic_curve_to.cljs$core$IFn$_invoke$arity$5(G__59999_60147,off_x_60146,mid_y_60145,(0),to_y_60144);

monet.canvas.stroke(G__59999_60147);


var G__60148 = cljs.core.next(seq__59965_60135__$1);
var G__60149 = null;
var G__60150 = (0);
var G__60151 = (0);
seq__59965_60111 = G__60148;
chunk__59969_60112 = G__60149;
count__59970_60113 = G__60150;
i__59971_60114 = G__60151;
continue;
} else {
var G__60152 = cljs.core.next(seq__59965_60135__$1);
var G__60153 = null;
var G__60154 = (0);
var G__60155 = (0);
seq__59965_60111 = G__60152;
chunk__59969_60112 = G__60153;
count__59970_60113 = G__60154;
i__59971_60114 = G__60155;
continue;
}
} else {
var G__60156 = cljs.core.next(seq__59965_60135__$1);
var G__60157 = null;
var G__60158 = (0);
var G__60159 = (0);
seq__59965_60111 = G__60156;
chunk__59969_60112 = G__60157;
count__59970_60113 = G__60158;
i__59971_60114 = G__60159;
continue;
}
}
} else {
}
}
break;
}

var G__60160 = cljs.core.next(seq__59962_60101__$1);
var G__60161 = null;
var G__60162 = (0);
var G__60163 = (0);
seq__59962_60035 = G__60160;
chunk__59975_60036 = G__60161;
count__59976_60037 = G__60162;
i__59977_60038 = G__60163;
continue;
} else {
var G__60164 = cljs.core.next(seq__59962_60101__$1);
var G__60165 = null;
var G__60166 = (0);
var G__60167 = (0);
seq__59962_60035 = G__60164;
chunk__59975_60036 = G__60165;
count__59976_60037 = G__60166;
i__59977_60038 = G__60167;
continue;
}
}
} else {
}
}
break;
}

monet.canvas.stroke_width(ctx,(1));

monet.canvas.text_baseline(ctx,cljs.core.cst$kw$middle);

var seq__60000_60168 = cljs.core.seq(sdr_label_counts_STAR_);
var chunk__60002_60169 = null;
var count__60003_60170 = (0);
var i__60004_60171 = (0);
while(true){
if((i__60004_60171 < count__60003_60170)){
var vec__60006_60172 = chunk__60002_60169.cljs$core$IIndexed$_nth$arity$2(null,i__60004_60171);
var sdr_60173 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60006_60172,(0),null);
var label_counts_60174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60006_60172,(1),null);
var y_mid_60175 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(sdr_60173) : sdr_ordinate.call(null,sdr_60173)));
var sdr_tot_count_60176 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(label_counts_60174));
var sdr_width_60177 = (x_scale * sdr_tot_count_60176);
var sdr_height_60178 = (y_scale * (sdr_sizes.cljs$core$IFn$_invoke$arity$1 ? sdr_sizes.cljs$core$IFn$_invoke$arity$1(sdr_60173) : sdr_sizes.call(null,sdr_60173)));
var y_top_60179 = (y_mid_60175 - cljs.core.quot(sdr_height_60178,(2)));
var active_color_60180 = (cljs.core.truth_((ac_sdrv.cljs$core$IFn$_invoke$arity$1 ? ac_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60173) : ac_sdrv.call(null,sdr_60173)))?"#fbb":(cljs.core.truth_((pc_sdrv.cljs$core$IFn$_invoke$arity$1 ? pc_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60173) : pc_sdrv.call(null,sdr_60173)))?"#bbf":null
));
var active_size_60181 = (function (){var or__6153__auto__ = (ac_sdrv.cljs$core$IFn$_invoke$arity$1 ? ac_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60173) : ac_sdrv.call(null,sdr_60173));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return (pc_sdrv.cljs$core$IFn$_invoke$arity$1 ? pc_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60173) : pc_sdrv.call(null,sdr_60173));
}
})();
var sdr_rect_60182 = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$x,(- cljs.core.quot(sdr_width_60177,(2))),cljs.core.cst$kw$y,y_top_60179,cljs.core.cst$kw$w,sdr_width_60177,cljs.core.cst$kw$h,sdr_height_60178,cljs.core.cst$kw$r,(5)], null);
var G__60007_60183 = ctx;
monet.canvas.stroke_style(G__60007_60183,"#aaa");

monet.canvas.rounded_rect(G__60007_60183,cljs.core.update.cljs$core$IFn$_invoke$arity$4(sdr_rect_60182,cljs.core.cst$kw$r,cljs.core.min,(sdr_height_60178 / (2))));

monet.canvas.alpha(G__60007_60183,0.8);

monet.canvas.fill_style(G__60007_60183,"#ddd");

monet.canvas.fill(G__60007_60183);

monet.canvas.alpha(G__60007_60183,1.0);


if(cljs.core.truth_(active_size_60181)){
var h_60184 = (y_scale * active_size_60181);
var G__60008_60185 = ctx;
monet.canvas.alpha(G__60008_60185,0.4);

monet.canvas.fill_style(G__60008_60185,active_color_60180);

monet.canvas.rounded_rect(G__60008_60185,cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sdr_rect_60182,cljs.core.cst$kw$h,h_60184),cljs.core.cst$kw$r,cljs.core.min,(h_60184 / (2))));

monet.canvas.fill(G__60008_60185);

monet.canvas.alpha(G__60008_60185,1.0);

} else {
}

var temp__4657__auto___60186 = (sdr_growth.cljs$core$IFn$_invoke$arity$1 ? sdr_growth.cljs$core$IFn$_invoke$arity$1(sdr_60173) : sdr_growth.call(null,sdr_60173));
if(cljs.core.truth_(temp__4657__auto___60186)){
var growth_60187 = temp__4657__auto___60186;
var h_60188 = (y_scale * growth_60187);
var G__60009_60189 = ctx;
monet.canvas.alpha(G__60009_60189,0.8);

monet.canvas.fill_style(G__60009_60189,"#bfb");

monet.canvas.rounded_rect(G__60009_60189,cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sdr_rect_60182,cljs.core.cst$kw$h,h_60188),cljs.core.cst$kw$r,cljs.core.min,(h_60188 / (2))),cljs.core.cst$kw$y,cljs.core._PLUS_,sdr_height_60178));

monet.canvas.fill(G__60009_60189);

monet.canvas.alpha(G__60009_60189,1.0);

} else {
}

var temp__4657__auto___60190 = (wc_sdrv.cljs$core$IFn$_invoke$arity$1 ? wc_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60173) : wc_sdrv.call(null,sdr_60173));
if(cljs.core.truth_(temp__4657__auto___60190)){
var wc_size_60191 = temp__4657__auto___60190;
var h_60192 = (y_scale * wc_size_60191);
var G__60010_60193 = ctx;
monet.canvas.stroke_style(G__60010_60193,"#000");

monet.canvas.rounded_rect(G__60010_60193,cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sdr_rect_60182,cljs.core.cst$kw$h,h_60192),cljs.core.cst$kw$r,cljs.core.min,(h_60192 / (2))));

} else {
}

var gy_60194 = (y_scale * (sdr_growth.cljs$core$IFn$_invoke$arity$1 ? sdr_growth.cljs$core$IFn$_invoke$arity$1(sdr_60173) : sdr_growth.call(null,sdr_60173)));
var lab_y_60195 = (((sdr_height_60178 > (0)))?y_mid_60175:(y_mid_60175 + (gy_60194 / (2))));
monet.canvas.fill_style(ctx,"#000");

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (seq__60000_60168,chunk__60002_60169,count__60003_60170,i__60004_60171,gy_60194,lab_y_60195,y_mid_60175,sdr_tot_count_60176,sdr_width_60177,sdr_height_60178,y_top_60179,active_color_60180,active_size_60181,sdr_rect_60182,vec__60006_60172,sdr_60173,label_counts_60174,wc_sdrv,ac_sdrv,pc_sdrv,kept_sdr_QMARK_,sdr_label_counts_STAR_,gap,vec__59960,sdr_ordinate,y_max,title_px,hits_w_px,full_width_px,width_px,full_height_px,height_px,y_scale,sdr_max_count,x_scale,mid_x,label_width,map__59956,map__59956__$1,plot_data,sdr_label_counts,sdr_growth,hit_counts,kept_sdrs,timestep,title,threshold,sdr_transitions,sdr_sizes,sdr_votes,map__59957,map__59957__$1,plot_opts,group_contexts_QMARK_,ordering,hide_conns_smaller){
return (function (offset,p__60011){
var vec__60012 = p__60011;
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60012,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60012,(1),null);
monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(x_scale * (offset + (n / (2)))),cljs.core.cst$kw$y,lab_y_60195,cljs.core.cst$kw$text,[cljs.core.str(label)].join('')], null));

return (offset + n);
});})(seq__60000_60168,chunk__60002_60169,count__60003_60170,i__60004_60171,gy_60194,lab_y_60195,y_mid_60175,sdr_tot_count_60176,sdr_width_60177,sdr_height_60178,y_top_60179,active_color_60180,active_size_60181,sdr_rect_60182,vec__60006_60172,sdr_60173,label_counts_60174,wc_sdrv,ac_sdrv,pc_sdrv,kept_sdr_QMARK_,sdr_label_counts_STAR_,gap,vec__59960,sdr_ordinate,y_max,title_px,hits_w_px,full_width_px,width_px,full_height_px,height_px,y_scale,sdr_max_count,x_scale,mid_x,label_width,map__59956,map__59956__$1,plot_data,sdr_label_counts,sdr_growth,hit_counts,kept_sdrs,timestep,title,threshold,sdr_transitions,sdr_sizes,sdr_votes,map__59957,map__59957__$1,plot_opts,group_contexts_QMARK_,ordering,hide_conns_smaller))
,(- (sdr_tot_count_60176 / (2))),label_counts_60174);

var G__60196 = seq__60000_60168;
var G__60197 = chunk__60002_60169;
var G__60198 = count__60003_60170;
var G__60199 = (i__60004_60171 + (1));
seq__60000_60168 = G__60196;
chunk__60002_60169 = G__60197;
count__60003_60170 = G__60198;
i__60004_60171 = G__60199;
continue;
} else {
var temp__4657__auto___60200 = cljs.core.seq(seq__60000_60168);
if(temp__4657__auto___60200){
var seq__60000_60201__$1 = temp__4657__auto___60200;
if(cljs.core.chunked_seq_QMARK_(seq__60000_60201__$1)){
var c__6956__auto___60202 = cljs.core.chunk_first(seq__60000_60201__$1);
var G__60203 = cljs.core.chunk_rest(seq__60000_60201__$1);
var G__60204 = c__6956__auto___60202;
var G__60205 = cljs.core.count(c__6956__auto___60202);
var G__60206 = (0);
seq__60000_60168 = G__60203;
chunk__60002_60169 = G__60204;
count__60003_60170 = G__60205;
i__60004_60171 = G__60206;
continue;
} else {
var vec__60013_60207 = cljs.core.first(seq__60000_60201__$1);
var sdr_60208 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60013_60207,(0),null);
var label_counts_60209 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60013_60207,(1),null);
var y_mid_60210 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(sdr_60208) : sdr_ordinate.call(null,sdr_60208)));
var sdr_tot_count_60211 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(label_counts_60209));
var sdr_width_60212 = (x_scale * sdr_tot_count_60211);
var sdr_height_60213 = (y_scale * (sdr_sizes.cljs$core$IFn$_invoke$arity$1 ? sdr_sizes.cljs$core$IFn$_invoke$arity$1(sdr_60208) : sdr_sizes.call(null,sdr_60208)));
var y_top_60214 = (y_mid_60210 - cljs.core.quot(sdr_height_60213,(2)));
var active_color_60215 = (cljs.core.truth_((ac_sdrv.cljs$core$IFn$_invoke$arity$1 ? ac_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60208) : ac_sdrv.call(null,sdr_60208)))?"#fbb":(cljs.core.truth_((pc_sdrv.cljs$core$IFn$_invoke$arity$1 ? pc_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60208) : pc_sdrv.call(null,sdr_60208)))?"#bbf":null
));
var active_size_60216 = (function (){var or__6153__auto__ = (ac_sdrv.cljs$core$IFn$_invoke$arity$1 ? ac_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60208) : ac_sdrv.call(null,sdr_60208));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
return (pc_sdrv.cljs$core$IFn$_invoke$arity$1 ? pc_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60208) : pc_sdrv.call(null,sdr_60208));
}
})();
var sdr_rect_60217 = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$x,(- cljs.core.quot(sdr_width_60212,(2))),cljs.core.cst$kw$y,y_top_60214,cljs.core.cst$kw$w,sdr_width_60212,cljs.core.cst$kw$h,sdr_height_60213,cljs.core.cst$kw$r,(5)], null);
var G__60014_60218 = ctx;
monet.canvas.stroke_style(G__60014_60218,"#aaa");

monet.canvas.rounded_rect(G__60014_60218,cljs.core.update.cljs$core$IFn$_invoke$arity$4(sdr_rect_60217,cljs.core.cst$kw$r,cljs.core.min,(sdr_height_60213 / (2))));

monet.canvas.alpha(G__60014_60218,0.8);

monet.canvas.fill_style(G__60014_60218,"#ddd");

monet.canvas.fill(G__60014_60218);

monet.canvas.alpha(G__60014_60218,1.0);


if(cljs.core.truth_(active_size_60216)){
var h_60219 = (y_scale * active_size_60216);
var G__60015_60220 = ctx;
monet.canvas.alpha(G__60015_60220,0.4);

monet.canvas.fill_style(G__60015_60220,active_color_60215);

monet.canvas.rounded_rect(G__60015_60220,cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sdr_rect_60217,cljs.core.cst$kw$h,h_60219),cljs.core.cst$kw$r,cljs.core.min,(h_60219 / (2))));

monet.canvas.fill(G__60015_60220);

monet.canvas.alpha(G__60015_60220,1.0);

} else {
}

var temp__4657__auto___60221__$1 = (sdr_growth.cljs$core$IFn$_invoke$arity$1 ? sdr_growth.cljs$core$IFn$_invoke$arity$1(sdr_60208) : sdr_growth.call(null,sdr_60208));
if(cljs.core.truth_(temp__4657__auto___60221__$1)){
var growth_60222 = temp__4657__auto___60221__$1;
var h_60223 = (y_scale * growth_60222);
var G__60016_60224 = ctx;
monet.canvas.alpha(G__60016_60224,0.8);

monet.canvas.fill_style(G__60016_60224,"#bfb");

monet.canvas.rounded_rect(G__60016_60224,cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sdr_rect_60217,cljs.core.cst$kw$h,h_60223),cljs.core.cst$kw$r,cljs.core.min,(h_60223 / (2))),cljs.core.cst$kw$y,cljs.core._PLUS_,sdr_height_60213));

monet.canvas.fill(G__60016_60224);

monet.canvas.alpha(G__60016_60224,1.0);

} else {
}

var temp__4657__auto___60225__$1 = (wc_sdrv.cljs$core$IFn$_invoke$arity$1 ? wc_sdrv.cljs$core$IFn$_invoke$arity$1(sdr_60208) : wc_sdrv.call(null,sdr_60208));
if(cljs.core.truth_(temp__4657__auto___60225__$1)){
var wc_size_60226 = temp__4657__auto___60225__$1;
var h_60227 = (y_scale * wc_size_60226);
var G__60017_60228 = ctx;
monet.canvas.stroke_style(G__60017_60228,"#000");

monet.canvas.rounded_rect(G__60017_60228,cljs.core.update.cljs$core$IFn$_invoke$arity$4(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sdr_rect_60217,cljs.core.cst$kw$h,h_60227),cljs.core.cst$kw$r,cljs.core.min,(h_60227 / (2))));

} else {
}

var gy_60229 = (y_scale * (sdr_growth.cljs$core$IFn$_invoke$arity$1 ? sdr_growth.cljs$core$IFn$_invoke$arity$1(sdr_60208) : sdr_growth.call(null,sdr_60208)));
var lab_y_60230 = (((sdr_height_60213 > (0)))?y_mid_60210:(y_mid_60210 + (gy_60229 / (2))));
monet.canvas.fill_style(ctx,"#000");

cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (seq__60000_60168,chunk__60002_60169,count__60003_60170,i__60004_60171,gy_60229,lab_y_60230,y_mid_60210,sdr_tot_count_60211,sdr_width_60212,sdr_height_60213,y_top_60214,active_color_60215,active_size_60216,sdr_rect_60217,vec__60013_60207,sdr_60208,label_counts_60209,seq__60000_60201__$1,temp__4657__auto___60200,wc_sdrv,ac_sdrv,pc_sdrv,kept_sdr_QMARK_,sdr_label_counts_STAR_,gap,vec__59960,sdr_ordinate,y_max,title_px,hits_w_px,full_width_px,width_px,full_height_px,height_px,y_scale,sdr_max_count,x_scale,mid_x,label_width,map__59956,map__59956__$1,plot_data,sdr_label_counts,sdr_growth,hit_counts,kept_sdrs,timestep,title,threshold,sdr_transitions,sdr_sizes,sdr_votes,map__59957,map__59957__$1,plot_opts,group_contexts_QMARK_,ordering,hide_conns_smaller){
return (function (offset,p__60018){
var vec__60019 = p__60018;
var label = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60019,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60019,(1),null);
monet.canvas.text(ctx,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,(x_scale * (offset + (n / (2)))),cljs.core.cst$kw$y,lab_y_60230,cljs.core.cst$kw$text,[cljs.core.str(label)].join('')], null));

return (offset + n);
});})(seq__60000_60168,chunk__60002_60169,count__60003_60170,i__60004_60171,gy_60229,lab_y_60230,y_mid_60210,sdr_tot_count_60211,sdr_width_60212,sdr_height_60213,y_top_60214,active_color_60215,active_size_60216,sdr_rect_60217,vec__60013_60207,sdr_60208,label_counts_60209,seq__60000_60201__$1,temp__4657__auto___60200,wc_sdrv,ac_sdrv,pc_sdrv,kept_sdr_QMARK_,sdr_label_counts_STAR_,gap,vec__59960,sdr_ordinate,y_max,title_px,hits_w_px,full_width_px,width_px,full_height_px,height_px,y_scale,sdr_max_count,x_scale,mid_x,label_width,map__59956,map__59956__$1,plot_data,sdr_label_counts,sdr_growth,hit_counts,kept_sdrs,timestep,title,threshold,sdr_transitions,sdr_sizes,sdr_votes,map__59957,map__59957__$1,plot_opts,group_contexts_QMARK_,ordering,hide_conns_smaller))
,(- (sdr_tot_count_60211 / (2))),label_counts_60209);

var G__60231 = cljs.core.next(seq__60000_60201__$1);
var G__60232 = null;
var G__60233 = (0);
var G__60234 = (0);
seq__60000_60168 = G__60231;
chunk__60002_60169 = G__60232;
count__60003_60170 = G__60233;
i__60004_60171 = G__60234;
continue;
}
} else {
}
}
break;
}

var max_hits_60235 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max,(5),cljs.core.vals(hit_counts));
var x_left_60236 = (((0) - mid_x) - hits_w_px);
monet.canvas.text_align(ctx,cljs.core.cst$kw$right);

monet.canvas.font_style(ctx,[cljs.core.str(org.nfrac.comportex.util.round.cljs$core$IFn$_invoke$arity$1((hits_w_px * 0.5))),cljs.core.str("px sans")].join(''));

var seq__60020_60237 = cljs.core.seq(hit_counts);
var chunk__60022_60238 = null;
var count__60023_60239 = (0);
var i__60024_60240 = (0);
while(true){
if((i__60024_60240 < count__60023_60239)){
var vec__60026_60241 = chunk__60022_60238.cljs$core$IIndexed$_nth$arity$2(null,i__60024_60240);
var sdr_60242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60026_60241,(0),null);
var n_hits_60243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60026_60241,(1),null);
var z_60244 = (function (){var x__6491__auto__ = 1.0;
var y__6492__auto__ = (n_hits_60243 / max_hits_60235);
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
})();
var y_mid_60245 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(sdr_60242) : sdr_ordinate.call(null,sdr_60242)));
var sdr_height_60246 = (y_scale * (sdr_sizes.cljs$core$IFn$_invoke$arity$1 ? sdr_sizes.cljs$core$IFn$_invoke$arity$1(sdr_60242) : sdr_sizes.call(null,sdr_60242)));
var y_top_60247 = (y_mid_60245 - cljs.core.quot(sdr_height_60246,(2)));
var G__60027_60248 = ctx;
monet.canvas.alpha(G__60027_60248,z_60244);

monet.canvas.fill_style(G__60027_60248,"black");

monet.canvas.fill_rect(G__60027_60248,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,x_left_60236,cljs.core.cst$kw$y,y_top_60247,cljs.core.cst$kw$w,hits_w_px,cljs.core.cst$kw$h,sdr_height_60246], null));

monet.canvas.alpha(G__60027_60248,1.0);

monet.canvas.fill_style(G__60027_60248,(((z_60244 > 0.5))?"white":"black"));

monet.canvas.text(G__60027_60248,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,((x_left_60236 + hits_w_px) + (-5)),cljs.core.cst$kw$y,y_mid_60245,cljs.core.cst$kw$text,n_hits_60243], null));


var G__60249 = seq__60020_60237;
var G__60250 = chunk__60022_60238;
var G__60251 = count__60023_60239;
var G__60252 = (i__60024_60240 + (1));
seq__60020_60237 = G__60249;
chunk__60022_60238 = G__60250;
count__60023_60239 = G__60251;
i__60024_60240 = G__60252;
continue;
} else {
var temp__4657__auto___60253 = cljs.core.seq(seq__60020_60237);
if(temp__4657__auto___60253){
var seq__60020_60254__$1 = temp__4657__auto___60253;
if(cljs.core.chunked_seq_QMARK_(seq__60020_60254__$1)){
var c__6956__auto___60255 = cljs.core.chunk_first(seq__60020_60254__$1);
var G__60256 = cljs.core.chunk_rest(seq__60020_60254__$1);
var G__60257 = c__6956__auto___60255;
var G__60258 = cljs.core.count(c__6956__auto___60255);
var G__60259 = (0);
seq__60020_60237 = G__60256;
chunk__60022_60238 = G__60257;
count__60023_60239 = G__60258;
i__60024_60240 = G__60259;
continue;
} else {
var vec__60028_60260 = cljs.core.first(seq__60020_60254__$1);
var sdr_60261 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60028_60260,(0),null);
var n_hits_60262 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60028_60260,(1),null);
var z_60263 = (function (){var x__6491__auto__ = 1.0;
var y__6492__auto__ = (n_hits_60262 / max_hits_60235);
return ((x__6491__auto__ < y__6492__auto__) ? x__6491__auto__ : y__6492__auto__);
})();
var y_mid_60264 = (y_scale * (sdr_ordinate.cljs$core$IFn$_invoke$arity$1 ? sdr_ordinate.cljs$core$IFn$_invoke$arity$1(sdr_60261) : sdr_ordinate.call(null,sdr_60261)));
var sdr_height_60265 = (y_scale * (sdr_sizes.cljs$core$IFn$_invoke$arity$1 ? sdr_sizes.cljs$core$IFn$_invoke$arity$1(sdr_60261) : sdr_sizes.call(null,sdr_60261)));
var y_top_60266 = (y_mid_60264 - cljs.core.quot(sdr_height_60265,(2)));
var G__60029_60267 = ctx;
monet.canvas.alpha(G__60029_60267,z_60263);

monet.canvas.fill_style(G__60029_60267,"black");

monet.canvas.fill_rect(G__60029_60267,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$x,x_left_60236,cljs.core.cst$kw$y,y_top_60266,cljs.core.cst$kw$w,hits_w_px,cljs.core.cst$kw$h,sdr_height_60265], null));

monet.canvas.alpha(G__60029_60267,1.0);

monet.canvas.fill_style(G__60029_60267,(((z_60263 > 0.5))?"white":"black"));

monet.canvas.text(G__60029_60267,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$x,((x_left_60236 + hits_w_px) + (-5)),cljs.core.cst$kw$y,y_mid_60264,cljs.core.cst$kw$text,n_hits_60262], null));


var G__60268 = cljs.core.next(seq__60020_60254__$1);
var G__60269 = null;
var G__60270 = (0);
var G__60271 = (0);
seq__60020_60237 = G__60268;
chunk__60022_60238 = G__60269;
count__60023_60239 = G__60270;
i__60024_60240 = G__60271;
continue;
}
} else {
}
}
break;
}

return monet.canvas.restore(ctx);
});
org.numenta.sanity.plots.cell_sdrs_plot_data_group_contexts = (function org$numenta$sanity$plots$cell_sdrs_plot_data_group_contexts(p__60272){
var map__60275 = p__60272;
var map__60275__$1 = ((((!((map__60275 == null)))?((((map__60275.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60275.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60275):map__60275);
var plot_data = map__60275__$1;
var sdr_label_counts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$sdr_DASH_label_DASH_counts);
var sdr_growth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$sdr_DASH_growth);
var gid_sizes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$gid_DASH_sizes);
var kept_sdrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$kept_DASH_sdrs);
var current_sdrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$current_DASH_sdrs);
var sdr__GT_gid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$sdr_DASH__GT_gid);
var sdr_transitions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$sdr_DASH_transitions);
var gid_growth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$gid_DASH_growth);
var sdr_sizes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$sdr_DASH_sizes);
var sdr_votes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60275__$1,cljs.core.cst$kw$sdr_DASH_votes);
var kept_gids = cljs.core.reverse(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.reverse(cljs.core.map.cljs$core$IFn$_invoke$arity$2(sdr__GT_gid,kept_sdrs))));
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(plot_data,cljs.core.cst$kw$kept_DASH_sdrs,kept_gids,cljs.core.array_seq([cljs.core.cst$kw$current_DASH_sdrs,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(sdr__GT_gid,current_sdrs)),cljs.core.cst$kw$sdr_DASH_sizes,gid_sizes,cljs.core.cst$kw$sdr_DASH_growth,gid_growth,cljs.core.cst$kw$grouped_QMARK_,true], 0)),cljs.core.cst$kw$sdr_DASH_label_DASH_counts,((function (kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes){
return (function (m){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv(((function (kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes){
return (function (m__$1,sdr,label_counts){
var gid = (sdr__GT_gid.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_gid.cljs$core$IFn$_invoke$arity$1(sdr) : sdr__GT_gid.call(null,sdr));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,gid,cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._PLUS_,cljs.core.array_seq([cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,gid,cljs.core.PersistentArrayMap.EMPTY),label_counts], 0)));
});})(kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m));
});})(kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes))
),cljs.core.cst$kw$sdr_DASH_transitions,((function (kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes){
return (function (m){
return cljs.core.persistent_BANG_(cljs.core.reduce_kv(((function (kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes){
return (function (m__$1,from_sdr,to_sdrs_counts){
var from_gid = (sdr__GT_gid.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_gid.cljs$core$IFn$_invoke$arity$1(from_sdr) : sdr__GT_gid.call(null,from_sdr));
var to_gids_counts = cljs.core.persistent_BANG_(cljs.core.reduce_kv(((function (from_gid,kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes){
return (function (mm,to_sdr,n){
var to_gid = (sdr__GT_gid.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_gid.cljs$core$IFn$_invoke$arity$1(to_sdr) : sdr__GT_gid.call(null,to_sdr));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(mm,to_gid,(function (){var x__6484__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(mm,to_gid,(0));
var y__6485__auto__ = n;
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})());
});})(from_gid,kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),to_sdrs_counts));
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,from_gid,cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._PLUS_,cljs.core.array_seq([cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,from_gid,cljs.core.PersistentArrayMap.EMPTY),to_gids_counts], 0)));
});})(kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes))
,cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m));
});})(kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes))
),cljs.core.cst$kw$sdr_DASH_votes,((function (kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes){
return (function (vm){
return org.nfrac.comportex.util.remap(((function (kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes){
return (function (m){
return cljs.core.reduce_kv(((function (kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes){
return (function (mm,sdr,vote){
var gid = (sdr__GT_gid.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_gid.cljs$core$IFn$_invoke$arity$1(sdr) : sdr__GT_gid.call(null,sdr));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(mm,gid,(function (){var x__6484__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(mm,gid,(0));
var y__6485__auto__ = vote;
return ((x__6484__auto__ > y__6485__auto__) ? x__6484__auto__ : y__6485__auto__);
})());
});})(kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes))
,cljs.core.PersistentArrayMap.EMPTY,m);
});})(kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes))
,vm);
});})(kept_gids,map__60275,map__60275__$1,plot_data,sdr_label_counts,sdr_growth,gid_sizes,kept_sdrs,current_sdrs,sdr__GT_gid,sdr_transitions,gid_growth,sdr_sizes,sdr_votes))
);
});
org.numenta.sanity.plots.cell_sdrs_plot_spread_activation = (function org$numenta$sanity$plots$cell_sdrs_plot_spread_activation(p__60277,p__60278){
var map__60287 = p__60277;
var map__60287__$1 = ((((!((map__60287 == null)))?((((map__60287.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60287.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60287):map__60287);
var plot_data = map__60287__$1;
var sdr_transitions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60287__$1,cljs.core.cst$kw$sdr_DASH_transitions);
var sdr_last_matches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60287__$1,cljs.core.cst$kw$sdr_DASH_last_DASH_matches);
var timestep = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60287__$1,cljs.core.cst$kw$timestep);
var kept_sdrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60287__$1,cljs.core.cst$kw$kept_DASH_sdrs);
var current_sdrs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60287__$1,cljs.core.cst$kw$current_DASH_sdrs);
var map__60288 = p__60278;
var map__60288__$1 = ((((!((map__60288 == null)))?((((map__60288.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60288.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60288):map__60288);
var plot_opts = map__60288__$1;
var spreading_activation_steps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60288__$1,cljs.core.cst$kw$spreading_DASH_activation_DASH_steps);
var hide_conns_smaller = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60288__$1,cljs.core.cst$kw$hide_DASH_conns_DASH_smaller);
var ok_transitions = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (map__60287,map__60287__$1,plot_data,sdr_transitions,sdr_last_matches,timestep,kept_sdrs,current_sdrs,map__60288,map__60288__$1,plot_opts,spreading_activation_steps,hide_conns_smaller){
return (function (p__60291){
var vec__60292 = p__60291;
var from_sdr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60292,(0),null);
var to_sdrs_counts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60292,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [from_sdr,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(((function (vec__60292,from_sdr,to_sdrs_counts,map__60287,map__60287__$1,plot_data,sdr_transitions,sdr_last_matches,timestep,kept_sdrs,current_sdrs,map__60288,map__60288__$1,plot_opts,spreading_activation_steps,hide_conns_smaller){
return (function (p__60293){
var vec__60294 = p__60293;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60294,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60294,(1),null);
if((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(from_sdr,id)) && ((n >= hide_conns_smaller))){
return id;
} else {
return null;
}
});})(vec__60292,from_sdr,to_sdrs_counts,map__60287,map__60287__$1,plot_data,sdr_transitions,sdr_last_matches,timestep,kept_sdrs,current_sdrs,map__60288,map__60288__$1,plot_opts,spreading_activation_steps,hide_conns_smaller))
,to_sdrs_counts)], null);
});})(map__60287,map__60287__$1,plot_data,sdr_transitions,sdr_last_matches,timestep,kept_sdrs,current_sdrs,map__60288,map__60288__$1,plot_opts,spreading_activation_steps,hide_conns_smaller))
),cljs.core.select_keys(sdr_transitions,kept_sdrs));
var hit_counts = (function (){var hit_counts = cljs.core.zipmap(current_sdrs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((0)));
var current_ids = current_sdrs;
var n = spreading_activation_steps;
while(true){
if((n > (0))){
var next_ids = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(ok_transitions,cljs.core.array_seq([current_ids], 0));
var next_counts = cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._PLUS_,cljs.core.array_seq([hit_counts,cljs.core.frequencies(next_ids)], 0));
var G__60295 = next_counts;
var G__60296 = next_ids;
var G__60297 = (n - (1));
hit_counts = G__60295;
current_ids = G__60296;
n = G__60297;
continue;
} else {
return hit_counts;
}
break;
}
})();
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(plot_data,cljs.core.cst$kw$hit_DASH_counts,hit_counts);
});
/**
 * Applies options hide-states-older, hide-states-rarer to filter the
 *   list of sdrs, and returns them ordered by last appearance.
 */
org.numenta.sanity.plots.kept_sdrs_by_last_appearance = (function org$numenta$sanity$plots$kept_sdrs_by_last_appearance(p__60298,p__60299){
var map__60304 = p__60298;
var map__60304__$1 = ((((!((map__60304 == null)))?((((map__60304.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60304.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60304):map__60304);
var sdr_label_counts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60304__$1,cljs.core.cst$kw$sdr_DASH_label_DASH_counts);
var sdr_last_matches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60304__$1,cljs.core.cst$kw$sdr_DASH_last_DASH_matches);
var sdr_votes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60304__$1,cljs.core.cst$kw$sdr_DASH_votes);
var timestep = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60304__$1,cljs.core.cst$kw$timestep);
var map__60305 = p__60299;
var map__60305__$1 = ((((!((map__60305 == null)))?((((map__60305.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60305.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60305):map__60305);
var hide_states_older = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60305__$1,cljs.core.cst$kw$hide_DASH_states_DASH_older);
var hide_states_rarer = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60305__$1,cljs.core.cst$kw$hide_DASH_states_DASH_rarer);
var wc_sdrv = cljs.core.cst$kw$winners.cljs$core$IFn$_invoke$arity$1(sdr_votes);
return cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentVector.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.key),(((hide_states_rarer > (1)))?cljs.core.filter.cljs$core$IFn$_invoke$arity$1(((function (wc_sdrv,map__60304,map__60304__$1,sdr_label_counts,sdr_last_matches,sdr_votes,timestep,map__60305,map__60305__$1,hide_states_older,hide_states_rarer){
return (function (sdr){
var or__6153__auto__ = (wc_sdrv.cljs$core$IFn$_invoke$arity$1 ? wc_sdrv.cljs$core$IFn$_invoke$arity$1(sdr) : wc_sdrv.call(null,sdr));
if(cljs.core.truth_(or__6153__auto__)){
return or__6153__auto__;
} else {
var label_counts = (sdr_label_counts.cljs$core$IFn$_invoke$arity$1 ? sdr_label_counts.cljs$core$IFn$_invoke$arity$1(sdr) : sdr_label_counts.call(null,sdr));
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(label_counts)) >= hide_states_rarer);
}
});})(wc_sdrv,map__60304,map__60304__$1,sdr_label_counts,sdr_last_matches,sdr_votes,timestep,map__60305,map__60305__$1,hide_states_older,hide_states_rarer))
):cljs.core.identity)),cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(sdr_last_matches,cljs.core._GT__EQ_,(timestep - hide_states_older)));
});
org.numenta.sanity.plots.draw_cell_sdrs_plot_BANG_ = (function org$numenta$sanity$plots$draw_cell_sdrs_plot_BANG_(ctx,p__60308,plot_opts){
var map__60312 = p__60308;
var map__60312__$1 = ((((!((map__60312 == null)))?((((map__60312.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60312.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60312):map__60312);
var plot_data_STAR_ = map__60312__$1;
var sdr_last_matches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60312__$1,cljs.core.cst$kw$sdr_DASH_last_DASH_matches);
var timestep = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60312__$1,cljs.core.cst$kw$timestep);
var kept_sdrs = org.numenta.sanity.plots.kept_sdrs_by_last_appearance(plot_data_STAR_,plot_opts);
var current_sdrs = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(sdr_last_matches,cljs.core._GT__EQ_,timestep));
var plot_data = (function (){var G__60314 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(plot_data_STAR_,cljs.core.cst$kw$kept_DASH_sdrs,kept_sdrs,cljs.core.array_seq([cljs.core.cst$kw$current_DASH_sdrs,current_sdrs], 0));
var G__60314__$1 = (cljs.core.truth_(cljs.core.cst$kw$group_DASH_contexts_QMARK_.cljs$core$IFn$_invoke$arity$1(plot_opts))?org.numenta.sanity.plots.cell_sdrs_plot_data_group_contexts(G__60314):G__60314);
if((cljs.core.cst$kw$spreading_DASH_activation_DASH_steps.cljs$core$IFn$_invoke$arity$1(plot_opts) > (0))){
return org.numenta.sanity.plots.cell_sdrs_plot_spread_activation(G__60314__$1,plot_opts);
} else {
return G__60314__$1;
}
})();
return org.numenta.sanity.plots.draw_cell_sdrs_plot_BANG__STAR_(ctx,plot_data,plot_opts);
});
org.numenta.sanity.plots.cell_sdrs_context_analysis_cmp = (function org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp(p__60316,p__60317){
var map__60351 = p__60316;
var map__60351__$1 = ((((!((map__60351 == null)))?((((map__60351.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60351.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60351):map__60351);
var plot_data = map__60351__$1;
var sdr_history = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60351__$1,cljs.core.cst$kw$sdr_DASH_history);
var sdr_transitions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60351__$1,cljs.core.cst$kw$sdr_DASH_transitions);
var sdr__GT_gid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60351__$1,cljs.core.cst$kw$sdr_DASH__GT_gid);
var sdr_label_counts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60351__$1,cljs.core.cst$kw$sdr_DASH_label_DASH_counts);
var timestep = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60351__$1,cljs.core.cst$kw$timestep);
var map__60352 = p__60317;
var map__60352__$1 = ((((!((map__60352 == null)))?((((map__60352.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60352.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60352):map__60352);
var plot_opts = map__60352__$1;
var hide_states_older = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60352__$1,cljs.core.cst$kw$hide_DASH_states_DASH_older);
var hide_conns_smaller = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60352__$1,cljs.core.cst$kw$hide_DASH_conns_DASH_smaller);
var sdrseq = cljs.core.reverse(cljs.core.take.cljs$core$IFn$_invoke$arity$2(hide_states_older,sdr_history));
var sdr__GT_label = org.nfrac.comportex.util.remap(((function (sdrseq,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (labm){
return cljs.core.key(cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.val,labm));
});})(sdrseq,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,sdr_label_counts);
var sdr__GT_count = org.nfrac.comportex.util.remap(((function (sdrseq,sdr__GT_label,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (labm){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(labm));
});})(sdrseq,sdr__GT_label,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,sdr_label_counts);
var gid__GT_sdrs = cljs.core.group_by(sdr__GT_gid,cljs.core.keys(sdr__GT_gid));
var kept_sdrs = org.numenta.sanity.plots.kept_sdrs_by_last_appearance(plot_data,plot_opts);
var ok_transitions = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$1(((function (sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (p__60355){
var vec__60356 = p__60355;
var from_sdr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60356,(0),null);
var to_sdrs_counts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60356,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [from_sdr,cljs.core.keep.cljs$core$IFn$_invoke$arity$2(((function (vec__60356,from_sdr,to_sdrs_counts,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (p__60357){
var vec__60358 = p__60357;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60358,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60358,(1),null);
if((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(from_sdr,id)) && ((n >= hide_conns_smaller))){
return id;
} else {
return null;
}
});})(vec__60356,from_sdr,to_sdrs_counts,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,to_sdrs_counts)], null);
});})(sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
),cljs.core.select_keys(sdr_transitions,kept_sdrs));
var column_diversity = ((function (sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (gid){
var instances = (gid__GT_sdrs.cljs$core$IFn$_invoke$arity$1 ? gid__GT_sdrs.cljs$core$IFn$_invoke$arity$1(gid) : gid__GT_sdrs.call(null,gid));
var counts = cljs.core.map.cljs$core$IFn$_invoke$arity$2(sdr__GT_count,instances);
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,counts);
return (- cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (instances,counts,total,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (n){
var p = (n / total);
return (p * Math.log(p));
});})(instances,counts,total,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,counts)));
});})(sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
;
var context_alternatives = ((function (sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (ctx_sdr){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(sdr__GT_gid,(ok_transitions.cljs$core$IFn$_invoke$arity$1 ? ok_transitions.cljs$core$IFn$_invoke$arity$1(ctx_sdr) : ok_transitions.call(null,ctx_sdr))));
});})(sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
;
var curr_sdr = cljs.core.first(sdr_history);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$table$table_DASH_condensed,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$text_DASH_right,"diversity of contexts input appears in"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th$text_DASH_right,"number of inputs appearing in this context"], null)], null)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody], null),(function (){var iter__6925__auto__ = ((function (sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60359(s__60360){
return (new cljs.core.LazySeq(null,((function (sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (){
var s__60360__$1 = s__60360;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__60360__$1);
if(temp__4657__auto__){
var s__60360__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__60360__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__60360__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__60362 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__60361 = (0);
while(true){
if((i__60361 < size__6924__auto__)){
var vec__60367 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__60361);
var prior_sdr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60367,(0),null);
var sdr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60367,(1),null);
var col_d = column_diversity((sdr__GT_gid.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_gid.cljs$core$IFn$_invoke$arity$1(sdr) : sdr__GT_gid.call(null,sdr)));
var ctx_n = (cljs.core.truth_(prior_sdr)?cljs.core.count(context_alternatives(prior_sdr)):(0));
cljs.core.chunk_append(b__60362,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,(((sdr === curr_sdr))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$active], null):null),[cljs.core.str((sdr__GT_label.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_label.cljs$core$IFn$_invoke$arity$1(sdr) : sdr__GT_label.call(null,sdr)))].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$text_DASH_right,(((col_d >= 1.5))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$success], null):(((col_d >= 1.2))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$info], null):(((col_d >= 0.68))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$warning], null):cljs.core.PersistentArrayMap.EMPTY
))),col_d.toFixed((2))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$text_DASH_right,(((ctx_n >= (4)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$success], null):(((ctx_n >= (3)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$info], null):(((ctx_n >= (2)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$warning], null):null))),ctx_n], null)], null));

var G__60384 = (i__60361 + (1));
i__60361 = G__60384;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__60362),org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60359(cljs.core.chunk_rest(s__60360__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__60362),null);
}
} else {
var vec__60368 = cljs.core.first(s__60360__$2);
var prior_sdr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60368,(0),null);
var sdr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60368,(1),null);
var col_d = column_diversity((sdr__GT_gid.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_gid.cljs$core$IFn$_invoke$arity$1(sdr) : sdr__GT_gid.call(null,sdr)));
var ctx_n = (cljs.core.truth_(prior_sdr)?cljs.core.count(context_alternatives(prior_sdr)):(0));
return cljs.core.cons(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,(((sdr === curr_sdr))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$active], null):null),[cljs.core.str((sdr__GT_label.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_label.cljs$core$IFn$_invoke$arity$1(sdr) : sdr__GT_label.call(null,sdr)))].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$text_DASH_right,(((col_d >= 1.5))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$success], null):(((col_d >= 1.2))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$info], null):(((col_d >= 0.68))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$warning], null):cljs.core.PersistentArrayMap.EMPTY
))),col_d.toFixed((2))], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$text_DASH_right,(((ctx_n >= (4)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$success], null):(((ctx_n >= (3)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$info], null):(((ctx_n >= (2)))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,cljs.core.cst$kw$warning], null):null))),ctx_n], null)], null),org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60359(cljs.core.rest(s__60360__$2)));
}
} else {
return null;
}
break;
}
});})(sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,null,null));
});})(sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
;
return iter__6925__auto__(cljs.core.partition.cljs$core$IFn$_invoke$arity$3((2),(1),cljs.core.cons(null,sdrseq)));
})()),(function (){var sdr = cljs.core.first(sdr_history);
var prev_sdr = cljs.core.second(sdr_history);
var alternatives = context_alternatives(prev_sdr);
var instances = (function (){var G__60369 = (sdr__GT_gid.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_gid.cljs$core$IFn$_invoke$arity$1(sdr) : sdr__GT_gid.call(null,sdr));
return (gid__GT_sdrs.cljs$core$IFn$_invoke$arity$1 ? gid__GT_sdrs.cljs$core$IFn$_invoke$arity$1(G__60369) : gid__GT_sdrs.call(null,G__60369));
})();
var transitions_to = ((function (sdr,prev_sdr,alternatives,instances,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (sdr__$1){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2(((function (sdr,prev_sdr,alternatives,instances,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (p__60370){
var vec__60371 = p__60370;
var from_sdr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60371,(0),null);
var to_sdrs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60371,(1),null);
if(cljs.core.truth_(cljs.core.some(((function (vec__60371,from_sdr,to_sdrs,sdr,prev_sdr,alternatives,instances,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (p1__60315_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sdr__$1,p1__60315_SHARP_);
});})(vec__60371,from_sdr,to_sdrs,sdr,prev_sdr,alternatives,instances,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,to_sdrs))){
return from_sdr;
} else {
return null;
}
});})(sdr,prev_sdr,alternatives,instances,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,ok_transitions);
});})(sdr,prev_sdr,alternatives,instances,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tfoot,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$text_DASH_right,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol], null),(function (){var iter__6925__auto__ = ((function (sdr,prev_sdr,alternatives,instances,transitions_to,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60372(s__60373){
return (new cljs.core.LazySeq(null,((function (sdr,prev_sdr,alternatives,instances,transitions_to,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (){
var s__60373__$1 = s__60373;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__60373__$1);
if(temp__4657__auto__){
var s__60373__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__60373__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__60373__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__60375 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__60374 = (0);
while(true){
if((i__60374 < size__6924__auto__)){
var i_sdr = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__60374);
cljs.core.chunk_append(b__60375,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" / ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(sdr__GT_label,transitions_to(i_sdr)))," (...)"], null));

var G__60385 = (i__60374 + (1));
i__60374 = G__60385;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__60375),org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60372(cljs.core.chunk_rest(s__60373__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__60375),null);
}
} else {
var i_sdr = cljs.core.first(s__60373__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" / ",cljs.core.map.cljs$core$IFn$_invoke$arity$2(sdr__GT_label,transitions_to(i_sdr)))," (...)"], null),org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60372(cljs.core.rest(s__60373__$2)));
}
} else {
return null;
}
break;
}
});})(sdr,prev_sdr,alternatives,instances,transitions_to,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,null,null));
});})(sdr,prev_sdr,alternatives,instances,transitions_to,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
;
return iter__6925__auto__(instances);
})())], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$text_DASH_right,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ol], null),(function (){var iter__6925__auto__ = ((function (sdr,prev_sdr,alternatives,instances,transitions_to,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60378(s__60379){
return (new cljs.core.LazySeq(null,((function (sdr,prev_sdr,alternatives,instances,transitions_to,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller){
return (function (){
var s__60379__$1 = s__60379;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__60379__$1);
if(temp__4657__auto__){
var s__60379__$2 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_(s__60379__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__60379__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__60381 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__60380 = (0);
while(true){
if((i__60380 < size__6924__auto__)){
var a_sdr = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__60380);
cljs.core.chunk_append(b__60381,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,(sdr__GT_label.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_label.cljs$core$IFn$_invoke$arity$1(a_sdr) : sdr__GT_label.call(null,a_sdr))], null));

var G__60386 = (i__60380 + (1));
i__60380 = G__60386;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__60381),org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60378(cljs.core.chunk_rest(s__60379__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__60381),null);
}
} else {
var a_sdr = cljs.core.first(s__60379__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,(sdr__GT_label.cljs$core$IFn$_invoke$arity$1 ? sdr__GT_label.cljs$core$IFn$_invoke$arity$1(a_sdr) : sdr__GT_label.call(null,a_sdr))], null),org$numenta$sanity$plots$cell_sdrs_context_analysis_cmp_$_iter__60378(cljs.core.rest(s__60379__$2)));
}
} else {
return null;
}
break;
}
});})(sdr,prev_sdr,alternatives,instances,transitions_to,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
,null,null));
});})(sdr,prev_sdr,alternatives,instances,transitions_to,sdrseq,sdr__GT_label,sdr__GT_count,gid__GT_sdrs,kept_sdrs,ok_transitions,column_diversity,context_alternatives,curr_sdr,map__60351,map__60351__$1,plot_data,sdr_history,sdr_transitions,sdr__GT_gid,sdr_label_counts,timestep,map__60352,map__60352__$1,plot_opts,hide_states_older,hide_conns_smaller))
;
return iter__6925__auto__(alternatives);
})())], null)], null)], null);
})()], null);
});
org.numenta.sanity.plots.fetch_transitions_data = (function org$numenta$sanity$plots$fetch_transitions_data(sel1,cell_sdr_counts,into_journal){
var temp__4657__auto__ = org.numenta.sanity.selection.layer(sel1);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__60390 = temp__4657__auto__;
var region = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60390,(0),null);
var layer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60390,(1),null);
var map__60391 = cljs.core.cst$kw$step.cljs$core$IFn$_invoke$arity$1(sel1);
var map__60391__$1 = ((((!((map__60391 == null)))?((((map__60391.cljs$lang$protocol_mask$partition0$ & (64))) || (map__60391.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__60391):map__60391);
var snapshot_id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__60391__$1,cljs.core.cst$kw$snapshot_DASH_id);
var response_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, ["get-transitions-data",snapshot_id,region,layer,cell_sdr_counts,org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c,true)], null));

return response_c;
} else {
return null;
}
});
org.numenta.sanity.plots.calc_sdr_sizes = (function org$numenta$sanity$plots$calc_sdr_sizes(cell_sdr_fracs){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,sdr_fracs){
return cljs.core.reduce_kv((function (m__$1,sdr,frac){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(m__$1,sdr,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,sdr,(0)) + frac));
}),m,sdr_fracs);
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),cljs.core.vals(cell_sdr_fracs)));
});
org.numenta.sanity.plots.update_cell_sdrs_plot_data_BANG_ = (function org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG_(plot_data,states,sel1,into_journal){
var temp__4657__auto__ = org.numenta.sanity.selection.layer(sel1);
if(cljs.core.truth_(temp__4657__auto__)){
var vec__60419 = temp__4657__auto__;
var region = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60419,(0),null);
var layer = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__60419,(1),null);
var snapshot_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(sel1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$step,cljs.core.cst$kw$snapshot_DASH_id], null));
var temp__4657__auto____$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(states) : cljs.core.deref.call(null,states)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [snapshot_id,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [region,layer], null)], null));
if(cljs.core.truth_(temp__4657__auto____$1)){
var state_STAR_ = temp__4657__auto____$1;
var state = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state_STAR_,cljs.core.cst$kw$title,[cljs.core.str(cljs.core.name(region)),cljs.core.str(" "),cljs.core.str(cljs.core.name(layer))].join(''));
if(cljs.core.not(cljs.core.cst$kw$sdr_DASH_transitions.cljs$core$IFn$_invoke$arity$1(state))){
var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__,state,state_STAR_,temp__4657__auto____$1,snapshot_id,vec__60419,region,layer,temp__4657__auto__){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__,state,state_STAR_,temp__4657__auto____$1,snapshot_id,vec__60419,region,layer,temp__4657__auto__){
return (function (state_60434){
var state_val_60435 = (state_60434[(1)]);
if((state_val_60435 === (1))){
var inst_60420 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(plot_data,state) : cljs.core.reset_BANG_.call(null,plot_data,state));
var inst_60421 = cljs.core.cst$kw$cell_DASH_sdr_DASH_counts.cljs$core$IFn$_invoke$arity$1(state);
var inst_60422 = org.numenta.sanity.plots.fetch_transitions_data(sel1,inst_60421,into_journal);
var state_60434__$1 = (function (){var statearr_60436 = state_60434;
(statearr_60436[(7)] = inst_60420);

return statearr_60436;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_60434__$1,(2),inst_60422);
} else {
if((state_val_60435 === (2))){
var inst_60424 = (state_60434[(2)]);
var inst_60425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_60427 = [region,layer];
var inst_60428 = (new cljs.core.PersistentVector(null,2,(5),inst_60426,inst_60427,null));
var inst_60429 = [snapshot_id,inst_60428,cljs.core.cst$kw$sdr_DASH_transitions];
var inst_60430 = (new cljs.core.PersistentVector(null,3,(5),inst_60425,inst_60429,null));
var inst_60431 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(states,cljs.core.assoc_in,inst_60430,inst_60424);
var inst_60432 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(plot_data,cljs.core.assoc,cljs.core.cst$kw$sdr_DASH_transitions,inst_60424);
var state_60434__$1 = (function (){var statearr_60437 = state_60434;
(statearr_60437[(8)] = inst_60431);

return statearr_60437;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_60434__$1,inst_60432);
} else {
return null;
}
}
});})(c__38109__auto__,state,state_STAR_,temp__4657__auto____$1,snapshot_id,vec__60419,region,layer,temp__4657__auto__))
;
return ((function (switch__37995__auto__,c__38109__auto__,state,state_STAR_,temp__4657__auto____$1,snapshot_id,vec__60419,region,layer,temp__4657__auto__){
return (function() {
var org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto__ = null;
var org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto____0 = (function (){
var statearr_60441 = [null,null,null,null,null,null,null,null,null];
(statearr_60441[(0)] = org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto__);

(statearr_60441[(1)] = (1));

return statearr_60441;
});
var org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto____1 = (function (state_60434){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_60434);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e60442){if((e60442 instanceof Object)){
var ex__37999__auto__ = e60442;
var statearr_60443_60445 = state_60434;
(statearr_60443_60445[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_60434);

return cljs.core.cst$kw$recur;
} else {
throw e60442;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__60446 = state_60434;
state_60434 = G__60446;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto__ = function(state_60434){
switch(arguments.length){
case 0:
return org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto____1.call(this,state_60434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto____0;
org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto____1;
return org$numenta$sanity$plots$update_cell_sdrs_plot_data_BANG__$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__,state,state_STAR_,temp__4657__auto____$1,snapshot_id,vec__60419,region,layer,temp__4657__auto__))
})();
var state__38111__auto__ = (function (){var statearr_60444 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_60444[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_60444;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__,state,state_STAR_,temp__4657__auto____$1,snapshot_id,vec__60419,region,layer,temp__4657__auto__))
);

return c__38109__auto__;
} else {
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(plot_data,state) : cljs.core.reset_BANG_.call(null,plot_data,state));
}
} else {
return null;
}
} else {
return null;
}
});
org.numenta.sanity.plots.sdr_votes = (function org$numenta$sanity$plots$sdr_votes(cells,cell_sdr_fracs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.merge_with,cljs.core._PLUS_,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cell_sdr_fracs,cells));
});
org.numenta.sanity.plots.freqs__GT_fracs = (function org$numenta$sanity$plots$freqs__GT_fracs(freqs){
var total = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,cljs.core.vals(freqs));
return org.nfrac.comportex.util.remap(((function (total){
return (function (p1__60447_SHARP_){
return (p1__60447_SHARP_ / total);
});})(total))
,freqs);
});
org.numenta.sanity.plots.empty_cell_sdrs_state = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$sdr_DASH_last_DASH_matches,cljs.core.cst$kw$sdr_DASH_history,cljs.core.cst$kw$gid_DASH_sizes,cljs.core.cst$kw$timestep,cljs.core.cst$kw$col_DASH_gid_DASH_counts,cljs.core.cst$kw$threshold,cljs.core.cst$kw$cell_DASH_sdr_DASH_counts,cljs.core.cst$kw$sdr_DASH__GT_gid,cljs.core.cst$kw$sdr_DASH_transitions,cljs.core.cst$kw$sdr_DASH_sizes,cljs.core.cst$kw$sdr_DASH_votes,cljs.core.cst$kw$sdr_DASH_label_DASH_counts,cljs.core.cst$kw$sdr_DASH_growth],[tailrecursion.priority_map.priority_map(),cljs.core.List.EMPTY,cljs.core.PersistentArrayMap.EMPTY,(0),cljs.core.PersistentArrayMap.EMPTY,(0),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$winners,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$active,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$pred,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY]);
org.numenta.sanity.plots.update_cell_sdrs_states_BANG_ = (function org$numenta$sanity$plots$update_cell_sdrs_states_BANG_(states,network_shape,step,prev_step,into_journal){
var iter__6925__auto__ = (function org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693(s__62694){
return (new cljs.core.LazySeq(null,(function (){
var s__62694__$1 = s__62694;
while(true){
var temp__4657__auto__ = cljs.core.seq(s__62694__$1);
if(temp__4657__auto__){
var xs__5205__auto__ = temp__4657__auto__;
var vec__63819 = cljs.core.first(xs__5205__auto__);
var region = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63819,(0),null);
var layer_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__63819,(1),null);
var iterys__6921__auto__ = ((function (s__62694__$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695(s__62696){
return (new cljs.core.LazySeq(null,((function (s__62694__$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (){
var s__62696__$1 = s__62696;
while(true){
var temp__4657__auto____$1 = cljs.core.seq(s__62696__$1);
if(temp__4657__auto____$1){
var s__62696__$2 = temp__4657__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__62696__$2)){
var c__6923__auto__ = cljs.core.chunk_first(s__62696__$2);
var size__6924__auto__ = cljs.core.count(c__6923__auto__);
var b__62698 = cljs.core.chunk_buffer(size__6924__auto__);
if((function (){var i__62697 = (0);
while(true){
if((i__62697 < size__6924__auto__)){
var layer = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__6923__auto__,i__62697);
var response_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var snapshot_id = cljs.core.cst$kw$snapshot_DASH_id.cljs$core$IFn$_invoke$arity$1(step);
cljs.core.chunk_append(b__62698,(function (){var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (i__62697,s__62694__$1,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (i__62697,s__62694__$1,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (state_64573){
var state_val_64574 = (state_64573[(1)]);
if((state_val_64574 === (7))){
var inst_64420 = (state_64573[(7)]);
var inst_64427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64428 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64429 = [inst_64420];
var inst_64430 = (new cljs.core.PersistentVector(null,1,(5),inst_64428,inst_64429,null));
var inst_64431 = [inst_64430,inst_64420];
var inst_64432 = (new cljs.core.PersistentVector(null,2,(5),inst_64427,inst_64431,null));
var state_64573__$1 = state_64573;
var statearr_64575_64938 = state_64573__$1;
(statearr_64575_64938[(2)] = inst_64432);

(statearr_64575_64938[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (20))){
var inst_64405 = (state_64573[(8)]);
var inst_64495 = (state_64573[(2)]);
var state_64573__$1 = (function (){var statearr_64576 = state_64573;
(statearr_64576[(9)] = inst_64495);

return statearr_64576;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64577_64939 = state_64573__$1;
(statearr_64577_64939[(1)] = (21));

} else {
var statearr_64578_64940 = state_64573__$1;
(statearr_64578_64940[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (27))){
var inst_64413 = (state_64573[(10)]);
var inst_64473 = (state_64573[(11)]);
var inst_64401 = (state_64573[(12)]);
var inst_64479 = (state_64573[(13)]);
var inst_64481 = (state_64573[(14)]);
var inst_64440 = (state_64573[(15)]);
var inst_64402 = (state_64573[(16)]);
var inst_64460 = (state_64573[(17)]);
var inst_64461 = (state_64573[(18)]);
var inst_64405 = (state_64573[(8)]);
var inst_64415 = (state_64573[(19)]);
var inst_64403 = (state_64573[(20)]);
var inst_64439 = (state_64573[(21)]);
var inst_64459 = (state_64573[(22)]);
var inst_64438 = (state_64573[(23)]);
var inst_64410 = (state_64573[(24)]);
var inst_64436 = (state_64573[(25)]);
var inst_64507 = (state_64573[(26)]);
var inst_64434 = (state_64573[(27)]);
var inst_64487 = (state_64573[(28)]);
var inst_64412 = (state_64573[(29)]);
var inst_64476 = (state_64573[(30)]);
var inst_64414 = (state_64573[(31)]);
var inst_64435 = (state_64573[(32)]);
var inst_64388 = (state_64573[(33)]);
var inst_64404 = (state_64573[(34)]);
var inst_64488 = (state_64573[(35)]);
var inst_64467 = (state_64573[(36)]);
var inst_64509 = (function (){var t = inst_64488;
var pc_sdrv = inst_64414;
var win_sdrs = inst_64435;
var vec__64386 = inst_64459;
var a_cols = inst_64439;
var ac_sdrv = inst_64413;
var win_gids = inst_64460;
var new_sdr = inst_64436;
var wc = inst_64402;
var vec__64385 = inst_64434;
var on_QMARK_ = inst_64405;
var gid_sizes = inst_64473;
var gidv = inst_64440;
var ac = inst_64403;
var cells_by_state = inst_64388;
var new_gid = inst_64461;
var inc_label = inst_64487;
var col_gid_fracs = inst_64438;
var pc = inst_64404;
var state = inst_64401;
var inc_win_gids = inst_64479;
var threshold = inst_64410;
var inc_win_sdrs = inst_64476;
var label = inst_64481;
var sdr_sizes = inst_64467;
var wc_sdrv = inst_64415;
var G__64489 = inst_64507;
var cell_sdr_fracs = inst_64412;
return ((function (i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64507,inst_64434,inst_64487,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
return org.nfrac.comportex.util.update_each(m,win_sdrs,inc_label);
});
;})(i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64507,inst_64434,inst_64487,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64510 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64507,cljs.core.cst$kw$sdr_DASH_label_DASH_counts,inst_64509);
var state_64573__$1 = state_64573;
var statearr_64579_64941 = state_64573__$1;
(statearr_64579_64941[(2)] = inst_64510);

(statearr_64579_64941[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (1))){
var inst_64380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64381 = org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c,true);
var inst_64382 = ["get-cells-by-state",snapshot_id,region,layer,inst_64381];
var inst_64383 = (new cljs.core.PersistentVector(null,5,(5),inst_64380,inst_64382,null));
var inst_64384 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,inst_64383);
var state_64573__$1 = (function (){var statearr_64580 = state_64573;
(statearr_64580[(37)] = inst_64384);

return statearr_64580;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64573__$1,(2),response_c);
} else {
if((state_val_64574 === (24))){
var inst_64413 = (state_64573[(10)]);
var inst_64473 = (state_64573[(11)]);
var inst_64401 = (state_64573[(12)]);
var inst_64479 = (state_64573[(13)]);
var inst_64481 = (state_64573[(14)]);
var inst_64440 = (state_64573[(15)]);
var inst_64402 = (state_64573[(16)]);
var inst_64460 = (state_64573[(17)]);
var inst_64461 = (state_64573[(18)]);
var inst_64405 = (state_64573[(8)]);
var inst_64415 = (state_64573[(19)]);
var inst_64403 = (state_64573[(20)]);
var inst_64439 = (state_64573[(21)]);
var inst_64459 = (state_64573[(22)]);
var inst_64438 = (state_64573[(23)]);
var inst_64410 = (state_64573[(24)]);
var inst_64436 = (state_64573[(25)]);
var inst_64434 = (state_64573[(27)]);
var inst_64487 = (state_64573[(28)]);
var inst_64501 = (state_64573[(38)]);
var inst_64412 = (state_64573[(29)]);
var inst_64476 = (state_64573[(30)]);
var inst_64414 = (state_64573[(31)]);
var inst_64435 = (state_64573[(32)]);
var inst_64388 = (state_64573[(33)]);
var inst_64404 = (state_64573[(34)]);
var inst_64488 = (state_64573[(35)]);
var inst_64467 = (state_64573[(36)]);
var inst_64503 = (function (){var t = inst_64488;
var pc_sdrv = inst_64414;
var win_sdrs = inst_64435;
var vec__64386 = inst_64459;
var a_cols = inst_64439;
var ac_sdrv = inst_64413;
var win_gids = inst_64460;
var new_sdr = inst_64436;
var wc = inst_64402;
var vec__64385 = inst_64434;
var on_QMARK_ = inst_64405;
var gid_sizes = inst_64473;
var gidv = inst_64440;
var ac = inst_64403;
var cells_by_state = inst_64388;
var new_gid = inst_64461;
var inc_label = inst_64487;
var col_gid_fracs = inst_64438;
var pc = inst_64404;
var state = inst_64401;
var inc_win_gids = inst_64479;
var threshold = inst_64410;
var inc_win_sdrs = inst_64476;
var label = inst_64481;
var sdr_sizes = inst_64467;
var wc_sdrv = inst_64415;
var G__64489 = inst_64501;
var cell_sdr_fracs = inst_64412;
return ((function (i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64434,inst_64487,inst_64501,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
if(cljs.core.truth_(new_sdr)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new_sdr,cljs.core.first(win_gids));
} else {
return m;
}
});
;})(i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64434,inst_64487,inst_64501,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64504 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64501,cljs.core.cst$kw$sdr_DASH__GT_gid,inst_64503);
var state_64573__$1 = state_64573;
var statearr_64581_64942 = state_64573__$1;
(statearr_64581_64942[(2)] = inst_64504);

(statearr_64581_64942[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (39))){
var inst_64539 = (state_64573[(39)]);
var inst_64542 = (state_64573[(40)]);
var inst_64533 = (state_64573[(41)]);
var inst_64545 = (state_64573[(42)]);
var inst_64536 = (state_64573[(43)]);
var inst_64548 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64533,cljs.core.cst$kw$updated_DASH_sdr_DASH_sizes,inst_64536,cljs.core.array_seq([cljs.core.cst$kw$sdr_DASH_growth,inst_64539,cljs.core.cst$kw$updated_DASH_gid_DASH_sizes,inst_64542,cljs.core.cst$kw$gid_DASH_growth,inst_64545], 0));
var state_64573__$1 = state_64573;
var statearr_64582_64943 = state_64573__$1;
(statearr_64582_64943[(2)] = inst_64548);

(statearr_64582_64943[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (46))){
var inst_64551 = (state_64573[(44)]);
var state_64573__$1 = state_64573;
var statearr_64583_64944 = state_64573__$1;
(statearr_64583_64944[(2)] = inst_64551);

(statearr_64583_64944[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (4))){
var state_64573__$1 = state_64573;
var statearr_64584_64945 = state_64573__$1;
(statearr_64584_64945[(2)] = org.numenta.sanity.plots.empty_cell_sdrs_state);

(statearr_64584_64945[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (15))){
var inst_64468 = (state_64573[(45)]);
var state_64573__$1 = state_64573;
var statearr_64585_64946 = state_64573__$1;
(statearr_64585_64946[(2)] = inst_64468);

(statearr_64585_64946[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (21))){
var inst_64413 = (state_64573[(10)]);
var inst_64473 = (state_64573[(11)]);
var inst_64401 = (state_64573[(12)]);
var inst_64479 = (state_64573[(13)]);
var inst_64481 = (state_64573[(14)]);
var inst_64440 = (state_64573[(15)]);
var inst_64402 = (state_64573[(16)]);
var inst_64460 = (state_64573[(17)]);
var inst_64461 = (state_64573[(18)]);
var inst_64405 = (state_64573[(8)]);
var inst_64415 = (state_64573[(19)]);
var inst_64403 = (state_64573[(20)]);
var inst_64439 = (state_64573[(21)]);
var inst_64459 = (state_64573[(22)]);
var inst_64438 = (state_64573[(23)]);
var inst_64410 = (state_64573[(24)]);
var inst_64436 = (state_64573[(25)]);
var inst_64434 = (state_64573[(27)]);
var inst_64487 = (state_64573[(28)]);
var inst_64412 = (state_64573[(29)]);
var inst_64476 = (state_64573[(30)]);
var inst_64414 = (state_64573[(31)]);
var inst_64435 = (state_64573[(32)]);
var inst_64388 = (state_64573[(33)]);
var inst_64404 = (state_64573[(34)]);
var inst_64488 = (state_64573[(35)]);
var inst_64495 = (state_64573[(9)]);
var inst_64467 = (state_64573[(36)]);
var inst_64497 = (function (){var t = inst_64488;
var pc_sdrv = inst_64414;
var win_sdrs = inst_64435;
var vec__64386 = inst_64459;
var a_cols = inst_64439;
var ac_sdrv = inst_64413;
var win_gids = inst_64460;
var new_sdr = inst_64436;
var wc = inst_64402;
var vec__64385 = inst_64434;
var on_QMARK_ = inst_64405;
var gid_sizes = inst_64473;
var gidv = inst_64440;
var ac = inst_64403;
var cells_by_state = inst_64388;
var new_gid = inst_64461;
var inc_label = inst_64487;
var col_gid_fracs = inst_64438;
var pc = inst_64404;
var state = inst_64401;
var inc_win_gids = inst_64479;
var threshold = inst_64410;
var inc_win_sdrs = inst_64476;
var label = inst_64481;
var sdr_sizes = inst_64467;
var wc_sdrv = inst_64415;
var G__64489 = inst_64495;
var cell_sdr_fracs = inst_64412;
return ((function (i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64434,inst_64487,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64495,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
return org.nfrac.comportex.util.update_each(m,a_cols,inc_win_gids);
});
;})(i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64434,inst_64487,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64495,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64498 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64495,cljs.core.cst$kw$col_DASH_gid_DASH_counts,inst_64497);
var state_64573__$1 = state_64573;
var statearr_64586_64947 = state_64573__$1;
(statearr_64586_64947[(2)] = inst_64498);

(statearr_64586_64947[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (31))){
var inst_64513 = (state_64573[(46)]);
var state_64573__$1 = state_64573;
var statearr_64587_64948 = state_64573__$1;
(statearr_64587_64948[(2)] = inst_64513);

(statearr_64587_64948[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (32))){
var inst_64405 = (state_64573[(8)]);
var inst_64519 = (state_64573[(2)]);
var state_64573__$1 = (function (){var statearr_64588 = state_64573;
(statearr_64588[(47)] = inst_64519);

return statearr_64588;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64589_64949 = state_64573__$1;
(statearr_64589_64949[(1)] = (33));

} else {
var statearr_64590_64950 = state_64573__$1;
(statearr_64590_64950[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (40))){
var inst_64533 = (state_64573[(41)]);
var state_64573__$1 = state_64573;
var statearr_64591_64951 = state_64573__$1;
(statearr_64591_64951[(2)] = inst_64533);

(statearr_64591_64951[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (33))){
var inst_64519 = (state_64573[(47)]);
var inst_64435 = (state_64573[(32)]);
var inst_64521 = cljs.core.first(inst_64435);
var inst_64522 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(inst_64519,cljs.core.cst$kw$sdr_DASH_history,cljs.core.conj,inst_64521);
var state_64573__$1 = state_64573;
var statearr_64592_64952 = state_64573__$1;
(statearr_64592_64952[(2)] = inst_64522);

(statearr_64592_64952[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (13))){
var inst_64412 = (state_64573[(29)]);
var inst_64465 = org.numenta.sanity.plots.calc_sdr_sizes(inst_64412);
var state_64573__$1 = state_64573;
var statearr_64593_64953 = state_64573__$1;
(statearr_64593_64953[(2)] = inst_64465);

(statearr_64593_64953[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (22))){
var inst_64495 = (state_64573[(9)]);
var state_64573__$1 = state_64573;
var statearr_64594_64954 = state_64573__$1;
(statearr_64594_64954[(2)] = inst_64495);

(statearr_64594_64954[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (36))){
var inst_64413 = (state_64573[(10)]);
var inst_64473 = (state_64573[(11)]);
var inst_64525 = (state_64573[(48)]);
var inst_64415 = (state_64573[(19)]);
var inst_64410 = (state_64573[(24)]);
var inst_64414 = (state_64573[(31)]);
var inst_64488 = (state_64573[(35)]);
var inst_64467 = (state_64573[(36)]);
var inst_64527 = [cljs.core.cst$kw$winners,cljs.core.cst$kw$active,cljs.core.cst$kw$pred];
var inst_64528 = [inst_64415,inst_64413,inst_64414];
var inst_64529 = cljs.core.PersistentHashMap.fromArrays(inst_64527,inst_64528);
var inst_64530 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64525,cljs.core.cst$kw$sdr_DASH_transitions,null,cljs.core.array_seq([cljs.core.cst$kw$sdr_DASH_votes,inst_64529,cljs.core.cst$kw$sdr_DASH_sizes,inst_64467,cljs.core.cst$kw$gid_DASH_sizes,inst_64473,cljs.core.cst$kw$timestep,inst_64488,cljs.core.cst$kw$threshold,inst_64410], 0));
var state_64573__$1 = state_64573;
var statearr_64595_64955 = state_64573__$1;
(statearr_64595_64955[(2)] = inst_64530);

(statearr_64595_64955[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (41))){
var inst_64405 = (state_64573[(8)]);
var inst_64551 = (state_64573[(2)]);
var state_64573__$1 = (function (){var statearr_64596 = state_64573;
(statearr_64596[(44)] = inst_64551);

return statearr_64596;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64597_64956 = state_64573__$1;
(statearr_64597_64956[(1)] = (42));

} else {
var statearr_64598_64957 = state_64573__$1;
(statearr_64598_64957[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (43))){
var inst_64405 = (state_64573[(8)]);
var state_64573__$1 = state_64573;
var statearr_64599_64958 = state_64573__$1;
(statearr_64599_64958[(2)] = inst_64405);

(statearr_64599_64958[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (29))){
var inst_64405 = (state_64573[(8)]);
var inst_64513 = (state_64573[(2)]);
var state_64573__$1 = (function (){var statearr_64600 = state_64573;
(statearr_64600[(46)] = inst_64513);

return statearr_64600;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64601_64959 = state_64573__$1;
(statearr_64601_64959[(1)] = (30));

} else {
var statearr_64602_64960 = state_64573__$1;
(statearr_64602_64960[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (44))){
var inst_64555 = (state_64573[(2)]);
var state_64573__$1 = state_64573;
if(cljs.core.truth_(inst_64555)){
var statearr_64603_64961 = state_64573__$1;
(statearr_64603_64961[(1)] = (45));

} else {
var statearr_64604_64962 = state_64573__$1;
(statearr_64604_64962[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (6))){
var inst_64418 = (state_64573[(49)]);
var inst_64423 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64424 = [inst_64418,null];
var inst_64425 = (new cljs.core.PersistentVector(null,2,(5),inst_64423,inst_64424,null));
var state_64573__$1 = state_64573;
var statearr_64605_64963 = state_64573__$1;
(statearr_64605_64963[(2)] = inst_64425);

(statearr_64605_64963[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (28))){
var inst_64507 = (state_64573[(26)]);
var state_64573__$1 = state_64573;
var statearr_64606_64964 = state_64573__$1;
(statearr_64606_64964[(2)] = inst_64507);

(statearr_64606_64964[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (25))){
var inst_64501 = (state_64573[(38)]);
var state_64573__$1 = state_64573;
var statearr_64607_64965 = state_64573__$1;
(statearr_64607_64965[(2)] = inst_64501);

(statearr_64607_64965[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (34))){
var inst_64519 = (state_64573[(47)]);
var state_64573__$1 = state_64573;
var statearr_64608_64966 = state_64573__$1;
(statearr_64608_64966[(2)] = inst_64519);

(statearr_64608_64966[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (17))){
var inst_64481 = (state_64573[(14)]);
var inst_64460 = (state_64573[(17)]);
var inst_64405 = (state_64573[(8)]);
var inst_64435 = (state_64573[(32)]);
var inst_64473 = (state_64573[(2)]);
var inst_64474 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((1));
var inst_64475 = cljs.core.zipmap(inst_64435,inst_64474);
var inst_64476 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,inst_64475);
var inst_64477 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((1));
var inst_64478 = cljs.core.zipmap(inst_64460,inst_64477);
var inst_64479 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,inst_64478);
var inst_64480 = cljs.core.cst$kw$input_DASH_value.cljs$core$IFn$_invoke$arity$1(step);
var inst_64481__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64480,cljs.core.cst$kw$label,inst_64480);
var inst_64482 = [inst_64481__$1];
var inst_64483 = cljs.core.count(inst_64435);
var inst_64484 = ((1) / inst_64483);
var inst_64485 = [inst_64484];
var inst_64486 = cljs.core.PersistentHashMap.fromArrays(inst_64482,inst_64485);
var inst_64487 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,inst_64486);
var inst_64488 = cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(step);
var state_64573__$1 = (function (){var statearr_64609 = state_64573;
(statearr_64609[(11)] = inst_64473);

(statearr_64609[(13)] = inst_64479);

(statearr_64609[(14)] = inst_64481__$1);

(statearr_64609[(28)] = inst_64487);

(statearr_64609[(30)] = inst_64476);

(statearr_64609[(35)] = inst_64488);

return statearr_64609;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64610_64967 = state_64573__$1;
(statearr_64610_64967[(1)] = (18));

} else {
var statearr_64611_64968 = state_64573__$1;
(statearr_64611_64968[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (3))){
var inst_64397 = (state_64573[(50)]);
var state_64573__$1 = state_64573;
var statearr_64612_64969 = state_64573__$1;
(statearr_64612_64969[(2)] = inst_64397);

(statearr_64612_64969[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (12))){
var inst_64462 = (state_64573[(51)]);
var state_64573__$1 = state_64573;
var statearr_64613_64970 = state_64573__$1;
(statearr_64613_64970[(2)] = inst_64462);

(statearr_64613_64970[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (2))){
var inst_64397 = (state_64573[(50)]);
var inst_64388 = (state_64573[(2)]);
var inst_64389 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(states) : cljs.core.deref.call(null,states));
var inst_64390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64391 = cljs.core.cst$kw$snapshot_DASH_id.cljs$core$IFn$_invoke$arity$1(prev_step);
var inst_64392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64393 = [region,layer];
var inst_64394 = (new cljs.core.PersistentVector(null,2,(5),inst_64392,inst_64393,null));
var inst_64395 = [inst_64391,inst_64394];
var inst_64396 = (new cljs.core.PersistentVector(null,2,(5),inst_64390,inst_64395,null));
var inst_64397__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_64389,inst_64396);
var state_64573__$1 = (function (){var statearr_64614 = state_64573;
(statearr_64614[(50)] = inst_64397__$1);

(statearr_64614[(33)] = inst_64388);

return statearr_64614;
})();
if(cljs.core.truth_(inst_64397__$1)){
var statearr_64615_64971 = state_64573__$1;
(statearr_64615_64971[(1)] = (3));

} else {
var statearr_64616_64972 = state_64573__$1;
(statearr_64616_64972[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (23))){
var inst_64405 = (state_64573[(8)]);
var inst_64501 = (state_64573[(2)]);
var state_64573__$1 = (function (){var statearr_64617 = state_64573;
(statearr_64617[(38)] = inst_64501);

return statearr_64617;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64618_64973 = state_64573__$1;
(statearr_64618_64973[(1)] = (24));

} else {
var statearr_64619_64974 = state_64573__$1;
(statearr_64619_64974[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (47))){
var inst_64564 = (state_64573[(2)]);
var inst_64565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64566 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64567 = [region,layer];
var inst_64568 = (new cljs.core.PersistentVector(null,2,(5),inst_64566,inst_64567,null));
var inst_64569 = [snapshot_id,inst_64568];
var inst_64570 = (new cljs.core.PersistentVector(null,2,(5),inst_64565,inst_64569,null));
var inst_64571 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(states,cljs.core.assoc_in,inst_64570,inst_64564);
var state_64573__$1 = state_64573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64573__$1,inst_64571);
} else {
if((state_val_64574 === (35))){
var inst_64525 = (state_64573[(2)]);
var state_64573__$1 = (function (){var statearr_64620 = state_64573;
(statearr_64620[(48)] = inst_64525);

return statearr_64620;
})();
var statearr_64621_64975 = state_64573__$1;
(statearr_64621_64975[(1)] = (36));



return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (19))){
var inst_64401 = (state_64573[(12)]);
var state_64573__$1 = state_64573;
var statearr_64623_64976 = state_64573__$1;
(statearr_64623_64976[(2)] = inst_64401);

(statearr_64623_64976[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (11))){
var inst_64401 = (state_64573[(12)]);
var inst_64459 = (state_64573[(22)]);
var inst_64462 = (state_64573[(51)]);
var inst_64459__$1 = (state_64573[(2)]);
var inst_64460 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64459__$1,(0),null);
var inst_64461 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64459__$1,(1),null);
var inst_64462__$1 = cljs.core.cst$kw$updated_DASH_sdr_DASH_sizes.cljs$core$IFn$_invoke$arity$1(inst_64401);
var state_64573__$1 = (function (){var statearr_64624 = state_64573;
(statearr_64624[(17)] = inst_64460);

(statearr_64624[(18)] = inst_64461);

(statearr_64624[(22)] = inst_64459__$1);

(statearr_64624[(51)] = inst_64462__$1);

return statearr_64624;
})();
if(cljs.core.truth_(inst_64462__$1)){
var statearr_64625_64977 = state_64573__$1;
(statearr_64625_64977[(1)] = (12));

} else {
var statearr_64626_64978 = state_64573__$1;
(statearr_64626_64978[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (9))){
var inst_64443 = (state_64573[(52)]);
var inst_64448 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64449 = [inst_64443,null];
var inst_64450 = (new cljs.core.PersistentVector(null,2,(5),inst_64448,inst_64449,null));
var state_64573__$1 = state_64573;
var statearr_64627_64979 = state_64573__$1;
(statearr_64627_64979[(2)] = inst_64450);

(statearr_64627_64979[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (5))){
var inst_64413 = (state_64573[(10)]);
var inst_64401 = (state_64573[(12)]);
var inst_64402 = (state_64573[(16)]);
var inst_64405 = (state_64573[(8)]);
var inst_64415 = (state_64573[(19)]);
var inst_64403 = (state_64573[(20)]);
var inst_64410 = (state_64573[(24)]);
var inst_64412 = (state_64573[(29)]);
var inst_64418 = (state_64573[(49)]);
var inst_64414 = (state_64573[(31)]);
var inst_64388 = (state_64573[(33)]);
var inst_64404 = (state_64573[(34)]);
var inst_64401__$1 = (state_64573[(2)]);
var inst_64402__$1 = cljs.core.cst$kw$winner_DASH_cells.cljs$core$IFn$_invoke$arity$1(inst_64388);
var inst_64403__$1 = cljs.core.cst$kw$active_DASH_cells.cljs$core$IFn$_invoke$arity$1(inst_64388);
var inst_64404__$1 = cljs.core.cst$kw$pred_DASH_cells.cljs$core$IFn$_invoke$arity$1(inst_64388);
var inst_64405__$1 = cljs.core.cst$kw$engaged_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_64388);
var inst_64406 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape));
var inst_64407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64408 = [cljs.core.cst$kw$regions,region,layer,cljs.core.cst$kw$spec,cljs.core.cst$kw$distal,cljs.core.cst$kw$learn_DASH_threshold];
var inst_64409 = (new cljs.core.PersistentVector(null,6,(5),inst_64407,inst_64408,null));
var inst_64410__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_64406,inst_64409);
var inst_64411 = cljs.core.cst$kw$cell_DASH_sdr_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64401__$1);
var inst_64412__$1 = org.nfrac.comportex.util.remap(org.numenta.sanity.plots.freqs__GT_fracs,inst_64411);
var inst_64413__$1 = org.numenta.sanity.plots.sdr_votes(inst_64403__$1,inst_64412__$1);
var inst_64414__$1 = org.numenta.sanity.plots.sdr_votes(inst_64404__$1,inst_64412__$1);
var inst_64415__$1 = org.numenta.sanity.plots.sdr_votes(inst_64402__$1,inst_64412__$1);
var inst_64417 = (function (){var pc_sdrv = inst_64414__$1;
var ac_sdrv = inst_64413__$1;
var wc = inst_64402__$1;
var on_QMARK_ = inst_64405__$1;
var ac = inst_64403__$1;
var cells_by_state = inst_64388;
var pc = inst_64404__$1;
var state = inst_64401__$1;
var threshold = inst_64410__$1;
var wc_sdrv = inst_64415__$1;
var cell_sdr_fracs = inst_64412__$1;
return ((function (i__62697,s__62694__$1,pc_sdrv,ac_sdrv,wc,on_QMARK_,ac,cells_by_state,pc,state,threshold,wc_sdrv,cell_sdr_fracs,inst_64413,inst_64401,inst_64402,inst_64405,inst_64415,inst_64403,inst_64410,inst_64412,inst_64418,inst_64414,inst_64388,inst_64404,inst_64401__$1,inst_64402__$1,inst_64403__$1,inst_64404__$1,inst_64405__$1,inst_64406,inst_64407,inst_64408,inst_64409,inst_64410__$1,inst_64411,inst_64412__$1,inst_64413__$1,inst_64414__$1,inst_64415__$1,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (p__64416){
var vec__64628 = p__64416;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64628,(0),null);
var vote = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64628,(1),null);
if((vote >= threshold)){
return id;
} else {
return null;
}
});
;})(i__62697,s__62694__$1,pc_sdrv,ac_sdrv,wc,on_QMARK_,ac,cells_by_state,pc,state,threshold,wc_sdrv,cell_sdr_fracs,inst_64413,inst_64401,inst_64402,inst_64405,inst_64415,inst_64403,inst_64410,inst_64412,inst_64418,inst_64414,inst_64388,inst_64404,inst_64401__$1,inst_64402__$1,inst_64403__$1,inst_64404__$1,inst_64405__$1,inst_64406,inst_64407,inst_64408,inst_64409,inst_64410__$1,inst_64411,inst_64412__$1,inst_64413__$1,inst_64414__$1,inst_64415__$1,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64418__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_64417,inst_64415__$1);
var inst_64419 = cljs.core.cst$kw$sdr_DASH_label_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64401__$1);
var inst_64420 = cljs.core.count(inst_64419);
var inst_64421 = cljs.core.seq(inst_64418__$1);
var state_64573__$1 = (function (){var statearr_64629 = state_64573;
(statearr_64629[(10)] = inst_64413__$1);

(statearr_64629[(12)] = inst_64401__$1);

(statearr_64629[(16)] = inst_64402__$1);

(statearr_64629[(8)] = inst_64405__$1);

(statearr_64629[(19)] = inst_64415__$1);

(statearr_64629[(20)] = inst_64403__$1);

(statearr_64629[(24)] = inst_64410__$1);

(statearr_64629[(7)] = inst_64420);

(statearr_64629[(29)] = inst_64412__$1);

(statearr_64629[(49)] = inst_64418__$1);

(statearr_64629[(31)] = inst_64414__$1);

(statearr_64629[(34)] = inst_64404__$1);

return statearr_64629;
})();
if(inst_64421){
var statearr_64630_64980 = state_64573__$1;
(statearr_64630_64980[(1)] = (6));

} else {
var statearr_64631_64981 = state_64573__$1;
(statearr_64631_64981[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (14))){
var inst_64468 = (state_64573[(45)]);
var inst_64401 = (state_64573[(12)]);
var inst_64467 = (state_64573[(2)]);
var inst_64468__$1 = cljs.core.cst$kw$updated_DASH_gid_DASH_sizes.cljs$core$IFn$_invoke$arity$1(inst_64401);
var state_64573__$1 = (function (){var statearr_64632 = state_64573;
(statearr_64632[(45)] = inst_64468__$1);

(statearr_64632[(36)] = inst_64467);

return statearr_64632;
})();
if(cljs.core.truth_(inst_64468__$1)){
var statearr_64633_64982 = state_64573__$1;
(statearr_64633_64982[(1)] = (15));

} else {
var statearr_64634_64983 = state_64573__$1;
(statearr_64634_64983[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (45))){
var inst_64551 = (state_64573[(44)]);
var inst_64539 = (state_64573[(39)]);
var inst_64436 = (state_64573[(25)]);
var inst_64557 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64558 = [cljs.core.cst$kw$sdr_DASH_votes,cljs.core.cst$kw$winners,inst_64436];
var inst_64559 = (new cljs.core.PersistentVector(null,3,(5),inst_64557,inst_64558,null));
var inst_64560 = (inst_64539.cljs$core$IFn$_invoke$arity$1 ? inst_64539.cljs$core$IFn$_invoke$arity$1(inst_64436) : inst_64539.call(null,inst_64436));
var inst_64561 = cljs.core.assoc_in(inst_64551,inst_64559,inst_64560);
var state_64573__$1 = state_64573;
var statearr_64635_64984 = state_64573__$1;
(statearr_64635_64984[(2)] = inst_64561);

(statearr_64635_64984[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (26))){
var inst_64405 = (state_64573[(8)]);
var inst_64507 = (state_64573[(2)]);
var state_64573__$1 = (function (){var statearr_64636 = state_64573;
(statearr_64636[(26)] = inst_64507);

return statearr_64636;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64637_64985 = state_64573__$1;
(statearr_64637_64985[(1)] = (27));

} else {
var statearr_64638_64986 = state_64573__$1;
(statearr_64638_64986[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (16))){
var inst_64438 = (state_64573[(23)]);
var inst_64471 = org.numenta.sanity.plots.calc_sdr_sizes(inst_64438);
var state_64573__$1 = state_64573;
var statearr_64639_64987 = state_64573__$1;
(statearr_64639_64987[(2)] = inst_64471);

(statearr_64639_64987[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (38))){
var inst_64473 = (state_64573[(11)]);
var inst_64460 = (state_64573[(17)]);
var inst_64405 = (state_64573[(8)]);
var inst_64542 = (state_64573[(40)]);
var inst_64533 = (state_64573[(41)]);
var inst_64435 = (state_64573[(32)]);
var inst_64536 = (state_64573[(43)]);
var inst_64467 = (state_64573[(36)]);
var inst_64533__$1 = (state_64573[(2)]);
var inst_64534 = cljs.core.cst$kw$cell_DASH_sdr_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64533__$1);
var inst_64535 = org.nfrac.comportex.util.remap(org.numenta.sanity.plots.freqs__GT_fracs,inst_64534);
var inst_64536__$1 = org.numenta.sanity.plots.calc_sdr_sizes(inst_64535);
var inst_64537 = cljs.core.select_keys(inst_64536__$1,inst_64435);
var inst_64538 = cljs.core.select_keys(inst_64467,inst_64435);
var inst_64539 = cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._,cljs.core.array_seq([inst_64537,inst_64538], 0));
var inst_64540 = cljs.core.cst$kw$col_DASH_gid_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64533__$1);
var inst_64541 = org.nfrac.comportex.util.remap(org.numenta.sanity.plots.freqs__GT_fracs,inst_64540);
var inst_64542__$1 = org.numenta.sanity.plots.calc_sdr_sizes(inst_64541);
var inst_64543 = cljs.core.select_keys(inst_64542__$1,inst_64460);
var inst_64544 = cljs.core.select_keys(inst_64473,inst_64460);
var inst_64545 = cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._,cljs.core.array_seq([inst_64543,inst_64544], 0));
var state_64573__$1 = (function (){var statearr_64640 = state_64573;
(statearr_64640[(39)] = inst_64539);

(statearr_64640[(40)] = inst_64542__$1);

(statearr_64640[(41)] = inst_64533__$1);

(statearr_64640[(42)] = inst_64545);

(statearr_64640[(43)] = inst_64536__$1);

return statearr_64640;
})();
if(cljs.core.truth_(inst_64405)){
var statearr_64641_64988 = state_64573__$1;
(statearr_64641_64988[(1)] = (39));

} else {
var statearr_64642_64989 = state_64573__$1;
(statearr_64642_64989[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (30))){
var inst_64413 = (state_64573[(10)]);
var inst_64473 = (state_64573[(11)]);
var inst_64401 = (state_64573[(12)]);
var inst_64479 = (state_64573[(13)]);
var inst_64481 = (state_64573[(14)]);
var inst_64440 = (state_64573[(15)]);
var inst_64402 = (state_64573[(16)]);
var inst_64460 = (state_64573[(17)]);
var inst_64513 = (state_64573[(46)]);
var inst_64461 = (state_64573[(18)]);
var inst_64405 = (state_64573[(8)]);
var inst_64415 = (state_64573[(19)]);
var inst_64403 = (state_64573[(20)]);
var inst_64439 = (state_64573[(21)]);
var inst_64459 = (state_64573[(22)]);
var inst_64438 = (state_64573[(23)]);
var inst_64410 = (state_64573[(24)]);
var inst_64436 = (state_64573[(25)]);
var inst_64434 = (state_64573[(27)]);
var inst_64487 = (state_64573[(28)]);
var inst_64412 = (state_64573[(29)]);
var inst_64476 = (state_64573[(30)]);
var inst_64414 = (state_64573[(31)]);
var inst_64435 = (state_64573[(32)]);
var inst_64388 = (state_64573[(33)]);
var inst_64404 = (state_64573[(34)]);
var inst_64488 = (state_64573[(35)]);
var inst_64467 = (state_64573[(36)]);
var inst_64515 = (function (){var t = inst_64488;
var pc_sdrv = inst_64414;
var win_sdrs = inst_64435;
var vec__64386 = inst_64459;
var a_cols = inst_64439;
var ac_sdrv = inst_64413;
var win_gids = inst_64460;
var new_sdr = inst_64436;
var wc = inst_64402;
var vec__64385 = inst_64434;
var on_QMARK_ = inst_64405;
var gid_sizes = inst_64473;
var gidv = inst_64440;
var ac = inst_64403;
var cells_by_state = inst_64388;
var new_gid = inst_64461;
var inc_label = inst_64487;
var col_gid_fracs = inst_64438;
var pc = inst_64404;
var state = inst_64401;
var inc_win_gids = inst_64479;
var threshold = inst_64410;
var inc_win_sdrs = inst_64476;
var label = inst_64481;
var sdr_sizes = inst_64467;
var wc_sdrv = inst_64415;
var G__64489 = inst_64513;
var cell_sdr_fracs = inst_64412;
return ((function (i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64513,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64434,inst_64487,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([m,cljs.core.zipmap(win_sdrs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(t))], 0));
});
;})(i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64513,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64434,inst_64487,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64516 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64513,cljs.core.cst$kw$sdr_DASH_last_DASH_matches,inst_64515);
var state_64573__$1 = state_64573;
var statearr_64643_64990 = state_64573__$1;
(statearr_64643_64990[(2)] = inst_64516);

(statearr_64643_64990[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (10))){
var inst_64445 = (state_64573[(53)]);
var inst_64452 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64453 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64454 = [inst_64445];
var inst_64455 = (new cljs.core.PersistentVector(null,1,(5),inst_64453,inst_64454,null));
var inst_64456 = [inst_64455,inst_64445];
var inst_64457 = (new cljs.core.PersistentVector(null,2,(5),inst_64452,inst_64456,null));
var state_64573__$1 = state_64573;
var statearr_64644_64991 = state_64573__$1;
(statearr_64644_64991[(2)] = inst_64457);

(statearr_64644_64991[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (18))){
var inst_64413 = (state_64573[(10)]);
var inst_64473 = (state_64573[(11)]);
var inst_64401 = (state_64573[(12)]);
var inst_64479 = (state_64573[(13)]);
var inst_64481 = (state_64573[(14)]);
var inst_64440 = (state_64573[(15)]);
var inst_64402 = (state_64573[(16)]);
var inst_64460 = (state_64573[(17)]);
var inst_64461 = (state_64573[(18)]);
var inst_64405 = (state_64573[(8)]);
var inst_64415 = (state_64573[(19)]);
var inst_64403 = (state_64573[(20)]);
var inst_64439 = (state_64573[(21)]);
var inst_64459 = (state_64573[(22)]);
var inst_64438 = (state_64573[(23)]);
var inst_64410 = (state_64573[(24)]);
var inst_64436 = (state_64573[(25)]);
var inst_64434 = (state_64573[(27)]);
var inst_64487 = (state_64573[(28)]);
var inst_64412 = (state_64573[(29)]);
var inst_64476 = (state_64573[(30)]);
var inst_64414 = (state_64573[(31)]);
var inst_64435 = (state_64573[(32)]);
var inst_64388 = (state_64573[(33)]);
var inst_64404 = (state_64573[(34)]);
var inst_64488 = (state_64573[(35)]);
var inst_64467 = (state_64573[(36)]);
var inst_64491 = (function (){var t = inst_64488;
var pc_sdrv = inst_64414;
var win_sdrs = inst_64435;
var vec__64386 = inst_64459;
var a_cols = inst_64439;
var ac_sdrv = inst_64413;
var win_gids = inst_64460;
var new_sdr = inst_64436;
var wc = inst_64402;
var vec__64385 = inst_64434;
var on_QMARK_ = inst_64405;
var gid_sizes = inst_64473;
var gidv = inst_64440;
var ac = inst_64403;
var cells_by_state = inst_64388;
var new_gid = inst_64461;
var inc_label = inst_64487;
var col_gid_fracs = inst_64438;
var pc = inst_64404;
var state = inst_64401;
var inc_win_gids = inst_64479;
var threshold = inst_64410;
var inc_win_sdrs = inst_64476;
var label = inst_64481;
var sdr_sizes = inst_64467;
var wc_sdrv = inst_64415;
var G__64489 = inst_64401;
var cell_sdr_fracs = inst_64412;
return ((function (i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64434,inst_64487,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
return org.nfrac.comportex.util.update_each(m,wc,inc_win_sdrs);
});
;})(i__62697,s__62694__$1,t,pc_sdrv,win_sdrs,vec__64386,a_cols,ac_sdrv,win_gids,new_sdr,wc,vec__64385,on_QMARK_,gid_sizes,gidv,ac,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64489,cell_sdr_fracs,inst_64413,inst_64473,inst_64401,inst_64479,inst_64481,inst_64440,inst_64402,inst_64460,inst_64461,inst_64405,inst_64415,inst_64403,inst_64439,inst_64459,inst_64438,inst_64410,inst_64436,inst_64434,inst_64487,inst_64412,inst_64476,inst_64414,inst_64435,inst_64388,inst_64404,inst_64488,inst_64467,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64492 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64401,cljs.core.cst$kw$cell_DASH_sdr_DASH_counts,inst_64491);
var state_64573__$1 = state_64573;
var statearr_64645_64992 = state_64573__$1;
(statearr_64645_64992[(2)] = inst_64492);

(statearr_64645_64992[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (42))){
var inst_64436 = (state_64573[(25)]);
var state_64573__$1 = state_64573;
var statearr_64646_64993 = state_64573__$1;
(statearr_64646_64993[(2)] = inst_64436);

(statearr_64646_64993[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (37))){
var inst_64525 = (state_64573[(48)]);
var state_64573__$1 = state_64573;
var statearr_64647_64994 = state_64573__$1;
(statearr_64647_64994[(2)] = inst_64525);

(statearr_64647_64994[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64574 === (8))){
var inst_64413 = (state_64573[(10)]);
var inst_64401 = (state_64573[(12)]);
var inst_64440 = (state_64573[(15)]);
var inst_64402 = (state_64573[(16)]);
var inst_64405 = (state_64573[(8)]);
var inst_64415 = (state_64573[(19)]);
var inst_64403 = (state_64573[(20)]);
var inst_64439 = (state_64573[(21)]);
var inst_64438 = (state_64573[(23)]);
var inst_64410 = (state_64573[(24)]);
var inst_64436 = (state_64573[(25)]);
var inst_64434 = (state_64573[(27)]);
var inst_64412 = (state_64573[(29)]);
var inst_64414 = (state_64573[(31)]);
var inst_64435 = (state_64573[(32)]);
var inst_64388 = (state_64573[(33)]);
var inst_64404 = (state_64573[(34)]);
var inst_64443 = (state_64573[(52)]);
var inst_64434__$1 = (state_64573[(2)]);
var inst_64435__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64434__$1,(0),null);
var inst_64436__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64434__$1,(1),null);
var inst_64437 = cljs.core.cst$kw$col_DASH_gid_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64401);
var inst_64438__$1 = org.nfrac.comportex.util.remap(org.numenta.sanity.plots.freqs__GT_fracs,inst_64437);
var inst_64439__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,inst_64402);
var inst_64440__$1 = org.numenta.sanity.plots.sdr_votes(inst_64439__$1,inst_64438__$1);
var inst_64442 = (function (){var pc_sdrv = inst_64414;
var win_sdrs = inst_64435__$1;
var a_cols = inst_64439__$1;
var ac_sdrv = inst_64413;
var new_sdr = inst_64436__$1;
var wc = inst_64402;
var vec__64385 = inst_64434__$1;
var on_QMARK_ = inst_64405;
var gidv = inst_64440__$1;
var ac = inst_64403;
var cells_by_state = inst_64388;
var col_gid_fracs = inst_64438__$1;
var pc = inst_64404;
var state = inst_64401;
var threshold = inst_64410;
var wc_sdrv = inst_64415;
var cell_sdr_fracs = inst_64412;
return ((function (i__62697,s__62694__$1,pc_sdrv,win_sdrs,a_cols,ac_sdrv,new_sdr,wc,vec__64385,on_QMARK_,gidv,ac,cells_by_state,col_gid_fracs,pc,state,threshold,wc_sdrv,cell_sdr_fracs,inst_64413,inst_64401,inst_64440,inst_64402,inst_64405,inst_64415,inst_64403,inst_64439,inst_64438,inst_64410,inst_64436,inst_64434,inst_64412,inst_64414,inst_64435,inst_64388,inst_64404,inst_64443,inst_64434__$1,inst_64435__$1,inst_64436__$1,inst_64437,inst_64438__$1,inst_64439__$1,inst_64440__$1,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (p__64441){
var vec__64648 = p__64441;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64648,(0),null);
var vote = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64648,(1),null);
if((vote >= threshold)){
return id;
} else {
return null;
}
});
;})(i__62697,s__62694__$1,pc_sdrv,win_sdrs,a_cols,ac_sdrv,new_sdr,wc,vec__64385,on_QMARK_,gidv,ac,cells_by_state,col_gid_fracs,pc,state,threshold,wc_sdrv,cell_sdr_fracs,inst_64413,inst_64401,inst_64440,inst_64402,inst_64405,inst_64415,inst_64403,inst_64439,inst_64438,inst_64410,inst_64436,inst_64434,inst_64412,inst_64414,inst_64435,inst_64388,inst_64404,inst_64443,inst_64434__$1,inst_64435__$1,inst_64436__$1,inst_64437,inst_64438__$1,inst_64439__$1,inst_64440__$1,state_val_64574,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64443__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_64442,inst_64440__$1);
var inst_64444 = cljs.core.cst$kw$sdr_DASH_label_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64401);
var inst_64445 = cljs.core.count(inst_64444);
var inst_64446 = cljs.core.seq(inst_64443__$1);
var state_64573__$1 = (function (){var statearr_64649 = state_64573;
(statearr_64649[(15)] = inst_64440__$1);

(statearr_64649[(21)] = inst_64439__$1);

(statearr_64649[(23)] = inst_64438__$1);

(statearr_64649[(25)] = inst_64436__$1);

(statearr_64649[(27)] = inst_64434__$1);

(statearr_64649[(53)] = inst_64445);

(statearr_64649[(32)] = inst_64435__$1);

(statearr_64649[(52)] = inst_64443__$1);

return statearr_64649;
})();
if(inst_64446){
var statearr_64650_64995 = state_64573__$1;
(statearr_64650_64995[(1)] = (9));

} else {
var statearr_64651_64996 = state_64573__$1;
(statearr_64651_64996[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(i__62697,s__62694__$1,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
;
return ((function (i__62697,s__62694__$1,switch__37995__auto__,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function() {
var org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__ = null;
var org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____0 = (function (){
var statearr_64655 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64655[(0)] = org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__);

(statearr_64655[(1)] = (1));

return statearr_64655;
});
var org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____1 = (function (state_64573){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_64573);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e64656){if((e64656 instanceof Object)){
var ex__37999__auto__ = e64656;
var statearr_64657_64997 = state_64573;
(statearr_64657_64997[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_64573);

return cljs.core.cst$kw$recur;
} else {
throw e64656;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__64998 = state_64573;
state_64573 = G__64998;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__ = function(state_64573){
switch(arguments.length){
case 0:
return org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____1.call(this,state_64573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____0;
org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____1;
return org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__;
})()
;})(i__62697,s__62694__$1,switch__37995__auto__,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var state__38111__auto__ = (function (){var statearr_64658 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_64658[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_64658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(i__62697,s__62694__$1,c__38109__auto__,response_c,snapshot_id,layer,c__6923__auto__,size__6924__auto__,b__62698,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
);

return c__38109__auto__;
})());

var G__64999 = (i__62697 + (1));
i__62697 = G__64999;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__62698),org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695(cljs.core.chunk_rest(s__62696__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__62698),null);
}
} else {
var layer = cljs.core.first(s__62696__$2);
var response_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var snapshot_id = cljs.core.cst$kw$snapshot_DASH_id.cljs$core$IFn$_invoke$arity$1(step);
return cljs.core.cons((function (){var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (s__62694__$1,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (s__62694__$1,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (state_64852){
var state_val_64853 = (state_64852[(1)]);
if((state_val_64853 === (7))){
var inst_64699 = (state_64852[(7)]);
var inst_64706 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64707 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64708 = [inst_64699];
var inst_64709 = (new cljs.core.PersistentVector(null,1,(5),inst_64707,inst_64708,null));
var inst_64710 = [inst_64709,inst_64699];
var inst_64711 = (new cljs.core.PersistentVector(null,2,(5),inst_64706,inst_64710,null));
var state_64852__$1 = state_64852;
var statearr_64854_65000 = state_64852__$1;
(statearr_64854_65000[(2)] = inst_64711);

(statearr_64854_65000[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (20))){
var inst_64684 = (state_64852[(8)]);
var inst_64774 = (state_64852[(2)]);
var state_64852__$1 = (function (){var statearr_64855 = state_64852;
(statearr_64855[(9)] = inst_64774);

return statearr_64855;
})();
if(cljs.core.truth_(inst_64684)){
var statearr_64856_65001 = state_64852__$1;
(statearr_64856_65001[(1)] = (21));

} else {
var statearr_64857_65002 = state_64852__$1;
(statearr_64857_65002[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (27))){
var inst_64715 = (state_64852[(10)]);
var inst_64752 = (state_64852[(11)]);
var inst_64667 = (state_64852[(12)]);
var inst_64693 = (state_64852[(13)]);
var inst_64713 = (state_64852[(14)]);
var inst_64755 = (state_64852[(15)]);
var inst_64680 = (state_64852[(16)]);
var inst_64738 = (state_64852[(17)]);
var inst_64739 = (state_64852[(18)]);
var inst_64692 = (state_64852[(19)]);
var inst_64718 = (state_64852[(20)]);
var inst_64758 = (state_64852[(21)]);
var inst_64760 = (state_64852[(22)]);
var inst_64719 = (state_64852[(23)]);
var inst_64740 = (state_64852[(24)]);
var inst_64691 = (state_64852[(25)]);
var inst_64717 = (state_64852[(26)]);
var inst_64766 = (state_64852[(27)]);
var inst_64746 = (state_64852[(28)]);
var inst_64714 = (state_64852[(29)]);
var inst_64681 = (state_64852[(30)]);
var inst_64683 = (state_64852[(31)]);
var inst_64689 = (state_64852[(32)]);
var inst_64767 = (state_64852[(33)]);
var inst_64682 = (state_64852[(34)]);
var inst_64694 = (state_64852[(35)]);
var inst_64684 = (state_64852[(8)]);
var inst_64786 = (state_64852[(36)]);
var inst_64788 = (function (){var t = inst_64767;
var pc_sdrv = inst_64693;
var win_sdrs = inst_64714;
var a_cols = inst_64718;
var ac_sdrv = inst_64692;
var vec__64665 = inst_64738;
var win_gids = inst_64739;
var new_sdr = inst_64715;
var wc = inst_64681;
var on_QMARK_ = inst_64684;
var gid_sizes = inst_64752;
var gidv = inst_64719;
var ac = inst_64682;
var vec__64664 = inst_64713;
var cells_by_state = inst_64667;
var new_gid = inst_64740;
var inc_label = inst_64766;
var col_gid_fracs = inst_64717;
var pc = inst_64683;
var state = inst_64680;
var inc_win_gids = inst_64758;
var threshold = inst_64689;
var inc_win_sdrs = inst_64755;
var label = inst_64760;
var sdr_sizes = inst_64746;
var wc_sdrv = inst_64694;
var G__64768 = inst_64786;
var cell_sdr_fracs = inst_64691;
return ((function (s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64693,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,inst_64786,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
return org.nfrac.comportex.util.update_each(m,win_sdrs,inc_label);
});
;})(s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64693,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,inst_64786,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64789 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64786,cljs.core.cst$kw$sdr_DASH_label_DASH_counts,inst_64788);
var state_64852__$1 = state_64852;
var statearr_64858_65003 = state_64852__$1;
(statearr_64858_65003[(2)] = inst_64789);

(statearr_64858_65003[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (1))){
var inst_64659 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64660 = org.numenta.sanity.bridge.marshalling.channel.cljs$core$IFn$_invoke$arity$2(response_c,true);
var inst_64661 = ["get-cells-by-state",snapshot_id,region,layer,inst_64660];
var inst_64662 = (new cljs.core.PersistentVector(null,5,(5),inst_64659,inst_64661,null));
var inst_64663 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(into_journal,inst_64662);
var state_64852__$1 = (function (){var statearr_64859 = state_64852;
(statearr_64859[(37)] = inst_64663);

return statearr_64859;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64852__$1,(2),response_c);
} else {
if((state_val_64853 === (24))){
var inst_64715 = (state_64852[(10)]);
var inst_64752 = (state_64852[(11)]);
var inst_64667 = (state_64852[(12)]);
var inst_64693 = (state_64852[(13)]);
var inst_64713 = (state_64852[(14)]);
var inst_64755 = (state_64852[(15)]);
var inst_64680 = (state_64852[(16)]);
var inst_64738 = (state_64852[(17)]);
var inst_64739 = (state_64852[(18)]);
var inst_64692 = (state_64852[(19)]);
var inst_64718 = (state_64852[(20)]);
var inst_64758 = (state_64852[(21)]);
var inst_64760 = (state_64852[(22)]);
var inst_64719 = (state_64852[(23)]);
var inst_64780 = (state_64852[(38)]);
var inst_64740 = (state_64852[(24)]);
var inst_64691 = (state_64852[(25)]);
var inst_64717 = (state_64852[(26)]);
var inst_64766 = (state_64852[(27)]);
var inst_64746 = (state_64852[(28)]);
var inst_64714 = (state_64852[(29)]);
var inst_64681 = (state_64852[(30)]);
var inst_64683 = (state_64852[(31)]);
var inst_64689 = (state_64852[(32)]);
var inst_64767 = (state_64852[(33)]);
var inst_64682 = (state_64852[(34)]);
var inst_64694 = (state_64852[(35)]);
var inst_64684 = (state_64852[(8)]);
var inst_64782 = (function (){var t = inst_64767;
var pc_sdrv = inst_64693;
var win_sdrs = inst_64714;
var a_cols = inst_64718;
var ac_sdrv = inst_64692;
var vec__64665 = inst_64738;
var win_gids = inst_64739;
var new_sdr = inst_64715;
var wc = inst_64681;
var on_QMARK_ = inst_64684;
var gid_sizes = inst_64752;
var gidv = inst_64719;
var ac = inst_64682;
var vec__64664 = inst_64713;
var cells_by_state = inst_64667;
var new_gid = inst_64740;
var inc_label = inst_64766;
var col_gid_fracs = inst_64717;
var pc = inst_64683;
var state = inst_64680;
var inc_win_gids = inst_64758;
var threshold = inst_64689;
var inc_win_sdrs = inst_64755;
var label = inst_64760;
var sdr_sizes = inst_64746;
var wc_sdrv = inst_64694;
var G__64768 = inst_64780;
var cell_sdr_fracs = inst_64691;
return ((function (s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64693,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64780,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
if(cljs.core.truth_(new_sdr)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new_sdr,cljs.core.first(win_gids));
} else {
return m;
}
});
;})(s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64693,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64780,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64783 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64780,cljs.core.cst$kw$sdr_DASH__GT_gid,inst_64782);
var state_64852__$1 = state_64852;
var statearr_64860_65004 = state_64852__$1;
(statearr_64860_65004[(2)] = inst_64783);

(statearr_64860_65004[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (39))){
var inst_64818 = (state_64852[(39)]);
var inst_64821 = (state_64852[(40)]);
var inst_64824 = (state_64852[(41)]);
var inst_64815 = (state_64852[(42)]);
var inst_64812 = (state_64852[(43)]);
var inst_64827 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64812,cljs.core.cst$kw$updated_DASH_sdr_DASH_sizes,inst_64815,cljs.core.array_seq([cljs.core.cst$kw$sdr_DASH_growth,inst_64818,cljs.core.cst$kw$updated_DASH_gid_DASH_sizes,inst_64821,cljs.core.cst$kw$gid_DASH_growth,inst_64824], 0));
var state_64852__$1 = state_64852;
var statearr_64861_65005 = state_64852__$1;
(statearr_64861_65005[(2)] = inst_64827);

(statearr_64861_65005[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (46))){
var inst_64830 = (state_64852[(44)]);
var state_64852__$1 = state_64852;
var statearr_64862_65006 = state_64852__$1;
(statearr_64862_65006[(2)] = inst_64830);

(statearr_64862_65006[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (4))){
var state_64852__$1 = state_64852;
var statearr_64863_65007 = state_64852__$1;
(statearr_64863_65007[(2)] = org.numenta.sanity.plots.empty_cell_sdrs_state);

(statearr_64863_65007[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (15))){
var inst_64747 = (state_64852[(45)]);
var state_64852__$1 = state_64852;
var statearr_64864_65008 = state_64852__$1;
(statearr_64864_65008[(2)] = inst_64747);

(statearr_64864_65008[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (21))){
var inst_64715 = (state_64852[(10)]);
var inst_64752 = (state_64852[(11)]);
var inst_64667 = (state_64852[(12)]);
var inst_64693 = (state_64852[(13)]);
var inst_64774 = (state_64852[(9)]);
var inst_64713 = (state_64852[(14)]);
var inst_64755 = (state_64852[(15)]);
var inst_64680 = (state_64852[(16)]);
var inst_64738 = (state_64852[(17)]);
var inst_64739 = (state_64852[(18)]);
var inst_64692 = (state_64852[(19)]);
var inst_64718 = (state_64852[(20)]);
var inst_64758 = (state_64852[(21)]);
var inst_64760 = (state_64852[(22)]);
var inst_64719 = (state_64852[(23)]);
var inst_64740 = (state_64852[(24)]);
var inst_64691 = (state_64852[(25)]);
var inst_64717 = (state_64852[(26)]);
var inst_64766 = (state_64852[(27)]);
var inst_64746 = (state_64852[(28)]);
var inst_64714 = (state_64852[(29)]);
var inst_64681 = (state_64852[(30)]);
var inst_64683 = (state_64852[(31)]);
var inst_64689 = (state_64852[(32)]);
var inst_64767 = (state_64852[(33)]);
var inst_64682 = (state_64852[(34)]);
var inst_64694 = (state_64852[(35)]);
var inst_64684 = (state_64852[(8)]);
var inst_64776 = (function (){var t = inst_64767;
var pc_sdrv = inst_64693;
var win_sdrs = inst_64714;
var a_cols = inst_64718;
var ac_sdrv = inst_64692;
var vec__64665 = inst_64738;
var win_gids = inst_64739;
var new_sdr = inst_64715;
var wc = inst_64681;
var on_QMARK_ = inst_64684;
var gid_sizes = inst_64752;
var gidv = inst_64719;
var ac = inst_64682;
var vec__64664 = inst_64713;
var cells_by_state = inst_64667;
var new_gid = inst_64740;
var inc_label = inst_64766;
var col_gid_fracs = inst_64717;
var pc = inst_64683;
var state = inst_64680;
var inc_win_gids = inst_64758;
var threshold = inst_64689;
var inc_win_sdrs = inst_64755;
var label = inst_64760;
var sdr_sizes = inst_64746;
var wc_sdrv = inst_64694;
var G__64768 = inst_64774;
var cell_sdr_fracs = inst_64691;
return ((function (s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64693,inst_64774,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
return org.nfrac.comportex.util.update_each(m,a_cols,inc_win_gids);
});
;})(s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64693,inst_64774,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64777 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64774,cljs.core.cst$kw$col_DASH_gid_DASH_counts,inst_64776);
var state_64852__$1 = state_64852;
var statearr_64865_65009 = state_64852__$1;
(statearr_64865_65009[(2)] = inst_64777);

(statearr_64865_65009[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (31))){
var inst_64792 = (state_64852[(46)]);
var state_64852__$1 = state_64852;
var statearr_64866_65010 = state_64852__$1;
(statearr_64866_65010[(2)] = inst_64792);

(statearr_64866_65010[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (32))){
var inst_64684 = (state_64852[(8)]);
var inst_64798 = (state_64852[(2)]);
var state_64852__$1 = (function (){var statearr_64867 = state_64852;
(statearr_64867[(47)] = inst_64798);

return statearr_64867;
})();
if(cljs.core.truth_(inst_64684)){
var statearr_64868_65011 = state_64852__$1;
(statearr_64868_65011[(1)] = (33));

} else {
var statearr_64869_65012 = state_64852__$1;
(statearr_64869_65012[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (40))){
var inst_64812 = (state_64852[(43)]);
var state_64852__$1 = state_64852;
var statearr_64870_65013 = state_64852__$1;
(statearr_64870_65013[(2)] = inst_64812);

(statearr_64870_65013[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (33))){
var inst_64714 = (state_64852[(29)]);
var inst_64798 = (state_64852[(47)]);
var inst_64800 = cljs.core.first(inst_64714);
var inst_64801 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(inst_64798,cljs.core.cst$kw$sdr_DASH_history,cljs.core.conj,inst_64800);
var state_64852__$1 = state_64852;
var statearr_64871_65014 = state_64852__$1;
(statearr_64871_65014[(2)] = inst_64801);

(statearr_64871_65014[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (13))){
var inst_64691 = (state_64852[(25)]);
var inst_64744 = org.numenta.sanity.plots.calc_sdr_sizes(inst_64691);
var state_64852__$1 = state_64852;
var statearr_64872_65015 = state_64852__$1;
(statearr_64872_65015[(2)] = inst_64744);

(statearr_64872_65015[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (22))){
var inst_64774 = (state_64852[(9)]);
var state_64852__$1 = state_64852;
var statearr_64873_65016 = state_64852__$1;
(statearr_64873_65016[(2)] = inst_64774);

(statearr_64873_65016[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (36))){
var inst_64752 = (state_64852[(11)]);
var inst_64693 = (state_64852[(13)]);
var inst_64692 = (state_64852[(19)]);
var inst_64804 = (state_64852[(48)]);
var inst_64746 = (state_64852[(28)]);
var inst_64689 = (state_64852[(32)]);
var inst_64767 = (state_64852[(33)]);
var inst_64694 = (state_64852[(35)]);
var inst_64806 = [cljs.core.cst$kw$winners,cljs.core.cst$kw$active,cljs.core.cst$kw$pred];
var inst_64807 = [inst_64694,inst_64692,inst_64693];
var inst_64808 = cljs.core.PersistentHashMap.fromArrays(inst_64806,inst_64807);
var inst_64809 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_64804,cljs.core.cst$kw$sdr_DASH_transitions,null,cljs.core.array_seq([cljs.core.cst$kw$sdr_DASH_votes,inst_64808,cljs.core.cst$kw$sdr_DASH_sizes,inst_64746,cljs.core.cst$kw$gid_DASH_sizes,inst_64752,cljs.core.cst$kw$timestep,inst_64767,cljs.core.cst$kw$threshold,inst_64689], 0));
var state_64852__$1 = state_64852;
var statearr_64874_65017 = state_64852__$1;
(statearr_64874_65017[(2)] = inst_64809);

(statearr_64874_65017[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (41))){
var inst_64684 = (state_64852[(8)]);
var inst_64830 = (state_64852[(2)]);
var state_64852__$1 = (function (){var statearr_64875 = state_64852;
(statearr_64875[(44)] = inst_64830);

return statearr_64875;
})();
if(cljs.core.truth_(inst_64684)){
var statearr_64876_65018 = state_64852__$1;
(statearr_64876_65018[(1)] = (42));

} else {
var statearr_64877_65019 = state_64852__$1;
(statearr_64877_65019[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (43))){
var inst_64684 = (state_64852[(8)]);
var state_64852__$1 = state_64852;
var statearr_64878_65020 = state_64852__$1;
(statearr_64878_65020[(2)] = inst_64684);

(statearr_64878_65020[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (29))){
var inst_64684 = (state_64852[(8)]);
var inst_64792 = (state_64852[(2)]);
var state_64852__$1 = (function (){var statearr_64879 = state_64852;
(statearr_64879[(46)] = inst_64792);

return statearr_64879;
})();
if(cljs.core.truth_(inst_64684)){
var statearr_64880_65021 = state_64852__$1;
(statearr_64880_65021[(1)] = (30));

} else {
var statearr_64881_65022 = state_64852__$1;
(statearr_64881_65022[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (44))){
var inst_64834 = (state_64852[(2)]);
var state_64852__$1 = state_64852;
if(cljs.core.truth_(inst_64834)){
var statearr_64882_65023 = state_64852__$1;
(statearr_64882_65023[(1)] = (45));

} else {
var statearr_64883_65024 = state_64852__$1;
(statearr_64883_65024[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (6))){
var inst_64697 = (state_64852[(49)]);
var inst_64702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64703 = [inst_64697,null];
var inst_64704 = (new cljs.core.PersistentVector(null,2,(5),inst_64702,inst_64703,null));
var state_64852__$1 = state_64852;
var statearr_64884_65025 = state_64852__$1;
(statearr_64884_65025[(2)] = inst_64704);

(statearr_64884_65025[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (28))){
var inst_64786 = (state_64852[(36)]);
var state_64852__$1 = state_64852;
var statearr_64885_65026 = state_64852__$1;
(statearr_64885_65026[(2)] = inst_64786);

(statearr_64885_65026[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (25))){
var inst_64780 = (state_64852[(38)]);
var state_64852__$1 = state_64852;
var statearr_64886_65027 = state_64852__$1;
(statearr_64886_65027[(2)] = inst_64780);

(statearr_64886_65027[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (34))){
var inst_64798 = (state_64852[(47)]);
var state_64852__$1 = state_64852;
var statearr_64887_65028 = state_64852__$1;
(statearr_64887_65028[(2)] = inst_64798);

(statearr_64887_65028[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (17))){
var inst_64739 = (state_64852[(18)]);
var inst_64760 = (state_64852[(22)]);
var inst_64714 = (state_64852[(29)]);
var inst_64684 = (state_64852[(8)]);
var inst_64752 = (state_64852[(2)]);
var inst_64753 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((1));
var inst_64754 = cljs.core.zipmap(inst_64714,inst_64753);
var inst_64755 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,inst_64754);
var inst_64756 = cljs.core.repeat.cljs$core$IFn$_invoke$arity$1((1));
var inst_64757 = cljs.core.zipmap(inst_64739,inst_64756);
var inst_64758 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,inst_64757);
var inst_64759 = cljs.core.cst$kw$input_DASH_value.cljs$core$IFn$_invoke$arity$1(step);
var inst_64760__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_64759,cljs.core.cst$kw$label,inst_64759);
var inst_64761 = [inst_64760__$1];
var inst_64762 = cljs.core.count(inst_64714);
var inst_64763 = ((1) / inst_64762);
var inst_64764 = [inst_64763];
var inst_64765 = cljs.core.PersistentHashMap.fromArrays(inst_64761,inst_64764);
var inst_64766 = cljs.core.partial.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,cljs.core._PLUS_,inst_64765);
var inst_64767 = cljs.core.cst$kw$timestep.cljs$core$IFn$_invoke$arity$1(step);
var state_64852__$1 = (function (){var statearr_64888 = state_64852;
(statearr_64888[(11)] = inst_64752);

(statearr_64888[(15)] = inst_64755);

(statearr_64888[(21)] = inst_64758);

(statearr_64888[(22)] = inst_64760__$1);

(statearr_64888[(27)] = inst_64766);

(statearr_64888[(33)] = inst_64767);

return statearr_64888;
})();
if(cljs.core.truth_(inst_64684)){
var statearr_64889_65029 = state_64852__$1;
(statearr_64889_65029[(1)] = (18));

} else {
var statearr_64890_65030 = state_64852__$1;
(statearr_64890_65030[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (3))){
var inst_64676 = (state_64852[(50)]);
var state_64852__$1 = state_64852;
var statearr_64891_65031 = state_64852__$1;
(statearr_64891_65031[(2)] = inst_64676);

(statearr_64891_65031[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (12))){
var inst_64741 = (state_64852[(51)]);
var state_64852__$1 = state_64852;
var statearr_64892_65032 = state_64852__$1;
(statearr_64892_65032[(2)] = inst_64741);

(statearr_64892_65032[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (2))){
var inst_64676 = (state_64852[(50)]);
var inst_64667 = (state_64852[(2)]);
var inst_64668 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(states) : cljs.core.deref.call(null,states));
var inst_64669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64670 = cljs.core.cst$kw$snapshot_DASH_id.cljs$core$IFn$_invoke$arity$1(prev_step);
var inst_64671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64672 = [region,layer];
var inst_64673 = (new cljs.core.PersistentVector(null,2,(5),inst_64671,inst_64672,null));
var inst_64674 = [inst_64670,inst_64673];
var inst_64675 = (new cljs.core.PersistentVector(null,2,(5),inst_64669,inst_64674,null));
var inst_64676__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_64668,inst_64675);
var state_64852__$1 = (function (){var statearr_64893 = state_64852;
(statearr_64893[(12)] = inst_64667);

(statearr_64893[(50)] = inst_64676__$1);

return statearr_64893;
})();
if(cljs.core.truth_(inst_64676__$1)){
var statearr_64894_65033 = state_64852__$1;
(statearr_64894_65033[(1)] = (3));

} else {
var statearr_64895_65034 = state_64852__$1;
(statearr_64895_65034[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (23))){
var inst_64684 = (state_64852[(8)]);
var inst_64780 = (state_64852[(2)]);
var state_64852__$1 = (function (){var statearr_64896 = state_64852;
(statearr_64896[(38)] = inst_64780);

return statearr_64896;
})();
if(cljs.core.truth_(inst_64684)){
var statearr_64897_65035 = state_64852__$1;
(statearr_64897_65035[(1)] = (24));

} else {
var statearr_64898_65036 = state_64852__$1;
(statearr_64898_65036[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (47))){
var inst_64843 = (state_64852[(2)]);
var inst_64844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64846 = [region,layer];
var inst_64847 = (new cljs.core.PersistentVector(null,2,(5),inst_64845,inst_64846,null));
var inst_64848 = [snapshot_id,inst_64847];
var inst_64849 = (new cljs.core.PersistentVector(null,2,(5),inst_64844,inst_64848,null));
var inst_64850 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(states,cljs.core.assoc_in,inst_64849,inst_64843);
var state_64852__$1 = state_64852;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64852__$1,inst_64850);
} else {
if((state_val_64853 === (35))){
var inst_64804 = (state_64852[(2)]);
var state_64852__$1 = (function (){var statearr_64899 = state_64852;
(statearr_64899[(48)] = inst_64804);

return statearr_64899;
})();
var statearr_64900_65037 = state_64852__$1;
(statearr_64900_65037[(1)] = (36));



return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (19))){
var inst_64680 = (state_64852[(16)]);
var state_64852__$1 = state_64852;
var statearr_64902_65038 = state_64852__$1;
(statearr_64902_65038[(2)] = inst_64680);

(statearr_64902_65038[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (11))){
var inst_64680 = (state_64852[(16)]);
var inst_64738 = (state_64852[(17)]);
var inst_64741 = (state_64852[(51)]);
var inst_64738__$1 = (state_64852[(2)]);
var inst_64739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64738__$1,(0),null);
var inst_64740 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64738__$1,(1),null);
var inst_64741__$1 = cljs.core.cst$kw$updated_DASH_sdr_DASH_sizes.cljs$core$IFn$_invoke$arity$1(inst_64680);
var state_64852__$1 = (function (){var statearr_64903 = state_64852;
(statearr_64903[(17)] = inst_64738__$1);

(statearr_64903[(18)] = inst_64739);

(statearr_64903[(24)] = inst_64740);

(statearr_64903[(51)] = inst_64741__$1);

return statearr_64903;
})();
if(cljs.core.truth_(inst_64741__$1)){
var statearr_64904_65039 = state_64852__$1;
(statearr_64904_65039[(1)] = (12));

} else {
var statearr_64905_65040 = state_64852__$1;
(statearr_64905_65040[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (9))){
var inst_64722 = (state_64852[(52)]);
var inst_64727 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64728 = [inst_64722,null];
var inst_64729 = (new cljs.core.PersistentVector(null,2,(5),inst_64727,inst_64728,null));
var state_64852__$1 = state_64852;
var statearr_64906_65041 = state_64852__$1;
(statearr_64906_65041[(2)] = inst_64729);

(statearr_64906_65041[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (5))){
var inst_64667 = (state_64852[(12)]);
var inst_64693 = (state_64852[(13)]);
var inst_64680 = (state_64852[(16)]);
var inst_64692 = (state_64852[(19)]);
var inst_64691 = (state_64852[(25)]);
var inst_64681 = (state_64852[(30)]);
var inst_64683 = (state_64852[(31)]);
var inst_64697 = (state_64852[(49)]);
var inst_64689 = (state_64852[(32)]);
var inst_64682 = (state_64852[(34)]);
var inst_64694 = (state_64852[(35)]);
var inst_64684 = (state_64852[(8)]);
var inst_64680__$1 = (state_64852[(2)]);
var inst_64681__$1 = cljs.core.cst$kw$winner_DASH_cells.cljs$core$IFn$_invoke$arity$1(inst_64667);
var inst_64682__$1 = cljs.core.cst$kw$active_DASH_cells.cljs$core$IFn$_invoke$arity$1(inst_64667);
var inst_64683__$1 = cljs.core.cst$kw$pred_DASH_cells.cljs$core$IFn$_invoke$arity$1(inst_64667);
var inst_64684__$1 = cljs.core.cst$kw$engaged_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_64667);
var inst_64685 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape));
var inst_64686 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64687 = [cljs.core.cst$kw$regions,region,layer,cljs.core.cst$kw$spec,cljs.core.cst$kw$distal,cljs.core.cst$kw$learn_DASH_threshold];
var inst_64688 = (new cljs.core.PersistentVector(null,6,(5),inst_64686,inst_64687,null));
var inst_64689__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_64685,inst_64688);
var inst_64690 = cljs.core.cst$kw$cell_DASH_sdr_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64680__$1);
var inst_64691__$1 = org.nfrac.comportex.util.remap(org.numenta.sanity.plots.freqs__GT_fracs,inst_64690);
var inst_64692__$1 = org.numenta.sanity.plots.sdr_votes(inst_64682__$1,inst_64691__$1);
var inst_64693__$1 = org.numenta.sanity.plots.sdr_votes(inst_64683__$1,inst_64691__$1);
var inst_64694__$1 = org.numenta.sanity.plots.sdr_votes(inst_64681__$1,inst_64691__$1);
var inst_64696 = (function (){var pc_sdrv = inst_64693__$1;
var ac_sdrv = inst_64692__$1;
var wc = inst_64681__$1;
var on_QMARK_ = inst_64684__$1;
var ac = inst_64682__$1;
var cells_by_state = inst_64667;
var pc = inst_64683__$1;
var state = inst_64680__$1;
var threshold = inst_64689__$1;
var wc_sdrv = inst_64694__$1;
var cell_sdr_fracs = inst_64691__$1;
return ((function (s__62694__$1,pc_sdrv,ac_sdrv,wc,on_QMARK_,ac,cells_by_state,pc,state,threshold,wc_sdrv,cell_sdr_fracs,inst_64667,inst_64693,inst_64680,inst_64692,inst_64691,inst_64681,inst_64683,inst_64697,inst_64689,inst_64682,inst_64694,inst_64684,inst_64680__$1,inst_64681__$1,inst_64682__$1,inst_64683__$1,inst_64684__$1,inst_64685,inst_64686,inst_64687,inst_64688,inst_64689__$1,inst_64690,inst_64691__$1,inst_64692__$1,inst_64693__$1,inst_64694__$1,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (p__64695){
var vec__64907 = p__64695;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64907,(0),null);
var vote = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64907,(1),null);
if((vote >= threshold)){
return id;
} else {
return null;
}
});
;})(s__62694__$1,pc_sdrv,ac_sdrv,wc,on_QMARK_,ac,cells_by_state,pc,state,threshold,wc_sdrv,cell_sdr_fracs,inst_64667,inst_64693,inst_64680,inst_64692,inst_64691,inst_64681,inst_64683,inst_64697,inst_64689,inst_64682,inst_64694,inst_64684,inst_64680__$1,inst_64681__$1,inst_64682__$1,inst_64683__$1,inst_64684__$1,inst_64685,inst_64686,inst_64687,inst_64688,inst_64689__$1,inst_64690,inst_64691__$1,inst_64692__$1,inst_64693__$1,inst_64694__$1,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64697__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_64696,inst_64694__$1);
var inst_64698 = cljs.core.cst$kw$sdr_DASH_label_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64680__$1);
var inst_64699 = cljs.core.count(inst_64698);
var inst_64700 = cljs.core.seq(inst_64697__$1);
var state_64852__$1 = (function (){var statearr_64908 = state_64852;
(statearr_64908[(13)] = inst_64693__$1);

(statearr_64908[(16)] = inst_64680__$1);

(statearr_64908[(19)] = inst_64692__$1);

(statearr_64908[(7)] = inst_64699);

(statearr_64908[(25)] = inst_64691__$1);

(statearr_64908[(30)] = inst_64681__$1);

(statearr_64908[(31)] = inst_64683__$1);

(statearr_64908[(49)] = inst_64697__$1);

(statearr_64908[(32)] = inst_64689__$1);

(statearr_64908[(34)] = inst_64682__$1);

(statearr_64908[(35)] = inst_64694__$1);

(statearr_64908[(8)] = inst_64684__$1);

return statearr_64908;
})();
if(inst_64700){
var statearr_64909_65042 = state_64852__$1;
(statearr_64909_65042[(1)] = (6));

} else {
var statearr_64910_65043 = state_64852__$1;
(statearr_64910_65043[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (14))){
var inst_64747 = (state_64852[(45)]);
var inst_64680 = (state_64852[(16)]);
var inst_64746 = (state_64852[(2)]);
var inst_64747__$1 = cljs.core.cst$kw$updated_DASH_gid_DASH_sizes.cljs$core$IFn$_invoke$arity$1(inst_64680);
var state_64852__$1 = (function (){var statearr_64911 = state_64852;
(statearr_64911[(45)] = inst_64747__$1);

(statearr_64911[(28)] = inst_64746);

return statearr_64911;
})();
if(cljs.core.truth_(inst_64747__$1)){
var statearr_64912_65044 = state_64852__$1;
(statearr_64912_65044[(1)] = (15));

} else {
var statearr_64913_65045 = state_64852__$1;
(statearr_64913_65045[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (45))){
var inst_64715 = (state_64852[(10)]);
var inst_64818 = (state_64852[(39)]);
var inst_64830 = (state_64852[(44)]);
var inst_64836 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64837 = [cljs.core.cst$kw$sdr_DASH_votes,cljs.core.cst$kw$winners,inst_64715];
var inst_64838 = (new cljs.core.PersistentVector(null,3,(5),inst_64836,inst_64837,null));
var inst_64839 = (inst_64818.cljs$core$IFn$_invoke$arity$1 ? inst_64818.cljs$core$IFn$_invoke$arity$1(inst_64715) : inst_64818.call(null,inst_64715));
var inst_64840 = cljs.core.assoc_in(inst_64830,inst_64838,inst_64839);
var state_64852__$1 = state_64852;
var statearr_64914_65046 = state_64852__$1;
(statearr_64914_65046[(2)] = inst_64840);

(statearr_64914_65046[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (26))){
var inst_64684 = (state_64852[(8)]);
var inst_64786 = (state_64852[(2)]);
var state_64852__$1 = (function (){var statearr_64915 = state_64852;
(statearr_64915[(36)] = inst_64786);

return statearr_64915;
})();
if(cljs.core.truth_(inst_64684)){
var statearr_64916_65047 = state_64852__$1;
(statearr_64916_65047[(1)] = (27));

} else {
var statearr_64917_65048 = state_64852__$1;
(statearr_64917_65048[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (16))){
var inst_64717 = (state_64852[(26)]);
var inst_64750 = org.numenta.sanity.plots.calc_sdr_sizes(inst_64717);
var state_64852__$1 = state_64852;
var statearr_64918_65049 = state_64852__$1;
(statearr_64918_65049[(2)] = inst_64750);

(statearr_64918_65049[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (38))){
var inst_64752 = (state_64852[(11)]);
var inst_64821 = (state_64852[(40)]);
var inst_64739 = (state_64852[(18)]);
var inst_64746 = (state_64852[(28)]);
var inst_64815 = (state_64852[(42)]);
var inst_64714 = (state_64852[(29)]);
var inst_64812 = (state_64852[(43)]);
var inst_64684 = (state_64852[(8)]);
var inst_64812__$1 = (state_64852[(2)]);
var inst_64813 = cljs.core.cst$kw$cell_DASH_sdr_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64812__$1);
var inst_64814 = org.nfrac.comportex.util.remap(org.numenta.sanity.plots.freqs__GT_fracs,inst_64813);
var inst_64815__$1 = org.numenta.sanity.plots.calc_sdr_sizes(inst_64814);
var inst_64816 = cljs.core.select_keys(inst_64815__$1,inst_64714);
var inst_64817 = cljs.core.select_keys(inst_64746,inst_64714);
var inst_64818 = cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._,cljs.core.array_seq([inst_64816,inst_64817], 0));
var inst_64819 = cljs.core.cst$kw$col_DASH_gid_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64812__$1);
var inst_64820 = org.nfrac.comportex.util.remap(org.numenta.sanity.plots.freqs__GT_fracs,inst_64819);
var inst_64821__$1 = org.numenta.sanity.plots.calc_sdr_sizes(inst_64820);
var inst_64822 = cljs.core.select_keys(inst_64821__$1,inst_64739);
var inst_64823 = cljs.core.select_keys(inst_64752,inst_64739);
var inst_64824 = cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(cljs.core._,cljs.core.array_seq([inst_64822,inst_64823], 0));
var state_64852__$1 = (function (){var statearr_64919 = state_64852;
(statearr_64919[(39)] = inst_64818);

(statearr_64919[(40)] = inst_64821__$1);

(statearr_64919[(41)] = inst_64824);

(statearr_64919[(42)] = inst_64815__$1);

(statearr_64919[(43)] = inst_64812__$1);

return statearr_64919;
})();
if(cljs.core.truth_(inst_64684)){
var statearr_64920_65050 = state_64852__$1;
(statearr_64920_65050[(1)] = (39));

} else {
var statearr_64921_65051 = state_64852__$1;
(statearr_64921_65051[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (30))){
var inst_64715 = (state_64852[(10)]);
var inst_64752 = (state_64852[(11)]);
var inst_64667 = (state_64852[(12)]);
var inst_64792 = (state_64852[(46)]);
var inst_64693 = (state_64852[(13)]);
var inst_64713 = (state_64852[(14)]);
var inst_64755 = (state_64852[(15)]);
var inst_64680 = (state_64852[(16)]);
var inst_64738 = (state_64852[(17)]);
var inst_64739 = (state_64852[(18)]);
var inst_64692 = (state_64852[(19)]);
var inst_64718 = (state_64852[(20)]);
var inst_64758 = (state_64852[(21)]);
var inst_64760 = (state_64852[(22)]);
var inst_64719 = (state_64852[(23)]);
var inst_64740 = (state_64852[(24)]);
var inst_64691 = (state_64852[(25)]);
var inst_64717 = (state_64852[(26)]);
var inst_64766 = (state_64852[(27)]);
var inst_64746 = (state_64852[(28)]);
var inst_64714 = (state_64852[(29)]);
var inst_64681 = (state_64852[(30)]);
var inst_64683 = (state_64852[(31)]);
var inst_64689 = (state_64852[(32)]);
var inst_64767 = (state_64852[(33)]);
var inst_64682 = (state_64852[(34)]);
var inst_64694 = (state_64852[(35)]);
var inst_64684 = (state_64852[(8)]);
var inst_64794 = (function (){var t = inst_64767;
var pc_sdrv = inst_64693;
var win_sdrs = inst_64714;
var a_cols = inst_64718;
var ac_sdrv = inst_64692;
var vec__64665 = inst_64738;
var win_gids = inst_64739;
var new_sdr = inst_64715;
var wc = inst_64681;
var on_QMARK_ = inst_64684;
var gid_sizes = inst_64752;
var gidv = inst_64719;
var ac = inst_64682;
var vec__64664 = inst_64713;
var cells_by_state = inst_64667;
var new_gid = inst_64740;
var inc_label = inst_64766;
var col_gid_fracs = inst_64717;
var pc = inst_64683;
var state = inst_64680;
var inc_win_gids = inst_64758;
var threshold = inst_64689;
var inc_win_sdrs = inst_64755;
var label = inst_64760;
var sdr_sizes = inst_64746;
var wc_sdrv = inst_64694;
var G__64768 = inst_64792;
var cell_sdr_fracs = inst_64691;
return ((function (s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64792,inst_64693,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([m,cljs.core.zipmap(win_sdrs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(t))], 0));
});
;})(s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64792,inst_64693,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64795 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64792,cljs.core.cst$kw$sdr_DASH_last_DASH_matches,inst_64794);
var state_64852__$1 = state_64852;
var statearr_64922_65052 = state_64852__$1;
(statearr_64922_65052[(2)] = inst_64795);

(statearr_64922_65052[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (10))){
var inst_64724 = (state_64852[(53)]);
var inst_64731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64732 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64733 = [inst_64724];
var inst_64734 = (new cljs.core.PersistentVector(null,1,(5),inst_64732,inst_64733,null));
var inst_64735 = [inst_64734,inst_64724];
var inst_64736 = (new cljs.core.PersistentVector(null,2,(5),inst_64731,inst_64735,null));
var state_64852__$1 = state_64852;
var statearr_64923_65053 = state_64852__$1;
(statearr_64923_65053[(2)] = inst_64736);

(statearr_64923_65053[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (18))){
var inst_64715 = (state_64852[(10)]);
var inst_64752 = (state_64852[(11)]);
var inst_64667 = (state_64852[(12)]);
var inst_64693 = (state_64852[(13)]);
var inst_64713 = (state_64852[(14)]);
var inst_64755 = (state_64852[(15)]);
var inst_64680 = (state_64852[(16)]);
var inst_64738 = (state_64852[(17)]);
var inst_64739 = (state_64852[(18)]);
var inst_64692 = (state_64852[(19)]);
var inst_64718 = (state_64852[(20)]);
var inst_64758 = (state_64852[(21)]);
var inst_64760 = (state_64852[(22)]);
var inst_64719 = (state_64852[(23)]);
var inst_64740 = (state_64852[(24)]);
var inst_64691 = (state_64852[(25)]);
var inst_64717 = (state_64852[(26)]);
var inst_64766 = (state_64852[(27)]);
var inst_64746 = (state_64852[(28)]);
var inst_64714 = (state_64852[(29)]);
var inst_64681 = (state_64852[(30)]);
var inst_64683 = (state_64852[(31)]);
var inst_64689 = (state_64852[(32)]);
var inst_64767 = (state_64852[(33)]);
var inst_64682 = (state_64852[(34)]);
var inst_64694 = (state_64852[(35)]);
var inst_64684 = (state_64852[(8)]);
var inst_64770 = (function (){var t = inst_64767;
var pc_sdrv = inst_64693;
var win_sdrs = inst_64714;
var a_cols = inst_64718;
var ac_sdrv = inst_64692;
var vec__64665 = inst_64738;
var win_gids = inst_64739;
var new_sdr = inst_64715;
var wc = inst_64681;
var on_QMARK_ = inst_64684;
var gid_sizes = inst_64752;
var gidv = inst_64719;
var ac = inst_64682;
var vec__64664 = inst_64713;
var cells_by_state = inst_64667;
var new_gid = inst_64740;
var inc_label = inst_64766;
var col_gid_fracs = inst_64717;
var pc = inst_64683;
var state = inst_64680;
var inc_win_gids = inst_64758;
var threshold = inst_64689;
var inc_win_sdrs = inst_64755;
var label = inst_64760;
var sdr_sizes = inst_64746;
var wc_sdrv = inst_64694;
var G__64768 = inst_64680;
var cell_sdr_fracs = inst_64691;
return ((function (s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64693,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (m){
return org.nfrac.comportex.util.update_each(m,wc,inc_win_sdrs);
});
;})(s__62694__$1,t,pc_sdrv,win_sdrs,a_cols,ac_sdrv,vec__64665,win_gids,new_sdr,wc,on_QMARK_,gid_sizes,gidv,ac,vec__64664,cells_by_state,new_gid,inc_label,col_gid_fracs,pc,state,inc_win_gids,threshold,inc_win_sdrs,label,sdr_sizes,wc_sdrv,G__64768,cell_sdr_fracs,inst_64715,inst_64752,inst_64667,inst_64693,inst_64713,inst_64755,inst_64680,inst_64738,inst_64739,inst_64692,inst_64718,inst_64758,inst_64760,inst_64719,inst_64740,inst_64691,inst_64717,inst_64766,inst_64746,inst_64714,inst_64681,inst_64683,inst_64689,inst_64767,inst_64682,inst_64694,inst_64684,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64771 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_64680,cljs.core.cst$kw$cell_DASH_sdr_DASH_counts,inst_64770);
var state_64852__$1 = state_64852;
var statearr_64924_65054 = state_64852__$1;
(statearr_64924_65054[(2)] = inst_64771);

(statearr_64924_65054[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (42))){
var inst_64715 = (state_64852[(10)]);
var state_64852__$1 = state_64852;
var statearr_64925_65055 = state_64852__$1;
(statearr_64925_65055[(2)] = inst_64715);

(statearr_64925_65055[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (37))){
var inst_64804 = (state_64852[(48)]);
var state_64852__$1 = state_64852;
var statearr_64926_65056 = state_64852__$1;
(statearr_64926_65056[(2)] = inst_64804);

(statearr_64926_65056[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64853 === (8))){
var inst_64715 = (state_64852[(10)]);
var inst_64667 = (state_64852[(12)]);
var inst_64693 = (state_64852[(13)]);
var inst_64713 = (state_64852[(14)]);
var inst_64722 = (state_64852[(52)]);
var inst_64680 = (state_64852[(16)]);
var inst_64692 = (state_64852[(19)]);
var inst_64718 = (state_64852[(20)]);
var inst_64719 = (state_64852[(23)]);
var inst_64691 = (state_64852[(25)]);
var inst_64717 = (state_64852[(26)]);
var inst_64714 = (state_64852[(29)]);
var inst_64681 = (state_64852[(30)]);
var inst_64683 = (state_64852[(31)]);
var inst_64689 = (state_64852[(32)]);
var inst_64682 = (state_64852[(34)]);
var inst_64694 = (state_64852[(35)]);
var inst_64684 = (state_64852[(8)]);
var inst_64713__$1 = (state_64852[(2)]);
var inst_64714__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64713__$1,(0),null);
var inst_64715__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64713__$1,(1),null);
var inst_64716 = cljs.core.cst$kw$col_DASH_gid_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64680);
var inst_64717__$1 = org.nfrac.comportex.util.remap(org.numenta.sanity.plots.freqs__GT_fracs,inst_64716);
var inst_64718__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,inst_64681);
var inst_64719__$1 = org.numenta.sanity.plots.sdr_votes(inst_64718__$1,inst_64717__$1);
var inst_64721 = (function (){var pc_sdrv = inst_64693;
var win_sdrs = inst_64714__$1;
var a_cols = inst_64718__$1;
var ac_sdrv = inst_64692;
var new_sdr = inst_64715__$1;
var wc = inst_64681;
var on_QMARK_ = inst_64684;
var gidv = inst_64719__$1;
var ac = inst_64682;
var vec__64664 = inst_64713__$1;
var cells_by_state = inst_64667;
var col_gid_fracs = inst_64717__$1;
var pc = inst_64683;
var state = inst_64680;
var threshold = inst_64689;
var wc_sdrv = inst_64694;
var cell_sdr_fracs = inst_64691;
return ((function (s__62694__$1,pc_sdrv,win_sdrs,a_cols,ac_sdrv,new_sdr,wc,on_QMARK_,gidv,ac,vec__64664,cells_by_state,col_gid_fracs,pc,state,threshold,wc_sdrv,cell_sdr_fracs,inst_64715,inst_64667,inst_64693,inst_64713,inst_64722,inst_64680,inst_64692,inst_64718,inst_64719,inst_64691,inst_64717,inst_64714,inst_64681,inst_64683,inst_64689,inst_64682,inst_64694,inst_64684,inst_64713__$1,inst_64714__$1,inst_64715__$1,inst_64716,inst_64717__$1,inst_64718__$1,inst_64719__$1,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function (p__64720){
var vec__64927 = p__64720;
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64927,(0),null);
var vote = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64927,(1),null);
if((vote >= threshold)){
return id;
} else {
return null;
}
});
;})(s__62694__$1,pc_sdrv,win_sdrs,a_cols,ac_sdrv,new_sdr,wc,on_QMARK_,gidv,ac,vec__64664,cells_by_state,col_gid_fracs,pc,state,threshold,wc_sdrv,cell_sdr_fracs,inst_64715,inst_64667,inst_64693,inst_64713,inst_64722,inst_64680,inst_64692,inst_64718,inst_64719,inst_64691,inst_64717,inst_64714,inst_64681,inst_64683,inst_64689,inst_64682,inst_64694,inst_64684,inst_64713__$1,inst_64714__$1,inst_64715__$1,inst_64716,inst_64717__$1,inst_64718__$1,inst_64719__$1,state_val_64853,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var inst_64722__$1 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_64721,inst_64719__$1);
var inst_64723 = cljs.core.cst$kw$sdr_DASH_label_DASH_counts.cljs$core$IFn$_invoke$arity$1(inst_64680);
var inst_64724 = cljs.core.count(inst_64723);
var inst_64725 = cljs.core.seq(inst_64722__$1);
var state_64852__$1 = (function (){var statearr_64928 = state_64852;
(statearr_64928[(10)] = inst_64715__$1);

(statearr_64928[(14)] = inst_64713__$1);

(statearr_64928[(52)] = inst_64722__$1);

(statearr_64928[(20)] = inst_64718__$1);

(statearr_64928[(23)] = inst_64719__$1);

(statearr_64928[(53)] = inst_64724);

(statearr_64928[(26)] = inst_64717__$1);

(statearr_64928[(29)] = inst_64714__$1);

return statearr_64928;
})();
if(inst_64725){
var statearr_64929_65057 = state_64852__$1;
(statearr_64929_65057[(1)] = (9));

} else {
var statearr_64930_65058 = state_64852__$1;
(statearr_64930_65058[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(s__62694__$1,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
;
return ((function (s__62694__$1,switch__37995__auto__,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__){
return (function() {
var org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__ = null;
var org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____0 = (function (){
var statearr_64934 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64934[(0)] = org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__);

(statearr_64934[(1)] = (1));

return statearr_64934;
});
var org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____1 = (function (state_64852){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_64852);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e64935){if((e64935 instanceof Object)){
var ex__37999__auto__ = e64935;
var statearr_64936_65059 = state_64852;
(statearr_64936_65059[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_64852);

return cljs.core.cst$kw$recur;
} else {
throw e64935;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__65060 = state_64852;
state_64852 = G__65060;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__ = function(state_64852){
switch(arguments.length){
case 0:
return org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____1.call(this,state_64852);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____0;
org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto____1;
return org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695_$_state_machine__37996__auto__;
})()
;})(s__62694__$1,switch__37995__auto__,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
})();
var state__38111__auto__ = (function (){var statearr_64937 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_64937[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_64937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(s__62694__$1,c__38109__auto__,response_c,snapshot_id,layer,s__62696__$2,temp__4657__auto____$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
);

return c__38109__auto__;
})(),org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693_$_iter__62695(cljs.core.rest(s__62696__$2)));
}
} else {
return null;
}
break;
}
});})(s__62694__$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
,null,null));
});})(s__62694__$1,vec__63819,region,layer_map,xs__5205__auto__,temp__4657__auto__))
;
var fs__6922__auto__ = cljs.core.seq(iterys__6921__auto__(cljs.core.keys(layer_map)));
if(fs__6922__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__6922__auto__,org$numenta$sanity$plots$update_cell_sdrs_states_BANG__$_iter__62693(cljs.core.rest(s__62694__$1)));
} else {
var G__65061 = cljs.core.rest(s__62694__$1);
s__62694__$1 = G__65061;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__6925__auto__(cljs.core.cst$kw$regions.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(network_shape) : cljs.core.deref.call(null,network_shape))));
});
org.numenta.sanity.plots.cell_sdrs_plot_builder = (function org$numenta$sanity$plots$cell_sdrs_plot_builder(steps,network_shape,selection,into_journal,plot_opts){
var states = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var plot_data = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(org.numenta.sanity.plots.empty_cell_sdrs_state,cljs.core.cst$kw$title,""));
cljs.core.add_watch(steps,cljs.core.cst$kw$org$numenta$sanity$plots_SLASH_cell_DASH_sdrs_DASH_plot,((function (states,plot_data){
return (function (_,___$1,___$2,p__65357){
var vec__65358 = p__65357;
var step = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65358,(0),null);
var prev_step = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65358,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$snapshot_DASH_id.cljs$core$IFn$_invoke$arity$1(step))){
var procs = org.numenta.sanity.plots.update_cell_sdrs_states_BANG_(states,network_shape,step,prev_step,into_journal);
var c__38109__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto__,procs,vec__65358,step,prev_step,states,plot_data){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto__,procs,vec__65358,step,prev_step,states,plot_data){
return (function (state_65406){
var state_val_65407 = (state_65406[(1)]);
if((state_val_65407 === (7))){
var inst_65366 = (state_65406[(7)]);
var inst_65365 = (state_65406[(8)]);
var inst_65364 = (state_65406[(9)]);
var inst_65367 = (state_65406[(10)]);
var inst_65374 = (state_65406[(2)]);
var inst_65375 = (inst_65367 + (1));
var tmp65408 = inst_65366;
var tmp65409 = inst_65365;
var tmp65410 = inst_65364;
var inst_65364__$1 = tmp65410;
var inst_65365__$1 = tmp65409;
var inst_65366__$1 = tmp65408;
var inst_65367__$1 = inst_65375;
var state_65406__$1 = (function (){var statearr_65411 = state_65406;
(statearr_65411[(7)] = inst_65366__$1);

(statearr_65411[(8)] = inst_65365__$1);

(statearr_65411[(9)] = inst_65364__$1);

(statearr_65411[(11)] = inst_65374);

(statearr_65411[(10)] = inst_65367__$1);

return statearr_65411;
})();
var statearr_65412_65651 = state_65406__$1;
(statearr_65412_65651[(2)] = null);

(statearr_65412_65651[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (1))){
var inst_65363 = cljs.core.seq(procs);
var inst_65364 = inst_65363;
var inst_65365 = null;
var inst_65366 = (0);
var inst_65367 = (0);
var state_65406__$1 = (function (){var statearr_65413 = state_65406;
(statearr_65413[(7)] = inst_65366);

(statearr_65413[(8)] = inst_65365);

(statearr_65413[(9)] = inst_65364);

(statearr_65413[(10)] = inst_65367);

return statearr_65413;
})();
var statearr_65414_65652 = state_65406__$1;
(statearr_65414_65652[(2)] = null);

(statearr_65414_65652[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (4))){
var inst_65365 = (state_65406[(8)]);
var inst_65367 = (state_65406[(10)]);
var inst_65372 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_65365,inst_65367);
var state_65406__$1 = state_65406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65406__$1,(7),inst_65372);
} else {
if((state_val_65407 === (13))){
var inst_65393 = (state_65406[(2)]);
var state_65406__$1 = state_65406;
var statearr_65415_65653 = state_65406__$1;
(statearr_65415_65653[(2)] = inst_65393);

(statearr_65415_65653[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (6))){
var inst_65398 = (state_65406[(2)]);
var state_65406__$1 = state_65406;
var statearr_65416_65654 = state_65406__$1;
(statearr_65416_65654[(2)] = inst_65398);

(statearr_65416_65654[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (3))){
var inst_65400 = (state_65406[(2)]);
var inst_65402 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selection) : cljs.core.deref.call(null,selection));
var inst_65403 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65402,(0),null);
var inst_65404 = org.numenta.sanity.plots.update_cell_sdrs_plot_data_BANG_(plot_data,states,inst_65403,into_journal);
var state_65406__$1 = (function (){var statearr_65417 = state_65406;
(statearr_65417[(12)] = inst_65400);

return statearr_65417;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65406__$1,inst_65404);
} else {
if((state_val_65407 === (12))){
var inst_65378 = (state_65406[(13)]);
var inst_65387 = cljs.core.first(inst_65378);
var state_65406__$1 = state_65406;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65406__$1,(14),inst_65387);
} else {
if((state_val_65407 === (2))){
var inst_65366 = (state_65406[(7)]);
var inst_65367 = (state_65406[(10)]);
var inst_65369 = (inst_65367 < inst_65366);
var inst_65370 = inst_65369;
var state_65406__$1 = state_65406;
if(cljs.core.truth_(inst_65370)){
var statearr_65418_65655 = state_65406__$1;
(statearr_65418_65655[(1)] = (4));

} else {
var statearr_65419_65656 = state_65406__$1;
(statearr_65419_65656[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (11))){
var inst_65378 = (state_65406[(13)]);
var inst_65382 = cljs.core.chunk_first(inst_65378);
var inst_65383 = cljs.core.chunk_rest(inst_65378);
var inst_65384 = cljs.core.count(inst_65382);
var inst_65364 = inst_65383;
var inst_65365 = inst_65382;
var inst_65366 = inst_65384;
var inst_65367 = (0);
var state_65406__$1 = (function (){var statearr_65420 = state_65406;
(statearr_65420[(7)] = inst_65366);

(statearr_65420[(8)] = inst_65365);

(statearr_65420[(9)] = inst_65364);

(statearr_65420[(10)] = inst_65367);

return statearr_65420;
})();
var statearr_65421_65657 = state_65406__$1;
(statearr_65421_65657[(2)] = null);

(statearr_65421_65657[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (9))){
var state_65406__$1 = state_65406;
var statearr_65422_65658 = state_65406__$1;
(statearr_65422_65658[(2)] = null);

(statearr_65422_65658[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (5))){
var inst_65378 = (state_65406[(13)]);
var inst_65364 = (state_65406[(9)]);
var inst_65378__$1 = cljs.core.seq(inst_65364);
var state_65406__$1 = (function (){var statearr_65423 = state_65406;
(statearr_65423[(13)] = inst_65378__$1);

return statearr_65423;
})();
if(inst_65378__$1){
var statearr_65424_65659 = state_65406__$1;
(statearr_65424_65659[(1)] = (8));

} else {
var statearr_65425_65660 = state_65406__$1;
(statearr_65425_65660[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (14))){
var inst_65378 = (state_65406[(13)]);
var inst_65389 = (state_65406[(2)]);
var inst_65390 = cljs.core.next(inst_65378);
var inst_65364 = inst_65390;
var inst_65365 = null;
var inst_65366 = (0);
var inst_65367 = (0);
var state_65406__$1 = (function (){var statearr_65426 = state_65406;
(statearr_65426[(7)] = inst_65366);

(statearr_65426[(8)] = inst_65365);

(statearr_65426[(9)] = inst_65364);

(statearr_65426[(14)] = inst_65389);

(statearr_65426[(10)] = inst_65367);

return statearr_65426;
})();
var statearr_65427_65661 = state_65406__$1;
(statearr_65427_65661[(2)] = null);

(statearr_65427_65661[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (10))){
var inst_65396 = (state_65406[(2)]);
var state_65406__$1 = state_65406;
var statearr_65428_65662 = state_65406__$1;
(statearr_65428_65662[(2)] = inst_65396);

(statearr_65428_65662[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65407 === (8))){
var inst_65378 = (state_65406[(13)]);
var inst_65380 = cljs.core.chunked_seq_QMARK_(inst_65378);
var state_65406__$1 = state_65406;
if(inst_65380){
var statearr_65429_65663 = state_65406__$1;
(statearr_65429_65663[(1)] = (11));

} else {
var statearr_65430_65664 = state_65406__$1;
(statearr_65430_65664[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto__,procs,vec__65358,step,prev_step,states,plot_data))
;
return ((function (switch__37995__auto__,c__38109__auto__,procs,vec__65358,step,prev_step,states,plot_data){
return (function() {
var org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__ = null;
var org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____0 = (function (){
var statearr_65434 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65434[(0)] = org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__);

(statearr_65434[(1)] = (1));

return statearr_65434;
});
var org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____1 = (function (state_65406){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_65406);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e65435){if((e65435 instanceof Object)){
var ex__37999__auto__ = e65435;
var statearr_65436_65665 = state_65406;
(statearr_65436_65665[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_65406);

return cljs.core.cst$kw$recur;
} else {
throw e65435;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__65666 = state_65406;
state_65406 = G__65666;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__ = function(state_65406){
switch(arguments.length){
case 0:
return org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____1.call(this,state_65406);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____0;
org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____1;
return org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto__,procs,vec__65358,step,prev_step,states,plot_data))
})();
var state__38111__auto__ = (function (){var statearr_65437 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_65437[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto__);

return statearr_65437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto__,procs,vec__65358,step,prev_step,states,plot_data))
);

return c__38109__auto__;
} else {
return null;
}
});})(states,plot_data))
);

cljs.core.add_watch(selection,cljs.core.cst$kw$org$numenta$sanity$plots_SLASH_cell_DASH_sdrs_DASH_plot,((function (states,plot_data){
return (function (_,___$1,___$2,p__65438){
var vec__65439 = p__65438;
var sel = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65439,(0),null);
return org.numenta.sanity.plots.update_cell_sdrs_plot_data_BANG_(plot_data,states,sel,into_journal);
});})(states,plot_data))
);

var vec__65440_65667 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selection) : cljs.core.deref.call(null,selection));
var sel1_65668 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__65440_65667,(0),null);
var temp__4657__auto___65669 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(sel1_65668,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$step,cljs.core.cst$kw$snapshot_DASH_id], null));
if(cljs.core.truth_(temp__4657__auto___65669)){
var snapshot_id_65670 = temp__4657__auto___65669;
var to_ingest_65671 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(((function (snapshot_id_65670,temp__4657__auto___65669,vec__65440_65667,sel1_65668,states,plot_data){
return (function (p1__65062_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(snapshot_id_65670,cljs.core.cst$kw$snapshot_DASH_id.cljs$core$IFn$_invoke$arity$1(p1__65062_SHARP_));
});})(snapshot_id_65670,temp__4657__auto___65669,vec__65440_65667,sel1_65668,states,plot_data))
,cljs.core.reverse((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(steps) : cljs.core.deref.call(null,steps))));
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["cell-sdrs ingesting from",cljs.core.cst$kw$snapshot_DASH_id.cljs$core$IFn$_invoke$arity$1(cljs.core.first(to_ingest_65671)),"to",cljs.core.cst$kw$snapshot_DASH_id.cljs$core$IFn$_invoke$arity$1(cljs.core.last(to_ingest_65671))], 0));

var c__38109__auto___65672 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__38109__auto___65672,to_ingest_65671,snapshot_id_65670,temp__4657__auto___65669,vec__65440_65667,sel1_65668,states,plot_data){
return (function (){
var f__38110__auto__ = (function (){var switch__37995__auto__ = ((function (c__38109__auto___65672,to_ingest_65671,snapshot_id_65670,temp__4657__auto___65669,vec__65440_65667,sel1_65668,states,plot_data){
return (function (state_65575){
var state_val_65576 = (state_65575[(1)]);
if((state_val_65576 === (7))){
var inst_65468 = (state_65575[(7)]);
var inst_65469 = (state_65575[(8)]);
var inst_65471 = (inst_65469 < inst_65468);
var inst_65472 = inst_65471;
var state_65575__$1 = state_65575;
if(cljs.core.truth_(inst_65472)){
var statearr_65577_65673 = state_65575__$1;
(statearr_65577_65673[(1)] = (9));

} else {
var statearr_65578_65674 = state_65575__$1;
(statearr_65578_65674[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (20))){
var inst_65506 = (state_65575[(9)]);
var inst_65508 = cljs.core.chunked_seq_QMARK_(inst_65506);
var state_65575__$1 = state_65575;
if(inst_65508){
var statearr_65579_65675 = state_65575__$1;
(statearr_65579_65675[(1)] = (23));

} else {
var statearr_65580_65676 = state_65575__$1;
(statearr_65580_65676[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (27))){
var inst_65506 = (state_65575[(9)]);
var inst_65561 = (state_65575[(2)]);
var inst_65562 = cljs.core.next(inst_65506);
var inst_65448 = inst_65562;
var inst_65449 = null;
var inst_65450 = (0);
var inst_65451 = (0);
var state_65575__$1 = (function (){var statearr_65581 = state_65575;
(statearr_65581[(10)] = inst_65450);

(statearr_65581[(11)] = inst_65449);

(statearr_65581[(12)] = inst_65451);

(statearr_65581[(13)] = inst_65448);

(statearr_65581[(14)] = inst_65561);

return statearr_65581;
})();
var statearr_65582_65677 = state_65575__$1;
(statearr_65582_65677[(2)] = null);

(statearr_65582_65677[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (1))){
var inst_65445 = cljs.core.cons(null,to_ingest_65671);
var inst_65446 = cljs.core.partition.cljs$core$IFn$_invoke$arity$3((2),(1),inst_65445);
var inst_65447 = cljs.core.seq(inst_65446);
var inst_65448 = inst_65447;
var inst_65449 = null;
var inst_65450 = (0);
var inst_65451 = (0);
var state_65575__$1 = (function (){var statearr_65583 = state_65575;
(statearr_65583[(10)] = inst_65450);

(statearr_65583[(11)] = inst_65449);

(statearr_65583[(12)] = inst_65451);

(statearr_65583[(13)] = inst_65448);

return statearr_65583;
})();
var statearr_65584_65678 = state_65575__$1;
(statearr_65584_65678[(2)] = null);

(statearr_65584_65678[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (24))){
var inst_65506 = (state_65575[(9)]);
var inst_65516 = cljs.core.first(inst_65506);
var inst_65517 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65516,(0),null);
var inst_65518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65516,(1),null);
var inst_65519 = org.numenta.sanity.plots.update_cell_sdrs_states_BANG_(states,network_shape,inst_65518,inst_65517,into_journal);
var inst_65524 = cljs.core.seq(inst_65519);
var inst_65525 = inst_65524;
var inst_65526 = null;
var inst_65527 = (0);
var inst_65528 = (0);
var state_65575__$1 = (function (){var statearr_65585 = state_65575;
(statearr_65585[(15)] = inst_65526);

(statearr_65585[(16)] = inst_65527);

(statearr_65585[(17)] = inst_65525);

(statearr_65585[(18)] = inst_65528);

return statearr_65585;
})();
var statearr_65586_65679 = state_65575__$1;
(statearr_65586_65679[(2)] = null);

(statearr_65586_65679[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (4))){
var inst_65449 = (state_65575[(11)]);
var inst_65451 = (state_65575[(12)]);
var inst_65457 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_65449,inst_65451);
var inst_65458 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65457,(0),null);
var inst_65459 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65457,(1),null);
var inst_65460 = org.numenta.sanity.plots.update_cell_sdrs_states_BANG_(states,network_shape,inst_65459,inst_65458,into_journal);
var inst_65465 = cljs.core.seq(inst_65460);
var inst_65466 = inst_65465;
var inst_65467 = null;
var inst_65468 = (0);
var inst_65469 = (0);
var state_65575__$1 = (function (){var statearr_65587 = state_65575;
(statearr_65587[(7)] = inst_65468);

(statearr_65587[(19)] = inst_65467);

(statearr_65587[(8)] = inst_65469);

(statearr_65587[(20)] = inst_65466);

return statearr_65587;
})();
var statearr_65588_65680 = state_65575__$1;
(statearr_65588_65680[(2)] = null);

(statearr_65588_65680[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (15))){
var inst_65498 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65592_65681 = state_65575__$1;
(statearr_65592_65681[(2)] = inst_65498);

(statearr_65592_65681[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (21))){
var state_65575__$1 = state_65575;
var statearr_65593_65682 = state_65575__$1;
(statearr_65593_65682[(2)] = null);

(statearr_65593_65682[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (31))){
var inst_65526 = (state_65575[(15)]);
var inst_65527 = (state_65575[(16)]);
var inst_65525 = (state_65575[(17)]);
var inst_65528 = (state_65575[(18)]);
var inst_65535 = (state_65575[(2)]);
var inst_65536 = (inst_65528 + (1));
var tmp65589 = inst_65526;
var tmp65590 = inst_65527;
var tmp65591 = inst_65525;
var inst_65525__$1 = tmp65591;
var inst_65526__$1 = tmp65589;
var inst_65527__$1 = tmp65590;
var inst_65528__$1 = inst_65536;
var state_65575__$1 = (function (){var statearr_65594 = state_65575;
(statearr_65594[(15)] = inst_65526__$1);

(statearr_65594[(16)] = inst_65527__$1);

(statearr_65594[(17)] = inst_65525__$1);

(statearr_65594[(18)] = inst_65528__$1);

(statearr_65594[(21)] = inst_65535);

return statearr_65594;
})();
var statearr_65595_65683 = state_65575__$1;
(statearr_65595_65683[(2)] = null);

(statearr_65595_65683[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (32))){
var inst_65539 = (state_65575[(22)]);
var inst_65541 = cljs.core.chunked_seq_QMARK_(inst_65539);
var state_65575__$1 = state_65575;
if(inst_65541){
var statearr_65596_65684 = state_65575__$1;
(statearr_65596_65684[(1)] = (35));

} else {
var statearr_65597_65685 = state_65575__$1;
(statearr_65597_65685[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (33))){
var state_65575__$1 = state_65575;
var statearr_65598_65686 = state_65575__$1;
(statearr_65598_65686[(2)] = null);

(statearr_65598_65686[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (13))){
var inst_65480 = (state_65575[(23)]);
var inst_65482 = cljs.core.chunked_seq_QMARK_(inst_65480);
var state_65575__$1 = state_65575;
if(inst_65482){
var statearr_65599_65687 = state_65575__$1;
(statearr_65599_65687[(1)] = (16));

} else {
var statearr_65600_65688 = state_65575__$1;
(statearr_65600_65688[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (22))){
var inst_65568 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65601_65689 = state_65575__$1;
(statearr_65601_65689[(2)] = inst_65568);

(statearr_65601_65689[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (36))){
var inst_65539 = (state_65575[(22)]);
var inst_65548 = cljs.core.first(inst_65539);
var state_65575__$1 = state_65575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65575__$1,(38),inst_65548);
} else {
if((state_val_65576 === (29))){
var inst_65525 = (state_65575[(17)]);
var inst_65539 = (state_65575[(22)]);
var inst_65539__$1 = cljs.core.seq(inst_65525);
var state_65575__$1 = (function (){var statearr_65602 = state_65575;
(statearr_65602[(22)] = inst_65539__$1);

return statearr_65602;
})();
if(inst_65539__$1){
var statearr_65603_65690 = state_65575__$1;
(statearr_65603_65690[(1)] = (32));

} else {
var statearr_65604_65691 = state_65575__$1;
(statearr_65604_65691[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (6))){
var inst_65570 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65605_65692 = state_65575__$1;
(statearr_65605_65692[(2)] = inst_65570);

(statearr_65605_65692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (28))){
var inst_65526 = (state_65575[(15)]);
var inst_65528 = (state_65575[(18)]);
var inst_65533 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_65526,inst_65528);
var state_65575__$1 = state_65575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65575__$1,(31),inst_65533);
} else {
if((state_val_65576 === (25))){
var inst_65565 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65606_65693 = state_65575__$1;
(statearr_65606_65693[(2)] = inst_65565);

(statearr_65606_65693[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (34))){
var inst_65557 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65607_65694 = state_65575__$1;
(statearr_65607_65694[(2)] = inst_65557);

(statearr_65607_65694[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (17))){
var inst_65480 = (state_65575[(23)]);
var inst_65489 = cljs.core.first(inst_65480);
var state_65575__$1 = state_65575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65575__$1,(19),inst_65489);
} else {
if((state_val_65576 === (3))){
var inst_65572 = (state_65575[(2)]);
var inst_65573 = org.numenta.sanity.plots.update_cell_sdrs_plot_data_BANG_(plot_data,states,sel1_65668,into_journal);
var state_65575__$1 = (function (){var statearr_65611 = state_65575;
(statearr_65611[(24)] = inst_65572);

return statearr_65611;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_65575__$1,inst_65573);
} else {
if((state_val_65576 === (12))){
var inst_65468 = (state_65575[(7)]);
var inst_65467 = (state_65575[(19)]);
var inst_65469 = (state_65575[(8)]);
var inst_65466 = (state_65575[(20)]);
var inst_65476 = (state_65575[(2)]);
var inst_65477 = (inst_65469 + (1));
var tmp65608 = inst_65468;
var tmp65609 = inst_65467;
var tmp65610 = inst_65466;
var inst_65466__$1 = tmp65610;
var inst_65467__$1 = tmp65609;
var inst_65468__$1 = tmp65608;
var inst_65469__$1 = inst_65477;
var state_65575__$1 = (function (){var statearr_65612 = state_65575;
(statearr_65612[(7)] = inst_65468__$1);

(statearr_65612[(19)] = inst_65467__$1);

(statearr_65612[(25)] = inst_65476);

(statearr_65612[(8)] = inst_65469__$1);

(statearr_65612[(20)] = inst_65466__$1);

return statearr_65612;
})();
var statearr_65613_65695 = state_65575__$1;
(statearr_65613_65695[(2)] = null);

(statearr_65613_65695[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (2))){
var inst_65450 = (state_65575[(10)]);
var inst_65451 = (state_65575[(12)]);
var inst_65453 = (inst_65451 < inst_65450);
var inst_65454 = inst_65453;
var state_65575__$1 = state_65575;
if(cljs.core.truth_(inst_65454)){
var statearr_65614_65696 = state_65575__$1;
(statearr_65614_65696[(1)] = (4));

} else {
var statearr_65615_65697 = state_65575__$1;
(statearr_65615_65697[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (23))){
var inst_65506 = (state_65575[(9)]);
var inst_65510 = cljs.core.chunk_first(inst_65506);
var inst_65511 = cljs.core.chunk_rest(inst_65506);
var inst_65512 = cljs.core.count(inst_65510);
var inst_65448 = inst_65511;
var inst_65449 = inst_65510;
var inst_65450 = inst_65512;
var inst_65451 = (0);
var state_65575__$1 = (function (){var statearr_65616 = state_65575;
(statearr_65616[(10)] = inst_65450);

(statearr_65616[(11)] = inst_65449);

(statearr_65616[(12)] = inst_65451);

(statearr_65616[(13)] = inst_65448);

return statearr_65616;
})();
var statearr_65617_65698 = state_65575__$1;
(statearr_65617_65698[(2)] = null);

(statearr_65617_65698[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (35))){
var inst_65539 = (state_65575[(22)]);
var inst_65543 = cljs.core.chunk_first(inst_65539);
var inst_65544 = cljs.core.chunk_rest(inst_65539);
var inst_65545 = cljs.core.count(inst_65543);
var inst_65525 = inst_65544;
var inst_65526 = inst_65543;
var inst_65527 = inst_65545;
var inst_65528 = (0);
var state_65575__$1 = (function (){var statearr_65618 = state_65575;
(statearr_65618[(15)] = inst_65526);

(statearr_65618[(16)] = inst_65527);

(statearr_65618[(17)] = inst_65525);

(statearr_65618[(18)] = inst_65528);

return statearr_65618;
})();
var statearr_65619_65699 = state_65575__$1;
(statearr_65619_65699[(2)] = null);

(statearr_65619_65699[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (19))){
var inst_65480 = (state_65575[(23)]);
var inst_65491 = (state_65575[(2)]);
var inst_65492 = cljs.core.next(inst_65480);
var inst_65466 = inst_65492;
var inst_65467 = null;
var inst_65468 = (0);
var inst_65469 = (0);
var state_65575__$1 = (function (){var statearr_65620 = state_65575;
(statearr_65620[(7)] = inst_65468);

(statearr_65620[(19)] = inst_65467);

(statearr_65620[(26)] = inst_65491);

(statearr_65620[(8)] = inst_65469);

(statearr_65620[(20)] = inst_65466);

return statearr_65620;
})();
var statearr_65621_65700 = state_65575__$1;
(statearr_65621_65700[(2)] = null);

(statearr_65621_65700[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (11))){
var inst_65500 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65622_65701 = state_65575__$1;
(statearr_65622_65701[(2)] = inst_65500);

(statearr_65622_65701[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (9))){
var inst_65467 = (state_65575[(19)]);
var inst_65469 = (state_65575[(8)]);
var inst_65474 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_65467,inst_65469);
var state_65575__$1 = state_65575;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65575__$1,(12),inst_65474);
} else {
if((state_val_65576 === (5))){
var inst_65506 = (state_65575[(9)]);
var inst_65448 = (state_65575[(13)]);
var inst_65506__$1 = cljs.core.seq(inst_65448);
var state_65575__$1 = (function (){var statearr_65623 = state_65575;
(statearr_65623[(9)] = inst_65506__$1);

return statearr_65623;
})();
if(inst_65506__$1){
var statearr_65624_65702 = state_65575__$1;
(statearr_65624_65702[(1)] = (20));

} else {
var statearr_65625_65703 = state_65575__$1;
(statearr_65625_65703[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (14))){
var state_65575__$1 = state_65575;
var statearr_65626_65704 = state_65575__$1;
(statearr_65626_65704[(2)] = null);

(statearr_65626_65704[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (26))){
var inst_65527 = (state_65575[(16)]);
var inst_65528 = (state_65575[(18)]);
var inst_65530 = (inst_65528 < inst_65527);
var inst_65531 = inst_65530;
var state_65575__$1 = state_65575;
if(cljs.core.truth_(inst_65531)){
var statearr_65627_65705 = state_65575__$1;
(statearr_65627_65705[(1)] = (28));

} else {
var statearr_65628_65706 = state_65575__$1;
(statearr_65628_65706[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (16))){
var inst_65480 = (state_65575[(23)]);
var inst_65484 = cljs.core.chunk_first(inst_65480);
var inst_65485 = cljs.core.chunk_rest(inst_65480);
var inst_65486 = cljs.core.count(inst_65484);
var inst_65466 = inst_65485;
var inst_65467 = inst_65484;
var inst_65468 = inst_65486;
var inst_65469 = (0);
var state_65575__$1 = (function (){var statearr_65629 = state_65575;
(statearr_65629[(7)] = inst_65468);

(statearr_65629[(19)] = inst_65467);

(statearr_65629[(8)] = inst_65469);

(statearr_65629[(20)] = inst_65466);

return statearr_65629;
})();
var statearr_65630_65707 = state_65575__$1;
(statearr_65630_65707[(2)] = null);

(statearr_65630_65707[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (38))){
var inst_65539 = (state_65575[(22)]);
var inst_65550 = (state_65575[(2)]);
var inst_65551 = cljs.core.next(inst_65539);
var inst_65525 = inst_65551;
var inst_65526 = null;
var inst_65527 = (0);
var inst_65528 = (0);
var state_65575__$1 = (function (){var statearr_65631 = state_65575;
(statearr_65631[(15)] = inst_65526);

(statearr_65631[(16)] = inst_65527);

(statearr_65631[(17)] = inst_65525);

(statearr_65631[(27)] = inst_65550);

(statearr_65631[(18)] = inst_65528);

return statearr_65631;
})();
var statearr_65632_65708 = state_65575__$1;
(statearr_65632_65708[(2)] = null);

(statearr_65632_65708[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (30))){
var inst_65559 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65633_65709 = state_65575__$1;
(statearr_65633_65709[(2)] = inst_65559);

(statearr_65633_65709[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (10))){
var inst_65480 = (state_65575[(23)]);
var inst_65466 = (state_65575[(20)]);
var inst_65480__$1 = cljs.core.seq(inst_65466);
var state_65575__$1 = (function (){var statearr_65634 = state_65575;
(statearr_65634[(23)] = inst_65480__$1);

return statearr_65634;
})();
if(inst_65480__$1){
var statearr_65635_65710 = state_65575__$1;
(statearr_65635_65710[(1)] = (13));

} else {
var statearr_65636_65711 = state_65575__$1;
(statearr_65636_65711[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (18))){
var inst_65495 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65640_65712 = state_65575__$1;
(statearr_65640_65712[(2)] = inst_65495);

(statearr_65640_65712[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (37))){
var inst_65554 = (state_65575[(2)]);
var state_65575__$1 = state_65575;
var statearr_65641_65713 = state_65575__$1;
(statearr_65641_65713[(2)] = inst_65554);

(statearr_65641_65713[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65576 === (8))){
var inst_65450 = (state_65575[(10)]);
var inst_65449 = (state_65575[(11)]);
var inst_65451 = (state_65575[(12)]);
var inst_65448 = (state_65575[(13)]);
var inst_65502 = (state_65575[(2)]);
var inst_65503 = (inst_65451 + (1));
var tmp65637 = inst_65450;
var tmp65638 = inst_65449;
var tmp65639 = inst_65448;
var inst_65448__$1 = tmp65639;
var inst_65449__$1 = tmp65638;
var inst_65450__$1 = tmp65637;
var inst_65451__$1 = inst_65503;
var state_65575__$1 = (function (){var statearr_65642 = state_65575;
(statearr_65642[(10)] = inst_65450__$1);

(statearr_65642[(28)] = inst_65502);

(statearr_65642[(11)] = inst_65449__$1);

(statearr_65642[(12)] = inst_65451__$1);

(statearr_65642[(13)] = inst_65448__$1);

return statearr_65642;
})();
var statearr_65643_65714 = state_65575__$1;
(statearr_65643_65714[(2)] = null);

(statearr_65643_65714[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__38109__auto___65672,to_ingest_65671,snapshot_id_65670,temp__4657__auto___65669,vec__65440_65667,sel1_65668,states,plot_data))
;
return ((function (switch__37995__auto__,c__38109__auto___65672,to_ingest_65671,snapshot_id_65670,temp__4657__auto___65669,vec__65440_65667,sel1_65668,states,plot_data){
return (function() {
var org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__ = null;
var org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____0 = (function (){
var statearr_65647 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_65647[(0)] = org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__);

(statearr_65647[(1)] = (1));

return statearr_65647;
});
var org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____1 = (function (state_65575){
while(true){
var ret_value__37997__auto__ = (function (){try{while(true){
var result__37998__auto__ = switch__37995__auto__(state_65575);
if(cljs.core.keyword_identical_QMARK_(result__37998__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__37998__auto__;
}
break;
}
}catch (e65648){if((e65648 instanceof Object)){
var ex__37999__auto__ = e65648;
var statearr_65649_65715 = state_65575;
(statearr_65649_65715[(5)] = ex__37999__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_65575);

return cljs.core.cst$kw$recur;
} else {
throw e65648;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__37997__auto__,cljs.core.cst$kw$recur)){
var G__65716 = state_65575;
state_65575 = G__65716;
continue;
} else {
return ret_value__37997__auto__;
}
break;
}
});
org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__ = function(state_65575){
switch(arguments.length){
case 0:
return org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____0.call(this);
case 1:
return org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____1.call(this,state_65575);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$0 = org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____0;
org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__.cljs$core$IFn$_invoke$arity$1 = org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto____1;
return org$numenta$sanity$plots$cell_sdrs_plot_builder_$_state_machine__37996__auto__;
})()
;})(switch__37995__auto__,c__38109__auto___65672,to_ingest_65671,snapshot_id_65670,temp__4657__auto___65669,vec__65440_65667,sel1_65668,states,plot_data))
})();
var state__38111__auto__ = (function (){var statearr_65650 = (f__38110__auto__.cljs$core$IFn$_invoke$arity$0 ? f__38110__auto__.cljs$core$IFn$_invoke$arity$0() : f__38110__auto__.call(null));
(statearr_65650[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__38109__auto___65672);

return statearr_65650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__38111__auto__);
});})(c__38109__auto___65672,to_ingest_65671,snapshot_id_65670,temp__4657__auto___65669,vec__65440_65667,sel1_65668,states,plot_data))
);

} else {
}

return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$content,(function (){var size_invalidates_c = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
return ((function (size_invalidates_c,states,plot_data){
return (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.helpers.window_resize_listener,size_invalidates_c], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [org.numenta.sanity.helpers.resizing_canvas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,"100%",cljs.core.cst$kw$height,"100vh"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [plot_data,plot_opts], null),((function (size_invalidates_c,states,plot_data){
return (function (ctx){
return org.numenta.sanity.plots.draw_cell_sdrs_plot_BANG_(ctx,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(plot_data) : cljs.core.deref.call(null,plot_data)),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(plot_opts) : cljs.core.deref.call(null,plot_opts)));
});})(size_invalidates_c,states,plot_data))
,size_invalidates_c], null),org.numenta.sanity.plots.cell_sdrs_context_analysis_cmp((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(plot_data) : cljs.core.deref.call(null,plot_data)),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(plot_opts) : cljs.core.deref.call(null,plot_opts)))], null);
});
;})(size_invalidates_c,states,plot_data))
})(),cljs.core.cst$kw$teardown,((function (states,plot_data){
return (function (){
cljs.core.remove_watch(steps,cljs.core.cst$kw$org$numenta$sanity$plots_SLASH_cell_DASH_sdrs_DASH_plot);

return cljs.core.remove_watch(selection,cljs.core.cst$kw$org$numenta$sanity$plots_SLASH_cell_DASH_sdrs_DASH_plot);
});})(states,plot_data))
], null);
});
