"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Branch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_amplify_1 = require("aws-cdk-lib/aws-amplify");
const utils_1 = require("./utils");
/**
 * (experimental) An Amplify Console branch.
 *
 * @experimental
 */
class Branch extends aws_cdk_lib_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        this.environmentVariables = props.environmentVariables || {};
        const branchName = props.branchName || id;
        const branch = new aws_amplify_1.CfnBranch(this, 'Resource', {
            appId: props.app.appId,
            basicAuthConfig: props.basicAuth && props.basicAuth.bind(this, `${branchName}BasicAuth`),
            branchName,
            buildSpec: props.buildSpec && props.buildSpec.toBuildSpec(),
            description: props.description,
            enableAutoBuild: (_b = props.autoBuild) !== null && _b !== void 0 ? _b : true,
            enablePullRequestPreview: (_c = props.pullRequestPreview) !== null && _c !== void 0 ? _c : true,
            environmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => utils_1.renderEnvironmentVariables(this.environmentVariables) }, { omitEmptyArray: true }),
            pullRequestEnvironmentName: props.pullRequestEnvironmentName,
            stage: props.stage,
        });
        this.arn = branch.attrArn;
        this.branchName = branch.attrBranchName;
    }
    /**
     * (experimental) Import an existing branch.
     *
     * @experimental
     */
    static fromBranchName(scope, id, branchName) {
        class Import extends aws_cdk_lib_1.Resource {
            constructor() {
                super(...arguments);
                this.branchName = branchName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Adds an environment variable to this branch.
     *
     * All environment variables that you add are encrypted to prevent rogue
     * access so you can use them to store secret information.
     *
     * @experimental
     */
    addEnvironment(name, value) {
        this.environmentVariables[name] = value;
        return this;
    }
}
exports.Branch = Branch;
_a = JSII_RTTI_SYMBOL_1;
Branch[_a] = { fqn: "@aws-cdk/aws-amplify-alpha.Branch", version: "2.0.0-alpha.7" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnJhbmNoLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYnJhbmNoLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQ0EsNkNBQXdEO0FBRXhELHlEQUFvRDtBQUdwRCxtQ0FBcUQ7Ozs7OztBQTZDckQsTUFBYSxNQUFPLFNBQVEsc0JBQVE7Ozs7SUFnQmxDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBa0I7O1FBQzFELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLG9CQUFvQixHQUFHLEtBQUssQ0FBQyxvQkFBb0IsSUFBSSxFQUFFLENBQUM7UUFFN0QsTUFBTSxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsSUFBSSxFQUFFLENBQUM7UUFDMUMsTUFBTSxNQUFNLEdBQUcsSUFBSSx1QkFBUyxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDN0MsS0FBSyxFQUFFLEtBQUssQ0FBQyxHQUFHLENBQUMsS0FBSztZQUN0QixlQUFlLEVBQUUsS0FBSyxDQUFDLFNBQVMsSUFBSSxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLEVBQUUsR0FBRyxVQUFVLFdBQVcsQ0FBQztZQUN4RixVQUFVO1lBQ1YsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTLElBQUksS0FBSyxDQUFDLFNBQVMsQ0FBQyxXQUFXLEVBQUU7WUFDM0QsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGVBQWUsUUFBRSxLQUFLLENBQUMsU0FBUyxtQ0FBSSxJQUFJO1lBQ3hDLHdCQUF3QixRQUFFLEtBQUssQ0FBQyxrQkFBa0IsbUNBQUksSUFBSTtZQUMxRCxvQkFBb0IsRUFBRSxrQkFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxrQ0FBMEIsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLENBQUMsRUFBRSxFQUFFLEVBQUUsY0FBYyxFQUFFLElBQUksRUFBRSxDQUFDO1lBQ2xJLDBCQUEwQixFQUFFLEtBQUssQ0FBQywwQkFBMEI7WUFDNUQsS0FBSyxFQUFFLEtBQUssQ0FBQyxLQUFLO1NBQ25CLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxHQUFHLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMxQixJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sQ0FBQyxjQUFjLENBQUM7SUFDMUMsQ0FBQzs7Ozs7O0lBbkNNLE1BQU0sQ0FBQyxjQUFjLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsVUFBa0I7UUFDM0UsTUFBTSxNQUFPLFNBQVEsc0JBQVE7WUFBN0I7O2dCQUNrQixlQUFVLEdBQUcsVUFBVSxDQUFDO1lBQzFDLENBQUM7U0FBQTtRQUNELE9BQU8sSUFBSSxNQUFNLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQy9CLENBQUM7Ozs7Ozs7OztJQWlDTSxjQUFjLENBQUMsSUFBWSxFQUFFLEtBQWE7UUFDL0MsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxHQUFHLEtBQUssQ0FBQztRQUN4QyxPQUFPLElBQUksQ0FBQztJQUNkLENBQUM7O0FBM0NILHdCQTRDQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVidWlsZCBmcm9tICdhd3MtY2RrLWxpYi9hd3MtY29kZWJ1aWxkJztcbmltcG9ydCB7IElSZXNvdXJjZSwgTGF6eSwgUmVzb3VyY2UgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmbkJyYW5jaCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1hbXBsaWZ5JztcbmltcG9ydCB7IElBcHAgfSBmcm9tICcuL2FwcCc7XG5pbXBvcnQgeyBCYXNpY0F1dGggfSBmcm9tICcuL2Jhc2ljLWF1dGgnO1xuaW1wb3J0IHsgcmVuZGVyRW52aXJvbm1lbnRWYXJpYWJsZXMgfSBmcm9tICcuL3V0aWxzJztcblxuICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBJQnJhbmNoIGV4dGVuZHMgSVJlc291cmNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBicmFuY2hOYW1lOiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgQnJhbmNoT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBiYXNpY0F1dGg/OiBCYXNpY0F1dGg7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYnJhbmNoTmFtZT86IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYnVpbGRTcGVjPzogY29kZWJ1aWxkLkJ1aWxkU3BlYztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGRlc2NyaXB0aW9uPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXV0b0J1aWxkPzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcHVsbFJlcXVlc3RQcmV2aWV3PzogYm9vbGVhbjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBlbnZpcm9ubWVudFZhcmlhYmxlcz86IHsgW25hbWU6IHN0cmluZ106IHN0cmluZyB9O1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHB1bGxSZXF1ZXN0RW52aXJvbm1lbnROYW1lPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHN0YWdlPzogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEJyYW5jaFByb3BzIGV4dGVuZHMgQnJhbmNoT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgYXBwOiBJQXBwO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBCcmFuY2ggZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElCcmFuY2gge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUJyYW5jaE5hbWUoc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgYnJhbmNoTmFtZTogc3RyaW5nKTogSUJyYW5jaCB7XG4gICAgY2xhc3MgSW1wb3J0IGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJQnJhbmNoIHtcbiAgICAgIHB1YmxpYyByZWFkb25seSBicmFuY2hOYW1lID0gYnJhbmNoTmFtZTtcbiAgICB9XG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgcmVhZG9ubHkgYXJuOiBzdHJpbmc7XG5cbiAgcHVibGljIHJlYWRvbmx5IGJyYW5jaE5hbWU6IHN0cmluZztcblxuICBwcml2YXRlIHJlYWRvbmx5IGVudmlyb25tZW50VmFyaWFibGVzOiB7IFtuYW1lOiBzdHJpbmddOiBzdHJpbmcgfTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQnJhbmNoUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy5lbnZpcm9ubWVudFZhcmlhYmxlcyA9IHByb3BzLmVudmlyb25tZW50VmFyaWFibGVzIHx8IHt9O1xuXG4gICAgY29uc3QgYnJhbmNoTmFtZSA9IHByb3BzLmJyYW5jaE5hbWUgfHwgaWQ7XG4gICAgY29uc3QgYnJhbmNoID0gbmV3IENmbkJyYW5jaCh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBhcHBJZDogcHJvcHMuYXBwLmFwcElkLFxuICAgICAgYmFzaWNBdXRoQ29uZmlnOiBwcm9wcy5iYXNpY0F1dGggJiYgcHJvcHMuYmFzaWNBdXRoLmJpbmQodGhpcywgYCR7YnJhbmNoTmFtZX1CYXNpY0F1dGhgKSxcbiAgICAgIGJyYW5jaE5hbWUsXG4gICAgICBidWlsZFNwZWM6IHByb3BzLmJ1aWxkU3BlYyAmJiBwcm9wcy5idWlsZFNwZWMudG9CdWlsZFNwZWMoKSxcbiAgICAgIGRlc2NyaXB0aW9uOiBwcm9wcy5kZXNjcmlwdGlvbixcbiAgICAgIGVuYWJsZUF1dG9CdWlsZDogcHJvcHMuYXV0b0J1aWxkID8/IHRydWUsXG4gICAgICBlbmFibGVQdWxsUmVxdWVzdFByZXZpZXc6IHByb3BzLnB1bGxSZXF1ZXN0UHJldmlldyA/PyB0cnVlLFxuICAgICAgZW52aXJvbm1lbnRWYXJpYWJsZXM6IExhenkuYW55KHsgcHJvZHVjZTogKCkgPT4gcmVuZGVyRW52aXJvbm1lbnRWYXJpYWJsZXModGhpcy5lbnZpcm9ubWVudFZhcmlhYmxlcykgfSwgeyBvbWl0RW1wdHlBcnJheTogdHJ1ZSB9KSxcbiAgICAgIHB1bGxSZXF1ZXN0RW52aXJvbm1lbnROYW1lOiBwcm9wcy5wdWxsUmVxdWVzdEVudmlyb25tZW50TmFtZSxcbiAgICAgIHN0YWdlOiBwcm9wcy5zdGFnZSxcbiAgICB9KTtcblxuICAgIHRoaXMuYXJuID0gYnJhbmNoLmF0dHJBcm47XG4gICAgdGhpcy5icmFuY2hOYW1lID0gYnJhbmNoLmF0dHJCcmFuY2hOYW1lO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIGFkZEVudmlyb25tZW50KG5hbWU6IHN0cmluZywgdmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuZW52aXJvbm1lbnRWYXJpYWJsZXNbbmFtZV0gPSB2YWx1ZTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxufVxuIl19