import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [gamesparks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongamesparks.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Gamesparks extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [gamesparks](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongamesparks.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_CreateGame.html
     */
    toCreateGame(): this;
    /**
     * Grants permission to create a snapshot of a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_CreateSnapshot.html
     */
    toCreateSnapshot(): this;
    /**
     * Grants permission to create a stage in a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_CreateStage.html
     */
    toCreateStage(): this;
    /**
     * Grants permission to delete a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_DeleteGame.html
     */
    toDeleteGame(): this;
    /**
     * Grants permission to delete a stage from a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_DeleteStage.html
     */
    toDeleteStage(): this;
    /**
     * Grants permission to disconnect a player from the game runtime
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_DisconnectPlayer.html
     */
    toDisconnectPlayer(): this;
    /**
     * Grants permission to export a snapshot of the game configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ExportSnapshot.html
     */
    toExportSnapshot(): this;
    /**
     * Grants permission to get details about an extension
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetExtension.html
     */
    toGetExtension(): this;
    /**
     * Grants permission to get details about an extension version
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetExtensionVersion.html
     */
    toGetExtensionVersion(): this;
    /**
     * Grants permission to get details about a game
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetGame.html
     */
    toGetGame(): this;
    /**
     * Grants permission to get the configuration for the game
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetGameConfiguration.html
     */
    toGetGameConfiguration(): this;
    /**
     * Grants permission to get details about a job that is generating code for a snapshot
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetGeneratedCodeJob.html
     */
    toGetGeneratedCodeJob(): this;
    /**
     * Grants permission to get the status of a player connection
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetPlayerConnectionStatus.html
     */
    toGetPlayerConnectionStatus(): this;
    /**
     * Grants permission to get a snapshot of the game
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetSnapshot.html
     */
    toGetSnapshot(): this;
    /**
     * Grants permission to gets information about a stage
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetStage.html
     */
    toGetStage(): this;
    /**
     * Grants permission to get information about a stage deployment
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_GetStageDeployment.html
     */
    toGetStageDeployment(): this;
    /**
     * Grants permission to import a snapshot of a game configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ImportGameDocument.html
     */
    toImportGameConfiguration(): this;
    /**
     * Grants permission to invoke backend services for a specific game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/dg/security-iam-stage-roles.html
     */
    toInvokeBackend(): this;
    /**
     * Grants permission to list the extension versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListExtensionVersions.html
     */
    toListExtensionVersions(): this;
    /**
     * Grants permission to list the extensions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListExtensions.html
     */
    toListExtensions(): this;
    /**
     * Grants permission to list the games
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListGames.html
     */
    toListGames(): this;
    /**
     * Grants permission to get a list of code generation jobs for a snapshot
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListGeneratedCodeJobs.html
     */
    toListGeneratedCodeJobs(): this;
    /**
     * Grants permission to get a list of snapshot summaries for a game
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListSnapshots.html
     */
    toListSnapshots(): this;
    /**
     * Grants permission to get a list of stage deployment summaries for a game
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListStageDeployments.html
     */
    toListStageDeployments(): this;
    /**
     * Grants permission to get a list of stage summaries for a game
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListStages.html
     */
    toListStages(): this;
    /**
     * Grants permission to list the tags associated with a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to start an asynchronous process that generates client code for system-defined and custom messages
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_StartGeneratedCodeJob.html
     */
    toStartGeneratedCodeJob(): this;
    /**
     * Grants permission to deploy a snapshot to a stage and creates a new game runtime
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_StartStageDeployment.html
     */
    toStartStageDeployment(): this;
    /**
     * Grants permission to adds tags to a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to remove tags from a resource
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to change the metadata of a game
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UpdateGame.html
     */
    toUpdateGame(): this;
    /**
     * Grants permission to change the working copy of the game configuration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UpdateGameConfiguration.html
     */
    toUpdateGameConfiguration(): this;
    /**
     * Grants permission to update the metadata of a snapshot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UpdateSnapshot.html
     */
    toUpdateSnapshot(): this;
    /**
     * Grants permission to update the metadata of a stage
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/gamesparks/latest/api/svc/API_UpdateStage.html
     */
    toUpdateStage(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type game to the statement
     *
     * https://docs.aws.amazon.com/gamesparks/latest/dg/security-iam-service.html#policy-resources
     *
     * @param gameId - Identifier for the gameId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGame(gameId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type stage to the statement
     *
     * https://docs.aws.amazon.com/gamesparks/latest/dg/security-iam-service.html#policy-resources
     *
     * @param gameId - Identifier for the gameId.
     * @param stageName - Identifier for the stageName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onStage(gameId: string, stageName: string, account?: string, region?: string, partition?: string): this;
}
