import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
/**
 * Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Iotroborunner extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [iotroborunner](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotroborunner.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to create an action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateAction.html
     */
    toCreateAction(): this;
    /**
     * Grants permission to create an action template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateActionTemplate.html
     */
    toCreateActionTemplate(): this;
    /**
     * Grants permission to create an action template dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateActionTemplateDependency.html
     */
    toCreateActionTemplateDependency(): this;
    /**
     * Grants permission to create an activity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateActivity.html
     */
    toCreateActivity(): this;
    /**
     * Grants permission to create an activity dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateActivityDependency.html
     */
    toCreateActivityDependency(): this;
    /**
     * Grants permission to create a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateDestination.html
     */
    toCreateDestination(): this;
    /**
     * Grants permission to create a destination relationship
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateDestinationRelationship.html
     */
    toCreateDestinationRelationship(): this;
    /**
     * Grants permission to create a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateSite.html
     */
    toCreateSite(): this;
    /**
     * Grants permission to create a task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateTask.html
     */
    toCreateTask(): this;
    /**
     * Grants permission to create a task dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateTaskDependency.html
     */
    toCreateTaskDependency(): this;
    /**
     * Grants permission to create a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateWorker.html
     */
    toCreateWorker(): this;
    /**
     * Grants permission to create a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_CreateWorkerFleet.html
     */
    toCreateWorkerFleet(): this;
    /**
     * Grants permission to delete an action
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteAction.html
     */
    toDeleteAction(): this;
    /**
     * Grants permission to delete an action template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteActionTemplate.html
     */
    toDeleteActionTemplate(): this;
    /**
     * Grants permission to delete an action template dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteActionTemplateDependency.html
     */
    toDeleteActionTemplateDependency(): this;
    /**
     * Grants permission to delete an activity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteActivity.html
     */
    toDeleteActivity(): this;
    /**
     * Grants permission to delete an activity dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteActivityDependency.html
     */
    toDeleteActivityDependency(): this;
    /**
     * Grants permission to delete a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteDestination.html
     */
    toDeleteDestination(): this;
    /**
     * Grants permission to delete a destination relationship
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteDestinationRelationship.html
     */
    toDeleteDestinationRelationship(): this;
    /**
     * Grants permission to delete a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteSite.html
     */
    toDeleteSite(): this;
    /**
     * Grants permission to delete a task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteTask.html
     */
    toDeleteTask(): this;
    /**
     * Grants permission to delete a task dependency
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteTaskDependency.html
     */
    toDeleteTaskDependency(): this;
    /**
     * Grants permission to delete a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteWorker.html
     */
    toDeleteWorker(): this;
    /**
     * Grants permission to delete a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_DeleteWorkerFleet.html
     */
    toDeleteWorkerFleet(): this;
    /**
     * Grants permission to get an action
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetAction.html
     */
    toGetAction(): this;
    /**
     * Grants permission to get an action template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetActionTemplate.html
     */
    toGetActionTemplate(): this;
    /**
     * Grants permission to get an activity
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetActivity.html
     */
    toGetActivity(): this;
    /**
     * Grants permission to get a destination
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetDestination.html
     */
    toGetDestination(): this;
    /**
     * Grants permission to get a destination relationship
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetDestinationRelationship.html
     */
    toGetDestinationRelationship(): this;
    /**
     * Grants permission to get a site
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetSite.html
     */
    toGetSite(): this;
    /**
     * Grants permission to get a task
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetTask.html
     */
    toGetTask(): this;
    /**
     * Grants permission to get a worker
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetWorker.html
     */
    toGetWorker(): this;
    /**
     * Grants permission to get a worker fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_GetWorkerFleet.html
     */
    toGetWorkerFleet(): this;
    /**
     * Grants permission to list action templates
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListActionTemplates.html
     */
    toListActionTemplates(): this;
    /**
     * Grants permission to list actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListActions.html
     */
    toListActions(): this;
    /**
     * Grants permission to list activities
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListActivities.html
     */
    toListActivities(): this;
    /**
     * Grants permission to list destination relationships
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListDestinationRelationships.html
     */
    toListDestinationRelationships(): this;
    /**
     * Grants permission to list destinations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListDestinations.html
     */
    toListDestinations(): this;
    /**
     * Grants permission to list sites
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListSites.html
     */
    toListSites(): this;
    /**
     * Grants permission to list tasks
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListTasks.html
     */
    toListTasks(): this;
    /**
     * Grants permission to list worker fleets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListWorkerFleets.html
     */
    toListWorkerFleets(): this;
    /**
     * Grants permission to list workers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_ListWorkers.html
     */
    toListWorkers(): this;
    /**
     * Grants permission to update an action's state
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateActionState.html
     */
    toUpdateActionState(): this;
    /**
     * Grants permission to update an activity
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateActivity.html
     */
    toUpdateActivity(): this;
    /**
     * Grants permission to update a destination
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateDestination.html
     */
    toUpdateDestination(): this;
    /**
     * Grants permission to update a site
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateSite.html
     */
    toUpdateSite(): this;
    /**
     * Grants permission to update a task
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateTask.html
     */
    toUpdateTask(): this;
    /**
     * Grants permission to update a worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateWorker.html
     */
    toUpdateWorker(): this;
    /**
     * Grants permission to update a worker fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/API_UpdateWorkerFleet.html
     */
    toUpdateWorkerFleet(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type ActionResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param actionId - Identifier for the actionId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifActionResourceId()
     */
    onActionResource(actionId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ActionTemplateResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param actionTemplateId - Identifier for the actionTemplateId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifActionTemplateResourceId()
     */
    onActionTemplateResource(actionTemplateId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type ActivityResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param activityId - Identifier for the activityId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifActivityResourceId()
     */
    onActivityResource(activityId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type DestinationRelationshipResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param destinationRelationshipId - Identifier for the destinationRelationshipId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifDestinationRelationshipResourceId()
     */
    onDestinationRelationshipResource(destinationRelationshipId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type DestinationResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param destinationId - Identifier for the destinationId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifDestinationResourceId()
     */
    onDestinationResource(destinationId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type SiteResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifSiteResourceId()
     */
    onSiteResource(siteId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TaggingResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param tagKey - Identifier for the tagKey.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifTaggingResourceTagKey()
     */
    onTaggingResource(tagKey: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type TaskResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param taskId - Identifier for the taskId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifTaskResourceId()
     */
    onTaskResource(taskId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type WorkerFleetResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param workerFleetId - Identifier for the workerFleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifWorkerFleetResourceId()
     */
    onWorkerFleetResource(siteId: string, workerFleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type WorkerResource to the statement
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/api/
     *
     * @param siteId - Identifier for the siteId.
     * @param workerFleetId - Identifier for the workerFleetId.
     * @param workerId - Identifier for the workerId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifWorkerResourceId()
     */
    onWorkerResource(siteId: string, workerFleetId: string, workerId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Filters access by the action's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Action
     *
     * Applies to resource types:
     * - ActionResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActionResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the action template's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#ActionTemplate
     *
     * Applies to resource types:
     * - ActionTemplateResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActionTemplateResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the activity's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Activity
     *
     * Applies to resource types:
     * - ActivityResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifActivityResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the destination relationship's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#DestinationRelationship
     *
     * Applies to resource types:
     * - DestinationRelationshipResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDestinationRelationshipResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the destination's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Destination
     *
     * Applies to resource types:
     * - DestinationResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifDestinationResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the site's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Site
     *
     * Applies to resource types:
     * - SiteResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifSiteResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the metadata tag name
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Tagging
     *
     * Applies to resource types:
     * - TaggingResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTaggingResourceTagKey(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the task's identifer
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Task
     *
     * Applies to resource types:
     * - TaskResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTaskResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the worker fleet's identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#WorkerFleet
     *
     * Applies to resource types:
     * - WorkerFleetResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkerFleetResourceId(value: string | string[], operator?: Operator | string): this;
    /**
     * Filters access by the workers identifier
     *
     * https://docs.aws.amazon.com/iotroborunner/latest/dev/#Worker
     *
     * Applies to resource types:
     * - WorkerResource
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifWorkerResourceId(value: string | string[], operator?: Operator | string): this;
}
