"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyStatementWithResources = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _3_actions_1 = require("./3-actions");
/**
 * Adds "resource" functionality to the Policy Statement
 */
class PolicyStatementWithResources extends _3_actions_1.PolicyStatementWithActions {
    constructor() {
        super(...arguments);
        this.useNotResource = false;
        this.floydResources = [];
        this.skipAutoResource = false;
        this.cdkResourcesApplied = false;
    }
    /**
     * Injects resources into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON() {
        // @ts-ignore only available after swapping 1-base
        if (typeof this.addResources == 'function') {
            this.cdkApplyResources();
            return super.toJSON();
        }
        const mode = this.useNotResource ? 'NotResource' : 'Resource';
        const statement = super.toJSON();
        const self = this;
        this.ensureResource();
        if (this.floydResources.length) {
            const resources = this.floydResources.filter((elem, pos) => {
                return self.floydResources.indexOf(elem) == pos;
            });
            statement[mode] = resources.length > 1 ? resources : resources[0];
        }
        return statement;
    }
    toStatementJson() {
        this.ensureResource();
        this.cdkApplyResources();
        // @ts-ignore only available after swapping 1-base
        return super.toStatementJson();
    }
    freeze() {
        // @ts-ignore only available after swapping 1-base
        if (!this.frozen) {
            this.ensureResource();
            this.cdkApplyResources();
        }
        return super.freeze();
    }
    cdkApplyResources() {
        if (!this.cdkResourcesApplied) {
            const mode = this.useNotResource ? 'addNotResources' : 'addResources';
            const self = this;
            const uniqueResources = this.floydResources.filter((elem, pos) => {
                return self.floydResources.indexOf(elem) == pos;
            });
            // @ts-ignore only available after swapping 1-base
            this[mode](...uniqueResources);
            this.cdkResourcesApplied = true;
        }
    }
    /**
     * Switches the statement to use [`NotResource`](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html).
     */
    notResource() {
        this.useNotResource = true;
        return this;
    }
    /**
     * Checks weather any resource was applied to the policy.
     */
    hasResources() {
        return this.floydResources.length > 0;
    }
    /**
     * Limit statement to specified resources.
     *
     * To allow all resources, pass `*`
     */
    on(...arns) {
        this.floydResources.push(...arns);
        return this;
    }
    /**
     * Add all resources (`*`) to the statement
     *
     * This is the default behavior, unless the statement has principals.
     */
    onAllResources() {
        this.floydResources.push('*');
        return this;
    }
    ensureResource() {
        if (this.hasResources())
            return;
        // @ts-ignore only available after swapping 1-base
        if (this.hasResource)
            return;
        // @ts-ignore only available after swapping 1-base
        if (this.hasPrincipal)
            return; //assume policies may not have resources
        if (this.skipAutoResource)
            return;
        // a statement requires resources. if none was added, we assume the user wants all resources
        this.onAllResources();
    }
}
exports.PolicyStatementWithResources = PolicyStatementWithResources;
_a = JSII_RTTI_SYMBOL_1;
PolicyStatementWithResources[_a] = { fqn: "iam-floyd.PolicyStatementWithResources", version: "0.410.0" };
//# sourceMappingURL=data:application/json;base64,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