import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAdOuConfig extends cdktf.TerraformMetaArguments {
    /**
    * Distinguished Name of the OU object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/ou#dn DataAdOu#dn}
    */
    readonly dn?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/ou#id DataAdOu#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the OU object. If this is used then the `path` attribute needs to be set as well.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/ou#name DataAdOu#name}
    */
    readonly name?: string;
    /**
    * The OU's identifier. It can be the OU's GUID, SID, Distinguished Name, or SAM Account Name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/ou#ou_id DataAdOu#ou_id}
    */
    readonly ouId?: string;
    /**
    * Path of the OU object. If this is used then the `Name` attribute needs to be set as well.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/d/ou#path DataAdOu#path}
    */
    readonly path?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/d/ou ad_ou}
*/
export declare class DataAdOu extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ad_ou";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/d/ou ad_ou} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAdOuConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAdOuConfig);
    get description(): string;
    private _dn?;
    get dn(): string;
    set dn(value: string);
    resetDn(): void;
    get dnInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _ouId?;
    get ouId(): string;
    set ouId(value: string);
    resetOuId(): void;
    get ouIdInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    get protected(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
