import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GplinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * Controls the state of the GP link between a GPO and a container object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gplink#enabled Gplink#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * If set to true, the GPO will be enforced on the container object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gplink#enforced Gplink#enforced}
    */
    readonly enforced?: boolean | cdktf.IResolvable;
    /**
    * The GUID of the GPO that will be linked to the container object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gplink#gpo_guid Gplink#gpo_guid}
    */
    readonly gpoGuid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gplink#id Gplink#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Sets the precedence between multiple GPOs linked to the same container object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gplink#order Gplink#order}
    */
    readonly order?: number;
    /**
    * The DN of the object the GPO will be linked to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gplink#target_dn Gplink#target_dn}
    */
    readonly targetDn: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/r/gplink ad_gplink}
*/
export declare class Gplink extends cdktf.TerraformResource {
    static readonly tfResourceType = "ad_gplink";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/r/gplink ad_gplink} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GplinkConfig
    */
    constructor(scope: Construct, id: string, config: GplinkConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enforced?;
    get enforced(): boolean | cdktf.IResolvable;
    set enforced(value: boolean | cdktf.IResolvable);
    resetEnforced(): void;
    get enforcedInput(): boolean | cdktf.IResolvable | undefined;
    private _gpoGuid?;
    get gpoGuid(): string;
    set gpoGuid(value: string);
    get gpoGuidInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _order?;
    get order(): number;
    set order(value: number);
    resetOrder(): void;
    get orderInput(): number | undefined;
    private _targetDn?;
    get targetDn(): string;
    set targetDn(value: string);
    get targetDnInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
