import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GpoSecurityConfig extends cdktf.TerraformMetaArguments {
    /**
    * The GUID of the container the security settings belong to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#gpo_container GpoSecurity#gpo_container}
    */
    readonly gpoContainer: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#id GpoSecurity#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * account_lockout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#account_lockout GpoSecurity#account_lockout}
    */
    readonly accountLockout?: GpoSecurityAccountLockout;
    /**
    * application_log block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#application_log GpoSecurity#application_log}
    */
    readonly applicationLog?: GpoSecurityApplicationLog;
    /**
    * audit_log block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_log GpoSecurity#audit_log}
    */
    readonly auditLog?: GpoSecurityAuditLog;
    /**
    * event_audit block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#event_audit GpoSecurity#event_audit}
    */
    readonly eventAudit?: GpoSecurityEventAudit;
    /**
    * filesystem block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#filesystem GpoSecurity#filesystem}
    */
    readonly filesystem?: GpoSecurityFilesystem[] | cdktf.IResolvable;
    /**
    * kerberos_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#kerberos_policy GpoSecurity#kerberos_policy}
    */
    readonly kerberosPolicy?: GpoSecurityKerberosPolicy;
    /**
    * password_policies block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#password_policies GpoSecurity#password_policies}
    */
    readonly passwordPolicies?: GpoSecurityPasswordPolicies;
    /**
    * registry_keys block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#registry_keys GpoSecurity#registry_keys}
    */
    readonly registryKeys?: GpoSecurityRegistryKeys[] | cdktf.IResolvable;
    /**
    * registry_values block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#registry_values GpoSecurity#registry_values}
    */
    readonly registryValues?: GpoSecurityRegistryValues[] | cdktf.IResolvable;
    /**
    * restricted_groups block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#restricted_groups GpoSecurity#restricted_groups}
    */
    readonly restrictedGroups?: GpoSecurityRestrictedGroups[] | cdktf.IResolvable;
    /**
    * system_log block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#system_log GpoSecurity#system_log}
    */
    readonly systemLog?: GpoSecuritySystemLog;
    /**
    * system_services block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#system_services GpoSecurity#system_services}
    */
    readonly systemServices?: GpoSecuritySystemServices[] | cdktf.IResolvable;
}
export interface GpoSecurityAccountLockout {
    /**
    * Disconnect SMB sessions when logon hours expire.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#force_logoff_when_hour_expire GpoSecurity#force_logoff_when_hour_expire}
    */
    readonly forceLogoffWhenHourExpire?: string;
    /**
    * Number of failed logon attempts until a account is locked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#lockout_bad_count GpoSecurity#lockout_bad_count}
    */
    readonly lockoutBadCount?: string;
    /**
    * Number of minutes a locked out account must remain locked out.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#lockout_duration GpoSecurity#lockout_duration}
    */
    readonly lockoutDuration?: string;
    /**
    * Number of minutes a account will remain locked after a failed logon attempt.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#reset_lockout_count GpoSecurity#reset_lockout_count}
    */
    readonly resetLockoutCount?: string;
}
export declare function gpoSecurityAccountLockoutToTerraform(struct?: GpoSecurityAccountLockoutOutputReference | GpoSecurityAccountLockout): any;
export declare class GpoSecurityAccountLockoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GpoSecurityAccountLockout | undefined;
    set internalValue(value: GpoSecurityAccountLockout | undefined);
    private _forceLogoffWhenHourExpire?;
    get forceLogoffWhenHourExpire(): string;
    set forceLogoffWhenHourExpire(value: string);
    resetForceLogoffWhenHourExpire(): void;
    get forceLogoffWhenHourExpireInput(): string | undefined;
    private _lockoutBadCount?;
    get lockoutBadCount(): string;
    set lockoutBadCount(value: string);
    resetLockoutBadCount(): void;
    get lockoutBadCountInput(): string | undefined;
    private _lockoutDuration?;
    get lockoutDuration(): string;
    set lockoutDuration(value: string);
    resetLockoutDuration(): void;
    get lockoutDurationInput(): string | undefined;
    private _resetLockoutCount?;
    get resetLockoutCount(): string;
    set resetLockoutCount(value: string);
    resetResetLockoutCount(): void;
    get resetLockoutCountInput(): string | undefined;
}
export interface GpoSecurityApplicationLog {
    /**
    * Control log retention. Values: 0: overwrite events as needed, 1: overwrite events as specified specified by `retention_days`, 2: never overwrite events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_log_retention_period GpoSecurity#audit_log_retention_period}
    */
    readonly auditLogRetentionPeriod?: string;
    /**
    * Maximum size of log in KiloBytes. (64-4194240)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#maximum_log_size GpoSecurity#maximum_log_size}
    */
    readonly maximumLogSize?: string;
    /**
    * Restrict access to logs for guest users. A non-zero value restricts access to guest users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#restrict_guest_access GpoSecurity#restrict_guest_access}
    */
    readonly restrictGuestAccess?: string;
    /**
    * Number of days before new events overwrite old events. (1-365)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#retention_days GpoSecurity#retention_days}
    */
    readonly retentionDays?: string;
}
export declare function gpoSecurityApplicationLogToTerraform(struct?: GpoSecurityApplicationLogOutputReference | GpoSecurityApplicationLog): any;
export declare class GpoSecurityApplicationLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GpoSecurityApplicationLog | undefined;
    set internalValue(value: GpoSecurityApplicationLog | undefined);
    private _auditLogRetentionPeriod?;
    get auditLogRetentionPeriod(): string;
    set auditLogRetentionPeriod(value: string);
    resetAuditLogRetentionPeriod(): void;
    get auditLogRetentionPeriodInput(): string | undefined;
    private _maximumLogSize?;
    get maximumLogSize(): string;
    set maximumLogSize(value: string);
    resetMaximumLogSize(): void;
    get maximumLogSizeInput(): string | undefined;
    private _restrictGuestAccess?;
    get restrictGuestAccess(): string;
    set restrictGuestAccess(value: string);
    resetRestrictGuestAccess(): void;
    get restrictGuestAccessInput(): string | undefined;
    private _retentionDays?;
    get retentionDays(): string;
    set retentionDays(value: string);
    resetRetentionDays(): void;
    get retentionDaysInput(): string | undefined;
}
export interface GpoSecurityAuditLog {
    /**
    * Control log retention. Values: 0: overwrite events as needed, 1: overwrite events as specified specified by `retention_days`, 2: never overwrite events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_log_retention_period GpoSecurity#audit_log_retention_period}
    */
    readonly auditLogRetentionPeriod?: string;
    /**
    * Maximum size of log in KiloBytes. (64-4194240)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#maximum_log_size GpoSecurity#maximum_log_size}
    */
    readonly maximumLogSize?: string;
    /**
    * Restrict access to logs for guest users. A non-zero value restricts access to guest users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#restrict_guest_access GpoSecurity#restrict_guest_access}
    */
    readonly restrictGuestAccess?: string;
    /**
    * Number of days before new events overwrite old events. (1-365)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#retention_days GpoSecurity#retention_days}
    */
    readonly retentionDays?: string;
}
export declare function gpoSecurityAuditLogToTerraform(struct?: GpoSecurityAuditLogOutputReference | GpoSecurityAuditLog): any;
export declare class GpoSecurityAuditLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GpoSecurityAuditLog | undefined;
    set internalValue(value: GpoSecurityAuditLog | undefined);
    private _auditLogRetentionPeriod?;
    get auditLogRetentionPeriod(): string;
    set auditLogRetentionPeriod(value: string);
    resetAuditLogRetentionPeriod(): void;
    get auditLogRetentionPeriodInput(): string | undefined;
    private _maximumLogSize?;
    get maximumLogSize(): string;
    set maximumLogSize(value: string);
    resetMaximumLogSize(): void;
    get maximumLogSizeInput(): string | undefined;
    private _restrictGuestAccess?;
    get restrictGuestAccess(): string;
    set restrictGuestAccess(value: string);
    resetRestrictGuestAccess(): void;
    get restrictGuestAccessInput(): string | undefined;
    private _retentionDays?;
    get retentionDays(): string;
    set retentionDays(value: string);
    resetRetentionDays(): void;
    get retentionDaysInput(): string | undefined;
}
export interface GpoSecurityEventAudit {
    /**
    * Audit credential validation.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_account_logon GpoSecurity#audit_account_logon}
    */
    readonly auditAccountLogon?: string;
    /**
    * Audit account management events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_account_manage GpoSecurity#audit_account_manage}
    */
    readonly auditAccountManage?: string;
    /**
    * Audit access attempts to AD objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_ds_access GpoSecurity#audit_ds_access}
    */
    readonly auditDsAccess?: string;
    /**
    * Audit logon events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_logon_events GpoSecurity#audit_logon_events}
    */
    readonly auditLogonEvents?: string;
    /**
    * Audit access attempts to non-AD objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_object_access GpoSecurity#audit_object_access}
    */
    readonly auditObjectAccess?: string;
    /**
    * Audit attempts to change a policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_policy_change GpoSecurity#audit_policy_change}
    */
    readonly auditPolicyChange?: string;
    /**
    * Audit user attempts of exercising user rights.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_privilege_use GpoSecurity#audit_privilege_use}
    */
    readonly auditPrivilegeUse?: string;
    /**
    * Audit process related events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_process_tracking GpoSecurity#audit_process_tracking}
    */
    readonly auditProcessTracking?: string;
    /**
    * Audit system events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_system_events GpoSecurity#audit_system_events}
    */
    readonly auditSystemEvents?: string;
}
export declare function gpoSecurityEventAuditToTerraform(struct?: GpoSecurityEventAuditOutputReference | GpoSecurityEventAudit): any;
export declare class GpoSecurityEventAuditOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GpoSecurityEventAudit | undefined;
    set internalValue(value: GpoSecurityEventAudit | undefined);
    private _auditAccountLogon?;
    get auditAccountLogon(): string;
    set auditAccountLogon(value: string);
    resetAuditAccountLogon(): void;
    get auditAccountLogonInput(): string | undefined;
    private _auditAccountManage?;
    get auditAccountManage(): string;
    set auditAccountManage(value: string);
    resetAuditAccountManage(): void;
    get auditAccountManageInput(): string | undefined;
    private _auditDsAccess?;
    get auditDsAccess(): string;
    set auditDsAccess(value: string);
    resetAuditDsAccess(): void;
    get auditDsAccessInput(): string | undefined;
    private _auditLogonEvents?;
    get auditLogonEvents(): string;
    set auditLogonEvents(value: string);
    resetAuditLogonEvents(): void;
    get auditLogonEventsInput(): string | undefined;
    private _auditObjectAccess?;
    get auditObjectAccess(): string;
    set auditObjectAccess(value: string);
    resetAuditObjectAccess(): void;
    get auditObjectAccessInput(): string | undefined;
    private _auditPolicyChange?;
    get auditPolicyChange(): string;
    set auditPolicyChange(value: string);
    resetAuditPolicyChange(): void;
    get auditPolicyChangeInput(): string | undefined;
    private _auditPrivilegeUse?;
    get auditPrivilegeUse(): string;
    set auditPrivilegeUse(value: string);
    resetAuditPrivilegeUse(): void;
    get auditPrivilegeUseInput(): string | undefined;
    private _auditProcessTracking?;
    get auditProcessTracking(): string;
    set auditProcessTracking(value: string);
    resetAuditProcessTracking(): void;
    get auditProcessTrackingInput(): string | undefined;
    private _auditSystemEvents?;
    get auditSystemEvents(): string;
    set auditSystemEvents(value: string);
    resetAuditSystemEvents(): void;
    get auditSystemEventsInput(): string | undefined;
}
export interface GpoSecurityFilesystem {
    /**
    * Security descriptor to apply. (https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-dtyp/f4296d69-1c0f-491f-9587-a960b292d070)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#acl GpoSecurity#acl}
    */
    readonly acl: string;
    /**
    * Path of the file or directory.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#path GpoSecurity#path}
    */
    readonly path: string;
    /**
    * Control permission propagation. 0: Propagate permissions to all subfolders and files, 1: Replace existing permissions on all subfolders and files, 2: Do not allow permissions to be replaced.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#propagation_mode GpoSecurity#propagation_mode}
    */
    readonly propagationMode: string;
}
export declare function gpoSecurityFilesystemToTerraform(struct?: GpoSecurityFilesystem | cdktf.IResolvable): any;
export declare class GpoSecurityFilesystemOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GpoSecurityFilesystem | cdktf.IResolvable | undefined;
    set internalValue(value: GpoSecurityFilesystem | cdktf.IResolvable | undefined);
    private _acl?;
    get acl(): string;
    set acl(value: string);
    get aclInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _propagationMode?;
    get propagationMode(): string;
    set propagationMode(value: string);
    get propagationModeInput(): string | undefined;
}
export declare class GpoSecurityFilesystemList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GpoSecurityFilesystem[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GpoSecurityFilesystemOutputReference;
}
export interface GpoSecurityKerberosPolicy {
    /**
    * Maximum time difference, in minutes, between the client clock and the server clock. (0-99999).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#max_clock_skew GpoSecurity#max_clock_skew}
    */
    readonly maxClockSkew?: string;
    /**
    * Number of days during which a ticket-granting ticket can be renewed (0-99999).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#max_renew_age GpoSecurity#max_renew_age}
    */
    readonly maxRenewAge?: string;
    /**
    * Maximum amount of minutes a ticket must be valid to access a service or resource. Minimum should be 10 and maximum should be equal to `max_ticket_age`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#max_service_age GpoSecurity#max_service_age}
    */
    readonly maxServiceAge?: string;
    /**
    * Maximum amount of hours a ticket-granting ticket is valid (0-99999).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#max_ticket_age GpoSecurity#max_ticket_age}
    */
    readonly maxTicketAge?: string;
    /**
    * Control if the session ticket is validated for every request. A non-zero value disables the policy.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#ticket_validate_client GpoSecurity#ticket_validate_client}
    */
    readonly ticketValidateClient?: string;
}
export declare function gpoSecurityKerberosPolicyToTerraform(struct?: GpoSecurityKerberosPolicyOutputReference | GpoSecurityKerberosPolicy): any;
export declare class GpoSecurityKerberosPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GpoSecurityKerberosPolicy | undefined;
    set internalValue(value: GpoSecurityKerberosPolicy | undefined);
    private _maxClockSkew?;
    get maxClockSkew(): string;
    set maxClockSkew(value: string);
    resetMaxClockSkew(): void;
    get maxClockSkewInput(): string | undefined;
    private _maxRenewAge?;
    get maxRenewAge(): string;
    set maxRenewAge(value: string);
    resetMaxRenewAge(): void;
    get maxRenewAgeInput(): string | undefined;
    private _maxServiceAge?;
    get maxServiceAge(): string;
    set maxServiceAge(value: string);
    resetMaxServiceAge(): void;
    get maxServiceAgeInput(): string | undefined;
    private _maxTicketAge?;
    get maxTicketAge(): string;
    set maxTicketAge(value: string);
    resetMaxTicketAge(): void;
    get maxTicketAgeInput(): string | undefined;
    private _ticketValidateClient?;
    get ticketValidateClient(): string;
    set ticketValidateClient(value: string);
    resetTicketValidateClient(): void;
    get ticketValidateClientInput(): string | undefined;
}
export interface GpoSecurityPasswordPolicies {
    /**
    * Store password with reversible encryption (0-2^16). The password will not be stored with reversible encryption if the value is set to 0. Reversible encryption will be used in any other case.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#clear_text_password GpoSecurity#clear_text_password}
    */
    readonly clearTextPassword?: string;
    /**
    * Number of days before password expires (-1-999). If set to -1, it means the password never expires.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#maximum_password_age GpoSecurity#maximum_password_age}
    */
    readonly maximumPasswordAge?: string;
    /**
    * Number of days a password must be used before changing it (0-999).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#minimum_password_age GpoSecurity#minimum_password_age}
    */
    readonly minimumPasswordAge?: string;
    /**
    * Minimum number of characters used in a password (0-2^16). If set to 0, it means no password is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#minimum_password_length GpoSecurity#minimum_password_length}
    */
    readonly minimumPasswordLength?: string;
    /**
    * Password must meet complexity requirements (0-2^16). If set to 0, then requirements do not apply, any other value means requirements are applied
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#password_complexity GpoSecurity#password_complexity}
    */
    readonly passwordComplexity?: string;
    /**
    * The number of unique new passwords that are required before an old password can be reused in association with a user account (0-2^16).  A value of 0 indicates that the password history is disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#password_history_size GpoSecurity#password_history_size}
    */
    readonly passwordHistorySize?: string;
}
export declare function gpoSecurityPasswordPoliciesToTerraform(struct?: GpoSecurityPasswordPoliciesOutputReference | GpoSecurityPasswordPolicies): any;
export declare class GpoSecurityPasswordPoliciesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GpoSecurityPasswordPolicies | undefined;
    set internalValue(value: GpoSecurityPasswordPolicies | undefined);
    private _clearTextPassword?;
    get clearTextPassword(): string;
    set clearTextPassword(value: string);
    resetClearTextPassword(): void;
    get clearTextPasswordInput(): string | undefined;
    private _maximumPasswordAge?;
    get maximumPasswordAge(): string;
    set maximumPasswordAge(value: string);
    resetMaximumPasswordAge(): void;
    get maximumPasswordAgeInput(): string | undefined;
    private _minimumPasswordAge?;
    get minimumPasswordAge(): string;
    set minimumPasswordAge(value: string);
    resetMinimumPasswordAge(): void;
    get minimumPasswordAgeInput(): string | undefined;
    private _minimumPasswordLength?;
    get minimumPasswordLength(): string;
    set minimumPasswordLength(value: string);
    resetMinimumPasswordLength(): void;
    get minimumPasswordLengthInput(): string | undefined;
    private _passwordComplexity?;
    get passwordComplexity(): string;
    set passwordComplexity(value: string);
    resetPasswordComplexity(): void;
    get passwordComplexityInput(): string | undefined;
    private _passwordHistorySize?;
    get passwordHistorySize(): string;
    set passwordHistorySize(value: string);
    resetPasswordHistorySize(): void;
    get passwordHistorySizeInput(): string | undefined;
}
export interface GpoSecurityRegistryKeys {
    /**
    * Security descriptor to apply. (https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-dtyp/f4296d69-1c0f-491f-9587-a960b292d070)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#acl GpoSecurity#acl}
    */
    readonly acl: string;
    /**
    * Fully qualified name of the key (https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-rrp/97587de7-3524-4291-8527-3951711      0c0eb)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#key_name GpoSecurity#key_name}
    */
    readonly keyName: string;
    /**
    * Control permission propagation. 0: Propagate permissions to all subkeys, 1: Replace existing permissions on all subkeys, 2: Do not allow permissions to be replaced on the key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#propagation_mode GpoSecurity#propagation_mode}
    */
    readonly propagationMode: string;
}
export declare function gpoSecurityRegistryKeysToTerraform(struct?: GpoSecurityRegistryKeys | cdktf.IResolvable): any;
export declare class GpoSecurityRegistryKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GpoSecurityRegistryKeys | cdktf.IResolvable | undefined;
    set internalValue(value: GpoSecurityRegistryKeys | cdktf.IResolvable | undefined);
    private _acl?;
    get acl(): string;
    set acl(value: string);
    get aclInput(): string | undefined;
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    get keyNameInput(): string | undefined;
    private _propagationMode?;
    get propagationMode(): string;
    set propagationMode(value: string);
    get propagationModeInput(): string | undefined;
}
export declare class GpoSecurityRegistryKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GpoSecurityRegistryKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GpoSecurityRegistryKeysOutputReference;
}
export interface GpoSecurityRegistryValues {
    /**
    * Fully qualified name of the key (https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-rrp/97587de7-3524-4291-8527-39517110c0eb)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#key_name GpoSecurity#key_name}
    */
    readonly keyName: string;
    /**
    * The value of the key, matching the type set in `value_type`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#value GpoSecurity#value}
    */
    readonly value: string;
    /**
    * Data type of the key's value. 1: String, 2: Expand String, 3: Binary, 4: DWORD, 5: MULTI_SZ.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#value_type GpoSecurity#value_type}
    */
    readonly valueType: string;
}
export declare function gpoSecurityRegistryValuesToTerraform(struct?: GpoSecurityRegistryValues | cdktf.IResolvable): any;
export declare class GpoSecurityRegistryValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GpoSecurityRegistryValues | cdktf.IResolvable | undefined;
    set internalValue(value: GpoSecurityRegistryValues | cdktf.IResolvable | undefined);
    private _keyName?;
    get keyName(): string;
    set keyName(value: string);
    get keyNameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    get valueTypeInput(): string | undefined;
}
export declare class GpoSecurityRegistryValuesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GpoSecurityRegistryValues[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GpoSecurityRegistryValuesOutputReference;
}
export interface GpoSecurityRestrictedGroups {
    /**
    * Comma separated list of group names or SIDs that this group belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#group_memberof GpoSecurity#group_memberof}
    */
    readonly groupMemberof: string;
    /**
    * Comma separated list of group names or SIDs that are members of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#group_members GpoSecurity#group_members}
    */
    readonly groupMembers: string;
    /**
    * Name of the group we are managing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#group_name GpoSecurity#group_name}
    */
    readonly groupName: string;
}
export declare function gpoSecurityRestrictedGroupsToTerraform(struct?: GpoSecurityRestrictedGroups | cdktf.IResolvable): any;
export declare class GpoSecurityRestrictedGroupsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GpoSecurityRestrictedGroups | cdktf.IResolvable | undefined;
    set internalValue(value: GpoSecurityRestrictedGroups | cdktf.IResolvable | undefined);
    private _groupMemberof?;
    get groupMemberof(): string;
    set groupMemberof(value: string);
    get groupMemberofInput(): string | undefined;
    private _groupMembers?;
    get groupMembers(): string;
    set groupMembers(value: string);
    get groupMembersInput(): string | undefined;
    private _groupName?;
    get groupName(): string;
    set groupName(value: string);
    get groupNameInput(): string | undefined;
}
export declare class GpoSecurityRestrictedGroupsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GpoSecurityRestrictedGroups[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GpoSecurityRestrictedGroupsOutputReference;
}
export interface GpoSecuritySystemLog {
    /**
    * Control log retention. Values: 0: overwrite events as needed, 1: overwrite events as specified specified by `retention_days`, 2: never overwrite events.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#audit_log_retention_period GpoSecurity#audit_log_retention_period}
    */
    readonly auditLogRetentionPeriod?: string;
    /**
    * Maximum size of log in KiloBytes. (64-4194240)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#maximum_log_size GpoSecurity#maximum_log_size}
    */
    readonly maximumLogSize?: string;
    /**
    * Restrict access to logs for guest users. A non-zero value restricts access to guest users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#restrict_guest_access GpoSecurity#restrict_guest_access}
    */
    readonly restrictGuestAccess?: string;
    /**
    * Number of days before new events overwrite old events. (1-365)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#retention_days GpoSecurity#retention_days}
    */
    readonly retentionDays?: string;
}
export declare function gpoSecuritySystemLogToTerraform(struct?: GpoSecuritySystemLogOutputReference | GpoSecuritySystemLog): any;
export declare class GpoSecuritySystemLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GpoSecuritySystemLog | undefined;
    set internalValue(value: GpoSecuritySystemLog | undefined);
    private _auditLogRetentionPeriod?;
    get auditLogRetentionPeriod(): string;
    set auditLogRetentionPeriod(value: string);
    resetAuditLogRetentionPeriod(): void;
    get auditLogRetentionPeriodInput(): string | undefined;
    private _maximumLogSize?;
    get maximumLogSize(): string;
    set maximumLogSize(value: string);
    resetMaximumLogSize(): void;
    get maximumLogSizeInput(): string | undefined;
    private _restrictGuestAccess?;
    get restrictGuestAccess(): string;
    set restrictGuestAccess(value: string);
    resetRestrictGuestAccess(): void;
    get restrictGuestAccessInput(): string | undefined;
    private _retentionDays?;
    get retentionDays(): string;
    set retentionDays(value: string);
    resetRetentionDays(): void;
    get retentionDaysInput(): string | undefined;
}
export interface GpoSecuritySystemServices {
    /**
    * Security descriptor to apply. (https://docs.microsoft.com/en-us/openspecs/windows_protocols/ms-dtyp/f4296d69-1c0f-491f-9587-a960b292d070)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#acl GpoSecurity#acl}
    */
    readonly acl: string;
    /**
    * Name of the service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#service_name GpoSecurity#service_name}
    */
    readonly serviceName: string;
    /**
    * Startup mode of the service. Possible values are 2: Automatic, 3: Manual, 4: Disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/gpo_security#startup_mode GpoSecurity#startup_mode}
    */
    readonly startupMode: string;
}
export declare function gpoSecuritySystemServicesToTerraform(struct?: GpoSecuritySystemServices | cdktf.IResolvable): any;
export declare class GpoSecuritySystemServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GpoSecuritySystemServices | cdktf.IResolvable | undefined;
    set internalValue(value: GpoSecuritySystemServices | cdktf.IResolvable | undefined);
    private _acl?;
    get acl(): string;
    set acl(value: string);
    get aclInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    private _startupMode?;
    get startupMode(): string;
    set startupMode(value: string);
    get startupModeInput(): string | undefined;
}
export declare class GpoSecuritySystemServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GpoSecuritySystemServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GpoSecuritySystemServicesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/r/gpo_security ad_gpo_security}
*/
export declare class GpoSecurity extends cdktf.TerraformResource {
    static readonly tfResourceType = "ad_gpo_security";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/r/gpo_security ad_gpo_security} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GpoSecurityConfig
    */
    constructor(scope: Construct, id: string, config: GpoSecurityConfig);
    private _gpoContainer?;
    get gpoContainer(): string;
    set gpoContainer(value: string);
    get gpoContainerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _accountLockout;
    get accountLockout(): GpoSecurityAccountLockoutOutputReference;
    putAccountLockout(value: GpoSecurityAccountLockout): void;
    resetAccountLockout(): void;
    get accountLockoutInput(): GpoSecurityAccountLockout | undefined;
    private _applicationLog;
    get applicationLog(): GpoSecurityApplicationLogOutputReference;
    putApplicationLog(value: GpoSecurityApplicationLog): void;
    resetApplicationLog(): void;
    get applicationLogInput(): GpoSecurityApplicationLog | undefined;
    private _auditLog;
    get auditLog(): GpoSecurityAuditLogOutputReference;
    putAuditLog(value: GpoSecurityAuditLog): void;
    resetAuditLog(): void;
    get auditLogInput(): GpoSecurityAuditLog | undefined;
    private _eventAudit;
    get eventAudit(): GpoSecurityEventAuditOutputReference;
    putEventAudit(value: GpoSecurityEventAudit): void;
    resetEventAudit(): void;
    get eventAuditInput(): GpoSecurityEventAudit | undefined;
    private _filesystem;
    get filesystem(): GpoSecurityFilesystemList;
    putFilesystem(value: GpoSecurityFilesystem[] | cdktf.IResolvable): void;
    resetFilesystem(): void;
    get filesystemInput(): cdktf.IResolvable | GpoSecurityFilesystem[] | undefined;
    private _kerberosPolicy;
    get kerberosPolicy(): GpoSecurityKerberosPolicyOutputReference;
    putKerberosPolicy(value: GpoSecurityKerberosPolicy): void;
    resetKerberosPolicy(): void;
    get kerberosPolicyInput(): GpoSecurityKerberosPolicy | undefined;
    private _passwordPolicies;
    get passwordPolicies(): GpoSecurityPasswordPoliciesOutputReference;
    putPasswordPolicies(value: GpoSecurityPasswordPolicies): void;
    resetPasswordPolicies(): void;
    get passwordPoliciesInput(): GpoSecurityPasswordPolicies | undefined;
    private _registryKeys;
    get registryKeys(): GpoSecurityRegistryKeysList;
    putRegistryKeys(value: GpoSecurityRegistryKeys[] | cdktf.IResolvable): void;
    resetRegistryKeys(): void;
    get registryKeysInput(): cdktf.IResolvable | GpoSecurityRegistryKeys[] | undefined;
    private _registryValues;
    get registryValues(): GpoSecurityRegistryValuesList;
    putRegistryValues(value: GpoSecurityRegistryValues[] | cdktf.IResolvable): void;
    resetRegistryValues(): void;
    get registryValuesInput(): cdktf.IResolvable | GpoSecurityRegistryValues[] | undefined;
    private _restrictedGroups;
    get restrictedGroups(): GpoSecurityRestrictedGroupsList;
    putRestrictedGroups(value: GpoSecurityRestrictedGroups[] | cdktf.IResolvable): void;
    resetRestrictedGroups(): void;
    get restrictedGroupsInput(): cdktf.IResolvable | GpoSecurityRestrictedGroups[] | undefined;
    private _systemLog;
    get systemLog(): GpoSecuritySystemLogOutputReference;
    putSystemLog(value: GpoSecuritySystemLog): void;
    resetSystemLog(): void;
    get systemLogInput(): GpoSecuritySystemLog | undefined;
    private _systemServices;
    get systemServices(): GpoSecuritySystemServicesList;
    putSystemServices(value: GpoSecuritySystemServices[] | cdktf.IResolvable): void;
    resetSystemServices(): void;
    get systemServicesInput(): cdktf.IResolvable | GpoSecuritySystemServices[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
