import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupMembershipConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of the group. This can be a GUID, a SID, a Distinguished Name, or the SAM Account Name of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group_membership#group_id GroupMembership#group_id}
    */
    readonly groupId: string;
    /**
    * A list of member AD Principals. Each principal can be identified by its GUID, SID, Distinguished Name, or SAM Account Name. Only one is required
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group_membership#group_members GroupMembership#group_members}
    */
    readonly groupMembers: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group_membership#id GroupMembership#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/r/group_membership ad_group_membership}
*/
export declare class GroupMembership extends cdktf.TerraformResource {
    static readonly tfResourceType = "ad_group_membership";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/r/group_membership ad_group_membership} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupMembershipConfig
    */
    constructor(scope: Construct, id: string, config: GroupMembershipConfig);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    get groupIdInput(): string | undefined;
    private _groupMembers?;
    get groupMembers(): string[];
    set groupMembers(value: string[]);
    get groupMembersInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
