import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * The group's category. Can be one of `distribution` or `security` (case sensitive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group#category Group#category}
    */
    readonly category?: string;
    /**
    * A DN of a container object holding the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group#container Group#container}
    */
    readonly container: string;
    /**
    * Description of the Group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group#description Group#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group#id Group#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group#name Group#name}
    */
    readonly name: string;
    /**
    * The pre-win2k name of the group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group#sam_account_name Group#sam_account_name}
    */
    readonly samAccountName: string;
    /**
    * The group's scope. Can be one of `global`, `domainlocal`, or `universal` (case sensitive).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/group#scope Group#scope}
    */
    readonly scope?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/r/group ad_group}
*/
export declare class Group extends cdktf.TerraformResource {
    static readonly tfResourceType = "ad_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/r/group ad_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupConfig
    */
    constructor(scope: Construct, id: string, config: GroupConfig);
    private _category?;
    get category(): string;
    set category(value: string);
    resetCategory(): void;
    get categoryInput(): string | undefined;
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get dn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _samAccountName?;
    get samAccountName(): string;
    set samAccountName(value: string);
    get samAccountNameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    get sid(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
