import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * If set to true, the user will not be allowed to change their password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#cannot_change_password User#cannot_change_password}
    */
    readonly cannotChangePassword?: boolean | cdktf.IResolvable;
    /**
    * Specifies the user's town or city. This parameter sets the City property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#city User#city}
    */
    readonly city?: string;
    /**
    * Specifies the user's company. This parameter sets the Company property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#company User#company}
    */
    readonly company?: string;
    /**
    * A DN of the container object that will be holding the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#container User#container}
    */
    readonly container?: string;
    /**
    * Specifies the country by setting the country code (refer to ISO 3166)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#country User#country}
    */
    readonly country?: string;
    /**
    * JSON encoded map that represents key/value pairs for custom attributes. Please note that `terraform import` will not import these attributes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#custom_attributes User#custom_attributes}
    */
    readonly customAttributes?: string;
    /**
    * Specifies the user's department. This parameter sets the Department property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#department User#department}
    */
    readonly department?: string;
    /**
    * Specifies a description of the object. This parameter sets the value of the Description property for the user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#description User#description}
    */
    readonly description?: string;
    /**
    * The Display Name of an Active Directory user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#display_name User#display_name}
    */
    readonly displayName: string;
    /**
    * Specifies the user's division. This parameter sets the Division property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#division User#division}
    */
    readonly division?: string;
    /**
    * Specifies the user's e-mail address. This parameter sets the EmailAddress property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#email_address User#email_address}
    */
    readonly emailAddress?: string;
    /**
    * Specifies the user's employee ID. This parameter sets the EmployeeID property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#employee_id User#employee_id}
    */
    readonly employeeId?: string;
    /**
    * Specifies the user's employee number. This parameter sets the EmployeeNumber property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#employee_number User#employee_number}
    */
    readonly employeeNumber?: string;
    /**
    * If set to false, the user will be disabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#enabled User#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Specifies the user's fax phone number. This parameter sets the Fax property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#fax User#fax}
    */
    readonly fax?: string;
    /**
    * Specifies the user's given name. This parameter sets the GivenName property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#given_name User#given_name}
    */
    readonly givenName?: string;
    /**
    * Specifies a user's home directory. This parameter sets the HomeDirectory property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#home_directory User#home_directory}
    */
    readonly homeDirectory?: string;
    /**
    * Specifies a drive that is associated with the UNC path defined by the HomeDirectory property. The drive letter is specified as <DriveLetter>: where <DriveLetter> indicates the letter of the drive to associate. The <DriveLetter> must be a single, uppercase letter and the colon is required. This parameter sets the HomeDrive property of the user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#home_drive User#home_drive}
    */
    readonly homeDrive?: string;
    /**
    * Specifies the URL of the home page of the object. This parameter sets the homePage property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#home_page User#home_page}
    */
    readonly homePage?: string;
    /**
    * Specifies the user's home telephone number. This parameter sets the HomePhone property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#home_phone User#home_phone}
    */
    readonly homePhone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#id User#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The user's initial password. This will be set on creation but will *not* be enforced in subsequent plans.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#initial_password User#initial_password}
    */
    readonly initialPassword?: string;
    /**
    * Specifies the initials that represent part of a user's name. Maximum 6 char.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#initials User#initials}
    */
    readonly initials?: string;
    /**
    * Specifies the user's mobile phone number. This parameter sets the MobilePhone property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#mobile_phone User#mobile_phone}
    */
    readonly mobilePhone?: string;
    /**
    * Specifies the location of the user's office or place of business. This parameter sets the Office property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#office User#office}
    */
    readonly office?: string;
    /**
    * Specifies the user's office telephone number. This parameter sets the OfficePhone property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#office_phone User#office_phone}
    */
    readonly officePhone?: string;
    /**
    * Specifies the user's organization. This parameter sets the Organization property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#organization User#organization}
    */
    readonly organization?: string;
    /**
    * Specifies a name in addition to a user's given name and surname, such as the user's middle name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#other_name User#other_name}
    */
    readonly otherName?: string;
    /**
    * If set to true, the password for this user will not expire.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#password_never_expires User#password_never_expires}
    */
    readonly passwordNeverExpires?: boolean | cdktf.IResolvable;
    /**
    * Specifies the user's post office box number. This parameter sets the POBox property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#po_box User#po_box}
    */
    readonly poBox?: string;
    /**
    * Specifies the user's postal code or zip code. This parameter sets the PostalCode property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#postal_code User#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The Principal Name of an Active Directory user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#principal_name User#principal_name}
    */
    readonly principalName: string;
    /**
    * The pre-win2k user logon name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#sam_account_name User#sam_account_name}
    */
    readonly samAccountName: string;
    /**
    * If set to true, a smart card is required to logon. This parameter sets the SmartCardLoginRequired property for a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#smart_card_logon_required User#smart_card_logon_required}
    */
    readonly smartCardLogonRequired?: boolean | cdktf.IResolvable;
    /**
    * Specifies the user's or Organizational Unit's state or province. This parameter sets the State property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#state User#state}
    */
    readonly state?: string;
    /**
    * Specifies the user's street address. This parameter sets the StreetAddress property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#street_address User#street_address}
    */
    readonly streetAddress?: string;
    /**
    * Specifies the user's last name or surname. This parameter sets the Surname property of a user object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#surname User#surname}
    */
    readonly surname?: string;
    /**
    * Specifies the user's title. This parameter sets the Title property of a user object
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#title User#title}
    */
    readonly title?: string;
    /**
    * If set to true, the user account is trusted for Kerberos delegation. A service that runs under an account that is trusted for Kerberos delegation can assume the identity of a client requesting the service. This parameter sets the TrustedForDelegation property of an account object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ad/r/user#trusted_for_delegation User#trusted_for_delegation}
    */
    readonly trustedForDelegation?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ad/r/user ad_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "ad_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ad/r/user ad_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _cannotChangePassword?;
    get cannotChangePassword(): boolean | cdktf.IResolvable;
    set cannotChangePassword(value: boolean | cdktf.IResolvable);
    resetCannotChangePassword(): void;
    get cannotChangePasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _city?;
    get city(): string;
    set city(value: string);
    resetCity(): void;
    get cityInput(): string | undefined;
    private _company?;
    get company(): string;
    set company(value: string);
    resetCompany(): void;
    get companyInput(): string | undefined;
    private _container?;
    get container(): string;
    set container(value: string);
    resetContainer(): void;
    get containerInput(): string | undefined;
    private _country?;
    get country(): string;
    set country(value: string);
    resetCountry(): void;
    get countryInput(): string | undefined;
    private _customAttributes?;
    get customAttributes(): string;
    set customAttributes(value: string);
    resetCustomAttributes(): void;
    get customAttributesInput(): string | undefined;
    private _department?;
    get department(): string;
    set department(value: string);
    resetDepartment(): void;
    get departmentInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _division?;
    get division(): string;
    set division(value: string);
    resetDivision(): void;
    get divisionInput(): string | undefined;
    get dn(): string;
    private _emailAddress?;
    get emailAddress(): string;
    set emailAddress(value: string);
    resetEmailAddress(): void;
    get emailAddressInput(): string | undefined;
    private _employeeId?;
    get employeeId(): string;
    set employeeId(value: string);
    resetEmployeeId(): void;
    get employeeIdInput(): string | undefined;
    private _employeeNumber?;
    get employeeNumber(): string;
    set employeeNumber(value: string);
    resetEmployeeNumber(): void;
    get employeeNumberInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _fax?;
    get fax(): string;
    set fax(value: string);
    resetFax(): void;
    get faxInput(): string | undefined;
    private _givenName?;
    get givenName(): string;
    set givenName(value: string);
    resetGivenName(): void;
    get givenNameInput(): string | undefined;
    private _homeDirectory?;
    get homeDirectory(): string;
    set homeDirectory(value: string);
    resetHomeDirectory(): void;
    get homeDirectoryInput(): string | undefined;
    private _homeDrive?;
    get homeDrive(): string;
    set homeDrive(value: string);
    resetHomeDrive(): void;
    get homeDriveInput(): string | undefined;
    private _homePage?;
    get homePage(): string;
    set homePage(value: string);
    resetHomePage(): void;
    get homePageInput(): string | undefined;
    private _homePhone?;
    get homePhone(): string;
    set homePhone(value: string);
    resetHomePhone(): void;
    get homePhoneInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialPassword?;
    get initialPassword(): string;
    set initialPassword(value: string);
    resetInitialPassword(): void;
    get initialPasswordInput(): string | undefined;
    private _initials?;
    get initials(): string;
    set initials(value: string);
    resetInitials(): void;
    get initialsInput(): string | undefined;
    private _mobilePhone?;
    get mobilePhone(): string;
    set mobilePhone(value: string);
    resetMobilePhone(): void;
    get mobilePhoneInput(): string | undefined;
    private _office?;
    get office(): string;
    set office(value: string);
    resetOffice(): void;
    get officeInput(): string | undefined;
    private _officePhone?;
    get officePhone(): string;
    set officePhone(value: string);
    resetOfficePhone(): void;
    get officePhoneInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    resetOrganization(): void;
    get organizationInput(): string | undefined;
    private _otherName?;
    get otherName(): string;
    set otherName(value: string);
    resetOtherName(): void;
    get otherNameInput(): string | undefined;
    private _passwordNeverExpires?;
    get passwordNeverExpires(): boolean | cdktf.IResolvable;
    set passwordNeverExpires(value: boolean | cdktf.IResolvable);
    resetPasswordNeverExpires(): void;
    get passwordNeverExpiresInput(): boolean | cdktf.IResolvable | undefined;
    private _poBox?;
    get poBox(): string;
    set poBox(value: string);
    resetPoBox(): void;
    get poBoxInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _principalName?;
    get principalName(): string;
    set principalName(value: string);
    get principalNameInput(): string | undefined;
    private _samAccountName?;
    get samAccountName(): string;
    set samAccountName(value: string);
    get samAccountNameInput(): string | undefined;
    get sid(): string;
    private _smartCardLogonRequired?;
    get smartCardLogonRequired(): boolean | cdktf.IResolvable;
    set smartCardLogonRequired(value: boolean | cdktf.IResolvable);
    resetSmartCardLogonRequired(): void;
    get smartCardLogonRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
    private _surname?;
    get surname(): string;
    set surname(value: string);
    resetSurname(): void;
    get surnameInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _trustedForDelegation?;
    get trustedForDelegation(): boolean | cdktf.IResolvable;
    set trustedForDelegation(value: boolean | cdktf.IResolvable);
    resetTrustedForDelegation(): void;
    get trustedForDelegationInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
