"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LightTheme = exports.LightPalette = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const palette_1 = require("./palette");
/** Light theme color palette */
var LightPalette;
(function (LightPalette) {
    LightPalette["PUBLIC"] = "#E9F3E6";
    LightPalette["PRIVATE"] = "#E6F2F8";
    LightPalette["GENERIC"] = "#5A6B861A";
    LightPalette["PRIMARY"] = "#232F3E";
    LightPalette["SECONDARY"] = "#5B9BD5";
    LightPalette["TERTIARY"] = "#5A6B86";
})(LightPalette || (exports.LightPalette = LightPalette = {}));
/** Light theme definition */
exports.LightTheme = {
    id: "light",
    backgrounds: {
        base: palette_1.BasePalette.WHITE,
        private: LightPalette.PRIVATE,
        public: LightPalette.PUBLIC,
        generic: LightPalette.GENERIC,
    },
    text: {
        default: palette_1.BasePalette.BLACK,
        primary: LightPalette.PRIMARY,
        secondary: LightPalette.SECONDARY,
        tertiary: LightPalette.TERTIARY,
    },
    groups: {
        cloud: {
            color: "#242F3E",
            bgcolor: false,
            borderColor: "#242F3E",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSCloud.png",
        },
        cloudAlt: {
            color: "#242F3E",
            bgcolor: false,
            borderColor: "#242F3E",
            borderStyle: "solid",
            iconPng: "theme/light/groups/Cloud.png",
        },
        region: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "dotted",
            iconPng: "theme/light/groups/Region.png",
        },
        availabilityZone: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "dashed",
        },
        securityGroup: {
            color: "#DF3312",
            bgcolor: false,
            borderColor: "#DF3312",
            borderStyle: "solid",
        },
        autoScalingGroup: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "dashed",
            iconPng: "theme/light/groups/AutoScalingGroup.png",
        },
        vpc: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/VPC.png",
        },
        privateSubnet: {
            color: "#127EBA",
            bgcolor: false,
            borderColor: "#127EBA",
            borderStyle: "none",
            iconPng: "theme/light/groups/PrivateSubnet.png",
        },
        publicSubnet: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "none",
            iconPng: "theme/light/groups/PublicSubnet.png",
        },
        serverContents: {
            color: "#596B85",
            bgcolor: false,
            borderColor: "#596B85",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ServerContents.png",
        },
        corporateDataCenter: {
            color: "#596B85",
            bgcolor: false,
            borderColor: "#596B85",
            borderStyle: "solid",
            iconPng: "theme/light/groups/CorporateDataCenter.png",
        },
        ec2InstanceContents: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/EC2InstanceContents.png",
        },
        spotFleet: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/SpotFleet.png",
        },
        awsAccount: {
            color: "#B0084D",
            bgcolor: false,
            borderColor: "#B0084D",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSAccount.png",
        },
        awsIoTGreengrassDeployment: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrassDeployment.png",
        },
        awsIoTGreengrass: {
            color: "#3F8624",
            bgcolor: false,
            borderColor: "#3F8624",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSIoTGreengrass.png",
        },
        elasticBeanstalkContainer: {
            color: "#D86613",
            bgcolor: false,
            borderColor: "#D86613",
            borderStyle: "solid",
            iconPng: "theme/light/groups/ElasticBeanstalkContainer.png",
        },
        awsStepFunctionsWorkflow: {
            color: "#CD2264",
            bgcolor: false,
            borderColor: "#CD2264",
            borderStyle: "solid",
            iconPng: "theme/light/groups/AWSStepFunctionsWorkflow.png",
        },
        generic: {
            color: "#5A6B86",
            bgcolor: false,
            borderColor: "#5A6B86",
            borderStyle: "dashed",
        },
        genericAlt: {
            color: "#000000CC",
            bgcolor: "#5A6B861A",
            borderColor: false,
            borderStyle: "none",
        },
    },
    arrows: {
        default: {
            color: LightPalette.GENERIC,
            head: "none",
            tail: "normal",
            width: 0.75,
            style: "solid",
        },
        child: {
            color: LightPalette.TERTIARY,
            tail: "none",
            head: "normal",
            width: 1,
            style: "solid",
        },
        reference: {
            color: LightPalette.TERTIARY,
            tail: "none",
            head: "normal",
            width: 0.75,
            style: "solid",
        },
        dependency: {
            color: LightPalette.SECONDARY,
            tail: "normal",
            head: "odot",
            width: 0.75,
            style: "dotted",
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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