/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
/**
 * Normalize string value to standard identifier form.
 *
 * Removes extraneous prefixes (Amazon, AWS), replaces all non-alphanumerics with underscore (_),
 * and converts to lower-case.
 * @param value - Value to normalize
 * @returns Returns normalized identifier string.
 */
export declare function normalizeIdentifier(value: string): string;
/**
 * Normalizes string value for consistent comparison with variants between systems.
 * @param value - The value to normalize for comparison
 */
export declare function normalizeComparisonString(value: string): string;
/**
 * RegEx pattern for https://aws.amazon.com based urls.
 */
export declare const AWS_URL_PATTERN: RegExp;
/**
 * Parsed Aws Url based on {@link AWS_URL_PATTERN}
 */
export interface ParsedAwsUrl {
    readonly domain: string;
    readonly service: string;
    readonly resource?: string;
    readonly dataType?: string;
    /**
     * @virtual
     */
    readonly code: string;
}
/** Parses https://aws.amazon.com based url into common definition. */
export declare function parseAwsUrl(url: string): ParsedAwsUrl;
