#!/usr/bin/env ts-node
import { Image } from "./types";
/**
 * Resolve image path to [dot-wasm](https://hpcc-systems.github.io/hpcc-js-wasm/classes/graphviz.Graphviz.html) image
 * struct which requires width and height dimensions.
 */
export declare function resolveDotWasmImage(relativePath: string): Promise<Image>;
/**
 * Resolve [dot-wasm](https://hpcc-systems.github.io/hpcc-js-wasm/classes/graphviz.Graphviz.html) generated svg.
 *
 * **dot-wasm** (as well as Graphviz) generate non-desirable svg state which this function resolves:
 * 1. Unescape/Decode all html entities (eg: `&#45;` => `-`)
 * 2. Reconcile the `viewBox` size to match graph content
 * 3. Remove width and height from root svg, to ensure pure viewBox is utilized without side effects
 * 4. Resolve font **config** values to proper html/svg font-family and styles
 * 5. Inline all svg images via definitions
 */
export declare function resolveSvg(svgString: string): Promise<string>;
