"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterStrategy = exports.FilterPreset = void 0;
/** Filter presets */
var FilterPreset;
(function (FilterPreset) {
    /**
     * Collapses extraneous nodes to parent and cdk created nodes on themselves,
     * and prunes extraneous edges.
     *
     * This most closely represents the developers code for the current application
     * and reduces the noise one expects.
     */
    FilterPreset["COMPACT"] = "compact";
    /**
     * Collapses extraneous nodes to parent and prunes extraneous edges.
     */
    FilterPreset["NON_EXTRANEOUS"] = "non-extraneous";
    /**
     * No filtering is performed which will output **verbose** graph.
     */
    FilterPreset["NONE"] = "none";
})(FilterPreset || (exports.FilterPreset = FilterPreset = {}));
/**
 * Filter strategy to apply to filter matches.
 */
var FilterStrategy;
(function (FilterStrategy) {
    /** Remove filtered entity and all its edges */
    FilterStrategy["PRUNE"] = "prune";
    /** Collapse all child entities of filtered entity into filtered entity; and hoist all edges. */
    FilterStrategy["COLLAPSE"] = "collapse";
    /** Collapse all filtered entities into their parent entity; and hoist its edges to parent. */
    FilterStrategy["COLLAPSE_TO_PARENT"] = "collapse_to_parent";
})(FilterStrategy || (exports.FilterStrategy = FilterStrategy = {}));
//# sourceMappingURL=data:application/json;base64,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