"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
const userpool_with_mfa_1 = require("./userpool-with-mfa");
const WEB_CLIENT_ID = "WebClient";
/**
 * Creates a UserPool and Identity Pool with sane defaults configured intended for usage from a web client.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        this.userPool = !props?.userPool
            ? new userpool_with_mfa_1.UserPoolWithMfa(this, "UserPool")
            : props.userPool;
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", props?.identityPoolOptions);
        const existingClient = this.userPool.node.children.find((e) => e.node.id === WEB_CLIENT_ID && e instanceof aws_cognito_1.UserPoolClient);
        this.userPoolClient =
            existingClient ??
                this.userPool.addClient(WEB_CLIENT_ID, {
                    authFlows: {
                        userPassword: true,
                        userSrp: true,
                    },
                });
        this.identityPool.addUserPoolAuthentication(new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
        }));
        new aws_cdk_lib_1.CfnOutput(this, `${id}-UserPoolId`, {
            value: this.userPool.userPoolId,
        });
        new aws_cdk_lib_1.CfnOutput(this, `${id}-IdentityPoolId`, {
            value: this.identityPool.identityPoolId,
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws/pdk.identity.UserIdentity", version: "0.22.14" };
//# sourceMappingURL=data:application/json;base64,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