import { CloudscapeReactTsWebsiteProject } from "../../../cloudscape-react-ts-website";
import { TypeSafeApiProject } from "../../../type-safe-api";
import { AwsCdkJavaApp } from "projen/lib/awscdk";
import { AwsCdkJavaAppOptions } from "./aws-cdk-java-app-options";
/**
 * Configuration options for the InfrastructureJavaProject.
 */
export interface InfrastructureJavaProjectOptions extends AwsCdkJavaAppOptions {
    /**
     * TypeSafeApi instance to use when setting up the initial project sample code.
     */
    readonly typeSafeApi?: TypeSafeApiProject;
    /**
     * CloudscapeReactTsWebsiteProject instance to use when setting up the initial project sample code.
     */
    readonly cloudscapeReactTsWebsite?: CloudscapeReactTsWebsiteProject;
}
/**
 * Synthesizes a Infrastructure Typescript Project.
 */
export declare class InfrastructureJavaProject extends AwsCdkJavaApp {
    constructor(options: InfrastructureJavaProjectOptions);
    private emitSampleFiles;
}
