import { CloudscapeReactTsWebsiteProject } from "../../../cloudscape-react-ts-website";
import { TypeSafeApiProject } from "../../../type-safe-api";
import { AwsCdkPythonApp } from "projen/lib/awscdk";
import { AwsCdkPythonAppOptions } from "./aws-cdk-py-app-options";
/**
 * Configuration options for the InfrastructurePyProject.
 */
export interface InfrastructurePyProjectOptions extends AwsCdkPythonAppOptions {
    /**
     * TypeSafeApi instance to use when setting up the initial project sample code.
     */
    readonly typeSafeApi?: TypeSafeApiProject;
    /**
     * CloudscapeReactTsWebsiteProject instance to use when setting up the initial project sample code.
     */
    readonly cloudscapeReactTsWebsite?: CloudscapeReactTsWebsiteProject;
}
/**
 * Synthesizes a Infrastructure Python Project.
 */
export declare class InfrastructurePyProject extends AwsCdkPythonApp {
    constructor(options: InfrastructurePyProjectOptions);
    private emitSampleFiles;
}
