import { CloudscapeReactTsWebsiteProject } from "../../../cloudscape-react-ts-website";
import { TypeSafeApiProject } from "../../../type-safe-api";
import { AwsCdkTypeScriptApp } from "projen/lib/awscdk";
import { AwsCdkTypeScriptAppOptions } from "./aws-cdk-ts-app-options";
/**
 * Configuration options for the InfrastructureTsProject.
 */
export interface InfrastructureTsProjectOptions extends AwsCdkTypeScriptAppOptions {
    /**
     * TypeSafeApi instance to use when setting up the initial project sample code.
     */
    readonly typeSafeApi?: TypeSafeApiProject;
    /**
     * CloudscapeReactTsWebsiteProject instance to use when setting up the initial project sample code.
     */
    readonly cloudscapeReactTsWebsite?: CloudscapeReactTsWebsiteProject;
}
/**
 * Synthesizes a Infrastructure Typescript Project.
 */
export declare class InfrastructureTsProject extends AwsCdkTypeScriptApp {
    constructor(options: InfrastructureTsProjectOptions);
    private emitSampleFiles;
}
