"use strict";
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Nx = void 0;
var Nx;
(function (Nx) {
    /**
     * Supported enums for a TargetDependency.
     */
    let TargetDependencyProject;
    (function (TargetDependencyProject) {
        /**
         * Only rely on the package where the target is called.
         *
         * This is usually done for test like targets where you only want to run unit
         * tests on the target packages without testing all dependent packages.
         */
        TargetDependencyProject["SELF"] = "self";
        /**
         * Target relies on executing the target against all dependencies first.
         *
         * This is usually done for build like targets where you want to build all
         * dependant projects first.
         */
        TargetDependencyProject["DEPENDENCIES"] = "dependencies";
    })(TargetDependencyProject = Nx.TargetDependencyProject || (Nx.TargetDependencyProject = {}));
})(Nx || (exports.Nx = Nx = {}));
//# sourceMappingURL=data:application/json;base64,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